import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Internetmonitor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Creates a monitor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toCreateMonitor(): this;
    /**
     * Deletes a monitor
     *
     * Access Level: Write
     */
    toDeleteMonitor(): this;
    /**
     * Gets information about a health event for a specified monitor
     *
     * Access Level: Read
     */
    toGetHealthEvent(): this;
    /**
     * Gets information about a monitor
     *
     * Access Level: Read
     */
    toGetMonitor(): this;
    /**
     * Lists all health events for a monitor
     *
     * Access Level: List
     */
    toListHealthEvents(): this;
    /**
     * Lists all monitors in an account and their statuses
     *
     * Access Level: List
     */
    toListMonitors(): this;
    /**
     * Lists the tags for a resource
     *
     * Access Level: Read
     */
    toListTagsForResource(): this;
    /**
     * Adds a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toTagResource(): this;
    /**
     * Removes a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     */
    toUntagResource(): this;
    /**
     * Updates a monitor
     *
     * Access Level: Write
     */
    toUpdateMonitor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type HealthEvents to the statement
     *
     * @param monitorName - Identifier for the monitorName.
     * @param eventId - Identifier for the eventId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHealthEvents(monitorName: string, eventId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Monitor to the statement
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName: string, account?: string, region?: string, partition?: string): this;
}
