"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Securitylake = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Securitylake extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'securitylake';
        this.accessLevelList = {
            Write: [
                'CreateAwsLogSource',
                'CreateCustomLogSource',
                'CreateDatalake',
                'CreateDatalakeAutoEnable',
                'CreateDatalakeDelegatedAdmin',
                'CreateDatalakeExceptionsSubscription',
                'CreateSubscriber',
                'CreateSubscriptionNotificationConfiguration',
                'DeleteAwsLogSource',
                'DeleteCustomLogSource',
                'DeleteDatalake',
                'DeleteDatalakeAutoEnable',
                'DeleteDatalakeDelegatedAdmin',
                'DeleteDatalakeExceptionsSubscription',
                'DeleteSubscriber',
                'DeleteSubscriptionNotificationConfiguration',
                'UpdateDatalake',
                'UpdateDatalakeExceptionsExpiry',
                'UpdateDatalakeExceptionsSubscription',
                'UpdateSubscriber',
                'UpdateSubscriptionNotificationConfiguration'
            ],
            Read: [
                'GetDatalake',
                'GetDatalakeAutoEnable',
                'GetDatalakeExceptionsExpiry',
                'GetDatalakeExceptionsSubscription',
                'GetDatalakeStatus',
                'GetSubscriber',
                'GetSubscriptionNotificationConfiguration'
            ],
            List: [
                'ListDatalakeExceptions',
                'ListLogSources',
                'ListSubscribers'
            ]
        };
    }
    /**
     * Grants permission to enable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateAwsLogSource.html
     */
    toCreateAwsLogSource() {
        return this.to('CreateAwsLogSource');
    }
    /**
     * Grants permission to add a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateCrawler
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:StartCrawlerSchedule
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - lakeformation:GrantPermissions
     * - lakeformation:RegisterResource
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateCustomLogSource.html
     */
    toCreateCustomLogSource() {
        return this.to('CreateCustomLogSource');
    }
    /**
     * Grants permission to create a new Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalake.html
     */
    toCreateDatalake() {
        return this.to('CreateDatalake');
    }
    /**
     * Grants permission to add to the configuration for automatically enabling Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeAutoEnable.html
     */
    toCreateDatalakeAutoEnable() {
        return this.to('CreateDatalakeAutoEnable');
    }
    /**
     * Grants permission to designate the Amazon Security Lake administrator account for the organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeDelegatedAdmin.html
     */
    toCreateDatalakeDelegatedAdmin() {
        return this.to('CreateDatalakeDelegatedAdmin');
    }
    /**
     * Grants permission to get instant notifications about exceptions by subscribing to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeExceptionsSubscription.html
     */
    toCreateDatalakeExceptionsSubscription() {
        return this.to('CreateDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to create a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - lakeformation:GrantPermissions
     * - lakeformation:ListPermissions
     * - lakeformation:RegisterResource
     * - lakeformation:RevokePermissions
     * - ram:GetResourceShareAssociations
     * - ram:GetResourceShares
     * - ram:UpdateResourceShare
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriber.html
     */
    toCreateSubscriber() {
        return this.to('CreateSubscriber');
    }
    /**
     * Grants permission to create a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - s3:GetBucketNotification
     * - s3:PutBucketNotification
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriptionNotificationConfiguration.html
     */
    toCreateSubscriptionNotificationConfiguration() {
        return this.to('CreateSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to disable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteAwsLogSource.html
     */
    toDeleteAwsLogSource() {
        return this.to('DeleteAwsLogSource');
    }
    /**
     * Grants permission to remove a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:StopCrawlerSchedule
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteCustomLogSource.html
     */
    toDeleteCustomLogSource() {
        return this.to('DeleteCustomLogSource');
    }
    /**
     * Grants permission to delete all Security Data Lakes
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalake.html
     */
    toDeleteDatalake() {
        return this.to('DeleteDatalake');
    }
    /**
     * Grants permission to remove from the existing configuration the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeAutoEnable.html
     */
    toDeleteDatalakeAutoEnable() {
        return this.to('DeleteDatalakeAutoEnable');
    }
    /**
     * Grants permission to remove the Delegated Administrator account and disable Amazon Security Lake as a service for this organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DeregisterDelegatedAdministrator
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeDelegatedAdmin.html
     */
    toDeleteDatalakeDelegatedAdmin() {
        return this.to('DeleteDatalakeDelegatedAdmin');
    }
    /**
     * Grants permission to unsubscribe from SNS topics for exception notifications. Also, removes the SNS exception notifications topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeExceptionsSubscription.html
     */
    toDeleteDatalakeExceptionsSubscription() {
        return this.to('DeleteDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to delete the specified subscription permissions for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:ListPermissions
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriber.html
     */
    toDeleteSubscriber() {
        return this.to('DeleteSubscriber');
    }
    /**
     * Grants permission to remove a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriptionNotificationConfiguration.html
     */
    toDeleteSubscriptionNotificationConfiguration() {
        return this.to('DeleteSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to get information on the Security Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalake.html
     */
    toGetDatalake() {
        return this.to('GetDatalake');
    }
    /**
     * Grants permission to get an organization’s configuration setting for the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeAutoEnable.html
     */
    toGetDatalakeAutoEnable() {
        return this.to('GetDatalakeAutoEnable');
    }
    /**
     * Grants permission to allow user to query what was set as the expiration period for the exception message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsExpiry.html
     */
    toGetDatalakeExceptionsExpiry() {
        return this.to('GetDatalakeExceptionsExpiry');
    }
    /**
     * Grants permission to query the protocol and endpoint that were supplied when subscribing to the SNS topics for exception notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsSubscription.html
     */
    toGetDatalakeExceptionsSubscription() {
        return this.to('GetDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to get a static snapshot of the Security Data Lake in the current region, including enabled accounts and log sources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeStatus.html
     */
    toGetDatalakeStatus() {
        return this.to('GetDatalakeStatus');
    }
    /**
     * Grants permission to get subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriber.html
     */
    toGetSubscriber() {
        return this.to('GetSubscriber');
    }
    /**
     * Grants permission to get information for a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriptionNotificationConfiguration.html
     */
    toGetSubscriptionNotificationConfiguration() {
        return this.to('GetSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to get the list of all non-retry-able failures
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListDatalakeExceptions.html
     */
    toListDatalakeExceptions() {
        return this.to('ListDatalakeExceptions');
    }
    /**
     * Grants permission to show the estate view of enabled accounts with the enabled sources in the enabled regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListLogSources.html
     */
    toListLogSources() {
        return this.to('ListLogSources');
    }
    /**
     * Grants permission to list all subscription permissions for accounts that are already enabled
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListSubscribers.html
     */
    toListSubscribers() {
        return this.to('ListSubscribers');
    }
    /**
     * Grants permission to update a Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalake.html
     */
    toUpdateDatalake() {
        return this.to('UpdateDatalake');
    }
    /**
     * Grants permission to control the time-to-live (TTL) for the exception message to remain in service cache
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsExpiry.html
     */
    toUpdateDatalakeExceptionsExpiry() {
        return this.to('UpdateDatalakeExceptionsExpiry');
    }
    /**
     * Grants permission to update subscriptions to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsSubscription.html
     */
    toUpdateDatalakeExceptionsSubscription() {
        return this.to('UpdateDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to update subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriber.html
     */
    toUpdateSubscriber() {
        return this.to('UpdateSubscriber');
    }
    /**
     * Grants permission to update a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - s3:CreateBucket
     * - s3:GetBucketNotification
     * - s3:ListBucket
     * - s3:PutBucketNotification
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - s3:PutLifecycleConfiguration
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriptionNotificationConfiguration.html
     */
    toUpdateSubscriptionNotificationConfiguration() {
        return this.to('UpdateSubscriptionNotificationConfiguration');
    }
}
exports.Securitylake = Securitylake;
_a = JSII_RTTI_SYMBOL_1;
Securitylake[_a] = { fqn: "iam-floyd.Securitylake", version: "0.463.0" };
//# sourceMappingURL=data:application/json;base64,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