/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import compiler.FunctionHashesKt;
import evm.EVMConstsKt;
import evm.SighashInt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLErrorLogger;
import spec.StandardCVLErrorLogger;
import spec.cvlast.AssertRule;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLAstTypeChecker;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLCmdTransformer;
import spec.cvlast.CVLCmdTypeChecker;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLEnumType;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpFolder;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLExpTransformer;
import spec.cvlast.CVLExpTypeChecker;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLGhostAxiom;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLGhostVariable;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLHookPattern;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLInvariantProof;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLPreserved;
import spec.cvlast.CVLRuleType;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLSingleRule;
import spec.cvlast.CVLSlotPattern;
import spec.cvlast.CVLStorageType;
import spec.cvlast.CVLStructType;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeConversions;
import spec.cvlast.CVLTypeEnvironment;
import spec.cvlast.CVLTypeTypeChecker;
import spec.cvlast.CVLVoidType;
import spec.cvlast.ContractFunction;
import spec.cvlast.GhostUseSubstitutor;
import spec.cvlast.GroupRule;
import spec.cvlast.HasCVLErrorLogger;
import spec.cvlast.IRule;
import spec.cvlast.MethodIdWithCallContext;
import spec.cvlast.MethodParamFilter;
import spec.cvlast.MethodParamFilters;
import spec.cvlast.MethodReference;
import spec.cvlast.MethodSignature;
import spec.cvlast.SingleRuleWithCode;
import spec.cvlast.SolidityContract;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.StaticRule;
import spec.cvlast.StaticRuleWithCode;
import tac.StructField;
import tac.TACStorageType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0018\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010\u0019\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\u0019\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0019\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0018\u0010\u0019\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J\n\u00101\u001a\u000202*\u000203R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064\u00b2\u0006\u0012\u00105\u001a\n\u0012\u0004\u0012\u000207\u0018\u000106X\u008a\u0084\u0002\u00b2\u0006\u0010\u00108\u001a\b\u0012\u0004\u0012\u00020:09X\u008a\u0084\u0002\u00b2\u0006\n\u0010;\u001a\u00020\u0013X\u008a\u0084\u0002"}, d2={"Lspec/cvlast/CVLAstTypeChecker;", "Lspec/cvlast/HasCVLErrorLogger;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "errorLogger", "Lspec/CVLErrorLogger;", "(Lspec/cvlast/CVLSymbolTable;Lspec/CVLErrorLogger;)V", "cvlCmdTypeChecker", "Lspec/cvlast/CVLCmdTypeChecker;", "cvlExpTypeChecker", "Lspec/cvlast/CVLExpTypeChecker;", "cvlTypeTypeChecker", "Lspec/cvlast/CVLTypeTypeChecker;", "getErrorLogger", "()Lspec/CVLErrorLogger;", "filterExpMustBeBooleanAndClosed", "Lspec/cvlast/CVLExp;", "filterExp", "typeEnv", "Lspec/cvlast/CVLTypeEnvironment;", "loc", "Lspec/cvlast/CVLLocation;", "allowedVarsInUse", "", "", "typeCheck", "Lspec/cvlast/CVLAst;", "cvlAst", "Lspec/cvlast/CVLDefinition;", "definition", "Lspec/cvlast/CVLGhostDeclaration;", "ghost", "Lspec/cvlast/CVLHook;", "hook", "Lspec/cvlast/CVLInvariant;", "inv", "Lspec/cvlast/ContractFunction;", "import", "ambiguousSighashes", "Levm/SighashInt;", "Lspec/cvlast/IRule;", "rule", "Lspec/cvlast/MethodParamFilters;", "methodParamFilters", "typeCheckSlotPattern", "", "typecheck", "Lspec/cvlast/CVLFunction;", "sub", "allPathsReturn", "", "Lspec/cvlast/CVLCmd;", "Shared", "params", "", "Lspec/cvlast/CVLParam;", "namedParams", "", "Lspec/cvlast/CVLParam$Named;", "pushedTypeEnv"})
public final class CVLAstTypeChecker
implements HasCVLErrorLogger {
    @NotNull
    private final CVLSymbolTable symbolTable;
    @NotNull
    private final CVLErrorLogger errorLogger;
    @NotNull
    private final CVLTypeTypeChecker cvlTypeTypeChecker;
    @NotNull
    private final CVLCmdTypeChecker cvlCmdTypeChecker;
    @NotNull
    private final CVLExpTypeChecker cvlExpTypeChecker;

    public CVLAstTypeChecker(@NotNull CVLSymbolTable symbolTable, @NotNull CVLErrorLogger errorLogger) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(errorLogger, "errorLogger");
        this.symbolTable = symbolTable;
        this.errorLogger = errorLogger;
        if (!(this.symbolTable.getUserDefinedTypeResolver() != null)) {
            boolean bl = false;
            String string2 = "Type checker must take a symbol table with a non-null user defined type resolver";
            throw new IllegalStateException(string2.toString());
        }
        this.cvlTypeTypeChecker = new CVLTypeTypeChecker(this.symbolTable, null, 2, null);
        this.cvlCmdTypeChecker = new CVLCmdTypeChecker(this.symbolTable, null, 2, null);
        this.cvlExpTypeChecker = new CVLExpTypeChecker(this.symbolTable, null, 2, null);
    }

    public /* synthetic */ CVLAstTypeChecker(CVLSymbolTable cVLSymbolTable, CVLErrorLogger cVLErrorLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cVLErrorLogger = StandardCVLErrorLogger.INSTANCE;
        }
        this(cVLSymbolTable, cVLErrorLogger);
    }

    @Override
    @NotNull
    public CVLErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final CVLAst typeCheck(@NotNull CVLAst cvlAst) {
        Intrinsics.checkNotNullParameter(cvlAst, "cvlAst");
        $this$map$iv = cvlAst.getGhosts();
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            var10_24 = (CVLGhostDeclaration)item$iv$iv;
            var39_20 = destination$iv$iv /* !! */ ;
            $i$a$-map-CVLAstTypeChecker$typeCheck$ghosts$1 = false;
            var39_20.add(this.typeCheck((CVLGhostDeclaration)ghost));
        }
        ghosts = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = cvlAst.getDefinitions();
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-CVLAstTypeChecker$typeCheck$ghosts$1 = (CVLDefinition)item$iv$iv;
            var39_20 = destination$iv$iv /* !! */ ;
            $i$a$-map-CVLAstTypeChecker$typeCheck$definitions$1 = false;
            readsAndModifies = CollectionsKt.intersect((Iterable)definition.getModifies(), (Iterable)definition.getReads());
            if (readsAndModifies.isEmpty()) {
                var14_51 = definition.getModifies();
                v0 = definition.getLoc();
                v1 = definition.getScope();
                Intrinsics.checkNotNull(v1);
                var15_61 = CVLTypeEnvironment.Companion.empty(v0, v1);
                $i$f$fold = false;
                accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    var20_91 = (CVLGhostFunction)element$iv;
                    accEnv = accumulator$iv;
                    $i$a$-fold-CVLAstTypeChecker$typeCheck$definitions$1$typeEnv$1 = false;
                    accumulator$iv = accEnv.pushTwoStateGhost((CVLGhostDeclaration)elModified);
                }
                v2 = accumulator$iv;
            } else {
                this.getErrorLogger().error("Definition " + definition.getId() + " both reads and modifies the ghost function(s) " + CollectionsKt.joinToString$default(readsAndModifies, ", ", null, null, 0, null, typeCheck.definitions.1.typeEnv.2.INSTANCE, 30, null) + ". This is not allowed.", definition.getLoc());
                v3 = definition.getLoc();
                v4 = definition.getScope();
                Intrinsics.checkNotNull(v4);
                v2 = CVLTypeEnvironment.Companion.empty(v3, v4);
            }
            typeEnv = v2;
            defTypeChecked = this.typeCheck((CVLDefinition)definition, (CVLTypeEnvironment)typeEnv);
            var39_20.add(defTypeChecked);
        }
        definitions = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = cvlAst.getRules();
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-CVLAstTypeChecker$typeCheck$definitions$1 = (IRule)item$iv$iv;
            var39_20 = destination$iv$iv /* !! */ ;
            $i$a$-map-CVLAstTypeChecker$typeCheck$rules$1 = false;
            var39_20.add(this.typeCheck((IRule)it));
        }
        rules = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = cvlAst.getSubs();
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-CVLAstTypeChecker$typeCheck$rules$1 = (CVLFunction)item$iv$iv;
            var39_20 = destination$iv$iv /* !! */ ;
            $i$a$-map-CVLAstTypeChecker$typeCheck$subs$1 = false;
            subTypeChecked = this.typecheck((CVLFunction)sub);
            var39_20.add(subTypeChecked);
        }
        subs = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = cvlAst.getInvs();
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-CVLAstTypeChecker$typeCheck$subs$1 = (CVLInvariant)item$iv$iv;
            var39_20 = destination$iv$iv;
            $i$a$-map-CVLAstTypeChecker$typeCheck$invs$1 = false;
            $i$f$fold = inv.getParams();
            v5 = inv.getLoc();
            v6 = inv.getScope();
            Intrinsics.checkNotNull(v6);
            accumulator$iv = CVLTypeEnvironment.Companion.empty(v5, v6);
            var18_83 = inv;
            element$iv = this;
            $i$f$fold = false;
            accumulator$iv = initial$iv;
            for (T element$iv : $this$fold$iv) {
                var24_111 = (CVLParam.Named)element$iv;
                accEnv = accumulator$iv;
                $i$a$-fold-CVLAstTypeChecker$typeCheck$invs$1$invTypeChecked$1 = false;
                accumulator$iv = accEnv.pushParam((CVLParam)elParam);
            }
            var27_121 = accumulator$iv;
            invTypeChecked = super.typeCheck((CVLInvariant)var18_83, (CVLTypeEnvironment)var27_121);
            var39_20.add(invTypeChecked);
        }
        invs = (List)destination$iv$iv;
        hooks = new ArrayList<E>();
        duplicateHooks = new ArrayList<E>();
        $this$forEach$iv = cvlAst.getHooks();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block38: {
                hook = (CVLHook)element$iv /* !! */ ;
                $i$a$-forEach-CVLAstTypeChecker$typeCheck$1 = false;
                $this$firstOrNull$iv = hooks;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    seen = (CVLHook)element$iv;
                    $i$a$-firstOrNull-CVLAstTypeChecker$typeCheck$1$duplicate$1 = false;
                    if (!hook.getPattern().matches(seen.getPattern())) continue;
                    v7 = element$iv;
                    break block38;
                }
                v7 = null;
            }
            duplicate = v7;
            if (duplicate != null) {
                duplicateHooks.add(TuplesKt.to(hook, duplicate));
                continue;
            }
            hooks.add(hook);
        }
        $this$forEach$iv = duplicateHooks;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            $dstr$duplicate$hook = (Pair)element$iv /* !! */ ;
            $i$a$-forEach-CVLAstTypeChecker$typeCheck$2 = false;
            duplicate = (CVLHook)$dstr$duplicate$hook.component1();
            hook = (CVLHook)$dstr$duplicate$hook.component2();
            initial$iv = hook.getPattern();
            if (initial$iv instanceof CVLHookPattern.StoragePattern) {
                this.getErrorLogger().error("The declared hook pattern " + duplicate.getPattern() + " is a duplicate with the hook pattern " + hook.getPattern() + " that has already been declared. A hook pattern may only be used once.", duplicate.getLoc());
                continue;
            }
            if (!(initial$iv instanceof CVLHookPattern.Create)) continue;
            this.getErrorLogger().error("Duplicate Create hook: " + hook.getLoc() + " and " + duplicate.getLoc(), duplicate.getLoc());
        }
        $this$map$iv = hooks;
        $i$f$map = false;
        element$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            initial$iv = (CVLHook)item$iv$iv;
            var39_20 = destination$iv$iv;
            $i$a$-map-CVLAstTypeChecker$typeCheck$hooksTypeChecked$1 = false;
            var39_20.add(this.typeCheck((CVLHook)hook));
        }
        hooksTypeChecked = (List)destination$iv$iv;
        $this$filter$iv = cvlAst.getImportedMethods();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        duplicate = $this$filterTo$iv$iv.iterator();
        while (duplicate.hasNext()) {
            element$iv$iv = duplicate.next();
            it = (ContractFunction)element$iv$iv;
            $i$a$-filter-CVLAstTypeChecker$typeCheck$3 = false;
            if (!(it.getSummary() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            importedMethod = (ContractFunction)element$iv;
            $i$a$-forEach-CVLAstTypeChecker$typeCheck$4 = false;
            $this$filter$iv = cvlAst.getImportedMethods();
            $i$f$filter = false;
            $i$a$-filter-CVLAstTypeChecker$typeCheck$3 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (ContractFunction)element$iv$iv;
                $i$a$-filter-CVLAstTypeChecker$typeCheck$4$duplicates$1 = false;
                if (!Intrinsics.areEqual(it.getMethodSignature(), importedMethod.getMethodSignature())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            duplicates = (List)destination$iv$iv;
            if (duplicates.size() <= 1) continue;
            this.getErrorLogger().error("the same method is imported more than once: " + duplicates, importedMethod.getLoc());
        }
        cvlFunctionsUsedAsSummaries = new ArrayList<E>();
        v8 = this.symbolTable.getUserDefinedTypeResolver();
        Intrinsics.checkNotNull(v8);
        $this$flatMap$iv = v8.getContracts();
        $i$f$flatMap = false;
        importedMethod = $this$flatMap$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            contract = (ContractInstanceInSDC)element$iv$iv;
            $i$a$-flatMap-CVLAstTypeChecker$typeCheck$ambiguousMethods$1 = false;
            methodInstances = new LinkedHashMap<K, V>();
            $this$forEach$iv = contract.getAllMethods();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                m = (Method)element$iv;
                $i$a$-forEach-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$1 = false;
                hash = new SighashInt(FunctionHashesKt.calculateHashFromCanonicalNameBigInt(m.getCanonicalName()));
                $this$getOrPut$iv = methodInstances;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(hash);
                if (value$iv == null) {
                    $i$a$-getOrPut-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$1$1 = false;
                    answer$iv = new LinkedHashSet<E>();
                    $this$getOrPut$iv.put(hash, answer$iv);
                    v9 /* !! */  = answer$iv;
                } else {
                    v9 /* !! */  = value$iv;
                }
                ((Set)v9 /* !! */ ).add(m);
            }
            $this$filter$iv = methodInstances;
            $i$f$filter = false;
            $i$a$-filter-CVLAstTypeChecker$typeCheck$4$duplicates$1 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            $i$a$-forEach-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$1 = $this$filterTo$iv$iv.entrySet().iterator();
            while ($i$a$-forEach-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$1.hasNext()) {
                block39: {
                    $dstr$_u24__u24$matches = element$iv$iv = $i$a$-forEach-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$1.next();
                    $i$a$-filter-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$2 = false;
                    matches = (Set)$dstr$_u24__u24$matches.getValue();
                    if (matches.size() <= 1) ** GOTO lbl-1000
                    $this$any$iv = matches;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v10 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            match = (Method)element$iv;
                            $i$a$-any-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$2$1 = false;
                            if (!(match.getVisibility() != null)) {
                                $i$a$-check-CVLAstTypeChecker$typeCheck$ambiguousMethods$1$2$1$1 = false;
                                var38_139 = "all methods from a contract must have a visibility but method " + match.getCanonicalName() + " from contract " + contract.getName() + " does not";
                                throw new IllegalStateException(var38_139.toString());
                            }
                            if (!match.hasInternalImplementation()) continue;
                            v10 = true;
                            break block39;
                        }
                        v10 = false;
                    }
                }
                if (v10) {
                    v11 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v11 = false;
                }
                if (!v11) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv /* !! */ , list$iv$iv);
        }
        ambiguousMethods = CollectionsKt.toSet((List)destination$iv$iv /* !! */ );
        $this$map$iv = cvlAst.getImportedMethods();
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-flatMap-CVLAstTypeChecker$typeCheck$ambiguousMethods$1 = (ContractFunction)item$iv$iv;
            var39_20 = destination$iv$iv;
            $i$a$-map-CVLAstTypeChecker$typeCheck$importsTypeChecked$1 = false;
            v12 = importedMethod.getLoc();
            v13 = cvlAst.getScope();
            Intrinsics.checkNotNull(v13);
            f = $this$filter$iv = this.typeCheck((ContractFunction)importedMethod, ambiguousMethods, CVLTypeEnvironment.Companion.empty(v12, v13));
            $i$a$-also-CVLAstTypeChecker$typeCheck$importsTypeChecked$1$1 = false;
            if (f.getSummary() instanceof SpecCallSummary.Exp && ((SpecCallSummary.Exp)f.getSummary()).getExp() instanceof CVLExp.ApplyExp.CVLFunction) {
                v14 = ((CVLExp.ApplyExp.CVLFunction)((SpecCallSummary.Exp)f.getSummary()).getExp()).getId();
                v15 = cvlAst.getScope();
                Intrinsics.checkNotNull(v15);
                v16 = this.symbolTable.lookUpFunctionLikeSymbol(v14, v15);
                v17 = v16 == null ? null : v16.getHook();
                if (v17 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLFunction");
                }
                f = (CVLFunction)v17;
                $this$single$iv = subs;
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    fTypeChecked = (CVLFunction)element$iv;
                    $i$a$-single-CVLAstTypeChecker$typeCheck$importsTypeChecked$1$1$fTypeChecked$1 = false;
                    if (!Intrinsics.areEqual(fTypeChecked.getDeclarationId(), f.getDeclarationId())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                fTypeChecked = single$iv;
                cvlFunctionsUsedAsSummaries.add(TuplesKt.to(importedMethod, fTypeChecked));
            }
            var39_20.add($this$filter$iv);
        }
        importsTypeChecked = (List)destination$iv$iv;
        $this$forEach$iv = cvlFunctionsUsedAsSummaries;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            $dstr$contractFunction$cvlFunctionAsSummary = (Pair)element$iv;
            $i$a$-forEach-CVLAstTypeChecker$typeCheck$5 = false;
            contractFunction = (ContractFunction)$dstr$contractFunction$cvlFunctionAsSummary.component1();
            cvlFunctionAsSummary = (CVLFunction)$dstr$contractFunction$cvlFunctionAsSummary.component2();
            transformer = new CVLExpTransformer(this, contractFunction, cvlFunctionAsSummary){
                final /* synthetic */ CVLAstTypeChecker this$0;
                final /* synthetic */ ContractFunction $contractFunction;
                final /* synthetic */ CVLFunction $cvlFunctionAsSummary;
                {
                    this.this$0 = $receiver;
                    this.$contractFunction = $contractFunction;
                    this.$cvlFunctionAsSummary = $cvlFunctionAsSummary;
                }

                @NotNull
                public CVLExp invokeExp(@NotNull CVLExp.ApplyExp.ContractFunction exp) {
                    Intrinsics.checkNotNullParameter(exp, "exp");
                    CVLErrorLogger cVLErrorLogger = this.this$0.getErrorLogger();
                    MethodReference methodReference = this.$contractFunction.getMethodSignature().getMethodReference();
                    String string2 = this.$cvlFunctionAsSummary.getDeclarationId();
                    String string3 = this.$cvlFunctionAsSummary.getDeclarationId();
                    MethodIdWithCallContext methodIdWithCallContext = exp.getMethodIdWithCallContext();
                    CVLLocation cVLLocation = exp.getTag().getLoc();
                    Intrinsics.checkNotNull(cVLLocation);
                    cVLErrorLogger.error("The function " + methodReference + " may not be summarized with the CVL Function " + string2 + " since " + string3 + " contains a call to a contract function, (in this case " + methodIdWithCallContext + " at " + cVLLocation + ").", this.$contractFunction.getLoc());
                    return super.invokeExp(exp);
                }
            };
            $this$forEach$iv = cvlFunctionAsSummary.getBlock();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                cmd = (CVLCmd)element$iv;
                $i$a$-forEach-CVLAstTypeChecker$typeCheck$5$1 = false;
                new CVLCmdTransformer(transformer).cmd(cmd);
            }
            $this$forEach$iv = cvlFunctionAsSummary.getParams();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                param = (CVLParam.Named)element$iv;
                $i$a$-forEach-CVLAstTypeChecker$typeCheck$5$2 = false;
                if (param.getType().enumsBegone() instanceof CVLSimpleType) continue;
                this.getErrorLogger().error("The parameter " + param.getId() + " to CVL Function " + cvlFunctionAsSummary.getMethodReference() + " must be a simple type since " + cvlFunctionAsSummary.getMethodReference() + " is used as a summary for " + contractFunction.getMethodSignature().getMethodReference() + " (at " + contractFunction.getLoc() + ").", cvlFunctionAsSummary.getLoc());
            }
        }
        return new CVLAst(cvlAst.getPragma(), importsTypeChecked, cvlAst.getImportedEvents(), cvlAst.getUseDeclarations(), rules, subs, invs, cvlAst.getSorts(), ghosts, definitions, hooksTypeChecked, cvlAst.getImportedContracts(), cvlAst.getImportedSpecFiles(), cvlAst.getOverrideDeclarations(), cvlAst.getScope());
    }

    /*
     * WARNING - void declaration
     */
    private final CVLInvariant typeCheck(CVLInvariant inv, CVLTypeEnvironment typeEnv2) {
        CVLInvariant cVLInvariant;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        inv.checkPreservedIsErrorFree((Function2<? super String, ? super CVLLocation, Unit>)new Function2<String, CVLLocation, Unit>((Object)this.getErrorLogger()){

            public final void invoke(@NotNull String p0, @NotNull CVLLocation p12) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p12, "p1");
                ((CVLErrorLogger)this.receiver).error(p0, p12);
            }
        });
        Iterable $this$map$iv = inv.getProof().getPreserved();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void preserve;
            CVLPreserved cVLPreserved = (CVLPreserved)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(preserve.copyWithBlockMapperAndScopeAndParams((Function1<? super List<? extends CVLCmd>, ? extends List<? extends CVLCmd>>)new Function1<List<? extends CVLCmd>, List<? extends CVLCmd>>(this){
                final /* synthetic */ CVLAstTypeChecker this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<CVLCmd> invoke(@NotNull List<? extends CVLCmd> l) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(l, "l");
                    Iterable iterable = l;
                    CVLAstTypeChecker cVLAstTypeChecker = this.this$0;
                    boolean $i$f$map = false;
                    void var5_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void cmd;
                        CVLCmd cVLCmd = (CVLCmd)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(CVLAstTypeChecker.access$getCvlCmdTypeChecker$p(cVLAstTypeChecker).typeCheck((CVLCmd)cmd));
                    }
                    return (List)destination$iv$iv;
                }
            }, preserve.getWithParams(), preserve.getScope()));
        }
        List list = (List)destination$iv$iv;
        CVLInvariantProof proof2 = new CVLInvariantProof(list);
        Iterable $this$map$iv2 = inv.getParams();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            CVLParam.Named bl = (CVLParam.Named)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            CVLType cVLType = param.getType();
            CVLLocation cVLLocation = inv.getLoc();
            CVLScope cVLScope = inv.getScope();
            Intrinsics.checkNotNull(cVLScope);
            collection.add(CVLParam.Named.copy$default((CVLParam.Named)param, CVLTypeTypeChecker.typeCheck$default(this.cvlTypeTypeChecker, cVLType, cVLLocation, cVLScope, null, 8, null), null, 2, null));
        }
        List params2 = (List)destination$iv$iv2;
        Iterable $this$fold$iv = params2;
        boolean $i$f$fold = false;
        CVLTypeEnvironment accumulator$iv = typeEnv2;
        for (Object element$iv : $this$fold$iv) {
            void param;
            Object item$iv$iv;
            item$iv$iv = (CVLParam.Named)element$iv;
            CVLTypeEnvironment env = accumulator$iv;
            boolean bl = false;
            accumulator$iv = env.pushParam((CVLParam)param);
        }
        CVLTypeEnvironment invTypeEnv = accumulator$iv;
        CVLExp exp = new CVLExpTypeChecker(this.symbolTable, null, 2, null).typeCheck(inv.getExp(), invTypeEnv);
        CVLTypeConversions.TypeConversion expAsBool = CVLTypeConversions.INSTANCE.convertTypeIfPossible(exp, CVLInbuiltSimpleTypes.bool.INSTANCE.getCvlType());
        if (inv.getMethodParamFilters().getMethodParamToFilter().size() > 1) {
            Iterable $this$sortedBy$iv = inv.getMethodParamFilters().getMethodParamToFilter().keySet();
            boolean $i$f$sortedBy = false;
            return CVLInvariant.copy$default(inv, null, null, null, params2, exp.updateType(this.typeError(exp, inv.getLoc(), "filtered expression for invariants must take a single input variable, got " + CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    CVLExp.VariableExp it = (CVLExp.VariableExp)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getId());
                    it = (CVLExp.VariableExp)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getId()));
                }
            }) + " for " + inv.getId())), null, proof2, null, null, 423, null);
        }
        CVLTypeEnvironment invTypeEnvForFilters = invTypeEnv.pushParam(new CVLParam.Named(CVLInbuiltStructTypes.methodType.getCvlType(), inv.getMethodParam().getId()));
        MethodParamFilters methodParamFilters = !((Collection)inv.getMethodParamFilters().getMethodParamToFilter().keySet()).isEmpty() ? this.typeCheck(inv.getMethodParamFilters().updateSingleMethodParamTo(inv.getMethodParam()), invTypeEnvForFilters) : inv.getMethodParamFilters();
        CVLTypeConversions.TypeConversion typeConversion = expAsBool;
        if (typeConversion instanceof CVLTypeConversions.TypeConversion.Success) {
            cVLInvariant = CVLInvariant.copy$default(inv, null, null, null, params2, expAsBool.getExp(), methodParamFilters, proof2, null, null, 391, null);
        } else if (typeConversion instanceof CVLTypeConversions.TypeConversion.Error) {
            cVLInvariant = CVLInvariant.copy$default(inv, null, null, null, params2, exp.updateType(this.typeError(exp, inv.getLoc(), "invariant expression has non-Boolean type")), methodParamFilters, proof2, null, null, 391, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return cVLInvariant;
    }

    public final boolean allPathsReturn(@NotNull CVLCmd $this$allPathsReturn) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter($this$allPathsReturn, "<this>");
            CVLCmd cVLCmd = $this$allPathsReturn;
            if (cVLCmd instanceof CVLCmd.Simple.Return) {
                bl = true;
            } else if (cVLCmd instanceof CVLCmd.Composite.Block) {
                Iterable $this$any$iv = ((CVLCmd.Composite.Block)$this$allPathsReturn).getBlock();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CVLCmd cmd = (CVLCmd)element$iv;
                        boolean bl2 = false;
                        if (!this.allPathsReturn(cmd)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = cVLCmd instanceof CVLCmd.Composite.If ? this.allPathsReturn(((CVLCmd.Composite.If)$this$allPathsReturn).getElseCmd()) && this.allPathsReturn(((CVLCmd.Composite.If)$this$allPathsReturn).getThenCmd()) : false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final CVLFunction typecheck(CVLFunction sub2) {
        Collection<CVLCmd> collection;
        Object object;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = sub2.getParams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void param;
            item$iv$iv = iterator2.next();
            CVLParam.Named named = (CVLParam.Named)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            CVLType cVLType = param.getType();
            CVLLocation cVLLocation = sub2.getLoc();
            CVLScope cVLScope = sub2.getScope();
            Intrinsics.checkNotNull(cVLScope);
            object.add(CVLParam.Named.copy$default((CVLParam.Named)param, CVLTypeTypeChecker.typeCheck$default(this.cvlTypeTypeChecker, cVLType, cVLLocation, cVLScope, null, 8, null), null, 2, null));
        }
        List params2 = (List)destination$iv$iv;
        if (!Intrinsics.areEqual(sub2.getRets(), CVLVoidType.INSTANCE) && !CVLAstTypeChecker.typecheck$allPathsReturn(sub2, this)) {
            this.getErrorLogger().error("A non-returning path was found in the CVL Function " + sub2.getDeclarationId(), sub2.getLoc());
        }
        Iterable $this$forEach$iv = sub2.getBlock();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator $this$filterTo$iv$iv;
            CVLCmd cmd = (CVLCmd)element$iv;
            boolean bl = false;
            if (!(cmd instanceof CVLCmd.Simple.Havoc)) continue;
            Iterable $this$filter$iv = ((CVLCmd.Simple.Havoc)cmd).getHavoccedVars();
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                boolean bl3;
                Object element$iv$iv;
                block9: {
                    element$iv$iv = iterator3.next();
                    CVLExp.VariableExp v = (CVLExp.VariableExp)element$iv$iv;
                    boolean bl4 = false;
                    Iterable $this$any$iv = sub2.getParams();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            CVLParam.Named param = (CVLParam.Named)element$iv2;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(param.getId(), v.getId())) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List havocdParams = (List)destination$iv$iv2;
            Iterable $this$forEach$iv2 = havocdParams;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv3 = $this$filterTo$iv$iv.next();
                CVLExp.VariableExp param = (CVLExp.VariableExp)element$iv3;
                boolean bl6 = false;
                this.syntaxError(cmd.getLoc(), "Havocing a CVL Function param (" + param + ") is not allowed");
            }
        }
        $this$forEach$iv = sub2.getBlock();
        CVLType cVLType = null;
        List list = params2;
        String string2 = null;
        CVLLocation cVLLocation = null;
        object = sub2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void cmd;
            item$iv$iv = iterator2.next();
            CVLCmd $i$f$forEach2 = (CVLCmd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cvlCmdTypeChecker.typeCheck((CVLCmd)cmd));
        }
        collection = (List)destination$iv$iv;
        return CVLFunction.copy$default((CVLFunction)object, cVLLocation, string2, list, cVLType, (List)collection, null, 43, null);
    }

    /*
     * WARNING - void declaration
     */
    private final MethodParamFilters typeCheck(MethodParamFilters methodParamFilters, CVLTypeEnvironment typeEnv2) {
        Collection<Pair<CVLExp.VariableExp, MethodParamFilter>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<CVLExp.VariableExp, MethodParamFilter> map2 = methodParamFilters.getMethodParamToFilter();
        CVLScope cVLScope = null;
        CVLLocation cVLLocation = null;
        MethodParamFilters methodParamFilters2 = methodParamFilters;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $dstr$methodParam$filter;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            CVLExp.VariableExp methodParam = (CVLExp.VariableExp)$dstr$methodParam$filter.getKey();
            MethodParamFilter filter2 = (MethodParamFilter)$dstr$methodParam$filter.getValue();
            String string2 = methodParam.getId();
            CVLScope cVLScope2 = methodParamFilters.getScope();
            Intrinsics.checkNotNull(cVLScope2);
            CVLSymbolTable.SymbolInfo symbolInfo = this.symbolTable.lookUpFunctionLikeSymbol(string2, cVLScope2);
            CVLExp.VariableExp typeCheckedMethodParam = !methodParamFilters.getScope().isInvariantScope() && (symbolInfo == null || !symbolInfo.isParam() || !Intrinsics.areEqual(symbolInfo.getCVLType(), CVLInbuiltStructTypes.methodType.getCvlType())) ? CVLExp.VariableExp.copy$default(methodParam, null, new CVLExpTag(methodParamFilters.getScope(), this.typeError(methodParam, methodParamFilters.getLoc(), "Filters can be declared only for method type rule parameters, but \"" + methodParam.getId() + "\" is not such a parameter"), methodParamFilters.getLoc(), false, 8, null), null, false, 13, null) : CVLExp.VariableExp.copy$default(methodParam, null, new CVLExpTag(methodParamFilters.getScope(), CVLInbuiltStructTypes.methodType.getCvlType(), methodParamFilters.getLoc(), false, 8, null), null, false, 13, null);
            CVLExp typeCheckedFilterExp = this.filterExpMustBeBooleanAndClosed(filter2.getFilterExp(), typeEnv2, methodParamFilters.getLoc(), SetsKt.setOf(typeCheckedMethodParam.getId()));
            collection.add(TuplesKt.to(typeCheckedMethodParam, MethodParamFilter.copy$default(filter2, typeCheckedMethodParam, typeCheckedFilterExp, null, null, 12, null)));
        }
        collection = (List)destination$iv$iv;
        return MethodParamFilters.copy$default(methodParamFilters2, cVLLocation, cVLScope, MapsKt.toMap((Iterable)collection), this.filterExpMustBeBooleanAndClosed(methodParamFilters.getDefaultFilterExp(), typeEnv2, methodParamFilters.getLoc(), SetsKt.emptySet()), 3, null);
    }

    private final CVLExp filterExpMustBeBooleanAndClosed(CVLExp filterExp, CVLTypeEnvironment typeEnv2, CVLLocation loc, Set<String> allowedVarsInUse) {
        CVLExp cVLExp;
        CVLExp typedFilterExp = this.cvlExpTypeChecker.typeCheck(filterExp, typeEnv2);
        if (typedFilterExp.getCVLType() instanceof CVLErrorType) {
            cVLExp = typedFilterExp;
        } else {
            Set symsInFilterExp2;
            CVLTypeConversions.TypeConversion converted = CVLTypeConversions.INSTANCE.convertTypeIfPossible(typedFilterExp, CVLInbuiltSimpleTypes.bool.INSTANCE.getCvlType());
            boolean bl = false;
            cVLExp = !(converted instanceof CVLTypeConversions.TypeConversion.Success) ? converted.getExp().updateType(this.typeError(converted.getExp(), loc, "Method parameter's filter expressions must be boolean (found " + converted.getExp().getCVLType() + " type)")) : (allowedVarsInUse.containsAll(symsInFilterExp2 = new CVLExpFolder<Set<? extends String>>(){

                @NotNull
                public Set<String> variable(@NotNull Set<String> acc, @NotNull CVLExp.VariableExp exp) {
                    Intrinsics.checkNotNullParameter(acc, "acc");
                    Intrinsics.checkNotNullParameter(exp, "exp");
                    return SetsKt.plus(acc, exp.getId());
                }

                @NotNull
                public Set<String> invokeSymbolicExp(@NotNull Set<String> acc, @NotNull CVLExp.ApplyExp.ContractFunction.Symbolic exp) {
                    Intrinsics.checkNotNullParameter(acc, "acc");
                    Intrinsics.checkNotNullParameter(exp, "exp");
                    return SetsKt.plus(super.invokeSymbolicExp(acc, exp), exp.getMethodIdWithCallContext().getMethodId());
                }
            }.expr(SetsKt.emptySet(), converted.getExp())) ? converted.getExp() : converted.getExp().updateType(this.typeError(converted.getExp(), loc, "The method parameter's filter expression uses the symbols " + SetsKt.minus(symsInFilterExp2, (Iterable)allowedVarsInUse) + " while it may only use " + allowedVarsInUse)));
        }
        return cVLExp;
    }

    /*
     * WARNING - void declaration
     */
    private final IRule typeCheck(IRule rule) {
        IRule iRule;
        IRule iRule2 = rule;
        if (iRule2 instanceof SingleRuleWithCode) {
            SingleRuleWithCode singleRuleWithCode2;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            void $this$fold$iv;
            SingleRuleWithCode initial$iv;
            CVLParam.Named param;
            Object object;
            CVLTypeEnvironment $this$mapTo$iv$iv2;
            Iterable $this$map$iv = ((SingleRuleWithCode)rule).getParams();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                CVLParam.Named named = (CVLParam.Named)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                CVLType cVLType = param.getType();
                CVLLocation cVLLocation = ((SingleRuleWithCode)rule).getLoc();
                CVLScope cVLScope = ((SingleRuleWithCode)rule).getScope();
                Intrinsics.checkNotNull(cVLScope);
                object.add(CVLParam.Named.copy$default(param, CVLTypeTypeChecker.typeCheck$default(this.cvlTypeTypeChecker, cVLType, cVLLocation, cVLScope, null, 8, null), null, 2, null));
            }
            List typeCheckedParams = (List)destination$iv$iv2;
            Iterable $i$f$map22 = typeCheckedParams;
            CVLLocation cVLLocation = ((SingleRuleWithCode)rule).getLoc();
            CVLScope cVLScope = ((SingleRuleWithCode)rule).getScope();
            Intrinsics.checkNotNull(cVLScope);
            $this$mapTo$iv$iv2 = CVLTypeEnvironment.Companion.empty(cVLLocation, cVLScope);
            boolean $i$f$fold = false;
            CVLTypeEnvironment accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                param = (CVLParam.Named)element$iv;
                void env = accumulator$iv;
                boolean bl = false;
                accumulator$iv = env.pushParam(param);
            }
            void ruleTypeEnv = accumulator$iv;
            MethodParamFilters typeCheckedMethodParamFilters = this.typeCheck(((SingleRuleWithCode)rule).getMethodParamFilters(), (CVLTypeEnvironment)ruleTypeEnv);
            if (!(!((Collection)((SingleRuleWithCode)rule).getBlock()).isEmpty())) {
                boolean $i$a$-check-CVLAstTypeChecker$typeCheck$122 = false;
                this.syntaxError(((SingleRuleWithCode)rule).getLoc(), "Encountered an empty rule: " + rule.getDeclarationId());
                Unit $i$a$-check-CVLAstTypeChecker$typeCheck$122 = Unit.INSTANCE;
                throw new IllegalStateException(((Object)$i$a$-check-CVLAstTypeChecker$typeCheck$122).toString());
            }
            initial$iv = (SingleRuleWithCode)rule;
            if (initial$iv instanceof CVLSingleRule) {
                Collection<CVLCmd> collection;
                void $this$map$iv2;
                Iterable $i$a$-check-CVLAstTypeChecker$typeCheck$122 = ((SingleRuleWithCode)rule).getBlock();
                String string2 = null;
                String string3 = null;
                List list = typeCheckedParams;
                String string4 = null;
                CVLLocation cVLLocation2 = null;
                object = (CVLSingleRule)rule;
                boolean $i$f$map = false;
                iterator2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cmd;
                    CVLCmd cVLCmd = (CVLCmd)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.cvlCmdTypeChecker.typeCheck((CVLCmd)cmd));
                }
                collection = (List)destination$iv$iv;
                singleRuleWithCode2 = CVLSingleRule.copy$default((CVLSingleRule)object, cVLLocation2, string4, list, string3, string2, collection, null, null, null, typeCheckedMethodParamFilters, null, 1499, null);
            } else if (initial$iv instanceof StaticRuleWithCode) {
                Collection<CVLCmd> collection;
                Iterable $this$map$iv2 = ((SingleRuleWithCode)rule).getBlock();
                List list = typeCheckedParams;
                String string5 = null;
                CVLRuleType.Single single2 = null;
                String string6 = null;
                object = (StaticRuleWithCode)rule;
                boolean $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CVLCmd cmd = (CVLCmd)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new CVLCmdTypeChecker(this.symbolTable, null, 2, null).typeCheck(cmd));
                }
                collection = (List)destination$iv$iv;
                singleRuleWithCode2 = StaticRuleWithCode.copy$default((StaticRuleWithCode)object, string6, single2, string5, list, (List)collection, null, typeCheckedMethodParamFilters, null, 167, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            iRule = singleRuleWithCode2;
        } else if (iRule2 instanceof GroupRule) {
            Collection<IRule> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable typeCheckedParams = ((GroupRule)rule).getRules();
            String string7 = null;
            GroupRule groupRule = (GroupRule)rule;
            boolean $i$f$map = false;
            void typeCheckedMethodParamFilters = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void r;
                IRule destination$iv$iv3 = (IRule)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.typeCheck((IRule)r));
            }
            collection = (List)destination$iv$iv;
            iRule = GroupRule.copy$default(groupRule, string7, (List)collection, null, 5, null);
        } else if (iRule2 instanceof AssertRule) {
            iRule = rule;
        } else if (iRule2 instanceof StaticRule) {
            iRule = rule;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return iRule;
    }

    /*
     * WARNING - void declaration
     */
    private final CVLGhostDeclaration typeCheck(CVLGhostDeclaration ghost2) {
        void $this$mapTo$iv$iv;
        CVLGhostDeclaration cVLGhostDeclaration;
        Collection<CVLGhostAxiom> collection;
        CVLGhostAxiom item$iv$iv;
        CVLGhostDeclaration cVLGhostDeclaration2;
        CVLLocation cVLLocation;
        CVLType cVLType;
        CVLFunctionType cVLFunctionType;
        Object axiomChecker2;
        CVLGhostDeclaration cVLGhostDeclaration3 = ghost2;
        if (cVLGhostDeclaration3 instanceof CVLGhostFunction) {
            CVLGhostAxiom axiom;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            axiomChecker2 = new GhostUseSubstitutor((Function1<? super CVLExp.ApplyExp.Ghost, ? extends CVLExp>)new Function1<CVLExp.ApplyExp.Ghost, CVLExp>(ghost2, this){
                final /* synthetic */ CVLGhostDeclaration $ghost;
                final /* synthetic */ CVLAstTypeChecker this$0;
                {
                    this.$ghost = $ghost;
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final CVLExp invoke(@NotNull CVLExp.ApplyExp.Ghost ghostApply) {
                    Intrinsics.checkNotNullParameter(ghostApply, "ghostApply");
                    if (ghostApply.getMethodIdWithCallContext().!matches(((CVLGhostFunction)this.$ghost).getMethodReference())) {
                        this.this$0.getErrorLogger().error("axiom for ghost function " + ((CVLGhostFunction)this.$ghost).getMethodReference() + " should only contain application expressions of " + ((CVLGhostFunction)this.$ghost).getMethodReference() + " not " + ghostApply.getMethodIdWithCallContext(), this.$ghost.getLoc());
                    }
                    return ghostApply;
                }
            }, typeCheck.axiomChecker.2.INSTANCE);
            CVLGhostFunction cVLGhostFunction = (CVLGhostFunction)ghost2;
            CVLType cVLType2 = ((CVLGhostFunction)ghost2).getType();
            CVLLocation cVLLocation2 = ghost2.getLoc();
            CVLScope cVLScope = ghost2.getScope();
            Intrinsics.checkNotNull(cVLScope);
            Iterable iterable = ghost2.getAxioms();
            cVLFunctionType = (CVLFunctionType)CVLTypeTypeChecker.typeCheckNoCVLStructTypes$default(this.cvlTypeTypeChecker, cVLType2, cVLLocation2, cVLScope, null, 8, null);
            cVLType = null;
            cVLLocation = null;
            cVLGhostDeclaration2 = cVLGhostFunction;
            boolean $i$f$map = false;
            void var6_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                CVLGhostAxiom cVLGhostAxiom = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(axiom.mapExp((Function1<? super CVLExp, ? extends CVLExp>)new Function1<CVLExp, CVLExp>(this, ghost2){
                    final /* synthetic */ CVLAstTypeChecker this$0;
                    final /* synthetic */ CVLGhostDeclaration $ghost;
                    {
                        this.this$0 = $receiver;
                        this.$ghost = $ghost;
                        super(1);
                    }

                    @NotNull
                    public final CVLExp invoke(@NotNull CVLExp exp) {
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        CVLExpTypeChecker cVLExpTypeChecker = CVLAstTypeChecker.access$getCvlExpTypeChecker$p(this.this$0);
                        CVLLocation cVLLocation = this.$ghost.getLoc();
                        CVLScope cVLScope = this.$ghost.getScope();
                        Intrinsics.checkNotNull(cVLScope);
                        return cVLExpTypeChecker.typeCheck(exp, CVLTypeEnvironment.Companion.empty(cVLLocation, cVLScope));
                    }
                }));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                axiom = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(axiom.mapExp((Function1<? super CVLExp, ? extends CVLExp>)new Function1<CVLExp, CVLExp>(axiomChecker2){

                    @NotNull
                    public final CVLExp invoke(@NotNull CVLExp p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((GhostUseSubstitutor)this.receiver).expr(p0);
                    }
                }));
            }
            collection = (List)destination$iv$iv;
            cVLGhostDeclaration = CVLGhostFunction.copy$default((CVLGhostFunction)cVLGhostDeclaration2, cVLLocation, (String)((Object)cVLType), cVLFunctionType, collection, false, null, false, 115, null);
        } else if (cVLGhostDeclaration3 instanceof CVLGhostVariable) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv;
            CVLGhostVariable cVLGhostVariable = (CVLGhostVariable)ghost2;
            CVLType cVLType3 = ((CVLGhostVariable)ghost2).getType();
            CVLLocation cVLLocation3 = ghost2.getLoc();
            CVLScope cVLScope = ghost2.getScope();
            Intrinsics.checkNotNull(cVLScope);
            axiomChecker2 = ghost2.getAxioms();
            cVLFunctionType = null;
            cVLType = CVLTypeTypeChecker.typeCheckNoCVLStructTypes$default(this.cvlTypeTypeChecker, cVLType3, cVLLocation3, cVLScope, null, 8, null);
            cVLLocation = null;
            cVLGhostDeclaration2 = cVLGhostVariable;
            boolean $i$f$map = false;
            void $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void axiom;
                item$iv$iv = (CVLGhostAxiom)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(axiom.mapExp((Function1<? super CVLExp, ? extends CVLExp>)new Function1<CVLExp, CVLExp>(this, ghost2){
                    final /* synthetic */ CVLAstTypeChecker this$0;
                    final /* synthetic */ CVLGhostDeclaration $ghost;
                    {
                        this.this$0 = $receiver;
                        this.$ghost = $ghost;
                        super(1);
                    }

                    @NotNull
                    public final CVLExp invoke(@NotNull CVLExp exp) {
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        CVLExpTypeChecker cVLExpTypeChecker = CVLAstTypeChecker.access$getCvlExpTypeChecker$p(this.this$0);
                        CVLLocation cVLLocation = this.$ghost.getLoc();
                        CVLScope cVLScope = this.$ghost.getScope();
                        Intrinsics.checkNotNull(cVLScope);
                        return cVLExpTypeChecker.typeCheck(exp, CVLTypeEnvironment.Companion.empty(cVLLocation, cVLScope));
                    }
                }));
            }
            collection = (List)destination$iv$iv;
            cVLGhostDeclaration = CVLGhostVariable.copy$default(cVLGhostDeclaration2, cVLLocation, cVLType, (String)((Object)cVLFunctionType), (List)collection, null, false, 53, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CVLGhostDeclaration it = cVLGhostDeclaration3 = cVLGhostDeclaration;
        boolean bl = false;
        CVLExpTransformer checkNoCallsInAxiomExp2 = new CVLExpTransformer(this, ghost2){
            final /* synthetic */ CVLAstTypeChecker this$0;
            final /* synthetic */ CVLGhostDeclaration $ghost;
            {
                this.this$0 = $receiver;
                this.$ghost = $ghost;
            }

            @NotNull
            public CVLExp applyExp(@NotNull CVLExp.ApplyExp exp) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                if (exp instanceof CVLExp.ApplyExp.ContractFunction) {
                    CVLErrorLogger cVLErrorLogger = this.this$0.getErrorLogger();
                    String string2 = "axiom for ghost " + this.$ghost.getId() + " may not contain calls to contract functions, but found a call to " + exp.getMethodIdWithCallContext();
                    CVLLocation cVLLocation = exp.getLocOrNull();
                    if (cVLLocation == null) {
                        cVLLocation = this.$ghost.getLoc();
                    }
                    cVLErrorLogger.error(string2, cVLLocation);
                }
                return super.applyExp(exp);
            }
        };
        Iterable $this$map$iv = ghost2.getAxioms();
        boolean $i$f$map = false;
        Iterable $i$f$mapTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it2;
            CVLGhostAxiom cVLGhostAxiom = (CVLGhostAxiom)item$iv$iv3;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(checkNoCallsInAxiomExp2.expr(it2.getExp()));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return cVLGhostDeclaration3;
    }

    /*
     * WARNING - void declaration
     */
    private final CVLDefinition typeCheck(CVLDefinition definition2, CVLTypeEnvironment typeEnv2) {
        void $this$distinctBy$iv;
        void $this$fold$iv;
        Iterable iterable = definition2.getParams();
        boolean $i$f$fold22 = false;
        CVLTypeEnvironment accumulator$iv = typeEnv2;
        for (Object element$iv : $this$fold$iv) {
            void param;
            CVLParam.Named named = (CVLParam.Named)element$iv;
            CVLTypeEnvironment env = accumulator$iv;
            boolean bl = false;
            accumulator$iv = env.pushParam((CVLParam)param);
        }
        CVLTypeEnvironment typeEnv3 = accumulator$iv;
        Iterable $i$f$fold22 = definition2.getParams();
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CVLParam.Named param = (CVLParam.Named)e$iv;
            boolean bl = false;
            String key$iv = param.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        boolean allParamsUnique = ((List)list$iv).size() == definition2.getParams().size();
        CVLFunctionType type = CVLTypeTypeChecker.typeCheck$default(this.cvlTypeTypeChecker, definition2.getType(), typeEnv3.getLoc(), typeEnv3.getScope(), null, 8, null);
        CVLExp body2 = this.cvlExpTypeChecker.typeCheck(definition2.getBody(), typeEnv3);
        if (!(body2.getCVLType() instanceof CVLErrorType || type.getResultType() instanceof CVLErrorType || body2.getCVLType().isConvertibleTo(type.getResultType()))) {
            this.getErrorLogger().error("definition " + definition2.getId() + " return type declared to be " + definition2.getRets() + " but body type inferred to be " + body2.getCVLType(), definition2.getLoc());
        }
        if (!allParamsUnique) {
            this.getErrorLogger().error("all parameters of definition " + definition2.getId() + " must have a unique name", definition2.getLoc());
        }
        return CVLDefinition.copy$default(definition2, null, null, null, type, body2, null, null, null, 231, null);
    }

    private final void typeCheckSlotPattern(CVLHook hook) {
        if (hook.getPattern() instanceof CVLHookPattern.StoragePattern) {
            CVLSlotPattern slot = ((CVLHookPattern.StoragePattern)hook.getPattern()).getSlot();
            String offsetFieldErrorMsg = "Cannot mix named fields and raw offsets in hook patterns";
            String unalignedDynamicErrorMsg = "hook pattern " + slot + " contains a non-word aligned access to a slot that has dynamic children: this is not allowed";
            CVLParam.Named type = hook.getPattern().getValue();
            CVLAstTypeChecker.typeCheckSlotPattern$typeCheckPattern(this, offsetFieldErrorMsg, hook, slot, unalignedDynamicErrorMsg, slot, false, false, (Function1<? super TACStorageType, Unit>)new Function1<TACStorageType, Unit>(this, slot, hook, type){
                final /* synthetic */ CVLAstTypeChecker this$0;
                final /* synthetic */ CVLSlotPattern $slot;
                final /* synthetic */ CVLHook $hook;
                final /* synthetic */ CVLParam.Named $type;
                {
                    this.this$0 = $receiver;
                    this.$slot = $slot;
                    this.$hook = $hook;
                    this.$type = $type;
                    super(1);
                }

                public final void invoke(@NotNull TACStorageType finalType) {
                    boolean bl;
                    Object object;
                    boolean bl2;
                    CVLType fieldType;
                    Intrinsics.checkNotNullParameter(finalType, "finalType");
                    if (!(finalType instanceof TACStorageType.IntegralType)) {
                        this.this$0.getErrorLogger().error("Slot pattern " + this.$slot + " is not a integral type: " + finalType.toErrorString(), this.$hook.getLoc());
                        return;
                    }
                    CVLType cVLType = fieldType = CVLAstTypeChecker.access$typeCheckSlotPattern$getMeTheType(this.this$0, ((TACStorageType.IntegralType)finalType).getTypeLabel());
                    if (cVLType == null) {
                        bl2 = false;
                    } else {
                        object = cVLType;
                        CVLType cVLType2 = this.$type.getType();
                        CVLType p0 = object;
                        boolean bl3 = false;
                        bl2 = cVLType2.matchesAsContractFuncParamWith(p0);
                    }
                    if (!bl2) {
                        this.this$0.getErrorLogger().error("Type mismatch: " + this.$slot + " is declared as type " + ((TACStorageType.IntegralType)finalType).getTypeLabel() + " but " + this.$type.getId() + " is declared as type " + this.$type.getType(), this.$hook.getLoc());
                    }
                    CVLHookPattern.StoragePattern.Store store = (object = this.$hook.getPattern()) instanceof CVLHookPattern.StoragePattern.Store ? (CVLHookPattern.StoragePattern.Store)object : null;
                    if (store == null) {
                        bl = false;
                    } else {
                        CVLParam.Named named = store.getPreviousValue();
                        if (named == null) {
                            bl = false;
                        } else {
                            boolean bl4;
                            CVLParam.Named param = named;
                            boolean bl5 = false;
                            CVLType cVLType3 = fieldType;
                            if (cVLType3 == null) {
                                bl4 = false;
                            } else {
                                CVLType cVLType4 = cVLType3;
                                CVLType cVLType5 = param.getType();
                                CVLType p0 = cVLType4;
                                boolean bl6 = false;
                                bl4 = cVLType5.matchesAsContractFuncParamWith(p0);
                            }
                            bl = !bl4;
                        }
                    }
                    if (bl) {
                        if (!(this.$hook.getPattern() instanceof CVLHookPattern.StoragePattern.Store)) {
                            object = "Check failed.";
                            throw new IllegalStateException(object.toString());
                        }
                        CVLErrorLogger cVLErrorLogger = this.this$0.getErrorLogger();
                        CVLSlotPattern cVLSlotPattern = ((CVLHookPattern.StoragePattern.Store)this.$hook.getPattern()).getSlot();
                        String string2 = ((TACStorageType.IntegralType)finalType).getTypeLabel();
                        CVLParam.Named named = ((CVLHookPattern.StoragePattern.Store)this.$hook.getPattern()).getPreviousValue();
                        Intrinsics.checkNotNull(named);
                        cVLErrorLogger.error("Type mismatch: " + cVLSlotPattern + " is declared as type " + string2 + ", but previous value " + named.getId() + " is declared as type " + ((CVLHookPattern.StoragePattern.Store)this.$hook.getPattern()).getPreviousValue().getType(), this.$hook.getLoc());
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CVLHook typeCheck(CVLHook hook) {
        void $this$onEach$iv;
        void var5_7;
        CVLCmd cmd;
        Collection<CVLCmd> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object paramType;
        CVLHookPattern cVLHookPattern = hook.getPattern();
        if (cVLHookPattern instanceof CVLHookPattern.StoragePattern) {
            this.typeCheckSlotPattern(hook);
        } else if (cVLHookPattern instanceof CVLHookPattern.Create && !((CVLType)(paramType = hook.getPattern().getValue().getType())).isAddress()) {
            this.getErrorLogger().error("Create hook argument must be an address, instead got " + (CVLType)paramType + " at " + hook.getLoc(), hook.getLoc());
        }
        CVLExpTransformer expTransformer2 = new CVLExpTransformer(this){
            final /* synthetic */ CVLAstTypeChecker this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public CVLExp applyExp(@NotNull CVLExp.ApplyExp exp) {
                block1: {
                    CVLExp.ApplyExp applyExp;
                    block0: {
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        applyExp = exp;
                        if (!(applyExp instanceof CVLExp.ApplyExp.CVLFunction)) break block0;
                        CVLLocation cVLLocation = exp.getTag().getLoc();
                        Intrinsics.checkNotNull(cVLLocation);
                        this.this$0.syntaxError(cVLLocation, "Hooks may not call CVL Functions");
                        break block1;
                    }
                    if (!(applyExp instanceof CVLExp.ApplyExp.ContractFunction)) break block1;
                    CVLLocation cVLLocation = exp.getTag().getLoc();
                    Intrinsics.checkNotNull(cVLLocation);
                    this.this$0.syntaxError(cVLLocation, "Hooks may not call Contract Functions");
                }
                return super.applyExp(exp);
            }
        };
        boolean $i$a$-let-CVLAstTypeChecker$typeCheck$noFunctionCallChecker$32 = false;
        CVLCmdTransformer noFunctionCallChecker2 = new CVLCmdTransformer(expTransformer2);
        paramType = hook.getBlock();
        CVLHookPattern cVLHookPattern2 = null;
        CVLHook cVLHook = hook;
        boolean $i$f$map = false;
        void $i$a$-let-CVLAstTypeChecker$typeCheck$noFunctionCallChecker$32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CVLCmd cVLCmd = (CVLCmd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cvlCmdTypeChecker.typeCheck(cmd));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var5_7 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            cmd = (CVLCmd)element$iv;
            boolean bl2 = false;
            noFunctionCallChecker2.cmd(cmd);
        }
        collection = var5_7;
        return CVLHook.copy$default(cVLHook, cVLHookPattern2, (List)collection, null, null, 13, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ContractFunction typeCheck(ContractFunction contractFunction, Set<SighashInt> ambiguousSighashes, CVLTypeEnvironment typeEnv2) {
        ContractFunction contractFunction2;
        MethodSignature methodSignature;
        Iterable param;
        Object object;
        ContractFunction contractFunction3 = contractFunction;
        CVLLocation cVLLocation = null;
        if (contractFunction.getMethodSignature() instanceof MethodSignature.Named) {
            Collection<Iterable> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = ((MethodSignature.Named)contractFunction.getMethodSignature()).getParams();
            MethodReference methodReference = null;
            CVLLocation cVLLocation2 = null;
            MethodSignature.Named named = (MethodSignature.Named)contractFunction.getMethodSignature();
            CVLLocation cVLLocation3 = cVLLocation;
            ContractFunction contractFunction4 = contractFunction3;
            boolean $i$f$map = false;
            void var7_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CVLParam cVLParam = (CVLParam)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CVLType type = ((CVLParam)((Object)param)).getType();
                collection.add((Iterable)(type instanceof CVLSimpleType.Inbuilt.EvmType ? param : (type instanceof CVLStructType ? ((CVLParam)((Object)param)).withType(CVLSimpleType.Companion.buildSimpleType$Shared(((CVLStructType)type).toEVMStructType())) : (type instanceof CVLEnumType ? ((CVLParam)((Object)param)).withType(CVLSimpleType.Companion.buildSimpleType$Shared(CVLInbuiltSimpleTypes.Companion.uint(8))) : ((CVLParam)((Object)param)).withType(this.typeError(new CVLExp.VariableExp(param.toString(), false, 2, null), contractFunction.getLoc(), "bad method parameter type: " + type))))));
            }
            collection = (List)destination$iv$iv;
            contractFunction3 = contractFunction4;
            cVLLocation = cVLLocation3;
            methodSignature = MethodSignature.Named.copy$default(named, cVLLocation2, methodReference, (List)collection, null, null, 27, null);
        } else {
            methodSignature = contractFunction.getMethodSignature();
        }
        import = ContractFunction.copy$default(contractFunction3, cVLLocation, methodSignature, false, false, false, false, null, null, null, null, 1021, null);
        object = import.getSummary();
        if (object == null) {
            contractFunction2 = import;
        } else {
            ContractFunction contractFunction5;
            void $this$mapTo$iv$iv;
            Object summary = object;
            boolean bl = false;
            MethodSignature methodSignature2 = import.getMethodSignature();
            if (methodSignature2 instanceof MethodSignature.Hashed) {
                if (!SighashInt.Companion.isValid(((MethodSignature.Hashed)import.getMethodSignature()).getSighash())) {
                    this.getErrorLogger().error("The provided sighash is invalid: " + SighashInt.Companion.badSigHash(((MethodSignature.Hashed)import.getMethodSignature()).getSighash()), ((SpecCallSummary)summary).getLoc());
                }
            } else if (methodSignature2 instanceof MethodSignature.Named) {
                // empty if block
            }
            Iterable $this$map$iv = ambiguousSighashes;
            boolean $i$f$map = false;
            param = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SighashInt sighashInt = (SighashInt)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getN());
            }
            if (((List)destination$iv$iv).contains(import.getSigHash())) {
                this.syntaxError(import.getLoc(), "Impossible to summarize " + import.getMethodSignature() + ". Though the function " + import.getMethodSignature() + " may be unique by solidity internal typing rules, CVT must use external typing rules and is unable to resolve which function to actually summarize.");
            }
            Lazy params$delegate = LazyKt.lazy((Function0)new Function0<List<? extends CVLParam>>(import, this, (SpecCallSummary)summary){
                final /* synthetic */ ContractFunction $import;
                final /* synthetic */ CVLAstTypeChecker this$0;
                final /* synthetic */ SpecCallSummary $summary;
                {
                    this.$import = $import;
                    this.this$0 = $receiver;
                    this.$summary = $summary;
                    super(0);
                }

                @Nullable
                public final List<CVLParam> invoke() {
                    List<CVLParam> list;
                    MethodSignature methodSignature = this.$import.getMethodSignature();
                    MethodSignature.Named named = methodSignature instanceof MethodSignature.Named ? (MethodSignature.Named)methodSignature : null;
                    if (named == null) {
                        list = null;
                    } else {
                        methodSignature = named;
                        CVLAstTypeChecker cVLAstTypeChecker = this.this$0;
                        SpecCallSummary specCallSummary = this.$summary;
                        MethodSignature sig = methodSignature;
                        boolean bl = false;
                        Iterable $this$forEach$iv = ((MethodSignature.Named)sig).getParams();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CVLParam param = (CVLParam)element$iv;
                            boolean bl2 = false;
                            CVLType type = param.getType();
                            if (type instanceof CVLSimpleType && type.isPrimitiveType()) continue;
                            cVLAstTypeChecker.syntaxError(specCallSummary.getLoc(), "Found a non-simple type (" + type + ") in an EXP summary: currently EXP summaries only support parameters with simple types.");
                        }
                        list = ((MethodSignature.Named)sig).getParams();
                    }
                    List<CVLParam> params2 = list;
                    return params2;
                }
            });
            Lazy namedParams$delegate = LazyKt.lazy((Function0)new Function0<List<CVLParam.Named>>(params$delegate){
                final /* synthetic */ Lazy<List<CVLParam>> $params$delegate;
                {
                    this.$params$delegate = $params$delegate;
                    super(0);
                }

                @NotNull
                public final List<CVLParam.Named> invoke() {
                    List namedParams2 = new ArrayList<E>();
                    List list = CVLAstTypeChecker.access$typeCheck$lambda-68$lambda-62(this.$params$delegate);
                    if (list != null) {
                        Iterable $this$mapNotNullTo$iv = list;
                        boolean $i$f$mapNotNullTo = false;
                        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            CVLParam.Named it$iv;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator2.next();
                            boolean bl = false;
                            CVLParam it = (CVLParam)element$iv;
                            boolean bl2 = false;
                            if ((it instanceof CVLParam.Named ? (CVLParam.Named)it : null) == null) continue;
                            it$iv = it$iv;
                            boolean bl3 = false;
                            ((Collection)namedParams2).add(it$iv);
                        }
                        List cfr_ignored_0 = (List)((Collection)namedParams2);
                    }
                    return namedParams2;
                }
            });
            Lazy<CVLTypeEnvironment> pushedTypeEnv$delegate = LazyKt.lazy((Function0)new Function0<CVLTypeEnvironment>(typeEnv2, namedParams$delegate){
                final /* synthetic */ CVLTypeEnvironment $typeEnv;
                final /* synthetic */ Lazy<List<CVLParam.Named>> $namedParams$delegate;
                {
                    this.$typeEnv = $typeEnv;
                    this.$namedParams$delegate = $namedParams$delegate;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final CVLTypeEnvironment invoke() {
                    void $this$fold$iv;
                    Iterable iterable = CVLAstTypeChecker.access$typeCheck$lambda-68$lambda-63(this.$namedParams$delegate);
                    CVLTypeEnvironment initial$iv = this.$typeEnv;
                    boolean $i$f$fold = false;
                    CVLTypeEnvironment accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void param;
                        CVLParam.Named named = (CVLParam.Named)element$iv;
                        CVLTypeEnvironment env = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = env.pushParam((CVLParam)param);
                    }
                    return accumulator$iv;
                }
            });
            Object object2 = summary;
            if (object2 instanceof SpecCallSummary.Exp) {
                if (!((Collection)((SpecCallSummary.Exp)summary).getWithParams()).isEmpty()) {
                    this.syntaxError(((SpecCallSummary)summary).getLoc(), "Specifying environment for expression/ghost summaries is currently unsupported");
                }
                contractFunction5 = ContractFunction.copy$default(import, null, null, false, false, false, false, null, null, SpecCallSummary.Exp.copy$default((SpecCallSummary.Exp)summary, false, CVLAstTypeChecker.typeCheck$lambda-68$checkReturnType(import, this, CVLAstTypeChecker.typeCheck$lambda-68$typecheckSummaryExp(this, (SpecCallSummary)summary, pushedTypeEnv$delegate, ((SpecCallSummary.Exp)summary).getExp())), CVLAstTypeChecker.typeCheck$lambda-68$lambda-62(params$delegate), null, null, 25, null), null, 767, null);
            } else if (object2 instanceof SpecCallSummary.Dispatcher) {
                if (((SpecCallSummary)summary).getSummarizeAllCalls()) {
                    this.getErrorLogger().error("A summary ALL is not allowed for dispatcher summaries, please remove the ALL keyword or add the UNRESOLVED for the summary " + (SpecCallSummary)summary, ((SpecCallSummary)summary).getLoc());
                }
                contractFunction5 = import;
            } else if (object2 instanceof SpecCallSummary.Always) {
                CVLExp.Constant cTypeChecked = (CVLExp.Constant)this.cvlExpTypeChecker.typeCheck(((SpecCallSummary.Always)summary).getConstant(), typeEnv2);
                contractFunction5 = ContractFunction.copy$default(import, null, null, false, false, false, false, null, null, SpecCallSummary.Always.copy$default((SpecCallSummary.Always)summary, (CVLExp.Constant)CVLAstTypeChecker.typeCheck$lambda-68$checkReturnType(import, this, cTypeChecked), false, null, 6, null), null, 767, null);
            } else if (((object2 instanceof SpecCallSummary.HavocSummary ? true : object2 instanceof SpecCallSummary.Constant) ? true : object2 instanceof SpecCallSummary.PerCalleeConstant) ? true : object2 instanceof SpecCallSummary.Command) {
                contractFunction5 = import;
            } else {
                if (Intrinsics.areEqual(object2, SpecCallSummary.OptimisticFallback.INSTANCE)) {
                    throw new IllegalStateException("Explicitly selecting the optimistic fallback is not supported");
                }
                throw new NoWhenBranchMatchedException();
            }
            ContractFunction contractFunction6 = contractFunction5;
            contractFunction2 = contractFunction6 == null ? import : contractFunction6;
        }
        return contractFunction2;
    }

    @Override
    public void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        HasCVLErrorLogger.DefaultImpls.syntaxError(this, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLLhs lhs, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, lhs, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, exp, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc) {
        return HasCVLErrorLogger.DefaultImpls.typeError(this, exp, loc);
    }

    private static final boolean typecheck$allPathsReturn(CVLFunction $sub, CVLAstTypeChecker this$0) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $sub.getBlock();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CVLCmd cmd = (CVLCmd)element$iv;
                    boolean bl2 = false;
                    if (!this$0.allPathsReturn(cmd)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Function1<TACStorageType, Unit> typeCheckSlotPattern$extend(Function1<? super TACStorageType, Unit> $this$typeCheckSlotPattern_u24extend, Function2<? super TACStorageType, ? super Function1<? super TACStorageType, Unit>, Unit> k) {
        Function1 function1;
        Function1<? super TACStorageType, Unit> function12 = $this$typeCheckSlotPattern_u24extend;
        if (function12 == null) {
            function1 = null;
        } else {
            Function1<? super TACStorageType, Unit> c = function12;
            boolean bl = false;
            function1 = new Function1<TACStorageType, Unit>(k, c){
                final /* synthetic */ Function2<TACStorageType, Function1<? super TACStorageType, Unit>, Unit> $k;
                final /* synthetic */ Function1<TACStorageType, Unit> $c;
                {
                    this.$k = $k;
                    this.$c = $c;
                    super(1);
                }

                public final void invoke(@NotNull TACStorageType storage2) {
                    Intrinsics.checkNotNullParameter(storage2, "storage");
                    this.$k.invoke(storage2, this.$c);
                }
            };
        }
        return function1;
    }

    private static final CVLType typeCheckSlotPattern$getMeTheType(CVLAstTypeChecker this$0, String typeName) {
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes = CVLInbuiltSimpleTypes.Companion.valueFromString(typeName);
        CVLSimpleType.Inbuilt inbuilt = cVLInbuiltSimpleTypes == null ? null : cVLInbuiltSimpleTypes.getCvlType();
        return inbuilt == null ? this$0.symbolTable.getTypeFromCanonicalName(typeName) : (CVLType)inbuilt;
    }

    private static final void typeCheckSlotPattern$typeCheckPattern(CVLAstTypeChecker this$0, String offsetFieldErrorMsg, CVLHook $hook, CVLSlotPattern slot, String unalignedDynamicErrorMsg, CVLSlotPattern pattern, boolean seenDynamicType, boolean seenFields, Function1<? super TACStorageType, Unit> checkCont) {
        CVLAstTypeChecker cVLAstTypeChecker = this$0;
        String string2 = offsetFieldErrorMsg;
        CVLHook cVLHook = $hook;
        CVLSlotPattern cVLSlotPattern = slot;
        String string3 = unalignedDynamicErrorMsg;
        CVLSlotPattern cVLSlotPattern2 = pattern;
        boolean bl = seenDynamicType;
        boolean bl2 = seenFields;
        Function1<TACStorageType, Unit> function1 = checkCont;
        while (true) {
            CVLSlotPattern cVLSlotPattern3;
            boolean bl3;
            boolean bl4;
            CVLSlotPattern cVLSlotPattern4;
            String string4;
            CVLSlotPattern cVLSlotPattern5;
            CVLHook cVLHook2;
            String string5;
            CVLAstTypeChecker cVLAstTypeChecker2;
            block14: {
                Function1<TACStorageType, Unit> function12;
                block15: {
                    String string6;
                    CVLAstTypeChecker $this$typeCheckSlotPattern_u24typeCheckPattern_u24lambda_u2d55;
                    block17: {
                        String hint;
                        String baseMsg;
                        CVLSymbolTable.SymbolInfo contractSymbol;
                        block16: {
                            cVLAstTypeChecker2 = cVLAstTypeChecker;
                            string5 = string2;
                            cVLHook2 = cVLHook;
                            cVLSlotPattern5 = cVLSlotPattern;
                            string4 = string3;
                            cVLSlotPattern4 = cVLSlotPattern2;
                            bl4 = bl;
                            bl3 = bl2;
                            function12 = function1;
                            cVLSlotPattern3 = cVLSlotPattern4;
                            if (cVLSlotPattern3 instanceof CVLSlotPattern.ArrayAccess) {
                                cVLAstTypeChecker = cVLAstTypeChecker2;
                                string2 = string5;
                                cVLHook = cVLHook2;
                                cVLSlotPattern = cVLSlotPattern5;
                                string3 = string4;
                                cVLSlotPattern2 = ((CVLSlotPattern.ArrayAccess)cVLSlotPattern4).getBase();
                                bl = true;
                                bl2 = bl3;
                                function1 = CVLAstTypeChecker.typeCheckSlotPattern$extend(function12, (Function2<? super TACStorageType, ? super Function1<? super TACStorageType, Unit>, Unit>)new Function2<TACStorageType, Function1<? super TACStorageType, ? extends Unit>, Unit>(cVLAstTypeChecker2, cVLSlotPattern4, cVLHook2){
                                    final /* synthetic */ CVLAstTypeChecker this$0;
                                    final /* synthetic */ CVLSlotPattern $pattern;
                                    final /* synthetic */ CVLHook $hook;
                                    {
                                        this.this$0 = $receiver;
                                        this.$pattern = $pattern;
                                        this.$hook = $hook;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull TACStorageType tacStorageType, @NotNull Function1<? super TACStorageType, Unit> nxt) {
                                        Intrinsics.checkNotNullParameter(tacStorageType, "tacStorageType");
                                        Intrinsics.checkNotNullParameter(nxt, "nxt");
                                        TACStorageType tACStorageType = tacStorageType;
                                        if (tACStorageType instanceof TACStorageType.Array) {
                                            nxt.invoke(((TACStorageType.Array)tacStorageType).getElementType());
                                        } else if (tACStorageType instanceof TACStorageType.StaticArray) {
                                            nxt.invoke(((TACStorageType.StaticArray)tacStorageType).getElementType());
                                        } else {
                                            this.this$0.getErrorLogger().error("Expected an array-like object at " + ((CVLSlotPattern.ArrayAccess)this.$pattern).getBase() + ", found " + tacStorageType.toErrorString(), this.$hook.getLoc());
                                        }
                                    }
                                });
                                continue;
                            }
                            if (cVLSlotPattern3 instanceof CVLSlotPattern.FieldAccess) {
                                if (function12 == null) {
                                    cVLAstTypeChecker2.getErrorLogger().error(string5, cVLHook2.getLoc());
                                    return;
                                }
                                cVLAstTypeChecker = cVLAstTypeChecker2;
                                string2 = string5;
                                cVLHook = cVLHook2;
                                cVLSlotPattern = cVLSlotPattern5;
                                string3 = string4;
                                cVLSlotPattern2 = ((CVLSlotPattern.FieldAccess)cVLSlotPattern4).getBase();
                                bl = bl4;
                                bl2 = true;
                                function1 = new Function1<TACStorageType, Unit>(cVLSlotPattern4, cVLAstTypeChecker2, cVLHook2, function12){
                                    final /* synthetic */ CVLSlotPattern $pattern;
                                    final /* synthetic */ CVLAstTypeChecker this$0;
                                    final /* synthetic */ CVLHook $hook;
                                    final /* synthetic */ Function1<TACStorageType, Unit> $checkCont;
                                    {
                                        this.$pattern = $pattern;
                                        this.this$0 = $receiver;
                                        this.$hook = $hook;
                                        this.$checkCont = $checkCont;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull TACStorageType it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        if (!(it instanceof TACStorageType.Struct) || !((TACStorageType.Struct)it).getMembers().containsKey(((CVLSlotPattern.FieldAccess)this.$pattern).getField())) {
                                            this.this$0.getErrorLogger().error("Expected a struct with field " + ((CVLSlotPattern.FieldAccess)this.$pattern).getField() + " at path " + ((CVLSlotPattern.FieldAccess)this.$pattern).getBase() + ", found " + it.toErrorString(), this.$hook.getLoc());
                                        } else {
                                            StructField structField = ((TACStorageType.Struct)it).getMembers().get(((CVLSlotPattern.FieldAccess)this.$pattern).getField());
                                            Intrinsics.checkNotNull(structField);
                                            this.$checkCont.invoke(structField.getType());
                                        }
                                    }
                                };
                                continue;
                            }
                            if (cVLSlotPattern3 instanceof CVLSlotPattern.MapAccess) {
                                cVLAstTypeChecker = cVLAstTypeChecker2;
                                string2 = string5;
                                cVLHook = cVLHook2;
                                cVLSlotPattern = cVLSlotPattern5;
                                string3 = string4;
                                cVLSlotPattern2 = ((CVLSlotPattern.MapAccess)cVLSlotPattern4).getBase();
                                bl = true;
                                bl2 = bl3;
                                function1 = CVLAstTypeChecker.typeCheckSlotPattern$extend((Function1<? super TACStorageType, Unit>)function12, (Function2<? super TACStorageType, ? super Function1<? super TACStorageType, Unit>, Unit>)new Function2<TACStorageType, Function1<? super TACStorageType, ? extends Unit>, Unit>(cVLAstTypeChecker2, cVLSlotPattern4, cVLHook2){
                                    final /* synthetic */ CVLAstTypeChecker this$0;
                                    final /* synthetic */ CVLSlotPattern $pattern;
                                    final /* synthetic */ CVLHook $hook;
                                    {
                                        this.this$0 = $receiver;
                                        this.$pattern = $pattern;
                                        this.$hook = $hook;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull TACStorageType ty, @NotNull Function1<? super TACStorageType, Unit> nxt) {
                                        Intrinsics.checkNotNullParameter(ty, "ty");
                                        Intrinsics.checkNotNullParameter(nxt, "nxt");
                                        if (!(ty instanceof TACStorageType.Mapping)) {
                                            this.this$0.getErrorLogger().error("Expected mapping type at " + ((CVLSlotPattern.MapAccess)this.$pattern).getBase() + ", found " + ty.toErrorString(), this.$hook.getLoc());
                                            return;
                                        }
                                        if (((TACStorageType.Mapping)ty).getKeyType() instanceof TACStorageType.IntegralType) {
                                            CVLType cVLType = CVLAstTypeChecker.access$typeCheckSlotPattern$getMeTheType(this.this$0, ((TACStorageType.IntegralType)((TACStorageType.Mapping)ty).getKeyType()).getTypeLabel());
                                            if (!(cVLType == null ? false : cVLType.matchesAsContractFuncParamWith(((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType()))) {
                                                this.this$0.getErrorLogger().error("Type mismatch: keys to " + ((CVLSlotPattern.MapAccess)this.$pattern).getBase() + " should have type " + ((TACStorageType.IntegralType)((TACStorageType.Mapping)ty).getKeyType()).getTypeLabel() + " but " + ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getId() + " has type " + ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType(), this.$hook.getLoc());
                                            }
                                        } else if (((TACStorageType.Mapping)ty).getKeyType() instanceof TACStorageType.Bytes) {
                                            if (!(Intrinsics.areEqual(((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType(), CVLInbuiltSimpleTypes.bytesblob.INSTANCE.getCvlType()) || ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType().matchesAsContractFuncParamWith(CVLInbuiltSimpleTypes.bytes.INSTANCE.getCvlType()) || ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType().matchesAsContractFuncParamWith(CVLInbuiltSimpleTypes.string.INSTANCE.getCvlType()))) {
                                                this.this$0.getErrorLogger().error("Type mismatch: keys to " + ((CVLSlotPattern.MapAccess)this.$pattern).getBase() + " should have type string/bytes, but " + ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getId() + " has type " + ((CVLSlotPattern.MapAccess)this.$pattern).getKey().getType(), this.$hook.getLoc());
                                            }
                                        } else {
                                            this.this$0.getErrorLogger().error("Trying to use hooks on non-integral key type " + ((TACStorageType.Mapping)ty).getKeyType() + " at " + ((CVLSlotPattern.MapAccess)this.$pattern).getBase(), this.$hook.getLoc());
                                            return;
                                        }
                                        nxt.invoke(((TACStorageType.Mapping)ty).getValueType());
                                    }
                                });
                                continue;
                            }
                            if (!(cVLSlotPattern3 instanceof CVLSlotPattern.Static)) break block14;
                            if (!(((CVLSlotPattern.Static)cVLSlotPattern4).getSolidityContract() instanceof SolidityContract.Named)) break block15;
                            $this$typeCheckSlotPattern_u24typeCheckPattern_u24lambda_u2d55 = cVLAstTypeChecker2;
                            boolean bl5 = false;
                            SolidityContract contract = ((CVLSlotPattern.Static)cVLSlotPattern4).getSolidityContract();
                            CVLSymbolTable cVLSymbolTable = $this$typeCheckSlotPattern_u24typeCheckPattern_u24lambda_u2d55.symbolTable;
                            String string7 = contract.getName();
                            CVLScope cVLScope = cVLHook2.getScope();
                            Intrinsics.checkNotNull(cVLScope);
                            contractSymbol = cVLSymbolTable.lookUpNonFunctionLikeSymbol(string7, cVLScope);
                            baseMsg = "hook contract '" + contract.getName() + "' must be an imported contract (using contract_name as Contract)";
                            hint = "Did you mean currentContract." + contract.getName() + "?";
                            if (contractSymbol != null) break block16;
                            string6 = baseMsg + " but is undefined. " + hint;
                            break block17;
                        }
                        if (contractSymbol.getHook() instanceof CVLImportedContract) break block15;
                        string6 = baseMsg + " but is bound as something else. " + hint;
                    }
                    String fullMsg = string6;
                    $this$typeCheckSlotPattern_u24typeCheckPattern_u24lambda_u2d55.getErrorLogger().error(fullMsg, cVLHook2.getLoc());
                    return;
                }
                if (bl3 && !(cVLSlotPattern4 instanceof CVLSlotPattern.Static.Named)) {
                    cVLAstTypeChecker2.getErrorLogger().error("Used named fields in " + cVLSlotPattern5 + ", but base slot is not named: hook patterns that use struct field names must refer to storage slots by name instead of slot number", cVLHook2.getLoc());
                }
                if (bl4 && cVLSlotPattern4 instanceof CVLSlotPattern.Static.Indexed && !Intrinsics.areEqual(((CVLSlotPattern.Static.Indexed)cVLSlotPattern4).getOffset().getN(), BigInteger.ZERO)) {
                    cVLAstTypeChecker2.getErrorLogger().error(string4, cVLHook2.getLoc());
                }
                if (!(cVLSlotPattern4 instanceof CVLSlotPattern.Static.Named)) break;
                CVLScope contractScope = cVLAstTypeChecker2.symbolTable.getContractScope(((CVLSlotPattern.Static)cVLSlotPattern4).getSolidityContract());
                CVLSymbolTable cVLSymbolTable = cVLAstTypeChecker2.symbolTable;
                String string8 = ((CVLSlotPattern.Static.Named)cVLSlotPattern4).getName();
                CVLScope cVLScope = contractScope;
                Intrinsics.checkNotNull(cVLScope);
                CVLSymbolTable.SymbolInfo symbol = cVLSymbolTable.lookUpNonFunctionLikeSymbol(string8, cVLScope);
                if (symbol == null || !symbol.isParam() || !Intrinsics.areEqual(symbol.getCVLType(), CVLInbuiltSimpleTypes.int.INSTANCE.getCvlType()) && !(symbol.getCVLType() instanceof CVLStorageType)) {
                    cVLAstTypeChecker2.getErrorLogger().error("named pattern root '" + ((CVLSlotPattern.Static.Named)cVLSlotPattern4).getName() + "' is not defined: did you spell something wrong? Note, named slots are only supported from solc 0.5.13 onward.", cVLHook2.getLoc());
                    break;
                }
                if (bl3 && !(symbol.getCVLType() instanceof CVLStorageType)) {
                    cVLAstTypeChecker2.getErrorLogger().error("Pattern uses fields, but named storage fields are not available (support is available only from solc 0.5.13 onward", cVLHook2.getLoc());
                    break;
                }
                if (function12 == null) break;
                CVLType cVLType = symbol.getCVLType();
                CVLStorageType cVLStorageType = cVLType instanceof CVLStorageType ? (CVLStorageType)cVLType : null;
                if (cVLStorageType == null) break;
                TACStorageType tACStorageType = cVLStorageType.getWrapped();
                if (tACStorageType == null) break;
                TACStorageType tACStorageType2 = tACStorageType;
                function12.invoke(tACStorageType2);
                break;
            }
            if (!(cVLSlotPattern3 instanceof CVLSlotPattern.StructAccess)) break;
            if (bl3) {
                cVLAstTypeChecker2.getErrorLogger().error(string5, cVLHook2.getLoc());
                return;
            }
            if (!Intrinsics.areEqual(((CVLSlotPattern.StructAccess)cVLSlotPattern4).getOffset().getN().mod(EVMConstsKt.getEVM_WORD_SIZE()), BigInteger.ZERO) && bl4) {
                cVLAstTypeChecker2.getErrorLogger().error(string4, cVLHook2.getLoc());
            }
            cVLAstTypeChecker = cVLAstTypeChecker2;
            string2 = string5;
            cVLHook = cVLHook2;
            cVLSlotPattern = cVLSlotPattern5;
            string3 = string4;
            cVLSlotPattern2 = ((CVLSlotPattern.StructAccess)cVLSlotPattern4).getBase();
            bl = bl4;
            bl2 = false;
            function1 = null;
        }
    }

    private static final CVLExp typeCheck$lambda-68$checkReturnType(ContractFunction contractFunction, CVLAstTypeChecker this$0, CVLExp exp) {
        CVLExp cVLExp;
        boolean bl;
        CVLType cVLType = contractFunction.retsOrNull();
        if (cVLType == null) {
            bl = false;
        } else {
            CVLType rets = cVLType;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual(rets, CVLVoidType.INSTANCE);
        }
        if (bl) {
            CVLTypeConversions.TypeConversion rhsConverted = CVLTypeConversions.INSTANCE.convertTypeIfPossible(exp, contractFunction.getRets());
            if (rhsConverted instanceof CVLTypeConversions.TypeConversion.Success) {
                cVLExp = rhsConverted.getExp();
            } else {
                String string2 = ((CVLTypeConversions.TypeConversion.Error)rhsConverted).getMsg();
                String message = string2 == null ? "could not convert type of summary (" + exp.getCVLType() + ") to type of (" + contractFunction.getRets() + ") in summary declaration " + contractFunction.toFullDecSignature() : string2;
                cVLExp = exp.updateTag(new CVLExpTag(this$0.typeError(exp, contractFunction.getLoc(), message)));
            }
        } else {
            cVLExp = exp;
        }
        return cVLExp;
    }

    private static final List<CVLParam> typeCheck$lambda-68$lambda-62(Lazy<? extends List<? extends CVLParam>> $params$delegate) {
        Lazy<? extends List<? extends CVLParam>> lazy = $params$delegate;
        return lazy.getValue();
    }

    private static final List<CVLParam.Named> typeCheck$lambda-68$lambda-63(Lazy<? extends List<CVLParam.Named>> $namedParams$delegate) {
        Lazy<? extends List<CVLParam.Named>> lazy = $namedParams$delegate;
        return lazy.getValue();
    }

    private static final CVLTypeEnvironment typeCheck$lambda-68$lambda-64(Lazy<CVLTypeEnvironment> $pushedTypeEnv$delegate) {
        Lazy<CVLTypeEnvironment> lazy = $pushedTypeEnv$delegate;
        return lazy.getValue();
    }

    private static final CVLExp typeCheck$lambda-68$typecheckSummaryExp(CVLAstTypeChecker this$0, SpecCallSummary $summary, Lazy<CVLTypeEnvironment> pushedTypeEnv$delegate, CVLExp exp) {
        CVLExp toRet;
        block14: {
            block15: {
                boolean bl;
                block13: {
                    CVLExp exp2 = this$0.cvlExpTypeChecker.typeCheck(exp, CVLAstTypeChecker.typeCheck$lambda-68$lambda-64(pushedTypeEnv$delegate));
                    boolean bl2 = false;
                    toRet = exp2.updateType(exp2.getCVLType().enumsBegone());
                    if (!(toRet instanceof CVLExp.ApplyExp.Ghost) && !(toRet instanceof CVLExp.ApplyExp.CVLFunction)) {
                        this$0.typeError(toRet, $summary.getLoc(), "Currently only a ghost function or CVL Function may be used as a summary, not " + toRet);
                    }
                    CVLType cVLType = toRet.getTag().getType();
                    if ((cVLType == null ? false : cVLType.isPrimitiveType()) || toRet.getTag().getType() instanceof CVLEnumType) break block14;
                    if (!(toRet.getTag().getType() instanceof CVLStructType)) break block15;
                    CVLType cVLType2 = toRet.getTag().getType();
                    if (cVLType2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLStructType");
                    }
                    Iterable $this$all$iv = ((CVLStructType)cVLType2).getEntries();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CVLStructType.StructEntry it = (CVLStructType.StructEntry)element$iv;
                            boolean bl3 = false;
                            if (it.getType().isPrimitiveType()) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (bl) break block14;
            }
            if (Intrinsics.areEqual(toRet.getTag().getType(), CVLVoidType.INSTANCE)) {
                StandardCVLErrorLogger.INSTANCE.warn("Using a function without return types as a summary can cause unpredictable behavior", toRet.getLocOrEmpty());
            } else {
                this$0.typeError(toRet, $summary.getLoc(), "A summary must return a simple type or a struct of simple types, but " + toRet + " returns '" + toRet.getTag().getType() + "'");
            }
        }
        if (toRet instanceof CVLExp.ApplyExp) {
            Iterable $this$forEach$iv = ((CVLExp.ApplyExp)toRet).getArgs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CVLExp arg = (CVLExp)element$iv;
                boolean bl = false;
                if (arg instanceof CVLExp.VariableExp || arg instanceof CVLExp.Constant.NumberLit) continue;
                this$0.typeError(toRet, $summary.getLoc(), "Arg " + arg + " of summary " + $summary + " must be either a variable or a constant.");
            }
        }
        return toRet;
    }

    public static final /* synthetic */ CVLType access$typeCheckSlotPattern$getMeTheType(CVLAstTypeChecker this$0, String typeName) {
        return CVLAstTypeChecker.typeCheckSlotPattern$getMeTheType(this$0, typeName);
    }

    public static final /* synthetic */ CVLCmdTypeChecker access$getCvlCmdTypeChecker$p(CVLAstTypeChecker $this) {
        return $this.cvlCmdTypeChecker;
    }

    public static final /* synthetic */ CVLExpTypeChecker access$getCvlExpTypeChecker$p(CVLAstTypeChecker $this) {
        return $this.cvlExpTypeChecker;
    }

    public static final /* synthetic */ List access$typeCheck$lambda-68$lambda-62(Lazy $params$delegate) {
        return CVLAstTypeChecker.typeCheck$lambda-68$lambda-62($params$delegate);
    }

    public static final /* synthetic */ List access$typeCheck$lambda-68$lambda-63(Lazy $namedParams$delegate) {
        return CVLAstTypeChecker.typeCheck$lambda-68$lambda-63($namedParams$delegate);
    }
}

