/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.AmbiguousArg;
import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.MethodReferenceExp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java_cup.runtime.ComplexSymbolFactory;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLLocation;
import spec.cvlast.MethodIdWithCallContext;
import spec.cvlast.TwoStateIndex;

public class InvokeCmd
extends Cmd {
    public MethodReferenceExp methodReference;
    public List<Exp> expList;
    public boolean noRevert;
    public Exp storage;
    public boolean onlyEnvFree;
    public boolean isWhole;

    public InvokeCmd(String _specFile, ComplexSymbolFactory.Location _loc, MethodReferenceExp _m, List<Exp> _expList, boolean _noRevert, Exp _storage, boolean _isWhole) {
        this(_specFile, _loc, _m, _expList, _noRevert, _storage, false, false, _isWhole);
    }

    public InvokeCmd(String _specFile, ComplexSymbolFactory.Location _loc, MethodReferenceExp _m, List<Exp> _expList, boolean _noRevert, Exp _storage, boolean _withPayment, boolean _onlyEnvFree, boolean _isWhole) {
        super(_specFile, _loc);
        this.expList = _expList;
        this.methodReference = _m;
        this.noRevert = _noRevert;
        this.storage = _storage;
        this.onlyEnvFree = _onlyEnvFree;
        this.isWhole = _isWhole;
    }

    public String toString() {
        Stream<String> expListToString = this.expList.stream().map(Objects::toString);
        String methodRef = this.methodReference.toString();
        if (this.noRevert) {
            return String.format(methodRef, expListToString.reduce("", (S, s) -> S + ", " + s), this.storage, this.onlyEnvFree);
        }
        return String.format(methodRef, expListToString.reduce("", (S, s) -> S + ", " + s), this.storage, this.onlyEnvFree);
    }

    @Override
    public CVLCmd kotlinize() {
        List dontCall = Collections.emptyList();
        MethodIdWithCallContext methodIdWithCallContext = MethodIdWithCallContext.Companion.fromMethodReference(this.methodReference.kotlinize());
        return new CVLCmd.Simple.AmbiguousApply(CVLLocation.Companion.fromLocationAndSpecFile(this.loc, this.specFile), new CVLExp.AmbiguousApplyExp(methodIdWithCallContext.getCalleeContext().getName(), methodIdWithCallContext.getMethodId(), Kotlinizer.kotlinizeList(this.expList.stream().map(obj -> new AmbiguousArg((Exp)obj)).collect(Collectors.toList())), CVLExpTag.Companion.getEmptyTag(), TwoStateIndex.NEITHER, (CVLExp)this.storage.kotlinize(), this.noRevert, this.isWhole), null);
    }
}

