"use strict";
const assert_1 = require("@aws-cdk/assert");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'trivial instantiation'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        new lib_1.MetricFilter(stack, 'Subscription', {
            logGroup,
            metricNamespace: 'AWS/Test',
            metricName: 'Latency',
            metricValue: '$.latency',
            filterPattern: lib_1.FilterPattern.exists('$.latency'),
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::MetricFilter', {
            MetricTransformations: [{
                    MetricNamespace: 'AWS/Test',
                    MetricName: 'Latency',
                    MetricValue: '$.latency',
                }],
            FilterPattern: '{ $.latency = "*" }',
            LogGroupName: { Ref: 'LogGroupF5B46931' },
        }));
        test.done();
    },
    'metric filter exposes metric'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        const mf = new lib_1.MetricFilter(stack, 'Subscription', {
            logGroup,
            metricNamespace: 'AWS/Test',
            metricName: 'Latency',
            metricValue: '$.latency',
            filterPattern: lib_1.FilterPattern.exists('$.latency'),
        });
        const metric = mf.metric();
        // THEN
        test.deepEqual(metric, new aws_cloudwatch_1.Metric({
            metricName: 'Latency',
            namespace: 'AWS/Test',
            statistic: 'avg',
        }));
        test.done();
    },
    'metric filter exposes metric with custom statistic'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        const mf = new lib_1.MetricFilter(stack, 'Subscription', {
            logGroup,
            metricNamespace: 'AWS/Test',
            metricName: 'Latency',
            metricValue: '$.latency',
            filterPattern: lib_1.FilterPattern.exists('$.latency'),
        });
        const metric = mf.metric({ statistic: 'maximum' });
        // THEN
        test.deepEqual(metric, new aws_cloudwatch_1.Metric({
            metricName: 'Latency',
            namespace: 'AWS/Test',
            statistic: 'maximum',
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5tZXRyaWNmaWx0ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0Lm1ldHJpY2ZpbHRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsNENBQXVEO0FBQ3ZELDREQUFpRDtBQUNqRCx3Q0FBc0M7QUFFdEMsZ0NBQStEO0FBRS9ELGlCQUFTO0lBQ1AsdUJBQXVCLENBQUMsSUFBVTtRQUNoQyxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztRQUMxQixNQUFNLFFBQVEsR0FBRyxJQUFJLGNBQVEsQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFFakQsT0FBTztRQUNQLElBQUksa0JBQVksQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO1lBQ3RDLFFBQVE7WUFDUixlQUFlLEVBQUUsVUFBVTtZQUMzQixVQUFVLEVBQUUsU0FBUztZQUNyQixXQUFXLEVBQUUsV0FBVztZQUN4QixhQUFhLEVBQUUsbUJBQWEsQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDO1NBQ2pELENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMseUJBQXlCLEVBQUU7WUFDdkQscUJBQXFCLEVBQUUsQ0FBQztvQkFDdEIsZUFBZSxFQUFFLFVBQVU7b0JBQzNCLFVBQVUsRUFBRSxTQUFTO29CQUNyQixXQUFXLEVBQUUsV0FBVztpQkFDekIsQ0FBQztZQUNGLGFBQWEsRUFBRSxxQkFBcUI7WUFDcEMsWUFBWSxFQUFFLEVBQUUsR0FBRyxFQUFFLGtCQUFrQixFQUFFO1NBQzFDLENBQUMsQ0FBQyxDQUFDO1FBRUosSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELDhCQUE4QixDQUFDLElBQVU7UUFDdkMsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxFQUFFLENBQUM7UUFDMUIsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBRWpELE9BQU87UUFDUCxNQUFNLEVBQUUsR0FBRyxJQUFJLGtCQUFZLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRTtZQUNqRCxRQUFRO1lBQ1IsZUFBZSxFQUFFLFVBQVU7WUFDM0IsVUFBVSxFQUFFLFNBQVM7WUFDckIsV0FBVyxFQUFFLFdBQVc7WUFDeEIsYUFBYSxFQUFFLG1CQUFhLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQztTQUNqRCxDQUFDLENBQUM7UUFFSCxNQUFNLE1BQU0sR0FBRyxFQUFFLENBQUMsTUFBTSxFQUFFLENBQUM7UUFFM0IsT0FBTztRQUNQLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFLElBQUksdUJBQU0sQ0FBQztZQUNoQyxVQUFVLEVBQUUsU0FBUztZQUNyQixTQUFTLEVBQUUsVUFBVTtZQUNyQixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUMsQ0FBQztRQUVKLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxvREFBb0QsQ0FBQyxJQUFVO1FBQzdELFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sUUFBUSxHQUFHLElBQUksY0FBUSxDQUFDLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztRQUVqRCxPQUFPO1FBQ1AsTUFBTSxFQUFFLEdBQUcsSUFBSSxrQkFBWSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUU7WUFDakQsUUFBUTtZQUNSLGVBQWUsRUFBRSxVQUFVO1lBQzNCLFVBQVUsRUFBRSxTQUFTO1lBQ3JCLFdBQVcsRUFBRSxXQUFXO1lBQ3hCLGFBQWEsRUFBRSxtQkFBYSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUM7U0FDakQsQ0FBQyxDQUFDO1FBRUgsTUFBTSxNQUFNLEdBQUcsRUFBRSxDQUFDLE1BQU0sQ0FBQyxFQUFFLFNBQVMsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBRW5ELE9BQU87UUFDUCxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sRUFBRSxJQUFJLHVCQUFNLENBQUM7WUFDaEMsVUFBVSxFQUFFLFNBQVM7WUFDckIsU0FBUyxFQUFFLFVBQVU7WUFDckIsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQyxDQUFDLENBQUM7UUFFSixJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBQ0YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGV4cGVjdCwgaGF2ZVJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCB7IE1ldHJpYyB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IHsgRmlsdGVyUGF0dGVybiwgTG9nR3JvdXAsIE1ldHJpY0ZpbHRlciB9IGZyb20gJy4uL2xpYic7XG5cbmV4cG9ydCA9IHtcbiAgJ3RyaXZpYWwgaW5zdGFudGlhdGlvbicodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCBsb2dHcm91cCA9IG5ldyBMb2dHcm91cChzdGFjaywgJ0xvZ0dyb3VwJyk7XG5cbiAgICAvLyBXSEVOXG4gICAgbmV3IE1ldHJpY0ZpbHRlcihzdGFjaywgJ1N1YnNjcmlwdGlvbicsIHtcbiAgICAgIGxvZ0dyb3VwLFxuICAgICAgbWV0cmljTmFtZXNwYWNlOiAnQVdTL1Rlc3QnLFxuICAgICAgbWV0cmljTmFtZTogJ0xhdGVuY3knLFxuICAgICAgbWV0cmljVmFsdWU6ICckLmxhdGVuY3knLFxuICAgICAgZmlsdGVyUGF0dGVybjogRmlsdGVyUGF0dGVybi5leGlzdHMoJyQubGF0ZW5jeScpLFxuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkxvZ3M6Ok1ldHJpY0ZpbHRlcicsIHtcbiAgICAgIE1ldHJpY1RyYW5zZm9ybWF0aW9uczogW3tcbiAgICAgICAgTWV0cmljTmFtZXNwYWNlOiAnQVdTL1Rlc3QnLFxuICAgICAgICBNZXRyaWNOYW1lOiAnTGF0ZW5jeScsXG4gICAgICAgIE1ldHJpY1ZhbHVlOiAnJC5sYXRlbmN5JyxcbiAgICAgIH1dLFxuICAgICAgRmlsdGVyUGF0dGVybjogJ3sgJC5sYXRlbmN5ID0gXCIqXCIgfScsXG4gICAgICBMb2dHcm91cE5hbWU6IHsgUmVmOiAnTG9nR3JvdXBGNUI0NjkzMScgfSxcbiAgICB9KSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWV0cmljIGZpbHRlciBleHBvc2VzIG1ldHJpYycodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCBsb2dHcm91cCA9IG5ldyBMb2dHcm91cChzdGFjaywgJ0xvZ0dyb3VwJyk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3QgbWYgPSBuZXcgTWV0cmljRmlsdGVyKHN0YWNrLCAnU3Vic2NyaXB0aW9uJywge1xuICAgICAgbG9nR3JvdXAsXG4gICAgICBtZXRyaWNOYW1lc3BhY2U6ICdBV1MvVGVzdCcsXG4gICAgICBtZXRyaWNOYW1lOiAnTGF0ZW5jeScsXG4gICAgICBtZXRyaWNWYWx1ZTogJyQubGF0ZW5jeScsXG4gICAgICBmaWx0ZXJQYXR0ZXJuOiBGaWx0ZXJQYXR0ZXJuLmV4aXN0cygnJC5sYXRlbmN5JyksXG4gICAgfSk7XG5cbiAgICBjb25zdCBtZXRyaWMgPSBtZi5tZXRyaWMoKTtcblxuICAgIC8vIFRIRU5cbiAgICB0ZXN0LmRlZXBFcXVhbChtZXRyaWMsIG5ldyBNZXRyaWMoe1xuICAgICAgbWV0cmljTmFtZTogJ0xhdGVuY3knLFxuICAgICAgbmFtZXNwYWNlOiAnQVdTL1Rlc3QnLFxuICAgICAgc3RhdGlzdGljOiAnYXZnJyxcbiAgICB9KSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWV0cmljIGZpbHRlciBleHBvc2VzIG1ldHJpYyB3aXRoIGN1c3RvbSBzdGF0aXN0aWMnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG4gICAgY29uc3QgbG9nR3JvdXAgPSBuZXcgTG9nR3JvdXAoc3RhY2ssICdMb2dHcm91cCcpO1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IG1mID0gbmV3IE1ldHJpY0ZpbHRlcihzdGFjaywgJ1N1YnNjcmlwdGlvbicsIHtcbiAgICAgIGxvZ0dyb3VwLFxuICAgICAgbWV0cmljTmFtZXNwYWNlOiAnQVdTL1Rlc3QnLFxuICAgICAgbWV0cmljTmFtZTogJ0xhdGVuY3knLFxuICAgICAgbWV0cmljVmFsdWU6ICckLmxhdGVuY3knLFxuICAgICAgZmlsdGVyUGF0dGVybjogRmlsdGVyUGF0dGVybi5leGlzdHMoJyQubGF0ZW5jeScpLFxuICAgIH0pO1xuXG4gICAgY29uc3QgbWV0cmljID0gbWYubWV0cmljKHsgc3RhdGlzdGljOiAnbWF4aW11bScgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgdGVzdC5kZWVwRXF1YWwobWV0cmljLCBuZXcgTWV0cmljKHtcbiAgICAgIG1ldHJpY05hbWU6ICdMYXRlbmN5JyxcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9UZXN0JyxcbiAgICAgIHN0YXRpc3RpYzogJ21heGltdW0nLFxuICAgIH0pKTtcblxuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxufTtcbiJdfQ==