# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetAlarmResult:
    """
    A collection of values returned by getAlarm.
    """
    def __init__(__self__, alarm_id=None, enabled=None, id=None, instance_id=None, message_type=None, queue_regex=None, recipients=None, time_threshold=None, type=None, value_threshold=None, vhost_regex=None):
        if alarm_id and not isinstance(alarm_id, float):
            raise TypeError("Expected argument 'alarm_id' to be a float")
        __self__.alarm_id = alarm_id
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        __self__.enabled = enabled
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if instance_id and not isinstance(instance_id, float):
            raise TypeError("Expected argument 'instance_id' to be a float")
        __self__.instance_id = instance_id
        if message_type and not isinstance(message_type, str):
            raise TypeError("Expected argument 'message_type' to be a str")
        __self__.message_type = message_type
        if queue_regex and not isinstance(queue_regex, str):
            raise TypeError("Expected argument 'queue_regex' to be a str")
        __self__.queue_regex = queue_regex
        if recipients and not isinstance(recipients, list):
            raise TypeError("Expected argument 'recipients' to be a list")
        __self__.recipients = recipients
        if time_threshold and not isinstance(time_threshold, float):
            raise TypeError("Expected argument 'time_threshold' to be a float")
        __self__.time_threshold = time_threshold
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        __self__.type = type
        if value_threshold and not isinstance(value_threshold, float):
            raise TypeError("Expected argument 'value_threshold' to be a float")
        __self__.value_threshold = value_threshold
        if vhost_regex and not isinstance(vhost_regex, str):
            raise TypeError("Expected argument 'vhost_regex' to be a str")
        __self__.vhost_regex = vhost_regex
class AwaitableGetAlarmResult(GetAlarmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmResult(
            alarm_id=self.alarm_id,
            enabled=self.enabled,
            id=self.id,
            instance_id=self.instance_id,
            message_type=self.message_type,
            queue_regex=self.queue_regex,
            recipients=self.recipients,
            time_threshold=self.time_threshold,
            type=self.type,
            value_threshold=self.value_threshold,
            vhost_regex=self.vhost_regex)

def get_alarm(alarm_id=None,instance_id=None,type=None,opts=None):
    """
    Use this data source to retrieve information about default or created alarms. Either use `alarm_id` or `type` to retrieve the alarm.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    default_cpu_alarm = cloudamqp.get_alarm(instance_id=cloudamqp_instance["instance"]["id"],
        type="cpu")
    ```
    ## Argument reference

    * `instance_id` - (Required) The CloudAMQP instance identifier.
    * `alarm_id`    - (Optional) The alarm identifier. Either use this or `type` to give `Alarm` necessary information to retrieve the alarm.
    * `type`        - (Optional) The alarm type. Either use this or `alarm_id` to give `Alarm` necessary information when retrieve the alarm.

    ## Attribute reference

    * `enabled`         - (Computed) Enable/disable status of the alarm.
    * `value_threshold` - (Computed) The value threshold that triggers the alarm.
    * `time_threshold`  - (Computed) The time interval (in seconds) the `value_threshold` should be active before trigger an alarm.
    * `queue_regex`     - (Computed) Regular expression for which queue to check.
    * `vhost_regex`     - (Computed) Regular expression for which vhost to check
    * `recipients`      - (Computed) Identifier for recipient to be notified.
    * `message_type`    - (Computed) Message type `(total, unacked, ready)` used by queue alarm type.

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.
    """
    __args__ = dict()


    __args__['alarmId'] = alarm_id
    __args__['instanceId'] = instance_id
    __args__['type'] = type
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('cloudamqp:index/getAlarm:getAlarm', __args__, opts=opts).value

    return AwaitableGetAlarmResult(
        alarm_id=__ret__.get('alarmId'),
        enabled=__ret__.get('enabled'),
        id=__ret__.get('id'),
        instance_id=__ret__.get('instanceId'),
        message_type=__ret__.get('messageType'),
        queue_regex=__ret__.get('queueRegex'),
        recipients=__ret__.get('recipients'),
        time_threshold=__ret__.get('timeThreshold'),
        type=__ret__.get('type'),
        value_threshold=__ret__.get('valueThreshold'),
        vhost_regex=__ret__.get('vhostRegex'))
