# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables


class SecurityFirewall(pulumi.CustomResource):
    instance_id: pulumi.Output[float]
    """
    The CloudAMQP instance ID.
    """
    rules: pulumi.Output[list]
    """
    An array of rules, minimum of 1 needs to be configured. Each `rules` block consists of the field documented below.

      * `description` (`str`) - Description name of the rule. e.g. Default.
      * `ip` (`str`) - Source ip and netmask for the rule. (e.g. 10.56.72.0/24)
      * `ports` (`list`) - Custom ports to be opened
      * `services` (`list`) - Pre-defined service ports
    """
    def __init__(__self__, resource_name, opts=None, instance_id=None, rules=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to configure and manage firewall rules for the CloudAMQP instance. Beware that all rules need to be present, since all older configurations will be overwritten.

        Only available for dedicated subscription plans.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        firewall_settings = cloudamqp.SecurityFirewall("firewallSettings",
            instance_id=cloudamqp_instance["instance"]["id"],
            rules=[
                {
                    "ip": "192.168.0.0/24",
                    "ports": [
                        4567,
                        4568,
                    ],
                    "services": [
                        "AMQP",
                        "AMQPS",
                    ],
                },
                {
                    "ip": "10.56.72.0/24",
                    "ports": [],
                    "services": [
                        "AMQP",
                        "AMQPS",
                    ],
                },
            ])
        ```
        ## Depedency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[list] rules: An array of rules, minimum of 1 needs to be configured. Each `rules` block consists of the field documented below.

        The **rules** object supports the following:

          * `description` (`pulumi.Input[str]`) - Description name of the rule. e.g. Default.
          * `ip` (`pulumi.Input[str]`) - Source ip and netmask for the rule. (e.g. 10.56.72.0/24)
          * `ports` (`pulumi.Input[list]`) - Custom ports to be opened
          * `services` (`pulumi.Input[list]`) - Pre-defined service ports
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if instance_id is None:
                raise TypeError("Missing required property 'instance_id'")
            __props__['instance_id'] = instance_id
            if rules is None:
                raise TypeError("Missing required property 'rules'")
            __props__['rules'] = rules
        super(SecurityFirewall, __self__).__init__(
            'cloudamqp:index/securityFirewall:SecurityFirewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, instance_id=None, rules=None):
        """
        Get an existing SecurityFirewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[list] rules: An array of rules, minimum of 1 needs to be configured. Each `rules` block consists of the field documented below.

        The **rules** object supports the following:

          * `description` (`pulumi.Input[str]`) - Description name of the rule. e.g. Default.
          * `ip` (`pulumi.Input[str]`) - Source ip and netmask for the rule. (e.g. 10.56.72.0/24)
          * `ports` (`pulumi.Input[list]`) - Custom ports to be opened
          * `services` (`pulumi.Input[list]`) - Pre-defined service ports
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["instance_id"] = instance_id
        __props__["rules"] = rules
        return SecurityFirewall(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
