(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.igv = factory());
}(this, (function () { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var check = function (it) {
	  return it && it.Math == Math && it;
	}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


	var global_1 = // eslint-disable-next-line no-undef
	check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func
	Function('return this')();

	var fails = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var descriptors = !fails(function () {
	  return Object.defineProperty({}, 1, {
	    get: function () {
	      return 7;
	    }
	  })[1] != 7;
	});

	var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

	var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({
	  1: 2
	}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable

	var f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : nativePropertyIsEnumerable;
	var objectPropertyIsEnumerable = {
	  f: f
	};

	var createPropertyDescriptor = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var toString = {}.toString;

	var classofRaw = function (it) {
	  return toString.call(it).slice(8, -1);
	};

	var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings

	var indexedObject = fails(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins
	  return !Object('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classofRaw(it) == 'String' ? split.call(it, '') : Object(it);
	} : Object;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.github.io/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible = function (it) {
	  if (it == undefined) throw TypeError("Can't call method on " + it);
	  return it;
	};

	var toIndexedObject = function (it) {
	  return indexedObject(requireObjectCoercible(it));
	};

	var isObject = function (it) {
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

	// https://tc39.github.io/ecma262/#sec-toprimitive
	// instead of the ES6 spec version, we didn't implement @@toPrimitive case
	// and the second argument - flag - preferred type is a string

	var toPrimitive = function (input, PREFERRED_STRING) {
	  if (!isObject(input)) return input;
	  var fn, val;
	  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  throw TypeError("Can't convert object to primitive value");
	};

	var hasOwnProperty = {}.hasOwnProperty;

	var has = function (it, key) {
	  return hasOwnProperty.call(it, key);
	};

	var document$1 = global_1.document; // typeof document.createElement is 'object' in old IE

	var EXISTS = isObject(document$1) && isObject(document$1.createElement);

	var documentCreateElement = function (it) {
	  return EXISTS ? document$1.createElement(it) : {};
	};

	var ie8DomDefine = !descriptors && !fails(function () {
	  return Object.defineProperty(documentCreateElement('div'), 'a', {
	    get: function () {
	      return 7;
	    }
	  }).a != 7;
	});

	var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor

	var f$1 = descriptors ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject(O);
	  P = toPrimitive(P, true);
	  if (ie8DomDefine) try {
	    return nativeGetOwnPropertyDescriptor(O, P);
	  } catch (error) {
	    /* empty */
	  }
	  if (has(O, P)) return createPropertyDescriptor(!objectPropertyIsEnumerable.f.call(O, P), O[P]);
	};
	var objectGetOwnPropertyDescriptor = {
	  f: f$1
	};

	var anObject = function (it) {
	  if (!isObject(it)) {
	    throw TypeError(String(it) + ' is not an object');
	  }

	  return it;
	};

	var nativeDefineProperty = Object.defineProperty; // `Object.defineProperty` method
	// https://tc39.github.io/ecma262/#sec-object.defineproperty

	var f$2 = descriptors ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPrimitive(P, true);
	  anObject(Attributes);
	  if (ie8DomDefine) try {
	    return nativeDefineProperty(O, P, Attributes);
	  } catch (error) {
	    /* empty */
	  }
	  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};
	var objectDefineProperty = {
	  f: f$2
	};

	var createNonEnumerableProperty = descriptors ? function (object, key, value) {
	  return objectDefineProperty.f(object, key, createPropertyDescriptor(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var setGlobal = function (key, value) {
	  try {
	    createNonEnumerableProperty(global_1, key, value);
	  } catch (error) {
	    global_1[key] = value;
	  }

	  return value;
	};

	var SHARED = '__core-js_shared__';
	var store = global_1[SHARED] || setGlobal(SHARED, {});
	var sharedStore = store;

	var functionToString = Function.toString; // this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper

	if (typeof sharedStore.inspectSource != 'function') {
	  sharedStore.inspectSource = function (it) {
	    return functionToString.call(it);
	  };
	}

	var inspectSource = sharedStore.inspectSource;

	var WeakMap = global_1.WeakMap;
	var nativeWeakMap = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));

	var isPure = false;

	var shared = createCommonjsModule(function (module) {
	  (module.exports = function (key, value) {
	    return sharedStore[key] || (sharedStore[key] = value !== undefined ? value : {});
	  })('versions', []).push({
	    version: '3.6.5',
	    mode:  'global',
	    copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
	  });
	});

	var id = 0;
	var postfix = Math.random();

	var uid = function (key) {
	  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
	};

	var keys = shared('keys');

	var sharedKey = function (key) {
	  return keys[key] || (keys[key] = uid(key));
	};

	var hiddenKeys = {};

	var WeakMap$1 = global_1.WeakMap;
	var set, get, has$1;

	var enforce = function (it) {
	  return has$1(it) ? get(it) : set(it, {});
	};

	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;

	    if (!isObject(it) || (state = get(it)).type !== TYPE) {
	      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
	    }

	    return state;
	  };
	};

	if (nativeWeakMap) {
	  var store$1 = new WeakMap$1();
	  var wmget = store$1.get;
	  var wmhas = store$1.has;
	  var wmset = store$1.set;

	  set = function (it, metadata) {
	    wmset.call(store$1, it, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return wmget.call(store$1, it) || {};
	  };

	  has$1 = function (it) {
	    return wmhas.call(store$1, it);
	  };
	} else {
	  var STATE = sharedKey('state');
	  hiddenKeys[STATE] = true;

	  set = function (it, metadata) {
	    createNonEnumerableProperty(it, STATE, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return has(it, STATE) ? it[STATE] : {};
	  };

	  has$1 = function (it) {
	    return has(it, STATE);
	  };
	}

	var internalState = {
	  set: set,
	  get: get,
	  has: has$1,
	  enforce: enforce,
	  getterFor: getterFor
	};

	var redefine = createCommonjsModule(function (module) {
	  var getInternalState = internalState.get;
	  var enforceInternalState = internalState.enforce;
	  var TEMPLATE = String(String).split('String');
	  (module.exports = function (O, key, value, options) {
	    var unsafe = options ? !!options.unsafe : false;
	    var simple = options ? !!options.enumerable : false;
	    var noTargetGet = options ? !!options.noTargetGet : false;

	    if (typeof value == 'function') {
	      if (typeof key == 'string' && !has(value, 'name')) createNonEnumerableProperty(value, 'name', key);
	      enforceInternalState(value).source = TEMPLATE.join(typeof key == 'string' ? key : '');
	    }

	    if (O === global_1) {
	      if (simple) O[key] = value;else setGlobal(key, value);
	      return;
	    } else if (!unsafe) {
	      delete O[key];
	    } else if (!noTargetGet && O[key]) {
	      simple = true;
	    }

	    if (simple) O[key] = value;else createNonEnumerableProperty(O, key, value); // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
	  })(Function.prototype, 'toString', function toString() {
	    return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
	  });
	});

	var path = global_1;

	var aFunction = function (variable) {
	  return typeof variable == 'function' ? variable : undefined;
	};

	var getBuiltIn = function (namespace, method) {
	  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global_1[namespace]) : path[namespace] && path[namespace][method] || global_1[namespace] && global_1[namespace][method];
	};

	var ceil = Math.ceil;
	var floor = Math.floor; // `ToInteger` abstract operation
	// https://tc39.github.io/ecma262/#sec-tointeger

	var toInteger = function (argument) {
	  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
	};

	var min = Math.min; // `ToLength` abstract operation
	// https://tc39.github.io/ecma262/#sec-tolength

	var toLength = function (argument) {
	  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var max = Math.max;
	var min$1 = Math.min; // Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

	var toAbsoluteIndex = function (index, length) {
	  var integer = toInteger(index);
	  return integer < 0 ? max(integer + length, 0) : min$1(integer, length);
	};

	var createMethod = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject($this);
	    var length = toLength(O.length);
	    var index = toAbsoluteIndex(fromIndex, length);
	    var value; // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare

	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++]; // eslint-disable-next-line no-self-compare

	      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
	    } else for (; length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    }
	    return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.includes
	  includes: createMethod(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod(false)
	};

	var indexOf = arrayIncludes.indexOf;

	var objectKeysInternal = function (object, names) {
	  var O = toIndexedObject(object);
	  var i = 0;
	  var result = [];
	  var key;

	  for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key); // Don't enum bug & hidden keys


	  while (names.length > i) if (has(O, key = names[i++])) {
	    ~indexOf(result, key) || result.push(key);
	  }

	  return result;
	};

	// IE8- don't enum bug keys
	var enumBugKeys = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

	var hiddenKeys$1 = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	var f$3 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return objectKeysInternal(O, hiddenKeys$1);
	};

	var objectGetOwnPropertyNames = {
	  f: f$3
	};

	var f$4 = Object.getOwnPropertySymbols;
	var objectGetOwnPropertySymbols = {
	  f: f$4
	};

	var ownKeys = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = objectGetOwnPropertyNames.f(anObject(it));
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
	};

	var copyConstructorProperties = function (target, source) {
	  var keys = ownKeys(source);
	  var defineProperty = objectDefineProperty.f;
	  var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;

	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	  }
	};

	var replacement = /#|\.prototype\./;

	var isForced = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
	};

	var normalize = isForced.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced.data = {};
	var NATIVE = isForced.NATIVE = 'N';
	var POLYFILL = isForced.POLYFILL = 'P';
	var isForced_1 = isForced;

	var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	/*
	  options.target      - name of the target object
	  options.global      - target is the global object
	  options.stat        - export as static methods of target
	  options.proto       - export as prototype methods of target
	  options.real        - real prototype method for the `pure` version
	  options.forced      - export even if the native feature is available
	  options.bind        - bind methods to the target, required for the `pure` version
	  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
	  options.sham        - add a flag to not completely full polyfills
	  options.enumerable  - export as enumerable property
	  options.noTargetGet - prevent calling a getter on target
	*/

	var _export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var FORCED, target, key, targetProperty, sourceProperty, descriptor;

	  if (GLOBAL) {
	    target = global_1;
	  } else if (STATIC) {
	    target = global_1[TARGET] || setGlobal(TARGET, {});
	  } else {
	    target = (global_1[TARGET] || {}).prototype;
	  }

	  if (target) for (key in source) {
	    sourceProperty = source[key];

	    if (options.noTargetGet) {
	      descriptor = getOwnPropertyDescriptor$1(target, key);
	      targetProperty = descriptor && descriptor.value;
	    } else targetProperty = target[key];

	    FORCED = isForced_1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contained in target

	    if (!FORCED && targetProperty !== undefined) {
	      if (typeof sourceProperty === typeof targetProperty) continue;
	      copyConstructorProperties(sourceProperty, targetProperty);
	    } // add a flag to not completely full polyfills


	    if (options.sham || targetProperty && targetProperty.sham) {
	      createNonEnumerableProperty(sourceProperty, 'sham', true);
	    } // extend global


	    redefine(target, key, sourceProperty, options);
	  }
	};

	var aFunction$1 = function (it) {
	  if (typeof it != 'function') {
	    throw TypeError(String(it) + ' is not a function');
	  }

	  return it;
	};

	var functionBindContext = function (fn, that, length) {
	  aFunction$1(fn);
	  if (that === undefined) return fn;

	  switch (length) {
	    case 0:
	      return function () {
	        return fn.call(that);
	      };

	    case 1:
	      return function (a) {
	        return fn.call(that, a);
	      };

	    case 2:
	      return function (a, b) {
	        return fn.call(that, a, b);
	      };

	    case 3:
	      return function (a, b, c) {
	        return fn.call(that, a, b, c);
	      };
	  }

	  return function ()
	  /* ...args */
	  {
	    return fn.apply(that, arguments);
	  };
	};

	// https://tc39.github.io/ecma262/#sec-toobject

	var toObject = function (argument) {
	  return Object(requireObjectCoercible(argument));
	};

	// https://tc39.github.io/ecma262/#sec-isarray

	var isArray = Array.isArray || function isArray(arg) {
	  return classofRaw(arg) == 'Array';
	};

	var nativeSymbol = !!Object.getOwnPropertySymbols && !fails(function () {
	  // Chrome 38 Symbol has incorrect toString conversion
	  // eslint-disable-next-line no-undef
	  return !String(Symbol());
	});

	var useSymbolAsUid = nativeSymbol // eslint-disable-next-line no-undef
	&& !Symbol.sham // eslint-disable-next-line no-undef
	&& typeof Symbol.iterator == 'symbol';

	var WellKnownSymbolsStore = shared('wks');
	var Symbol$1 = global_1.Symbol;
	var createWellKnownSymbol = useSymbolAsUid ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid;

	var wellKnownSymbol = function (name) {
	  if (!has(WellKnownSymbolsStore, name)) {
	    if (nativeSymbol && has(Symbol$1, name)) WellKnownSymbolsStore[name] = Symbol$1[name];else WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
	  }

	  return WellKnownSymbolsStore[name];
	};

	var SPECIES = wellKnownSymbol('species'); // `ArraySpeciesCreate` abstract operation
	// https://tc39.github.io/ecma262/#sec-arrayspeciescreate

	var arraySpeciesCreate = function (originalArray, length) {
	  var C;

	  if (isArray(originalArray)) {
	    C = originalArray.constructor; // cross-realm fallback

	    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;else if (isObject(C)) {
	      C = C[SPECIES];
	      if (C === null) C = undefined;
	    }
	  }

	  return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
	};

	var push = [].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation

	var createMethod$1 = function (TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject($this);
	    var self = indexedObject(O);
	    var boundFunction = functionBindContext(callbackfn, that, 3);
	    var length = toLength(self.length);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate;
	    var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
	    var value, result;

	    for (; length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);

	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	            case 3:
	              return true;
	            // some

	            case 5:
	              return value;
	            // find

	            case 6:
	              return index;
	            // findIndex

	            case 2:
	              push.call(target, value);
	            // filter
	          } else if (IS_EVERY) return false; // every
	      }
	    }

	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$1(0),
	  // `Array.prototype.map` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.map
	  map: createMethod$1(1),
	  // `Array.prototype.filter` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.filter
	  filter: createMethod$1(2),
	  // `Array.prototype.some` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.some
	  some: createMethod$1(3),
	  // `Array.prototype.every` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.every
	  every: createMethod$1(4),
	  // `Array.prototype.find` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.find
	  find: createMethod$1(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$1(6)
	};

	var engineUserAgent = getBuiltIn('navigator', 'userAgent') || '';

	var process$1 = global_1.process;
	var versions = process$1 && process$1.versions;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.');
	  version = match[0] + match[1];
	} else if (engineUserAgent) {
	  match = engineUserAgent.match(/Edge\/(\d+)/);

	  if (!match || match[1] >= 74) {
	    match = engineUserAgent.match(/Chrome\/(\d+)/);
	    if (match) version = match[1];
	  }
	}

	var engineV8Version = version && +version;

	var SPECIES$1 = wellKnownSymbol('species');

	var arrayMethodHasSpeciesSupport = function (METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return engineV8Version >= 51 || !fails(function () {
	    var array = [];
	    var constructor = array.constructor = {};

	    constructor[SPECIES$1] = function () {
	      return {
	        foo: 1
	      };
	    };

	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	var defineProperty = Object.defineProperty;
	var cache = {};

	var thrower = function (it) {
	  throw it;
	};

	var arrayMethodUsesToLength = function (METHOD_NAME, options) {
	  if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
	  if (!options) options = {};
	  var method = [][METHOD_NAME];
	  var ACCESSORS = has(options, 'ACCESSORS') ? options.ACCESSORS : false;
	  var argument0 = has(options, 0) ? options[0] : thrower;
	  var argument1 = has(options, 1) ? options[1] : undefined;
	  return cache[METHOD_NAME] = !!method && !fails(function () {
	    if (ACCESSORS && !descriptors) return true;
	    var O = {
	      length: -1
	    };
	    if (ACCESSORS) defineProperty(O, 1, {
	      enumerable: true,
	      get: thrower
	    });else O[1] = 1;
	    method.call(O, argument0, argument1);
	  });
	};

	var $filter = arrayIteration.filter;
	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // Edge 14- issue

	var USES_TO_LENGTH = arrayMethodUsesToLength('filter'); // `Array.prototype.filter` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.filter
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH
	}, {
	  filter: function filter(callbackfn
	  /* , thisArg */
	  ) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var arrayMethodIsStrict = function (METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails(function () {
	    // eslint-disable-next-line no-useless-call,no-throw-literal
	    method.call(null, argument || function () {
	      throw 1;
	    }, 1);
	  });
	};

	var $forEach = arrayIteration.forEach;
	var STRICT_METHOD = arrayMethodIsStrict('forEach');
	var USES_TO_LENGTH$1 = arrayMethodUsesToLength('forEach'); // `Array.prototype.forEach` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach

	var arrayForEach = !STRICT_METHOD || !USES_TO_LENGTH$1 ? function forEach(callbackfn
	/* , thisArg */
	) {
	  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	} : [].forEach;

	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach


	_export({
	  target: 'Array',
	  proto: true,
	  forced: [].forEach != arrayForEach
	}, {
	  forEach: arrayForEach
	});

	var $indexOf = arrayIncludes.indexOf;
	var nativeIndexOf = [].indexOf;
	var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
	var STRICT_METHOD$1 = arrayMethodIsStrict('indexOf');
	var USES_TO_LENGTH$2 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.indexOf` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.indexof

	_export({
	  target: 'Array',
	  proto: true,
	  forced: NEGATIVE_ZERO || !STRICT_METHOD$1 || !USES_TO_LENGTH$2
	}, {
	  indexOf: function indexOf(searchElement
	  /* , fromIndex = 0 */
	  ) {
	    return NEGATIVE_ZERO // convert -0 to +0
	    ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var min$2 = Math.min;
	var nativeLastIndexOf = [].lastIndexOf;
	var NEGATIVE_ZERO$1 = !!nativeLastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
	var STRICT_METHOD$2 = arrayMethodIsStrict('lastIndexOf'); // For preventing possible almost infinite loop in non-standard implementations, test the forward version of the method

	var USES_TO_LENGTH$3 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	});
	var FORCED = NEGATIVE_ZERO$1 || !STRICT_METHOD$2 || !USES_TO_LENGTH$3; // `Array.prototype.lastIndexOf` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof

	var arrayLastIndexOf = FORCED ? function lastIndexOf(searchElement
	/* , fromIndex = @[*-1] */
	) {
	  // convert -0 to +0
	  if (NEGATIVE_ZERO$1) return nativeLastIndexOf.apply(this, arguments) || 0;
	  var O = toIndexedObject(this);
	  var length = toLength(O.length);
	  var index = length - 1;
	  if (arguments.length > 1) index = min$2(index, toInteger(arguments[1]));
	  if (index < 0) index = length + index;

	  for (; index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;

	  return -1;
	} : nativeLastIndexOf;

	// https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof

	_export({
	  target: 'Array',
	  proto: true,
	  forced: arrayLastIndexOf !== [].lastIndexOf
	}, {
	  lastIndexOf: arrayLastIndexOf
	});

	// https://tc39.github.io/ecma262/#sec-get-regexp.prototype.flags


	var regexpFlags = function () {
	  var that = anObject(this);
	  var result = '';
	  if (that.global) result += 'g';
	  if (that.ignoreCase) result += 'i';
	  if (that.multiline) result += 'm';
	  if (that.dotAll) result += 's';
	  if (that.unicode) result += 'u';
	  if (that.sticky) result += 'y';
	  return result;
	};

	// so we use an intermediate function.


	function RE(s, f) {
	  return RegExp(s, f);
	}

	var UNSUPPORTED_Y = fails(function () {
	  // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
	  var re = RE('a', 'y');
	  re.lastIndex = 2;
	  return re.exec('abcd') != null;
	});
	var BROKEN_CARET = fails(function () {
	  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
	  var re = RE('^r', 'gy');
	  re.lastIndex = 2;
	  return re.exec('str') != null;
	});
	var regexpStickyHelpers = {
	  UNSUPPORTED_Y: UNSUPPORTED_Y,
	  BROKEN_CARET: BROKEN_CARET
	};

	var nativeExec = RegExp.prototype.exec; // This always refers to the native implementation, because the
	// String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,
	// which loads this file before patching the method.

	var nativeReplace = String.prototype.replace;
	var patchedExec = nativeExec;

	var UPDATES_LAST_INDEX_WRONG = function () {
	  var re1 = /a/;
	  var re2 = /b*/g;
	  nativeExec.call(re1, 'a');
	  nativeExec.call(re2, 'a');
	  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
	}();

	var UNSUPPORTED_Y$1 = regexpStickyHelpers.UNSUPPORTED_Y || regexpStickyHelpers.BROKEN_CARET; // nonparticipating capturing group, copied from es5-shim's String#split patch.

	var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;
	var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1;

	if (PATCH) {
	  patchedExec = function exec(str) {
	    var re = this;
	    var lastIndex, reCopy, match, i;
	    var sticky = UNSUPPORTED_Y$1 && re.sticky;
	    var flags = regexpFlags.call(re);
	    var source = re.source;
	    var charsAdded = 0;
	    var strCopy = str;

	    if (sticky) {
	      flags = flags.replace('y', '');

	      if (flags.indexOf('g') === -1) {
	        flags += 'g';
	      }

	      strCopy = String(str).slice(re.lastIndex); // Support anchored sticky behavior.

	      if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== '\n')) {
	        source = '(?: ' + source + ')';
	        strCopy = ' ' + strCopy;
	        charsAdded++;
	      } // ^(? + rx + ) is needed, in combination with some str slicing, to
	      // simulate the 'y' flag.


	      reCopy = new RegExp('^(?:' + source + ')', flags);
	    }

	    if (NPCG_INCLUDED) {
	      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
	    }

	    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
	    match = nativeExec.call(sticky ? reCopy : re, strCopy);

	    if (sticky) {
	      if (match) {
	        match.input = match.input.slice(charsAdded);
	        match[0] = match[0].slice(charsAdded);
	        match.index = re.lastIndex;
	        re.lastIndex += match[0].length;
	      } else re.lastIndex = 0;
	    } else if (UPDATES_LAST_INDEX_WRONG && match) {
	      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
	    }

	    if (NPCG_INCLUDED && match && match.length > 1) {
	      // Fix browsers whose `exec` methods don't consistently return `undefined`
	      // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
	      nativeReplace.call(match[0], reCopy, function () {
	        for (i = 1; i < arguments.length - 2; i++) {
	          if (arguments[i] === undefined) match[i] = undefined;
	        }
	      });
	    }

	    return match;
	  };
	}

	var regexpExec = patchedExec;

	_export({
	  target: 'RegExp',
	  proto: true,
	  forced: /./.exec !== regexpExec
	}, {
	  exec: regexpExec
	});

	var MATCH = wellKnownSymbol('match'); // `IsRegExp` abstract operation
	// https://tc39.github.io/ecma262/#sec-isregexp

	var isRegexp = function (it) {
	  var isRegExp;
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classofRaw(it) == 'RegExp');
	};

	var notARegexp = function (it) {
	  if (isRegexp(it)) {
	    throw TypeError("The method doesn't accept regular expressions");
	  }

	  return it;
	};

	var MATCH$1 = wellKnownSymbol('match');

	var correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;

	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (e) {
	    try {
	      regexp[MATCH$1] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (f) {
	      /* empty */
	    }
	  }

	  return false;
	};

	var getOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
	var nativeEndsWith = ''.endsWith;
	var min$3 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC = correctIsRegexpLogic('endsWith'); // https://github.com/zloirock/core-js/pull/702

	var MDN_POLYFILL_BUG =  !CORRECT_IS_REGEXP_LOGIC && !!function () {
	  var descriptor = getOwnPropertyDescriptor$2(String.prototype, 'endsWith');
	  return descriptor && !descriptor.writable;
	}(); // `String.prototype.endsWith` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.endswith

	_export({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
	}, {
	  endsWith: function endsWith(searchString
	  /* , endPosition = @length */
	  ) {
	    var that = String(requireObjectCoercible(this));
	    notARegexp(searchString);
	    var endPosition = arguments.length > 1 ? arguments[1] : undefined;
	    var len = toLength(that.length);
	    var end = endPosition === undefined ? len : min$3(toLength(endPosition), len);
	    var search = String(searchString);
	    return nativeEndsWith ? nativeEndsWith.call(that, search, end) : that.slice(end - search.length, end) === search;
	  }
	});

	var SPECIES$2 = wellKnownSymbol('species');
	var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
	  // #replace needs built-in support for named groups.
	  // #match works fine because it just return the exec results, even if it has
	  // a "grops" property.
	  var re = /./;

	  re.exec = function () {
	    var result = [];
	    result.groups = {
	      a: '7'
	    };
	    return result;
	  };

	  return ''.replace(re, '$<a>') !== '7';
	}); // IE <= 11 replaces $0 with the whole match, as if it was $&
	// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0

	var REPLACE_KEEPS_$0 = function () {
	  return 'a'.replace(/./, '$0') === '$0';
	}();

	var REPLACE = wellKnownSymbol('replace'); // Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string

	var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = function () {
	  if (/./[REPLACE]) {
	    return /./[REPLACE]('a', '$0') === '';
	  }

	  return false;
	}(); // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
	// Weex JS has frozen built-in prototypes, so use try / catch wrapper


	var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
	  var re = /(?:)/;
	  var originalExec = re.exec;

	  re.exec = function () {
	    return originalExec.apply(this, arguments);
	  };

	  var result = 'ab'.split(re);
	  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
	});

	var fixRegexpWellKnownSymbolLogic = function (KEY, length, exec, sham) {
	  var SYMBOL = wellKnownSymbol(KEY);
	  var DELEGATES_TO_SYMBOL = !fails(function () {
	    // String methods call symbol-named RegEp methods
	    var O = {};

	    O[SYMBOL] = function () {
	      return 7;
	    };

	    return ''[KEY](O) != 7;
	  });
	  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function () {
	    // Symbol-named RegExp methods call .exec
	    var execCalled = false;
	    var re = /a/;

	    if (KEY === 'split') {
	      // We can't use real regex here since it causes deoptimization
	      // and serious performance degradation in V8
	      // https://github.com/zloirock/core-js/issues/306
	      re = {}; // RegExp[@@split] doesn't call the regex's exec method, but first creates
	      // a new one. We need to return the patched regex when creating the new one.

	      re.constructor = {};

	      re.constructor[SPECIES$2] = function () {
	        return re;
	      };

	      re.flags = '';
	      re[SYMBOL] = /./[SYMBOL];
	    }

	    re.exec = function () {
	      execCalled = true;
	      return null;
	    };

	    re[SYMBOL]('');
	    return !execCalled;
	  });

	  if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || KEY === 'replace' && !(REPLACE_SUPPORTS_NAMED_GROUPS && REPLACE_KEEPS_$0 && !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE) || KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC) {
	    var nativeRegExpMethod = /./[SYMBOL];
	    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
	      if (regexp.exec === regexpExec) {
	        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
	          // The native String method already delegates to @@method (this
	          // polyfilled function), leasing to infinite recursion.
	          // We avoid it by directly calling the native @@method method.
	          return {
	            done: true,
	            value: nativeRegExpMethod.call(regexp, str, arg2)
	          };
	        }

	        return {
	          done: true,
	          value: nativeMethod.call(str, regexp, arg2)
	        };
	      }

	      return {
	        done: false
	      };
	    }, {
	      REPLACE_KEEPS_$0: REPLACE_KEEPS_$0,
	      REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE: REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
	    });
	    var stringMethod = methods[0];
	    var regexMethod = methods[1];
	    redefine(String.prototype, KEY, stringMethod);
	    redefine(RegExp.prototype, SYMBOL, length == 2 // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
	    // 21.2.5.11 RegExp.prototype[@@split](string, limit)
	    ? function (string, arg) {
	      return regexMethod.call(string, this, arg);
	    } // 21.2.5.6 RegExp.prototype[@@match](string)
	    // 21.2.5.9 RegExp.prototype[@@search](string)
	    : function (string) {
	      return regexMethod.call(string, this);
	    });
	  }

	  if (sham) createNonEnumerableProperty(RegExp.prototype[SYMBOL], 'sham', true);
	};

	// `SameValue` abstract operation
	// https://tc39.github.io/ecma262/#sec-samevalue
	var sameValue = Object.is || function is(x, y) {
	  // eslint-disable-next-line no-self-compare
	  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
	};

	// https://tc39.github.io/ecma262/#sec-regexpexec

	var regexpExecAbstract = function (R, S) {
	  var exec = R.exec;

	  if (typeof exec === 'function') {
	    var result = exec.call(R, S);

	    if (typeof result !== 'object') {
	      throw TypeError('RegExp exec method returned something other than an Object or null');
	    }

	    return result;
	  }

	  if (classofRaw(R) !== 'RegExp') {
	    throw TypeError('RegExp#exec called on incompatible receiver');
	  }

	  return regexpExec.call(R, S);
	};

	fixRegexpWellKnownSymbolLogic('search', 1, function (SEARCH, nativeSearch, maybeCallNative) {
	  return [// `String.prototype.search` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.search
	  function search(regexp) {
	    var O = requireObjectCoercible(this);
	    var searcher = regexp == undefined ? undefined : regexp[SEARCH];
	    return searcher !== undefined ? searcher.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));
	  }, // `RegExp.prototype[@@search]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@search
	  function (regexp) {
	    var res = maybeCallNative(nativeSearch, regexp, this);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    var previousLastIndex = rx.lastIndex;
	    if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
	    var result = regexpExecAbstract(rx, S);
	    if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
	    return result === null ? -1 : result.index;
	  }];
	});

	var SPECIES$3 = wellKnownSymbol('species'); // `SpeciesConstructor` abstract operation
	// https://tc39.github.io/ecma262/#sec-speciesconstructor

	var speciesConstructor = function (O, defaultConstructor) {
	  var C = anObject(O).constructor;
	  var S;
	  return C === undefined || (S = anObject(C)[SPECIES$3]) == undefined ? defaultConstructor : aFunction$1(S);
	};

	var createMethod$2 = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = String(requireObjectCoercible($this));
	    var position = toInteger(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = S.charCodeAt(position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$2(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$2(true)
	};

	var charAt = stringMultibyte.charAt; // `AdvanceStringIndex` abstract operation
	// https://tc39.github.io/ecma262/#sec-advancestringindex

	var advanceStringIndex = function (S, index, unicode) {
	  return index + (unicode ? charAt(S, index).length : 1);
	};

	var arrayPush = [].push;
	var min$4 = Math.min;
	var MAX_UINT32 = 0xFFFFFFFF; // babel-minify transpiles RegExp('x', 'y') -> /x/y and it causes SyntaxError

	var SUPPORTS_Y = !fails(function () {
	  return !RegExp(MAX_UINT32, 'y');
	}); // @@split logic

	fixRegexpWellKnownSymbolLogic('split', 2, function (SPLIT, nativeSplit, maybeCallNative) {
	  var internalSplit;

	  if ('abbc'.split(/(b)*/)[1] == 'c' || 'test'.split(/(?:)/, -1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 || '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
	    // based on es5-shim implementation, need to rework it
	    internalSplit = function (separator, limit) {
	      var string = String(requireObjectCoercible(this));
	      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	      if (lim === 0) return [];
	      if (separator === undefined) return [string]; // If `separator` is not a regex, use native split

	      if (!isRegexp(separator)) {
	        return nativeSplit.call(string, separator, lim);
	      }

	      var output = [];
	      var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
	      var lastLastIndex = 0; // Make `global` and avoid `lastIndex` issues by working with a copy

	      var separatorCopy = new RegExp(separator.source, flags + 'g');
	      var match, lastIndex, lastLength;

	      while (match = regexpExec.call(separatorCopy, string)) {
	        lastIndex = separatorCopy.lastIndex;

	        if (lastIndex > lastLastIndex) {
	          output.push(string.slice(lastLastIndex, match.index));
	          if (match.length > 1 && match.index < string.length) arrayPush.apply(output, match.slice(1));
	          lastLength = match[0].length;
	          lastLastIndex = lastIndex;
	          if (output.length >= lim) break;
	        }

	        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
	      }

	      if (lastLastIndex === string.length) {
	        if (lastLength || !separatorCopy.test('')) output.push('');
	      } else output.push(string.slice(lastLastIndex));

	      return output.length > lim ? output.slice(0, lim) : output;
	    }; // Chakra, V8

	  } else if ('0'.split(undefined, 0).length) {
	    internalSplit = function (separator, limit) {
	      return separator === undefined && limit === 0 ? [] : nativeSplit.call(this, separator, limit);
	    };
	  } else internalSplit = nativeSplit;

	  return [// `String.prototype.split` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.split
	  function split(separator, limit) {
	    var O = requireObjectCoercible(this);
	    var splitter = separator == undefined ? undefined : separator[SPLIT];
	    return splitter !== undefined ? splitter.call(separator, O, limit) : internalSplit.call(String(O), separator, limit);
	  }, // `RegExp.prototype[@@split]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@split
	  //
	  // NOTE: This cannot be properly polyfilled in engines that don't support
	  // the 'y' flag.
	  function (regexp, limit) {
	    var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== nativeSplit);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    var C = speciesConstructor(rx, RegExp);
	    var unicodeMatching = rx.unicode;
	    var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (SUPPORTS_Y ? 'y' : 'g'); // ^(? + rx + ) is needed, in combination with some S slicing, to
	    // simulate the 'y' flag.

	    var splitter = new C(SUPPORTS_Y ? rx : '^(?:' + rx.source + ')', flags);
	    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	    if (lim === 0) return [];
	    if (S.length === 0) return regexpExecAbstract(splitter, S) === null ? [S] : [];
	    var p = 0;
	    var q = 0;
	    var A = [];

	    while (q < S.length) {
	      splitter.lastIndex = SUPPORTS_Y ? q : 0;
	      var z = regexpExecAbstract(splitter, SUPPORTS_Y ? S : S.slice(q));
	      var e;

	      if (z === null || (e = min$4(toLength(splitter.lastIndex + (SUPPORTS_Y ? 0 : q)), S.length)) === p) {
	        q = advanceStringIndex(S, q, unicodeMatching);
	      } else {
	        A.push(S.slice(p, q));
	        if (A.length === lim) return A;

	        for (var i = 1; i <= z.length - 1; i++) {
	          A.push(z[i]);
	          if (A.length === lim) return A;
	        }

	        q = p = e;
	      }
	    }

	    A.push(S.slice(p));
	    return A;
	  }];
	}, !SUPPORTS_Y);

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};

	for (var COLLECTION_NAME in domIterables) {
	  var Collection = global_1[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype; // some Chrome versions have non-configurable methods on DOMTokenList

	  if (CollectionPrototype && CollectionPrototype.forEach !== arrayForEach) try {
	    createNonEnumerableProperty(CollectionPrototype, 'forEach', arrayForEach);
	  } catch (error) {
	    CollectionPrototype.forEach = arrayForEach;
	  }
	}

	var runtime_1 = createCommonjsModule(function (module) {
	  /**
	   * Copyright (c) 2014-present, Facebook, Inc.
	   *
	   * This source code is licensed under the MIT license found in the
	   * LICENSE file in the root directory of this source tree.
	   */
	  var runtime = function (exports) {

	    var Op = Object.prototype;
	    var hasOwn = Op.hasOwnProperty;
	    var undefined$1; // More compressible than void 0.

	    var $Symbol = typeof Symbol === "function" ? Symbol : {};
	    var iteratorSymbol = $Symbol.iterator || "@@iterator";
	    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	    function define(obj, key, value) {
	      Object.defineProperty(obj, key, {
	        value: value,
	        enumerable: true,
	        configurable: true,
	        writable: true
	      });
	      return obj[key];
	    }

	    try {
	      // IE 8 has a broken Object.defineProperty that only works on DOM objects.
	      define({}, "");
	    } catch (err) {
	      define = function (obj, key, value) {
	        return obj[key] = value;
	      };
	    }

	    function wrap(innerFn, outerFn, self, tryLocsList) {
	      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	      var generator = Object.create(protoGenerator.prototype);
	      var context = new Context(tryLocsList || []); // The ._invoke method unifies the implementations of the .next,
	      // .throw, and .return methods.

	      generator._invoke = makeInvokeMethod(innerFn, self, context);
	      return generator;
	    }

	    exports.wrap = wrap; // Try/catch helper to minimize deoptimizations. Returns a completion
	    // record like context.tryEntries[i].completion. This interface could
	    // have been (and was previously) designed to take a closure to be
	    // invoked without arguments, but in all the cases we care about we
	    // already have an existing method we want to call, so there's no need
	    // to create a new function object. We can even get away with assuming
	    // the method takes exactly one argument, since that happens to be true
	    // in every case, so we don't have to touch the arguments object. The
	    // only additional allocation required is the completion record, which
	    // has a stable shape and so hopefully should be cheap to allocate.

	    function tryCatch(fn, obj, arg) {
	      try {
	        return {
	          type: "normal",
	          arg: fn.call(obj, arg)
	        };
	      } catch (err) {
	        return {
	          type: "throw",
	          arg: err
	        };
	      }
	    }

	    var GenStateSuspendedStart = "suspendedStart";
	    var GenStateSuspendedYield = "suspendedYield";
	    var GenStateExecuting = "executing";
	    var GenStateCompleted = "completed"; // Returning this object from the innerFn has the same effect as
	    // breaking out of the dispatch switch statement.

	    var ContinueSentinel = {}; // Dummy constructor functions that we use as the .constructor and
	    // .constructor.prototype properties for functions that return Generator
	    // objects. For full spec compliance, you may wish to configure your
	    // minifier not to mangle the names of these two functions.

	    function Generator() {}

	    function GeneratorFunction() {}

	    function GeneratorFunctionPrototype() {} // This is a polyfill for %IteratorPrototype% for environments that
	    // don't natively support it.


	    var IteratorPrototype = {};

	    IteratorPrototype[iteratorSymbol] = function () {
	      return this;
	    };

	    var getProto = Object.getPrototypeOf;
	    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

	    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	      // This environment has a native %IteratorPrototype%; use it instead
	      // of the polyfill.
	      IteratorPrototype = NativeIteratorPrototype;
	    }

	    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	    GeneratorFunctionPrototype.constructor = GeneratorFunction;
	    GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"); // Helper for defining the .next, .throw, and .return methods of the
	    // Iterator interface in terms of a single ._invoke method.

	    function defineIteratorMethods(prototype) {
	      ["next", "throw", "return"].forEach(function (method) {
	        define(prototype, method, function (arg) {
	          return this._invoke(method, arg);
	        });
	      });
	    }

	    exports.isGeneratorFunction = function (genFun) {
	      var ctor = typeof genFun === "function" && genFun.constructor;
	      return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
	      // do is to check its .name property.
	      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
	    };

	    exports.mark = function (genFun) {
	      if (Object.setPrototypeOf) {
	        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	      } else {
	        genFun.__proto__ = GeneratorFunctionPrototype;
	        define(genFun, toStringTagSymbol, "GeneratorFunction");
	      }

	      genFun.prototype = Object.create(Gp);
	      return genFun;
	    }; // Within the body of any async function, `await x` is transformed to
	    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	    // `hasOwn.call(value, "__await")` to determine if the yielded value is
	    // meant to be awaited.


	    exports.awrap = function (arg) {
	      return {
	        __await: arg
	      };
	    };

	    function AsyncIterator(generator, PromiseImpl) {
	      function invoke(method, arg, resolve, reject) {
	        var record = tryCatch(generator[method], generator, arg);

	        if (record.type === "throw") {
	          reject(record.arg);
	        } else {
	          var result = record.arg;
	          var value = result.value;

	          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
	            return PromiseImpl.resolve(value.__await).then(function (value) {
	              invoke("next", value, resolve, reject);
	            }, function (err) {
	              invoke("throw", err, resolve, reject);
	            });
	          }

	          return PromiseImpl.resolve(value).then(function (unwrapped) {
	            // When a yielded Promise is resolved, its final value becomes
	            // the .value of the Promise<{value,done}> result for the
	            // current iteration.
	            result.value = unwrapped;
	            resolve(result);
	          }, function (error) {
	            // If a rejected Promise was yielded, throw the rejection back
	            // into the async generator function so it can be handled there.
	            return invoke("throw", error, resolve, reject);
	          });
	        }
	      }

	      var previousPromise;

	      function enqueue(method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }

	        return previousPromise = // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, // Avoid propagating failures to Promises returned by later
	        // invocations of the iterator.
	        callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      } // Define the unified helper method that is used to implement .next,
	      // .throw, and .return (see defineIteratorMethods).


	      this._invoke = enqueue;
	    }

	    defineIteratorMethods(AsyncIterator.prototype);

	    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	      return this;
	    };

	    exports.AsyncIterator = AsyncIterator; // Note that simple async functions are implemented on top of
	    // AsyncIterator objects; they just return a Promise for the value of
	    // the final result produced by the iterator.

	    exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	      if (PromiseImpl === void 0) PromiseImpl = Promise;
	      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	      return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function (result) {
	        return result.done ? result.value : iter.next();
	      });
	    };

	    function makeInvokeMethod(innerFn, self, context) {
	      var state = GenStateSuspendedStart;
	      return function invoke(method, arg) {
	        if (state === GenStateExecuting) {
	          throw new Error("Generator is already running");
	        }

	        if (state === GenStateCompleted) {
	          if (method === "throw") {
	            throw arg;
	          } // Be forgiving, per 25.3.3.3.3 of the spec:
	          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume


	          return doneResult();
	        }

	        context.method = method;
	        context.arg = arg;

	        while (true) {
	          var delegate = context.delegate;

	          if (delegate) {
	            var delegateResult = maybeInvokeDelegate(delegate, context);

	            if (delegateResult) {
	              if (delegateResult === ContinueSentinel) continue;
	              return delegateResult;
	            }
	          }

	          if (context.method === "next") {
	            // Setting context._sent for legacy support of Babel's
	            // function.sent implementation.
	            context.sent = context._sent = context.arg;
	          } else if (context.method === "throw") {
	            if (state === GenStateSuspendedStart) {
	              state = GenStateCompleted;
	              throw context.arg;
	            }

	            context.dispatchException(context.arg);
	          } else if (context.method === "return") {
	            context.abrupt("return", context.arg);
	          }

	          state = GenStateExecuting;
	          var record = tryCatch(innerFn, self, context);

	          if (record.type === "normal") {
	            // If an exception is thrown from innerFn, we leave state ===
	            // GenStateExecuting and loop back for another invocation.
	            state = context.done ? GenStateCompleted : GenStateSuspendedYield;

	            if (record.arg === ContinueSentinel) {
	              continue;
	            }

	            return {
	              value: record.arg,
	              done: context.done
	            };
	          } else if (record.type === "throw") {
	            state = GenStateCompleted; // Dispatch the exception by looping back around to the
	            // context.dispatchException(context.arg) call above.

	            context.method = "throw";
	            context.arg = record.arg;
	          }
	        }
	      };
	    } // Call delegate.iterator[context.method](context.arg) and handle the
	    // result, either by returning a { value, done } result from the
	    // delegate iterator, or by modifying context.method and context.arg,
	    // setting context.delegate to null, and returning the ContinueSentinel.


	    function maybeInvokeDelegate(delegate, context) {
	      var method = delegate.iterator[context.method];

	      if (method === undefined$1) {
	        // A .throw or .return when the delegate iterator has no .throw
	        // method always terminates the yield* loop.
	        context.delegate = null;

	        if (context.method === "throw") {
	          // Note: ["return"] must be used for ES3 parsing compatibility.
	          if (delegate.iterator["return"]) {
	            // If the delegate iterator has a return method, give it a
	            // chance to clean up.
	            context.method = "return";
	            context.arg = undefined$1;
	            maybeInvokeDelegate(delegate, context);

	            if (context.method === "throw") {
	              // If maybeInvokeDelegate(context) changed context.method from
	              // "return" to "throw", let that override the TypeError below.
	              return ContinueSentinel;
	            }
	          }

	          context.method = "throw";
	          context.arg = new TypeError("The iterator does not provide a 'throw' method");
	        }

	        return ContinueSentinel;
	      }

	      var record = tryCatch(method, delegate.iterator, context.arg);

	      if (record.type === "throw") {
	        context.method = "throw";
	        context.arg = record.arg;
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      var info = record.arg;

	      if (!info) {
	        context.method = "throw";
	        context.arg = new TypeError("iterator result is not an object");
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      if (info.done) {
	        // Assign the result of the finished delegate to the temporary
	        // variable specified by delegate.resultName (see delegateYield).
	        context[delegate.resultName] = info.value; // Resume execution at the desired location (see delegateYield).

	        context.next = delegate.nextLoc; // If context.method was "throw" but the delegate handled the
	        // exception, let the outer generator proceed normally. If
	        // context.method was "next", forget context.arg since it has been
	        // "consumed" by the delegate iterator. If context.method was
	        // "return", allow the original .return call to continue in the
	        // outer generator.

	        if (context.method !== "return") {
	          context.method = "next";
	          context.arg = undefined$1;
	        }
	      } else {
	        // Re-yield the result returned by the delegate method.
	        return info;
	      } // The delegate iterator is finished, so forget it and continue with
	      // the outer generator.


	      context.delegate = null;
	      return ContinueSentinel;
	    } // Define Generator.prototype.{next,throw,return} in terms of the
	    // unified ._invoke helper method.


	    defineIteratorMethods(Gp);
	    define(Gp, toStringTagSymbol, "Generator"); // A Generator should always return itself as the iterator object when the
	    // @@iterator function is called on it. Some browsers' implementations of the
	    // iterator prototype chain incorrectly implement this, causing the Generator
	    // object to not be returned from this call. This ensures that doesn't happen.
	    // See https://github.com/facebook/regenerator/issues/274 for more details.

	    Gp[iteratorSymbol] = function () {
	      return this;
	    };

	    Gp.toString = function () {
	      return "[object Generator]";
	    };

	    function pushTryEntry(locs) {
	      var entry = {
	        tryLoc: locs[0]
	      };

	      if (1 in locs) {
	        entry.catchLoc = locs[1];
	      }

	      if (2 in locs) {
	        entry.finallyLoc = locs[2];
	        entry.afterLoc = locs[3];
	      }

	      this.tryEntries.push(entry);
	    }

	    function resetTryEntry(entry) {
	      var record = entry.completion || {};
	      record.type = "normal";
	      delete record.arg;
	      entry.completion = record;
	    }

	    function Context(tryLocsList) {
	      // The root entry object (effectively a try statement without a catch
	      // or a finally block) gives us a place to store values thrown from
	      // locations where there is no enclosing try statement.
	      this.tryEntries = [{
	        tryLoc: "root"
	      }];
	      tryLocsList.forEach(pushTryEntry, this);
	      this.reset(true);
	    }

	    exports.keys = function (object) {
	      var keys = [];

	      for (var key in object) {
	        keys.push(key);
	      }

	      keys.reverse(); // Rather than returning an object with a next method, we keep
	      // things simple and return the next function itself.

	      return function next() {
	        while (keys.length) {
	          var key = keys.pop();

	          if (key in object) {
	            next.value = key;
	            next.done = false;
	            return next;
	          }
	        } // To avoid creating an additional object, we just hang the .value
	        // and .done properties off the next function object itself. This
	        // also ensures that the minifier will not anonymize the function.


	        next.done = true;
	        return next;
	      };
	    };

	    function values(iterable) {
	      if (iterable) {
	        var iteratorMethod = iterable[iteratorSymbol];

	        if (iteratorMethod) {
	          return iteratorMethod.call(iterable);
	        }

	        if (typeof iterable.next === "function") {
	          return iterable;
	        }

	        if (!isNaN(iterable.length)) {
	          var i = -1,
	              next = function next() {
	            while (++i < iterable.length) {
	              if (hasOwn.call(iterable, i)) {
	                next.value = iterable[i];
	                next.done = false;
	                return next;
	              }
	            }

	            next.value = undefined$1;
	            next.done = true;
	            return next;
	          };

	          return next.next = next;
	        }
	      } // Return an iterator with no values.


	      return {
	        next: doneResult
	      };
	    }

	    exports.values = values;

	    function doneResult() {
	      return {
	        value: undefined$1,
	        done: true
	      };
	    }

	    Context.prototype = {
	      constructor: Context,
	      reset: function (skipTempReset) {
	        this.prev = 0;
	        this.next = 0; // Resetting context._sent for legacy support of Babel's
	        // function.sent implementation.

	        this.sent = this._sent = undefined$1;
	        this.done = false;
	        this.delegate = null;
	        this.method = "next";
	        this.arg = undefined$1;
	        this.tryEntries.forEach(resetTryEntry);

	        if (!skipTempReset) {
	          for (var name in this) {
	            // Not sure about the optimal order of these conditions:
	            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
	              this[name] = undefined$1;
	            }
	          }
	        }
	      },
	      stop: function () {
	        this.done = true;
	        var rootEntry = this.tryEntries[0];
	        var rootRecord = rootEntry.completion;

	        if (rootRecord.type === "throw") {
	          throw rootRecord.arg;
	        }

	        return this.rval;
	      },
	      dispatchException: function (exception) {
	        if (this.done) {
	          throw exception;
	        }

	        var context = this;

	        function handle(loc, caught) {
	          record.type = "throw";
	          record.arg = exception;
	          context.next = loc;

	          if (caught) {
	            // If the dispatched exception was caught by a catch block,
	            // then let that catch block handle the exception normally.
	            context.method = "next";
	            context.arg = undefined$1;
	          }

	          return !!caught;
	        }

	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          var record = entry.completion;

	          if (entry.tryLoc === "root") {
	            // Exception thrown outside of any try block that could handle
	            // it, so set the completion value of the entire function to
	            // throw the exception.
	            return handle("end");
	          }

	          if (entry.tryLoc <= this.prev) {
	            var hasCatch = hasOwn.call(entry, "catchLoc");
	            var hasFinally = hasOwn.call(entry, "finallyLoc");

	            if (hasCatch && hasFinally) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              } else if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else if (hasCatch) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              }
	            } else if (hasFinally) {
	              if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else {
	              throw new Error("try statement without catch or finally");
	            }
	          }
	        }
	      },
	      abrupt: function (type, arg) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	            var finallyEntry = entry;
	            break;
	          }
	        }

	        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
	          // Ignore the finally entry if control is not jumping to a
	          // location outside the try/catch block.
	          finallyEntry = null;
	        }

	        var record = finallyEntry ? finallyEntry.completion : {};
	        record.type = type;
	        record.arg = arg;

	        if (finallyEntry) {
	          this.method = "next";
	          this.next = finallyEntry.finallyLoc;
	          return ContinueSentinel;
	        }

	        return this.complete(record);
	      },
	      complete: function (record, afterLoc) {
	        if (record.type === "throw") {
	          throw record.arg;
	        }

	        if (record.type === "break" || record.type === "continue") {
	          this.next = record.arg;
	        } else if (record.type === "return") {
	          this.rval = this.arg = record.arg;
	          this.method = "return";
	          this.next = "end";
	        } else if (record.type === "normal" && afterLoc) {
	          this.next = afterLoc;
	        }

	        return ContinueSentinel;
	      },
	      finish: function (finallyLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.finallyLoc === finallyLoc) {
	            this.complete(entry.completion, entry.afterLoc);
	            resetTryEntry(entry);
	            return ContinueSentinel;
	          }
	        }
	      },
	      "catch": function (tryLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc === tryLoc) {
	            var record = entry.completion;

	            if (record.type === "throw") {
	              var thrown = record.arg;
	              resetTryEntry(entry);
	            }

	            return thrown;
	          }
	        } // The context.catch method must only be called with a location
	        // argument that corresponds to a known catch block.


	        throw new Error("illegal catch attempt");
	      },
	      delegateYield: function (iterable, resultName, nextLoc) {
	        this.delegate = {
	          iterator: values(iterable),
	          resultName: resultName,
	          nextLoc: nextLoc
	        };

	        if (this.method === "next") {
	          // Deliberately forget the last sent value so that we don't
	          // accidentally pass it on to the delegate.
	          this.arg = undefined$1;
	        }

	        return ContinueSentinel;
	      }
	    }; // Regardless of whether this script is executing as a CommonJS module
	    // or not, return the runtime object so that we can declare the variable
	    // regeneratorRuntime in the outer scope, which allows this module to be
	    // injected easily by `bin/regenerator --include-runtime script.js`.

	    return exports;
	  }( // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	   module.exports );

	  try {
	    regeneratorRuntime = runtime;
	  } catch (accidentalStrictMode) {
	    // This module should not be running in strict mode, so the above
	    // assignment should always work unless something is misconfigured. Just
	    // in case runtime.js accidentally runs in strict mode, we can escape
	    // strict mode using a global Function call. This could conceivably fail
	    // if a Content Security Policy forbids using Function, but in that case
	    // the proper solution is to fix the accidental strict mode problem. If
	    // you've misconfigured your bundler to force strict mode and applied a
	    // CSP to forbid Function, and you're not willing to fix either of those
	    // problems, please detail your unique predicament in a GitHub issue.
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	});

	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    _typeof = function (obj) {
	      return typeof obj;
	    };
	  } else {
	    _typeof = function (obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };
	  }

	  return _typeof(obj);
	}

	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }

	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}

	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	        args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);

	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }

	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }

	      _next(undefined);
	    });
	  };
	}

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = Object.create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	function _getPrototypeOf(o) {
	  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
	    return o.__proto__ || Object.getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}

	function _setPrototypeOf(o, p) {
	  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };

	  return _setPrototypeOf(o, p);
	}

	function _isNativeReflectConstruct() {
	  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
	  if (Reflect.construct.sham) return false;
	  if (typeof Proxy === "function") return true;

	  try {
	    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
	    return true;
	  } catch (e) {
	    return false;
	  }
	}

	function _construct(Parent, args, Class) {
	  if (_isNativeReflectConstruct()) {
	    _construct = Reflect.construct;
	  } else {
	    _construct = function _construct(Parent, args, Class) {
	      var a = [null];
	      a.push.apply(a, args);
	      var Constructor = Function.bind.apply(Parent, a);
	      var instance = new Constructor();
	      if (Class) _setPrototypeOf(instance, Class.prototype);
	      return instance;
	    };
	  }

	  return _construct.apply(null, arguments);
	}

	function _isNativeFunction(fn) {
	  return Function.toString.call(fn).indexOf("[native code]") !== -1;
	}

	function _wrapNativeSuper(Class) {
	  var _cache = typeof Map === "function" ? new Map() : undefined;

	  _wrapNativeSuper = function _wrapNativeSuper(Class) {
	    if (Class === null || !_isNativeFunction(Class)) return Class;

	    if (typeof Class !== "function") {
	      throw new TypeError("Super expression must either be null or a function");
	    }

	    if (typeof _cache !== "undefined") {
	      if (_cache.has(Class)) return _cache.get(Class);

	      _cache.set(Class, Wrapper);
	    }

	    function Wrapper() {
	      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
	    }

	    Wrapper.prototype = Object.create(Class.prototype, {
	      constructor: {
	        value: Wrapper,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    return _setPrototypeOf(Wrapper, Class);
	  };

	  return _wrapNativeSuper(Class);
	}

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (typeof call === "object" || typeof call === "function")) {
	    return call;
	  }

	  return _assertThisInitialized(self);
	}

	function _createSuper(Derived) {
	  var hasNativeReflectConstruct = _isNativeReflectConstruct();

	  return function _createSuperInternal() {
	    var Super = _getPrototypeOf(Derived),
	        result;

	    if (hasNativeReflectConstruct) {
	      var NewTarget = _getPrototypeOf(this).constructor;

	      result = Reflect.construct(Super, arguments, NewTarget);
	    } else {
	      result = Super.apply(this, arguments);
	    }

	    return _possibleConstructorReturn(this, result);
	  };
	}

	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = _getPrototypeOf(object);
	    if (object === null) break;
	  }

	  return object;
	}

	function _get(target, property, receiver) {
	  if (typeof Reflect !== "undefined" && Reflect.get) {
	    _get = Reflect.get;
	  } else {
	    _get = function _get(target, property, receiver) {
	      var base = _superPropBase(target, property);

	      if (!base) return;
	      var desc = Object.getOwnPropertyDescriptor(base, property);

	      if (desc.get) {
	        return desc.get.call(receiver);
	      }

	      return desc.value;
	    };
	  }

	  return _get(target, property, receiver || target);
	}

	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
	}

	function _toArray(arr) {
	  return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
	}

	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
	}

	function _arrayWithoutHoles(arr) {
	  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
	}

	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}

	function _iterableToArray(iter) {
	  if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
	}

	function _iterableToArrayLimit(arr, i) {
	  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;
	  var _e = undefined;

	  try {
	    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
	}

	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

	  return arr2;
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _createForOfIteratorHelper(o, allowArrayLike) {
	  var it;

	  if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
	    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
	      if (it) o = it;
	      var i = 0;

	      var F = function () {};

	      return {
	        s: F,
	        n: function () {
	          if (i >= o.length) return {
	            done: true
	          };
	          return {
	            done: false,
	            value: o[i++]
	          };
	        },
	        e: function (e) {
	          throw e;
	        },
	        f: F
	      };
	    }

	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }

	  var normalCompletion = true,
	      didErr = false,
	      err;
	  return {
	    s: function () {
	      it = o[Symbol.iterator]();
	    },
	    n: function () {
	      var step = it.next();
	      normalCompletion = step.done;
	      return step;
	    },
	    e: function (e) {
	      didErr = true;
	      err = e;
	    },
	    f: function () {
	      try {
	        if (!normalCompletion && it.return != null) it.return();
	      } finally {
	        if (didErr) throw err;
	      }
	    }
	  };
	}

	var btoa$1 = createCommonjsModule(function (module) {
	  (function () {

	    function btoa(str) {
	      var buffer;

	      if (str instanceof Buffer) {
	        buffer = str;
	      } else {
	        buffer = Buffer.from(str.toString(), 'binary');
	      }

	      return buffer.toString('base64');
	    }

	    module.exports = btoa;
	  })();
	});

	function div(options) {
	  return create("div", options);
	}

	function create(tag, options) {
	  const elem = document.createElement(tag);

	  if (options) {
	    if (options.class) {
	      elem.classList.add(options.class);
	    }

	    if (options.id) {
	      elem.id = options.id;
	    }

	    if (options.style) {
	      applyStyle(elem, options.style);
	    }
	  }

	  return elem;
	}

	function hide(elem) {
	  const cssStyle = getComputedStyle(elem);

	  if (cssStyle.display !== "none") {
	    elem._initialDisplay = cssStyle.display;
	  }

	  elem.style.display = "none";
	}

	function show(elem) {
	  const currentDisplay = getComputedStyle(elem).display;

	  if (currentDisplay === "none") {
	    const d = elem._initialDisplay || "block";
	    elem.style.display = d;
	  }
	}

	function offset(elem) {
	  // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
	  // Support: IE <=11 only
	  // Running getBoundingClientRect on a
	  // disconnected node in IE throws an error
	  if (!elem.getClientRects().length) {
	    return {
	      top: 0,
	      left: 0
	    };
	  } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


	  const rect = elem.getBoundingClientRect();
	  const win = elem.ownerDocument.defaultView;
	  return {
	    top: rect.top + win.pageYOffset,
	    left: rect.left + win.pageXOffset
	  };
	}

	function pageCoordinates(e) {
	  if (e.type.startsWith("touch")) {
	    const touch = e.touches[0];
	    return {
	      x: touch.pageX,
	      y: touch.pageY
	    };
	  } else {
	    return {
	      x: e.pageX,
	      y: e.pageY
	    };
	  }
	}

	function applyStyle(elem, style) {
	  for (let key of Object.keys(style)) {
	    elem.style[key] = style[key];
	  }
	}

	let getMouseXY = (domElement, {
	  clientX,
	  clientY
	}) => {
	  // DOMRect object with eight properties: left, top, right, bottom, x, y, width, height
	  const {
	    left,
	    top,
	    width,
	    height
	  } = domElement.getBoundingClientRect();
	  const x = clientX - left;
	  const y = clientY - top;
	  return {
	    x,
	    y,
	    xNormalized: x / width,
	    yNormalized: y / height,
	    width,
	    height
	  };
	};
	/**
	 * Translate the mouse coordinates for the event to the coordinates for the given target element
	 * @param event
	 * @param domElement
	 * @returns {{x: number, y: number}}
	 */


	function translateMouseCoordinates(event, domElement) {
	  const {
	    clientX,
	    clientY
	  } = event;
	  return getMouseXY(domElement, {
	    clientX,
	    clientY
	  });
	}

	function createCheckbox(name, initialState) {
	  const container = div({
	    class: 'igv-ui-trackgear-popover-check-container'
	  });
	  const svg = iconMarkup('check', true === initialState ? '#444' : 'transparent');
	  svg.style.borderColor = 'gray';
	  svg.style.borderWidth = '1px';
	  svg.style.borderStyle = 'solid';
	  container.appendChild(svg);
	  let label = div(); //{ class: 'igv-some-label-class' });

	  label.textContent = name;
	  container.appendChild(label);
	  return container;
	}

	function createIcon(name, color) {
	  return iconMarkup(name, color);
	}

	function iconMarkup(name, color) {
	  color = color || "currentColor";
	  let icon = icons[name];

	  if (!icon) {
	    console.error(`No icon named: ${name}`);
	    icon = icons["question"];
	  }

	  const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
	  svg.setAttributeNS(null, 'viewBox', '0 0 ' + icon[0] + ' ' + icon[1]);
	  const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
	  path.setAttributeNS(null, 'fill', color);
	  path.setAttributeNS(null, 'd', icon[4]);
	  svg.appendChild(path);
	  return svg;
	}

	const icons = {
	  "check": [512, 512, [], "f00c", "M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"],
	  "cog": [512, 512, [], "f013", "M444.788 291.1l42.616 24.599c4.867 2.809 7.126 8.618 5.459 13.985-11.07 35.642-29.97 67.842-54.689 94.586a12.016 12.016 0 0 1-14.832 2.254l-42.584-24.595a191.577 191.577 0 0 1-60.759 35.13v49.182a12.01 12.01 0 0 1-9.377 11.718c-34.956 7.85-72.499 8.256-109.219.007-5.49-1.233-9.403-6.096-9.403-11.723v-49.184a191.555 191.555 0 0 1-60.759-35.13l-42.584 24.595a12.016 12.016 0 0 1-14.832-2.254c-24.718-26.744-43.619-58.944-54.689-94.586-1.667-5.366.592-11.175 5.459-13.985L67.212 291.1a193.48 193.48 0 0 1 0-70.199l-42.616-24.599c-4.867-2.809-7.126-8.618-5.459-13.985 11.07-35.642 29.97-67.842 54.689-94.586a12.016 12.016 0 0 1 14.832-2.254l42.584 24.595a191.577 191.577 0 0 1 60.759-35.13V25.759a12.01 12.01 0 0 1 9.377-11.718c34.956-7.85 72.499-8.256 109.219-.007 5.49 1.233 9.403 6.096 9.403 11.723v49.184a191.555 191.555 0 0 1 60.759 35.13l42.584-24.595a12.016 12.016 0 0 1 14.832 2.254c24.718 26.744 43.619 58.944 54.689 94.586 1.667 5.366-.592 11.175-5.459 13.985L444.788 220.9a193.485 193.485 0 0 1 0 70.2zM336 256c0-44.112-35.888-80-80-80s-80 35.888-80 80 35.888 80 80 80 80-35.888 80-80z"],
	  "exclamation": [192, 512, [], "f12a", "M176 432c0 44.112-35.888 80-80 80s-80-35.888-80-80 35.888-80 80-80 80 35.888 80 80zM25.26 25.199l13.6 272C39.499 309.972 50.041 320 62.83 320h66.34c12.789 0 23.331-10.028 23.97-22.801l13.6-272C167.425 11.49 156.496 0 142.77 0H49.23C35.504 0 24.575 11.49 25.26 25.199z"],
	  "exclamation-circle": [512, 512, [], "f06a", "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
	  "exclamation-triangle": [576, 512, [], "f071", "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
	  "minus": [448, 512, [], "f068", "M424 318.2c13.3 0 24-10.7 24-24v-76.4c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h400z"],
	  "minus-circle": [512, 512, [], "f056", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zM124 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H124z"],
	  "minus-square": [448, 512, [], "f146", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM92 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H92z"],
	  "plus": [448, 512, [], "f067", "M448 294.2v-76.4c0-13.3-10.7-24-24-24H286.2V56c0-13.3-10.7-24-24-24h-76.4c-13.3 0-24 10.7-24 24v137.8H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h137.8V456c0 13.3 10.7 24 24 24h76.4c13.3 0 24-10.7 24-24V318.2H424c13.3 0 24-10.7 24-24z"],
	  "plus-circle": [512, 512, [], "f055", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92h-92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
	  "plus-square": [448, 512, [], "f0fe", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-32 252c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92H92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
	  "question": [384, 512, [], "f128", "M202.021 0C122.202 0 70.503 32.703 29.914 91.026c-7.363 10.58-5.093 25.086 5.178 32.874l43.138 32.709c10.373 7.865 25.132 6.026 33.253-4.148 25.049-31.381 43.63-49.449 82.757-49.449 30.764 0 68.816 19.799 68.816 49.631 0 22.552-18.617 34.134-48.993 51.164-35.423 19.86-82.299 44.576-82.299 106.405V320c0 13.255 10.745 24 24 24h72.471c13.255 0 24-10.745 24-24v-5.773c0-42.86 125.268-44.645 125.268-160.627C377.504 66.256 286.902 0 202.021 0zM192 373.459c-38.196 0-69.271 31.075-69.271 69.271 0 38.195 31.075 69.27 69.271 69.27s69.271-31.075 69.271-69.271-31.075-69.27-69.271-69.27z"],
	  "save": [448, 512, [], "f0c7", "M433.941 129.941l-83.882-83.882A48 48 0 0 0 316.118 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V163.882a48 48 0 0 0-14.059-33.941zM224 416c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64s64 28.654 64 64c0 35.346-28.654 64-64 64zm96-304.52V212c0 6.627-5.373 12-12 12H76c-6.627 0-12-5.373-12-12V108c0-6.627 5.373-12 12-12h228.52c3.183 0 6.235 1.264 8.485 3.515l3.48 3.48A11.996 11.996 0 0 1 320 111.48z"],
	  "search": [512, 512, [], "f002", "M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"],
	  "share": [512, 512, [], "f064", "M503.691 189.836L327.687 37.851C312.281 24.546 288 35.347 288 56.015v80.053C127.371 137.907 0 170.1 0 322.326c0 61.441 39.581 122.309 83.333 154.132 13.653 9.931 33.111-2.533 28.077-18.631C66.066 312.814 132.917 274.316 288 272.085V360c0 20.7 24.3 31.453 39.687 18.164l176.004-152c11.071-9.562 11.086-26.753 0-36.328z"],
	  "spinner": [512, 512, [], "f110", "M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z"],
	  "square": [448, 512, [], "f0c8", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48z"],
	  "square-full": [512, 512, [], "f45c", "M512 512H0V0h512v512z"],
	  "times": [384, 512, [], "f00d", "M323.1 441l53.9-53.9c9.4-9.4 9.4-24.5 0-33.9L279.8 256l97.2-97.2c9.4-9.4 9.4-24.5 0-33.9L323.1 71c-9.4-9.4-24.5-9.4-33.9 0L192 168.2 94.8 71c-9.4-9.4-24.5-9.4-33.9 0L7 124.9c-9.4 9.4-9.4 24.5 0 33.9l97.2 97.2L7 353.2c-9.4 9.4-9.4 24.5 0 33.9L60.9 441c9.4 9.4 24.5 9.4 33.9 0l97.2-97.2 97.2 97.2c9.3 9.3 24.5 9.3 33.9 0z"],
	  "times-circle": [512, 512, [], "f057", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z"],
	  "wrench": [512, 512, [], "f0ad", "M481.156 200c9.3 0 15.12 10.155 10.325 18.124C466.295 259.992 420.419 288 368 288c-79.222 0-143.501-63.974-143.997-143.079C223.505 65.469 288.548-.001 368.002 0c52.362.001 98.196 27.949 123.4 69.743C496.24 77.766 490.523 88 481.154 88H376l-40 56 40 56h105.156zm-171.649 93.003L109.255 493.255c-24.994 24.993-65.515 24.994-90.51 0-24.993-24.994-24.993-65.516 0-90.51L218.991 202.5c16.16 41.197 49.303 74.335 90.516 90.503zM104 432c0-13.255-10.745-24-24-24s-24 10.745-24 24 10.745 24 24 24 24-10.745 24-24z"]
	};

	function attachDialogCloseHandlerWithParent(parent, closeHandler) {
	  var container = document.createElement("div");
	  parent.appendChild(container);
	  container.appendChild(createIcon("times"));
	  container.addEventListener('click', function (e) {
	    e.preventDefault();
	    e.stopPropagation();
	    closeHandler();
	  });
	}
	/**
	 * @fileoverview Zlib namespace. Zlib の仕様に準拠した圧縮は Zlib.Deflate で実装
	 * されている. これは Inflate との共存を考慮している為.
	 */


	const ZLIB_STREAM_RAW_INFLATE_BUFFER_SIZE = 65000;
	var Zlib = {
	  Huffman: {},
	  Util: {},
	  CRC32: {}
	};
	/**
	 * Compression Method
	 * @enum {number}
	 */

	Zlib.CompressionMethod = {
	  DEFLATE: 8,
	  RESERVED: 15
	};
	/**
	 * @param {Object=} opt_params options.
	 * @constructor
	 */

	Zlib.Zip = function (opt_params) {
	  opt_params = opt_params || {};
	  /** @type {Array.<{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }>} */

	  this.files = [];
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.comment = opt_params['comment'];
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.password;
	};
	/**
	 * @enum {number}
	 */


	Zlib.Zip.CompressionMethod = {
	  STORE: 0,
	  DEFLATE: 8
	};
	/**
	 * @enum {number}
	 */

	Zlib.Zip.OperatingSystem = {
	  MSDOS: 0,
	  UNIX: 3,
	  MACINTOSH: 7
	};
	/**
	 * @enum {number}
	 */

	Zlib.Zip.Flags = {
	  ENCRYPT: 0x0001,
	  DESCRIPTOR: 0x0008,
	  UTF8: 0x0800
	};
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Zip.FileHeaderSignature = [0x50, 0x4b, 0x01, 0x02];
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Zip.LocalFileHeaderSignature = [0x50, 0x4b, 0x03, 0x04];
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Zip.CentralDirectorySignature = [0x50, 0x4b, 0x05, 0x06];
	/**
	 * @param {Array.<number>|Uint8Array} input
	 * @param {Object=} opt_params options.
	 */

	Zlib.Zip.prototype.addFile = function (input, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {string} */

	  var filename = opt_params['filename'];
	  /** @type {boolean} */

	  var compressed;
	  /** @type {number} */

	  var size = input.length;
	  /** @type {number} */

	  var crc32 = 0;

	  if (input instanceof Array) {
	    input = new Uint8Array(input);
	  } // default


	  if (typeof opt_params['compressionMethod'] !== 'number') {
	    opt_params['compressionMethod'] = Zlib.Zip.CompressionMethod.DEFLATE;
	  } // その場で圧縮する場合


	  if (opt_params['compress']) {
	    switch (opt_params['compressionMethod']) {
	      case Zlib.Zip.CompressionMethod.STORE:
	        break;

	      case Zlib.Zip.CompressionMethod.DEFLATE:
	        crc32 = Zlib.CRC32.calc(input);
	        input = this.deflateWithOption(input, opt_params);
	        compressed = true;
	        break;

	      default:
	        throw new Error('unknown compression method:' + opt_params['compressionMethod']);
	    }
	  }

	  this.files.push({
	    buffer: input,
	    option: opt_params,
	    compressed: compressed,
	    encrypted: false,
	    size: size,
	    crc32: crc32
	  });
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 */


	Zlib.Zip.prototype.setPassword = function (password) {
	  this.password = password;
	};

	Zlib.Zip.prototype.compress = function () {
	  /** @type {Array.<{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }>} */
	  var files = this.files;
	  /** @type {{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }} */

	  var file;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var output;
	  /** @type {number} */

	  var op1;
	  /** @type {number} */

	  var op2;
	  /** @type {number} */

	  var op3;
	  /** @type {number} */

	  var localFileSize = 0;
	  /** @type {number} */

	  var centralDirectorySize = 0;
	  /** @type {number} */

	  var endOfCentralDirectorySize;
	  /** @type {number} */

	  var offset;
	  /** @type {number} */

	  var needVersion;
	  /** @type {number} */

	  var flags;
	  /** @type {Zlib.Zip.CompressionMethod} */

	  var compressionMethod;
	  /** @type {Date} */

	  var date;
	  /** @type {number} */

	  var crc32;
	  /** @type {number} */

	  var size;
	  /** @type {number} */

	  var plainSize;
	  /** @type {number} */

	  var filenameLength;
	  /** @type {number} */

	  var extraFieldLength;
	  /** @type {number} */

	  var commentLength;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var filename;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var extraField;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var comment;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var buffer;
	  /** @type {*} */

	  var tmp;
	  /** @type {Array.<number>|Uint32Array|Object} */

	  var key;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {number} */

	  var j;
	  /** @type {number} */

	  var jl; // ファイルの圧縮

	  for (i = 0, il = files.length; i < il; ++i) {
	    file = files[i];
	    filenameLength = file.option['filename'] ? file.option['filename'].length : 0;
	    extraFieldLength = file.option['extraField'] ? file.option['extraField'].length : 0;
	    commentLength = file.option['comment'] ? file.option['comment'].length : 0; // 圧縮されていなかったら圧縮

	    if (!file.compressed) {
	      // 圧縮前に CRC32 の計算をしておく
	      file.crc32 = Zlib.CRC32.calc(file.buffer);

	      switch (file.option['compressionMethod']) {
	        case Zlib.Zip.CompressionMethod.STORE:
	          break;

	        case Zlib.Zip.CompressionMethod.DEFLATE:
	          file.buffer = this.deflateWithOption(file.buffer, file.option);
	          file.compressed = true;
	          break;

	        default:
	          throw new Error('unknown compression method:' + file.option['compressionMethod']);
	      }
	    } // encryption


	    if (file.option['password'] !== void 0 || this.password !== void 0) {
	      // init encryption
	      key = this.createEncryptionKey(file.option['password'] || this.password); // add header

	      buffer = file.buffer;
	      {
	        tmp = new Uint8Array(buffer.length + 12);
	        tmp.set(buffer, 12);
	        buffer = tmp;
	      }

	      for (j = 0; j < 12; ++j) {
	        buffer[j] = this.encode(key, i === 11 ? file.crc32 & 0xff : Math.random() * 256 | 0);
	      } // data encryption


	      for (jl = buffer.length; j < jl; ++j) {
	        buffer[j] = this.encode(key, buffer[j]);
	      }

	      file.buffer = buffer;
	    } // 必要バッファサイズの計算


	    localFileSize += // local file header
	    30 + filenameLength + // file data
	    file.buffer.length;
	    centralDirectorySize += // file header
	    46 + filenameLength + commentLength;
	  } // end of central directory


	  endOfCentralDirectorySize = 22 + (this.comment ? this.comment.length : 0);
	  output = new Uint8Array(localFileSize + centralDirectorySize + endOfCentralDirectorySize);
	  op1 = 0;
	  op2 = localFileSize;
	  op3 = op2 + centralDirectorySize; // ファイルの圧縮

	  for (i = 0, il = files.length; i < il; ++i) {
	    file = files[i];
	    filenameLength = file.option['filename'] ? file.option['filename'].length : 0;
	    extraFieldLength = 0; // TODO

	    commentLength = file.option['comment'] ? file.option['comment'].length : 0; //-------------------------------------------------------------------------
	    // local file header & file header
	    //-------------------------------------------------------------------------

	    offset = op1; // signature
	    // local file header

	    output[op1++] = Zlib.Zip.LocalFileHeaderSignature[0];
	    output[op1++] = Zlib.Zip.LocalFileHeaderSignature[1];
	    output[op1++] = Zlib.Zip.LocalFileHeaderSignature[2];
	    output[op1++] = Zlib.Zip.LocalFileHeaderSignature[3]; // file header

	    output[op2++] = Zlib.Zip.FileHeaderSignature[0];
	    output[op2++] = Zlib.Zip.FileHeaderSignature[1];
	    output[op2++] = Zlib.Zip.FileHeaderSignature[2];
	    output[op2++] = Zlib.Zip.FileHeaderSignature[3]; // compressor info

	    needVersion = 20;
	    output[op2++] = needVersion & 0xff;
	    output[op2++] =
	    /** @type {Zlib.Zip.OperatingSystem} */
	    file.option['os'] || Zlib.Zip.OperatingSystem.MSDOS; // need version

	    output[op1++] = output[op2++] = needVersion & 0xff;
	    output[op1++] = output[op2++] = needVersion >> 8 & 0xff; // general purpose bit flag

	    flags = 0;

	    if (file.option['password'] || this.password) {
	      flags |= Zlib.Zip.Flags.ENCRYPT;
	    }

	    output[op1++] = output[op2++] = flags & 0xff;
	    output[op1++] = output[op2++] = flags >> 8 & 0xff; // compression method

	    compressionMethod =
	    /** @type {Zlib.Zip.CompressionMethod} */
	    file.option['compressionMethod'];
	    output[op1++] = output[op2++] = compressionMethod & 0xff;
	    output[op1++] = output[op2++] = compressionMethod >> 8 & 0xff; // date

	    date =
	    /** @type {(Date|undefined)} */
	    file.option['date'] || new Date();
	    output[op1++] = output[op2++] = (date.getMinutes() & 0x7) << 5 | (date.getSeconds() / 2 | 0);
	    output[op1++] = output[op2++] = date.getHours() << 3 | date.getMinutes() >> 3; //

	    output[op1++] = output[op2++] = (date.getMonth() + 1 & 0x7) << 5 | date.getDate();
	    output[op1++] = output[op2++] = (date.getFullYear() - 1980 & 0x7f) << 1 | date.getMonth() + 1 >> 3; // CRC-32

	    crc32 = file.crc32;
	    output[op1++] = output[op2++] = crc32 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 8 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 16 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 24 & 0xff; // compressed size

	    size = file.buffer.length;
	    output[op1++] = output[op2++] = size & 0xff;
	    output[op1++] = output[op2++] = size >> 8 & 0xff;
	    output[op1++] = output[op2++] = size >> 16 & 0xff;
	    output[op1++] = output[op2++] = size >> 24 & 0xff; // uncompressed size

	    plainSize = file.size;
	    output[op1++] = output[op2++] = plainSize & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 8 & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 16 & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 24 & 0xff; // filename length

	    output[op1++] = output[op2++] = filenameLength & 0xff;
	    output[op1++] = output[op2++] = filenameLength >> 8 & 0xff; // extra field length

	    output[op1++] = output[op2++] = extraFieldLength & 0xff;
	    output[op1++] = output[op2++] = extraFieldLength >> 8 & 0xff; // file comment length

	    output[op2++] = commentLength & 0xff;
	    output[op2++] = commentLength >> 8 & 0xff; // disk number start

	    output[op2++] = 0;
	    output[op2++] = 0; // internal file attributes

	    output[op2++] = 0;
	    output[op2++] = 0; // external file attributes

	    output[op2++] = 0;
	    output[op2++] = 0;
	    output[op2++] = 0;
	    output[op2++] = 0; // relative offset of local header

	    output[op2++] = offset & 0xff;
	    output[op2++] = offset >> 8 & 0xff;
	    output[op2++] = offset >> 16 & 0xff;
	    output[op2++] = offset >> 24 & 0xff; // filename

	    filename = file.option['filename'];

	    if (filename) {
	      {
	        output.set(filename, op1);
	        output.set(filename, op2);
	        op1 += filenameLength;
	        op2 += filenameLength;
	      }
	    } // extra field


	    extraField = file.option['extraField'];

	    if (extraField) {
	      {
	        output.set(extraField, op1);
	        output.set(extraField, op2);
	        op1 += extraFieldLength;
	        op2 += extraFieldLength;
	      }
	    } // comment


	    comment = file.option['comment'];

	    if (comment) {
	      {
	        output.set(comment, op2);
	        op2 += commentLength;
	      }
	    } //-------------------------------------------------------------------------
	    // file data
	    //-------------------------------------------------------------------------


	    {
	      output.set(file.buffer, op1);
	      op1 += file.buffer.length;
	    }
	  } //-------------------------------------------------------------------------
	  // end of central directory
	  //-------------------------------------------------------------------------
	  // signature


	  output[op3++] = Zlib.Zip.CentralDirectorySignature[0];
	  output[op3++] = Zlib.Zip.CentralDirectorySignature[1];
	  output[op3++] = Zlib.Zip.CentralDirectorySignature[2];
	  output[op3++] = Zlib.Zip.CentralDirectorySignature[3]; // number of this disk

	  output[op3++] = 0;
	  output[op3++] = 0; // number of the disk with the start of the central directory

	  output[op3++] = 0;
	  output[op3++] = 0; // total number of entries in the central directory on this disk

	  output[op3++] = il & 0xff;
	  output[op3++] = il >> 8 & 0xff; // total number of entries in the central directory

	  output[op3++] = il & 0xff;
	  output[op3++] = il >> 8 & 0xff; // size of the central directory

	  output[op3++] = centralDirectorySize & 0xff;
	  output[op3++] = centralDirectorySize >> 8 & 0xff;
	  output[op3++] = centralDirectorySize >> 16 & 0xff;
	  output[op3++] = centralDirectorySize >> 24 & 0xff; // offset of start of central directory with respect to the starting disk number

	  output[op3++] = localFileSize & 0xff;
	  output[op3++] = localFileSize >> 8 & 0xff;
	  output[op3++] = localFileSize >> 16 & 0xff;
	  output[op3++] = localFileSize >> 24 & 0xff; // .ZIP file comment length

	  commentLength = this.comment ? this.comment.length : 0;
	  output[op3++] = commentLength & 0xff;
	  output[op3++] = commentLength >> 8 & 0xff; // .ZIP file comment

	  if (this.comment) {
	    {
	      output.set(this.comment, op3);
	      op3 += commentLength;
	    }
	  }

	  return output;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input
	 * @param {Object=} opt_params options.
	 * @return {!(Array.<number>|Uint8Array)}
	 */


	Zlib.Zip.prototype.deflateWithOption = function (input, opt_params) {
	  /** @type {Zlib.RawDeflate} */
	  var deflator = new Zlib.RawDeflate(input, opt_params['deflateOption']);
	  return deflator.compress();
	};
	/**
	 * @param {(Array.<number>|Uint32Array)} key
	 * @return {number}
	 */


	Zlib.Zip.prototype.getByte = function (key) {
	  /** @type {number} */
	  var tmp = key[2] & 0xffff | 2;
	  return tmp * (tmp ^ 1) >> 8 & 0xff;
	};
	/**
	 * @param {(Array.<number>|Uint32Array|Object)} key
	 * @param {number} n
	 * @return {number}
	 */


	Zlib.Zip.prototype.encode = function (key, n) {
	  /** @type {number} */
	  var tmp = this.getByte(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key);
	  this.updateKeys(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key, n);
	  return tmp ^ n;
	};
	/**
	 * @param {(Array.<number>|Uint32Array)} key
	 * @param {number} n
	 */


	Zlib.Zip.prototype.updateKeys = function (key, n) {
	  key[0] = Zlib.CRC32.single(key[0], n);
	  key[1] = (((key[1] + (key[0] & 0xff)) * 20173 >>> 0) * 6681 >>> 0) + 1 >>> 0;
	  key[2] = Zlib.CRC32.single(key[2], key[1] >>> 24);
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 * @return {!(Array.<number>|Uint32Array|Object)}
	 */


	Zlib.Zip.prototype.createEncryptionKey = function (password) {
	  /** @type {!(Array.<number>|Uint32Array)} */
	  var key = [305419896, 591751049, 878082192];
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  {
	    key = new Uint32Array(key);
	  }

	  for (i = 0, il = password.length; i < il; ++i) {
	    this.updateKeys(key, password[i] & 0xff);
	  }

	  return key;
	};
	/**
	 * build huffman table from length list.
	 * @param {!(Array.<number>|Uint8Array)} lengths length list.
	 * @return {!Array} huffman table.
	 */


	Zlib.Huffman.buildHuffmanTable = function (lengths) {
	  /** @type {number} length list size. */
	  var listSize = lengths.length;
	  /** @type {number} max code length for table size. */

	  var maxCodeLength = 0;
	  /** @type {number} min code length for table size. */

	  var minCodeLength = Number.POSITIVE_INFINITY;
	  /** @type {number} table size. */

	  var size;
	  /** @type {!(Array|Uint8Array)} huffman code table. */

	  var table;
	  /** @type {number} bit length. */

	  var bitLength;
	  /** @type {number} huffman code. */

	  var code;
	  /**
	   * サイズが 2^maxlength 個のテーブルを埋めるためのスキップ長.
	   * @type {number} skip length for table filling.
	   */

	  var skip;
	  /** @type {number} reversed code. */

	  var reversed;
	  /** @type {number} reverse temp. */

	  var rtemp;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limit. */

	  var il;
	  /** @type {number} loop counter. */

	  var j;
	  /** @type {number} table value. */

	  var value; // Math.max は遅いので最長の値は for-loop で取得する

	  for (i = 0, il = listSize; i < il; ++i) {
	    if (lengths[i] > maxCodeLength) {
	      maxCodeLength = lengths[i];
	    }

	    if (lengths[i] < minCodeLength) {
	      minCodeLength = lengths[i];
	    }
	  }

	  size = 1 << maxCodeLength;
	  table = new Uint32Array(size); // ビット長の短い順からハフマン符号を割り当てる

	  for (bitLength = 1, code = 0, skip = 2; bitLength <= maxCodeLength;) {
	    for (i = 0; i < listSize; ++i) {
	      if (lengths[i] === bitLength) {
	        // ビットオーダーが逆になるためビット長分並びを反転する
	        for (reversed = 0, rtemp = code, j = 0; j < bitLength; ++j) {
	          reversed = reversed << 1 | rtemp & 1;
	          rtemp >>= 1;
	        } // 最大ビット長をもとにテーブルを作るため、
	        // 最大ビット長以外では 0 / 1 どちらでも良い箇所ができる
	        // そのどちらでも良い場所は同じ値で埋めることで
	        // 本来のビット長以上のビット数取得しても問題が起こらないようにする


	        value = bitLength << 16 | i;

	        for (j = reversed; j < size; j += skip) {
	          table[j] = value;
	        }

	        ++code;
	      }
	    } // 次のビット長へ


	    ++bitLength;
	    code <<= 1;
	    skip <<= 1;
	  }

	  return [table, maxCodeLength, minCodeLength];
	}; //-----------------------------------------------------------------------------

	/** @define {number} buffer block size. */


	var ZLIB_RAW_INFLATE_BUFFER_SIZE = 0x8000; // [ 0x8000 >= ZLIB_BUFFER_BLOCK_SIZE ]
	//-----------------------------------------------------------------------------

	var buildHuffmanTable = Zlib.Huffman.buildHuffmanTable;
	/**
	 * @constructor
	 * @param {!(Uint8Array|Array.<number>)} input input buffer.
	 * @param {Object} opt_params option parameter.
	 *
	 * opt_params は以下のプロパティを指定する事ができます。
	 *   - index: input buffer の deflate コンテナの開始位置.
	 *   - blockSize: バッファのブロックサイズ.
	 *   - bufferType: Zlib.RawInflate.BufferType の値によってバッファの管理方法を指定する.
	 *   - resize: 確保したバッファが実際の大きさより大きかった場合に切り詰める.
	 */

	Zlib.RawInflate = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} inflated buffer */
	  this.buffer;
	  /** @type {!Array.<(Array.<number>|Uint8Array)>} */

	  this.blocks = [];
	  /** @type {number} block size. */

	  this.bufferSize = ZLIB_RAW_INFLATE_BUFFER_SIZE;
	  /** @type {!number} total output buffer pointer. */

	  this.totalpos = 0;
	  /** @type {!number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {!number} bit stream reader buffer. */

	  this.bitsbuf = 0;
	  /** @type {!number} bit stream reader buffer size. */

	  this.bitsbuflen = 0;
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */

	  this.input = new Uint8Array(input);
	  /** @type {!(Uint8Array|Array.<number>)} output buffer. */

	  this.output;
	  /** @type {!number} output buffer pointer. */

	  this.op;
	  /** @type {boolean} is final block flag. */

	  this.bfinal = false;
	  /** @type {Zlib.RawInflate.BufferType} buffer management. */

	  this.bufferType = Zlib.RawInflate.BufferType.ADAPTIVE;
	  /** @type {boolean} resize flag for memory size optimization. */

	  this.resize = false; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (opt_params['index']) {
	      this.ip = opt_params['index'];
	    }

	    if (opt_params['bufferSize']) {
	      this.bufferSize = opt_params['bufferSize'];
	    }

	    if (opt_params['bufferType']) {
	      this.bufferType = opt_params['bufferType'];
	    }

	    if (opt_params['resize']) {
	      this.resize = opt_params['resize'];
	    }
	  } // initialize


	  switch (this.bufferType) {
	    case Zlib.RawInflate.BufferType.BLOCK:
	      this.op = Zlib.RawInflate.MaxBackwardLength;
	      this.output = new Uint8Array(Zlib.RawInflate.MaxBackwardLength + this.bufferSize + Zlib.RawInflate.MaxCopyLength);
	      break;

	    case Zlib.RawInflate.BufferType.ADAPTIVE:
	      this.op = 0;
	      this.output = new Uint8Array(this.bufferSize);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * @enum {number}
	 */


	Zlib.RawInflate.BufferType = {
	  BLOCK: 0,
	  ADAPTIVE: 1
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array.<number>)} inflated buffer.
	 */

	Zlib.RawInflate.prototype.decompress = function () {
	  while (!this.bfinal) {
	    this.parseBlock();
	  }

	  switch (this.bufferType) {
	    case Zlib.RawInflate.BufferType.BLOCK:
	      return this.concatBufferBlock();

	    case Zlib.RawInflate.BufferType.ADAPTIVE:
	      return this.concatBufferDynamic();

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * @const
	 * @type {number} max backward length for LZ77.
	 */


	Zlib.RawInflate.MaxBackwardLength = 32768;
	/**
	 * @const
	 * @type {number} max copy length for LZ77.
	 */

	Zlib.RawInflate.MaxCopyLength = 258;
	/**
	 * huffman order
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */

	Zlib.RawInflate.Order = function (table) {
	  return new Uint16Array(table);
	}([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
	/**
	 * huffman length code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib.RawInflate.LengthCodeTable = function (table) {
	  return new Uint16Array(table);
	}([0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000d, 0x000f, 0x0011, 0x0013, 0x0017, 0x001b, 0x001f, 0x0023, 0x002b, 0x0033, 0x003b, 0x0043, 0x0053, 0x0063, 0x0073, 0x0083, 0x00a3, 0x00c3, 0x00e3, 0x0102, 0x0102, 0x0102]);
	/**
	 * huffman length extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib.RawInflate.LengthExtraTable = function (table) {
	  return new Uint8Array(table);
	}([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0]);
	/**
	 * huffman dist code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib.RawInflate.DistCodeTable = function (table) {
	  return new Uint16Array(table);
	}([0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000d, 0x0011, 0x0019, 0x0021, 0x0031, 0x0041, 0x0061, 0x0081, 0x00c1, 0x0101, 0x0181, 0x0201, 0x0301, 0x0401, 0x0601, 0x0801, 0x0c01, 0x1001, 0x1801, 0x2001, 0x3001, 0x4001, 0x6001]);
	/**
	 * huffman dist extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib.RawInflate.DistExtraTable = function (table) {
	  return new Uint8Array(table);
	}([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13]);
	/**
	 * fixed huffman length code table
	 * @const
	 * @type {!Array}
	 */


	Zlib.RawInflate.FixedLiteralLengthTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new Uint8Array(288);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = i <= 143 ? 8 : i <= 255 ? 9 : i <= 279 ? 7 : 8;
	  }

	  return buildHuffmanTable(lengths);
	}());
	/**
	 * fixed huffman distance code table
	 * @const
	 * @type {!Array}
	 */


	Zlib.RawInflate.FixedDistanceTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new Uint8Array(30);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = 5;
	  }

	  return buildHuffmanTable(lengths);
	}());
	/**
	 * parse deflated block.
	 */


	Zlib.RawInflate.prototype.parseBlock = function () {
	  /** @type {number} header */
	  var hdr = this.readBits(3); // BFINAL

	  if (hdr & 0x1) {
	    this.bfinal = true;
	  } // BTYPE


	  hdr >>>= 1;

	  switch (hdr) {
	    // uncompressed
	    case 0:
	      this.parseUncompressedBlock();
	      break;
	    // fixed huffman

	    case 1:
	      this.parseFixedHuffmanBlock();
	      break;
	    // dynamic huffman

	    case 2:
	      this.parseDynamicHuffmanBlock();
	      break;
	    // reserved or other

	    default:
	      throw new Error('unknown BTYPE: ' + hdr);
	  }
	};
	/**
	 * read inflate bits
	 * @param {number} length bits length.
	 * @return {number} read bits.
	 */


	Zlib.RawInflate.prototype.readBits = function (length) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {number} input and output byte. */

	  var octet; // input byte

	  if (ip + (length - bitsbuflen + 7 >> 3) >= inputLength) {
	    throw new Error('input buffer is broken');
	  } // not enough buffer


	  while (bitsbuflen < length) {
	    bitsbuf |= input[ip++] << bitsbuflen;
	    bitsbuflen += 8;
	  } // output byte


	  octet = bitsbuf &
	  /* MASK */
	  (1 << length) - 1;
	  bitsbuf >>>= length;
	  bitsbuflen -= length;
	  this.bitsbuf = bitsbuf;
	  this.bitsbuflen = bitsbuflen;
	  this.ip = ip;
	  return octet;
	};
	/**
	 * read huffman code using table
	 * @param {!(Array.<number>|Uint8Array|Uint16Array)} table huffman code table.
	 * @return {number} huffman code.
	 */


	Zlib.RawInflate.prototype.readCodeByTable = function (table) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {!(Array.<number>|Uint8Array)} huffman code table */

	  var codeTable = table[0];
	  /** @type {number} */

	  var maxCodeLength = table[1];
	  /** @type {number} code length & code (16bit, 16bit) */

	  var codeWithLength;
	  /** @type {number} code bits length */

	  var codeLength; // not enough buffer

	  while (bitsbuflen < maxCodeLength) {
	    if (ip >= inputLength) {
	      break;
	    }

	    bitsbuf |= input[ip++] << bitsbuflen;
	    bitsbuflen += 8;
	  } // read max length


	  codeWithLength = codeTable[bitsbuf & (1 << maxCodeLength) - 1];
	  codeLength = codeWithLength >>> 16;

	  if (codeLength > bitsbuflen) {
	    throw new Error('invalid code length: ' + codeLength);
	  }

	  this.bitsbuf = bitsbuf >> codeLength;
	  this.bitsbuflen = bitsbuflen - codeLength;
	  this.ip = ip;
	  return codeWithLength & 0xffff;
	};
	/**
	 * parse uncompressed block.
	 */


	Zlib.RawInflate.prototype.parseUncompressedBlock = function () {
	  var input = this.input;
	  var ip = this.ip;
	  var output = this.output;
	  var op = this.op;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {number} block length */

	  var len;
	  /** @type {number} number for check block length */

	  var nlen;
	  /** @type {number} output buffer length */

	  var olength = output.length;
	  /** @type {number} copy counter */

	  var preCopy; // skip buffered header bits

	  this.bitsbuf = 0;
	  this.bitsbuflen = 0; // len

	  if (ip + 1 >= inputLength) {
	    throw new Error('invalid uncompressed block header: LEN');
	  }

	  len = input[ip++] | input[ip++] << 8; // nlen

	  if (ip + 1 >= inputLength) {
	    throw new Error('invalid uncompressed block header: NLEN');
	  }

	  nlen = input[ip++] | input[ip++] << 8; // check len & nlen

	  if (len === ~nlen) {
	    throw new Error('invalid uncompressed block header: length verify');
	  } // check size


	  if (ip + len > input.length) {
	    throw new Error('input buffer is broken');
	  } // expand buffer


	  switch (this.bufferType) {
	    case Zlib.RawInflate.BufferType.BLOCK:
	      // pre copy
	      while (op + len > output.length) {
	        preCopy = olength - op;
	        len -= preCopy;
	        {
	          output.set(input.subarray(ip, ip + preCopy), op);
	          op += preCopy;
	          ip += preCopy;
	        }
	        this.op = op;
	        output = this.expandBufferBlock();
	        op = this.op;
	      }

	      break;

	    case Zlib.RawInflate.BufferType.ADAPTIVE:
	      while (op + len > output.length) {
	        output = this.expandBufferAdaptive({
	          fixRatio: 2
	        });
	      }

	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  } // copy


	  {
	    output.set(input.subarray(ip, ip + len), op);
	    op += len;
	    ip += len;
	  }
	  this.ip = ip;
	  this.op = op;
	  this.output = output;
	};
	/**
	 * parse fixed huffman block.
	 */


	Zlib.RawInflate.prototype.parseFixedHuffmanBlock = function () {
	  switch (this.bufferType) {
	    case Zlib.RawInflate.BufferType.ADAPTIVE:
	      this.decodeHuffmanAdaptive(Zlib.RawInflate.FixedLiteralLengthTable, Zlib.RawInflate.FixedDistanceTable);
	      break;

	    case Zlib.RawInflate.BufferType.BLOCK:
	      this.decodeHuffmanBlock(Zlib.RawInflate.FixedLiteralLengthTable, Zlib.RawInflate.FixedDistanceTable);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * parse dynamic huffman block.
	 */


	Zlib.RawInflate.prototype.parseDynamicHuffmanBlock = function () {
	  /** @type {number} number of literal and length codes. */
	  var hlit = this.readBits(5) + 257;
	  /** @type {number} number of distance codes. */

	  var hdist = this.readBits(5) + 1;
	  /** @type {number} number of code lengths. */

	  var hclen = this.readBits(4) + 4;
	  /** @type {!(Uint8Array|Array.<number>)} code lengths. */

	  var codeLengths = new Uint8Array(Zlib.RawInflate.Order.length);
	  /** @type {!Array} code lengths table. */

	  var codeLengthsTable;
	  /** @type {!(Uint8Array|Array.<number>)} literal and length code table. */

	  var litlenTable;
	  /** @type {!(Uint8Array|Array.<number>)} distance code table. */

	  var distTable;
	  /** @type {!(Uint8Array|Array.<number>)} code length table. */

	  var lengthTable;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var prev;
	  /** @type {number} */

	  var repeat;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limit. */

	  var il; // decode code lengths

	  for (i = 0; i < hclen; ++i) {
	    codeLengths[Zlib.RawInflate.Order[i]] = this.readBits(3);
	  } // decode length table


	  codeLengthsTable = buildHuffmanTable(codeLengths);
	  lengthTable = new Uint8Array(hlit + hdist);

	  for (i = 0, il = hlit + hdist; i < il;) {
	    code = this.readCodeByTable(codeLengthsTable);

	    switch (code) {
	      case 16:
	        repeat = 3 + this.readBits(2);

	        while (repeat--) {
	          lengthTable[i++] = prev;
	        }

	        break;

	      case 17:
	        repeat = 3 + this.readBits(3);

	        while (repeat--) {
	          lengthTable[i++] = 0;
	        }

	        prev = 0;
	        break;

	      case 18:
	        repeat = 11 + this.readBits(7);

	        while (repeat--) {
	          lengthTable[i++] = 0;
	        }

	        prev = 0;
	        break;

	      default:
	        lengthTable[i++] = code;
	        prev = code;
	        break;
	    }
	  }

	  litlenTable = buildHuffmanTable(lengthTable.subarray(0, hlit));
	  distTable = buildHuffmanTable(lengthTable.subarray(hlit));

	  switch (this.bufferType) {
	    case Zlib.RawInflate.BufferType.ADAPTIVE:
	      this.decodeHuffmanAdaptive(litlenTable, distTable);
	      break;

	    case Zlib.RawInflate.BufferType.BLOCK:
	      this.decodeHuffmanBlock(litlenTable, distTable);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * decode huffman code
	 * @param {!(Array.<number>|Uint16Array)} litlen literal and length code table.
	 * @param {!(Array.<number>|Uint8Array)} dist distination code table.
	 */


	Zlib.RawInflate.prototype.decodeHuffmanBlock = function (litlen, dist) {
	  var output = this.output;
	  var op = this.op;
	  this.currentLitlenTable = litlen;
	  /** @type {number} output position limit. */

	  var olength = output.length - Zlib.RawInflate.MaxCopyLength;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var lengthCodeTable = Zlib.RawInflate.LengthCodeTable;
	  var lengthExtraTable = Zlib.RawInflate.LengthExtraTable;
	  var distCodeTable = Zlib.RawInflate.DistCodeTable;
	  var distExtraTable = Zlib.RawInflate.DistExtraTable;

	  while ((code = this.readCodeByTable(litlen)) !== 256) {
	    // literal
	    if (code < 256) {
	      if (op >= olength) {
	        this.op = op;
	        output = this.expandBufferBlock();
	        op = this.op;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = lengthCodeTable[ti];

	    if (lengthExtraTable[ti] > 0) {
	      codeLength += this.readBits(lengthExtraTable[ti]);
	    } // dist code


	    code = this.readCodeByTable(dist);
	    codeDist = distCodeTable[code];

	    if (distExtraTable[code] > 0) {
	      codeDist += this.readBits(distExtraTable[code]);
	    } // lz77 decode


	    if (op >= olength) {
	      this.op = op;
	      output = this.expandBufferBlock();
	      op = this.op;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	};
	/**
	 * decode huffman code (adaptive)
	 * @param {!(Array.<number>|Uint16Array)} litlen literal and length code table.
	 * @param {!(Array.<number>|Uint8Array)} dist distination code table.
	 */


	Zlib.RawInflate.prototype.decodeHuffmanAdaptive = function (litlen, dist) {
	  var output = this.output;
	  var op = this.op;
	  this.currentLitlenTable = litlen;
	  /** @type {number} output position limit. */

	  var olength = output.length;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var lengthCodeTable = Zlib.RawInflate.LengthCodeTable;
	  var lengthExtraTable = Zlib.RawInflate.LengthExtraTable;
	  var distCodeTable = Zlib.RawInflate.DistCodeTable;
	  var distExtraTable = Zlib.RawInflate.DistExtraTable;

	  while ((code = this.readCodeByTable(litlen)) !== 256) {
	    // literal
	    if (code < 256) {
	      if (op >= olength) {
	        output = this.expandBufferAdaptive();
	        olength = output.length;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = lengthCodeTable[ti];

	    if (lengthExtraTable[ti] > 0) {
	      codeLength += this.readBits(lengthExtraTable[ti]);
	    } // dist code


	    code = this.readCodeByTable(dist);
	    codeDist = distCodeTable[code];

	    if (distExtraTable[code] > 0) {
	      codeDist += this.readBits(distExtraTable[code]);
	    } // lz77 decode


	    if (op + codeLength > olength) {
	      output = this.expandBufferAdaptive();
	      olength = output.length;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	};
	/**
	 * expand output buffer.
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib.RawInflate.prototype.expandBufferBlock = function (opt_param) {
	  /** @type {!(Array.<number>|Uint8Array)} store buffer. */
	  var buffer = new Uint8Array(this.op - Zlib.RawInflate.MaxBackwardLength);
	  /** @type {number} backward base point */

	  var backward = this.op - Zlib.RawInflate.MaxBackwardLength;
	  var output = this.output; // copy to output buffer

	  {
	    buffer.set(output.subarray(Zlib.RawInflate.MaxBackwardLength, buffer.length));
	  }
	  this.blocks.push(buffer);
	  this.totalpos += buffer.length; // copy to backward buffer

	  {
	    output.set(output.subarray(backward, backward + Zlib.RawInflate.MaxBackwardLength));
	  }
	  this.op = Zlib.RawInflate.MaxBackwardLength;
	  return output;
	};
	/**
	 * expand output buffer. (adaptive)
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array.<number>|Uint8Array)} output buffer pointer.
	 */


	Zlib.RawInflate.prototype.expandBufferAdaptive = function (opt_param) {
	  /** @type {!(Array.<number>|Uint8Array)} store buffer. */
	  var buffer;
	  /** @type {number} expantion ratio. */

	  var ratio = this.input.length / this.ip + 1 | 0;
	  /** @type {number} maximum number of huffman code. */

	  var maxHuffCode;
	  /** @type {number} new output buffer size. */

	  var newSize;
	  /** @type {number} max inflate size. */

	  var maxInflateSize;
	  var input = this.input;
	  var output = this.output;

	  if (opt_param) {
	    if (typeof opt_param.fixRatio === 'number') {
	      ratio = opt_param.fixRatio;
	    }

	    if (typeof opt_param.addRatio === 'number') {
	      ratio += opt_param.addRatio;
	    }
	  } // calculate new buffer size


	  if (ratio < 2) {
	    maxHuffCode = (input.length - this.ip) / this.currentLitlenTable[2];
	    maxInflateSize = maxHuffCode / 2 * 258 | 0;
	    newSize = maxInflateSize < output.length ? output.length + maxInflateSize : output.length << 1;
	  } else {
	    newSize = output.length * ratio;
	  } // buffer expantion


	  {
	    buffer = new Uint8Array(newSize);
	    buffer.set(output);
	  }
	  this.output = buffer;
	  return this.output;
	};
	/**
	 * concat output buffer.
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib.RawInflate.prototype.concatBufferBlock = function () {
	  /** @type {number} buffer pointer. */
	  var pos = 0;
	  /** @type {number} buffer pointer. */

	  var limit = this.totalpos + (this.op - Zlib.RawInflate.MaxBackwardLength);
	  /** @type {!(Array.<number>|Uint8Array)} output block array. */

	  var output = this.output;
	  /** @type {!Array} blocks array. */

	  var blocks = this.blocks;
	  /** @type {!(Array.<number>|Uint8Array)} output block array. */

	  var block;
	  /** @type {!(Array.<number>|Uint8Array)} output buffer. */

	  var buffer = new Uint8Array(limit);
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limiter. */

	  var il;
	  /** @type {number} loop counter. */

	  var j;
	  /** @type {number} loop limiter. */

	  var jl; // single buffer

	  if (blocks.length === 0) {
	    return this.output.subarray(Zlib.RawInflate.MaxBackwardLength, this.op);
	  } // copy to buffer


	  for (i = 0, il = blocks.length; i < il; ++i) {
	    block = blocks[i];

	    for (j = 0, jl = block.length; j < jl; ++j) {
	      buffer[pos++] = block[j];
	    }
	  } // current buffer


	  for (i = Zlib.RawInflate.MaxBackwardLength, il = this.op; i < il; ++i) {
	    buffer[pos++] = output[i];
	  }

	  this.blocks = [];
	  this.buffer = buffer;
	  return this.buffer;
	};
	/**
	 * concat output buffer. (dynamic)
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib.RawInflate.prototype.concatBufferDynamic = function () {
	  /** @type {Array.<number>|Uint8Array} output buffer. */
	  var buffer;
	  var op = this.op;
	  {
	    if (this.resize) {
	      buffer = new Uint8Array(op);
	      buffer.set(this.output.subarray(0, op));
	    } else {
	      buffer = this.output.subarray(0, op);
	    }
	  }
	  this.buffer = buffer;
	  return this.buffer;
	};

	var buildHuffmanTable = Zlib.Huffman.buildHuffmanTable;
	/**
	 * @param {!(Uint8Array|Array.<number>)} input input buffer.
	 * @param {number} ip input buffer pointer.
	 * @param {number=} opt_buffersize buffer block size.
	 * @constructor
	 */

	Zlib.RawInflateStream = function (input, ip, opt_buffersize) {
	  /** @type {!Array.<(Array|Uint8Array)>} */
	  this.blocks = [];
	  /** @type {number} block size. */

	  this.bufferSize = opt_buffersize ? opt_buffersize : ZLIB_STREAM_RAW_INFLATE_BUFFER_SIZE;
	  /** @type {!number} total output buffer pointer. */

	  this.totalpos = 0;
	  /** @type {!number} input buffer pointer. */

	  this.ip = ip === void 0 ? 0 : ip;
	  /** @type {!number} bit stream reader buffer. */

	  this.bitsbuf = 0;
	  /** @type {!number} bit stream reader buffer size. */

	  this.bitsbuflen = 0;
	  /** @type {!(Array|Uint8Array)} input buffer. */

	  this.input = new Uint8Array(input);
	  /** @type {!(Uint8Array|Array)} output buffer. */

	  this.output = new Uint8Array(this.bufferSize);
	  /** @type {!number} output buffer pointer. */

	  this.op = 0;
	  /** @type {boolean} is final block flag. */

	  this.bfinal = false;
	  /** @type {number} uncompressed block length. */

	  this.blockLength;
	  /** @type {boolean} resize flag for memory size optimization. */

	  this.resize = false;
	  /** @type {Array} */

	  this.litlenTable;
	  /** @type {Array} */

	  this.distTable;
	  /** @type {number} */

	  this.sp = 0; // stream pointer

	  /** @type {Zlib.RawInflateStream.Status} */

	  this.status = Zlib.RawInflateStream.Status.INITIALIZED; //
	  // backup
	  //

	  /** @type {!number} */

	  this.ip_;
	  /** @type {!number} */

	  this.bitsbuflen_;
	  /** @type {!number} */

	  this.bitsbuf_;
	};
	/**
	 * @enum {number}
	 */


	Zlib.RawInflateStream.BlockType = {
	  UNCOMPRESSED: 0,
	  FIXED: 1,
	  DYNAMIC: 2
	};
	/**
	 * @enum {number}
	 */

	Zlib.RawInflateStream.Status = {
	  INITIALIZED: 0,
	  BLOCK_HEADER_START: 1,
	  BLOCK_HEADER_END: 2,
	  BLOCK_BODY_START: 3,
	  BLOCK_BODY_END: 4,
	  DECODE_BLOCK_START: 5,
	  DECODE_BLOCK_END: 6
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */

	Zlib.RawInflateStream.prototype.decompress = function (newInput, ip) {
	  /** @type {boolean} */
	  var stop = false;

	  if (newInput !== void 0) {
	    this.input = newInput;
	  }

	  if (ip !== void 0) {
	    this.ip = ip;
	  } // decompress


	  while (!stop) {
	    switch (this.status) {
	      // block header
	      case Zlib.RawInflateStream.Status.INITIALIZED:
	      case Zlib.RawInflateStream.Status.BLOCK_HEADER_START:
	        if (this.readBlockHeader() < 0) {
	          stop = true;
	        }

	        break;
	      // block body

	      case Zlib.RawInflateStream.Status.BLOCK_HEADER_END:
	      /* FALLTHROUGH */

	      case Zlib.RawInflateStream.Status.BLOCK_BODY_START:
	        switch (this.currentBlockType) {
	          case Zlib.RawInflateStream.BlockType.UNCOMPRESSED:
	            if (this.readUncompressedBlockHeader() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib.RawInflateStream.BlockType.FIXED:
	            if (this.parseFixedHuffmanBlock() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib.RawInflateStream.BlockType.DYNAMIC:
	            if (this.parseDynamicHuffmanBlock() < 0) {
	              stop = true;
	            }

	            break;
	        }

	        break;
	      // decode data

	      case Zlib.RawInflateStream.Status.BLOCK_BODY_END:
	      case Zlib.RawInflateStream.Status.DECODE_BLOCK_START:
	        switch (this.currentBlockType) {
	          case Zlib.RawInflateStream.BlockType.UNCOMPRESSED:
	            if (this.parseUncompressedBlock() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib.RawInflateStream.BlockType.FIXED:
	          /* FALLTHROUGH */

	          case Zlib.RawInflateStream.BlockType.DYNAMIC:
	            if (this.decodeHuffman() < 0) {
	              stop = true;
	            }

	            break;
	        }

	        break;

	      case Zlib.RawInflateStream.Status.DECODE_BLOCK_END:
	        if (this.bfinal) {
	          stop = true;
	        } else {
	          this.status = Zlib.RawInflateStream.Status.INITIALIZED;
	        }

	        break;
	    }
	  }

	  return this.concatBuffer();
	};
	/**
	 * @const
	 * @type {number} max backward length for LZ77.
	 */


	Zlib.RawInflateStream.MaxBackwardLength = 32768;
	/**
	 * @const
	 * @type {number} max copy length for LZ77.
	 */

	Zlib.RawInflateStream.MaxCopyLength = 258;
	/**
	 * huffman order
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */

	Zlib.RawInflateStream.Order = function (table) {
	  return new Uint16Array(table);
	}([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
	/**
	 * huffman length code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib.RawInflateStream.LengthCodeTable = function (table) {
	  return new Uint16Array(table);
	}([0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000d, 0x000f, 0x0011, 0x0013, 0x0017, 0x001b, 0x001f, 0x0023, 0x002b, 0x0033, 0x003b, 0x0043, 0x0053, 0x0063, 0x0073, 0x0083, 0x00a3, 0x00c3, 0x00e3, 0x0102, 0x0102, 0x0102]);
	/**
	 * huffman length extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib.RawInflateStream.LengthExtraTable = function (table) {
	  return new Uint8Array(table);
	}([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0]);
	/**
	 * huffman dist code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib.RawInflateStream.DistCodeTable = function (table) {
	  return new Uint16Array(table);
	}([0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000d, 0x0011, 0x0019, 0x0021, 0x0031, 0x0041, 0x0061, 0x0081, 0x00c1, 0x0101, 0x0181, 0x0201, 0x0301, 0x0401, 0x0601, 0x0801, 0x0c01, 0x1001, 0x1801, 0x2001, 0x3001, 0x4001, 0x6001]);
	/**
	 * huffman dist extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib.RawInflateStream.DistExtraTable = function (table) {
	  return new Uint8Array(table);
	}([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13]);
	/**
	 * fixed huffman length code table
	 * @const
	 * @type {!Array}
	 */


	Zlib.RawInflateStream.FixedLiteralLengthTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new Uint8Array(288);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = i <= 143 ? 8 : i <= 255 ? 9 : i <= 279 ? 7 : 8;
	  }

	  return buildHuffmanTable(lengths);
	}());
	/**
	 * fixed huffman distance code table
	 * @const
	 * @type {!Array}
	 */


	Zlib.RawInflateStream.FixedDistanceTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new Uint8Array(30);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = 5;
	  }

	  return buildHuffmanTable(lengths);
	}());
	/**
	 * parse deflated block.
	 */


	Zlib.RawInflateStream.prototype.readBlockHeader = function () {
	  /** @type {number} header */
	  var hdr;
	  this.status = Zlib.RawInflateStream.Status.BLOCK_HEADER_START;
	  this.save_();

	  if ((hdr = this.readBits(3)) < 0) {
	    this.restore_();
	    return -1;
	  } // BFINAL


	  if (hdr & 0x1) {
	    this.bfinal = true;
	  } // BTYPE


	  hdr >>>= 1;

	  switch (hdr) {
	    case 0:
	      // uncompressed
	      this.currentBlockType = Zlib.RawInflateStream.BlockType.UNCOMPRESSED;
	      break;

	    case 1:
	      // fixed huffman
	      this.currentBlockType = Zlib.RawInflateStream.BlockType.FIXED;
	      break;

	    case 2:
	      // dynamic huffman
	      this.currentBlockType = Zlib.RawInflateStream.BlockType.DYNAMIC;
	      break;

	    default:
	      // reserved or other
	      throw new Error('unknown BTYPE: ' + hdr);
	  }

	  this.status = Zlib.RawInflateStream.Status.BLOCK_HEADER_END;
	};
	/**
	 * read inflate bits
	 * @param {number} length bits length.
	 * @return {number} read bits.
	 */


	Zlib.RawInflateStream.prototype.readBits = function (length) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} input and output byte. */

	  var octet; // not enough buffer

	  while (bitsbuflen < length) {
	    // input byte
	    if (input.length <= ip) {
	      return -1;
	    }

	    octet = input[ip++]; // concat octet

	    bitsbuf |= octet << bitsbuflen;
	    bitsbuflen += 8;
	  } // output byte


	  octet = bitsbuf &
	  /* MASK */
	  (1 << length) - 1;
	  bitsbuf >>>= length;
	  bitsbuflen -= length;
	  this.bitsbuf = bitsbuf;
	  this.bitsbuflen = bitsbuflen;
	  this.ip = ip;
	  return octet;
	};
	/**
	 * read huffman code using table
	 * @param {Array} table huffman code table.
	 * @return {number} huffman code.
	 */


	Zlib.RawInflateStream.prototype.readCodeByTable = function (table) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {!(Array|Uint8Array)} huffman code table */

	  var codeTable = table[0];
	  /** @type {number} */

	  var maxCodeLength = table[1];
	  /** @type {number} input byte */

	  var octet;
	  /** @type {number} code length & code (16bit, 16bit) */

	  var codeWithLength;
	  /** @type {number} code bits length */

	  var codeLength; // not enough buffer

	  while (bitsbuflen < maxCodeLength) {
	    if (input.length <= ip) {
	      return -1;
	    }

	    octet = input[ip++];
	    bitsbuf |= octet << bitsbuflen;
	    bitsbuflen += 8;
	  } // read max length


	  codeWithLength = codeTable[bitsbuf & (1 << maxCodeLength) - 1];
	  codeLength = codeWithLength >>> 16;

	  if (codeLength > bitsbuflen) {
	    throw new Error('invalid code length: ' + codeLength);
	  }

	  this.bitsbuf = bitsbuf >> codeLength;
	  this.bitsbuflen = bitsbuflen - codeLength;
	  this.ip = ip;
	  return codeWithLength & 0xffff;
	};
	/**
	 * read uncompressed block header
	 */


	Zlib.RawInflateStream.prototype.readUncompressedBlockHeader = function () {
	  /** @type {number} block length */
	  var len;
	  /** @type {number} number for check block length */

	  var nlen;
	  var input = this.input;
	  var ip = this.ip;
	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_START;

	  if (ip + 4 >= input.length) {
	    return -1;
	  }

	  len = input[ip++] | input[ip++] << 8;
	  nlen = input[ip++] | input[ip++] << 8; // check len & nlen

	  if (len === ~nlen) {
	    throw new Error('invalid uncompressed block header: length verify');
	  } // skip buffered header bits


	  this.bitsbuf = 0;
	  this.bitsbuflen = 0;
	  this.ip = ip;
	  this.blockLength = len;
	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_END;
	};
	/**
	 * parse uncompressed block.
	 */


	Zlib.RawInflateStream.prototype.parseUncompressedBlock = function () {
	  var input = this.input;
	  var ip = this.ip;
	  var output = this.output;
	  var op = this.op;
	  var len = this.blockLength;
	  this.status = Zlib.RawInflateStream.Status.DECODE_BLOCK_START; // copy
	  // XXX: とりあえず素直にコピー

	  while (len--) {
	    if (op === output.length) {
	      output = this.expandBuffer({
	        fixRatio: 2
	      });
	    } // not enough input buffer


	    if (ip >= input.length) {
	      this.ip = ip;
	      this.op = op;
	      this.blockLength = len + 1; // コピーしてないので戻す

	      return -1;
	    }

	    output[op++] = input[ip++];
	  }

	  if (len < 0) {
	    this.status = Zlib.RawInflateStream.Status.DECODE_BLOCK_END;
	  }

	  this.ip = ip;
	  this.op = op;
	  return 0;
	};
	/**
	 * parse fixed huffman block.
	 */


	Zlib.RawInflateStream.prototype.parseFixedHuffmanBlock = function () {
	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_START;
	  this.litlenTable = Zlib.RawInflateStream.FixedLiteralLengthTable;
	  this.distTable = Zlib.RawInflateStream.FixedDistanceTable;
	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_END;
	  return 0;
	};
	/**
	 * オブジェクトのコンテキストを別のプロパティに退避する.
	 * @private
	 */


	Zlib.RawInflateStream.prototype.save_ = function () {
	  this.ip_ = this.ip;
	  this.bitsbuflen_ = this.bitsbuflen;
	  this.bitsbuf_ = this.bitsbuf;
	};
	/**
	 * 別のプロパティに退避したコンテキストを復元する.
	 * @private
	 */


	Zlib.RawInflateStream.prototype.restore_ = function () {
	  this.ip = this.ip_;
	  this.bitsbuflen = this.bitsbuflen_;
	  this.bitsbuf = this.bitsbuf_;
	};
	/**
	 * parse dynamic huffman block.
	 */


	Zlib.RawInflateStream.prototype.parseDynamicHuffmanBlock = function () {
	  /** @type {number} number of literal and length codes. */
	  var hlit;
	  /** @type {number} number of distance codes. */

	  var hdist;
	  /** @type {number} number of code lengths. */

	  var hclen;
	  /** @type {!(Uint8Array|Array)} code lengths. */

	  var codeLengths = new Uint8Array(Zlib.RawInflateStream.Order.length);
	  /** @type {!Array} code lengths table. */

	  var codeLengthsTable;
	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_START;
	  this.save_();
	  hlit = this.readBits(5) + 257;
	  hdist = this.readBits(5) + 1;
	  hclen = this.readBits(4) + 4;

	  if (hlit < 0 || hdist < 0 || hclen < 0) {
	    this.restore_();
	    return -1;
	  }

	  try {
	    parseDynamicHuffmanBlockImpl.call(this);
	  } catch (e) {
	    this.restore_();
	    return -1;
	  }

	  function parseDynamicHuffmanBlockImpl() {
	    /** @type {number} */
	    var bits;
	    var code;
	    var prev = 0;
	    var repeat;
	    /** @type {!(Uint8Array|Array.<number>)} code length table. */

	    var lengthTable;
	    /** @type {number} loop counter. */

	    var i;
	    /** @type {number} loop limit. */

	    var il; // decode code lengths

	    for (i = 0; i < hclen; ++i) {
	      if ((bits = this.readBits(3)) < 0) {
	        throw new Error('not enough input');
	      }

	      codeLengths[Zlib.RawInflateStream.Order[i]] = bits;
	    } // decode length table


	    codeLengthsTable = buildHuffmanTable(codeLengths);
	    lengthTable = new Uint8Array(hlit + hdist);

	    for (i = 0, il = hlit + hdist; i < il;) {
	      code = this.readCodeByTable(codeLengthsTable);

	      if (code < 0) {
	        throw new Error('not enough input');
	      }

	      switch (code) {
	        case 16:
	          if ((bits = this.readBits(2)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 3 + bits;

	          while (repeat--) {
	            lengthTable[i++] = prev;
	          }

	          break;

	        case 17:
	          if ((bits = this.readBits(3)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 3 + bits;

	          while (repeat--) {
	            lengthTable[i++] = 0;
	          }

	          prev = 0;
	          break;

	        case 18:
	          if ((bits = this.readBits(7)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 11 + bits;

	          while (repeat--) {
	            lengthTable[i++] = 0;
	          }

	          prev = 0;
	          break;

	        default:
	          lengthTable[i++] = code;
	          prev = code;
	          break;
	      }
	    }

	    this.litlenTable = buildHuffmanTable(lengthTable.subarray(0, hlit));
	    this.distTable = buildHuffmanTable(lengthTable.subarray(hlit));
	  }

	  this.status = Zlib.RawInflateStream.Status.BLOCK_BODY_END;
	  return 0;
	};
	/**
	 * decode huffman code (dynamic)
	 * @return {(number|undefined)} -1 is error.
	 */


	Zlib.RawInflateStream.prototype.decodeHuffman = function () {
	  var output = this.output;
	  var op = this.op;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var litlen = this.litlenTable;
	  var dist = this.distTable;
	  var olength = output.length;
	  var bits;
	  this.status = Zlib.RawInflateStream.Status.DECODE_BLOCK_START;

	  while (true) {
	    this.save_();
	    code = this.readCodeByTable(litlen);

	    if (code < 0) {
	      this.op = op;
	      this.restore_();
	      return -1;
	    }

	    if (code === 256) {
	      break;
	    } // literal


	    if (code < 256) {
	      if (op === olength) {
	        output = this.expandBuffer();
	        olength = output.length;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = Zlib.RawInflateStream.LengthCodeTable[ti];

	    if (Zlib.RawInflateStream.LengthExtraTable[ti] > 0) {
	      bits = this.readBits(Zlib.RawInflateStream.LengthExtraTable[ti]);

	      if (bits < 0) {
	        this.op = op;
	        this.restore_();
	        return -1;
	      }

	      codeLength += bits;
	    } // dist code


	    code = this.readCodeByTable(dist);

	    if (code < 0) {
	      this.op = op;
	      this.restore_();
	      return -1;
	    }

	    codeDist = Zlib.RawInflateStream.DistCodeTable[code];

	    if (Zlib.RawInflateStream.DistExtraTable[code] > 0) {
	      bits = this.readBits(Zlib.RawInflateStream.DistExtraTable[code]);

	      if (bits < 0) {
	        this.op = op;
	        this.restore_();
	        return -1;
	      }

	      codeDist += bits;
	    } // lz77 decode


	    if (op + codeLength >= olength) {
	      output = this.expandBuffer();
	      olength = output.length;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    } // break


	    if (this.ip === this.input.length) {
	      this.op = op;
	      return -1;
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	  this.status = Zlib.RawInflateStream.Status.DECODE_BLOCK_END;
	};
	/**
	 * expand output buffer. (dynamic)
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array|Uint8Array)} output buffer pointer.
	 */


	Zlib.RawInflateStream.prototype.expandBuffer = function (opt_param) {
	  /** @type {!(Array|Uint8Array)} store buffer. */
	  var buffer;
	  /** @type {number} expantion ratio. */

	  var ratio = this.input.length / this.ip + 1 | 0;
	  /** @type {number} maximum number of huffman code. */

	  var maxHuffCode;
	  /** @type {number} new output buffer size. */

	  var newSize;
	  /** @type {number} max inflate size. */

	  var maxInflateSize;
	  var input = this.input;
	  var output = this.output;

	  if (opt_param) {
	    if (typeof opt_param.fixRatio === 'number') {
	      ratio = opt_param.fixRatio;
	    }

	    if (typeof opt_param.addRatio === 'number') {
	      ratio += opt_param.addRatio;
	    }
	  } // calculate new buffer size


	  if (ratio < 2) {
	    maxHuffCode = (input.length - this.ip) / this.litlenTable[2];
	    maxInflateSize = maxHuffCode / 2 * 258 | 0;
	    newSize = maxInflateSize < output.length ? output.length + maxInflateSize : output.length << 1;
	  } else {
	    newSize = output.length * ratio;
	  } // buffer expantion


	  {
	    buffer = new Uint8Array(newSize);
	    buffer.set(output);
	  }
	  this.output = buffer;
	  return this.output;
	};
	/**
	 * concat output buffer. (dynamic)
	 * @return {!(Array|Uint8Array)} output buffer.
	 */


	Zlib.RawInflateStream.prototype.concatBuffer = function () {
	  /** @type {!(Array|Uint8Array)} output buffer. */
	  var buffer;
	  /** @type {number} */

	  var op = this.op;
	  /** @type {Uint8Array} */

	  var tmp;

	  if (this.resize) {
	    {
	      buffer = new Uint8Array(this.output.subarray(this.sp, op));
	    }
	  } else {
	    buffer = this.output.subarray(this.sp, op);
	  }

	  this.sp = op; // compaction

	  if (op > Zlib.RawInflateStream.MaxBackwardLength + this.bufferSize) {
	    this.op = this.sp = Zlib.RawInflateStream.MaxBackwardLength;
	    {
	      tmp =
	      /** @type {Uint8Array} */
	      this.output;
	      this.output = new Uint8Array(this.bufferSize + Zlib.RawInflateStream.MaxBackwardLength);
	      this.output.set(tmp.subarray(op - Zlib.RawInflateStream.MaxBackwardLength, op));
	    }
	  }

	  return buffer;
	};
	/**
	 * @constructor
	 * @param {!(Uint8Array|Array)} input deflated buffer.
	 * @param {Object=} opt_params option parameters.
	 *
	 * opt_params は以下のプロパティを指定する事ができます。
	 *   - index: input buffer の deflate コンテナの開始位置.
	 *   - blockSize: バッファのブロックサイズ.
	 *   - verify: 伸張が終わった後 adler-32 checksum の検証を行うか.
	 *   - bufferType: Zlib.Inflate.BufferType の値によってバッファの管理方法を指定する.
	 *       Zlib.Inflate.BufferType は Zlib.RawInflate.BufferType のエイリアス.
	 */


	Zlib.Inflate = function (input, opt_params) {
	  /** @type {number} */
	  var cmf;
	  /** @type {number} */

	  var flg;
	  /** @type {!(Uint8Array|Array)} */

	  this.input = input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {Zlib.RawInflate} */

	  this.rawinflate;
	  /** @type {(boolean|undefined)} verify flag. */

	  this.verify; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (opt_params['index']) {
	      this.ip = opt_params['index'];
	    }

	    if (opt_params['verify']) {
	      this.verify = opt_params['verify'];
	    }
	  } // Compression Method and Flags


	  cmf = input[this.ip++];
	  flg = input[this.ip++]; // compression method

	  switch (cmf & 0x0f) {
	    case Zlib.CompressionMethod.DEFLATE:
	      this.method = Zlib.CompressionMethod.DEFLATE;
	      break;

	    default:
	      throw new Error('unsupported compression method');
	  } // fcheck


	  if (((cmf << 8) + flg) % 31 !== 0) {
	    throw new Error('invalid fcheck flag:' + ((cmf << 8) + flg) % 31);
	  } // fdict (not supported)


	  if (flg & 0x20) {
	    throw new Error('fdict flag is not supported');
	  } // RawInflate


	  this.rawinflate = new Zlib.RawInflate(input, {
	    'index': this.ip,
	    'bufferSize': opt_params['bufferSize'],
	    'bufferType': opt_params['bufferType'],
	    'resize': opt_params['resize']
	  });
	};
	/**
	 * @enum {number}
	 */


	Zlib.Inflate.BufferType = Zlib.RawInflate.BufferType;
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */

	Zlib.Inflate.prototype.decompress = function () {
	  /** @type {!(Array|Uint8Array)} input buffer. */
	  var input = this.input;
	  /** @type {!(Uint8Array|Array)} inflated buffer. */

	  var buffer;
	  /** @type {number} adler-32 checksum */

	  var adler32;
	  buffer = this.rawinflate.decompress();
	  this.ip = this.rawinflate.ip; // verify adler-32

	  if (this.verify) {
	    adler32 = (input[this.ip++] << 24 | input[this.ip++] << 16 | input[this.ip++] << 8 | input[this.ip++]) >>> 0;

	    if (adler32 !== Zlib.Adler32(buffer)) {
	      throw new Error('invalid adler-32 checksum');
	    }
	  }

	  return buffer;
	};
	/* vim:set expandtab ts=2 sw=2 tw=80: */

	/**
	 * @param {!(Uint8Array|Array)} input deflated buffer.
	 * @constructor
	 */


	Zlib.InflateStream = function (input) {
	  /** @type {!(Uint8Array|Array)} */
	  this.input = input === void 0 ? new Uint8Array() : input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {Zlib.RawInflateStream} */

	  this.rawinflate = new Zlib.RawInflateStream(this.input, this.ip);
	  /** @type {Zlib.CompressionMethod} */

	  this.method;
	  /** @type {!(Array|Uint8Array)} */

	  this.output = this.rawinflate.output;
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */


	Zlib.InflateStream.prototype.decompress = function (input) {
	  /** @type {!(Uint8Array|Array)} inflated buffer. */
	  var buffer; // 新しい入力を入力バッファに結合する
	  // XXX Array, Uint8Array のチェックを行うか確認する

	  if (input !== void 0) {
	    {
	      var tmp = new Uint8Array(this.input.length + input.length);
	      tmp.set(this.input, 0);
	      tmp.set(input, this.input.length);
	      this.input = tmp;
	    }
	  }

	  if (this.method === void 0) {
	    if (this.readHeader() < 0) {
	      return new Uint8Array();
	    }
	  }

	  buffer = this.rawinflate.decompress(this.input, this.ip);

	  if (this.rawinflate.ip !== 0) {
	    this.input = this.input.subarray(this.rawinflate.ip);
	    this.ip = 0;
	  } // verify adler-32

	  /*
	  if (this.verify) {
	    adler32 =
	      input[this.ip++] << 24 | input[this.ip++] << 16 |
	      input[this.ip++] << 8 | input[this.ip++];
	     if (adler32 !== Zlib.Adler32(buffer)) {
	      throw new Error('invalid adler-32 checksum');
	    }
	  }
	  */


	  return buffer;
	};

	Zlib.InflateStream.prototype.readHeader = function () {
	  var ip = this.ip;
	  var input = this.input; // Compression Method and Flags

	  var cmf = input[ip++];
	  var flg = input[ip++];

	  if (cmf === void 0 || flg === void 0) {
	    return -1;
	  } // compression method


	  switch (cmf & 0x0f) {
	    case Zlib.CompressionMethod.DEFLATE:
	      this.method = Zlib.CompressionMethod.DEFLATE;
	      break;

	    default:
	      throw new Error('unsupported compression method');
	  } // fcheck


	  if (((cmf << 8) + flg) % 31 !== 0) {
	    throw new Error('invalid fcheck flag:' + ((cmf << 8) + flg) % 31);
	  } // fdict (not supported)


	  if (flg & 0x20) {
	    throw new Error('fdict flag is not supported');
	  }

	  this.ip = ip;
	};
	/**
	 * @fileoverview GZIP (RFC1952) 展開コンテナ実装.
	 */

	/**
	 * @constructor
	 * @param {!(Array|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params option parameters.
	 */


	Zlib.Gunzip = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */
	  this.input = input;
	  /** @type {number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {Array.<Zlib.GunzipMember>} */

	  this.member = [];
	  /** @type {boolean} */

	  this.decompressed = false;
	};
	/**
	 * @return {Array.<Zlib.GunzipMember>}
	 */


	Zlib.Gunzip.prototype.getMembers = function () {
	  if (!this.decompressed) {
	    this.decompress();
	  }

	  return this.member.slice();
	};
	/**
	 * inflate gzip data.
	 * @return {!(Array.<number>|Uint8Array)} inflated buffer.
	 */


	Zlib.Gunzip.prototype.decompress = function () {
	  /** @type {number} input length. */
	  var il = this.input.length;

	  while (this.ip < il) {
	    this.decodeMember();
	  }

	  this.decompressed = true;
	  return this.concatMember();
	};
	/**
	 * decode gzip member.
	 */


	Zlib.Gunzip.prototype.decodeMember = function () {
	  /** @type {Zlib.GunzipMember} */
	  var member = new Zlib.GunzipMember();
	  /** @type {number} */

	  var isize;
	  /** @type {Zlib.RawInflate} RawInflate implementation. */

	  var rawinflate;
	  /** @type {!(Array.<number>|Uint8Array)} inflated data. */

	  var inflated;
	  /** @type {number} inflate size */

	  var inflen;
	  /** @type {number} character code */

	  var c;
	  /** @type {number} character index in string. */

	  var ci;
	  /** @type {Array.<string>} character array. */

	  var str;
	  /** @type {number} modification time. */

	  var mtime;
	  /** @type {number} */

	  var crc32;
	  var input = this.input;
	  var ip = this.ip;
	  member.id1 = input[ip++];
	  member.id2 = input[ip++]; // check signature

	  if (member.id1 !== 0x1f || member.id2 !== 0x8b) {
	    throw new Error('invalid file signature:' + member.id1 + ',' + member.id2);
	  } // check compression method


	  member.cm = input[ip++];

	  switch (member.cm) {
	    case 8:
	      /* XXX: use Zlib const */
	      break;

	    default:
	      throw new Error('unknown compression method: ' + member.cm);
	  } // flags


	  member.flg = input[ip++]; // modification time

	  mtime = input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24;
	  member.mtime = new Date(mtime * 1000); // extra flags

	  member.xfl = input[ip++]; // operating system

	  member.os = input[ip++]; // extra

	  if ((member.flg & Zlib.Gzip.FlagsMask.FEXTRA) > 0) {
	    member.xlen = input[ip++] | input[ip++] << 8;
	    ip = this.decodeSubField(ip, member.xlen);
	  } // fname


	  if ((member.flg & Zlib.Gzip.FlagsMask.FNAME) > 0) {
	    for (str = [], ci = 0; (c = input[ip++]) > 0;) {
	      str[ci++] = String.fromCharCode(c);
	    }

	    member.name = str.join('');
	  } // fcomment


	  if ((member.flg & Zlib.Gzip.FlagsMask.FCOMMENT) > 0) {
	    for (str = [], ci = 0; (c = input[ip++]) > 0;) {
	      str[ci++] = String.fromCharCode(c);
	    }

	    member.comment = str.join('');
	  } // fhcrc


	  if ((member.flg & Zlib.Gzip.FlagsMask.FHCRC) > 0) {
	    member.crc16 = Zlib.CRC32.calc(input, 0, ip) & 0xffff;

	    if (member.crc16 !== (input[ip++] | input[ip++] << 8)) {
	      throw new Error('invalid header crc16');
	    }
	  } // isize を事前に取得すると展開後のサイズが分かるため、
	  // inflate処理のバッファサイズが事前に分かり、高速になる


	  isize = input[input.length - 4] | input[input.length - 3] << 8 | input[input.length - 2] << 16 | input[input.length - 1] << 24; // isize の妥当性チェック
	  // ハフマン符号では最小 2-bit のため、最大で 1/4 になる
	  // LZ77 符号では 長さと距離 2-Byte で最大 258-Byte を表現できるため、
	  // 1/128 になるとする
	  // ここから入力バッファの残りが isize の 512 倍以上だったら
	  // サイズ指定のバッファ確保は行わない事とする

	  if (input.length - ip -
	  /* CRC-32 */
	  4 -
	  /* ISIZE */
	  4 < isize * 512) {
	    inflen = isize;
	  } // compressed block


	  rawinflate = new Zlib.RawInflate(input, {
	    'index': ip,
	    'bufferSize': inflen
	  });
	  member.data = inflated = rawinflate.decompress();
	  ip = rawinflate.ip; // crc32

	  member.crc32 = crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0;

	  if (Zlib.CRC32.calc(inflated) !== crc32) {
	    throw new Error('invalid CRC-32 checksum: 0x' + Zlib.CRC32.calc(inflated).toString(16) + ' / 0x' + crc32.toString(16));
	  } // input size


	  member.isize = isize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0;

	  if ((inflated.length & 0xffffffff) !== isize) {
	    throw new Error('invalid input size: ' + (inflated.length & 0xffffffff) + ' / ' + isize);
	  }

	  this.member.push(member);
	  this.ip = ip;
	};
	/**
	 * サブフィールドのデコード
	 * XXX: 現在は何もせずスキップする
	 */


	Zlib.Gunzip.prototype.decodeSubField = function (ip, length) {
	  return ip + length;
	};
	/**
	 * @return {!(Array.<number>|Uint8Array)}
	 */


	Zlib.Gunzip.prototype.concatMember = function () {
	  /** @type {Array.<Zlib.GunzipMember>} */
	  var member = this.member;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {number} */

	  var p = 0;
	  /** @type {number} */

	  var size = 0;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var buffer;

	  for (i = 0, il = member.length; i < il; ++i) {
	    size += member[i].data.length;
	  }

	  {
	    buffer = new Uint8Array(size);

	    for (i = 0; i < il; ++i) {
	      buffer.set(member[i].data, p);
	      p += member[i].data.length;
	    }
	  }
	  return buffer;
	};
	/**
	 * @constructor
	 */


	Zlib.GunzipMember = function () {
	  /** @type {number} signature first byte. */
	  this.id1;
	  /** @type {number} signature second byte. */

	  this.id2;
	  /** @type {number} compression method. */

	  this.cm;
	  /** @type {number} flags. */

	  this.flg;
	  /** @type {Date} modification time. */

	  this.mtime;
	  /** @type {number} extra flags. */

	  this.xfl;
	  /** @type {number} operating system number. */

	  this.os;
	  /** @type {number} CRC-16 value for FHCRC flag. */

	  this.crc16;
	  /** @type {number} extra length. */

	  this.xlen;
	  /** @type {number} CRC-32 value for verification. */

	  this.crc32;
	  /** @type {number} input size modulo 32 value. */

	  this.isize;
	  /** @type {string} filename. */

	  this.name;
	  /** @type {string} comment. */

	  this.comment;
	  /** @type {!(Uint8Array|Array.<number>)} */

	  this.data;
	};

	Zlib.GunzipMember.prototype.getName = function () {
	  return this.name;
	};

	Zlib.GunzipMember.prototype.getData = function () {
	  return this.data;
	};

	Zlib.GunzipMember.prototype.getMtime = function () {
	  return this.mtime;
	};
	/**
	 * @fileoverview GZIP (RFC1952) 実装.
	 */

	/**
	 * @constructor
	 * @param {!(Array|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params option parameters.
	 */


	Zlib.Gzip = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */
	  this.input = input;
	  /** @type {number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {!(Array.<number>|Uint8Array)} output buffer. */

	  this.output;
	  /** @type {number} output buffer. */

	  this.op = 0;
	  /** @type {!Object} flags option flags. */

	  this.flags = {};
	  /** @type {!string} filename. */

	  this.filename;
	  /** @type {!string} comment. */

	  this.comment;
	  /** @type {!Object} deflate options. */

	  this.deflateOptions; // option parameters

	  if (opt_params) {
	    if (opt_params['flags']) {
	      this.flags = opt_params['flags'];
	    }

	    if (typeof opt_params['filename'] === 'string') {
	      this.filename = opt_params['filename'];
	    }

	    if (typeof opt_params['comment'] === 'string') {
	      this.comment = opt_params['comment'];
	    }

	    if (opt_params['deflateOptions']) {
	      this.deflateOptions = opt_params['deflateOptions'];
	    }
	  }

	  if (!this.deflateOptions) {
	    this.deflateOptions = {};
	  }
	};
	/**
	 * @type {number}
	 * @const
	 */


	Zlib.Gzip.DefaultBufferSize = 0x8000;
	/**
	 * encode gzip members.
	 * @return {!(Array|Uint8Array)} gzip binary array.
	 */

	Zlib.Gzip.prototype.compress = function () {
	  /** @type {number} flags. */
	  var flg;
	  /** @type {number} modification time. */

	  var mtime;
	  /** @type {number} CRC-16 value for FHCRC flag. */

	  var crc16;
	  /** @type {number} CRC-32 value for verification. */

	  var crc32;
	  /** @type {!Zlib.RawDeflate} raw deflate object. */

	  var rawdeflate;
	  /** @type {number} character code */

	  var c;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limiter. */

	  var il;
	  /** @type {!(Array|Uint8Array)} output buffer. */

	  var output = new Uint8Array(Zlib.Gzip.DefaultBufferSize);
	  /** @type {number} output buffer pointer. */

	  var op = 0;
	  var input = this.input;
	  var ip = this.ip;
	  var filename = this.filename;
	  var comment = this.comment; // check signature

	  output[op++] = 0x1f;
	  output[op++] = 0x8b; // check compression method

	  output[op++] = 8;
	  /* XXX: use Zlib const */
	  // flags

	  flg = 0;
	  if (this.flags['fname']) flg |= Zlib.Gzip.FlagsMask.FNAME;
	  if (this.flags['fcomment']) flg |= Zlib.Gzip.FlagsMask.FCOMMENT;
	  if (this.flags['fhcrc']) flg |= Zlib.Gzip.FlagsMask.FHCRC; // XXX: FTEXT
	  // XXX: FEXTRA

	  output[op++] = flg; // modification time

	  mtime = (Date.now ? Date.now() : +new Date()) / 1000 | 0;
	  output[op++] = mtime & 0xff;
	  output[op++] = mtime >>> 8 & 0xff;
	  output[op++] = mtime >>> 16 & 0xff;
	  output[op++] = mtime >>> 24 & 0xff; // extra flags

	  output[op++] = 0; // operating system

	  output[op++] = Zlib.Gzip.OperatingSystem.UNKNOWN; // extra

	  /* NOP */
	  // fname

	  if (this.flags['fname'] !== void 0) {
	    for (i = 0, il = filename.length; i < il; ++i) {
	      c = filename.charCodeAt(i);

	      if (c > 0xff) {
	        output[op++] = c >>> 8 & 0xff;
	      }

	      output[op++] = c & 0xff;
	    }

	    output[op++] = 0; // null termination
	  } // fcomment


	  if (this.flags['comment']) {
	    for (i = 0, il = comment.length; i < il; ++i) {
	      c = comment.charCodeAt(i);

	      if (c > 0xff) {
	        output[op++] = c >>> 8 & 0xff;
	      }

	      output[op++] = c & 0xff;
	    }

	    output[op++] = 0; // null termination
	  } // fhcrc


	  if (this.flags['fhcrc']) {
	    crc16 = Zlib.CRC32.calc(output, 0, op) & 0xffff;
	    output[op++] = crc16 & 0xff;
	    output[op++] = crc16 >>> 8 & 0xff;
	  } // add compress option


	  this.deflateOptions['outputBuffer'] = output;
	  this.deflateOptions['outputIndex'] = op; // compress

	  rawdeflate = new Zlib.RawDeflate(input, this.deflateOptions);
	  output = rawdeflate.compress();
	  op = rawdeflate.op; // expand buffer

	  {
	    if (op + 8 > output.buffer.byteLength) {
	      this.output = new Uint8Array(op + 8);
	      this.output.set(new Uint8Array(output.buffer));
	      output = this.output;
	    } else {
	      output = new Uint8Array(output.buffer);
	    }
	  } // crc32

	  crc32 = Zlib.CRC32.calc(input);
	  output[op++] = crc32 & 0xff;
	  output[op++] = crc32 >>> 8 & 0xff;
	  output[op++] = crc32 >>> 16 & 0xff;
	  output[op++] = crc32 >>> 24 & 0xff; // input size

	  il = input.length;
	  output[op++] = il & 0xff;
	  output[op++] = il >>> 8 & 0xff;
	  output[op++] = il >>> 16 & 0xff;
	  output[op++] = il >>> 24 & 0xff;
	  this.ip = ip;

	  if (op < output.length) {
	    this.output = output = output.subarray(0, op);
	  }

	  return output;
	};
	/** @enum {number} */


	Zlib.Gzip.OperatingSystem = {
	  FAT: 0,
	  AMIGA: 1,
	  VMS: 2,
	  UNIX: 3,
	  VM_CMS: 4,
	  ATARI_TOS: 5,
	  HPFS: 6,
	  MACINTOSH: 7,
	  Z_SYSTEM: 8,
	  CP_M: 9,
	  TOPS_20: 10,
	  NTFS: 11,
	  QDOS: 12,
	  ACORN_RISCOS: 13,
	  UNKNOWN: 255
	};
	/** @enum {number} */

	Zlib.Gzip.FlagsMask = {
	  FTEXT: 0x01,
	  FHCRC: 0x02,
	  FEXTRA: 0x04,
	  FNAME: 0x08,
	  FCOMMENT: 0x10
	};
	/**
	 * @fileoverview Heap Sort 実装. ハフマン符号化で使用する.
	 */

	/**
	 * カスタムハフマン符号で使用するヒープ実装
	 * @param {number} length ヒープサイズ.
	 * @constructor
	 */

	Zlib.Heap = function (length) {
	  this.buffer = new Uint16Array(length * 2);
	  this.length = 0;
	};
	/**
	 * 親ノードの index 取得
	 * @param {number} index 子ノードの index.
	 * @return {number} 親ノードの index.
	 *
	 */


	Zlib.Heap.prototype.getParent = function (index) {
	  return ((index - 2) / 4 | 0) * 2;
	};
	/**
	 * 子ノードの index 取得
	 * @param {number} index 親ノードの index.
	 * @return {number} 子ノードの index.
	 */


	Zlib.Heap.prototype.getChild = function (index) {
	  return 2 * index + 2;
	};
	/**
	 * Heap に値を追加する
	 * @param {number} index キー index.
	 * @param {number} value 値.
	 * @return {number} 現在のヒープ長.
	 */


	Zlib.Heap.prototype.push = function (index, value) {
	  var current,
	      parent,
	      heap = this.buffer,
	      swap;
	  current = this.length;
	  heap[this.length++] = value;
	  heap[this.length++] = index; // ルートノードにたどり着くまで入れ替えを試みる

	  while (current > 0) {
	    parent = this.getParent(current); // 親ノードと比較して親の方が小さければ入れ替える

	    if (heap[current] > heap[parent]) {
	      swap = heap[current];
	      heap[current] = heap[parent];
	      heap[parent] = swap;
	      swap = heap[current + 1];
	      heap[current + 1] = heap[parent + 1];
	      heap[parent + 1] = swap;
	      current = parent; // 入れ替えが必要なくなったらそこで抜ける
	    } else {
	      break;
	    }
	  }

	  return this.length;
	};
	/**
	 * Heapから一番大きい値を返す
	 * @return {{index: number, value: number, length: number}} {index: キーindex,
	 *     value: 値, length: ヒープ長} の Object.
	 */


	Zlib.Heap.prototype.pop = function () {
	  var index,
	      value,
	      heap = this.buffer,
	      swap,
	      current,
	      parent;
	  value = heap[0];
	  index = heap[1]; // 後ろから値を取る

	  this.length -= 2;
	  heap[0] = heap[this.length];
	  heap[1] = heap[this.length + 1];
	  parent = 0; // ルートノードから下がっていく

	  while (true) {
	    current = this.getChild(parent); // 範囲チェック

	    if (current >= this.length) {
	      break;
	    } // 隣のノードと比較して、隣の方が値が大きければ隣を現在ノードとして選択


	    if (current + 2 < this.length && heap[current + 2] > heap[current]) {
	      current += 2;
	    } // 親ノードと比較して親の方が小さい場合は入れ替える


	    if (heap[current] > heap[parent]) {
	      swap = heap[parent];
	      heap[parent] = heap[current];
	      heap[current] = swap;
	      swap = heap[parent + 1];
	      heap[parent + 1] = heap[current + 1];
	      heap[current + 1] = swap;
	    } else {
	      break;
	    }

	    parent = current;
	  }

	  return {
	    index: index,
	    value: value,
	    length: this.length
	  };
	};
	/* vim:set expandtab ts=2 sw=2 tw=80: */

	/**
	 * @fileoverview Deflate (RFC1951) 符号化アルゴリズム実装.
	 */

	/**
	 * Raw Deflate 実装
	 *
	 * @constructor
	 * @param {!(Array.<number>|Uint8Array)} input 符号化する対象のバッファ.
	 * @param {Object=} opt_params option parameters.
	 *
	 * typed array が使用可能なとき、outputBuffer が Array は自動的に Uint8Array に
	 * 変換されます.
	 * 別のオブジェクトになるため出力バッファを参照している変数などは
	 * 更新する必要があります.
	 */


	Zlib.RawDeflate = function (input, opt_params) {
	  /** @type {Zlib.RawDeflate.CompressionType} */
	  this.compressionType = Zlib.RawDeflate.CompressionType.DYNAMIC;
	  /** @type {number} */

	  this.lazy = 0;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  this.freqsLitLen;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  this.freqsDist;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.input = input instanceof Array ? new Uint8Array(input) : input;
	  /** @type {!(Array.<number>|Uint8Array)} output output buffer. */

	  this.output;
	  /** @type {number} pos output buffer position. */

	  this.op = 0; // option parameters

	  if (opt_params) {
	    if (opt_params['lazy']) {
	      this.lazy = opt_params['lazy'];
	    }

	    if (typeof opt_params['compressionType'] === 'number') {
	      this.compressionType = opt_params['compressionType'];
	    }

	    if (opt_params['outputBuffer']) {
	      this.output = opt_params['outputBuffer'] instanceof Array ? new Uint8Array(opt_params['outputBuffer']) : opt_params['outputBuffer'];
	    }

	    if (typeof opt_params['outputIndex'] === 'number') {
	      this.op = opt_params['outputIndex'];
	    }
	  }

	  if (!this.output) {
	    this.output = new Uint8Array(0x8000);
	  }
	};
	/**
	 * @enum {number}
	 */


	Zlib.RawDeflate.CompressionType = {
	  NONE: 0,
	  FIXED: 1,
	  DYNAMIC: 2,
	  RESERVED: 3
	};
	/**
	 * LZ77 の最小マッチ長
	 * @const
	 * @type {number}
	 */

	Zlib.RawDeflate.Lz77MinLength = 3;
	/**
	 * LZ77 の最大マッチ長
	 * @const
	 * @type {number}
	 */

	Zlib.RawDeflate.Lz77MaxLength = 258;
	/**
	 * LZ77 のウィンドウサイズ
	 * @const
	 * @type {number}
	 */

	Zlib.RawDeflate.WindowSize = 0x8000;
	/**
	 * 最長の符号長
	 * @const
	 * @type {number}
	 */

	Zlib.RawDeflate.MaxCodeLength = 16;
	/**
	 * ハフマン符号の最大数値
	 * @const
	 * @type {number}
	 */

	Zlib.RawDeflate.HUFMAX = 286;
	/**
	 * 固定ハフマン符号の符号化テーブル
	 * @const
	 * @type {Array.<Array.<number, number>>}
	 */

	Zlib.RawDeflate.FixedHuffmanTable = function () {
	  var table = [],
	      i;

	  for (i = 0; i < 288; i++) {
	    switch (true) {
	      case i <= 143:
	        table.push([i + 0x030, 8]);
	        break;

	      case i <= 255:
	        table.push([i - 144 + 0x190, 9]);
	        break;

	      case i <= 279:
	        table.push([i - 256 + 0x000, 7]);
	        break;

	      case i <= 287:
	        table.push([i - 280 + 0x0C0, 8]);
	        break;

	      default:
	        throw 'invalid literal: ' + i;
	    }
	  }

	  return table;
	}();
	/**
	 * DEFLATE ブロックの作成
	 * @return {!(Array.<number>|Uint8Array)} 圧縮済み byte array.
	 */


	Zlib.RawDeflate.prototype.compress = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var blockArray;
	  /** @type {number} */

	  var position;
	  /** @type {number} */

	  var length;
	  var input = this.input; // compression

	  switch (this.compressionType) {
	    case Zlib.RawDeflate.CompressionType.NONE:
	      // each 65535-Byte (length header: 16-bit)
	      for (position = 0, length = input.length; position < length;) {
	        blockArray = input.subarray(position, position + 0xffff);
	        position += blockArray.length;
	        this.makeNocompressBlock(blockArray, position === length);
	      }

	      break;

	    case Zlib.RawDeflate.CompressionType.FIXED:
	      this.output = this.makeFixedHuffmanBlock(input, true);
	      this.op = this.output.length;
	      break;

	    case Zlib.RawDeflate.CompressionType.DYNAMIC:
	      this.output = this.makeDynamicHuffmanBlock(input, true);
	      this.op = this.output.length;
	      break;

	    default:
	      throw 'invalid compression type';
	  }

	  return this.output;
	};
	/**
	 * 非圧縮ブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 非圧縮ブロック byte array.
	 */


	Zlib.RawDeflate.prototype.makeNocompressBlock = function (blockArray, isFinalBlock) {
	  /** @type {number} */
	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {number} */

	  var len;
	  /** @type {number} */

	  var nlen;
	  var output = this.output;
	  var op = this.op; // expand buffer

	  {
	    output = new Uint8Array(this.output.buffer);

	    while (output.length <= op + blockArray.length + 5) {
	      output = new Uint8Array(output.length << 1);
	    }

	    output.set(this.output);
	  } // header

	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib.RawDeflate.CompressionType.NONE;
	  output[op++] = bfinal | btype << 1; // length

	  len = blockArray.length;
	  nlen = ~len + 0x10000 & 0xffff;
	  output[op++] = len & 0xff;
	  output[op++] = len >>> 8 & 0xff;
	  output[op++] = nlen & 0xff;
	  output[op++] = nlen >>> 8 & 0xff; // copy buffer

	  {
	    output.set(blockArray, op);
	    op += blockArray.length;
	    output = output.subarray(0, op);
	  }
	  this.op = op;
	  this.output = output;
	  return output;
	};
	/**
	 * 固定ハフマンブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 固定ハフマン符号化ブロック byte array.
	 */


	Zlib.RawDeflate.prototype.makeFixedHuffmanBlock = function (blockArray, isFinalBlock) {
	  /** @type {Zlib.BitStream} */
	  var stream = new Zlib.BitStream(new Uint8Array(this.output.buffer), this.op);
	  /** @type {number} */

	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var data; // header

	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib.RawDeflate.CompressionType.FIXED;
	  stream.writeBits(bfinal, 1, true);
	  stream.writeBits(btype, 2, true);
	  data = this.lz77(blockArray);
	  this.fixedHuffman(data, stream);
	  return stream.finish();
	};
	/**
	 * 動的ハフマンブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 動的ハフマン符号ブロック byte array.
	 */


	Zlib.RawDeflate.prototype.makeDynamicHuffmanBlock = function (blockArray, isFinalBlock) {
	  /** @type {Zlib.BitStream} */
	  var stream = new Zlib.BitStream(new Uint8Array(this.output.buffer), this.op);
	  /** @type {number} */

	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var data;
	  /** @type {number} */

	  var hlit;
	  /** @type {number} */

	  var hdist;
	  /** @type {number} */

	  var hclen;
	  /** @const @type {Array.<number>} */

	  var hclenOrder = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var litLenLengths;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var litLenCodes;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var distLengths;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var distCodes;
	  /** @type {{
	   *   codes: !(Array.<number>|Uint32Array),
	   *   freqs: !(Array.<number>|Uint8Array)
	   * }} */

	  var treeSymbols;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var treeLengths;
	  /** @type {Array} */

	  var transLengths = new Array(19);
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var treeCodes;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var bitlen;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il; // header

	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib.RawDeflate.CompressionType.DYNAMIC;
	  stream.writeBits(bfinal, 1, true);
	  stream.writeBits(btype, 2, true);
	  data = this.lz77(blockArray); // リテラル・長さ, 距離のハフマン符号と符号長の算出

	  litLenLengths = this.getLengths_(this.freqsLitLen, 15);
	  litLenCodes = this.getCodesFromLengths_(litLenLengths);
	  distLengths = this.getLengths_(this.freqsDist, 7);
	  distCodes = this.getCodesFromLengths_(distLengths); // HLIT, HDIST の決定

	  for (hlit = 286; hlit > 257 && litLenLengths[hlit - 1] === 0; hlit--) {}

	  for (hdist = 30; hdist > 1 && distLengths[hdist - 1] === 0; hdist--) {} // HCLEN


	  treeSymbols = this.getTreeSymbols_(hlit, litLenLengths, hdist, distLengths);
	  treeLengths = this.getLengths_(treeSymbols.freqs, 7);

	  for (i = 0; i < 19; i++) {
	    transLengths[i] = treeLengths[hclenOrder[i]];
	  }

	  for (hclen = 19; hclen > 4 && transLengths[hclen - 1] === 0; hclen--) {}

	  treeCodes = this.getCodesFromLengths_(treeLengths); // 出力

	  stream.writeBits(hlit - 257, 5, true);
	  stream.writeBits(hdist - 1, 5, true);
	  stream.writeBits(hclen - 4, 4, true);

	  for (i = 0; i < hclen; i++) {
	    stream.writeBits(transLengths[i], 3, true);
	  } // ツリーの出力


	  for (i = 0, il = treeSymbols.codes.length; i < il; i++) {
	    code = treeSymbols.codes[i];
	    stream.writeBits(treeCodes[code], treeLengths[code], true); // extra bits

	    if (code >= 16) {
	      i++;

	      switch (code) {
	        case 16:
	          bitlen = 2;
	          break;

	        case 17:
	          bitlen = 3;
	          break;

	        case 18:
	          bitlen = 7;
	          break;

	        default:
	          throw 'invalid code: ' + code;
	      }

	      stream.writeBits(treeSymbols.codes[i], bitlen, true);
	    }
	  }

	  this.dynamicHuffman(data, [litLenCodes, litLenLengths], [distCodes, distLengths], stream);
	  return stream.finish();
	};
	/**
	 * 動的ハフマン符号化(カスタムハフマンテーブル)
	 * @param {!(Array.<number>|Uint16Array)} dataArray LZ77 符号化済み byte array.
	 * @param {!Zlib.BitStream} stream 書き込み用ビットストリーム.
	 * @return {!Zlib.BitStream} ハフマン符号化済みビットストリームオブジェクト.
	 */


	Zlib.RawDeflate.prototype.dynamicHuffman = function (dataArray, litLen, dist, stream) {
	  /** @type {number} */
	  var index;
	  /** @type {number} */

	  var length;
	  /** @type {number} */

	  var literal;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var litLenCodes;
	  /** @type {number} */

	  var litLenLengths;
	  /** @type {number} */

	  var distCodes;
	  /** @type {number} */

	  var distLengths;
	  litLenCodes = litLen[0];
	  litLenLengths = litLen[1];
	  distCodes = dist[0];
	  distLengths = dist[1]; // 符号を BitStream に書き込んでいく

	  for (index = 0, length = dataArray.length; index < length; ++index) {
	    literal = dataArray[index]; // literal or length

	    stream.writeBits(litLenCodes[literal], litLenLengths[literal], true); // 長さ・距離符号

	    if (literal > 256) {
	      // length extra
	      stream.writeBits(dataArray[++index], dataArray[++index], true); // distance

	      code = dataArray[++index];
	      stream.writeBits(distCodes[code], distLengths[code], true); // distance extra

	      stream.writeBits(dataArray[++index], dataArray[++index], true); // 終端
	    } else if (literal === 256) {
	      break;
	    }
	  }

	  return stream;
	};
	/**
	 * 固定ハフマン符号化
	 * @param {!(Array.<number>|Uint16Array)} dataArray LZ77 符号化済み byte array.
	 * @param {!Zlib.BitStream} stream 書き込み用ビットストリーム.
	 * @return {!Zlib.BitStream} ハフマン符号化済みビットストリームオブジェクト.
	 */


	Zlib.RawDeflate.prototype.fixedHuffman = function (dataArray, stream) {
	  /** @type {number} */
	  var index;
	  /** @type {number} */

	  var length;
	  /** @type {number} */

	  var literal; // 符号を BitStream に書き込んでいく

	  for (index = 0, length = dataArray.length; index < length; index++) {
	    literal = dataArray[index]; // 符号の書き込み

	    Zlib.BitStream.prototype.writeBits.apply(stream, Zlib.RawDeflate.FixedHuffmanTable[literal]); // 長さ・距離符号

	    if (literal > 0x100) {
	      // length extra
	      stream.writeBits(dataArray[++index], dataArray[++index], true); // distance

	      stream.writeBits(dataArray[++index], 5); // distance extra

	      stream.writeBits(dataArray[++index], dataArray[++index], true); // 終端
	    } else if (literal === 0x100) {
	      break;
	    }
	  }

	  return stream;
	};
	/**
	 * マッチ情報
	 * @param {!number} length マッチした長さ.
	 * @param {!number} backwardDistance マッチ位置との距離.
	 * @constructor
	 */


	Zlib.RawDeflate.Lz77Match = function (length, backwardDistance) {
	  /** @type {number} match length. */
	  this.length = length;
	  /** @type {number} backward distance. */

	  this.backwardDistance = backwardDistance;
	};
	/**
	 * 長さ符号テーブル.
	 * [コード, 拡張ビット, 拡張ビット長] の配列となっている.
	 * @const
	 * @type {!(Array.<number>|Uint32Array)}
	 */


	Zlib.RawDeflate.Lz77Match.LengthCodeTable = function (table) {
	  return new Uint32Array(table);
	}(function () {
	  /** @type {!Array} */
	  var table = [];
	  /** @type {number} */

	  var i;
	  /** @type {!Array.<number>} */

	  var c;

	  for (i = 3; i <= 258; i++) {
	    c = code(i);
	    table[i] = c[2] << 24 | c[1] << 16 | c[0];
	  }
	  /**
	   * @param {number} length lz77 length.
	   * @return {!Array.<number>} lz77 codes.
	   */


	  function code(length) {
	    switch (true) {
	      case length === 3:
	        return [257, length - 3, 0];

	      case length === 4:
	        return [258, length - 4, 0];

	      case length === 5:
	        return [259, length - 5, 0];

	      case length === 6:
	        return [260, length - 6, 0];

	      case length === 7:
	        return [261, length - 7, 0];

	      case length === 8:
	        return [262, length - 8, 0];

	      case length === 9:
	        return [263, length - 9, 0];

	      case length === 10:
	        return [264, length - 10, 0];

	      case length <= 12:
	        return [265, length - 11, 1];

	      case length <= 14:
	        return [266, length - 13, 1];

	      case length <= 16:
	        return [267, length - 15, 1];

	      case length <= 18:
	        return [268, length - 17, 1];

	      case length <= 22:
	        return [269, length - 19, 2];

	      case length <= 26:
	        return [270, length - 23, 2];

	      case length <= 30:
	        return [271, length - 27, 2];

	      case length <= 34:
	        return [272, length - 31, 2];

	      case length <= 42:
	        return [273, length - 35, 3];

	      case length <= 50:
	        return [274, length - 43, 3];

	      case length <= 58:
	        return [275, length - 51, 3];

	      case length <= 66:
	        return [276, length - 59, 3];

	      case length <= 82:
	        return [277, length - 67, 4];

	      case length <= 98:
	        return [278, length - 83, 4];

	      case length <= 114:
	        return [279, length - 99, 4];

	      case length <= 130:
	        return [280, length - 115, 4];

	      case length <= 162:
	        return [281, length - 131, 5];

	      case length <= 194:
	        return [282, length - 163, 5];

	      case length <= 226:
	        return [283, length - 195, 5];

	      case length <= 257:
	        return [284, length - 227, 5];

	      case length === 258:
	        return [285, length - 258, 0];

	      default:
	        throw 'invalid length: ' + length;
	    }
	  }

	  return table;
	}());
	/**
	 * 距離符号テーブル
	 * @param {!number} dist 距離.
	 * @return {!Array.<number>} コード、拡張ビット、拡張ビット長の配列.
	 * @private
	 */


	Zlib.RawDeflate.Lz77Match.prototype.getDistanceCode_ = function (dist) {
	  /** @type {!Array.<number>} distance code table. */
	  var r;

	  switch (true) {
	    case dist === 1:
	      r = [0, dist - 1, 0];
	      break;

	    case dist === 2:
	      r = [1, dist - 2, 0];
	      break;

	    case dist === 3:
	      r = [2, dist - 3, 0];
	      break;

	    case dist === 4:
	      r = [3, dist - 4, 0];
	      break;

	    case dist <= 6:
	      r = [4, dist - 5, 1];
	      break;

	    case dist <= 8:
	      r = [5, dist - 7, 1];
	      break;

	    case dist <= 12:
	      r = [6, dist - 9, 2];
	      break;

	    case dist <= 16:
	      r = [7, dist - 13, 2];
	      break;

	    case dist <= 24:
	      r = [8, dist - 17, 3];
	      break;

	    case dist <= 32:
	      r = [9, dist - 25, 3];
	      break;

	    case dist <= 48:
	      r = [10, dist - 33, 4];
	      break;

	    case dist <= 64:
	      r = [11, dist - 49, 4];
	      break;

	    case dist <= 96:
	      r = [12, dist - 65, 5];
	      break;

	    case dist <= 128:
	      r = [13, dist - 97, 5];
	      break;

	    case dist <= 192:
	      r = [14, dist - 129, 6];
	      break;

	    case dist <= 256:
	      r = [15, dist - 193, 6];
	      break;

	    case dist <= 384:
	      r = [16, dist - 257, 7];
	      break;

	    case dist <= 512:
	      r = [17, dist - 385, 7];
	      break;

	    case dist <= 768:
	      r = [18, dist - 513, 8];
	      break;

	    case dist <= 1024:
	      r = [19, dist - 769, 8];
	      break;

	    case dist <= 1536:
	      r = [20, dist - 1025, 9];
	      break;

	    case dist <= 2048:
	      r = [21, dist - 1537, 9];
	      break;

	    case dist <= 3072:
	      r = [22, dist - 2049, 10];
	      break;

	    case dist <= 4096:
	      r = [23, dist - 3073, 10];
	      break;

	    case dist <= 6144:
	      r = [24, dist - 4097, 11];
	      break;

	    case dist <= 8192:
	      r = [25, dist - 6145, 11];
	      break;

	    case dist <= 12288:
	      r = [26, dist - 8193, 12];
	      break;

	    case dist <= 16384:
	      r = [27, dist - 12289, 12];
	      break;

	    case dist <= 24576:
	      r = [28, dist - 16385, 13];
	      break;

	    case dist <= 32768:
	      r = [29, dist - 24577, 13];
	      break;

	    default:
	      throw 'invalid distance';
	  }

	  return r;
	};
	/**
	 * マッチ情報を LZ77 符号化配列で返す.
	 * なお、ここでは以下の内部仕様で符号化している
	 * [ CODE, EXTRA-BIT-LEN, EXTRA, CODE, EXTRA-BIT-LEN, EXTRA ]
	 * @return {!Array.<number>} LZ77 符号化 byte array.
	 */


	Zlib.RawDeflate.Lz77Match.prototype.toLz77Array = function () {
	  /** @type {number} */
	  var length = this.length;
	  /** @type {number} */

	  var dist = this.backwardDistance;
	  /** @type {Array} */

	  var codeArray = [];
	  /** @type {number} */

	  var pos = 0;
	  /** @type {!Array.<number>} */

	  var code; // length

	  code = Zlib.RawDeflate.Lz77Match.LengthCodeTable[length];
	  codeArray[pos++] = code & 0xffff;
	  codeArray[pos++] = code >> 16 & 0xff;
	  codeArray[pos++] = code >> 24; // distance

	  code = this.getDistanceCode_(dist);
	  codeArray[pos++] = code[0];
	  codeArray[pos++] = code[1];
	  codeArray[pos++] = code[2];
	  return codeArray;
	};
	/**
	 * LZ77 実装
	 * @param {!(Array.<number>|Uint8Array)} dataArray LZ77 符号化するバイト配列.
	 * @return {!(Array.<number>|Uint16Array)} LZ77 符号化した配列.
	 */


	Zlib.RawDeflate.prototype.lz77 = function (dataArray) {
	  /** @type {number} input position */
	  var position;
	  /** @type {number} input length */

	  var length;
	  /** @type {number} loop counter */

	  var i;
	  /** @type {number} loop limiter */

	  var il;
	  /** @type {number} chained-hash-table key */

	  var matchKey;
	  /** @type {Object.<number, Array.<number>>} chained-hash-table */

	  var table = {};
	  /** @const @type {number} */

	  var windowSize = Zlib.RawDeflate.WindowSize;
	  /** @type {Array.<number>} match list */

	  var matchList;
	  /** @type {Zlib.RawDeflate.Lz77Match} longest match */

	  var longestMatch;
	  /** @type {Zlib.RawDeflate.Lz77Match} previous longest match */

	  var prevMatch;
	  /** @type {!(Array.<number>|Uint16Array)} lz77 buffer */

	  var lz77buf = new Uint16Array(dataArray.length * 2);
	  /** @type {number} lz77 output buffer pointer */

	  var pos = 0;
	  /** @type {number} lz77 skip length */

	  var skipLength = 0;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var freqsLitLen = new Uint32Array(286);
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var freqsDist = new Uint32Array(30);
	  /** @type {number} */

	  var lazy = this.lazy;
	  /** @type {*} temporary variable */

	  var tmp;
	  freqsLitLen[256] = 1; // EOB の最低出現回数は 1

	  /**
	   * マッチデータの書き込み
	   * @param {Zlib.RawDeflate.Lz77Match} match LZ77 Match data.
	   * @param {!number} offset スキップ開始位置(相対指定).
	   * @private
	   */

	  function writeMatch(match, offset) {
	    /** @type {Array.<number>} */
	    var lz77Array = match.toLz77Array();
	    /** @type {number} */

	    var i;
	    /** @type {number} */

	    var il;

	    for (i = 0, il = lz77Array.length; i < il; ++i) {
	      lz77buf[pos++] = lz77Array[i];
	    }

	    freqsLitLen[lz77Array[0]]++;
	    freqsDist[lz77Array[3]]++;
	    skipLength = match.length + offset - 1;
	    prevMatch = null;
	  } // LZ77 符号化


	  for (position = 0, length = dataArray.length; position < length; ++position) {
	    // ハッシュキーの作成
	    for (matchKey = 0, i = 0, il = Zlib.RawDeflate.Lz77MinLength; i < il; ++i) {
	      if (position + i === length) {
	        break;
	      }

	      matchKey = matchKey << 8 | dataArray[position + i];
	    } // テーブルが未定義だったら作成する


	    if (table[matchKey] === void 0) {
	      table[matchKey] = [];
	    }

	    matchList = table[matchKey]; // skip

	    if (skipLength-- > 0) {
	      matchList.push(position);
	      continue;
	    } // マッチテーブルの更新 (最大戻り距離を超えているものを削除する)


	    while (matchList.length > 0 && position - matchList[0] > windowSize) {
	      matchList.shift();
	    } // データ末尾でマッチしようがない場合はそのまま流しこむ


	    if (position + Zlib.RawDeflate.Lz77MinLength >= length) {
	      if (prevMatch) {
	        writeMatch(prevMatch, -1);
	      }

	      for (i = 0, il = length - position; i < il; ++i) {
	        tmp = dataArray[position + i];
	        lz77buf[pos++] = tmp;
	        ++freqsLitLen[tmp];
	      }

	      break;
	    } // マッチ候補から最長のものを探す


	    if (matchList.length > 0) {
	      longestMatch = this.searchLongestMatch_(dataArray, position, matchList);

	      if (prevMatch) {
	        // 現在のマッチの方が前回のマッチよりも長い
	        if (prevMatch.length < longestMatch.length) {
	          // write previous literal
	          tmp = dataArray[position - 1];
	          lz77buf[pos++] = tmp;
	          ++freqsLitLen[tmp]; // write current match

	          writeMatch(longestMatch, 0);
	        } else {
	          // write previous match
	          writeMatch(prevMatch, -1);
	        }
	      } else if (longestMatch.length < lazy) {
	        prevMatch = longestMatch;
	      } else {
	        writeMatch(longestMatch, 0);
	      } // 前回マッチしていて今回マッチがなかったら前回のを採用

	    } else if (prevMatch) {
	      writeMatch(prevMatch, -1);
	    } else {
	      tmp = dataArray[position];
	      lz77buf[pos++] = tmp;
	      ++freqsLitLen[tmp];
	    }

	    matchList.push(position); // マッチテーブルに現在の位置を保存
	  } // 終端処理


	  lz77buf[pos++] = 256;
	  freqsLitLen[256]++;
	  this.freqsLitLen = freqsLitLen;
	  this.freqsDist = freqsDist;
	  return (
	    /** @type {!(Uint16Array|Array.<number>)} */
	    lz77buf.subarray(0, pos)
	  );
	};
	/**
	 * マッチした候補の中から最長一致を探す
	 * @param {!Object} data plain data byte array.
	 * @param {!number} position plain data byte array position.
	 * @param {!Array.<number>} matchList 候補となる位置の配列.
	 * @return {!Zlib.RawDeflate.Lz77Match} 最長かつ最短距離のマッチオブジェクト.
	 * @private
	 */


	Zlib.RawDeflate.prototype.searchLongestMatch_ = function (data, position, matchList) {
	  var match,
	      currentMatch,
	      matchMax = 0,
	      matchLength,
	      i,
	      j,
	      l,
	      dl = data.length; // 候補を後ろから 1 つずつ絞り込んでゆく

	  permatch: for (i = 0, l = matchList.length; i < l; i++) {
	    match = matchList[l - i - 1];
	    matchLength = Zlib.RawDeflate.Lz77MinLength; // 前回までの最長一致を末尾から一致検索する

	    if (matchMax > Zlib.RawDeflate.Lz77MinLength) {
	      for (j = matchMax; j > Zlib.RawDeflate.Lz77MinLength; j--) {
	        if (data[match + j - 1] !== data[position + j - 1]) {
	          continue permatch;
	        }
	      }

	      matchLength = matchMax;
	    } // 最長一致探索


	    while (matchLength < Zlib.RawDeflate.Lz77MaxLength && position + matchLength < dl && data[match + matchLength] === data[position + matchLength]) {
	      ++matchLength;
	    } // マッチ長が同じ場合は後方を優先


	    if (matchLength > matchMax) {
	      currentMatch = match;
	      matchMax = matchLength;
	    } // 最長が確定したら後の処理は省略


	    if (matchLength === Zlib.RawDeflate.Lz77MaxLength) {
	      break;
	    }
	  }

	  return new Zlib.RawDeflate.Lz77Match(matchMax, position - currentMatch);
	};
	/**
	 * Tree-Transmit Symbols の算出
	 * reference: PuTTY Deflate implementation
	 * @param {number} hlit HLIT.
	 * @param {!(Array.<number>|Uint8Array)} litlenLengths リテラルと長さ符号の符号長配列.
	 * @param {number} hdist HDIST.
	 * @param {!(Array.<number>|Uint8Array)} distLengths 距離符号の符号長配列.
	 * @return {{
	 *   codes: !(Array.<number>|Uint32Array),
	 *   freqs: !(Array.<number>|Uint8Array)
	 * }} Tree-Transmit Symbols.
	 */


	Zlib.RawDeflate.prototype.getTreeSymbols_ = function (hlit, litlenLengths, hdist, distLengths) {
	  var src = new Uint32Array(hlit + hdist),
	      i,
	      j,
	      runLength,
	      l,
	      result = new Uint32Array(286 + 30),
	      nResult,
	      rpt,
	      freqs = new Uint8Array(19);
	  j = 0;

	  for (i = 0; i < hlit; i++) {
	    src[j++] = litlenLengths[i];
	  }

	  for (i = 0; i < hdist; i++) {
	    src[j++] = distLengths[i];
	  } // 符号化


	  nResult = 0;

	  for (i = 0, l = src.length; i < l; i += j) {
	    // Run Length Encoding
	    for (j = 1; i + j < l && src[i + j] === src[i]; ++j) {}

	    runLength = j;

	    if (src[i] === 0) {
	      // 0 の繰り返しが 3 回未満ならばそのまま
	      if (runLength < 3) {
	        while (runLength-- > 0) {
	          result[nResult++] = 0;
	          freqs[0]++;
	        }
	      } else {
	        while (runLength > 0) {
	          // 繰り返しは最大 138 までなので切り詰める
	          rpt = runLength < 138 ? runLength : 138;

	          if (rpt > runLength - 3 && rpt < runLength) {
	            rpt = runLength - 3;
	          } // 3-10 回 -> 17


	          if (rpt <= 10) {
	            result[nResult++] = 17;
	            result[nResult++] = rpt - 3;
	            freqs[17]++; // 11-138 回 -> 18
	          } else {
	            result[nResult++] = 18;
	            result[nResult++] = rpt - 11;
	            freqs[18]++;
	          }

	          runLength -= rpt;
	        }
	      }
	    } else {
	      result[nResult++] = src[i];
	      freqs[src[i]]++;
	      runLength--; // 繰り返し回数が3回未満ならばランレングス符号は要らない

	      if (runLength < 3) {
	        while (runLength-- > 0) {
	          result[nResult++] = src[i];
	          freqs[src[i]]++;
	        } // 3 回以上ならばランレングス符号化

	      } else {
	        while (runLength > 0) {
	          // runLengthを 3-6 で分割
	          rpt = runLength < 6 ? runLength : 6;

	          if (rpt > runLength - 3 && rpt < runLength) {
	            rpt = runLength - 3;
	          }

	          result[nResult++] = 16;
	          result[nResult++] = rpt - 3;
	          freqs[16]++;
	          runLength -= rpt;
	        }
	      }
	    }
	  }

	  return {
	    codes: result.subarray(0, nResult),
	    freqs: freqs
	  };
	};
	/**
	 * ハフマン符号の長さを取得する
	 * @param {!(Array.<number>|Uint8Array|Uint32Array)} freqs 出現カウント.
	 * @param {number} limit 符号長の制限.
	 * @return {!(Array.<number>|Uint8Array)} 符号長配列.
	 * @private
	 */


	Zlib.RawDeflate.prototype.getLengths_ = function (freqs, limit) {
	  /** @type {number} */
	  var nSymbols = freqs.length;
	  /** @type {Zlib.Heap} */

	  var heap = new Zlib.Heap(2 * Zlib.RawDeflate.HUFMAX);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var length = new Uint8Array(nSymbols);
	  /** @type {Array} */

	  var nodes;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var values;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var codeLength;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il; // ヒープの構築

	  for (i = 0; i < nSymbols; ++i) {
	    if (freqs[i] > 0) {
	      heap.push(i, freqs[i]);
	    }
	  }

	  nodes = new Array(heap.length / 2);
	  values = new Uint32Array(heap.length / 2); // 非 0 の要素が一つだけだった場合は、そのシンボルに符号長 1 を割り当てて終了

	  if (nodes.length === 1) {
	    length[heap.pop().index] = 1;
	    return length;
	  } // Reverse Package Merge Algorithm による Canonical Huffman Code の符号長決定


	  for (i = 0, il = heap.length / 2; i < il; ++i) {
	    nodes[i] = heap.pop();
	    values[i] = nodes[i].value;
	  }

	  codeLength = this.reversePackageMerge_(values, values.length, limit);

	  for (i = 0, il = nodes.length; i < il; ++i) {
	    length[nodes[i].index] = codeLength[i];
	  }

	  return length;
	};
	/**
	 * Reverse Package Merge Algorithm.
	 * @param {!(Array.<number>|Uint32Array)} freqs sorted probability.
	 * @param {number} symbols number of symbols.
	 * @param {number} limit code length limit.
	 * @return {!(Array.<number>|Uint8Array)} code lengths.
	 */


	Zlib.RawDeflate.prototype.reversePackageMerge_ = function (freqs, symbols, limit) {
	  /** @type {!(Array.<number>|Uint16Array)} */
	  var minimumCost = new Uint16Array(limit);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var flag = new Uint8Array(limit);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var codeLength = new Uint8Array(symbols);
	  /** @type {Array} */

	  var value = new Array(limit);
	  /** @type {Array} */

	  var type = new Array(limit);
	  /** @type {Array.<number>} */

	  var currentPosition = new Array(limit);
	  /** @type {number} */

	  var excess = (1 << limit) - symbols;
	  /** @type {number} */

	  var half = 1 << limit - 1;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var j;
	  /** @type {number} */

	  var t;
	  /** @type {number} */

	  var weight;
	  /** @type {number} */

	  var next;
	  /**
	   * @param {number} j
	   */

	  function takePackage(j) {
	    /** @type {number} */
	    var x = type[j][currentPosition[j]];

	    if (x === symbols) {
	      takePackage(j + 1);
	      takePackage(j + 1);
	    } else {
	      --codeLength[x];
	    }

	    ++currentPosition[j];
	  }

	  minimumCost[limit - 1] = symbols;

	  for (j = 0; j < limit; ++j) {
	    if (excess < half) {
	      flag[j] = 0;
	    } else {
	      flag[j] = 1;
	      excess -= half;
	    }

	    excess <<= 1;
	    minimumCost[limit - 2 - j] = (minimumCost[limit - 1 - j] / 2 | 0) + symbols;
	  }

	  minimumCost[0] = flag[0];
	  value[0] = new Array(minimumCost[0]);
	  type[0] = new Array(minimumCost[0]);

	  for (j = 1; j < limit; ++j) {
	    if (minimumCost[j] > 2 * minimumCost[j - 1] + flag[j]) {
	      minimumCost[j] = 2 * minimumCost[j - 1] + flag[j];
	    }

	    value[j] = new Array(minimumCost[j]);
	    type[j] = new Array(minimumCost[j]);
	  }

	  for (i = 0; i < symbols; ++i) {
	    codeLength[i] = limit;
	  }

	  for (t = 0; t < minimumCost[limit - 1]; ++t) {
	    value[limit - 1][t] = freqs[t];
	    type[limit - 1][t] = t;
	  }

	  for (i = 0; i < limit; ++i) {
	    currentPosition[i] = 0;
	  }

	  if (flag[limit - 1] === 1) {
	    --codeLength[0];
	    ++currentPosition[limit - 1];
	  }

	  for (j = limit - 2; j >= 0; --j) {
	    i = 0;
	    weight = 0;
	    next = currentPosition[j + 1];

	    for (t = 0; t < minimumCost[j]; t++) {
	      weight = value[j + 1][next] + value[j + 1][next + 1];

	      if (weight > freqs[i]) {
	        value[j][t] = weight;
	        type[j][t] = symbols;
	        next += 2;
	      } else {
	        value[j][t] = freqs[i];
	        type[j][t] = i;
	        ++i;
	      }
	    }

	    currentPosition[j] = 0;

	    if (flag[j] === 1) {
	      takePackage(j);
	    }
	  }

	  return codeLength;
	};
	/**
	 * 符号長配列からハフマン符号を取得する
	 * reference: PuTTY Deflate implementation
	 * @param {!(Array.<number>|Uint8Array)} lengths 符号長配列.
	 * @return {!(Array.<number>|Uint16Array)} ハフマン符号配列.
	 * @private
	 */


	Zlib.RawDeflate.prototype.getCodesFromLengths_ = function (lengths) {
	  var codes = new Uint16Array(lengths.length),
	      count = [],
	      startCode = [],
	      code = 0,
	      i,
	      il,
	      j,
	      m; // Count the codes of each length.

	  for (i = 0, il = lengths.length; i < il; i++) {
	    count[lengths[i]] = (count[lengths[i]] | 0) + 1;
	  } // Determine the starting code for each length block.


	  for (i = 1, il = Zlib.RawDeflate.MaxCodeLength; i <= il; i++) {
	    startCode[i] = code;
	    code += count[i] | 0;
	    code <<= 1;
	  } // Determine the code for each symbol. Mirrored, of course.


	  for (i = 0, il = lengths.length; i < il; i++) {
	    code = startCode[lengths[i]];
	    startCode[lengths[i]] += 1;
	    codes[i] = 0;

	    for (j = 0, m = lengths[i]; j < m; j++) {
	      codes[i] = codes[i] << 1 | code & 1;
	      code >>>= 1;
	    }
	  }

	  return codes;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params options.
	 * @constructor
	 */


	Zlib.Unzip = function (input, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.input = input instanceof Array ? new Uint8Array(input) : input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {number} */

	  this.eocdrOffset;
	  /** @type {number} */

	  this.numberOfThisDisk;
	  /** @type {number} */

	  this.startDisk;
	  /** @type {number} */

	  this.totalEntriesThisDisk;
	  /** @type {number} */

	  this.totalEntries;
	  /** @type {number} */

	  this.centralDirectorySize;
	  /** @type {number} */

	  this.centralDirectoryOffset;
	  /** @type {number} */

	  this.commentLength;
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.comment;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  this.fileHeaderList;
	  /** @type {Object.<string, number>} */

	  this.filenameToIndex;
	  /** @type {boolean} */

	  this.verify = opt_params['verify'] || false;
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.password = opt_params['password'];
	};

	Zlib.Unzip.CompressionMethod = Zlib.Zip.CompressionMethod;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Unzip.FileHeaderSignature = Zlib.Zip.FileHeaderSignature;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Unzip.LocalFileHeaderSignature = Zlib.Zip.LocalFileHeaderSignature;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib.Unzip.CentralDirectorySignature = Zlib.Zip.CentralDirectorySignature;
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {number} ip input position.
	 * @constructor
	 */

	Zlib.Unzip.FileHeader = function (input, ip) {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  this.input = input;
	  /** @type {number} */

	  this.offset = ip;
	  /** @type {number} */

	  this.length;
	  /** @type {number} */

	  this.version;
	  /** @type {number} */

	  this.os;
	  /** @type {number} */

	  this.needVersion;
	  /** @type {number} */

	  this.flags;
	  /** @type {number} */

	  this.compression;
	  /** @type {number} */

	  this.time;
	  /** @type {number} */

	  this.date;
	  /** @type {number} */

	  this.crc32;
	  /** @type {number} */

	  this.compressedSize;
	  /** @type {number} */

	  this.plainSize;
	  /** @type {number} */

	  this.fileNameLength;
	  /** @type {number} */

	  this.extraFieldLength;
	  /** @type {number} */

	  this.fileCommentLength;
	  /** @type {number} */

	  this.diskNumberStart;
	  /** @type {number} */

	  this.internalFileAttributes;
	  /** @type {number} */

	  this.externalFileAttributes;
	  /** @type {number} */

	  this.relativeOffset;
	  /** @type {string} */

	  this.filename;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.extraField;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.comment;
	};

	Zlib.Unzip.FileHeader.prototype.parse = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip = this.offset; // central file header signature

	  if (input[ip++] !== Zlib.Unzip.FileHeaderSignature[0] || input[ip++] !== Zlib.Unzip.FileHeaderSignature[1] || input[ip++] !== Zlib.Unzip.FileHeaderSignature[2] || input[ip++] !== Zlib.Unzip.FileHeaderSignature[3]) {
	    throw new Error('invalid file header signature');
	  } // version made by


	  this.version = input[ip++];
	  this.os = input[ip++]; // version needed to extract

	  this.needVersion = input[ip++] | input[ip++] << 8; // general purpose bit flag

	  this.flags = input[ip++] | input[ip++] << 8; // compression method

	  this.compression = input[ip++] | input[ip++] << 8; // last mod file time

	  this.time = input[ip++] | input[ip++] << 8; //last mod file date

	  this.date = input[ip++] | input[ip++] << 8; // crc-32

	  this.crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // compressed size

	  this.compressedSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // uncompressed size

	  this.plainSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name length

	  this.fileNameLength = input[ip++] | input[ip++] << 8; // extra field length

	  this.extraFieldLength = input[ip++] | input[ip++] << 8; // file comment length

	  this.fileCommentLength = input[ip++] | input[ip++] << 8; // disk number start

	  this.diskNumberStart = input[ip++] | input[ip++] << 8; // internal file attributes

	  this.internalFileAttributes = input[ip++] | input[ip++] << 8; // external file attributes

	  this.externalFileAttributes = input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24; // relative offset of local header

	  this.relativeOffset = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name

	  this.filename = String.fromCharCode.apply(null, input.subarray(ip, ip += this.fileNameLength)); // extra field

	  this.extraField = input.subarray(ip, ip += this.extraFieldLength); // file comment

	  this.comment = input.subarray(ip, ip + this.fileCommentLength);
	  this.length = ip - this.offset;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {number} ip input position.
	 * @constructor
	 */


	Zlib.Unzip.LocalFileHeader = function (input, ip) {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  this.input = input;
	  /** @type {number} */

	  this.offset = ip;
	  /** @type {number} */

	  this.length;
	  /** @type {number} */

	  this.needVersion;
	  /** @type {number} */

	  this.flags;
	  /** @type {number} */

	  this.compression;
	  /** @type {number} */

	  this.time;
	  /** @type {number} */

	  this.date;
	  /** @type {number} */

	  this.crc32;
	  /** @type {number} */

	  this.compressedSize;
	  /** @type {number} */

	  this.plainSize;
	  /** @type {number} */

	  this.fileNameLength;
	  /** @type {number} */

	  this.extraFieldLength;
	  /** @type {string} */

	  this.filename;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.extraField;
	};

	Zlib.Unzip.LocalFileHeader.Flags = Zlib.Zip.Flags;

	Zlib.Unzip.LocalFileHeader.prototype.parse = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip = this.offset; // local file header signature

	  if (input[ip++] !== Zlib.Unzip.LocalFileHeaderSignature[0] || input[ip++] !== Zlib.Unzip.LocalFileHeaderSignature[1] || input[ip++] !== Zlib.Unzip.LocalFileHeaderSignature[2] || input[ip++] !== Zlib.Unzip.LocalFileHeaderSignature[3]) {
	    throw new Error('invalid local file header signature');
	  } // version needed to extract


	  this.needVersion = input[ip++] | input[ip++] << 8; // general purpose bit flag

	  this.flags = input[ip++] | input[ip++] << 8; // compression method

	  this.compression = input[ip++] | input[ip++] << 8; // last mod file time

	  this.time = input[ip++] | input[ip++] << 8; //last mod file date

	  this.date = input[ip++] | input[ip++] << 8; // crc-32

	  this.crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // compressed size

	  this.compressedSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // uncompressed size

	  this.plainSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name length

	  this.fileNameLength = input[ip++] | input[ip++] << 8; // extra field length

	  this.extraFieldLength = input[ip++] | input[ip++] << 8; // file name

	  this.filename = String.fromCharCode.apply(null, input.subarray(ip, ip += this.fileNameLength)); // extra field

	  this.extraField = input.subarray(ip, ip += this.extraFieldLength);
	  this.length = ip - this.offset;
	};

	Zlib.Unzip.prototype.searchEndOfCentralDirectoryRecord = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip;

	  for (ip = input.length - 12; ip > 0; --ip) {
	    if (input[ip] === Zlib.Unzip.CentralDirectorySignature[0] && input[ip + 1] === Zlib.Unzip.CentralDirectorySignature[1] && input[ip + 2] === Zlib.Unzip.CentralDirectorySignature[2] && input[ip + 3] === Zlib.Unzip.CentralDirectorySignature[3]) {
	      this.eocdrOffset = ip;
	      return;
	    }
	  }

	  throw new Error('End of Central Directory Record not found');
	};

	Zlib.Unzip.prototype.parseEndOfCentralDirectoryRecord = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip;

	  if (!this.eocdrOffset) {
	    this.searchEndOfCentralDirectoryRecord();
	  }

	  ip = this.eocdrOffset; // signature

	  if (input[ip++] !== Zlib.Unzip.CentralDirectorySignature[0] || input[ip++] !== Zlib.Unzip.CentralDirectorySignature[1] || input[ip++] !== Zlib.Unzip.CentralDirectorySignature[2] || input[ip++] !== Zlib.Unzip.CentralDirectorySignature[3]) {
	    throw new Error('invalid signature');
	  } // number of this disk


	  this.numberOfThisDisk = input[ip++] | input[ip++] << 8; // number of the disk with the start of the central directory

	  this.startDisk = input[ip++] | input[ip++] << 8; // total number of entries in the central directory on this disk

	  this.totalEntriesThisDisk = input[ip++] | input[ip++] << 8; // total number of entries in the central directory

	  this.totalEntries = input[ip++] | input[ip++] << 8; // size of the central directory

	  this.centralDirectorySize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // offset of start of central directory with respect to the starting disk number

	  this.centralDirectoryOffset = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // .ZIP file comment length

	  this.commentLength = input[ip++] | input[ip++] << 8; // .ZIP file comment

	  this.comment = input.subarray(ip, ip + this.commentLength);
	};

	Zlib.Unzip.prototype.parseFileHeader = function () {
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */
	  var filelist = [];
	  /** @type {Object.<string, number>} */

	  var filetable = {};
	  /** @type {number} */

	  var ip;
	  /** @type {Zlib.Unzip.FileHeader} */

	  var fileHeader;
	  /*: @type {number} */

	  var i;
	  /*: @type {number} */

	  var il;

	  if (this.fileHeaderList) {
	    return;
	  }

	  if (this.centralDirectoryOffset === void 0) {
	    this.parseEndOfCentralDirectoryRecord();
	  }

	  ip = this.centralDirectoryOffset;

	  for (i = 0, il = this.totalEntries; i < il; ++i) {
	    fileHeader = new Zlib.Unzip.FileHeader(this.input, ip);
	    fileHeader.parse();
	    ip += fileHeader.length;
	    filelist[i] = fileHeader;
	    filetable[fileHeader.filename] = i;
	  }

	  if (this.centralDirectorySize < ip - this.centralDirectoryOffset) {
	    throw new Error('invalid file header size');
	  }

	  this.fileHeaderList = filelist;
	  this.filenameToIndex = filetable;
	};
	/**
	 * @param {number} index file header index.
	 * @param {Object=} opt_params
	 * @return {!(Array.<number>|Uint8Array)} file data.
	 */


	Zlib.Unzip.prototype.getFileData = function (index, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var input = this.input;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  var fileHeaderList = this.fileHeaderList;
	  /** @type {Zlib.Unzip.LocalFileHeader} */

	  var localFileHeader;
	  /** @type {number} */

	  var offset;
	  /** @type {number} */

	  var length;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var buffer;
	  /** @type {number} */

	  var crc32;
	  /** @type {Array.<number>|Uint32Array|Object} */

	  var key;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;

	  if (!fileHeaderList) {
	    this.parseFileHeader();
	  }

	  if (fileHeaderList[index] === void 0) {
	    throw new Error('wrong index');
	  }

	  offset = fileHeaderList[index].relativeOffset;
	  localFileHeader = new Zlib.Unzip.LocalFileHeader(this.input, offset);
	  localFileHeader.parse();
	  offset += localFileHeader.length;
	  length = localFileHeader.compressedSize; // decryption

	  if ((localFileHeader.flags & Zlib.Unzip.LocalFileHeader.Flags.ENCRYPT) !== 0) {
	    if (!(opt_params['password'] || this.password)) {
	      throw new Error('please set password');
	    }

	    key = this.createDecryptionKey(opt_params['password'] || this.password); // encryption header

	    for (i = offset, il = offset + 12; i < il; ++i) {
	      this.decode(key, input[i]);
	    }

	    offset += 12;
	    length -= 12; // decryption

	    for (i = offset, il = offset + length; i < il; ++i) {
	      input[i] = this.decode(key, input[i]);
	    }
	  }

	  switch (localFileHeader.compression) {
	    case Zlib.Unzip.CompressionMethod.STORE:
	      buffer = this.input.subarray(offset, offset + length);
	      break;

	    case Zlib.Unzip.CompressionMethod.DEFLATE:
	      buffer = new Zlib.RawInflate(this.input, {
	        'index': offset,
	        'bufferSize': localFileHeader.plainSize
	      }).decompress();
	      break;

	    default:
	      throw new Error('unknown compression type');
	  }

	  if (this.verify) {
	    crc32 = Zlib.CRC32.calc(buffer);

	    if (localFileHeader.crc32 !== crc32) {
	      throw new Error('wrong crc: file=0x' + localFileHeader.crc32.toString(16) + ', data=0x' + crc32.toString(16));
	    }
	  }

	  return buffer;
	};
	/**
	 * @return {Array.<string>}
	 */


	Zlib.Unzip.prototype.getFilenames = function () {
	  /** @type {Array.<string>} */
	  var filenameList = [];
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  var fileHeaderList;

	  if (!this.fileHeaderList) {
	    this.parseFileHeader();
	  }

	  fileHeaderList = this.fileHeaderList;

	  for (i = 0, il = fileHeaderList.length; i < il; ++i) {
	    filenameList[i] = fileHeaderList[i].filename;
	  }

	  return filenameList;
	};
	/**
	 * @param {string} filename extract filename.
	 * @param {Object=} opt_params
	 * @return {!(Array.<number>|Uint8Array)} decompressed data.
	 */


	Zlib.Unzip.prototype.decompress = function (filename, opt_params) {
	  /** @type {number} */
	  var index;

	  if (!this.filenameToIndex) {
	    this.parseFileHeader();
	  }

	  index = this.filenameToIndex[filename];

	  if (index === void 0) {
	    throw new Error(filename + ' not found');
	  }

	  return this.getFileData(index, opt_params);
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 */


	Zlib.Unzip.prototype.setPassword = function (password) {
	  this.password = password;
	};
	/**
	 * @param {(Array.<number>|Uint32Array|Object)} key
	 * @param {number} n
	 * @return {number}
	 */


	Zlib.Unzip.prototype.decode = function (key, n) {
	  n ^= this.getByte(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key);
	  this.updateKeys(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key, n);
	  return n;
	}; // common method


	Zlib.Unzip.prototype.updateKeys = Zlib.Zip.prototype.updateKeys;
	Zlib.Unzip.prototype.createDecryptionKey = Zlib.Zip.prototype.createEncryptionKey;
	Zlib.Unzip.prototype.getByte = Zlib.Zip.prototype.getByte;
	/**
	 * @fileoverview 雑多な関数群をまとめたモジュール実装.
	 */

	/**
	 * Byte String から Byte Array に変換.
	 * @param {!string} str byte string.
	 * @return {!Array.<number>} byte array.
	 */

	Zlib.Util.stringToByteArray = function (str) {
	  /** @type {!Array.<(string|number)>} */
	  var tmp = str.split('');
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;

	  for (i = 0, il = tmp.length; i < il; i++) {
	    tmp[i] = (tmp[i].charCodeAt(0) & 0xff) >>> 0;
	  }

	  return tmp;
	};
	/**
	 * @fileoverview Adler32 checksum 実装.
	 */

	/**
	 * Adler32 ハッシュ値の作成
	 * @param {!(Array|Uint8Array|string)} array 算出に使用する byte array.
	 * @return {number} Adler32 ハッシュ値.
	 */


	Zlib.Adler32 = function (array) {
	  if (typeof array === 'string') {
	    array = Zlib.Util.stringToByteArray(array);
	  }

	  return Zlib.Adler32.update(1, array);
	};
	/**
	 * Adler32 ハッシュ値の更新
	 * @param {number} adler 現在のハッシュ値.
	 * @param {!(Array|Uint8Array)} array 更新に使用する byte array.
	 * @return {number} Adler32 ハッシュ値.
	 */


	Zlib.Adler32.update = function (adler, array) {
	  /** @type {number} */
	  var s1 = adler & 0xffff;
	  /** @type {number} */

	  var s2 = adler >>> 16 & 0xffff;
	  /** @type {number} array length */

	  var len = array.length;
	  /** @type {number} loop length (don't overflow) */

	  var tlen;
	  /** @type {number} array index */

	  var i = 0;

	  while (len > 0) {
	    tlen = len > Zlib.Adler32.OptimizationParameter ? Zlib.Adler32.OptimizationParameter : len;
	    len -= tlen;

	    do {
	      s1 += array[i++];
	      s2 += s1;
	    } while (--tlen);

	    s1 %= 65521;
	    s2 %= 65521;
	  }

	  return (s2 << 16 | s1) >>> 0;
	};
	/**
	 * Adler32 最適化パラメータ
	 * 現状では 1024 程度が最適.
	 * @see http://jsperf.com/adler-32-simple-vs-optimized/3
	 * @define {number}
	 */


	Zlib.Adler32.OptimizationParameter = 1024;
	/**
	 * ビットストリーム
	 * @constructor
	 * @param {!(Array|Uint8Array)=} buffer output buffer.
	 * @param {number=} bufferPosition start buffer pointer.
	 */

	Zlib.BitStream = function (buffer, bufferPosition) {
	  /** @type {number} buffer index. */
	  this.index = typeof bufferPosition === 'number' ? bufferPosition : 0;
	  /** @type {number} bit index. */

	  this.bitindex = 0;
	  /** @type {!(Array|Uint8Array)} bit-stream output buffer. */

	  this.buffer = buffer instanceof Uint8Array ? buffer : new Uint8Array(Zlib.BitStream.DefaultBlockSize); // 入力された index が足りなかったら拡張するが、倍にしてもダメなら不正とする

	  if (this.buffer.length * 2 <= this.index) {
	    throw new Error("invalid index");
	  } else if (this.buffer.length <= this.index) {
	    this.expandBuffer();
	  }
	};
	/**
	 * デフォルトブロックサイズ.
	 * @const
	 * @type {number}
	 */


	Zlib.BitStream.DefaultBlockSize = 0x8000;
	/**
	 * expand buffer.
	 * @return {!(Array|Uint8Array)} new buffer.
	 */

	Zlib.BitStream.prototype.expandBuffer = function () {
	  /** @type {!(Array|Uint8Array)} old buffer. */
	  var oldbuf = this.buffer;
	  /** @type {number} loop limiter. */

	  var il = oldbuf.length;
	  /** @type {!(Array|Uint8Array)} new buffer. */

	  var buffer = new Uint8Array(il << 1); // copy buffer

	  {
	    buffer.set(oldbuf);
	  }
	  return this.buffer = buffer;
	};
	/**
	 * 数値をビットで指定した数だけ書き込む.
	 * @param {number} number 書き込む数値.
	 * @param {number} n 書き込むビット数.
	 * @param {boolean=} reverse 逆順に書き込むならば true.
	 */


	Zlib.BitStream.prototype.writeBits = function (number, n, reverse) {
	  var buffer = this.buffer;
	  var index = this.index;
	  var bitindex = this.bitindex;
	  /** @type {number} current octet. */

	  var current = buffer[index];
	  /** @type {number} loop counter. */

	  var i;
	  /**
	   * 32-bit 整数のビット順を逆にする
	   * @param {number} n 32-bit integer.
	   * @return {number} reversed 32-bit integer.
	   * @private
	   */

	  function rev32_(n) {
	    return Zlib.BitStream.ReverseTable[n & 0xFF] << 24 | Zlib.BitStream.ReverseTable[n >>> 8 & 0xFF] << 16 | Zlib.BitStream.ReverseTable[n >>> 16 & 0xFF] << 8 | Zlib.BitStream.ReverseTable[n >>> 24 & 0xFF];
	  }

	  if (reverse && n > 1) {
	    number = n > 8 ? rev32_(number) >> 32 - n : Zlib.BitStream.ReverseTable[number] >> 8 - n;
	  } // Byte 境界を超えないとき


	  if (n + bitindex < 8) {
	    current = current << n | number;
	    bitindex += n; // Byte 境界を超えるとき
	  } else {
	    for (i = 0; i < n; ++i) {
	      current = current << 1 | number >> n - i - 1 & 1; // next byte

	      if (++bitindex === 8) {
	        bitindex = 0;
	        buffer[index++] = Zlib.BitStream.ReverseTable[current];
	        current = 0; // expand

	        if (index === buffer.length) {
	          buffer = this.expandBuffer();
	        }
	      }
	    }
	  }

	  buffer[index] = current;
	  this.buffer = buffer;
	  this.bitindex = bitindex;
	  this.index = index;
	};
	/**
	 * ストリームの終端処理を行う
	 * @return {!(Array|Uint8Array)} 終端処理後のバッファを byte array で返す.
	 */


	Zlib.BitStream.prototype.finish = function () {
	  var buffer = this.buffer;
	  var index = this.index;
	  /** @type {!(Array|Uint8Array)} output buffer. */

	  var output; // bitindex が 0 の時は余分に index が進んでいる状態

	  if (this.bitindex > 0) {
	    buffer[index] <<= 8 - this.bitindex;
	    buffer[index] = Zlib.BitStream.ReverseTable[buffer[index]];
	    index++;
	  } // array truncation


	  {
	    output = buffer.subarray(0, index);
	  }
	  return output;
	};
	/**
	 * 0-255 のビット順を反転したテーブル
	 * @const
	 * @type {!(Uint8Array|Array.<number>)}
	 */


	Zlib.BitStream.ReverseTable = function (table) {
	  return table;
	}(function () {
	  /** @type {!(Array|Uint8Array)} reverse table. */
	  var table = new Uint8Array(256);
	  /** @type {number} loop counter. */

	  var i; // generate

	  for (i = 0; i < 256; ++i) {
	    table[i] = function (n) {
	      var r = n;
	      var s = 7;

	      for (n >>>= 1; n; n >>>= 1) {
	        r <<= 1;
	        r |= n & 1;
	        --s;
	      }

	      return (r << s & 0xff) >>> 0;
	    }(i);
	  }

	  return table;
	}());
	/**
	 * CRC32 ハッシュ値を取得
	 * @param {!(Array.<number>|Uint8Array)} data data byte array.
	 * @param {number=} pos data position.
	 * @param {number=} length data length.
	 * @return {number} CRC32.
	 */


	Zlib.CRC32.calc = function (data, pos, length) {
	  return Zlib.CRC32.update(data, 0, pos, length);
	};
	/**
	 * CRC32ハッシュ値を更新
	 * @param {!(Array.<number>|Uint8Array)} data data byte array.
	 * @param {number} crc CRC32.
	 * @param {number=} pos data position.
	 * @param {number=} length data length.
	 * @return {number} CRC32.
	 */


	Zlib.CRC32.update = function (data, crc, pos, length) {
	  var table = Zlib.CRC32.Table;
	  var i = typeof pos === 'number' ? pos : pos = 0;
	  var il = typeof length === 'number' ? length : data.length;
	  crc ^= 0xffffffff; // loop unrolling for performance

	  for (i = il & 7; i--; ++pos) {
	    crc = crc >>> 8 ^ table[(crc ^ data[pos]) & 0xff];
	  }

	  for (i = il >> 3; i--; pos += 8) {
	    crc = crc >>> 8 ^ table[(crc ^ data[pos]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 1]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 2]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 3]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 4]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 5]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 6]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 7]) & 0xff];
	  }

	  return (crc ^ 0xffffffff) >>> 0;
	};
	/**
	 * @param {number} num
	 * @param {number} crc
	 * @returns {number}
	 */


	Zlib.CRC32.single = function (num, crc) {
	  return (Zlib.CRC32.Table[(num ^ crc) & 0xff] ^ num >>> 8) >>> 0;
	};
	/**
	 * @type {Array.<number>}
	 * @const
	 * @private
	 */


	Zlib.CRC32.Table_ = [0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91, 0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7, 0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b, 0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59, 0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924, 0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433, 0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01, 0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65, 0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f, 0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683, 0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1, 0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5, 0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b, 0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236, 0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d, 0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713, 0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777, 0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45, 0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9, 0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d];
	/**
	 * @type {!(Array.<number>|Uint32Array)} CRC-32 Table.
	 * @const
	 */

	Zlib.CRC32.Table = new Uint32Array(Zlib.CRC32.Table_);
	/**
	 * @fileoverview Deflate (RFC1951) 実装.
	 * Deflateアルゴリズム本体は Zlib.RawDeflate で実装されている.
	 */

	/**
	 * Zlib Deflate
	 * @constructor
	 * @param {!(Array|Uint8Array)} input 符号化する対象の byte array.
	 * @param {Object=} opt_params option parameters.
	 */

	Zlib.Deflate = function (input, opt_params) {
	  /** @type {!(Array|Uint8Array)} */
	  this.input = input;
	  /** @type {!(Array|Uint8Array)} */

	  this.output = new Uint8Array(Zlib.Deflate.DefaultBufferSize);
	  /** @type {Zlib.Deflate.CompressionType} */

	  this.compressionType = Zlib.Deflate.CompressionType.DYNAMIC;
	  /** @type {Zlib.RawDeflate} */

	  this.rawDeflate;
	  /** @type {Object} */

	  var rawDeflateOption = {};
	  /** @type {string} */

	  var prop; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (typeof opt_params['compressionType'] === 'number') {
	      this.compressionType = opt_params['compressionType'];
	    }
	  } // copy options


	  for (prop in opt_params) {
	    rawDeflateOption[prop] = opt_params[prop];
	  } // set raw-deflate output buffer


	  rawDeflateOption['outputBuffer'] = this.output;
	  this.rawDeflate = new Zlib.RawDeflate(this.input, rawDeflateOption);
	};
	/**
	 * @const
	 * @type {number} デフォルトバッファサイズ.
	 */


	Zlib.Deflate.DefaultBufferSize = 0x8000;
	/**
	 * @enum {number}
	 */

	Zlib.Deflate.CompressionType = Zlib.RawDeflate.CompressionType;
	/**
	 * 直接圧縮に掛ける.
	 * @param {!(Array|Uint8Array)} input target buffer.
	 * @param {Object=} opt_params option parameters.
	 * @return {!(Array|Uint8Array)} compressed data byte array.
	 */

	Zlib.Deflate.compress = function (input, opt_params) {
	  return new Zlib.Deflate(input, opt_params).compress();
	};
	/**
	 * Deflate Compression.
	 * @return {!(Array|Uint8Array)} compressed data byte array.
	 */


	Zlib.Deflate.prototype.compress = function () {
	  /** @type {Zlib.CompressionMethod} */
	  var cm;
	  /** @type {number} */

	  var cinfo;
	  /** @type {number} */

	  var cmf;
	  /** @type {number} */

	  var flg;
	  /** @type {number} */

	  var fcheck;
	  /** @type {number} */

	  var fdict;
	  /** @type {number} */

	  var flevel;
	  /** @type {number} */

	  var adler;
	  /** @type {!(Array|Uint8Array)} */

	  var output;
	  /** @type {number} */

	  var pos = 0;
	  output = this.output; // Compression Method and Flags

	  cm = Zlib.CompressionMethod.DEFLATE;

	  switch (cm) {
	    case Zlib.CompressionMethod.DEFLATE:
	      cinfo = Math.LOG2E * Math.log(Zlib.RawDeflate.WindowSize) - 8;
	      break;

	    default:
	      throw new Error('invalid compression method');
	  }

	  cmf = cinfo << 4 | cm;
	  output[pos++] = cmf; // Flags

	  fdict = 0;

	  switch (cm) {
	    case Zlib.CompressionMethod.DEFLATE:
	      switch (this.compressionType) {
	        case Zlib.Deflate.CompressionType.NONE:
	          flevel = 0;
	          break;

	        case Zlib.Deflate.CompressionType.FIXED:
	          flevel = 1;
	          break;

	        case Zlib.Deflate.CompressionType.DYNAMIC:
	          flevel = 2;
	          break;

	        default:
	          throw new Error('unsupported compression type');
	      }

	      break;

	    default:
	      throw new Error('invalid compression method');
	  }

	  flg = flevel << 6 | fdict << 5;
	  fcheck = 31 - (cmf * 256 + flg) % 31;
	  flg |= fcheck;
	  output[pos++] = flg; // Adler-32 checksum

	  adler = Zlib.Adler32(this.input);
	  this.rawDeflate.op = pos;
	  output = this.rawDeflate.compress();
	  pos = output.length;
	  {
	    // subarray 分を元にもどす
	    output = new Uint8Array(output.buffer); // expand buffer

	    if (output.length <= pos + 4) {
	      this.output = new Uint8Array(output.length + 4);
	      this.output.set(output);
	      output = this.output;
	    }

	    output = output.subarray(0, pos + 4);
	  } // adler32

	  output[pos++] = adler >> 24 & 0xff;
	  output[pos++] = adler >> 16 & 0xff;
	  output[pos++] = adler >> 8 & 0xff;
	  output[pos++] = adler & 0xff;
	  return output;
	};

	if (typeof process === 'object' && typeof window === 'undefined') {
	  global.atob = function (str) {
	    return Buffer.from(str, 'base64').toString('binary');
	  };
	}
	/**
	 * Make the target element movable by clicking and dragging on the handle.  This is not a general purprose function,
	 * it makes several options specific to igv dialogs, the primary one being that the
	 * target is absolutely positioned in pixel coordinates

	 */


	let dragData; // Its assumed we are only dragging one element at a time.

	function makeDraggable(target, handle) {
	  handle.addEventListener('mousedown', dragStart.bind(target));
	}

	function dragStart(event) {
	  event.stopPropagation();
	  event.preventDefault();
	  const pageCoords = offset(this);
	  const dragFunction = drag.bind(this);
	  const dragEndFunction = dragEnd.bind(this);
	  const computedStyle = getComputedStyle(this);
	  const top = parseInt(computedStyle.top.replace("px", ""));
	  const left = parseInt(computedStyle.left.replace("px", ""));
	  dragData = {
	    dragFunction: dragFunction,
	    dragEndFunction: dragEndFunction,
	    screenX: event.screenX,
	    screenY: event.screenY,
	    top: top,
	    left: left
	  };
	  document.addEventListener('mousemove', dragFunction);
	  document.addEventListener('mouseup', dragEndFunction);
	  document.addEventListener('mouseleave', dragEndFunction);
	  document.addEventListener('mouseexit', dragEndFunction);
	}

	function drag(event) {
	  if (!dragData) {
	    return;
	  }

	  event.stopPropagation();
	  event.preventDefault();
	  const dx = event.screenX - dragData.screenX;
	  const dy = event.screenY - dragData.screenY;
	  this.style.left = `${dragData.left + dx}px`;
	  this.style.top = `${dragData.top + dy}px`;
	}

	function dragEnd(event) {
	  if (!dragData) {
	    return;
	  }

	  event.stopPropagation();
	  event.preventDefault();
	  const dragFunction = dragData.dragFunction;
	  const dragEndFunction = dragData.dragEndFunction;
	  document.removeEventListener('mousemove', dragFunction);
	  document.removeEventListener('mouseup', dragEndFunction);
	  document.removeEventListener('mouseleave', dragEndFunction);
	  document.removeEventListener('mouseexit', dragEndFunction);
	  dragData = undefined;
	}

	const appleCrayonPalette = {
	  licorice: "#000000",
	  lead: "#1e1e1e",
	  tungsten: "#3a3a3a",
	  iron: "#545453",
	  steel: "#6e6e6e",
	  tin: "#878687",
	  nickel: "#888787",
	  aluminum: "#a09fa0",
	  magnesium: "#b8b8b8",
	  silver: "#d0d0d0",
	  mercury: "#e8e8e8",
	  snow: "#ffffff",
	  //
	  cayenne: "#891100",
	  mocha: "#894800",
	  aspargus: "#888501",
	  fern: "#458401",
	  clover: "#028401",
	  moss: "#018448",
	  teal: "#008688",
	  ocean: "#004a88",
	  midnight: "#001888",
	  eggplant: "#491a88",
	  plum: "#891e88",
	  maroon: "#891648",
	  //
	  maraschino: "#ff2101",
	  tangerine: "#ff8802",
	  lemon: "#fffa03",
	  lime: "#83f902",
	  spring: "#05f802",
	  seam_foam: "#03f987",
	  turquoise: "#00fdff",
	  aqua: "#008cff",
	  blueberry: "#002eff",
	  grape: "#8931ff",
	  magenta: "#ff39ff",
	  strawberry: "#ff2987",
	  //
	  salmon: "#ff726e",
	  cantaloupe: "#ffce6e",
	  banana: "#fffb6d",
	  honeydew: "#cefa6e",
	  flora: "#68f96e",
	  spindrift: "#68fbd0",
	  ice: "#68fdff",
	  sky: "#6acfff",
	  orchid: "#6e76ff",
	  lavender: "#d278ff",
	  bubblegum: "#ff7aff",
	  carnation: "#ff7fd3"
	};
	const httpMessages = {
	  "401": "Access unauthorized",
	  "403": "Access forbidden",
	  "404": "Not found"
	};

	class AlertDialog {
	  constructor(parent) {
	    // container
	    this.container = div({
	      class: "igv-ui-alert-dialog-container"
	    });
	    parent.appendChild(this.container);
	    this.container.setAttribute('tabIndex', '-1'); // header

	    const header = div();
	    this.container.appendChild(header);
	    const error = div();
	    header.appendChild(error);
	    error.textContent = "ERROR"; // body container

	    let bodyContainer = div({
	      id: 'igv-ui-alert-dialog-body'
	    });
	    this.container.appendChild(bodyContainer); // body copy

	    this.body = div({
	      id: 'igv-ui-alert-dialog-body-copy'
	    });
	    bodyContainer.appendChild(this.body); // ok container

	    let ok_container = div();
	    this.container.appendChild(ok_container); // ok

	    this.ok = div();
	    ok_container.appendChild(this.ok);
	    this.ok.textContent = 'OK';

	    const okHandler = () => {
	      if (typeof this.callback === 'function') {
	        this.callback("OK");
	        this.callback = undefined;
	      }

	      this.body.innerHTML = '';
	      hide(this.container);
	    };

	    this.ok.addEventListener('click', event => {
	      event.stopPropagation();
	      okHandler();
	    });
	    this.container.addEventListener('keypress', event => {
	      event.stopPropagation();

	      if ('Enter' === event.key) {
	        okHandler();
	      }
	    });
	    makeDraggable(this.container, header);
	    hide(this.container);
	  }

	  present(alert, callback) {
	    let string = alert.message || alert;

	    if (httpMessages.hasOwnProperty(string)) {
	      string = httpMessages[string];
	    }

	    this.body.innerHTML = string;
	    this.callback = callback;
	    show(this.container);
	    this.container.focus();
	  }

	} // The global Alert dialog


	let alertDialog;
	const Alert = {
	  init(root) {
	    if (!alertDialog) {
	      alertDialog = new AlertDialog(root);
	    }
	  },

	  presentAlert: function (alert, callback) {
	    alertDialog.present(alert, callback);
	  }
	};

	class InputDialog {
	  constructor(parent) {
	    this.parent = parent; // dialog container

	    this.container = div({
	      class: 'igv-ui-generic-dialog-container'
	    });
	    parent.appendChild(this.container); // const { x, y, width, height } = this.container.getBoundingClientRect();
	    // console.log(`InputDialog - x ${ x } y ${ y } width ${ width } height ${ height }`)
	    // dialog header

	    const header = div({
	      class: 'igv-ui-generic-dialog-header'
	    });
	    this.container.appendChild(header); // dialog label

	    this.label = div({
	      class: 'igv-ui-generic-dialog-one-liner'
	    });
	    this.container.appendChild(this.label);
	    this.label.text = 'Unlabeled'; // input container

	    this.input_container = div({
	      class: 'igv-ui-generic-dialog-input'
	    });
	    this.container.appendChild(this.input_container); //

	    this.input = document.createElement("input");
	    this.input_container.appendChild(this.input); // ok | cancel

	    const buttons = div({
	      class: 'igv-ui-generic-dialog-ok-cancel'
	    });
	    this.container.appendChild(buttons); // ok

	    this.ok = div();
	    buttons.appendChild(this.ok);
	    this.ok.textContent = 'OK'; // cancel

	    this.cancel = div();
	    buttons.appendChild(this.cancel);
	    this.cancel.textContent = 'Cancel';
	    hide(this.container);
	    this.input.addEventListener('keyup', e => {
	      if (13 === e.keyCode) {
	        if (typeof this.callback === 'function') {
	          this.callback(this.input.value);
	          this.callback = undefined;
	        }

	        this.input.value = undefined;
	        hide(this.container);
	      }
	    });
	    this.ok.addEventListener('click', () => {
	      if (typeof this.callback === 'function') {
	        this.callback(this.input.value);
	        this.callback = undefined;
	      }

	      this.input.value = undefined;
	      hide(this.container);
	    });

	    const cancel = () => {
	      this.input.value = '';
	      hide(this.container);
	    };

	    this.cancel.addEventListener('click', cancel);
	    attachDialogCloseHandlerWithParent(header, cancel);
	    makeDraggable(this.container, header);
	  }

	  present(options, e) {
	    this.label.textContent = options.label;
	    this.input.value = options.value;
	    this.callback = options.callback || options.click;
	    show(this.container);
	    const {
	      x,
	      y
	    } = pageCoordinates(e);
	    this.clampLocation(x, y);
	  }

	  clampLocation(pageX, pageY) {
	    const {
	      width: w,
	      height: h
	    } = this.container.getBoundingClientRect();
	    const {
	      x: px,
	      y: py,
	      width: pw,
	      height: ph
	    } = this.parent.getBoundingClientRect();
	    const y = Math.min(Math.max(pageY, py), py + ph - h);
	    const x = Math.min(Math.max(pageX, px), px + pw - w);
	    this.container.style.left = `${x}px`;
	    this.container.style.top = `${y}px`;
	  }

	}
	/*
	 * The MIT License (MIT)
	 *
	 * Copyright (c) 2014 Broad Institute
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 */


	class GenericContainer {
	  constructor({
	    parent,
	    top,
	    left,
	    width,
	    height,
	    border,
	    closeHandler
	  }) {
	    let container = div({
	      class: 'igv-ui-generic-container'
	    });
	    parent.appendChild(container);
	    hide(container);
	    this.container = container;

	    if (top !== undefined) {
	      this.container.style.width = top + "px";
	    }

	    if (left !== undefined) {
	      this.container.style.width = left + "px";
	    }

	    if (width !== undefined) {
	      this.container.style.width = width + "px";
	    }

	    if (height !== undefined) {
	      this.container.style.height = height + "px";
	    }

	    if (border) {
	      this.container.style.border = border;
	    } //
	    // let bbox = parent.getBoundingClientRect();
	    // this.origin = {x: bbox.x, y: bbox.y};
	    // this.container.offset({left: this.origin.x, top: this.origin.y});
	    // header


	    const header = div();
	    this.container.appendChild(header); // close button

	    attachDialogCloseHandlerWithParent(header, e => {
	      hide(this.container);

	      if (typeof closeHandler === "function") {
	        closeHandler(e);
	      }
	    });
	    makeDraggable(this.container, header);
	  }

	  show() {
	    show(this.container);
	  }

	  hide() {
	    hide(this.container);
	  }

	  dispose() {
	    if (this.container.parent) {
	      this.container.parent.removeChild(this.container);
	    }
	  }

	}

	class ColorPicker extends GenericContainer {
	  constructor({
	    parent,
	    top,
	    left,
	    width,
	    height,
	    defaultColors,
	    colorHandler
	  }) {
	    super({
	      parent,
	      top,
	      left,
	      width,
	      height,
	      border: '1px solid gray'
	    });
	    createColorSwatchSelector(this.container, colorHandler, defaultColors);
	  }

	}

	const createColorSwatchSelector = (container, colorHandler, defaultColors) => {
	  const hexColorStrings = Object.values(appleCrayonPalette);

	  for (let hexColorString of hexColorStrings) {
	    const swatch = div({
	      class: 'igv-ui-color-swatch'
	    });
	    container.appendChild(swatch);
	    decorateSwatch(swatch, hexColorString, colorHandler);
	  }

	  if (defaultColors) {
	    for (let hexColorString of defaultColors) {
	      const swatch = div({
	        class: 'igv-ui-color-swatch'
	      });
	      container.appendChild(swatch);
	      decorateSwatch(swatch, hexColorString, colorHandler);
	    }
	  }
	};

	const decorateSwatch = (swatch, hexColorString, colorHandler) => {
	  swatch.style.backgroundColor = hexColorString;

	  swatch.onmouseenter = () => swatch.style.borderColor = hexColorString;

	  swatch.onmouseenter = () => swatch.style.borderColor = 'white';

	  swatch.addEventListener('click', event => {
	    event.stopPropagation();
	    colorHandler(hexColorString);
	  });
	  swatch.addEventListener('touchend', event => {
	    event.stopPropagation();
	    colorHandler(hexColorString);
	  });
	};
	/*
	 * The MIT License (MIT)
	 *
	 * Copyright (c) 2014 Broad Institute
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 */


	class Popover {
	  constructor(parent) {
	    this.parent = parent; // popover

	    this.popover = div({
	      class: "igv-ui-popover"
	    });
	    parent.appendChild(this.popover); // header

	    const popoverHeader = div();
	    this.popover.appendChild(popoverHeader);
	    attachDialogCloseHandlerWithParent(popoverHeader, () => this.hide());
	    makeDraggable(this.popover, popoverHeader); // content

	    this.popoverContent = div();
	    this.popover.appendChild(this.popoverContent);
	    this.popover.style.display = 'none';
	  }

	  presentContentWithEvent(e, content) {
	    this.popover.style.display = 'block';
	    this.popoverContent.innerHTML = content;
	    present(e, this.popover);
	  }

	  presentMenu(e, menuItems) {
	    if (0 === menuItems.length) {
	      return;
	    }

	    this.popover.style.display = 'block';
	    const menuElements = createMenuElements(menuItems, this.popover);

	    for (let item of menuElements) {
	      this.popoverContent.appendChild(item.object);
	    }

	    present(e, this.popover);
	  }

	  hide() {
	    this.popover.style.display = 'none';
	    this.dispose();
	  }

	  dispose() {
	    if (this.popover) {
	      this.popover.parentNode.removeChild(this.popover);
	    }

	    const keys = Object.keys(this);

	    for (let key of keys) {
	      this[key] = undefined;
	    }
	  }

	}

	function present(e, popover) {
	  const {
	    x,
	    y
	  } = translateMouseCoordinates(e, popover.parentNode); // parent bbox

	  const {
	    width
	  } = popover.parentNode.getBoundingClientRect();
	  const {
	    width: w
	  } = popover.getBoundingClientRect();
	  const xmax = x + w;
	  popover.style.left = `${xmax > width ? x - (xmax - width) : x}px`;
	  popover.style.top = `${y}px`;
	}

	function createMenuElements(itemList, popover) {
	  const list = itemList.map(function (item, i) {
	    let elem;

	    if (typeof item === 'string') {
	      elem = div();
	      elem.innerHTML = item;
	    } else if (typeof item === 'Node') {
	      elem = item;
	    } else {
	      if (typeof item.init === 'function') {
	        item.init();
	      }

	      if ("checkbox" === item.type) {
	        elem = createCheckbox("Show all bases", item.value);
	      } else if ("color" === item.type) {
	        const colorPicker = new ColorPicker({
	          parent: popover.parentElement,
	          width: 364,
	          //defaultColor: 'aqua',
	          colorHandler: color => item.click(color)
	        });
	        elem = div();

	        if (typeof item.label === 'string') {
	          elem.innerHTML = item.label;
	        }

	        const clickHandler = e => {
	          colorPicker.show();
	          hide(popover);
	          e.preventDefault();
	          e.stopPropagation();
	        };

	        elem.addEventListener('click', clickHandler);
	        elem.addEventListener('touchend', clickHandler);
	        elem.addEventListener('mouseup', function (e) {
	          e.preventDefault();
	          e.stopPropagation();
	        });
	      } else {
	        elem = div();

	        if (typeof item.label === 'string') {
	          elem.innerHTML = item.label;
	        }
	      }

	      if (item.click && "color" !== item.type) {
	        elem.addEventListener('click', handleClick);
	        elem.addEventListener('touchend', handleClick);
	        elem.addEventListener('mouseup', function (e) {
	          e.preventDefault();
	          e.stopPropagation();
	        }); // eslint-disable-next-line no-inner-declarations

	        function handleClick(e) {
	          item.click();
	          hide(popover);
	          e.preventDefault();
	          e.stopPropagation();
	        }
	      }
	    }

	    return {
	      object: elem,
	      init: item.init
	    };
	  });
	  return list;
	}

	function embedCSS() {
	  var css = '.igv-ui-popover {\n  cursor: default;\n  position: absolute;\n  z-index: 2048;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: 1px;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: small;\n  background-color: white; }\n  .igv-ui-popover > div:first-child {\n    display: flex;\n    flex-direction: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-popover > div:first-child > div {\n      margin-right: 4px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-popover > div:first-child > div:hover {\n      color: #444; }\n  .igv-ui-popover > div:last-child {\n    overflow-y: auto;\n    overflow-x: hidden;\n    max-height: 400px;\n    background-color: white; }\n    .igv-ui-popover > div:last-child > div {\n      -webkit-user-select: all;\n      /* Chrome/Safari */\n      -moz-user-select: all;\n      /* Firefox */\n      margin-left: 4px;\n      margin-right: 4px;\n      max-width: 384px;\n      min-width: 220px;\n      overflow-x: hidden;\n      text-overflow: ellipsis;\n      white-space: nowrap; }\n      .igv-ui-popover > div:last-child > div > span {\n        font-weight: bolder; }\n    .igv-ui-popover > div:last-child hr {\n      width: 100%; }\n\n.igv-ui-alert-dialog-container {\n  box-sizing: content-box;\n  position: absolute;\n  z-index: 2048;\n  top: 50%;\n  left: 50%;\n  width: 400px;\n  height: 200px;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  outline: none;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: 15px;\n  font-weight: 400;\n  background-color: white;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: space-between;\n  align-items: center; }\n  .igv-ui-alert-dialog-container > div:first-child {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-start;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-alert-dialog-container > div:first-child div:first-child {\n      padding-left: 8px; }\n  .igv-ui-alert-dialog-container #igv-ui-alert-dialog-body {\n    color: #373737;\n    width: 100%;\n    height: calc(100% - 24px - 64px);\n    overflow-y: scroll; }\n    .igv-ui-alert-dialog-container #igv-ui-alert-dialog-body #igv-ui-alert-dialog-body-copy {\n      cursor: pointer;\n      margin: 16px;\n      width: auto;\n      height: auto;\n      overflow-wrap: break-word;\n      word-break: break-word;\n      background-color: white;\n      border: unset; }\n  .igv-ui-alert-dialog-container > div:last-child {\n    width: 100%;\n    margin-bottom: 10px;\n    background-color: white;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: center;\n    align-items: center; }\n    .igv-ui-alert-dialog-container > div:last-child div {\n      margin: unset;\n      width: 40px;\n      height: 30px;\n      line-height: 30px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: small;\n      font-weight: 400;\n      border-color: #2B81AF;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-alert-dialog-container > div:last-child div:hover {\n      cursor: pointer;\n      border-color: #25597f;\n      background-color: #25597f; }\n\n.igv-ui-color-swatch {\n  box-sizing: content-box;\n  display: flex;\n  flex-flow: row;\n  flex-wrap: wrap;\n  justify-content: center;\n  align-items: center;\n  width: 32px;\n  height: 32px;\n  border-style: solid;\n  border-width: 2px;\n  border-color: white;\n  border-radius: 4px; }\n\n.igv-ui-colorpicker-menu-close-button {\n  display: flex;\n  flex-flow: row;\n  flex-wrap: nowrap;\n  justify-content: flex-end;\n  align-items: center;\n  width: 100%;\n  height: 32px;\n  margin-top: 4px;\n  margin-bottom: 4px;\n  padding-right: 8px; }\n  .igv-ui-colorpicker-menu-close-button i.fa {\n    display: block;\n    margin-left: 4px;\n    margin-right: 4px;\n    color: #5f5f5f; }\n  .igv-ui-colorpicker-menu-close-button i.fa:hover,\n  .igv-ui-colorpicker-menu-close-button i.fa:focus,\n  .igv-ui-colorpicker-menu-close-button i.fa:active {\n    cursor: pointer;\n    color: #0f0f0f; }\n\n.igv-ui-generic-dialog-container {\n  box-sizing: content-box;\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 300px;\n  height: 200px;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  z-index: 2048;\n  background-color: white;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: flex-start;\n  align-items: center; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header div {\n      margin-right: 4px;\n      margin-bottom: 2px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-header div:hover {\n      cursor: pointer;\n      color: #444; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-one-liner {\n    color: #373737;\n    width: 95%;\n    height: 24px;\n    line-height: 24px;\n    text-align: left;\n    margin-top: 8px;\n    padding-left: 8px;\n    overflow-wrap: break-word;\n    background-color: white; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input {\n    margin-top: 8px;\n    width: 95%;\n    height: 24px;\n    color: #373737;\n    line-height: 24px;\n    padding-left: 8px;\n    background-color: white;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-start;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input div {\n      width: 30%;\n      height: 100%;\n      font-size: 16px;\n      text-align: right;\n      padding-right: 8px;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input input {\n      display: block;\n      height: 100%;\n      width: 100%;\n      padding-left: 4px;\n      font-family: \"Open Sans\", sans-serif;\n      font-weight: 400;\n      color: #373737;\n      text-align: left;\n      outline: none;\n      border-style: solid;\n      border-width: thin;\n      border-color: #7F7F7F;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-label-input input {\n      width: 50%;\n      font-size: 16px; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input {\n    margin-top: 8px;\n    width: calc(100% - 16px);\n    height: 24px;\n    color: #373737;\n    line-height: 24px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input input {\n      display: block;\n      height: 100%;\n      width: 100%;\n      padding-left: 4px;\n      font-family: \"Open Sans\", sans-serif;\n      font-weight: 400;\n      color: #373737;\n      text-align: left;\n      outline: none;\n      border-style: solid;\n      border-width: thin;\n      border-color: #7F7F7F;\n      background-color: white; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-input input {\n      font-size: 16px; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel {\n    width: 100%;\n    height: 28px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div {\n      margin-top: 32px;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: 14px;\n      font-weight: 400;\n      width: 75px;\n      height: 28px;\n      line-height: 28px;\n      text-align: center;\n      border-color: transparent;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 2px; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:first-child {\n      margin-left: 32px;\n      margin-right: 0;\n      background-color: #5ea4e0; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:last-child {\n      margin-left: 0;\n      margin-right: 32px;\n      background-color: #c4c4c4; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:first-child:hover {\n      cursor: pointer;\n      background-color: #3b5c7f; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok-cancel div:last-child:hover {\n      cursor: pointer;\n      background-color: #7f7f7f; }\n  .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok {\n    width: 100%;\n    height: 36px;\n    margin-top: 32px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok div {\n      width: 98px;\n      height: 36px;\n      line-height: 36px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: medium;\n      font-weight: 400;\n      border-color: white;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-generic-dialog-container .igv-ui-generic-dialog-ok div:hover {\n      cursor: pointer;\n      background-color: #25597f; }\n\n.igv-ui-generic-container {\n  box-sizing: content-box;\n  position: absolute;\n  z-index: 2048;\n  background-color: white;\n  cursor: pointer;\n  display: flex;\n  flex-direction: row;\n  flex-wrap: wrap;\n  justify-content: flex-start;\n  align-items: center; }\n  .igv-ui-generic-container div:first-child {\n    cursor: move;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    height: 24px;\n    width: 100%;\n    background-color: #dddddd; }\n    .igv-ui-generic-container div:first-child div {\n      display: block;\n      color: #5f5f5f;\n      cursor: pointer;\n      width: 14px;\n      height: 14px;\n      margin-right: 8px;\n      margin-bottom: 4px; }\n\n.igv-ui-dialog {\n  z-index: 2048;\n  position: fixed;\n  width: fit-content;\n  height: fit-content;\n  display: flex;\n  flex-flow: column;\n  flex-wrap: nowrap;\n  justify-content: flex-start;\n  background-color: white;\n  border-color: #7F7F7F;\n  border-radius: 4px;\n  border-style: solid;\n  border-width: thin;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400; }\n  .igv-ui-dialog .igv-ui-dialog-header {\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: flex-end;\n    align-items: center;\n    width: 100%;\n    height: 24px;\n    cursor: move;\n    border-top-left-radius: 4px;\n    border-top-right-radius: 4px;\n    border-bottom-color: #7F7F7F;\n    border-bottom-style: solid;\n    border-bottom-width: thin;\n    background-color: #eee; }\n    .igv-ui-dialog .igv-ui-dialog-header div {\n      margin-right: 4px;\n      margin-bottom: 2px;\n      height: 12px;\n      width: 12px;\n      color: #7F7F7F; }\n    .igv-ui-dialog .igv-ui-dialog-header div:hover {\n      cursor: pointer;\n      color: #444; }\n  .igv-ui-dialog .igv-ui-dialog-one-liner {\n    width: 95%;\n    height: 24px;\n    line-height: 24px;\n    text-align: left;\n    margin: 8px;\n    overflow-wrap: break-word;\n    background-color: white;\n    font-weight: bold; }\n  .igv-ui-dialog .igv-ui-dialog-ok-cancel {\n    width: 100%;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div {\n      margin: 16px;\n      margin-top: 32px;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: 14px;\n      font-weight: 400;\n      width: 75px;\n      height: 28px;\n      line-height: 28px;\n      text-align: center;\n      border-color: transparent;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 2px; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:first-child {\n      background-color: #5ea4e0; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:last-child {\n      background-color: #c4c4c4; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:first-child:hover {\n      cursor: pointer;\n      background-color: #3b5c7f; }\n    .igv-ui-dialog .igv-ui-dialog-ok-cancel div:last-child:hover {\n      cursor: pointer;\n      background-color: #7f7f7f; }\n  .igv-ui-dialog .igv-ui-dialog-ok {\n    width: 100%;\n    height: 36px;\n    margin-top: 32px;\n    display: flex;\n    flex-flow: row;\n    flex-wrap: nowrap;\n    justify-content: space-around;\n    align-items: center; }\n    .igv-ui-dialog .igv-ui-dialog-ok div {\n      width: 98px;\n      height: 36px;\n      line-height: 36px;\n      text-align: center;\n      color: white;\n      font-family: \"Open Sans\", sans-serif;\n      font-size: medium;\n      font-weight: 400;\n      border-color: white;\n      border-style: solid;\n      border-width: thin;\n      border-radius: 4px;\n      background-color: #2B81AF; }\n    .igv-ui-dialog .igv-ui-dialog-ok div:hover {\n      cursor: pointer;\n      background-color: #25597f; }\n\n.igv-ui-panel, .igv-ui-panel-column, .igv-ui-panel-row {\n  z-index: 2048;\n  background-color: white;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  display: flex;\n  justify-content: flex-start;\n  align-items: flex-start; }\n\n.igv-ui-panel-column {\n  display: flex;\n  flex-direction: column; }\n\n.igv-ui-panel-row {\n  display: flex;\n  flex-direction: row; }\n\n.igv-ui-textbox {\n  background-color: white;\n  font-family: \"Open Sans\", sans-serif;\n  font-size: medium;\n  font-weight: 400;\n  display: flex;\n  justify-content: flex-start;\n  align-items: flex-start; }\n\n/*# sourceMappingURL=igv-ui.css.map */\n';
	  var style = document.createElement('style');
	  style.setAttribute('type', 'text/css');
	  style.innerHTML = css;
	  document.head.insertBefore(style, document.head.childNodes[document.head.childNodes.length - 1]);
	}

	if (typeof document !== 'undefined') {
	  if (!stylesheetExists("igv-ui.css")) {
	    // console.log('igv-ui. will call embedCSS() ...');
	    embedCSS(); // console.log('... done.');
	  }

	  function stylesheetExists(stylesheetName) {
	    for (let ss of document.styleSheets) {
	      ss = ss.href ? ss.href.replace(/^.*[\\\/]/, '') : '';

	      if (ss === stylesheetName) {
	        return true;
	      }
	    }

	    return false;
	  }
	}

	function offset$1(elem) {
	  // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
	  // Support: IE <=11 only
	  // Running getBoundingClientRect on a
	  // disconnected node in IE throws an error
	  if (!elem.getClientRects().length) {
	    return {
	      top: 0,
	      left: 0
	    };
	  } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


	  const rect = elem.getBoundingClientRect();
	  const win = elem.ownerDocument.defaultView;
	  return {
	    top: rect.top + win.pageYOffset,
	    left: rect.left + win.pageXOffset
	  };
	}

	function pageCoordinates$1(e) {
	  if (e.type.startsWith("touch")) {
	    const touch = e.touches[0];
	    return {
	      x: touch.pageX,
	      y: touch.pageY
	    };
	  } else {
	    return {
	      x: e.pageX,
	      y: e.pageY
	    };
	  }
	}

	const relativeDOMBBox = (parentElement, childElement) => {
	  const {
	    x: x_p,
	    y: y_p,
	    width: width_p,
	    height: height_p
	  } = parentElement.getBoundingClientRect();
	  const {
	    x: x_c,
	    y: y_c,
	    width: width_c,
	    height: height_c
	  } = childElement.getBoundingClientRect();
	  return {
	    x: x_c - x_p,
	    y: y_c - y_p,
	    width: width_c,
	    height: height_c
	  };
	};

	function guid() {
	  return ("0000" + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4);
	}

	let getMouseXY$1 = (domElement, {
	  clientX,
	  clientY
	}) => {
	  // DOMRect object with eight properties: left, top, right, bottom, x, y, width, height
	  const {
	    left,
	    top,
	    width,
	    height
	  } = domElement.getBoundingClientRect();
	  const x = clientX - left;
	  const y = clientY - top;
	  return {
	    x,
	    y,
	    xNormalized: x / width,
	    yNormalized: y / height,
	    width,
	    height
	  };
	};
	/**
	 * Translate the mouse coordinates for the event to the coordinates for the given target element
	 * @param event
	 * @param domElement
	 * @returns {{x: number, y: number}}
	 */


	function translateMouseCoordinates$1(event, domElement) {
	  const {
	    clientX,
	    clientY
	  } = event;
	  return getMouseXY$1(domElement, {
	    clientX,
	    clientY
	  });
	}

	function createIcon$1(name, color) {
	  return iconMarkup$1(name, color);
	}

	function iconMarkup$1(name, color) {
	  color = color || "currentColor";
	  let icon = icons$1[name];

	  if (!icon) {
	    console.error(`No icon named: ${name}`);
	    icon = icons$1["question"];
	  }

	  const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
	  svg.setAttributeNS(null, 'viewBox', '0 0 ' + icon[0] + ' ' + icon[1]);
	  const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
	  path.setAttributeNS(null, 'fill', color);
	  path.setAttributeNS(null, 'd', icon[4]);
	  svg.appendChild(path);
	  return svg;
	}

	const icons$1 = {
	  "check": [512, 512, [], "f00c", "M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"],
	  "cog": [512, 512, [], "f013", "M444.788 291.1l42.616 24.599c4.867 2.809 7.126 8.618 5.459 13.985-11.07 35.642-29.97 67.842-54.689 94.586a12.016 12.016 0 0 1-14.832 2.254l-42.584-24.595a191.577 191.577 0 0 1-60.759 35.13v49.182a12.01 12.01 0 0 1-9.377 11.718c-34.956 7.85-72.499 8.256-109.219.007-5.49-1.233-9.403-6.096-9.403-11.723v-49.184a191.555 191.555 0 0 1-60.759-35.13l-42.584 24.595a12.016 12.016 0 0 1-14.832-2.254c-24.718-26.744-43.619-58.944-54.689-94.586-1.667-5.366.592-11.175 5.459-13.985L67.212 291.1a193.48 193.48 0 0 1 0-70.199l-42.616-24.599c-4.867-2.809-7.126-8.618-5.459-13.985 11.07-35.642 29.97-67.842 54.689-94.586a12.016 12.016 0 0 1 14.832-2.254l42.584 24.595a191.577 191.577 0 0 1 60.759-35.13V25.759a12.01 12.01 0 0 1 9.377-11.718c34.956-7.85 72.499-8.256 109.219-.007 5.49 1.233 9.403 6.096 9.403 11.723v49.184a191.555 191.555 0 0 1 60.759 35.13l42.584-24.595a12.016 12.016 0 0 1 14.832 2.254c24.718 26.744 43.619 58.944 54.689 94.586 1.667 5.366-.592 11.175-5.459 13.985L444.788 220.9a193.485 193.485 0 0 1 0 70.2zM336 256c0-44.112-35.888-80-80-80s-80 35.888-80 80 35.888 80 80 80 80-35.888 80-80z"],
	  "exclamation": [192, 512, [], "f12a", "M176 432c0 44.112-35.888 80-80 80s-80-35.888-80-80 35.888-80 80-80 80 35.888 80 80zM25.26 25.199l13.6 272C39.499 309.972 50.041 320 62.83 320h66.34c12.789 0 23.331-10.028 23.97-22.801l13.6-272C167.425 11.49 156.496 0 142.77 0H49.23C35.504 0 24.575 11.49 25.26 25.199z"],
	  "exclamation-circle": [512, 512, [], "f06a", "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
	  "exclamation-triangle": [576, 512, [], "f071", "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"],
	  "minus": [448, 512, [], "f068", "M424 318.2c13.3 0 24-10.7 24-24v-76.4c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h400z"],
	  "minus-circle": [512, 512, [], "f056", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zM124 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H124z"],
	  "minus-square": [448, 512, [], "f146", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM92 296c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h264c6.6 0 12 5.4 12 12v56c0 6.6-5.4 12-12 12H92z"],
	  "plus": [448, 512, [], "f067", "M448 294.2v-76.4c0-13.3-10.7-24-24-24H286.2V56c0-13.3-10.7-24-24-24h-76.4c-13.3 0-24 10.7-24 24v137.8H24c-13.3 0-24 10.7-24 24v76.4c0 13.3 10.7 24 24 24h137.8V456c0 13.3 10.7 24 24 24h76.4c13.3 0 24-10.7 24-24V318.2H424c13.3 0 24-10.7 24-24z"],
	  "plus-circle": [512, 512, [], "f055", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92h-92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
	  "plus-square": [448, 512, [], "f0fe", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-32 252c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92H92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z"],
	  "question": [384, 512, [], "f128", "M202.021 0C122.202 0 70.503 32.703 29.914 91.026c-7.363 10.58-5.093 25.086 5.178 32.874l43.138 32.709c10.373 7.865 25.132 6.026 33.253-4.148 25.049-31.381 43.63-49.449 82.757-49.449 30.764 0 68.816 19.799 68.816 49.631 0 22.552-18.617 34.134-48.993 51.164-35.423 19.86-82.299 44.576-82.299 106.405V320c0 13.255 10.745 24 24 24h72.471c13.255 0 24-10.745 24-24v-5.773c0-42.86 125.268-44.645 125.268-160.627C377.504 66.256 286.902 0 202.021 0zM192 373.459c-38.196 0-69.271 31.075-69.271 69.271 0 38.195 31.075 69.27 69.271 69.27s69.271-31.075 69.271-69.271-31.075-69.27-69.271-69.27z"],
	  "save": [448, 512, [], "f0c7", "M433.941 129.941l-83.882-83.882A48 48 0 0 0 316.118 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V163.882a48 48 0 0 0-14.059-33.941zM224 416c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64s64 28.654 64 64c0 35.346-28.654 64-64 64zm96-304.52V212c0 6.627-5.373 12-12 12H76c-6.627 0-12-5.373-12-12V108c0-6.627 5.373-12 12-12h228.52c3.183 0 6.235 1.264 8.485 3.515l3.48 3.48A11.996 11.996 0 0 1 320 111.48z"],
	  "search": [512, 512, [], "f002", "M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"],
	  "share": [512, 512, [], "f064", "M503.691 189.836L327.687 37.851C312.281 24.546 288 35.347 288 56.015v80.053C127.371 137.907 0 170.1 0 322.326c0 61.441 39.581 122.309 83.333 154.132 13.653 9.931 33.111-2.533 28.077-18.631C66.066 312.814 132.917 274.316 288 272.085V360c0 20.7 24.3 31.453 39.687 18.164l176.004-152c11.071-9.562 11.086-26.753 0-36.328z"],
	  "spinner": [512, 512, [], "f110", "M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z"],
	  "square": [448, 512, [], "f0c8", "M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48z"],
	  "square-full": [512, 512, [], "f45c", "M512 512H0V0h512v512z"],
	  "times": [384, 512, [], "f00d", "M323.1 441l53.9-53.9c9.4-9.4 9.4-24.5 0-33.9L279.8 256l97.2-97.2c9.4-9.4 9.4-24.5 0-33.9L323.1 71c-9.4-9.4-24.5-9.4-33.9 0L192 168.2 94.8 71c-9.4-9.4-24.5-9.4-33.9 0L7 124.9c-9.4 9.4-9.4 24.5 0 33.9l97.2 97.2L7 353.2c-9.4 9.4-9.4 24.5 0 33.9L60.9 441c9.4 9.4 24.5 9.4 33.9 0l97.2-97.2 97.2 97.2c9.3 9.3 24.5 9.3 33.9 0z"],
	  "times-circle": [512, 512, [], "f057", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z"],
	  "wrench": [512, 512, [], "f0ad", "M481.156 200c9.3 0 15.12 10.155 10.325 18.124C466.295 259.992 420.419 288 368 288c-79.222 0-143.501-63.974-143.997-143.079C223.505 65.469 288.548-.001 368.002 0c52.362.001 98.196 27.949 123.4 69.743C496.24 77.766 490.523 88 481.154 88H376l-40 56 40 56h105.156zm-171.649 93.003L109.255 493.255c-24.994 24.993-65.515 24.994-90.51 0-24.993-24.994-24.993-65.516 0-90.51L218.991 202.5c16.16 41.197 49.303 74.335 90.516 90.503zM104 432c0-13.255-10.745-24-24-24s-24 10.745-24 24 10.745 24 24 24 24-10.745 24-24z"]
	};

	function attachDialogCloseHandlerWithParent$1(parent, closeHandler) {
	  var container = document.createElement("div");
	  parent.appendChild(container);
	  container.appendChild(createIcon$1("times"));
	  container.addEventListener('click', function (e) {
	    e.preventDefault();
	    e.stopPropagation();
	    closeHandler();
	  });
	}

	/**
	 * @fileoverview Zlib namespace. Zlib の仕様に準拠した圧縮は Zlib.Deflate で実装
	 * されている. これは Inflate との共存を考慮している為.
	 */
	const ZLIB_STREAM_RAW_INFLATE_BUFFER_SIZE$1 = 65000;
	var Zlib$1 = {
	  Huffman: {},
	  Util: {},
	  CRC32: {}
	};
	/**
	 * Compression Method
	 * @enum {number}
	 */

	Zlib$1.CompressionMethod = {
	  DEFLATE: 8,
	  RESERVED: 15
	};
	/**
	 * @param {Object=} opt_params options.
	 * @constructor
	 */

	Zlib$1.Zip = function (opt_params) {
	  opt_params = opt_params || {};
	  /** @type {Array.<{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }>} */

	  this.files = [];
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.comment = opt_params['comment'];
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.password;
	};
	/**
	 * @enum {number}
	 */


	Zlib$1.Zip.CompressionMethod = {
	  STORE: 0,
	  DEFLATE: 8
	};
	/**
	 * @enum {number}
	 */

	Zlib$1.Zip.OperatingSystem = {
	  MSDOS: 0,
	  UNIX: 3,
	  MACINTOSH: 7
	};
	/**
	 * @enum {number}
	 */

	Zlib$1.Zip.Flags = {
	  ENCRYPT: 0x0001,
	  DESCRIPTOR: 0x0008,
	  UTF8: 0x0800
	};
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Zip.FileHeaderSignature = [0x50, 0x4b, 0x01, 0x02];
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Zip.LocalFileHeaderSignature = [0x50, 0x4b, 0x03, 0x04];
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Zip.CentralDirectorySignature = [0x50, 0x4b, 0x05, 0x06];
	/**
	 * @param {Array.<number>|Uint8Array} input
	 * @param {Object=} opt_params options.
	 */

	Zlib$1.Zip.prototype.addFile = function (input, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {string} */

	  var filename =  opt_params['filename'];
	  /** @type {boolean} */

	  var compressed;
	  /** @type {number} */

	  var size = input.length;
	  /** @type {number} */

	  var crc32 = 0;

	  if ( input instanceof Array) {
	    input = new Uint8Array(input);
	  } // default


	  if (typeof opt_params['compressionMethod'] !== 'number') {
	    opt_params['compressionMethod'] = Zlib$1.Zip.CompressionMethod.DEFLATE;
	  } // その場で圧縮する場合


	  if (opt_params['compress']) {
	    switch (opt_params['compressionMethod']) {
	      case Zlib$1.Zip.CompressionMethod.STORE:
	        break;

	      case Zlib$1.Zip.CompressionMethod.DEFLATE:
	        crc32 = Zlib$1.CRC32.calc(input);
	        input = this.deflateWithOption(input, opt_params);
	        compressed = true;
	        break;

	      default:
	        throw new Error('unknown compression method:' + opt_params['compressionMethod']);
	    }
	  }

	  this.files.push({
	    buffer: input,
	    option: opt_params,
	    compressed: compressed,
	    encrypted: false,
	    size: size,
	    crc32: crc32
	  });
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 */


	Zlib$1.Zip.prototype.setPassword = function (password) {
	  this.password = password;
	};

	Zlib$1.Zip.prototype.compress = function () {
	  /** @type {Array.<{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }>} */
	  var files = this.files;
	  /** @type {{
	   *   buffer: !(Array.<number>|Uint8Array),
	   *   option: Object,
	   *   compressed: boolean,
	   *   encrypted: boolean,
	   *   size: number,
	   *   crc32: number
	   * }} */

	  var file;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var output;
	  /** @type {number} */

	  var op1;
	  /** @type {number} */

	  var op2;
	  /** @type {number} */

	  var op3;
	  /** @type {number} */

	  var localFileSize = 0;
	  /** @type {number} */

	  var centralDirectorySize = 0;
	  /** @type {number} */

	  var endOfCentralDirectorySize;
	  /** @type {number} */

	  var offset;
	  /** @type {number} */

	  var needVersion;
	  /** @type {number} */

	  var flags;
	  /** @type {Zlib.Zip.CompressionMethod} */

	  var compressionMethod;
	  /** @type {Date} */

	  var date;
	  /** @type {number} */

	  var crc32;
	  /** @type {number} */

	  var size;
	  /** @type {number} */

	  var plainSize;
	  /** @type {number} */

	  var filenameLength;
	  /** @type {number} */

	  var extraFieldLength;
	  /** @type {number} */

	  var commentLength;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var filename;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var extraField;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var comment;
	  /** @type {(Array.<number>|Uint8Array)} */

	  var buffer;
	  /** @type {*} */

	  var tmp;
	  /** @type {Array.<number>|Uint32Array|Object} */

	  var key;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {number} */

	  var j;
	  /** @type {number} */

	  var jl; // ファイルの圧縮

	  for (i = 0, il = files.length; i < il; ++i) {
	    file = files[i];
	    filenameLength = file.option['filename'] ? file.option['filename'].length : 0;
	    extraFieldLength = file.option['extraField'] ? file.option['extraField'].length : 0;
	    commentLength = file.option['comment'] ? file.option['comment'].length : 0; // 圧縮されていなかったら圧縮

	    if (!file.compressed) {
	      // 圧縮前に CRC32 の計算をしておく
	      file.crc32 = Zlib$1.CRC32.calc(file.buffer);

	      switch (file.option['compressionMethod']) {
	        case Zlib$1.Zip.CompressionMethod.STORE:
	          break;

	        case Zlib$1.Zip.CompressionMethod.DEFLATE:
	          file.buffer = this.deflateWithOption(file.buffer, file.option);
	          file.compressed = true;
	          break;

	        default:
	          throw new Error('unknown compression method:' + file.option['compressionMethod']);
	      }
	    } // encryption


	    if (file.option['password'] !== void 0 || this.password !== void 0) {
	      // init encryption
	      key = this.createEncryptionKey(file.option['password'] || this.password); // add header

	      buffer = file.buffer;

	      {
	        tmp = new Uint8Array(buffer.length + 12);
	        tmp.set(buffer, 12);
	        buffer = tmp;
	      }

	      for (j = 0; j < 12; ++j) {
	        buffer[j] = this.encode(key, i === 11 ? file.crc32 & 0xff : Math.random() * 256 | 0);
	      } // data encryption


	      for (jl = buffer.length; j < jl; ++j) {
	        buffer[j] = this.encode(key, buffer[j]);
	      }

	      file.buffer = buffer;
	    } // 必要バッファサイズの計算


	    localFileSize += // local file header
	    30 + filenameLength + // file data
	    file.buffer.length;
	    centralDirectorySize += // file header
	    46 + filenameLength + commentLength;
	  } // end of central directory


	  endOfCentralDirectorySize = 22 + (this.comment ? this.comment.length : 0);
	  output = new ( Uint8Array )(localFileSize + centralDirectorySize + endOfCentralDirectorySize);
	  op1 = 0;
	  op2 = localFileSize;
	  op3 = op2 + centralDirectorySize; // ファイルの圧縮

	  for (i = 0, il = files.length; i < il; ++i) {
	    file = files[i];
	    filenameLength = file.option['filename'] ? file.option['filename'].length : 0;
	    extraFieldLength = 0; // TODO

	    commentLength = file.option['comment'] ? file.option['comment'].length : 0; //-------------------------------------------------------------------------
	    // local file header & file header
	    //-------------------------------------------------------------------------

	    offset = op1; // signature
	    // local file header

	    output[op1++] = Zlib$1.Zip.LocalFileHeaderSignature[0];
	    output[op1++] = Zlib$1.Zip.LocalFileHeaderSignature[1];
	    output[op1++] = Zlib$1.Zip.LocalFileHeaderSignature[2];
	    output[op1++] = Zlib$1.Zip.LocalFileHeaderSignature[3]; // file header

	    output[op2++] = Zlib$1.Zip.FileHeaderSignature[0];
	    output[op2++] = Zlib$1.Zip.FileHeaderSignature[1];
	    output[op2++] = Zlib$1.Zip.FileHeaderSignature[2];
	    output[op2++] = Zlib$1.Zip.FileHeaderSignature[3]; // compressor info

	    needVersion = 20;
	    output[op2++] = needVersion & 0xff;
	    output[op2++] =
	    /** @type {Zlib.Zip.OperatingSystem} */
	    file.option['os'] || Zlib$1.Zip.OperatingSystem.MSDOS; // need version

	    output[op1++] = output[op2++] = needVersion & 0xff;
	    output[op1++] = output[op2++] = needVersion >> 8 & 0xff; // general purpose bit flag

	    flags = 0;

	    if (file.option['password'] || this.password) {
	      flags |= Zlib$1.Zip.Flags.ENCRYPT;
	    }

	    output[op1++] = output[op2++] = flags & 0xff;
	    output[op1++] = output[op2++] = flags >> 8 & 0xff; // compression method

	    compressionMethod =
	    /** @type {Zlib.Zip.CompressionMethod} */
	    file.option['compressionMethod'];
	    output[op1++] = output[op2++] = compressionMethod & 0xff;
	    output[op1++] = output[op2++] = compressionMethod >> 8 & 0xff; // date

	    date =
	    /** @type {(Date|undefined)} */
	    file.option['date'] || new Date();
	    output[op1++] = output[op2++] = (date.getMinutes() & 0x7) << 5 | (date.getSeconds() / 2 | 0);
	    output[op1++] = output[op2++] = date.getHours() << 3 | date.getMinutes() >> 3; //

	    output[op1++] = output[op2++] = (date.getMonth() + 1 & 0x7) << 5 | date.getDate();
	    output[op1++] = output[op2++] = (date.getFullYear() - 1980 & 0x7f) << 1 | date.getMonth() + 1 >> 3; // CRC-32

	    crc32 = file.crc32;
	    output[op1++] = output[op2++] = crc32 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 8 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 16 & 0xff;
	    output[op1++] = output[op2++] = crc32 >> 24 & 0xff; // compressed size

	    size = file.buffer.length;
	    output[op1++] = output[op2++] = size & 0xff;
	    output[op1++] = output[op2++] = size >> 8 & 0xff;
	    output[op1++] = output[op2++] = size >> 16 & 0xff;
	    output[op1++] = output[op2++] = size >> 24 & 0xff; // uncompressed size

	    plainSize = file.size;
	    output[op1++] = output[op2++] = plainSize & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 8 & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 16 & 0xff;
	    output[op1++] = output[op2++] = plainSize >> 24 & 0xff; // filename length

	    output[op1++] = output[op2++] = filenameLength & 0xff;
	    output[op1++] = output[op2++] = filenameLength >> 8 & 0xff; // extra field length

	    output[op1++] = output[op2++] = extraFieldLength & 0xff;
	    output[op1++] = output[op2++] = extraFieldLength >> 8 & 0xff; // file comment length

	    output[op2++] = commentLength & 0xff;
	    output[op2++] = commentLength >> 8 & 0xff; // disk number start

	    output[op2++] = 0;
	    output[op2++] = 0; // internal file attributes

	    output[op2++] = 0;
	    output[op2++] = 0; // external file attributes

	    output[op2++] = 0;
	    output[op2++] = 0;
	    output[op2++] = 0;
	    output[op2++] = 0; // relative offset of local header

	    output[op2++] = offset & 0xff;
	    output[op2++] = offset >> 8 & 0xff;
	    output[op2++] = offset >> 16 & 0xff;
	    output[op2++] = offset >> 24 & 0xff; // filename

	    filename = file.option['filename'];

	    if (filename) {
	      {
	        output.set(filename, op1);
	        output.set(filename, op2);
	        op1 += filenameLength;
	        op2 += filenameLength;
	      }
	    } // extra field


	    extraField = file.option['extraField'];

	    if (extraField) {
	      {
	        output.set(extraField, op1);
	        output.set(extraField, op2);
	        op1 += extraFieldLength;
	        op2 += extraFieldLength;
	      }
	    } // comment


	    comment = file.option['comment'];

	    if (comment) {
	      {
	        output.set(comment, op2);
	        op2 += commentLength;
	      }
	    } //-------------------------------------------------------------------------
	    // file data
	    //-------------------------------------------------------------------------


	    {
	      output.set(file.buffer, op1);
	      op1 += file.buffer.length;
	    }
	  } //-------------------------------------------------------------------------
	  // end of central directory
	  //-------------------------------------------------------------------------
	  // signature


	  output[op3++] = Zlib$1.Zip.CentralDirectorySignature[0];
	  output[op3++] = Zlib$1.Zip.CentralDirectorySignature[1];
	  output[op3++] = Zlib$1.Zip.CentralDirectorySignature[2];
	  output[op3++] = Zlib$1.Zip.CentralDirectorySignature[3]; // number of this disk

	  output[op3++] = 0;
	  output[op3++] = 0; // number of the disk with the start of the central directory

	  output[op3++] = 0;
	  output[op3++] = 0; // total number of entries in the central directory on this disk

	  output[op3++] = il & 0xff;
	  output[op3++] = il >> 8 & 0xff; // total number of entries in the central directory

	  output[op3++] = il & 0xff;
	  output[op3++] = il >> 8 & 0xff; // size of the central directory

	  output[op3++] = centralDirectorySize & 0xff;
	  output[op3++] = centralDirectorySize >> 8 & 0xff;
	  output[op3++] = centralDirectorySize >> 16 & 0xff;
	  output[op3++] = centralDirectorySize >> 24 & 0xff; // offset of start of central directory with respect to the starting disk number

	  output[op3++] = localFileSize & 0xff;
	  output[op3++] = localFileSize >> 8 & 0xff;
	  output[op3++] = localFileSize >> 16 & 0xff;
	  output[op3++] = localFileSize >> 24 & 0xff; // .ZIP file comment length

	  commentLength = this.comment ? this.comment.length : 0;
	  output[op3++] = commentLength & 0xff;
	  output[op3++] = commentLength >> 8 & 0xff; // .ZIP file comment

	  if (this.comment) {
	    {
	      output.set(this.comment, op3);
	      op3 += commentLength;
	    }
	  }

	  return output;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input
	 * @param {Object=} opt_params options.
	 * @return {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.Zip.prototype.deflateWithOption = function (input, opt_params) {
	  /** @type {Zlib.RawDeflate} */
	  var deflator = new Zlib$1.RawDeflate(input, opt_params['deflateOption']);
	  return deflator.compress();
	};
	/**
	 * @param {(Array.<number>|Uint32Array)} key
	 * @return {number}
	 */


	Zlib$1.Zip.prototype.getByte = function (key) {
	  /** @type {number} */
	  var tmp = key[2] & 0xffff | 2;
	  return tmp * (tmp ^ 1) >> 8 & 0xff;
	};
	/**
	 * @param {(Array.<number>|Uint32Array|Object)} key
	 * @param {number} n
	 * @return {number}
	 */


	Zlib$1.Zip.prototype.encode = function (key, n) {
	  /** @type {number} */
	  var tmp = this.getByte(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key);
	  this.updateKeys(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key, n);
	  return tmp ^ n;
	};
	/**
	 * @param {(Array.<number>|Uint32Array)} key
	 * @param {number} n
	 */


	Zlib$1.Zip.prototype.updateKeys = function (key, n) {
	  key[0] = Zlib$1.CRC32.single(key[0], n);
	  key[1] = (((key[1] + (key[0] & 0xff)) * 20173 >>> 0) * 6681 >>> 0) + 1 >>> 0;
	  key[2] = Zlib$1.CRC32.single(key[2], key[1] >>> 24);
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 * @return {!(Array.<number>|Uint32Array|Object)}
	 */


	Zlib$1.Zip.prototype.createEncryptionKey = function (password) {
	  /** @type {!(Array.<number>|Uint32Array)} */
	  var key = [305419896, 591751049, 878082192];
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;

	  {
	    key = new Uint32Array(key);
	  }

	  for (i = 0, il = password.length; i < il; ++i) {
	    this.updateKeys(key, password[i] & 0xff);
	  }

	  return key;
	};
	/**
	 * build huffman table from length list.
	 * @param {!(Array.<number>|Uint8Array)} lengths length list.
	 * @return {!Array} huffman table.
	 */


	Zlib$1.Huffman.buildHuffmanTable = function (lengths) {
	  /** @type {number} length list size. */
	  var listSize = lengths.length;
	  /** @type {number} max code length for table size. */

	  var maxCodeLength = 0;
	  /** @type {number} min code length for table size. */

	  var minCodeLength = Number.POSITIVE_INFINITY;
	  /** @type {number} table size. */

	  var size;
	  /** @type {!(Array|Uint8Array)} huffman code table. */

	  var table;
	  /** @type {number} bit length. */

	  var bitLength;
	  /** @type {number} huffman code. */

	  var code;
	  /**
	   * サイズが 2^maxlength 個のテーブルを埋めるためのスキップ長.
	   * @type {number} skip length for table filling.
	   */

	  var skip;
	  /** @type {number} reversed code. */

	  var reversed;
	  /** @type {number} reverse temp. */

	  var rtemp;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limit. */

	  var il;
	  /** @type {number} loop counter. */

	  var j;
	  /** @type {number} table value. */

	  var value; // Math.max は遅いので最長の値は for-loop で取得する

	  for (i = 0, il = listSize; i < il; ++i) {
	    if (lengths[i] > maxCodeLength) {
	      maxCodeLength = lengths[i];
	    }

	    if (lengths[i] < minCodeLength) {
	      minCodeLength = lengths[i];
	    }
	  }

	  size = 1 << maxCodeLength;
	  table = new ( Uint32Array )(size); // ビット長の短い順からハフマン符号を割り当てる

	  for (bitLength = 1, code = 0, skip = 2; bitLength <= maxCodeLength;) {
	    for (i = 0; i < listSize; ++i) {
	      if (lengths[i] === bitLength) {
	        // ビットオーダーが逆になるためビット長分並びを反転する
	        for (reversed = 0, rtemp = code, j = 0; j < bitLength; ++j) {
	          reversed = reversed << 1 | rtemp & 1;
	          rtemp >>= 1;
	        } // 最大ビット長をもとにテーブルを作るため、
	        // 最大ビット長以外では 0 / 1 どちらでも良い箇所ができる
	        // そのどちらでも良い場所は同じ値で埋めることで
	        // 本来のビット長以上のビット数取得しても問題が起こらないようにする


	        value = bitLength << 16 | i;

	        for (j = reversed; j < size; j += skip) {
	          table[j] = value;
	        }

	        ++code;
	      }
	    } // 次のビット長へ


	    ++bitLength;
	    code <<= 1;
	    skip <<= 1;
	  }

	  return [table, maxCodeLength, minCodeLength];
	}; //-----------------------------------------------------------------------------

	/** @define {number} buffer block size. */


	var ZLIB_RAW_INFLATE_BUFFER_SIZE$1 = 0x8000; // [ 0x8000 >= ZLIB_BUFFER_BLOCK_SIZE ]
	//-----------------------------------------------------------------------------

	var buildHuffmanTable$1 = Zlib$1.Huffman.buildHuffmanTable;
	/**
	 * @constructor
	 * @param {!(Uint8Array|Array.<number>)} input input buffer.
	 * @param {Object} opt_params option parameter.
	 *
	 * opt_params は以下のプロパティを指定する事ができます。
	 *   - index: input buffer の deflate コンテナの開始位置.
	 *   - blockSize: バッファのブロックサイズ.
	 *   - bufferType: Zlib.RawInflate.BufferType の値によってバッファの管理方法を指定する.
	 *   - resize: 確保したバッファが実際の大きさより大きかった場合に切り詰める.
	 */

	Zlib$1.RawInflate = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} inflated buffer */
	  this.buffer;
	  /** @type {!Array.<(Array.<number>|Uint8Array)>} */

	  this.blocks = [];
	  /** @type {number} block size. */

	  this.bufferSize = ZLIB_RAW_INFLATE_BUFFER_SIZE$1;
	  /** @type {!number} total output buffer pointer. */

	  this.totalpos = 0;
	  /** @type {!number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {!number} bit stream reader buffer. */

	  this.bitsbuf = 0;
	  /** @type {!number} bit stream reader buffer size. */

	  this.bitsbuflen = 0;
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */

	  this.input =  new Uint8Array(input) ;
	  /** @type {!(Uint8Array|Array.<number>)} output buffer. */

	  this.output;
	  /** @type {!number} output buffer pointer. */

	  this.op;
	  /** @type {boolean} is final block flag. */

	  this.bfinal = false;
	  /** @type {Zlib.RawInflate.BufferType} buffer management. */

	  this.bufferType = Zlib$1.RawInflate.BufferType.ADAPTIVE;
	  /** @type {boolean} resize flag for memory size optimization. */

	  this.resize = false; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (opt_params['index']) {
	      this.ip = opt_params['index'];
	    }

	    if (opt_params['bufferSize']) {
	      this.bufferSize = opt_params['bufferSize'];
	    }

	    if (opt_params['bufferType']) {
	      this.bufferType = opt_params['bufferType'];
	    }

	    if (opt_params['resize']) {
	      this.resize = opt_params['resize'];
	    }
	  } // initialize


	  switch (this.bufferType) {
	    case Zlib$1.RawInflate.BufferType.BLOCK:
	      this.op = Zlib$1.RawInflate.MaxBackwardLength;
	      this.output = new ( Uint8Array )(Zlib$1.RawInflate.MaxBackwardLength + this.bufferSize + Zlib$1.RawInflate.MaxCopyLength);
	      break;

	    case Zlib$1.RawInflate.BufferType.ADAPTIVE:
	      this.op = 0;
	      this.output = new ( Uint8Array )(this.bufferSize);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * @enum {number}
	 */


	Zlib$1.RawInflate.BufferType = {
	  BLOCK: 0,
	  ADAPTIVE: 1
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array.<number>)} inflated buffer.
	 */

	Zlib$1.RawInflate.prototype.decompress = function () {
	  while (!this.bfinal) {
	    this.parseBlock();
	  }

	  switch (this.bufferType) {
	    case Zlib$1.RawInflate.BufferType.BLOCK:
	      return this.concatBufferBlock();

	    case Zlib$1.RawInflate.BufferType.ADAPTIVE:
	      return this.concatBufferDynamic();

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * @const
	 * @type {number} max backward length for LZ77.
	 */


	Zlib$1.RawInflate.MaxBackwardLength = 32768;
	/**
	 * @const
	 * @type {number} max copy length for LZ77.
	 */

	Zlib$1.RawInflate.MaxCopyLength = 258;
	/**
	 * huffman order
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */

	Zlib$1.RawInflate.Order = function (table) {
	  return  new Uint16Array(table) ;
	}([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
	/**
	 * huffman length code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib$1.RawInflate.LengthCodeTable = function (table) {
	  return  new Uint16Array(table) ;
	}([0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000d, 0x000f, 0x0011, 0x0013, 0x0017, 0x001b, 0x001f, 0x0023, 0x002b, 0x0033, 0x003b, 0x0043, 0x0053, 0x0063, 0x0073, 0x0083, 0x00a3, 0x00c3, 0x00e3, 0x0102, 0x0102, 0x0102]);
	/**
	 * huffman length extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.RawInflate.LengthExtraTable = function (table) {
	  return  new Uint8Array(table) ;
	}([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0]);
	/**
	 * huffman dist code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib$1.RawInflate.DistCodeTable = function (table) {
	  return  new Uint16Array(table) ;
	}([0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000d, 0x0011, 0x0019, 0x0021, 0x0031, 0x0041, 0x0061, 0x0081, 0x00c1, 0x0101, 0x0181, 0x0201, 0x0301, 0x0401, 0x0601, 0x0801, 0x0c01, 0x1001, 0x1801, 0x2001, 0x3001, 0x4001, 0x6001]);
	/**
	 * huffman dist extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.RawInflate.DistExtraTable = function (table) {
	  return  new Uint8Array(table) ;
	}([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13]);
	/**
	 * fixed huffman length code table
	 * @const
	 * @type {!Array}
	 */


	Zlib$1.RawInflate.FixedLiteralLengthTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new ( Uint8Array )(288);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = i <= 143 ? 8 : i <= 255 ? 9 : i <= 279 ? 7 : 8;
	  }

	  return buildHuffmanTable$1(lengths);
	}());
	/**
	 * fixed huffman distance code table
	 * @const
	 * @type {!Array}
	 */


	Zlib$1.RawInflate.FixedDistanceTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new ( Uint8Array )(30);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = 5;
	  }

	  return buildHuffmanTable$1(lengths);
	}());
	/**
	 * parse deflated block.
	 */


	Zlib$1.RawInflate.prototype.parseBlock = function () {
	  /** @type {number} header */
	  var hdr = this.readBits(3); // BFINAL

	  if (hdr & 0x1) {
	    this.bfinal = true;
	  } // BTYPE


	  hdr >>>= 1;

	  switch (hdr) {
	    // uncompressed
	    case 0:
	      this.parseUncompressedBlock();
	      break;
	    // fixed huffman

	    case 1:
	      this.parseFixedHuffmanBlock();
	      break;
	    // dynamic huffman

	    case 2:
	      this.parseDynamicHuffmanBlock();
	      break;
	    // reserved or other

	    default:
	      throw new Error('unknown BTYPE: ' + hdr);
	  }
	};
	/**
	 * read inflate bits
	 * @param {number} length bits length.
	 * @return {number} read bits.
	 */


	Zlib$1.RawInflate.prototype.readBits = function (length) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {number} input and output byte. */

	  var octet; // input byte

	  if (ip + (length - bitsbuflen + 7 >> 3) >= inputLength) {
	    throw new Error('input buffer is broken');
	  } // not enough buffer


	  while (bitsbuflen < length) {
	    bitsbuf |= input[ip++] << bitsbuflen;
	    bitsbuflen += 8;
	  } // output byte


	  octet = bitsbuf &
	  /* MASK */
	  (1 << length) - 1;
	  bitsbuf >>>= length;
	  bitsbuflen -= length;
	  this.bitsbuf = bitsbuf;
	  this.bitsbuflen = bitsbuflen;
	  this.ip = ip;
	  return octet;
	};
	/**
	 * read huffman code using table
	 * @param {!(Array.<number>|Uint8Array|Uint16Array)} table huffman code table.
	 * @return {number} huffman code.
	 */


	Zlib$1.RawInflate.prototype.readCodeByTable = function (table) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {!(Array.<number>|Uint8Array)} huffman code table */

	  var codeTable = table[0];
	  /** @type {number} */

	  var maxCodeLength = table[1];
	  /** @type {number} code length & code (16bit, 16bit) */

	  var codeWithLength;
	  /** @type {number} code bits length */

	  var codeLength; // not enough buffer

	  while (bitsbuflen < maxCodeLength) {
	    if (ip >= inputLength) {
	      break;
	    }

	    bitsbuf |= input[ip++] << bitsbuflen;
	    bitsbuflen += 8;
	  } // read max length


	  codeWithLength = codeTable[bitsbuf & (1 << maxCodeLength) - 1];
	  codeLength = codeWithLength >>> 16;

	  if (codeLength > bitsbuflen) {
	    throw new Error('invalid code length: ' + codeLength);
	  }

	  this.bitsbuf = bitsbuf >> codeLength;
	  this.bitsbuflen = bitsbuflen - codeLength;
	  this.ip = ip;
	  return codeWithLength & 0xffff;
	};
	/**
	 * parse uncompressed block.
	 */


	Zlib$1.RawInflate.prototype.parseUncompressedBlock = function () {
	  var input = this.input;
	  var ip = this.ip;
	  var output = this.output;
	  var op = this.op;
	  /** @type {number} */

	  var inputLength = input.length;
	  /** @type {number} block length */

	  var len;
	  /** @type {number} number for check block length */

	  var nlen;
	  /** @type {number} output buffer length */

	  var olength = output.length;
	  /** @type {number} copy counter */

	  var preCopy; // skip buffered header bits

	  this.bitsbuf = 0;
	  this.bitsbuflen = 0; // len

	  if (ip + 1 >= inputLength) {
	    throw new Error('invalid uncompressed block header: LEN');
	  }

	  len = input[ip++] | input[ip++] << 8; // nlen

	  if (ip + 1 >= inputLength) {
	    throw new Error('invalid uncompressed block header: NLEN');
	  }

	  nlen = input[ip++] | input[ip++] << 8; // check len & nlen

	  if (len === ~nlen) {
	    throw new Error('invalid uncompressed block header: length verify');
	  } // check size


	  if (ip + len > input.length) {
	    throw new Error('input buffer is broken');
	  } // expand buffer


	  switch (this.bufferType) {
	    case Zlib$1.RawInflate.BufferType.BLOCK:
	      // pre copy
	      while (op + len > output.length) {
	        preCopy = olength - op;
	        len -= preCopy;

	        {
	          output.set(input.subarray(ip, ip + preCopy), op);
	          op += preCopy;
	          ip += preCopy;
	        }

	        this.op = op;
	        output = this.expandBufferBlock();
	        op = this.op;
	      }

	      break;

	    case Zlib$1.RawInflate.BufferType.ADAPTIVE:
	      while (op + len > output.length) {
	        output = this.expandBufferAdaptive({
	          fixRatio: 2
	        });
	      }

	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  } // copy


	  {
	    output.set(input.subarray(ip, ip + len), op);
	    op += len;
	    ip += len;
	  }

	  this.ip = ip;
	  this.op = op;
	  this.output = output;
	};
	/**
	 * parse fixed huffman block.
	 */


	Zlib$1.RawInflate.prototype.parseFixedHuffmanBlock = function () {
	  switch (this.bufferType) {
	    case Zlib$1.RawInflate.BufferType.ADAPTIVE:
	      this.decodeHuffmanAdaptive(Zlib$1.RawInflate.FixedLiteralLengthTable, Zlib$1.RawInflate.FixedDistanceTable);
	      break;

	    case Zlib$1.RawInflate.BufferType.BLOCK:
	      this.decodeHuffmanBlock(Zlib$1.RawInflate.FixedLiteralLengthTable, Zlib$1.RawInflate.FixedDistanceTable);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * parse dynamic huffman block.
	 */


	Zlib$1.RawInflate.prototype.parseDynamicHuffmanBlock = function () {
	  /** @type {number} number of literal and length codes. */
	  var hlit = this.readBits(5) + 257;
	  /** @type {number} number of distance codes. */

	  var hdist = this.readBits(5) + 1;
	  /** @type {number} number of code lengths. */

	  var hclen = this.readBits(4) + 4;
	  /** @type {!(Uint8Array|Array.<number>)} code lengths. */

	  var codeLengths = new ( Uint8Array )(Zlib$1.RawInflate.Order.length);
	  /** @type {!Array} code lengths table. */

	  var codeLengthsTable;
	  /** @type {!(Uint8Array|Array.<number>)} literal and length code table. */

	  var litlenTable;
	  /** @type {!(Uint8Array|Array.<number>)} distance code table. */

	  var distTable;
	  /** @type {!(Uint8Array|Array.<number>)} code length table. */

	  var lengthTable;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var prev;
	  /** @type {number} */

	  var repeat;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limit. */

	  var il; // decode code lengths

	  for (i = 0; i < hclen; ++i) {
	    codeLengths[Zlib$1.RawInflate.Order[i]] = this.readBits(3);
	  }


	  codeLengthsTable = buildHuffmanTable$1(codeLengths);
	  lengthTable = new ( Uint8Array )(hlit + hdist);

	  for (i = 0, il = hlit + hdist; i < il;) {
	    code = this.readCodeByTable(codeLengthsTable);

	    switch (code) {
	      case 16:
	        repeat = 3 + this.readBits(2);

	        while (repeat--) {
	          lengthTable[i++] = prev;
	        }

	        break;

	      case 17:
	        repeat = 3 + this.readBits(3);

	        while (repeat--) {
	          lengthTable[i++] = 0;
	        }

	        prev = 0;
	        break;

	      case 18:
	        repeat = 11 + this.readBits(7);

	        while (repeat--) {
	          lengthTable[i++] = 0;
	        }

	        prev = 0;
	        break;

	      default:
	        lengthTable[i++] = code;
	        prev = code;
	        break;
	    }
	  }

	  litlenTable =  buildHuffmanTable$1(lengthTable.subarray(0, hlit)) ;
	  distTable =  buildHuffmanTable$1(lengthTable.subarray(hlit)) ;

	  switch (this.bufferType) {
	    case Zlib$1.RawInflate.BufferType.ADAPTIVE:
	      this.decodeHuffmanAdaptive(litlenTable, distTable);
	      break;

	    case Zlib$1.RawInflate.BufferType.BLOCK:
	      this.decodeHuffmanBlock(litlenTable, distTable);
	      break;

	    default:
	      throw new Error('invalid inflate mode');
	  }
	};
	/**
	 * decode huffman code
	 * @param {!(Array.<number>|Uint16Array)} litlen literal and length code table.
	 * @param {!(Array.<number>|Uint8Array)} dist distination code table.
	 */


	Zlib$1.RawInflate.prototype.decodeHuffmanBlock = function (litlen, dist) {
	  var output = this.output;
	  var op = this.op;
	  this.currentLitlenTable = litlen;
	  /** @type {number} output position limit. */

	  var olength = output.length - Zlib$1.RawInflate.MaxCopyLength;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var lengthCodeTable = Zlib$1.RawInflate.LengthCodeTable;
	  var lengthExtraTable = Zlib$1.RawInflate.LengthExtraTable;
	  var distCodeTable = Zlib$1.RawInflate.DistCodeTable;
	  var distExtraTable = Zlib$1.RawInflate.DistExtraTable;

	  while ((code = this.readCodeByTable(litlen)) !== 256) {
	    // literal
	    if (code < 256) {
	      if (op >= olength) {
	        this.op = op;
	        output = this.expandBufferBlock();
	        op = this.op;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = lengthCodeTable[ti];

	    if (lengthExtraTable[ti] > 0) {
	      codeLength += this.readBits(lengthExtraTable[ti]);
	    } // dist code


	    code = this.readCodeByTable(dist);
	    codeDist = distCodeTable[code];

	    if (distExtraTable[code] > 0) {
	      codeDist += this.readBits(distExtraTable[code]);
	    } // lz77 decode


	    if (op >= olength) {
	      this.op = op;
	      output = this.expandBufferBlock();
	      op = this.op;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	};
	/**
	 * decode huffman code (adaptive)
	 * @param {!(Array.<number>|Uint16Array)} litlen literal and length code table.
	 * @param {!(Array.<number>|Uint8Array)} dist distination code table.
	 */


	Zlib$1.RawInflate.prototype.decodeHuffmanAdaptive = function (litlen, dist) {
	  var output = this.output;
	  var op = this.op;
	  this.currentLitlenTable = litlen;
	  /** @type {number} output position limit. */

	  var olength = output.length;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var lengthCodeTable = Zlib$1.RawInflate.LengthCodeTable;
	  var lengthExtraTable = Zlib$1.RawInflate.LengthExtraTable;
	  var distCodeTable = Zlib$1.RawInflate.DistCodeTable;
	  var distExtraTable = Zlib$1.RawInflate.DistExtraTable;

	  while ((code = this.readCodeByTable(litlen)) !== 256) {
	    // literal
	    if (code < 256) {
	      if (op >= olength) {
	        output = this.expandBufferAdaptive();
	        olength = output.length;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = lengthCodeTable[ti];

	    if (lengthExtraTable[ti] > 0) {
	      codeLength += this.readBits(lengthExtraTable[ti]);
	    } // dist code


	    code = this.readCodeByTable(dist);
	    codeDist = distCodeTable[code];

	    if (distExtraTable[code] > 0) {
	      codeDist += this.readBits(distExtraTable[code]);
	    } // lz77 decode


	    if (op + codeLength > olength) {
	      output = this.expandBufferAdaptive();
	      olength = output.length;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	};
	/**
	 * expand output buffer.
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib$1.RawInflate.prototype.expandBufferBlock = function (opt_param) {
	  /** @type {!(Array.<number>|Uint8Array)} store buffer. */
	  var buffer = new ( Uint8Array )(this.op - Zlib$1.RawInflate.MaxBackwardLength);
	  /** @type {number} backward base point */

	  var backward = this.op - Zlib$1.RawInflate.MaxBackwardLength;
	  var output = this.output; // copy to output buffer

	  {
	    buffer.set(output.subarray(Zlib$1.RawInflate.MaxBackwardLength, buffer.length));
	  }

	  this.blocks.push(buffer);
	  this.totalpos += buffer.length; // copy to backward buffer

	  {
	    output.set(output.subarray(backward, backward + Zlib$1.RawInflate.MaxBackwardLength));
	  }

	  this.op = Zlib$1.RawInflate.MaxBackwardLength;
	  return output;
	};
	/**
	 * expand output buffer. (adaptive)
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array.<number>|Uint8Array)} output buffer pointer.
	 */


	Zlib$1.RawInflate.prototype.expandBufferAdaptive = function (opt_param) {
	  /** @type {!(Array.<number>|Uint8Array)} store buffer. */
	  var buffer;
	  /** @type {number} expantion ratio. */

	  var ratio = this.input.length / this.ip + 1 | 0;
	  /** @type {number} maximum number of huffman code. */

	  var maxHuffCode;
	  /** @type {number} new output buffer size. */

	  var newSize;
	  /** @type {number} max inflate size. */

	  var maxInflateSize;
	  var input = this.input;
	  var output = this.output;

	  if (opt_param) {
	    if (typeof opt_param.fixRatio === 'number') {
	      ratio = opt_param.fixRatio;
	    }

	    if (typeof opt_param.addRatio === 'number') {
	      ratio += opt_param.addRatio;
	    }
	  } // calculate new buffer size


	  if (ratio < 2) {
	    maxHuffCode = (input.length - this.ip) / this.currentLitlenTable[2];
	    maxInflateSize = maxHuffCode / 2 * 258 | 0;
	    newSize = maxInflateSize < output.length ? output.length + maxInflateSize : output.length << 1;
	  } else {
	    newSize = output.length * ratio;
	  } // buffer expantion


	  {
	    buffer = new Uint8Array(newSize);
	    buffer.set(output);
	  }

	  this.output = buffer;
	  return this.output;
	};
	/**
	 * concat output buffer.
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib$1.RawInflate.prototype.concatBufferBlock = function () {
	  /** @type {number} buffer pointer. */
	  var pos = 0;
	  /** @type {number} buffer pointer. */

	  var limit = this.totalpos + (this.op - Zlib$1.RawInflate.MaxBackwardLength);
	  /** @type {!(Array.<number>|Uint8Array)} output block array. */

	  var output = this.output;
	  /** @type {!Array} blocks array. */

	  var blocks = this.blocks;
	  /** @type {!(Array.<number>|Uint8Array)} output block array. */

	  var block;
	  /** @type {!(Array.<number>|Uint8Array)} output buffer. */

	  var buffer = new ( Uint8Array )(limit);
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limiter. */

	  var il;
	  /** @type {number} loop counter. */

	  var j;
	  /** @type {number} loop limiter. */

	  var jl; // single buffer

	  if (blocks.length === 0) {
	    return  this.output.subarray(Zlib$1.RawInflate.MaxBackwardLength, this.op) ;
	  } // copy to buffer


	  for (i = 0, il = blocks.length; i < il; ++i) {
	    block = blocks[i];

	    for (j = 0, jl = block.length; j < jl; ++j) {
	      buffer[pos++] = block[j];
	    }
	  } // current buffer


	  for (i = Zlib$1.RawInflate.MaxBackwardLength, il = this.op; i < il; ++i) {
	    buffer[pos++] = output[i];
	  }

	  this.blocks = [];
	  this.buffer = buffer;
	  return this.buffer;
	};
	/**
	 * concat output buffer. (dynamic)
	 * @return {!(Array.<number>|Uint8Array)} output buffer.
	 */


	Zlib$1.RawInflate.prototype.concatBufferDynamic = function () {
	  /** @type {Array.<number>|Uint8Array} output buffer. */
	  var buffer;
	  var op = this.op;

	  {
	    if (this.resize) {
	      buffer = new Uint8Array(op);
	      buffer.set(this.output.subarray(0, op));
	    } else {
	      buffer = this.output.subarray(0, op);
	    }
	  }

	  this.buffer = buffer;
	  return this.buffer;
	};

	var buildHuffmanTable$1 = Zlib$1.Huffman.buildHuffmanTable;
	/**
	 * @param {!(Uint8Array|Array.<number>)} input input buffer.
	 * @param {number} ip input buffer pointer.
	 * @param {number=} opt_buffersize buffer block size.
	 * @constructor
	 */

	Zlib$1.RawInflateStream = function (input, ip, opt_buffersize) {
	  /** @type {!Array.<(Array|Uint8Array)>} */
	  this.blocks = [];
	  /** @type {number} block size. */

	  this.bufferSize = opt_buffersize ? opt_buffersize : ZLIB_STREAM_RAW_INFLATE_BUFFER_SIZE$1;
	  /** @type {!number} total output buffer pointer. */

	  this.totalpos = 0;
	  /** @type {!number} input buffer pointer. */

	  this.ip = ip === void 0 ? 0 : ip;
	  /** @type {!number} bit stream reader buffer. */

	  this.bitsbuf = 0;
	  /** @type {!number} bit stream reader buffer size. */

	  this.bitsbuflen = 0;
	  /** @type {!(Array|Uint8Array)} input buffer. */

	  this.input =  new Uint8Array(input) ;
	  /** @type {!(Uint8Array|Array)} output buffer. */

	  this.output = new ( Uint8Array )(this.bufferSize);
	  /** @type {!number} output buffer pointer. */

	  this.op = 0;
	  /** @type {boolean} is final block flag. */

	  this.bfinal = false;
	  /** @type {number} uncompressed block length. */

	  this.blockLength;
	  /** @type {boolean} resize flag for memory size optimization. */

	  this.resize = false;
	  /** @type {Array} */

	  this.litlenTable;
	  /** @type {Array} */

	  this.distTable;
	  /** @type {number} */

	  this.sp = 0; // stream pointer

	  /** @type {Zlib.RawInflateStream.Status} */

	  this.status = Zlib$1.RawInflateStream.Status.INITIALIZED; //
	  // backup
	  //

	  /** @type {!number} */

	  this.ip_;
	  /** @type {!number} */

	  this.bitsbuflen_;
	  /** @type {!number} */

	  this.bitsbuf_;
	};
	/**
	 * @enum {number}
	 */


	Zlib$1.RawInflateStream.BlockType = {
	  UNCOMPRESSED: 0,
	  FIXED: 1,
	  DYNAMIC: 2
	};
	/**
	 * @enum {number}
	 */

	Zlib$1.RawInflateStream.Status = {
	  INITIALIZED: 0,
	  BLOCK_HEADER_START: 1,
	  BLOCK_HEADER_END: 2,
	  BLOCK_BODY_START: 3,
	  BLOCK_BODY_END: 4,
	  DECODE_BLOCK_START: 5,
	  DECODE_BLOCK_END: 6
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */

	Zlib$1.RawInflateStream.prototype.decompress = function (newInput, ip) {
	  /** @type {boolean} */
	  var stop = false;

	  if (newInput !== void 0) {
	    this.input = newInput;
	  }

	  if (ip !== void 0) {
	    this.ip = ip;
	  } // decompress


	  while (!stop) {
	    switch (this.status) {
	      // block header
	      case Zlib$1.RawInflateStream.Status.INITIALIZED:
	      case Zlib$1.RawInflateStream.Status.BLOCK_HEADER_START:
	        if (this.readBlockHeader() < 0) {
	          stop = true;
	        }

	        break;
	      // block body

	      case Zlib$1.RawInflateStream.Status.BLOCK_HEADER_END:
	      /* FALLTHROUGH */

	      case Zlib$1.RawInflateStream.Status.BLOCK_BODY_START:
	        switch (this.currentBlockType) {
	          case Zlib$1.RawInflateStream.BlockType.UNCOMPRESSED:
	            if (this.readUncompressedBlockHeader() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib$1.RawInflateStream.BlockType.FIXED:
	            if (this.parseFixedHuffmanBlock() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib$1.RawInflateStream.BlockType.DYNAMIC:
	            if (this.parseDynamicHuffmanBlock() < 0) {
	              stop = true;
	            }

	            break;
	        }

	        break;
	      // decode data

	      case Zlib$1.RawInflateStream.Status.BLOCK_BODY_END:
	      case Zlib$1.RawInflateStream.Status.DECODE_BLOCK_START:
	        switch (this.currentBlockType) {
	          case Zlib$1.RawInflateStream.BlockType.UNCOMPRESSED:
	            if (this.parseUncompressedBlock() < 0) {
	              stop = true;
	            }

	            break;

	          case Zlib$1.RawInflateStream.BlockType.FIXED:
	          /* FALLTHROUGH */

	          case Zlib$1.RawInflateStream.BlockType.DYNAMIC:
	            if (this.decodeHuffman() < 0) {
	              stop = true;
	            }

	            break;
	        }

	        break;

	      case Zlib$1.RawInflateStream.Status.DECODE_BLOCK_END:
	        if (this.bfinal) {
	          stop = true;
	        } else {
	          this.status = Zlib$1.RawInflateStream.Status.INITIALIZED;
	        }

	        break;
	    }
	  }

	  return this.concatBuffer();
	};
	/**
	 * @const
	 * @type {number} max backward length for LZ77.
	 */


	Zlib$1.RawInflateStream.MaxBackwardLength = 32768;
	/**
	 * @const
	 * @type {number} max copy length for LZ77.
	 */

	Zlib$1.RawInflateStream.MaxCopyLength = 258;
	/**
	 * huffman order
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */

	Zlib$1.RawInflateStream.Order = function (table) {
	  return  new Uint16Array(table) ;
	}([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
	/**
	 * huffman length code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib$1.RawInflateStream.LengthCodeTable = function (table) {
	  return  new Uint16Array(table) ;
	}([0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000d, 0x000f, 0x0011, 0x0013, 0x0017, 0x001b, 0x001f, 0x0023, 0x002b, 0x0033, 0x003b, 0x0043, 0x0053, 0x0063, 0x0073, 0x0083, 0x00a3, 0x00c3, 0x00e3, 0x0102, 0x0102, 0x0102]);
	/**
	 * huffman length extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.RawInflateStream.LengthExtraTable = function (table) {
	  return  new Uint8Array(table) ;
	}([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0]);
	/**
	 * huffman dist code table.
	 * @const
	 * @type {!(Array.<number>|Uint16Array)}
	 */


	Zlib$1.RawInflateStream.DistCodeTable = function (table) {
	  return  new Uint16Array(table) ;
	}([0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000d, 0x0011, 0x0019, 0x0021, 0x0031, 0x0041, 0x0061, 0x0081, 0x00c1, 0x0101, 0x0181, 0x0201, 0x0301, 0x0401, 0x0601, 0x0801, 0x0c01, 0x1001, 0x1801, 0x2001, 0x3001, 0x4001, 0x6001]);
	/**
	 * huffman dist extra-bits table.
	 * @const
	 * @type {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.RawInflateStream.DistExtraTable = function (table) {
	  return  new Uint8Array(table) ;
	}([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13]);
	/**
	 * fixed huffman length code table
	 * @const
	 * @type {!Array}
	 */


	Zlib$1.RawInflateStream.FixedLiteralLengthTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new ( Uint8Array )(288);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = i <= 143 ? 8 : i <= 255 ? 9 : i <= 279 ? 7 : 8;
	  }

	  return buildHuffmanTable$1(lengths);
	}());
	/**
	 * fixed huffman distance code table
	 * @const
	 * @type {!Array}
	 */


	Zlib$1.RawInflateStream.FixedDistanceTable = function (table) {
	  return table;
	}(function () {
	  var lengths = new ( Uint8Array )(30);
	  var i, il;

	  for (i = 0, il = lengths.length; i < il; ++i) {
	    lengths[i] = 5;
	  }

	  return buildHuffmanTable$1(lengths);
	}());
	/**
	 * parse deflated block.
	 */


	Zlib$1.RawInflateStream.prototype.readBlockHeader = function () {
	  /** @type {number} header */
	  var hdr;
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_HEADER_START;
	  this.save_();

	  if ((hdr = this.readBits(3)) < 0) {
	    this.restore_();
	    return -1;
	  } // BFINAL


	  if (hdr & 0x1) {
	    this.bfinal = true;
	  } // BTYPE


	  hdr >>>= 1;

	  switch (hdr) {
	    case 0:
	      // uncompressed
	      this.currentBlockType = Zlib$1.RawInflateStream.BlockType.UNCOMPRESSED;
	      break;

	    case 1:
	      // fixed huffman
	      this.currentBlockType = Zlib$1.RawInflateStream.BlockType.FIXED;
	      break;

	    case 2:
	      // dynamic huffman
	      this.currentBlockType = Zlib$1.RawInflateStream.BlockType.DYNAMIC;
	      break;

	    default:
	      // reserved or other
	      throw new Error('unknown BTYPE: ' + hdr);
	  }

	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_HEADER_END;
	};
	/**
	 * read inflate bits
	 * @param {number} length bits length.
	 * @return {number} read bits.
	 */


	Zlib$1.RawInflateStream.prototype.readBits = function (length) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {number} input and output byte. */

	  var octet; // not enough buffer

	  while (bitsbuflen < length) {
	    // input byte
	    if (input.length <= ip) {
	      return -1;
	    }

	    octet = input[ip++]; // concat octet

	    bitsbuf |= octet << bitsbuflen;
	    bitsbuflen += 8;
	  } // output byte


	  octet = bitsbuf &
	  /* MASK */
	  (1 << length) - 1;
	  bitsbuf >>>= length;
	  bitsbuflen -= length;
	  this.bitsbuf = bitsbuf;
	  this.bitsbuflen = bitsbuflen;
	  this.ip = ip;
	  return octet;
	};
	/**
	 * read huffman code using table
	 * @param {Array} table huffman code table.
	 * @return {number} huffman code.
	 */


	Zlib$1.RawInflateStream.prototype.readCodeByTable = function (table) {
	  var bitsbuf = this.bitsbuf;
	  var bitsbuflen = this.bitsbuflen;
	  var input = this.input;
	  var ip = this.ip;
	  /** @type {!(Array|Uint8Array)} huffman code table */

	  var codeTable = table[0];
	  /** @type {number} */

	  var maxCodeLength = table[1];
	  /** @type {number} input byte */

	  var octet;
	  /** @type {number} code length & code (16bit, 16bit) */

	  var codeWithLength;
	  /** @type {number} code bits length */

	  var codeLength; // not enough buffer

	  while (bitsbuflen < maxCodeLength) {
	    if (input.length <= ip) {
	      return -1;
	    }

	    octet = input[ip++];
	    bitsbuf |= octet << bitsbuflen;
	    bitsbuflen += 8;
	  } // read max length


	  codeWithLength = codeTable[bitsbuf & (1 << maxCodeLength) - 1];
	  codeLength = codeWithLength >>> 16;

	  if (codeLength > bitsbuflen) {
	    throw new Error('invalid code length: ' + codeLength);
	  }

	  this.bitsbuf = bitsbuf >> codeLength;
	  this.bitsbuflen = bitsbuflen - codeLength;
	  this.ip = ip;
	  return codeWithLength & 0xffff;
	};
	/**
	 * read uncompressed block header
	 */


	Zlib$1.RawInflateStream.prototype.readUncompressedBlockHeader = function () {
	  /** @type {number} block length */
	  var len;
	  /** @type {number} number for check block length */

	  var nlen;
	  var input = this.input;
	  var ip = this.ip;
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_START;

	  if (ip + 4 >= input.length) {
	    return -1;
	  }

	  len = input[ip++] | input[ip++] << 8;
	  nlen = input[ip++] | input[ip++] << 8; // check len & nlen

	  if (len === ~nlen) {
	    throw new Error('invalid uncompressed block header: length verify');
	  } // skip buffered header bits


	  this.bitsbuf = 0;
	  this.bitsbuflen = 0;
	  this.ip = ip;
	  this.blockLength = len;
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_END;
	};
	/**
	 * parse uncompressed block.
	 */


	Zlib$1.RawInflateStream.prototype.parseUncompressedBlock = function () {
	  var input = this.input;
	  var ip = this.ip;
	  var output = this.output;
	  var op = this.op;
	  var len = this.blockLength;
	  this.status = Zlib$1.RawInflateStream.Status.DECODE_BLOCK_START; // copy
	  // XXX: とりあえず素直にコピー

	  while (len--) {
	    if (op === output.length) {
	      output = this.expandBuffer({
	        fixRatio: 2
	      });
	    } // not enough input buffer


	    if (ip >= input.length) {
	      this.ip = ip;
	      this.op = op;
	      this.blockLength = len + 1; // コピーしてないので戻す

	      return -1;
	    }

	    output[op++] = input[ip++];
	  }

	  if (len < 0) {
	    this.status = Zlib$1.RawInflateStream.Status.DECODE_BLOCK_END;
	  }

	  this.ip = ip;
	  this.op = op;
	  return 0;
	};
	/**
	 * parse fixed huffman block.
	 */


	Zlib$1.RawInflateStream.prototype.parseFixedHuffmanBlock = function () {
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_START;
	  this.litlenTable = Zlib$1.RawInflateStream.FixedLiteralLengthTable;
	  this.distTable = Zlib$1.RawInflateStream.FixedDistanceTable;
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_END;
	  return 0;
	};
	/**
	 * オブジェクトのコンテキストを別のプロパティに退避する.
	 * @private
	 */


	Zlib$1.RawInflateStream.prototype.save_ = function () {
	  this.ip_ = this.ip;
	  this.bitsbuflen_ = this.bitsbuflen;
	  this.bitsbuf_ = this.bitsbuf;
	};
	/**
	 * 別のプロパティに退避したコンテキストを復元する.
	 * @private
	 */


	Zlib$1.RawInflateStream.prototype.restore_ = function () {
	  this.ip = this.ip_;
	  this.bitsbuflen = this.bitsbuflen_;
	  this.bitsbuf = this.bitsbuf_;
	};
	/**
	 * parse dynamic huffman block.
	 */


	Zlib$1.RawInflateStream.prototype.parseDynamicHuffmanBlock = function () {
	  /** @type {number} number of literal and length codes. */
	  var hlit;
	  /** @type {number} number of distance codes. */

	  var hdist;
	  /** @type {number} number of code lengths. */

	  var hclen;
	  /** @type {!(Uint8Array|Array)} code lengths. */

	  var codeLengths = new ( Uint8Array )(Zlib$1.RawInflateStream.Order.length);
	  /** @type {!Array} code lengths table. */

	  var codeLengthsTable;
	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_START;
	  this.save_();
	  hlit = this.readBits(5) + 257;
	  hdist = this.readBits(5) + 1;
	  hclen = this.readBits(4) + 4;

	  if (hlit < 0 || hdist < 0 || hclen < 0) {
	    this.restore_();
	    return -1;
	  }

	  try {
	    parseDynamicHuffmanBlockImpl.call(this);
	  } catch (e) {
	    this.restore_();
	    return -1;
	  }

	  function parseDynamicHuffmanBlockImpl() {
	    /** @type {number} */
	    var bits;
	    var code;
	    var prev = 0;
	    var repeat;
	    /** @type {!(Uint8Array|Array.<number>)} code length table. */

	    var lengthTable;
	    /** @type {number} loop counter. */

	    var i;
	    /** @type {number} loop limit. */

	    var il; // decode code lengths

	    for (i = 0; i < hclen; ++i) {
	      if ((bits = this.readBits(3)) < 0) {
	        throw new Error('not enough input');
	      }

	      codeLengths[Zlib$1.RawInflateStream.Order[i]] = bits;
	    } // decode length table


	    codeLengthsTable = buildHuffmanTable$1(codeLengths);
	    lengthTable = new ( Uint8Array )(hlit + hdist);

	    for (i = 0, il = hlit + hdist; i < il;) {
	      code = this.readCodeByTable(codeLengthsTable);

	      if (code < 0) {
	        throw new Error('not enough input');
	      }

	      switch (code) {
	        case 16:
	          if ((bits = this.readBits(2)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 3 + bits;

	          while (repeat--) {
	            lengthTable[i++] = prev;
	          }

	          break;

	        case 17:
	          if ((bits = this.readBits(3)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 3 + bits;

	          while (repeat--) {
	            lengthTable[i++] = 0;
	          }

	          prev = 0;
	          break;

	        case 18:
	          if ((bits = this.readBits(7)) < 0) {
	            throw new Error('not enough input');
	          }

	          repeat = 11 + bits;

	          while (repeat--) {
	            lengthTable[i++] = 0;
	          }

	          prev = 0;
	          break;

	        default:
	          lengthTable[i++] = code;
	          prev = code;
	          break;
	      }
	    } // literal and length code
	    this.litlenTable =  buildHuffmanTable$1(lengthTable.subarray(0, hlit)) ;
	    this.distTable =  buildHuffmanTable$1(lengthTable.subarray(hlit)) ;
	  }

	  this.status = Zlib$1.RawInflateStream.Status.BLOCK_BODY_END;
	  return 0;
	};
	/**
	 * decode huffman code (dynamic)
	 * @return {(number|undefined)} -1 is error.
	 */


	Zlib$1.RawInflateStream.prototype.decodeHuffman = function () {
	  var output = this.output;
	  var op = this.op;
	  /** @type {number} huffman code. */

	  var code;
	  /** @type {number} table index. */

	  var ti;
	  /** @type {number} huffman code distination. */

	  var codeDist;
	  /** @type {number} huffman code length. */

	  var codeLength;
	  var litlen = this.litlenTable;
	  var dist = this.distTable;
	  var olength = output.length;
	  var bits;
	  this.status = Zlib$1.RawInflateStream.Status.DECODE_BLOCK_START;

	  while (true) {
	    this.save_();
	    code = this.readCodeByTable(litlen);

	    if (code < 0) {
	      this.op = op;
	      this.restore_();
	      return -1;
	    }

	    if (code === 256) {
	      break;
	    } // literal


	    if (code < 256) {
	      if (op === olength) {
	        output = this.expandBuffer();
	        olength = output.length;
	      }

	      output[op++] = code;
	      continue;
	    } // length code


	    ti = code - 257;
	    codeLength = Zlib$1.RawInflateStream.LengthCodeTable[ti];

	    if (Zlib$1.RawInflateStream.LengthExtraTable[ti] > 0) {
	      bits = this.readBits(Zlib$1.RawInflateStream.LengthExtraTable[ti]);

	      if (bits < 0) {
	        this.op = op;
	        this.restore_();
	        return -1;
	      }

	      codeLength += bits;
	    } // dist code


	    code = this.readCodeByTable(dist);

	    if (code < 0) {
	      this.op = op;
	      this.restore_();
	      return -1;
	    }

	    codeDist = Zlib$1.RawInflateStream.DistCodeTable[code];

	    if (Zlib$1.RawInflateStream.DistExtraTable[code] > 0) {
	      bits = this.readBits(Zlib$1.RawInflateStream.DistExtraTable[code]);

	      if (bits < 0) {
	        this.op = op;
	        this.restore_();
	        return -1;
	      }

	      codeDist += bits;
	    } // lz77 decode


	    if (op + codeLength >= olength) {
	      output = this.expandBuffer();
	      olength = output.length;
	    }

	    while (codeLength--) {
	      output[op] = output[op++ - codeDist];
	    } // break


	    if (this.ip === this.input.length) {
	      this.op = op;
	      return -1;
	    }
	  }

	  while (this.bitsbuflen >= 8) {
	    this.bitsbuflen -= 8;
	    this.ip--;
	  }

	  this.op = op;
	  this.status = Zlib$1.RawInflateStream.Status.DECODE_BLOCK_END;
	};
	/**
	 * expand output buffer. (dynamic)
	 * @param {Object=} opt_param option parameters.
	 * @return {!(Array|Uint8Array)} output buffer pointer.
	 */


	Zlib$1.RawInflateStream.prototype.expandBuffer = function (opt_param) {
	  /** @type {!(Array|Uint8Array)} store buffer. */
	  var buffer;
	  /** @type {number} expantion ratio. */

	  var ratio = this.input.length / this.ip + 1 | 0;
	  /** @type {number} maximum number of huffman code. */

	  var maxHuffCode;
	  /** @type {number} new output buffer size. */

	  var newSize;
	  /** @type {number} max inflate size. */

	  var maxInflateSize;
	  var input = this.input;
	  var output = this.output;

	  if (opt_param) {
	    if (typeof opt_param.fixRatio === 'number') {
	      ratio = opt_param.fixRatio;
	    }

	    if (typeof opt_param.addRatio === 'number') {
	      ratio += opt_param.addRatio;
	    }
	  } // calculate new buffer size


	  if (ratio < 2) {
	    maxHuffCode = (input.length - this.ip) / this.litlenTable[2];
	    maxInflateSize = maxHuffCode / 2 * 258 | 0;
	    newSize = maxInflateSize < output.length ? output.length + maxInflateSize : output.length << 1;
	  } else {
	    newSize = output.length * ratio;
	  } // buffer expantion


	  {
	    buffer = new Uint8Array(newSize);
	    buffer.set(output);
	  }

	  this.output = buffer;
	  return this.output;
	};
	/**
	 * concat output buffer. (dynamic)
	 * @return {!(Array|Uint8Array)} output buffer.
	 */


	Zlib$1.RawInflateStream.prototype.concatBuffer = function () {
	  /** @type {!(Array|Uint8Array)} output buffer. */
	  var buffer;
	  /** @type {number} */

	  var op = this.op;
	  /** @type {Uint8Array} */

	  var tmp;

	  if (this.resize) {
	    {
	      buffer = new Uint8Array(this.output.subarray(this.sp, op));
	    }
	  } else {
	    buffer =  this.output.subarray(this.sp, op) ;
	  }

	  this.sp = op; // compaction

	  if (op > Zlib$1.RawInflateStream.MaxBackwardLength + this.bufferSize) {
	    this.op = this.sp = Zlib$1.RawInflateStream.MaxBackwardLength;

	    {
	      tmp =
	      /** @type {Uint8Array} */
	      this.output;
	      this.output = new Uint8Array(this.bufferSize + Zlib$1.RawInflateStream.MaxBackwardLength);
	      this.output.set(tmp.subarray(op - Zlib$1.RawInflateStream.MaxBackwardLength, op));
	    }
	  }

	  return buffer;
	};
	/**
	 * @constructor
	 * @param {!(Uint8Array|Array)} input deflated buffer.
	 * @param {Object=} opt_params option parameters.
	 *
	 * opt_params は以下のプロパティを指定する事ができます。
	 *   - index: input buffer の deflate コンテナの開始位置.
	 *   - blockSize: バッファのブロックサイズ.
	 *   - verify: 伸張が終わった後 adler-32 checksum の検証を行うか.
	 *   - bufferType: Zlib.Inflate.BufferType の値によってバッファの管理方法を指定する.
	 *       Zlib.Inflate.BufferType は Zlib.RawInflate.BufferType のエイリアス.
	 */


	Zlib$1.Inflate = function (input, opt_params) {
	  /** @type {number} */

	  var cmf;
	  /** @type {number} */

	  var flg;
	  /** @type {!(Uint8Array|Array)} */

	  this.input = input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {Zlib.RawInflate} */

	  this.rawinflate;
	  /** @type {(boolean|undefined)} verify flag. */

	  this.verify; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (opt_params['index']) {
	      this.ip = opt_params['index'];
	    }

	    if (opt_params['verify']) {
	      this.verify = opt_params['verify'];
	    }
	  } // Compression Method and Flags


	  cmf = input[this.ip++];
	  flg = input[this.ip++]; // compression method

	  switch (cmf & 0x0f) {
	    case Zlib$1.CompressionMethod.DEFLATE:
	      this.method = Zlib$1.CompressionMethod.DEFLATE;
	      break;

	    default:
	      throw new Error('unsupported compression method');
	  } // fcheck


	  if (((cmf << 8) + flg) % 31 !== 0) {
	    throw new Error('invalid fcheck flag:' + ((cmf << 8) + flg) % 31);
	  } // fdict (not supported)


	  if (flg & 0x20) {
	    throw new Error('fdict flag is not supported');
	  } // RawInflate


	  this.rawinflate = new Zlib$1.RawInflate(input, {
	    'index': this.ip,
	    'bufferSize': opt_params['bufferSize'],
	    'bufferType': opt_params['bufferType'],
	    'resize': opt_params['resize']
	  });
	};
	/**
	 * @enum {number}
	 */


	Zlib$1.Inflate.BufferType = Zlib$1.RawInflate.BufferType;
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */

	Zlib$1.Inflate.prototype.decompress = function () {
	  /** @type {!(Array|Uint8Array)} input buffer. */
	  var input = this.input;
	  /** @type {!(Uint8Array|Array)} inflated buffer. */

	  var buffer;
	  /** @type {number} adler-32 checksum */

	  var adler32;
	  buffer = this.rawinflate.decompress();
	  this.ip = this.rawinflate.ip; // verify adler-32

	  if (this.verify) {
	    adler32 = (input[this.ip++] << 24 | input[this.ip++] << 16 | input[this.ip++] << 8 | input[this.ip++]) >>> 0;

	    if (adler32 !== Zlib$1.Adler32(buffer)) {
	      throw new Error('invalid adler-32 checksum');
	    }
	  }

	  return buffer;
	};
	/* vim:set expandtab ts=2 sw=2 tw=80: */

	/**
	 * @param {!(Uint8Array|Array)} input deflated buffer.
	 * @constructor
	 */


	Zlib$1.InflateStream = function (input) {
	  /** @type {!(Uint8Array|Array)} */
	  this.input = input === void 0 ? new ( Uint8Array )() : input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {Zlib.RawInflateStream} */

	  this.rawinflate = new Zlib$1.RawInflateStream(this.input, this.ip);
	  /** @type {Zlib.CompressionMethod} */

	  this.method;
	  /** @type {!(Array|Uint8Array)} */

	  this.output = this.rawinflate.output;
	};
	/**
	 * decompress.
	 * @return {!(Uint8Array|Array)} inflated buffer.
	 */


	Zlib$1.InflateStream.prototype.decompress = function (input) {
	  /** @type {!(Uint8Array|Array)} inflated buffer. */
	  var buffer;
	  // XXX Array, Uint8Array のチェックを行うか確認する

	  if (input !== void 0) {
	    {
	      var tmp = new Uint8Array(this.input.length + input.length);
	      tmp.set(this.input, 0);
	      tmp.set(input, this.input.length);
	      this.input = tmp;
	    }
	  }

	  if (this.method === void 0) {
	    if (this.readHeader() < 0) {
	      return new ( Uint8Array )();
	    }
	  }

	  buffer = this.rawinflate.decompress(this.input, this.ip);

	  if (this.rawinflate.ip !== 0) {
	    this.input =  this.input.subarray(this.rawinflate.ip) ;
	    this.ip = 0;
	  } // verify adler-32

	  /*
	  if (this.verify) {
	    adler32 =
	      input[this.ip++] << 24 | input[this.ip++] << 16 |
	      input[this.ip++] << 8 | input[this.ip++];
	     if (adler32 !== Zlib.Adler32(buffer)) {
	      throw new Error('invalid adler-32 checksum');
	    }
	  }
	  */


	  return buffer;
	};

	Zlib$1.InflateStream.prototype.readHeader = function () {
	  var ip = this.ip;
	  var input = this.input; // Compression Method and Flags

	  var cmf = input[ip++];
	  var flg = input[ip++];

	  if (cmf === void 0 || flg === void 0) {
	    return -1;
	  } // compression method


	  switch (cmf & 0x0f) {
	    case Zlib$1.CompressionMethod.DEFLATE:
	      this.method = Zlib$1.CompressionMethod.DEFLATE;
	      break;

	    default:
	      throw new Error('unsupported compression method');
	  } // fcheck


	  if (((cmf << 8) + flg) % 31 !== 0) {
	    throw new Error('invalid fcheck flag:' + ((cmf << 8) + flg) % 31);
	  } // fdict (not supported)


	  if (flg & 0x20) {
	    throw new Error('fdict flag is not supported');
	  }

	  this.ip = ip;
	};
	/**
	 * @fileoverview GZIP (RFC1952) 展開コンテナ実装.
	 */

	/**
	 * @constructor
	 * @param {!(Array|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params option parameters.
	 */


	Zlib$1.Gunzip = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */
	  this.input = input;
	  /** @type {number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {Array.<Zlib.GunzipMember>} */

	  this.member = [];
	  /** @type {boolean} */

	  this.decompressed = false;
	};
	/**
	 * @return {Array.<Zlib.GunzipMember>}
	 */


	Zlib$1.Gunzip.prototype.getMembers = function () {
	  if (!this.decompressed) {
	    this.decompress();
	  }

	  return this.member.slice();
	};
	/**
	 * inflate gzip data.
	 * @return {!(Array.<number>|Uint8Array)} inflated buffer.
	 */


	Zlib$1.Gunzip.prototype.decompress = function () {
	  /** @type {number} input length. */
	  var il = this.input.length;

	  while (this.ip < il) {
	    this.decodeMember();
	  }

	  this.decompressed = true;
	  return this.concatMember();
	};
	/**
	 * decode gzip member.
	 */


	Zlib$1.Gunzip.prototype.decodeMember = function () {
	  /** @type {Zlib.GunzipMember} */
	  var member = new Zlib$1.GunzipMember();
	  /** @type {number} */

	  var isize;
	  /** @type {Zlib.RawInflate} RawInflate implementation. */

	  var rawinflate;
	  /** @type {!(Array.<number>|Uint8Array)} inflated data. */

	  var inflated;
	  /** @type {number} inflate size */

	  var inflen;
	  /** @type {number} character code */

	  var c;
	  /** @type {number} character index in string. */

	  var ci;
	  /** @type {Array.<string>} character array. */

	  var str;
	  /** @type {number} modification time. */

	  var mtime;
	  /** @type {number} */

	  var crc32;
	  var input = this.input;
	  var ip = this.ip;
	  member.id1 = input[ip++];
	  member.id2 = input[ip++]; // check signature

	  if (member.id1 !== 0x1f || member.id2 !== 0x8b) {
	    throw new Error('invalid file signature:' + member.id1 + ',' + member.id2);
	  } // check compression method


	  member.cm = input[ip++];

	  switch (member.cm) {
	    case 8:
	      /* XXX: use Zlib const */
	      break;

	    default:
	      throw new Error('unknown compression method: ' + member.cm);
	  } // flags


	  member.flg = input[ip++]; // modification time

	  mtime = input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24;
	  member.mtime = new Date(mtime * 1000); // extra flags

	  member.xfl = input[ip++]; // operating system

	  member.os = input[ip++]; // extra

	  if ((member.flg & Zlib$1.Gzip.FlagsMask.FEXTRA) > 0) {
	    member.xlen = input[ip++] | input[ip++] << 8;
	    ip = this.decodeSubField(ip, member.xlen);
	  } // fname


	  if ((member.flg & Zlib$1.Gzip.FlagsMask.FNAME) > 0) {
	    for (str = [], ci = 0; (c = input[ip++]) > 0;) {
	      str[ci++] = String.fromCharCode(c);
	    }

	    member.name = str.join('');
	  } // fcomment


	  if ((member.flg & Zlib$1.Gzip.FlagsMask.FCOMMENT) > 0) {
	    for (str = [], ci = 0; (c = input[ip++]) > 0;) {
	      str[ci++] = String.fromCharCode(c);
	    }

	    member.comment = str.join('');
	  } // fhcrc


	  if ((member.flg & Zlib$1.Gzip.FlagsMask.FHCRC) > 0) {
	    member.crc16 = Zlib$1.CRC32.calc(input, 0, ip) & 0xffff;

	    if (member.crc16 !== (input[ip++] | input[ip++] << 8)) {
	      throw new Error('invalid header crc16');
	    }
	  } // isize を事前に取得すると展開後のサイズが分かるため、
	  // inflate処理のバッファサイズが事前に分かり、高速になる


	  isize = input[input.length - 4] | input[input.length - 3] << 8 | input[input.length - 2] << 16 | input[input.length - 1] << 24; // isize の妥当性チェック
	  // ハフマン符号では最小 2-bit のため、最大で 1/4 になる
	  // LZ77 符号では 長さと距離 2-Byte で最大 258-Byte を表現できるため、
	  // 1/128 になるとする
	  // ここから入力バッファの残りが isize の 512 倍以上だったら
	  // サイズ指定のバッファ確保は行わない事とする

	  if (input.length - ip -
	  /* CRC-32 */
	  4 -
	  /* ISIZE */
	  4 < isize * 512) {
	    inflen = isize;
	  } // compressed block


	  rawinflate = new Zlib$1.RawInflate(input, {
	    'index': ip,
	    'bufferSize': inflen
	  });
	  member.data = inflated = rawinflate.decompress();
	  ip = rawinflate.ip; // crc32

	  member.crc32 = crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0;

	  if (Zlib$1.CRC32.calc(inflated) !== crc32) {
	    throw new Error('invalid CRC-32 checksum: 0x' + Zlib$1.CRC32.calc(inflated).toString(16) + ' / 0x' + crc32.toString(16));
	  } // input size


	  member.isize = isize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0;

	  if ((inflated.length & 0xffffffff) !== isize) {
	    throw new Error('invalid input size: ' + (inflated.length & 0xffffffff) + ' / ' + isize);
	  }

	  this.member.push(member);
	  this.ip = ip;
	};
	/**
	 * サブフィールドのデコード
	 * XXX: 現在は何もせずスキップする
	 */


	Zlib$1.Gunzip.prototype.decodeSubField = function (ip, length) {
	  return ip + length;
	};
	/**
	 * @return {!(Array.<number>|Uint8Array)}
	 */


	Zlib$1.Gunzip.prototype.concatMember = function () {
	  /** @type {Array.<Zlib.GunzipMember>} */
	  var member = this.member;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {number} */

	  var p = 0;
	  /** @type {number} */

	  var size = 0;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var buffer;

	  for (i = 0, il = member.length; i < il; ++i) {
	    size += member[i].data.length;
	  }

	  {
	    buffer = new Uint8Array(size);

	    for (i = 0; i < il; ++i) {
	      buffer.set(member[i].data, p);
	      p += member[i].data.length;
	    }
	  }

	  return buffer;
	};
	/**
	 * @constructor
	 */


	Zlib$1.GunzipMember = function () {
	  /** @type {number} signature first byte. */
	  this.id1;
	  /** @type {number} signature second byte. */

	  this.id2;
	  /** @type {number} compression method. */

	  this.cm;
	  /** @type {number} flags. */

	  this.flg;
	  /** @type {Date} modification time. */

	  this.mtime;
	  /** @type {number} extra flags. */

	  this.xfl;
	  /** @type {number} operating system number. */

	  this.os;
	  /** @type {number} CRC-16 value for FHCRC flag. */

	  this.crc16;
	  /** @type {number} extra length. */

	  this.xlen;
	  /** @type {number} CRC-32 value for verification. */

	  this.crc32;
	  /** @type {number} input size modulo 32 value. */

	  this.isize;
	  /** @type {string} filename. */

	  this.name;
	  /** @type {string} comment. */

	  this.comment;
	  /** @type {!(Uint8Array|Array.<number>)} */

	  this.data;
	};

	Zlib$1.GunzipMember.prototype.getName = function () {
	  return this.name;
	};

	Zlib$1.GunzipMember.prototype.getData = function () {
	  return this.data;
	};

	Zlib$1.GunzipMember.prototype.getMtime = function () {
	  return this.mtime;
	};
	/**
	 * @fileoverview GZIP (RFC1952) 実装.
	 */

	/**
	 * @constructor
	 * @param {!(Array|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params option parameters.
	 */


	Zlib$1.Gzip = function (input, opt_params) {
	  /** @type {!(Array.<number>|Uint8Array)} input buffer. */
	  this.input = input;
	  /** @type {number} input buffer pointer. */

	  this.ip = 0;
	  /** @type {!(Array.<number>|Uint8Array)} output buffer. */

	  this.output;
	  /** @type {number} output buffer. */

	  this.op = 0;
	  /** @type {!Object} flags option flags. */

	  this.flags = {};
	  /** @type {!string} filename. */

	  this.filename;
	  /** @type {!string} comment. */

	  this.comment;
	  /** @type {!Object} deflate options. */

	  this.deflateOptions; // option parameters

	  if (opt_params) {
	    if (opt_params['flags']) {
	      this.flags = opt_params['flags'];
	    }

	    if (typeof opt_params['filename'] === 'string') {
	      this.filename = opt_params['filename'];
	    }

	    if (typeof opt_params['comment'] === 'string') {
	      this.comment = opt_params['comment'];
	    }

	    if (opt_params['deflateOptions']) {
	      this.deflateOptions = opt_params['deflateOptions'];
	    }
	  }

	  if (!this.deflateOptions) {
	    this.deflateOptions = {};
	  }
	};
	/**
	 * @type {number}
	 * @const
	 */


	Zlib$1.Gzip.DefaultBufferSize = 0x8000;
	/**
	 * encode gzip members.
	 * @return {!(Array|Uint8Array)} gzip binary array.
	 */

	Zlib$1.Gzip.prototype.compress = function () {
	  /** @type {number} flags. */
	  var flg;
	  /** @type {number} modification time. */

	  var mtime;
	  /** @type {number} CRC-16 value for FHCRC flag. */

	  var crc16;
	  /** @type {number} CRC-32 value for verification. */

	  var crc32;
	  /** @type {!Zlib.RawDeflate} raw deflate object. */

	  var rawdeflate;
	  /** @type {number} character code */

	  var c;
	  /** @type {number} loop counter. */

	  var i;
	  /** @type {number} loop limiter. */

	  var il;
	  /** @type {!(Array|Uint8Array)} output buffer. */

	  var output = new ( Uint8Array )(Zlib$1.Gzip.DefaultBufferSize);
	  /** @type {number} output buffer pointer. */

	  var op = 0;
	  var input = this.input;
	  var ip = this.ip;
	  var filename = this.filename;
	  var comment = this.comment; // check signature

	  output[op++] = 0x1f;
	  output[op++] = 0x8b; // check compression method

	  output[op++] = 8;
	  /* XXX: use Zlib const */
	  // flags

	  flg = 0;
	  if (this.flags['fname']) flg |= Zlib$1.Gzip.FlagsMask.FNAME;
	  if (this.flags['fcomment']) flg |= Zlib$1.Gzip.FlagsMask.FCOMMENT;
	  if (this.flags['fhcrc']) flg |= Zlib$1.Gzip.FlagsMask.FHCRC; // XXX: FTEXT
	  // XXX: FEXTRA

	  output[op++] = flg; // modification time

	  mtime = (Date.now ? Date.now() : +new Date()) / 1000 | 0;
	  output[op++] = mtime & 0xff;
	  output[op++] = mtime >>> 8 & 0xff;
	  output[op++] = mtime >>> 16 & 0xff;
	  output[op++] = mtime >>> 24 & 0xff; // extra flags

	  output[op++] = 0; // operating system

	  output[op++] = Zlib$1.Gzip.OperatingSystem.UNKNOWN; // extra

	  /* NOP */
	  // fname

	  if (this.flags['fname'] !== void 0) {
	    for (i = 0, il = filename.length; i < il; ++i) {
	      c = filename.charCodeAt(i);

	      if (c > 0xff) {
	        output[op++] = c >>> 8 & 0xff;
	      }

	      output[op++] = c & 0xff;
	    }

	    output[op++] = 0; // null termination
	  } // fcomment


	  if (this.flags['comment']) {
	    for (i = 0, il = comment.length; i < il; ++i) {
	      c = comment.charCodeAt(i);

	      if (c > 0xff) {
	        output[op++] = c >>> 8 & 0xff;
	      }

	      output[op++] = c & 0xff;
	    }

	    output[op++] = 0; // null termination
	  } // fhcrc


	  if (this.flags['fhcrc']) {
	    crc16 = Zlib$1.CRC32.calc(output, 0, op) & 0xffff;
	    output[op++] = crc16 & 0xff;
	    output[op++] = crc16 >>> 8 & 0xff;
	  } // add compress option


	  this.deflateOptions['outputBuffer'] = output;
	  this.deflateOptions['outputIndex'] = op; // compress

	  rawdeflate = new Zlib$1.RawDeflate(input, this.deflateOptions);
	  output = rawdeflate.compress();
	  op = rawdeflate.op; // expand buffer

	  {
	    if (op + 8 > output.buffer.byteLength) {
	      this.output = new Uint8Array(op + 8);
	      this.output.set(new Uint8Array(output.buffer));
	      output = this.output;
	    } else {
	      output = new Uint8Array(output.buffer);
	    }
	  } // crc32


	  crc32 = Zlib$1.CRC32.calc(input);
	  output[op++] = crc32 & 0xff;
	  output[op++] = crc32 >>> 8 & 0xff;
	  output[op++] = crc32 >>> 16 & 0xff;
	  output[op++] = crc32 >>> 24 & 0xff; // input size

	  il = input.length;
	  output[op++] = il & 0xff;
	  output[op++] = il >>> 8 & 0xff;
	  output[op++] = il >>> 16 & 0xff;
	  output[op++] = il >>> 24 & 0xff;
	  this.ip = ip;

	  if ( op < output.length) {
	    this.output = output = output.subarray(0, op);
	  }

	  return output;
	};
	/** @enum {number} */


	Zlib$1.Gzip.OperatingSystem = {
	  FAT: 0,
	  AMIGA: 1,
	  VMS: 2,
	  UNIX: 3,
	  VM_CMS: 4,
	  ATARI_TOS: 5,
	  HPFS: 6,
	  MACINTOSH: 7,
	  Z_SYSTEM: 8,
	  CP_M: 9,
	  TOPS_20: 10,
	  NTFS: 11,
	  QDOS: 12,
	  ACORN_RISCOS: 13,
	  UNKNOWN: 255
	};
	/** @enum {number} */

	Zlib$1.Gzip.FlagsMask = {
	  FTEXT: 0x01,
	  FHCRC: 0x02,
	  FEXTRA: 0x04,
	  FNAME: 0x08,
	  FCOMMENT: 0x10
	};
	/**
	 * @fileoverview Heap Sort 実装. ハフマン符号化で使用する.
	 */

	/**
	 * カスタムハフマン符号で使用するヒープ実装
	 * @param {number} length ヒープサイズ.
	 * @constructor
	 */

	Zlib$1.Heap = function (length) {
	  this.buffer = new ( Uint16Array )(length * 2);
	  this.length = 0;
	};
	/**
	 * 親ノードの index 取得
	 * @param {number} index 子ノードの index.
	 * @return {number} 親ノードの index.
	 *
	 */


	Zlib$1.Heap.prototype.getParent = function (index) {
	  return ((index - 2) / 4 | 0) * 2;
	};
	/**
	 * 子ノードの index 取得
	 * @param {number} index 親ノードの index.
	 * @return {number} 子ノードの index.
	 */


	Zlib$1.Heap.prototype.getChild = function (index) {
	  return 2 * index + 2;
	};
	/**
	 * Heap に値を追加する
	 * @param {number} index キー index.
	 * @param {number} value 値.
	 * @return {number} 現在のヒープ長.
	 */


	Zlib$1.Heap.prototype.push = function (index, value) {
	  var current,
	      parent,
	      heap = this.buffer,
	      swap;
	  current = this.length;
	  heap[this.length++] = value;
	  heap[this.length++] = index; // ルートノードにたどり着くまで入れ替えを試みる

	  while (current > 0) {
	    parent = this.getParent(current); // 親ノードと比較して親の方が小さければ入れ替える

	    if (heap[current] > heap[parent]) {
	      swap = heap[current];
	      heap[current] = heap[parent];
	      heap[parent] = swap;
	      swap = heap[current + 1];
	      heap[current + 1] = heap[parent + 1];
	      heap[parent + 1] = swap;
	      current = parent; // 入れ替えが必要なくなったらそこで抜ける
	    } else {
	      break;
	    }
	  }

	  return this.length;
	};
	/**
	 * Heapから一番大きい値を返す
	 * @return {{index: number, value: number, length: number}} {index: キーindex,
	 *     value: 値, length: ヒープ長} の Object.
	 */


	Zlib$1.Heap.prototype.pop = function () {
	  var index,
	      value,
	      heap = this.buffer,
	      swap,
	      current,
	      parent;
	  value = heap[0];
	  index = heap[1]; // 後ろから値を取る

	  this.length -= 2;
	  heap[0] = heap[this.length];
	  heap[1] = heap[this.length + 1];
	  parent = 0; // ルートノードから下がっていく

	  while (true) {
	    current = this.getChild(parent); // 範囲チェック

	    if (current >= this.length) {
	      break;
	    } // 隣のノードと比較して、隣の方が値が大きければ隣を現在ノードとして選択


	    if (current + 2 < this.length && heap[current + 2] > heap[current]) {
	      current += 2;
	    } // 親ノードと比較して親の方が小さい場合は入れ替える


	    if (heap[current] > heap[parent]) {
	      swap = heap[parent];
	      heap[parent] = heap[current];
	      heap[current] = swap;
	      swap = heap[parent + 1];
	      heap[parent + 1] = heap[current + 1];
	      heap[current + 1] = swap;
	    } else {
	      break;
	    }

	    parent = current;
	  }

	  return {
	    index: index,
	    value: value,
	    length: this.length
	  };
	};
	/* vim:set expandtab ts=2 sw=2 tw=80: */

	/**
	 * @fileoverview Deflate (RFC1951) 符号化アルゴリズム実装.
	 */

	/**
	 * Raw Deflate 実装
	 *
	 * @constructor
	 * @param {!(Array.<number>|Uint8Array)} input 符号化する対象のバッファ.
	 * @param {Object=} opt_params option parameters.
	 *
	 * typed array が使用可能なとき、outputBuffer が Array は自動的に Uint8Array に
	 * 変換されます.
	 * 別のオブジェクトになるため出力バッファを参照している変数などは
	 * 更新する必要があります.
	 */


	Zlib$1.RawDeflate = function (input, opt_params) {
	  /** @type {Zlib.RawDeflate.CompressionType} */
	  this.compressionType = Zlib$1.RawDeflate.CompressionType.DYNAMIC;
	  /** @type {number} */

	  this.lazy = 0;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  this.freqsLitLen;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  this.freqsDist;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.input =  input instanceof Array ? new Uint8Array(input) : input;
	  /** @type {!(Array.<number>|Uint8Array)} output output buffer. */

	  this.output;
	  /** @type {number} pos output buffer position. */

	  this.op = 0; // option parameters

	  if (opt_params) {
	    if (opt_params['lazy']) {
	      this.lazy = opt_params['lazy'];
	    }

	    if (typeof opt_params['compressionType'] === 'number') {
	      this.compressionType = opt_params['compressionType'];
	    }

	    if (opt_params['outputBuffer']) {
	      this.output =  opt_params['outputBuffer'] instanceof Array ? new Uint8Array(opt_params['outputBuffer']) : opt_params['outputBuffer'];
	    }

	    if (typeof opt_params['outputIndex'] === 'number') {
	      this.op = opt_params['outputIndex'];
	    }
	  }

	  if (!this.output) {
	    this.output = new ( Uint8Array )(0x8000);
	  }
	};
	/**
	 * @enum {number}
	 */


	Zlib$1.RawDeflate.CompressionType = {
	  NONE: 0,
	  FIXED: 1,
	  DYNAMIC: 2,
	  RESERVED: 3
	};
	/**
	 * LZ77 の最小マッチ長
	 * @const
	 * @type {number}
	 */

	Zlib$1.RawDeflate.Lz77MinLength = 3;
	/**
	 * LZ77 の最大マッチ長
	 * @const
	 * @type {number}
	 */

	Zlib$1.RawDeflate.Lz77MaxLength = 258;
	/**
	 * LZ77 のウィンドウサイズ
	 * @const
	 * @type {number}
	 */

	Zlib$1.RawDeflate.WindowSize = 0x8000;
	/**
	 * 最長の符号長
	 * @const
	 * @type {number}
	 */

	Zlib$1.RawDeflate.MaxCodeLength = 16;
	/**
	 * ハフマン符号の最大数値
	 * @const
	 * @type {number}
	 */

	Zlib$1.RawDeflate.HUFMAX = 286;
	/**
	 * 固定ハフマン符号の符号化テーブル
	 * @const
	 * @type {Array.<Array.<number, number>>}
	 */

	Zlib$1.RawDeflate.FixedHuffmanTable = function () {
	  var table = [],
	      i;

	  for (i = 0; i < 288; i++) {
	    switch (true) {
	      case i <= 143:
	        table.push([i + 0x030, 8]);
	        break;

	      case i <= 255:
	        table.push([i - 144 + 0x190, 9]);
	        break;

	      case i <= 279:
	        table.push([i - 256 + 0x000, 7]);
	        break;

	      case i <= 287:
	        table.push([i - 280 + 0x0C0, 8]);
	        break;

	      default:
	        throw 'invalid literal: ' + i;
	    }
	  }

	  return table;
	}();
	/**
	 * DEFLATE ブロックの作成
	 * @return {!(Array.<number>|Uint8Array)} 圧縮済み byte array.
	 */


	Zlib$1.RawDeflate.prototype.compress = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var blockArray;
	  /** @type {number} */

	  var position;
	  /** @type {number} */

	  var length;
	  var input = this.input; // compression

	  switch (this.compressionType) {
	    case Zlib$1.RawDeflate.CompressionType.NONE:
	      // each 65535-Byte (length header: 16-bit)
	      for (position = 0, length = input.length; position < length;) {
	        blockArray =  input.subarray(position, position + 0xffff) ;
	        position += blockArray.length;
	        this.makeNocompressBlock(blockArray, position === length);
	      }

	      break;

	    case Zlib$1.RawDeflate.CompressionType.FIXED:
	      this.output = this.makeFixedHuffmanBlock(input, true);
	      this.op = this.output.length;
	      break;

	    case Zlib$1.RawDeflate.CompressionType.DYNAMIC:
	      this.output = this.makeDynamicHuffmanBlock(input, true);
	      this.op = this.output.length;
	      break;

	    default:
	      throw 'invalid compression type';
	  }

	  return this.output;
	};
	/**
	 * 非圧縮ブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 非圧縮ブロック byte array.
	 */


	Zlib$1.RawDeflate.prototype.makeNocompressBlock = function (blockArray, isFinalBlock) {
	  /** @type {number} */
	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {number} */

	  var len;
	  /** @type {number} */

	  var nlen;
	  var output = this.output;
	  var op = this.op; // expand buffer

	  {
	    output = new Uint8Array(this.output.buffer);

	    while (output.length <= op + blockArray.length + 5) {
	      output = new Uint8Array(output.length << 1);
	    }

	    output.set(this.output);
	  } // header


	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib$1.RawDeflate.CompressionType.NONE;
	  output[op++] = bfinal | btype << 1; // length

	  len = blockArray.length;
	  nlen = ~len + 0x10000 & 0xffff;
	  output[op++] = len & 0xff;
	  output[op++] = len >>> 8 & 0xff;
	  output[op++] = nlen & 0xff;
	  output[op++] = nlen >>> 8 & 0xff; // copy buffer

	  {
	    output.set(blockArray, op);
	    op += blockArray.length;
	    output = output.subarray(0, op);
	  }

	  this.op = op;
	  this.output = output;
	  return output;
	};
	/**
	 * 固定ハフマンブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 固定ハフマン符号化ブロック byte array.
	 */


	Zlib$1.RawDeflate.prototype.makeFixedHuffmanBlock = function (blockArray, isFinalBlock) {
	  /** @type {Zlib.BitStream} */
	  var stream = new Zlib$1.BitStream( new Uint8Array(this.output.buffer) , this.op);
	  /** @type {number} */

	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var data; // header

	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib$1.RawDeflate.CompressionType.FIXED;
	  stream.writeBits(bfinal, 1, true);
	  stream.writeBits(btype, 2, true);
	  data = this.lz77(blockArray);
	  this.fixedHuffman(data, stream);
	  return stream.finish();
	};
	/**
	 * 動的ハフマンブロックの作成
	 * @param {!(Array.<number>|Uint8Array)} blockArray ブロックデータ byte array.
	 * @param {!boolean} isFinalBlock 最後のブロックならばtrue.
	 * @return {!(Array.<number>|Uint8Array)} 動的ハフマン符号ブロック byte array.
	 */


	Zlib$1.RawDeflate.prototype.makeDynamicHuffmanBlock = function (blockArray, isFinalBlock) {
	  /** @type {Zlib.BitStream} */
	  var stream = new Zlib$1.BitStream( new Uint8Array(this.output.buffer) , this.op);
	  /** @type {number} */

	  var bfinal;
	  /** @type {Zlib.RawDeflate.CompressionType} */

	  var btype;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var data;
	  /** @type {number} */

	  var hlit;
	  /** @type {number} */

	  var hdist;
	  /** @type {number} */

	  var hclen;
	  /** @const @type {Array.<number>} */

	  var hclenOrder = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var litLenLengths;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var litLenCodes;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var distLengths;
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var distCodes;
	  /** @type {{
	   *   codes: !(Array.<number>|Uint32Array),
	   *   freqs: !(Array.<number>|Uint8Array)
	   * }} */

	  var treeSymbols;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var treeLengths;
	  /** @type {Array} */

	  var transLengths = new Array(19);
	  /** @type {!(Array.<number>|Uint16Array)} */

	  var treeCodes;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var bitlen;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il; // header

	  bfinal = isFinalBlock ? 1 : 0;
	  btype = Zlib$1.RawDeflate.CompressionType.DYNAMIC;
	  stream.writeBits(bfinal, 1, true);
	  stream.writeBits(btype, 2, true);
	  data = this.lz77(blockArray); // リテラル・長さ, 距離のハフマン符号と符号長の算出

	  litLenLengths = this.getLengths_(this.freqsLitLen, 15);
	  litLenCodes = this.getCodesFromLengths_(litLenLengths);
	  distLengths = this.getLengths_(this.freqsDist, 7);
	  distCodes = this.getCodesFromLengths_(distLengths); // HLIT, HDIST の決定

	  for (hlit = 286; hlit > 257 && litLenLengths[hlit - 1] === 0; hlit--) {}

	  for (hdist = 30; hdist > 1 && distLengths[hdist - 1] === 0; hdist--) {} // HCLEN


	  treeSymbols = this.getTreeSymbols_(hlit, litLenLengths, hdist, distLengths);
	  treeLengths = this.getLengths_(treeSymbols.freqs, 7);

	  for (i = 0; i < 19; i++) {
	    transLengths[i] = treeLengths[hclenOrder[i]];
	  }

	  for (hclen = 19; hclen > 4 && transLengths[hclen - 1] === 0; hclen--) {}

	  treeCodes = this.getCodesFromLengths_(treeLengths); // 出力

	  stream.writeBits(hlit - 257, 5, true);
	  stream.writeBits(hdist - 1, 5, true);
	  stream.writeBits(hclen - 4, 4, true);

	  for (i = 0; i < hclen; i++) {
	    stream.writeBits(transLengths[i], 3, true);
	  } // ツリーの出力


	  for (i = 0, il = treeSymbols.codes.length; i < il; i++) {
	    code = treeSymbols.codes[i];
	    stream.writeBits(treeCodes[code], treeLengths[code], true); // extra bits

	    if (code >= 16) {
	      i++;

	      switch (code) {
	        case 16:
	          bitlen = 2;
	          break;

	        case 17:
	          bitlen = 3;
	          break;

	        case 18:
	          bitlen = 7;
	          break;

	        default:
	          throw 'invalid code: ' + code;
	      }

	      stream.writeBits(treeSymbols.codes[i], bitlen, true);
	    }
	  }

	  this.dynamicHuffman(data, [litLenCodes, litLenLengths], [distCodes, distLengths], stream);
	  return stream.finish();
	};
	/**
	 * 動的ハフマン符号化(カスタムハフマンテーブル)
	 * @param {!(Array.<number>|Uint16Array)} dataArray LZ77 符号化済み byte array.
	 * @param {!Zlib.BitStream} stream 書き込み用ビットストリーム.
	 * @return {!Zlib.BitStream} ハフマン符号化済みビットストリームオブジェクト.
	 */


	Zlib$1.RawDeflate.prototype.dynamicHuffman = function (dataArray, litLen, dist, stream) {
	  /** @type {number} */
	  var index;
	  /** @type {number} */

	  var length;
	  /** @type {number} */

	  var literal;
	  /** @type {number} */

	  var code;
	  /** @type {number} */

	  var litLenCodes;
	  /** @type {number} */

	  var litLenLengths;
	  /** @type {number} */

	  var distCodes;
	  /** @type {number} */

	  var distLengths;
	  litLenCodes = litLen[0];
	  litLenLengths = litLen[1];
	  distCodes = dist[0];
	  distLengths = dist[1]; // 符号を BitStream に書き込んでいく

	  for (index = 0, length = dataArray.length; index < length; ++index) {
	    literal = dataArray[index]; // literal or length

	    stream.writeBits(litLenCodes[literal], litLenLengths[literal], true); // 長さ・距離符号

	    if (literal > 256) {
	      // length extra
	      stream.writeBits(dataArray[++index], dataArray[++index], true); // distance

	      code = dataArray[++index];
	      stream.writeBits(distCodes[code], distLengths[code], true); // distance extra

	      stream.writeBits(dataArray[++index], dataArray[++index], true); // 終端
	    } else if (literal === 256) {
	      break;
	    }
	  }

	  return stream;
	};
	/**
	 * 固定ハフマン符号化
	 * @param {!(Array.<number>|Uint16Array)} dataArray LZ77 符号化済み byte array.
	 * @param {!Zlib.BitStream} stream 書き込み用ビットストリーム.
	 * @return {!Zlib.BitStream} ハフマン符号化済みビットストリームオブジェクト.
	 */


	Zlib$1.RawDeflate.prototype.fixedHuffman = function (dataArray, stream) {
	  /** @type {number} */
	  var index;
	  /** @type {number} */

	  var length;
	  /** @type {number} */

	  var literal; // 符号を BitStream に書き込んでいく

	  for (index = 0, length = dataArray.length; index < length; index++) {
	    literal = dataArray[index]; // 符号の書き込み

	    Zlib$1.BitStream.prototype.writeBits.apply(stream, Zlib$1.RawDeflate.FixedHuffmanTable[literal]); // 長さ・距離符号

	    if (literal > 0x100) {
	      // length extra
	      stream.writeBits(dataArray[++index], dataArray[++index], true); // distance

	      stream.writeBits(dataArray[++index], 5); // distance extra

	      stream.writeBits(dataArray[++index], dataArray[++index], true); // 終端
	    } else if (literal === 0x100) {
	      break;
	    }
	  }

	  return stream;
	};
	/**
	 * マッチ情報
	 * @param {!number} length マッチした長さ.
	 * @param {!number} backwardDistance マッチ位置との距離.
	 * @constructor
	 */


	Zlib$1.RawDeflate.Lz77Match = function (length, backwardDistance) {
	  /** @type {number} match length. */
	  this.length = length;
	  /** @type {number} backward distance. */

	  this.backwardDistance = backwardDistance;
	};
	/**
	 * 長さ符号テーブル.
	 * [コード, 拡張ビット, 拡張ビット長] の配列となっている.
	 * @const
	 * @type {!(Array.<number>|Uint32Array)}
	 */


	Zlib$1.RawDeflate.Lz77Match.LengthCodeTable = function (table) {
	  return  new Uint32Array(table) ;
	}(function () {
	  /** @type {!Array} */
	  var table = [];
	  /** @type {number} */

	  var i;
	  /** @type {!Array.<number>} */

	  var c;

	  for (i = 3; i <= 258; i++) {
	    c = code(i);
	    table[i] = c[2] << 24 | c[1] << 16 | c[0];
	  }
	  /**
	   * @param {number} length lz77 length.
	   * @return {!Array.<number>} lz77 codes.
	   */


	  function code(length) {
	    switch (true) {
	      case length === 3:
	        return [257, length - 3, 0];

	      case length === 4:
	        return [258, length - 4, 0];

	      case length === 5:
	        return [259, length - 5, 0];

	      case length === 6:
	        return [260, length - 6, 0];

	      case length === 7:
	        return [261, length - 7, 0];

	      case length === 8:
	        return [262, length - 8, 0];

	      case length === 9:
	        return [263, length - 9, 0];

	      case length === 10:
	        return [264, length - 10, 0];

	      case length <= 12:
	        return [265, length - 11, 1];

	      case length <= 14:
	        return [266, length - 13, 1];

	      case length <= 16:
	        return [267, length - 15, 1];

	      case length <= 18:
	        return [268, length - 17, 1];

	      case length <= 22:
	        return [269, length - 19, 2];

	      case length <= 26:
	        return [270, length - 23, 2];

	      case length <= 30:
	        return [271, length - 27, 2];

	      case length <= 34:
	        return [272, length - 31, 2];

	      case length <= 42:
	        return [273, length - 35, 3];

	      case length <= 50:
	        return [274, length - 43, 3];

	      case length <= 58:
	        return [275, length - 51, 3];

	      case length <= 66:
	        return [276, length - 59, 3];

	      case length <= 82:
	        return [277, length - 67, 4];

	      case length <= 98:
	        return [278, length - 83, 4];

	      case length <= 114:
	        return [279, length - 99, 4];

	      case length <= 130:
	        return [280, length - 115, 4];

	      case length <= 162:
	        return [281, length - 131, 5];

	      case length <= 194:
	        return [282, length - 163, 5];

	      case length <= 226:
	        return [283, length - 195, 5];

	      case length <= 257:
	        return [284, length - 227, 5];

	      case length === 258:
	        return [285, length - 258, 0];

	      default:
	        throw 'invalid length: ' + length;
	    }
	  }

	  return table;
	}());
	/**
	 * 距離符号テーブル
	 * @param {!number} dist 距離.
	 * @return {!Array.<number>} コード、拡張ビット、拡張ビット長の配列.
	 * @private
	 */


	Zlib$1.RawDeflate.Lz77Match.prototype.getDistanceCode_ = function (dist) {
	  /** @type {!Array.<number>} distance code table. */
	  var r;

	  switch (true) {
	    case dist === 1:
	      r = [0, dist - 1, 0];
	      break;

	    case dist === 2:
	      r = [1, dist - 2, 0];
	      break;

	    case dist === 3:
	      r = [2, dist - 3, 0];
	      break;

	    case dist === 4:
	      r = [3, dist - 4, 0];
	      break;

	    case dist <= 6:
	      r = [4, dist - 5, 1];
	      break;

	    case dist <= 8:
	      r = [5, dist - 7, 1];
	      break;

	    case dist <= 12:
	      r = [6, dist - 9, 2];
	      break;

	    case dist <= 16:
	      r = [7, dist - 13, 2];
	      break;

	    case dist <= 24:
	      r = [8, dist - 17, 3];
	      break;

	    case dist <= 32:
	      r = [9, dist - 25, 3];
	      break;

	    case dist <= 48:
	      r = [10, dist - 33, 4];
	      break;

	    case dist <= 64:
	      r = [11, dist - 49, 4];
	      break;

	    case dist <= 96:
	      r = [12, dist - 65, 5];
	      break;

	    case dist <= 128:
	      r = [13, dist - 97, 5];
	      break;

	    case dist <= 192:
	      r = [14, dist - 129, 6];
	      break;

	    case dist <= 256:
	      r = [15, dist - 193, 6];
	      break;

	    case dist <= 384:
	      r = [16, dist - 257, 7];
	      break;

	    case dist <= 512:
	      r = [17, dist - 385, 7];
	      break;

	    case dist <= 768:
	      r = [18, dist - 513, 8];
	      break;

	    case dist <= 1024:
	      r = [19, dist - 769, 8];
	      break;

	    case dist <= 1536:
	      r = [20, dist - 1025, 9];
	      break;

	    case dist <= 2048:
	      r = [21, dist - 1537, 9];
	      break;

	    case dist <= 3072:
	      r = [22, dist - 2049, 10];
	      break;

	    case dist <= 4096:
	      r = [23, dist - 3073, 10];
	      break;

	    case dist <= 6144:
	      r = [24, dist - 4097, 11];
	      break;

	    case dist <= 8192:
	      r = [25, dist - 6145, 11];
	      break;

	    case dist <= 12288:
	      r = [26, dist - 8193, 12];
	      break;

	    case dist <= 16384:
	      r = [27, dist - 12289, 12];
	      break;

	    case dist <= 24576:
	      r = [28, dist - 16385, 13];
	      break;

	    case dist <= 32768:
	      r = [29, dist - 24577, 13];
	      break;

	    default:
	      throw 'invalid distance';
	  }

	  return r;
	};
	/**
	 * マッチ情報を LZ77 符号化配列で返す.
	 * なお、ここでは以下の内部仕様で符号化している
	 * [ CODE, EXTRA-BIT-LEN, EXTRA, CODE, EXTRA-BIT-LEN, EXTRA ]
	 * @return {!Array.<number>} LZ77 符号化 byte array.
	 */


	Zlib$1.RawDeflate.Lz77Match.prototype.toLz77Array = function () {
	  /** @type {number} */
	  var length = this.length;
	  /** @type {number} */

	  var dist = this.backwardDistance;
	  /** @type {Array} */

	  var codeArray = [];
	  /** @type {number} */

	  var pos = 0;
	  /** @type {!Array.<number>} */

	  var code; // length

	  code = Zlib$1.RawDeflate.Lz77Match.LengthCodeTable[length];
	  codeArray[pos++] = code & 0xffff;
	  codeArray[pos++] = code >> 16 & 0xff;
	  codeArray[pos++] = code >> 24; // distance

	  code = this.getDistanceCode_(dist);
	  codeArray[pos++] = code[0];
	  codeArray[pos++] = code[1];
	  codeArray[pos++] = code[2];
	  return codeArray;
	};
	/**
	 * LZ77 実装
	 * @param {!(Array.<number>|Uint8Array)} dataArray LZ77 符号化するバイト配列.
	 * @return {!(Array.<number>|Uint16Array)} LZ77 符号化した配列.
	 */


	Zlib$1.RawDeflate.prototype.lz77 = function (dataArray) {
	  /** @type {number} input position */
	  var position;
	  /** @type {number} input length */

	  var length;
	  /** @type {number} loop counter */

	  var i;
	  /** @type {number} loop limiter */

	  var il;
	  /** @type {number} chained-hash-table key */

	  var matchKey;
	  /** @type {Object.<number, Array.<number>>} chained-hash-table */

	  var table = {};
	  /** @const @type {number} */

	  var windowSize = Zlib$1.RawDeflate.WindowSize;
	  /** @type {Array.<number>} match list */

	  var matchList;
	  /** @type {Zlib.RawDeflate.Lz77Match} longest match */

	  var longestMatch;
	  /** @type {Zlib.RawDeflate.Lz77Match} previous longest match */

	  var prevMatch;
	  /** @type {!(Array.<number>|Uint16Array)} lz77 buffer */

	  var lz77buf =  new Uint16Array(dataArray.length * 2) ;
	  /** @type {number} lz77 output buffer pointer */

	  var pos = 0;
	  /** @type {number} lz77 skip length */

	  var skipLength = 0;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var freqsLitLen = new ( Uint32Array )(286);
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var freqsDist = new ( Uint32Array )(30);
	  /** @type {number} */

	  var lazy = this.lazy;
	  /** @type {*} temporary variable */

	  var tmp; // 初期化

	  freqsLitLen[256] = 1; // EOB の最低出現回数は 1

	  /**
	   * マッチデータの書き込み
	   * @param {Zlib.RawDeflate.Lz77Match} match LZ77 Match data.
	   * @param {!number} offset スキップ開始位置(相対指定).
	   * @private
	   */

	  function writeMatch(match, offset) {
	    /** @type {Array.<number>} */
	    var lz77Array = match.toLz77Array();
	    /** @type {number} */

	    var i;
	    /** @type {number} */

	    var il;

	    for (i = 0, il = lz77Array.length; i < il; ++i) {
	      lz77buf[pos++] = lz77Array[i];
	    }

	    freqsLitLen[lz77Array[0]]++;
	    freqsDist[lz77Array[3]]++;
	    skipLength = match.length + offset - 1;
	    prevMatch = null;
	  } // LZ77 符号化


	  for (position = 0, length = dataArray.length; position < length; ++position) {
	    // ハッシュキーの作成
	    for (matchKey = 0, i = 0, il = Zlib$1.RawDeflate.Lz77MinLength; i < il; ++i) {
	      if (position + i === length) {
	        break;
	      }

	      matchKey = matchKey << 8 | dataArray[position + i];
	    } // テーブルが未定義だったら作成する


	    if (table[matchKey] === void 0) {
	      table[matchKey] = [];
	    }

	    matchList = table[matchKey]; // skip

	    if (skipLength-- > 0) {
	      matchList.push(position);
	      continue;
	    } // マッチテーブルの更新 (最大戻り距離を超えているものを削除する)


	    while (matchList.length > 0 && position - matchList[0] > windowSize) {
	      matchList.shift();
	    } // データ末尾でマッチしようがない場合はそのまま流しこむ


	    if (position + Zlib$1.RawDeflate.Lz77MinLength >= length) {
	      if (prevMatch) {
	        writeMatch(prevMatch, -1);
	      }

	      for (i = 0, il = length - position; i < il; ++i) {
	        tmp = dataArray[position + i];
	        lz77buf[pos++] = tmp;
	        ++freqsLitLen[tmp];
	      }

	      break;
	    } // マッチ候補から最長のものを探す


	    if (matchList.length > 0) {
	      longestMatch = this.searchLongestMatch_(dataArray, position, matchList);

	      if (prevMatch) {
	        // 現在のマッチの方が前回のマッチよりも長い
	        if (prevMatch.length < longestMatch.length) {
	          // write previous literal
	          tmp = dataArray[position - 1];
	          lz77buf[pos++] = tmp;
	          ++freqsLitLen[tmp]; // write current match

	          writeMatch(longestMatch, 0);
	        } else {
	          // write previous match
	          writeMatch(prevMatch, -1);
	        }
	      } else if (longestMatch.length < lazy) {
	        prevMatch = longestMatch;
	      } else {
	        writeMatch(longestMatch, 0);
	      } // 前回マッチしていて今回マッチがなかったら前回のを採用

	    } else if (prevMatch) {
	      writeMatch(prevMatch, -1);
	    } else {
	      tmp = dataArray[position];
	      lz77buf[pos++] = tmp;
	      ++freqsLitLen[tmp];
	    }

	    matchList.push(position); // マッチテーブルに現在の位置を保存
	  } // 終端処理


	  lz77buf[pos++] = 256;
	  freqsLitLen[256]++;
	  this.freqsLitLen = freqsLitLen;
	  this.freqsDist = freqsDist;
	  return (
	    /** @type {!(Uint16Array|Array.<number>)} */
	     lz77buf.subarray(0, pos) 
	  );
	};
	/**
	 * マッチした候補の中から最長一致を探す
	 * @param {!Object} data plain data byte array.
	 * @param {!number} position plain data byte array position.
	 * @param {!Array.<number>} matchList 候補となる位置の配列.
	 * @return {!Zlib.RawDeflate.Lz77Match} 最長かつ最短距離のマッチオブジェクト.
	 * @private
	 */


	Zlib$1.RawDeflate.prototype.searchLongestMatch_ = function (data, position, matchList) {
	  var match,
	      currentMatch,
	      matchMax = 0,
	      matchLength,
	      i,
	      j,
	      l,
	      dl = data.length; // 候補を後ろから 1 つずつ絞り込んでゆく

	  permatch: for (i = 0, l = matchList.length; i < l; i++) {
	    match = matchList[l - i - 1];
	    matchLength = Zlib$1.RawDeflate.Lz77MinLength; // 前回までの最長一致を末尾から一致検索する

	    if (matchMax > Zlib$1.RawDeflate.Lz77MinLength) {
	      for (j = matchMax; j > Zlib$1.RawDeflate.Lz77MinLength; j--) {
	        if (data[match + j - 1] !== data[position + j - 1]) {
	          continue permatch;
	        }
	      }

	      matchLength = matchMax;
	    } // 最長一致探索


	    while (matchLength < Zlib$1.RawDeflate.Lz77MaxLength && position + matchLength < dl && data[match + matchLength] === data[position + matchLength]) {
	      ++matchLength;
	    } // マッチ長が同じ場合は後方を優先


	    if (matchLength > matchMax) {
	      currentMatch = match;
	      matchMax = matchLength;
	    } // 最長が確定したら後の処理は省略


	    if (matchLength === Zlib$1.RawDeflate.Lz77MaxLength) {
	      break;
	    }
	  }

	  return new Zlib$1.RawDeflate.Lz77Match(matchMax, position - currentMatch);
	};
	/**
	 * Tree-Transmit Symbols の算出
	 * reference: PuTTY Deflate implementation
	 * @param {number} hlit HLIT.
	 * @param {!(Array.<number>|Uint8Array)} litlenLengths リテラルと長さ符号の符号長配列.
	 * @param {number} hdist HDIST.
	 * @param {!(Array.<number>|Uint8Array)} distLengths 距離符号の符号長配列.
	 * @return {{
	 *   codes: !(Array.<number>|Uint32Array),
	 *   freqs: !(Array.<number>|Uint8Array)
	 * }} Tree-Transmit Symbols.
	 */


	Zlib$1.RawDeflate.prototype.getTreeSymbols_ = function (hlit, litlenLengths, hdist, distLengths) {
	  var src = new ( Uint32Array )(hlit + hdist),
	      i,
	      j,
	      runLength,
	      l,
	      result = new ( Uint32Array )(286 + 30),
	      nResult,
	      rpt,
	      freqs = new ( Uint8Array )(19);
	  j = 0;

	  for (i = 0; i < hlit; i++) {
	    src[j++] = litlenLengths[i];
	  }

	  for (i = 0; i < hdist; i++) {
	    src[j++] = distLengths[i];
	  } // 初期化


	  nResult = 0;

	  for (i = 0, l = src.length; i < l; i += j) {
	    // Run Length Encoding
	    for (j = 1; i + j < l && src[i + j] === src[i]; ++j) {}

	    runLength = j;

	    if (src[i] === 0) {
	      // 0 の繰り返しが 3 回未満ならばそのまま
	      if (runLength < 3) {
	        while (runLength-- > 0) {
	          result[nResult++] = 0;
	          freqs[0]++;
	        }
	      } else {
	        while (runLength > 0) {
	          // 繰り返しは最大 138 までなので切り詰める
	          rpt = runLength < 138 ? runLength : 138;

	          if (rpt > runLength - 3 && rpt < runLength) {
	            rpt = runLength - 3;
	          } // 3-10 回 -> 17


	          if (rpt <= 10) {
	            result[nResult++] = 17;
	            result[nResult++] = rpt - 3;
	            freqs[17]++; // 11-138 回 -> 18
	          } else {
	            result[nResult++] = 18;
	            result[nResult++] = rpt - 11;
	            freqs[18]++;
	          }

	          runLength -= rpt;
	        }
	      }
	    } else {
	      result[nResult++] = src[i];
	      freqs[src[i]]++;
	      runLength--; // 繰り返し回数が3回未満ならばランレングス符号は要らない

	      if (runLength < 3) {
	        while (runLength-- > 0) {
	          result[nResult++] = src[i];
	          freqs[src[i]]++;
	        } // 3 回以上ならばランレングス符号化

	      } else {
	        while (runLength > 0) {
	          // runLengthを 3-6 で分割
	          rpt = runLength < 6 ? runLength : 6;

	          if (rpt > runLength - 3 && rpt < runLength) {
	            rpt = runLength - 3;
	          }

	          result[nResult++] = 16;
	          result[nResult++] = rpt - 3;
	          freqs[16]++;
	          runLength -= rpt;
	        }
	      }
	    }
	  }

	  return {
	    codes:  result.subarray(0, nResult) ,
	    freqs: freqs
	  };
	};
	/**
	 * ハフマン符号の長さを取得する
	 * @param {!(Array.<number>|Uint8Array|Uint32Array)} freqs 出現カウント.
	 * @param {number} limit 符号長の制限.
	 * @return {!(Array.<number>|Uint8Array)} 符号長配列.
	 * @private
	 */


	Zlib$1.RawDeflate.prototype.getLengths_ = function (freqs, limit) {
	  /** @type {number} */
	  var nSymbols = freqs.length;
	  /** @type {Zlib.Heap} */

	  var heap = new Zlib$1.Heap(2 * Zlib$1.RawDeflate.HUFMAX);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var length = new ( Uint8Array )(nSymbols);
	  /** @type {Array} */

	  var nodes;
	  /** @type {!(Array.<number>|Uint32Array)} */

	  var values;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var codeLength;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il; // 配列の初期化


	  for (i = 0; i < nSymbols; ++i) {
	    if (freqs[i] > 0) {
	      heap.push(i, freqs[i]);
	    }
	  }

	  nodes = new Array(heap.length / 2);
	  values = new ( Uint32Array )(heap.length / 2); // 非 0 の要素が一つだけだった場合は、そのシンボルに符号長 1 を割り当てて終了

	  if (nodes.length === 1) {
	    length[heap.pop().index] = 1;
	    return length;
	  } // Reverse Package Merge Algorithm による Canonical Huffman Code の符号長決定


	  for (i = 0, il = heap.length / 2; i < il; ++i) {
	    nodes[i] = heap.pop();
	    values[i] = nodes[i].value;
	  }

	  codeLength = this.reversePackageMerge_(values, values.length, limit);

	  for (i = 0, il = nodes.length; i < il; ++i) {
	    length[nodes[i].index] = codeLength[i];
	  }

	  return length;
	};
	/**
	 * Reverse Package Merge Algorithm.
	 * @param {!(Array.<number>|Uint32Array)} freqs sorted probability.
	 * @param {number} symbols number of symbols.
	 * @param {number} limit code length limit.
	 * @return {!(Array.<number>|Uint8Array)} code lengths.
	 */


	Zlib$1.RawDeflate.prototype.reversePackageMerge_ = function (freqs, symbols, limit) {
	  /** @type {!(Array.<number>|Uint16Array)} */
	  var minimumCost = new ( Uint16Array )(limit);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var flag = new ( Uint8Array )(limit);
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var codeLength = new ( Uint8Array )(symbols);
	  /** @type {Array} */

	  var value = new Array(limit);
	  /** @type {Array} */

	  var type = new Array(limit);
	  /** @type {Array.<number>} */

	  var currentPosition = new Array(limit);
	  /** @type {number} */

	  var excess = (1 << limit) - symbols;
	  /** @type {number} */

	  var half = 1 << limit - 1;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var j;
	  /** @type {number} */

	  var t;
	  /** @type {number} */

	  var weight;
	  /** @type {number} */

	  var next;
	  /**
	   * @param {number} j
	   */

	  function takePackage(j) {
	    /** @type {number} */
	    var x = type[j][currentPosition[j]];

	    if (x === symbols) {
	      takePackage(j + 1);
	      takePackage(j + 1);
	    } else {
	      --codeLength[x];
	    }

	    ++currentPosition[j];
	  }

	  minimumCost[limit - 1] = symbols;

	  for (j = 0; j < limit; ++j) {
	    if (excess < half) {
	      flag[j] = 0;
	    } else {
	      flag[j] = 1;
	      excess -= half;
	    }

	    excess <<= 1;
	    minimumCost[limit - 2 - j] = (minimumCost[limit - 1 - j] / 2 | 0) + symbols;
	  }

	  minimumCost[0] = flag[0];
	  value[0] = new Array(minimumCost[0]);
	  type[0] = new Array(minimumCost[0]);

	  for (j = 1; j < limit; ++j) {
	    if (minimumCost[j] > 2 * minimumCost[j - 1] + flag[j]) {
	      minimumCost[j] = 2 * minimumCost[j - 1] + flag[j];
	    }

	    value[j] = new Array(minimumCost[j]);
	    type[j] = new Array(minimumCost[j]);
	  }

	  for (i = 0; i < symbols; ++i) {
	    codeLength[i] = limit;
	  }

	  for (t = 0; t < minimumCost[limit - 1]; ++t) {
	    value[limit - 1][t] = freqs[t];
	    type[limit - 1][t] = t;
	  }

	  for (i = 0; i < limit; ++i) {
	    currentPosition[i] = 0;
	  }

	  if (flag[limit - 1] === 1) {
	    --codeLength[0];
	    ++currentPosition[limit - 1];
	  }

	  for (j = limit - 2; j >= 0; --j) {
	    i = 0;
	    weight = 0;
	    next = currentPosition[j + 1];

	    for (t = 0; t < minimumCost[j]; t++) {
	      weight = value[j + 1][next] + value[j + 1][next + 1];

	      if (weight > freqs[i]) {
	        value[j][t] = weight;
	        type[j][t] = symbols;
	        next += 2;
	      } else {
	        value[j][t] = freqs[i];
	        type[j][t] = i;
	        ++i;
	      }
	    }

	    currentPosition[j] = 0;

	    if (flag[j] === 1) {
	      takePackage(j);
	    }
	  }

	  return codeLength;
	};
	/**
	 * 符号長配列からハフマン符号を取得する
	 * reference: PuTTY Deflate implementation
	 * @param {!(Array.<number>|Uint8Array)} lengths 符号長配列.
	 * @return {!(Array.<number>|Uint16Array)} ハフマン符号配列.
	 * @private
	 */


	Zlib$1.RawDeflate.prototype.getCodesFromLengths_ = function (lengths) {
	  var codes = new ( Uint16Array )(lengths.length),
	      count = [],
	      startCode = [],
	      code = 0,
	      i,
	      il,
	      j,
	      m; // Count the codes of each length.

	  for (i = 0, il = lengths.length; i < il; i++) {
	    count[lengths[i]] = (count[lengths[i]] | 0) + 1;
	  } // Determine the starting code for each length block.


	  for (i = 1, il = Zlib$1.RawDeflate.MaxCodeLength; i <= il; i++) {
	    startCode[i] = code;
	    code += count[i] | 0;
	    code <<= 1;
	  } // Determine the code for each symbol. Mirrored, of course.


	  for (i = 0, il = lengths.length; i < il; i++) {
	    code = startCode[lengths[i]];
	    startCode[lengths[i]] += 1;
	    codes[i] = 0;

	    for (j = 0, m = lengths[i]; j < m; j++) {
	      codes[i] = codes[i] << 1 | code & 1;
	      code >>>= 1;
	    }
	  }

	  return codes;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {Object=} opt_params options.
	 * @constructor
	 */


	Zlib$1.Unzip = function (input, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.input =  input instanceof Array ? new Uint8Array(input) : input;
	  /** @type {number} */

	  this.ip = 0;
	  /** @type {number} */

	  this.eocdrOffset;
	  /** @type {number} */

	  this.numberOfThisDisk;
	  /** @type {number} */

	  this.startDisk;
	  /** @type {number} */

	  this.totalEntriesThisDisk;
	  /** @type {number} */

	  this.totalEntries;
	  /** @type {number} */

	  this.centralDirectorySize;
	  /** @type {number} */

	  this.centralDirectoryOffset;
	  /** @type {number} */

	  this.commentLength;
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.comment;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  this.fileHeaderList;
	  /** @type {Object.<string, number>} */

	  this.filenameToIndex;
	  /** @type {boolean} */

	  this.verify = opt_params['verify'] || false;
	  /** @type {(Array.<number>|Uint8Array)} */

	  this.password = opt_params['password'];
	};

	Zlib$1.Unzip.CompressionMethod = Zlib$1.Zip.CompressionMethod;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Unzip.FileHeaderSignature = Zlib$1.Zip.FileHeaderSignature;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Unzip.LocalFileHeaderSignature = Zlib$1.Zip.LocalFileHeaderSignature;
	/**
	 * @type {Array.<number>}
	 * @const
	 */

	Zlib$1.Unzip.CentralDirectorySignature = Zlib$1.Zip.CentralDirectorySignature;
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {number} ip input position.
	 * @constructor
	 */

	Zlib$1.Unzip.FileHeader = function (input, ip) {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  this.input = input;
	  /** @type {number} */

	  this.offset = ip;
	  /** @type {number} */

	  this.length;
	  /** @type {number} */

	  this.version;
	  /** @type {number} */

	  this.os;
	  /** @type {number} */

	  this.needVersion;
	  /** @type {number} */

	  this.flags;
	  /** @type {number} */

	  this.compression;
	  /** @type {number} */

	  this.time;
	  /** @type {number} */

	  this.date;
	  /** @type {number} */

	  this.crc32;
	  /** @type {number} */

	  this.compressedSize;
	  /** @type {number} */

	  this.plainSize;
	  /** @type {number} */

	  this.fileNameLength;
	  /** @type {number} */

	  this.extraFieldLength;
	  /** @type {number} */

	  this.fileCommentLength;
	  /** @type {number} */

	  this.diskNumberStart;
	  /** @type {number} */

	  this.internalFileAttributes;
	  /** @type {number} */

	  this.externalFileAttributes;
	  /** @type {number} */

	  this.relativeOffset;
	  /** @type {string} */

	  this.filename;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.extraField;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.comment;
	};

	Zlib$1.Unzip.FileHeader.prototype.parse = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip = this.offset; // central file header signature

	  if (input[ip++] !== Zlib$1.Unzip.FileHeaderSignature[0] || input[ip++] !== Zlib$1.Unzip.FileHeaderSignature[1] || input[ip++] !== Zlib$1.Unzip.FileHeaderSignature[2] || input[ip++] !== Zlib$1.Unzip.FileHeaderSignature[3]) {
	    throw new Error('invalid file header signature');
	  } // version made by


	  this.version = input[ip++];
	  this.os = input[ip++]; // version needed to extract

	  this.needVersion = input[ip++] | input[ip++] << 8; // general purpose bit flag

	  this.flags = input[ip++] | input[ip++] << 8; // compression method

	  this.compression = input[ip++] | input[ip++] << 8; // last mod file time

	  this.time = input[ip++] | input[ip++] << 8; //last mod file date

	  this.date = input[ip++] | input[ip++] << 8; // crc-32

	  this.crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // compressed size

	  this.compressedSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // uncompressed size

	  this.plainSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name length

	  this.fileNameLength = input[ip++] | input[ip++] << 8; // extra field length

	  this.extraFieldLength = input[ip++] | input[ip++] << 8; // file comment length

	  this.fileCommentLength = input[ip++] | input[ip++] << 8; // disk number start

	  this.diskNumberStart = input[ip++] | input[ip++] << 8; // internal file attributes

	  this.internalFileAttributes = input[ip++] | input[ip++] << 8; // external file attributes

	  this.externalFileAttributes = input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24; // relative offset of local header

	  this.relativeOffset = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name

	  this.filename = String.fromCharCode.apply(null,  input.subarray(ip, ip += this.fileNameLength) ); // extra field

	  this.extraField =  input.subarray(ip, ip += this.extraFieldLength) ; // file comment

	  this.comment =  input.subarray(ip, ip + this.fileCommentLength) ;
	  this.length = ip - this.offset;
	};
	/**
	 * @param {!(Array.<number>|Uint8Array)} input input buffer.
	 * @param {number} ip input position.
	 * @constructor
	 */


	Zlib$1.Unzip.LocalFileHeader = function (input, ip) {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  this.input = input;
	  /** @type {number} */

	  this.offset = ip;
	  /** @type {number} */

	  this.length;
	  /** @type {number} */

	  this.needVersion;
	  /** @type {number} */

	  this.flags;
	  /** @type {number} */

	  this.compression;
	  /** @type {number} */

	  this.time;
	  /** @type {number} */

	  this.date;
	  /** @type {number} */

	  this.crc32;
	  /** @type {number} */

	  this.compressedSize;
	  /** @type {number} */

	  this.plainSize;
	  /** @type {number} */

	  this.fileNameLength;
	  /** @type {number} */

	  this.extraFieldLength;
	  /** @type {string} */

	  this.filename;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  this.extraField;
	};

	Zlib$1.Unzip.LocalFileHeader.Flags = Zlib$1.Zip.Flags;

	Zlib$1.Unzip.LocalFileHeader.prototype.parse = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip = this.offset; // local file header signature

	  if (input[ip++] !== Zlib$1.Unzip.LocalFileHeaderSignature[0] || input[ip++] !== Zlib$1.Unzip.LocalFileHeaderSignature[1] || input[ip++] !== Zlib$1.Unzip.LocalFileHeaderSignature[2] || input[ip++] !== Zlib$1.Unzip.LocalFileHeaderSignature[3]) {
	    throw new Error('invalid local file header signature');
	  } // version needed to extract


	  this.needVersion = input[ip++] | input[ip++] << 8; // general purpose bit flag

	  this.flags = input[ip++] | input[ip++] << 8; // compression method

	  this.compression = input[ip++] | input[ip++] << 8; // last mod file time

	  this.time = input[ip++] | input[ip++] << 8; //last mod file date

	  this.date = input[ip++] | input[ip++] << 8; // crc-32

	  this.crc32 = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // compressed size

	  this.compressedSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // uncompressed size

	  this.plainSize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // file name length

	  this.fileNameLength = input[ip++] | input[ip++] << 8; // extra field length

	  this.extraFieldLength = input[ip++] | input[ip++] << 8; // file name

	  this.filename = String.fromCharCode.apply(null,  input.subarray(ip, ip += this.fileNameLength) ); // extra field

	  this.extraField =  input.subarray(ip, ip += this.extraFieldLength) ;
	  this.length = ip - this.offset;
	};

	Zlib$1.Unzip.prototype.searchEndOfCentralDirectoryRecord = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip;

	  for (ip = input.length - 12; ip > 0; --ip) {
	    if (input[ip] === Zlib$1.Unzip.CentralDirectorySignature[0] && input[ip + 1] === Zlib$1.Unzip.CentralDirectorySignature[1] && input[ip + 2] === Zlib$1.Unzip.CentralDirectorySignature[2] && input[ip + 3] === Zlib$1.Unzip.CentralDirectorySignature[3]) {
	      this.eocdrOffset = ip;
	      return;
	    }
	  }

	  throw new Error('End of Central Directory Record not found');
	};

	Zlib$1.Unzip.prototype.parseEndOfCentralDirectoryRecord = function () {
	  /** @type {!(Array.<number>|Uint8Array)} */
	  var input = this.input;
	  /** @type {number} */

	  var ip;

	  if (!this.eocdrOffset) {
	    this.searchEndOfCentralDirectoryRecord();
	  }

	  ip = this.eocdrOffset; // signature

	  if (input[ip++] !== Zlib$1.Unzip.CentralDirectorySignature[0] || input[ip++] !== Zlib$1.Unzip.CentralDirectorySignature[1] || input[ip++] !== Zlib$1.Unzip.CentralDirectorySignature[2] || input[ip++] !== Zlib$1.Unzip.CentralDirectorySignature[3]) {
	    throw new Error('invalid signature');
	  } // number of this disk


	  this.numberOfThisDisk = input[ip++] | input[ip++] << 8; // number of the disk with the start of the central directory

	  this.startDisk = input[ip++] | input[ip++] << 8; // total number of entries in the central directory on this disk

	  this.totalEntriesThisDisk = input[ip++] | input[ip++] << 8; // total number of entries in the central directory

	  this.totalEntries = input[ip++] | input[ip++] << 8; // size of the central directory

	  this.centralDirectorySize = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // offset of start of central directory with respect to the starting disk number

	  this.centralDirectoryOffset = (input[ip++] | input[ip++] << 8 | input[ip++] << 16 | input[ip++] << 24) >>> 0; // .ZIP file comment length

	  this.commentLength = input[ip++] | input[ip++] << 8; // .ZIP file comment

	  this.comment =  input.subarray(ip, ip + this.commentLength) ;
	};

	Zlib$1.Unzip.prototype.parseFileHeader = function () {
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */
	  var filelist = [];
	  /** @type {Object.<string, number>} */

	  var filetable = {};
	  /** @type {number} */

	  var ip;
	  /** @type {Zlib.Unzip.FileHeader} */

	  var fileHeader;
	  /*: @type {number} */

	  var i;
	  /*: @type {number} */

	  var il;

	  if (this.fileHeaderList) {
	    return;
	  }

	  if (this.centralDirectoryOffset === void 0) {
	    this.parseEndOfCentralDirectoryRecord();
	  }

	  ip = this.centralDirectoryOffset;

	  for (i = 0, il = this.totalEntries; i < il; ++i) {
	    fileHeader = new Zlib$1.Unzip.FileHeader(this.input, ip);
	    fileHeader.parse();
	    ip += fileHeader.length;
	    filelist[i] = fileHeader;
	    filetable[fileHeader.filename] = i;
	  }

	  if (this.centralDirectorySize < ip - this.centralDirectoryOffset) {
	    throw new Error('invalid file header size');
	  }

	  this.fileHeaderList = filelist;
	  this.filenameToIndex = filetable;
	};
	/**
	 * @param {number} index file header index.
	 * @param {Object=} opt_params
	 * @return {!(Array.<number>|Uint8Array)} file data.
	 */


	Zlib$1.Unzip.prototype.getFileData = function (index, opt_params) {
	  opt_params = opt_params || {};
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var input = this.input;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  var fileHeaderList = this.fileHeaderList;
	  /** @type {Zlib.Unzip.LocalFileHeader} */

	  var localFileHeader;
	  /** @type {number} */

	  var offset;
	  /** @type {number} */

	  var length;
	  /** @type {!(Array.<number>|Uint8Array)} */

	  var buffer;
	  /** @type {number} */

	  var crc32;
	  /** @type {Array.<number>|Uint32Array|Object} */

	  var key;
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;

	  if (!fileHeaderList) {
	    this.parseFileHeader();
	  }

	  if (fileHeaderList[index] === void 0) {
	    throw new Error('wrong index');
	  }

	  offset = fileHeaderList[index].relativeOffset;
	  localFileHeader = new Zlib$1.Unzip.LocalFileHeader(this.input, offset);
	  localFileHeader.parse();
	  offset += localFileHeader.length;
	  length = localFileHeader.compressedSize; // decryption

	  if ((localFileHeader.flags & Zlib$1.Unzip.LocalFileHeader.Flags.ENCRYPT) !== 0) {
	    if (!(opt_params['password'] || this.password)) {
	      throw new Error('please set password');
	    }

	    key = this.createDecryptionKey(opt_params['password'] || this.password); // encryption header

	    for (i = offset, il = offset + 12; i < il; ++i) {
	      this.decode(key, input[i]);
	    }

	    offset += 12;
	    length -= 12; // decryption

	    for (i = offset, il = offset + length; i < il; ++i) {
	      input[i] = this.decode(key, input[i]);
	    }
	  }

	  switch (localFileHeader.compression) {
	    case Zlib$1.Unzip.CompressionMethod.STORE:
	      buffer =  this.input.subarray(offset, offset + length) ;
	      break;

	    case Zlib$1.Unzip.CompressionMethod.DEFLATE:
	      buffer = new Zlib$1.RawInflate(this.input, {
	        'index': offset,
	        'bufferSize': localFileHeader.plainSize
	      }).decompress();
	      break;

	    default:
	      throw new Error('unknown compression type');
	  }

	  if (this.verify) {
	    crc32 = Zlib$1.CRC32.calc(buffer);

	    if (localFileHeader.crc32 !== crc32) {
	      throw new Error('wrong crc: file=0x' + localFileHeader.crc32.toString(16) + ', data=0x' + crc32.toString(16));
	    }
	  }

	  return buffer;
	};
	/**
	 * @return {Array.<string>}
	 */


	Zlib$1.Unzip.prototype.getFilenames = function () {
	  /** @type {Array.<string>} */
	  var filenameList = [];
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;
	  /** @type {Array.<Zlib.Unzip.FileHeader>} */

	  var fileHeaderList;

	  if (!this.fileHeaderList) {
	    this.parseFileHeader();
	  }

	  fileHeaderList = this.fileHeaderList;

	  for (i = 0, il = fileHeaderList.length; i < il; ++i) {
	    filenameList[i] = fileHeaderList[i].filename;
	  }

	  return filenameList;
	};
	/**
	 * @param {string} filename extract filename.
	 * @param {Object=} opt_params
	 * @return {!(Array.<number>|Uint8Array)} decompressed data.
	 */


	Zlib$1.Unzip.prototype.decompress = function (filename, opt_params) {
	  /** @type {number} */
	  var index;

	  if (!this.filenameToIndex) {
	    this.parseFileHeader();
	  }

	  index = this.filenameToIndex[filename];

	  if (index === void 0) {
	    throw new Error(filename + ' not found');
	  }

	  return this.getFileData(index, opt_params);
	};
	/**
	 * @param {(Array.<number>|Uint8Array)} password
	 */


	Zlib$1.Unzip.prototype.setPassword = function (password) {
	  this.password = password;
	};
	/**
	 * @param {(Array.<number>|Uint32Array|Object)} key
	 * @param {number} n
	 * @return {number}
	 */


	Zlib$1.Unzip.prototype.decode = function (key, n) {
	  n ^= this.getByte(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key);
	  this.updateKeys(
	  /** @type {(Array.<number>|Uint32Array)} */
	  key, n);
	  return n;
	}; // common method


	Zlib$1.Unzip.prototype.updateKeys = Zlib$1.Zip.prototype.updateKeys;
	Zlib$1.Unzip.prototype.createDecryptionKey = Zlib$1.Zip.prototype.createEncryptionKey;
	Zlib$1.Unzip.prototype.getByte = Zlib$1.Zip.prototype.getByte;
	/**
	 * @fileoverview 雑多な関数群をまとめたモジュール実装.
	 */

	/**
	 * Byte String から Byte Array に変換.
	 * @param {!string} str byte string.
	 * @return {!Array.<number>} byte array.
	 */

	Zlib$1.Util.stringToByteArray = function (str) {
	  /** @type {!Array.<(string|number)>} */
	  var tmp = str.split('');
	  /** @type {number} */

	  var i;
	  /** @type {number} */

	  var il;

	  for (i = 0, il = tmp.length; i < il; i++) {
	    tmp[i] = (tmp[i].charCodeAt(0) & 0xff) >>> 0;
	  }

	  return tmp;
	};
	/**
	 * @fileoverview Adler32 checksum 実装.
	 */

	/**
	 * Adler32 ハッシュ値の作成
	 * @param {!(Array|Uint8Array|string)} array 算出に使用する byte array.
	 * @return {number} Adler32 ハッシュ値.
	 */


	Zlib$1.Adler32 = function (array) {
	  if (typeof array === 'string') {
	    array = Zlib$1.Util.stringToByteArray(array);
	  }

	  return Zlib$1.Adler32.update(1, array);
	};
	/**
	 * Adler32 ハッシュ値の更新
	 * @param {number} adler 現在のハッシュ値.
	 * @param {!(Array|Uint8Array)} array 更新に使用する byte array.
	 * @return {number} Adler32 ハッシュ値.
	 */


	Zlib$1.Adler32.update = function (adler, array) {
	  /** @type {number} */
	  var s1 = adler & 0xffff;
	  /** @type {number} */

	  var s2 = adler >>> 16 & 0xffff;
	  /** @type {number} array length */

	  var len = array.length;
	  /** @type {number} loop length (don't overflow) */

	  var tlen;
	  /** @type {number} array index */

	  var i = 0;

	  while (len > 0) {
	    tlen = len > Zlib$1.Adler32.OptimizationParameter ? Zlib$1.Adler32.OptimizationParameter : len;
	    len -= tlen;

	    do {
	      s1 += array[i++];
	      s2 += s1;
	    } while (--tlen);

	    s1 %= 65521;
	    s2 %= 65521;
	  }

	  return (s2 << 16 | s1) >>> 0;
	};
	/**
	 * Adler32 最適化パラメータ
	 * 現状では 1024 程度が最適.
	 * @see http://jsperf.com/adler-32-simple-vs-optimized/3
	 * @define {number}
	 */


	Zlib$1.Adler32.OptimizationParameter = 1024;
	/**
	 * ビットストリーム
	 * @constructor
	 * @param {!(Array|Uint8Array)=} buffer output buffer.
	 * @param {number=} bufferPosition start buffer pointer.
	 */

	Zlib$1.BitStream = function (buffer, bufferPosition) {
	  /** @type {number} buffer index. */
	  this.index = typeof bufferPosition === 'number' ? bufferPosition : 0;
	  /** @type {number} bit index. */

	  this.bitindex = 0;
	  /** @type {!(Array|Uint8Array)} bit-stream output buffer. */

	  this.buffer = buffer instanceof ( Uint8Array ) ? buffer : new ( Uint8Array )(Zlib$1.BitStream.DefaultBlockSize); // 入力された index が足りなかったら拡張するが、倍にしてもダメなら不正とする

	  if (this.buffer.length * 2 <= this.index) {
	    throw new Error("invalid index");
	  } else if (this.buffer.length <= this.index) {
	    this.expandBuffer();
	  }
	};
	/**
	 * デフォルトブロックサイズ.
	 * @const
	 * @type {number}
	 */


	Zlib$1.BitStream.DefaultBlockSize = 0x8000;
	/**
	 * expand buffer.
	 * @return {!(Array|Uint8Array)} new buffer.
	 */

	Zlib$1.BitStream.prototype.expandBuffer = function () {
	  /** @type {!(Array|Uint8Array)} old buffer. */
	  var oldbuf = this.buffer;
	  /** @type {number} loop limiter. */

	  var il = oldbuf.length;
	  /** @type {!(Array|Uint8Array)} new buffer. */

	  var buffer = new ( Uint8Array )(il << 1); // copy buffer

	  {
	    buffer.set(oldbuf);
	  }

	  return this.buffer = buffer;
	};
	/**
	 * 数値をビットで指定した数だけ書き込む.
	 * @param {number} number 書き込む数値.
	 * @param {number} n 書き込むビット数.
	 * @param {boolean=} reverse 逆順に書き込むならば true.
	 */


	Zlib$1.BitStream.prototype.writeBits = function (number, n, reverse) {
	  var buffer = this.buffer;
	  var index = this.index;
	  var bitindex = this.bitindex;
	  /** @type {number} current octet. */

	  var current = buffer[index];
	  /** @type {number} loop counter. */

	  var i;
	  /**
	   * 32-bit 整数のビット順を逆にする
	   * @param {number} n 32-bit integer.
	   * @return {number} reversed 32-bit integer.
	   * @private
	   */

	  function rev32_(n) {
	    return Zlib$1.BitStream.ReverseTable[n & 0xFF] << 24 | Zlib$1.BitStream.ReverseTable[n >>> 8 & 0xFF] << 16 | Zlib$1.BitStream.ReverseTable[n >>> 16 & 0xFF] << 8 | Zlib$1.BitStream.ReverseTable[n >>> 24 & 0xFF];
	  }

	  if (reverse && n > 1) {
	    number = n > 8 ? rev32_(number) >> 32 - n : Zlib$1.BitStream.ReverseTable[number] >> 8 - n;
	  } // Byte 境界を超えないとき


	  if (n + bitindex < 8) {
	    current = current << n | number;
	    bitindex += n; // Byte 境界を超えるとき
	  } else {
	    for (i = 0; i < n; ++i) {
	      current = current << 1 | number >> n - i - 1 & 1; // next byte

	      if (++bitindex === 8) {
	        bitindex = 0;
	        buffer[index++] = Zlib$1.BitStream.ReverseTable[current];
	        current = 0; // expand

	        if (index === buffer.length) {
	          buffer = this.expandBuffer();
	        }
	      }
	    }
	  }

	  buffer[index] = current;
	  this.buffer = buffer;
	  this.bitindex = bitindex;
	  this.index = index;
	};
	/**
	 * ストリームの終端処理を行う
	 * @return {!(Array|Uint8Array)} 終端処理後のバッファを byte array で返す.
	 */


	Zlib$1.BitStream.prototype.finish = function () {
	  var buffer = this.buffer;
	  var index = this.index;
	  /** @type {!(Array|Uint8Array)} output buffer. */

	  var output; // bitindex が 0 の時は余分に index が進んでいる状態

	  if (this.bitindex > 0) {
	    buffer[index] <<= 8 - this.bitindex;
	    buffer[index] = Zlib$1.BitStream.ReverseTable[buffer[index]];
	    index++;
	  } // array truncation


	  {
	    output = buffer.subarray(0, index);
	  }

	  return output;
	};
	/**
	 * 0-255 のビット順を反転したテーブル
	 * @const
	 * @type {!(Uint8Array|Array.<number>)}
	 */


	Zlib$1.BitStream.ReverseTable = function (table) {
	  return table;
	}(function () {
	  /** @type {!(Array|Uint8Array)} reverse table. */
	  var table = new ( Uint8Array )(256);
	  /** @type {number} loop counter. */

	  var i; // generate

	  for (i = 0; i < 256; ++i) {
	    table[i] = function (n) {
	      var r = n;
	      var s = 7;

	      for (n >>>= 1; n; n >>>= 1) {
	        r <<= 1;
	        r |= n & 1;
	        --s;
	      }

	      return (r << s & 0xff) >>> 0;
	    }(i);
	  }

	  return table;
	}());
	/**
	 * CRC32 ハッシュ値を取得
	 * @param {!(Array.<number>|Uint8Array)} data data byte array.
	 * @param {number=} pos data position.
	 * @param {number=} length data length.
	 * @return {number} CRC32.
	 */

	Zlib$1.CRC32.calc = function (data, pos, length) {
	  return Zlib$1.CRC32.update(data, 0, pos, length);
	};
	/**
	 * CRC32ハッシュ値を更新
	 * @param {!(Array.<number>|Uint8Array)} data data byte array.
	 * @param {number} crc CRC32.
	 * @param {number=} pos data position.
	 * @param {number=} length data length.
	 * @return {number} CRC32.
	 */


	Zlib$1.CRC32.update = function (data, crc, pos, length) {
	  var table = Zlib$1.CRC32.Table;
	  var i = typeof pos === 'number' ? pos : pos = 0;
	  var il = typeof length === 'number' ? length : data.length;
	  crc ^= 0xffffffff; // loop unrolling for performance

	  for (i = il & 7; i--; ++pos) {
	    crc = crc >>> 8 ^ table[(crc ^ data[pos]) & 0xff];
	  }

	  for (i = il >> 3; i--; pos += 8) {
	    crc = crc >>> 8 ^ table[(crc ^ data[pos]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 1]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 2]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 3]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 4]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 5]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 6]) & 0xff];
	    crc = crc >>> 8 ^ table[(crc ^ data[pos + 7]) & 0xff];
	  }

	  return (crc ^ 0xffffffff) >>> 0;
	};
	/**
	 * @param {number} num
	 * @param {number} crc
	 * @returns {number}
	 */


	Zlib$1.CRC32.single = function (num, crc) {
	  return (Zlib$1.CRC32.Table[(num ^ crc) & 0xff] ^ num >>> 8) >>> 0;
	};
	/**
	 * @type {Array.<number>}
	 * @const
	 * @private
	 */


	Zlib$1.CRC32.Table_ = [0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91, 0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7, 0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b, 0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59, 0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924, 0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433, 0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01, 0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65, 0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f, 0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683, 0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1, 0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5, 0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b, 0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236, 0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d, 0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713, 0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777, 0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45, 0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9, 0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d];
	/**
	 * @type {!(Array.<number>|Uint32Array)} CRC-32 Table.
	 * @const
	 */

	Zlib$1.CRC32.Table =   new Uint32Array(Zlib$1.CRC32.Table_) ;
	/**
	 * @fileoverview Deflate (RFC1951) 実装.
	 * Deflateアルゴリズム本体は Zlib.RawDeflate で実装されている.
	 */

	/**
	 * Zlib Deflate
	 * @constructor
	 * @param {!(Array|Uint8Array)} input 符号化する対象の byte array.
	 * @param {Object=} opt_params option parameters.
	 */

	Zlib$1.Deflate = function (input, opt_params) {
	  /** @type {!(Array|Uint8Array)} */
	  this.input = input;
	  /** @type {!(Array|Uint8Array)} */

	  this.output = new ( Uint8Array )(Zlib$1.Deflate.DefaultBufferSize);
	  /** @type {Zlib.Deflate.CompressionType} */

	  this.compressionType = Zlib$1.Deflate.CompressionType.DYNAMIC;
	  /** @type {Zlib.RawDeflate} */

	  this.rawDeflate;
	  /** @type {Object} */

	  var rawDeflateOption = {};
	  /** @type {string} */

	  var prop; // option parameters

	  if (opt_params || !(opt_params = {})) {
	    if (typeof opt_params['compressionType'] === 'number') {
	      this.compressionType = opt_params['compressionType'];
	    }
	  } // copy options


	  for (prop in opt_params) {
	    rawDeflateOption[prop] = opt_params[prop];
	  } // set raw-deflate output buffer


	  rawDeflateOption['outputBuffer'] = this.output;
	  this.rawDeflate = new Zlib$1.RawDeflate(this.input, rawDeflateOption);
	};
	/**
	 * @const
	 * @type {number} デフォルトバッファサイズ.
	 */


	Zlib$1.Deflate.DefaultBufferSize = 0x8000;
	/**
	 * @enum {number}
	 */

	Zlib$1.Deflate.CompressionType = Zlib$1.RawDeflate.CompressionType;
	/**
	 * 直接圧縮に掛ける.
	 * @param {!(Array|Uint8Array)} input target buffer.
	 * @param {Object=} opt_params option parameters.
	 * @return {!(Array|Uint8Array)} compressed data byte array.
	 */

	Zlib$1.Deflate.compress = function (input, opt_params) {
	  return new Zlib$1.Deflate(input, opt_params).compress();
	};
	/**
	 * Deflate Compression.
	 * @return {!(Array|Uint8Array)} compressed data byte array.
	 */


	Zlib$1.Deflate.prototype.compress = function () {
	  /** @type {Zlib.CompressionMethod} */
	  var cm;
	  /** @type {number} */

	  var cinfo;
	  /** @type {number} */

	  var cmf;
	  /** @type {number} */

	  var flg;
	  /** @type {number} */

	  var fcheck;
	  /** @type {number} */

	  var fdict;
	  /** @type {number} */

	  var flevel;
	  /** @type {number} */

	  var adler;
	  /** @type {!(Array|Uint8Array)} */

	  var output;
	  /** @type {number} */

	  var pos = 0;
	  output = this.output; // Compression Method and Flags

	  cm = Zlib$1.CompressionMethod.DEFLATE;

	  switch (cm) {
	    case Zlib$1.CompressionMethod.DEFLATE:
	      cinfo = Math.LOG2E * Math.log(Zlib$1.RawDeflate.WindowSize) - 8;
	      break;

	    default:
	      throw new Error('invalid compression method');
	  }

	  cmf = cinfo << 4 | cm;
	  output[pos++] = cmf; // Flags

	  fdict = 0;

	  switch (cm) {
	    case Zlib$1.CompressionMethod.DEFLATE:
	      switch (this.compressionType) {
	        case Zlib$1.Deflate.CompressionType.NONE:
	          flevel = 0;
	          break;

	        case Zlib$1.Deflate.CompressionType.FIXED:
	          flevel = 1;
	          break;

	        case Zlib$1.Deflate.CompressionType.DYNAMIC:
	          flevel = 2;
	          break;

	        default:
	          throw new Error('unsupported compression type');
	      }

	      break;

	    default:
	      throw new Error('invalid compression method');
	  }

	  flg = flevel << 6 | fdict << 5;
	  fcheck = 31 - (cmf * 256 + flg) % 31;
	  flg |= fcheck;
	  output[pos++] = flg; // Adler-32 checksum

	  adler = Zlib$1.Adler32(this.input);
	  this.rawDeflate.op = pos;
	  output = this.rawDeflate.compress();
	  pos = output.length;

	  {
	    // subarray 分を元にもどす
	    output = new Uint8Array(output.buffer); // expand buffer

	    if (output.length <= pos + 4) {
	      this.output = new Uint8Array(output.length + 4);
	      this.output.set(output);
	      output = this.output;
	    }

	    output = output.subarray(0, pos + 4);
	  } // adler32


	  output[pos++] = adler >> 24 & 0xff;
	  output[pos++] = adler >> 16 & 0xff;
	  output[pos++] = adler >> 8 & 0xff;
	  output[pos++] = adler & 0xff;
	  return output;
	};

	let _btoa;

	if (typeof btoa === 'undefined') {
	  _btoa = btoa$1;
	} else {
	  _btoa = btoa;
	}
	/**
	 * Covers string literals and String objects
	 * @param x
	 * @returns {boolean}
	 */


	function isString(x) {
	  return typeof x === "string" || x instanceof String;
	} // StackOverflow: http://stackoverflow.com/a/10810674/116169


	function numberFormatter(rawNumber) {
	  var dec = String(rawNumber).split(/[.,]/),
	      sep = ',',
	      decsep = '.';
	  return dec[0].split('').reverse().reduce(function (prev, now, i) {
	    return i % 3 === 0 ? prev + sep + now : prev + now;
	  }).split('').reverse().join('') + (dec[1] ? decsep + dec[1] : '');
	}

	const splitLines = function (string) {
	  return string.split(/\n|\r\n|\r/g);
	};

	function splitStringRespectingQuotes(string, delim) {
	  var tokens = [],
	      len = string.length,
	      i,
	      n = 0,
	      quote = false,
	      c;

	  if (len > 0) {
	    tokens[n] = string.charAt(0);

	    for (i = 1; i < len; i++) {
	      c = string.charAt(i);

	      if (c === '"') {
	        quote = !quote;
	      } else if (!quote && c === delim) {
	        n++;
	        tokens[n] = "";
	      } else {
	        tokens[n] += c;
	      }
	    }
	  }

	  return tokens;
	}

	function stripQuotes(str) {
	  if (str === undefined) {
	    return str;
	  }

	  if (str.startsWith("'") || str.startsWith('"')) {
	    str = str.substring(1);
	  }

	  if (str.endsWith("'") || str.endsWith('"')) {
	    str = str.substring(0, str.length - 1);
	  }

	  return str;
	}

	function hashCode(s) {
	  return s.split("").reduce(function (a, b) {
	    a = (a << 5) - a + b.charCodeAt(0);
	    return a & a;
	  }, 0);
	}
	/**
	 * Compress string and encode in a url safe form
	 * @param s
	 */


	function compressString(str) {
	  const bytes = [];

	  for (var i = 0; i < str.length; i++) {
	    bytes.push(str.charCodeAt(i));
	  }

	  const compressedBytes = new Zlib$1.RawDeflate(bytes).compress(); // UInt8Arry

	  const compressedString = String.fromCharCode.apply(null, compressedBytes); // Convert to string

	  let enc = _btoa(compressedString);

	  return enc.replace(/\+/g, '.').replace(/\//g, '_').replace(/=/g, '-'); // URL safe
	}
	/**
	 * Uncompress the url-safe encoded compressed string, presumably created by compressString above
	 *
	 * @param enc
	 * @returns {string}
	 */


	function uncompressString(enc) {
	  enc = enc.replace(/\./g, '+').replace(/_/g, '/').replace(/-/g, '=');
	  const compressedString = atob(enc);
	  const compressedBytes = [];

	  for (let i = 0; i < compressedString.length; i++) {
	    compressedBytes.push(compressedString.charCodeAt(i));
	  }

	  const bytes = new Zlib$1.RawInflate(compressedBytes).decompress();
	  let str = '';

	  for (let b of bytes) {
	    str += String.fromCharCode(b);
	  }

	  return str;
	}

	function capitalize(str) {
	  return str.length > 0 ? str.charAt(0).toUpperCase() + str.slice(1) : str;
	}
	/**
	 * Parse a locus string and return a range object.  Locus string is of the form chr:start-end.  End is optional
	 *
	 */


	function parseLocusString(string) {
	  const t1 = string.split(":");
	  const t2 = t1[1].split("-");
	  const range = {
	    chr: t1[0],
	    start: Number.parseInt(t2[0].replace(/,/g, '')) - 1
	  };

	  if (t2.length > 1) {
	    range.end = Number.parseInt(t2[1].replace(/,/g, ''));
	  } else {
	    range.end = range.start + 1;
	  }

	  return range;
	}

	/**
	 * Return the filename from the path.   Example
	 *   https://foo.com/bar.bed?param=2   => bar.bed
	 * @param urlOrFile
	 */


	function getFilename(urlOrFile) {
	  if (urlOrFile instanceof File) {
	    return urlOrFile.name;
	  } else if (isString(urlOrFile)) {
	    let index = urlOrFile.lastIndexOf("/");
	    let filename = index < 0 ? urlOrFile : urlOrFile.substr(index + 1); //Strip parameters -- handle local files later

	    index = filename.indexOf("?");

	    if (index > 0) {
	      filename = filename.substr(0, index);
	    }

	    return filename;
	  } else {
	    throw Error(`Expected File or string, got ${typeof urlOrFile}`);
	  }
	}

	function isFilePath(path) {
	  return path instanceof File;
	}

	function download(filename, data) {
	  const element = document.createElement('a');
	  element.setAttribute('href', data);
	  element.setAttribute('download', filename);
	  element.style.display = 'none';
	  document.body.appendChild(element);
	  element.click();
	  document.body.removeChild(element);
	}

	const FileFormats = {
	  gwascatalog: {
	    fields: ['bin', 'chr', 'start', 'end', 'name', 'pubMedID', 'author', 'pubDate', 'journal', 'title', 'trait', 'initSample', 'replSample', 'region', 'genes', 'riskAllele', 'riskAlFreq', 'pValue', 'pValueDesc', 'orOrBeta', 'ci95', 'platform', 'cnv']
	  },
	  wgrna: {
	    fields: ['bin', 'chr', 'start', 'end', 'name', 'score', 'strand', 'thickStart', 'thickEnd', 'type']
	  },
	  cpgislandext: {
	    fields: ['bin', 'chr', 'start', 'end', 'name', 'length', 'cpgNum', 'gcNum', 'perCpg', 'perGc', 'obsExp']
	  },
	  clinVarMain: {
	    fields: ['chr1', 'start', 'end', 'name', 'score', 'strand', 'thickStart', 'thickEnd', 'reserved', 'blockCount', // Number of blocks
	    'blockSizes', // Comma separated list of block sizes
	    'chromStarts', // Start positions relative to chromStart
	    'origName', // NM_198053.2(CD247):c.462C>T (p.Asp154=)	ClinVar Variation Report
	    'clinSign', // Likely benign	Clinical significance
	    'reviewStatus', // 	based on: criteria provided,single submitter	Review Status
	    'type', // single nucleotide variant	Type of Variant
	    'geneId', // CD247	Gene Symbol
	    'snpId', //	181656780	dbSNP ID
	    'nsvId', //		dbVar ID
	    'rcvAcc', //	RCV000642347	ClinVar Allele Submission
	    'testedInGtr', //	N	Genetic Testing Registry
	    'phenotypeList', //	Immunodeficiency due to defect in cd3-zeta	Phenotypes
	    'phenotype', //	MedGen:C1857798, OMIM:610163	Phenotype identifiers
	    'origin', //	germline	Data origin
	    'assembly', //	GRCh37	Genome assembly
	    'cytogenetic', //	1q24.2	Cytogenetic status
	    'hgvsCod', //	NM_198053.2:c.462C>T	Nucleotide HGVS
	    'hgvsProt', //	NP_932170.1:p.Asp154=	Protein HGVS
	    'numSubmit', //	1	Number of submitters
	    'lastEval', //	Dec 19,2017	Last evaluation
	    'guidelines', //		Guidelines
	    'otherIds']
	  }
	};

	/*
	 * The MIT License (MIT)
	 *
	 * Copyright (c) 2014 Broad Institute
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 */
	const knownFileExtensions = new Set(["narrowpeak", "broadpeak", "regionpeak", "peaks", "bedgraph", "wig", "gff3", "gff", "gtf", "fusionjuncspan", "refflat", "seg", "aed", "bed", "vcf", "bb", "bigbed", "bw", "bigwig", "bam", "tdf", "refgene", "genepred", "genepredext", "bedpe", "bp", "snp", "rmsk", "cram", "gwas"]);
	/**
	 * Return a custom format object with the given name.
	 * @param name
	 * @returns {*}
	 */

	function getFormat(name) {
	  if (FileFormats && FileFormats[name]) {
	    return expandFormat(FileFormats[name]);
	  } else {
	    return undefined;
	  }

	  function expandFormat(format) {
	    const fields = format.fields;
	    const keys = ['chr', 'start', 'end'];

	    for (let i = 0; i < fields.length; i++) {
	      for (let key of keys) {
	        if (key === fields[i]) {
	          format[key] = i;
	        }
	      }
	    }

	    return format;
	  }
	}

	function inferFileFormat(fn) {
	  var idx, ext;
	  fn = fn.toLowerCase(); // Special case -- UCSC refgene files

	  if (fn.endsWith("refgene.txt.gz") || fn.endsWith("refgene.txt.bgz") || fn.endsWith("refgene.txt") || fn.endsWith("refgene.sorted.txt.gz") || fn.endsWith("refgene.sorted.txt.bgz")) {
	    return "refgene";
	  } //Strip parameters -- handle local files later


	  idx = fn.indexOf("?");

	  if (idx > 0) {
	    fn = fn.substr(0, idx);
	  } //Strip aux extensions .gz, .tab, and .txt


	  if (fn.endsWith(".gz")) {
	    fn = fn.substr(0, fn.length - 3);
	  }

	  if (fn.endsWith(".txt") || fn.endsWith(".tab") || fn.endsWith(".bgz")) {
	    fn = fn.substr(0, fn.length - 4);
	  }

	  idx = fn.lastIndexOf(".");
	  ext = idx < 0 ? fn : fn.substr(idx + 1);

	  switch (ext) {
	    case "bw":
	      return "bigwig";

	    case "bb":
	      return "bigbed";

	    default:
	      if (knownFileExtensions.has(ext)) {
	        return ext;
	      } else {
	        return undefined;
	      }

	  }
	}

	function inferIndexPath(url, extension) {
	  var idx;

	  if (url instanceof File) {
	    throw new Error("Cannot infer an index path for a local File.  Please select explicitly");
	  }

	  if (url.includes("?")) {
	    idx = url.indexOf("?");
	    return url.substring(0, idx) + "." + extension + url.substring(idx);
	  } else {
	    return url + "." + extension;
	  }
	}

	if (typeof process === 'object' && typeof window === 'undefined') {
	  global.atob = function (str) {
	    return Buffer.from(str, 'base64').toString('binary');
	  };
	}
	/**
	 * @param dataURI
	 * @returns {Array<number>|Uint8Array}
	 */


	function decodeDataURI(dataURI) {
	  const split = dataURI.split(',');
	  const info = split[0].split(':')[1];
	  let dataString = split[1];

	  if (info.indexOf('base64') >= 0) {
	    dataString = atob(dataString);
	  } else {
	    dataString = decodeURI(dataString); // URL encoded string -- not currently used of tested
	  }

	  const bytes = new Uint8Array(dataString.length);

	  for (let i = 0; i < dataString.length; i++) {
	    bytes[i] = dataString.charCodeAt(i);
	  }

	  let plain;

	  if (info.indexOf('gzip') > 0) {
	    const inflate = new Zlib$1.Gunzip(bytes);
	    plain = inflate.decompress();
	  } else {
	    plain = bytes;
	  }

	  return plain;
	}

	function parseUri(str) {
	  var o = options,
	      m = o.parser[ "loose"].exec(str),
	      uri = {},
	      i = 14;

	  while (i--) uri[o.key[i]] = m[i] || "";

	  uri[o.q.name] = {};
	  uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
	    if ($1) uri[o.q.name][$1] = $2;
	  });
	  return uri;
	}

	const options = {
	  strictMode: false,
	  key: ["source", "protocol", "authority", "userInfo", "user", "password", "host", "port", "relative", "path", "directory", "file", "query", "anchor"],
	  q: {
	    name: "queryKey",
	    parser: /(?:^|&)([^&=]*)=?([^&]*)/g
	  },
	  parser: {
	    strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
	    loose: /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
	  }
	};
	/**
	 * Resolve a url, which might be a string, function (that returns a string or Promse), or Promise (that resolves to a string)
	 *
	 * @param url
	 * @returns {Promise<*>}
	 */


	async function resolveURL(url) {
	  return typeof url === 'function' ? url() : url;
	}

	function isGoogleURL(url) {
	  return url.includes("googleapis") && !url.includes("urlshortener") || isGoogleStorageURL(url) || isGoogleDriveURL(url);
	}

	function isGoogleStorageURL(url) {
	  return url.startsWith("gs://") || url.startsWith("https://www.googleapis.com/storage") || url.startsWith("https://storage.cloud.google.com") || url.startsWith("https://storage.googleapis.com");
	}

	function isGoogleDriveURL(url) {
	  return url.indexOf("drive.google.com") >= 0 || url.indexOf("www.googleapis.com/drive") > 0;
	}

	function translateGoogleCloudURL(gsUrl) {
	  var i, bucket, object, qIdx, objectString, paramString;
	  i = gsUrl.indexOf('/', 5);
	  qIdx = gsUrl.indexOf('?');

	  if (i < 0) {
	    return gsUrl;
	  }

	  bucket = gsUrl.substring(5, i);
	  objectString = qIdx < 0 ? gsUrl.substring(i + 1) : gsUrl.substring(i + 1, qIdx);
	  object = encodeURIComponent(objectString);

	  if (qIdx > 0) {
	    paramString = gsUrl.substring(qIdx);
	  }

	  return "https://www.googleapis.com/storage/v1/b/" + bucket + "/o/" + object + (paramString ? paramString + "&alt=media" : "?alt=media");
	}

	function driveDownloadURL(link) {
	  // Return a google drive download url for the sharable link
	  //https://drive.google.com/open?id=0B-lleX9c2pZFbDJ4VVRxakJzVGM
	  //https://drive.google.com/file/d/1_FC4kCeO8E3V4dJ1yIW7A0sn1yURKIX-/view?usp=sharing
	  var id = getGoogleDriveFileID(link);
	  return id ? "https://www.googleapis.com/drive/v3/files/" + id + "?alt=media&supportsTeamDrives=true" : link;
	}

	function getGoogleDriveFileID(link) {
	  //https://drive.google.com/file/d/1_FC4kCeO8E3V4dJ1yIW7A0sn1yURKIX-/view?usp=sharing
	  var i1, i2;

	  if (link.includes("/open?id=")) {
	    i1 = link.indexOf("/open?id=") + 9;
	    i2 = link.indexOf("&");

	    if (i1 > 0 && i2 > i1) {
	      return link.substring(i1, i2);
	    } else if (i1 > 0) {
	      return link.substring(i1);
	    }
	  } else if (link.includes("/file/d/")) {
	    i1 = link.indexOf("/file/d/") + 8;
	    i2 = link.lastIndexOf("/");
	    return link.substring(i1, i2);
	  }
	}

	// Convenience functions for the gapi oAuth library.
	const FIVE_MINUTES = 5 * 60 * 1000;

	async function load(library) {
	  return new Promise(function (resolve, reject) {
	    gapi.load(library, {
	      callback: resolve,
	      onerror: reject
	    });
	  });
	}

	async function init$1(config) {
	  if (isInitialized()) {
	    console.warn("oAuth has already been initialized");
	    return;
	  }

	  gapi.apiKey = config.apiKey; // copy config, gapi will modify it

	  const configCopy = Object.assign({}, config);

	  if (!configCopy.scope) {
	    configCopy.scope = 'profile';
	  }

	  if (!config.client_id) {
	    config.client_id = config.clientId;
	  }

	  await load("auth2");
	  return new Promise(function (resolve, reject) {
	    gapi.auth2.init(configCopy).then(resolve, reject);
	  });
	}

	function isInitialized() {
	  return gapi.auth2 && gapi.auth2.getAuthInstance();
	}

	async function getAccessToken(scope) {
	  if (typeof gapi === "undefined") {
	    throw Error("Google authentication requires the 'gapi' library");
	  }

	  if (!gapi.auth2) {
	    throw Error("Google 'auth2' has not been initialized");
	  }

	  let currentUser = gapi.auth2.getAuthInstance().currentUser.get();

	  if (currentUser.isSignedIn()) {
	    if (!currentUser.hasGrantedScopes(scope)) {
	      await currentUser.grant({
	        scope
	      });
	    }

	    const {
	      access_token,
	      expires_at
	    } = currentUser.getAuthResponse();

	    if (Date.now() < expires_at - FIVE_MINUTES) {
	      return {
	        access_token,
	        expires_at
	      };
	    } else {
	      const {
	        access_token,
	        expires_at
	      } = currentUser.reloadAuthResponse();
	      return {
	        access_token,
	        expires_at
	      };
	    }
	  } else {
	    currentUser = await signIn(scope);
	    const {
	      access_token,
	      expires_at
	    } = currentUser.getAuthResponse();
	    return {
	      access_token,
	      expires_at
	    };
	  }
	}

	async function signIn(scope) {
	  const options = new gapi.auth2.SigninOptionsBuilder();
	  options.setPrompt('select_account');
	  options.setScope(scope);
	  return gapi.auth2.getAuthInstance().signIn(options);
	}

	function getScopeForURL(url) {
	  if (isGoogleDriveURL(url)) {
	    return "https://www.googleapis.com/auth/drive.file";
	  } else if (isGoogleStorageURL(url)) {
	    return "https://www.googleapis.com/auth/devstorage.read_only";
	  } else {
	    return 'https://www.googleapis.com/auth/userinfo.profile';
	  }
	}

	function getApiKey() {
	  return gapi.apiKey;
	}

	/*
	 * The MIT License (MIT)
	 *
	 * Copyright (c) 2016-2017 The Regents of the University of California
	 * Author: Jim Robinson
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 */
	const IGVMath = {
	  lerp: (v0, v1, t) => {
	    return (1 - t) * v0 + t * v1;
	  },
	  mean: function (array) {
	    var t = 0,
	        n = 0,
	        i;

	    for (i = 0; i < array.length; i++) {
	      if (!isNaN(array[i])) {
	        t += array[i];
	        n++;
	      }
	    }

	    return n > 0 ? t / n : 0;
	  },
	  meanAndStdev: function (array) {
	    var v,
	        t = 0,
	        t2 = 0,
	        n = 0,
	        i;

	    for (i = 0; i < array.length; i++) {
	      v = array[i];

	      if (!isNaN(v)) {
	        t += v;
	        t2 += v * v;
	        n++;
	      }
	    }

	    return n > 0 ? {
	      mean: t / n,
	      stdev: Math.sqrt(t2 - t * t / n)
	    } : {
	      mean: 0,
	      stdev: 0
	    };
	  },
	  median: function (numbers) {
	    // median of [3, 5, 4, 4, 1, 1, 2, 3] = 3
	    var median = 0,
	        numsLen = numbers.length;
	    numbers.sort();

	    if (numsLen % 2 === 0 // is even
	    ) {
	        // average of two middle numbers
	        median = (numbers[numsLen / 2 - 1] + numbers[numsLen / 2]) / 2;
	      } else {
	      // is odd
	      // middle number only
	      median = numbers[(numsLen - 1) / 2];
	    }

	    return median;
	  },
	  // Fast percentile function for "p" near edges.  This needs profiled for p in middle (e.g. median)
	  percentile: function (array, p) {
	    if (array.length === 0) return undefined;
	    var k = Math.floor(array.length * ((100 - p) / 100));

	    if (k === 0) {
	      array.sort(function (a, b) {
	        return b - a;
	      });
	      return array[k];
	    } else {
	      return selectElement(array, k);
	    }
	  },
	  clamp: function (value, min, max) {
	    return Math.min(Math.max(value, min), max);
	  },
	  log2: function (x) {
	    return Math.log(x) / Math.LN2;
	  }
	};

	function selectElement(array, k) {
	  // Credit Steve Hanov http://stevehanov.ca/blog/index.php?id=122
	  var heap = new BinaryHeap(),
	      i;

	  for (i = 0; i < array.length; i++) {
	    var item = array[i]; // If we have not yet found k items, or the current item is larger than
	    // the smallest item on the heap, add current item

	    if (heap.content.length < k || item > heap.content[0]) {
	      // If the heap is full, remove the smallest element on the heap.
	      if (heap.content.length === k) {
	        var r = heap.pop();
	      }

	      heap.push(item);
	    }
	  }

	  return heap.content[0];
	}

	function BinaryHeap() {
	  this.content = [];
	}

	BinaryHeap.prototype = {
	  push: function (element) {
	    // Add the new element to the end of the array.
	    this.content.push(element); // Allow it to bubble up.

	    this.bubbleUp(this.content.length - 1);
	  },
	  pop: function () {
	    // Store the first element so we can return it later.
	    var result = this.content[0]; // Get the element at the end of the array.

	    var end = this.content.pop(); // If there are any elements left, put the end element at the
	    // start, and let it sink down.

	    if (this.content.length > 0) {
	      this.content[0] = end;
	      this.sinkDown(0);
	    }

	    return result;
	  },
	  remove: function (node) {
	    var length = this.content.length; // To remove a value, we must search through the array to find
	    // it.

	    for (var i = 0; i < length; i++) {
	      if (this.content[i] !== node) continue; // When it is found, the process seen in 'pop' is repeated
	      // to fill up the hole.

	      var end = this.content.pop(); // If the element we popped was the one we needed to remove,
	      // we're done.

	      if (i === length - 1) break; // Otherwise, we replace the removed element with the popped
	      // one, and allow it to float up or sink down as appropriate.

	      this.content[i] = end;
	      this.bubbleUp(i);
	      this.sinkDown(i);
	      break;
	    }
	  },
	  size: function () {
	    return this.content.length;
	  },
	  bubbleUp: function (n) {
	    // Fetch the element that has to be moved.
	    var element = this.content[n],
	        score = element; // When at 0, an element can not go up any further.

	    while (n > 0) {
	      // Compute the parent element's index, and fetch it.
	      var parentN = Math.floor((n + 1) / 2) - 1,
	          parent = this.content[parentN]; // If the parent has a lesser score, things are in order and we
	      // are done.

	      if (score >= parent) break; // Otherwise, swap the parent with the current element and
	      // continue.

	      this.content[parentN] = element;
	      this.content[n] = parent;
	      n = parentN;
	    }
	  },
	  sinkDown: function (n) {
	    // Look up the target element and its score.
	    var length = this.content.length,
	        element = this.content[n],
	        elemScore = element;

	    while (true) {
	      // Compute the indices of the child elements.
	      var child2N = (n + 1) * 2,
	          child1N = child2N - 1; // This is used to store the new position of the element,
	      // if any.

	      var swap = null; // If the first child exists (is inside the array)...

	      if (child1N < length) {
	        // Look it up and compute its score.
	        var child1 = this.content[child1N],
	            child1Score = child1; // If the score is less than our element's, we need to swap.

	        if (child1Score < elemScore) swap = child1N;
	      } // Do the same checks for the other child.


	      if (child2N < length) {
	        var child2 = this.content[child2N],
	            child2Score = child2;
	        if (child2Score < (swap == null ? elemScore : child1Score)) swap = child2N;
	      } // No need to swap further, we are done.


	      if (swap == null) break; // Otherwise, swap and continue.

	      this.content[n] = this.content[swap];
	      this.content[swap] = element;
	      n = swap;
	    }
	  }
	};

	/*
	 * The MIT License (MIT)
	 *
	 * Copyright (c) 2014 Broad Institute
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in
	 * all copies or substantial portions of the Software.
	 *
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	 * THE SOFTWARE.
	 */
	const IGVColor = {
	  rgbListFromHSV: () => {
	    let s = 1;
	    let accumulation = [];

	    for (let v = 1; v >= 0.5; v -= .1) {
	      for (let h = 0; h < 1; h += 1 / 28) {
	        const r = "rgb(" + IGVColor.hsvToRgb(h, s, v).join(",") + ")";
	        accumulation.push(r);
	      }
	    } // add black


	    accumulation.pop();
	    accumulation.push(IGVColor.rgbColor(16, 16, 16));
	    return accumulation;
	  },
	  rgbToHex: function (rgb) {
	    rgb = rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);
	    return rgb && rgb.length === 4 ? "#" + ("0" + parseInt(rgb[1], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[2], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[3], 10).toString(16)).slice(-2) : '';
	  },
	  hexToRgb: function (hex) {
	    var cooked = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

	    if (null === cooked) {
	      return undefined;
	    }

	    return "rgb(" + parseInt(cooked[1], 16) + "," + parseInt(cooked[2], 16) + "," + parseInt(cooked[3], 16) + ")";
	  },

	  /**
	   * Converts an HSV color value to RGB. Conversion formula
	   * adapted from http://en.wikipedia.org/wiki/HSV_color_space.
	   * Assumes h, s, and v are contained in the set [0, 1] and
	   * returns r, g, and b in the set [0, 255].
	   *
	   * Credit: https://gist.githubusercontent.com/mjackson/5311256
	   *
	   * @param   h       The hue
	   * @param   s       The saturation
	   * @param   v       The value
	   * @return  Array   The RGB representation
	   */
	  hsvToRgb: function (h, s, v) {
	    var r, g, b;
	    var i = Math.floor(h * 6);
	    var f = h * 6 - i;
	    var p = v * (1 - s);
	    var q = v * (1 - f * s);
	    var t = v * (1 - (1 - f) * s);

	    switch (i % 6) {
	      case 0:
	        r = v, g = t, b = p;
	        break;

	      case 1:
	        r = q, g = v, b = p;
	        break;

	      case 2:
	        r = p, g = v, b = t;
	        break;

	      case 3:
	        r = p, g = q, b = v;
	        break;

	      case 4:
	        r = t, g = p, b = v;
	        break;

	      case 5:
	        r = v, g = p, b = q;
	        break;
	    }

	    return [Math.floor(r * 255), Math.floor(g * 255), Math.floor(b * 255)];
	  },

	  /**
	   * Converts an HSL color value to RGB. Conversion formula
	   * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
	   * Assumes h, s, and l are contained in the set [0, 1] and
	   * returns r, g, and b in the set [0, 255].
	   *
	   * Credit: https://gist.githubusercontent.com/mjackson/5311256
	   *
	   * @param   h       The hue
	   * @param   s       The saturation
	   * @param   l       The lightness
	   * @return  Array   The RGB representation
	   */
	  hslToRgb: function (h, s, l) {
	    var r, g, b;

	    if (s === 0) {
	      r = g = b = l; // achromatic
	    } else {
	      var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
	      var p = 2 * l - q;
	      r = IGVColor.hue2rgb(p, q, h + 1 / 3);
	      g = IGVColor.hue2rgb(p, q, h);
	      b = IGVColor.hue2rgb(p, q, h - 1 / 3);
	    }

	    return [r * 255, g * 255, b * 255];
	  },
	  hue2rgb: (p, q, t) => {
	    if (t < 0) t += 1;
	    if (t > 1) t -= 1;
	    if (t < 1 / 6) return p + (q - p) * 6 * t;
	    if (t < 1 / 2) return q;
	    if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
	    return p;
	  },
	  rgbaColor: function (r, g, b, a) {
	    r = IGVMath.clamp(r, 0, 255);
	    g = IGVMath.clamp(g, 0, 255);
	    b = IGVMath.clamp(b, 0, 255);
	    a = IGVMath.clamp(a, 0.0, 1.0);
	    return "rgba(" + r + "," + g + "," + b + "," + a + ")";
	  },
	  rgbColor: function (r, g, b) {
	    r = IGVMath.clamp(r, 0, 255);
	    g = IGVMath.clamp(g, 0, 255);
	    b = IGVMath.clamp(b, 0, 255);
	    return "rgb(" + r + "," + g + "," + b + ")";
	  },
	  greyScale: function (value) {
	    var grey = IGVMath.clamp(value, 0, 255);
	    return "rgb(" + grey + "," + grey + "," + grey + ")";
	  },
	  randomGrey: function (min, max) {
	    min = IGVMath.clamp(min, 0, 255);
	    max = IGVMath.clamp(max, 0, 255);
	    var g = Math.round(Math.random(min, max)).toString(10);
	    return "rgb(" + g + "," + g + "," + g + ")";
	  },
	  randomRGB: function (min, max) {
	    min = IGVMath.clamp(min, 0, 255);
	    max = IGVMath.clamp(max, 0, 255);
	    var r = Math.round(Math.random(min, max)).toString(10);
	    var g = Math.round(Math.random(min, max)).toString(10);
	    var b = Math.round(Math.random(min, max)).toString(10);
	    return "rgb(" + r + "," + g + "," + b + ")";
	  },
	  randomRGBConstantAlpha: function (min, max, alpha) {
	    min = IGVMath.clamp(min, 0, 255);
	    max = IGVMath.clamp(max, 0, 255);
	    var r = Math.round(Math.random(min, max)).toString(10);
	    var g = Math.round(Math.random(min, max)).toString(10);
	    var b = Math.round(Math.random(min, max)).toString(10);
	    return "rgba(" + r + "," + g + "," + b + "," + alpha + ")";
	  },
	  addAlpha: function (color, alpha) {
	    if (color === "0" || color === ".") {
	      color = "rgb(0,0,0)";
	    } else {
	      const c = this.colorNameToHex(color);

	      if (c) {
	        color = c;
	      }
	    }

	    var isHex = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(color);

	    if (color.startsWith("rgba")) {
	      const idx = color.lastIndexOf(",");
	      return color.substring(0, idx + 1) + alpha.toString() + ")";
	    }

	    if (isHex) {
	      color = IGVColor.hexToRgb(color);
	    }

	    if (color.startsWith("rgb")) {
	      return color.replace("rgb", "rgba").replace(")", ", " + alpha + ")");
	    } else {
	      return color;
	    }
	  },

	  /**
	   *
	   * @param dest  RGB components as an array
	   * @param src  RGB components as an array
	   * @param alpha   alpha transparancy in the range 0-1
	   * @returns {}
	   */
	  getCompositeColor: function (dest, src, alpha) {
	    var r = Math.floor(alpha * src[0] + (1 - alpha) * dest[0]),
	        g = Math.floor(alpha * src[1] + (1 - alpha) * dest[1]),
	        b = Math.floor(alpha * src[2] + (1 - alpha) * dest[2]);
	    return "rgb(" + r + "," + g + "," + b + ")";
	  },
	  createColorString: function (str) {
	    // Excel will quote color strings, strip all quotes
	    str = stripQuotes(str);

	    if (str.includes(",")) {
	      return str.startsWith("rgb") ? str : "rgb(" + str + ")";
	    } else {
	      return str;
	    }
	  },
	  darkenLighten: function (color, amt) {
	    let src;
	    let hexColor = this.colorNameToHex(color);

	    if (hexColor) {
	      src = IGVColor.hexToRgb(hexColor);
	    } else {
	      src = color.startsWith('rgb(') ? color : IGVColor.hexToRgb(color);
	    }

	    const components = src.replace(")", "").substring(4).split(",");
	    const r = Math.max(0, Math.min(255, Number.parseInt(components[0].trim()) + amt));
	    const g = Math.max(0, Math.min(255, Number.parseInt(components[1].trim()) + amt));
	    const b = Math.max(0, Math.min(255, Number.parseInt(components[2].trim()) + amt));
	    return 'rgb(' + r.toString() + ',' + g.toString() + ',' + b.toString() + ')';
	  },

	  /**
	   * Convert html/css color name to hex value.  Adapted from https://gist.github.com/mxfh/4719348
	   * @param colorName
	   * @returns {*}
	   */
	  colorNameToHex: function (colorName) {
	    // color list from http://stackoverflow.com/q/1573053/731179  with added gray/gray
	    const definedColorNames = {
	      "aliceblue": "#f0f8ff",
	      "antiquewhite": "#faebd7",
	      "aqua": "#00ffff",
	      "aquamarine": "#7fffd4",
	      "azure": "#f0ffff",
	      "beige": "#f5f5dc",
	      "bisque": "#ffe4c4",
	      "black": "#000000",
	      "blanchedalmond": "#ffebcd",
	      "blue": "#0000ff",
	      "blueviolet": "#8a2be2",
	      "brown": "#a52a2a",
	      "burlywood": "#deb887",
	      "cadetblue": "#5f9ea0",
	      "chartreuse": "#7fff00",
	      "chocolate": "#d2691e",
	      "coral": "#ff7f50",
	      "cornflowerblue": "#6495ed",
	      "cornsilk": "#fff8dc",
	      "crimson": "#dc143c",
	      "cyan": "#00ffff",
	      "darkblue": "#00008b",
	      "darkcyan": "#008b8b",
	      "darkgoldenrod": "#b8860b",
	      "darkgray": "#a9a9a9",
	      "darkgreen": "#006400",
	      "darkkhaki": "#bdb76b",
	      "darkmagenta": "#8b008b",
	      "darkolivegreen": "#556b2f",
	      "darkorange": "#ff8c00",
	      "darkorchid": "#9932cc",
	      "darkred": "#8b0000",
	      "darksalmon": "#e9967a",
	      "darkseagreen": "#8fbc8f",
	      "darkslateblue": "#483d8b",
	      "darkslategray": "#2f4f4f",
	      "darkturquoise": "#00ced1",
	      "darkviolet": "#9400d3",
	      "deeppink": "#ff1493",
	      "deepskyblue": "#00bfff",
	      "dimgray": "#696969",
	      "dodgerblue": "#1e90ff",
	      "firebrick": "#b22222",
	      "floralwhite": "#fffaf0",
	      "forestgreen": "#228b22",
	      "fuchsia": "#ff00ff",
	      "gainsboro": "#dcdcdc",
	      "ghostwhite": "#f8f8ff",
	      "gold": "#ffd700",
	      "goldenrod": "#daa520",
	      "gray": "#808080",
	      "green": "#008000",
	      "greenyellow": "#adff2f",
	      "honeydew": "#f0fff0",
	      "hotpink": "#ff69b4",
	      "indianred ": "#cd5c5c",
	      "indigo ": "#4b0082",
	      "ivory": "#fffff0",
	      "khaki": "#f0e68c",
	      "lavender": "#e6e6fa",
	      "lavenderblush": "#fff0f5",
	      "lawngreen": "#7cfc00",
	      "lemonchiffon": "#fffacd",
	      "lightblue": "#add8e6",
	      "lightcoral": "#f08080",
	      "lightcyan": "#e0ffff",
	      "lightgoldenrodyellow": "#fafad2",
	      "lightgrey": "#d3d3d3",
	      "lightgreen": "#90ee90",
	      "lightpink": "#ffb6c1",
	      "lightsalmon": "#ffa07a",
	      "lightseagreen": "#20b2aa",
	      "lightskyblue": "#87cefa",
	      "lightslategray": "#778899",
	      "lightsteelblue": "#b0c4de",
	      "lightyellow": "#ffffe0",
	      "lime": "#00ff00",
	      "limegreen": "#32cd32",
	      "linen": "#faf0e6",
	      "magenta": "#ff00ff",
	      "maroon": "#800000",
	      "mediumaquamarine": "#66cdaa",
	      "mediumblue": "#0000cd",
	      "mediumorchid": "#ba55d3",
	      "mediumpurple": "#9370d8",
	      "mediumseagreen": "#3cb371",
	      "mediumslateblue": "#7b68ee",
	      "mediumspringgreen": "#00fa9a",
	      "mediumturquoise": "#48d1cc",
	      "mediumvioletred": "#c71585",
	      "midnightblue": "#191970",
	      "mintcream": "#f5fffa",
	      "mistyrose": "#ffe4e1",
	      "moccasin": "#ffe4b5",
	      "navajowhite": "#ffdead",
	      "navy": "#000080",
	      "oldlace": "#fdf5e6",
	      "olive": "#808000",
	      "olivedrab": "#6b8e23",
	      "orange": "#ffa500",
	      "orangered": "#ff4500",
	      "orchid": "#da70d6",
	      "palegoldenrod": "#eee8aa",
	      "palegreen": "#98fb98",
	      "paleturquoise": "#afeeee",
	      "palevioletred": "#d87093",
	      "papayawhip": "#ffefd5",
	      "peachpuff": "#ffdab9",
	      "peru": "#cd853f",
	      "pink": "#ffc0cb",
	      "plum": "#dda0dd",
	      "powderblue": "#b0e0e6",
	      "purple": "#800080",
	      "red": "#ff0000",
	      "rosybrown": "#bc8f8f",
	      "royalblue": "#4169e1",
	      "saddlebrown": "#8b4513",
	      "salmon": "#fa8072",
	      "sandybrown": "#f4a460",
	      "seagreen": "#2e8b57",
	      "seashell": "#fff5ee",
	      "sienna": "#a0522d",
	      "silver": "#c0c0c0",
	      "skyblue": "#87ceeb",
	      "slateblue": "#6a5acd",
	      "slategray": "#708090",
	      "snow": "#fffafa",
	      "springgreen": "#00ff7f",
	      "steelblue": "#4682b4",
	      "tan": "#d2b48c",
	      "teal": "#008080",
	      "thistle": "#d8bfd8",
	      "tomato": "#ff6347",
	      "turquoise": "#40e0d0",
	      "violet": "#ee82ee",
	      "wheat": "#f5deb3",
	      "white": "#ffffff",
	      "whitesmoke": "#f5f5f5",
	      "yellow": "#ffff00",
	      "yellowgreen": "#9acd32",
	      "darkgrey": "#a9a9a9",
	      "darkslategrey": "#2f4f4f",
	      "dimgrey": "#696969",
	      "grey": "#808080",
	      "lightgray": "#d3d3d3",
	      "lightslategrey": "#778899",
	      "slategrey": "#708090"
	    };
	    return definedColorNames[colorName];
	  }
	};

	/**
	 * Make the target element movable by clicking and dragging on the handle.  This is not a general purprose function,
	 * it makes several options specific to igv dialogs, the primary one being that the
	 * target is absolutely positioned in pixel coordinates

	 */
	let dragData$1; // Its assumed we are only dragging one element at a time.

	function makeDraggable$1(target, handle) {
	  handle.addEventListener('mousedown', dragStart$1.bind(target));
	}

	function dragStart$1(event) {
	  event.stopPropagation();
	  event.preventDefault();
	  const pageCoords = offset$1(this);
	  const dragFunction = drag$1.bind(this);
	  const dragEndFunction = dragEnd$1.bind(this);
	  const computedStyle = getComputedStyle(this);
	  const top = parseInt(computedStyle.top.replace("px", ""));
	  const left = parseInt(computedStyle.left.replace("px", ""));
	  dragData$1 = {
	    dragFunction: dragFunction,
	    dragEndFunction: dragEndFunction,
	    screenX: event.screenX,
	    screenY: event.screenY,
	    top: top,
	    left: left
	  };
	  document.addEventListener('mousemove', dragFunction);
	  document.addEventListener('mouseup', dragEndFunction);
	  document.addEventListener('mouseleave', dragEndFunction);
	  document.addEventListener('mouseexit', dragEndFunction);
	}

	function drag$1(event) {
	  if (!dragData$1) {
	    return;
	  }

	  event.stopPropagation();
	  event.preventDefault();
	  const dx = event.screenX - dragData$1.screenX;
	  const dy = event.screenY - dragData$1.screenY;
	  this.style.left = `${dragData$1.left + dx}px`;
	  this.style.top = `${dragData$1.top + dy}px`;
	}

	function dragEnd$1(event) {
	  if (!dragData$1) {
	    return;
	  }

	  event.stopPropagation();
	  event.preventDefault();
	  const dragFunction = dragData$1.dragFunction;
	  const dragEndFunction = dragData$1.dragEndFunction;
	  document.removeEventListener('mousemove', dragFunction);
	  document.removeEventListener('mouseup', dragEndFunction);
	  document.removeEventListener('mouseleave', dragEndFunction);
	  document.removeEventListener('mouseexit', dragEndFunction);
	  dragData$1 = undefined;
	}

	// https://tc39.github.io/ecma262/#sec-object.keys

	var objectKeys = Object.keys || function keys(O) {
	  return objectKeysInternal(O, enumBugKeys);
	};

	// https://tc39.github.io/ecma262/#sec-object.defineproperties

	var objectDefineProperties = descriptors ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject(O);
	  var keys = objectKeys(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;

	  while (length > index) objectDefineProperty.f(O, key = keys[index++], Properties[key]);

	  return O;
	};

	var html = getBuiltIn('document', 'documentElement');

	var GT = '>';
	var LT = '<';
	var PROTOTYPE = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO = sharedKey('IE_PROTO');

	var EmptyConstructor = function () {
	  /* empty */
	};

	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak

	  return temp;
	}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


	var NullProtoObjectViaIFrame = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	}; // Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug


	var activeXDocument;

	var NullProtoObject = function () {
	  try {
	    /* global ActiveXObject */
	    activeXDocument = document.domain && new ActiveXObject('htmlfile');
	  } catch (error) {
	    /* ignore */
	  }

	  NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
	  var length = enumBugKeys.length;

	  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];

	  return NullProtoObject();
	};

	hiddenKeys[IE_PROTO] = true; // `Object.create` method
	// https://tc39.github.io/ecma262/#sec-object.create

	var objectCreate = Object.create || function create(O, Properties) {
	  var result;

	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE] = anObject(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill

	    result[IE_PROTO] = O;
	  } else result = NullProtoObject();

	  return Properties === undefined ? result : objectDefineProperties(result, Properties);
	};

	var nativeGetOwnPropertyNames = objectGetOwnPropertyNames.f;
	var toString$1 = {}.toString;
	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return nativeGetOwnPropertyNames(it);
	  } catch (error) {
	    return windowNames.slice();
	  }
	}; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window


	var f$5 = function getOwnPropertyNames(it) {
	  return windowNames && toString$1.call(it) == '[object Window]' ? getWindowNames(it) : nativeGetOwnPropertyNames(toIndexedObject(it));
	};

	var objectGetOwnPropertyNamesExternal = {
	  f: f$5
	};

	var f$6 = wellKnownSymbol;
	var wellKnownSymbolWrapped = {
	  f: f$6
	};

	var defineProperty$1 = objectDefineProperty.f;

	var defineWellKnownSymbol = function (NAME) {
	  var Symbol = path.Symbol || (path.Symbol = {});
	  if (!has(Symbol, NAME)) defineProperty$1(Symbol, NAME, {
	    value: wellKnownSymbolWrapped.f(NAME)
	  });
	};

	var defineProperty$2 = objectDefineProperty.f;
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');

	var setToStringTag = function (it, TAG, STATIC) {
	  if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
	    defineProperty$2(it, TO_STRING_TAG, {
	      configurable: true,
	      value: TAG
	    });
	  }
	};

	var $forEach$1 = arrayIteration.forEach;
	var HIDDEN = sharedKey('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE$1 = 'prototype';
	var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
	var setInternalState = internalState.set;
	var getInternalState = internalState.getterFor(SYMBOL);
	var ObjectPrototype = Object[PROTOTYPE$1];
	var $Symbol = global_1.Symbol;
	var $stringify = getBuiltIn('JSON', 'stringify');
	var nativeGetOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	var nativeDefineProperty$1 = objectDefineProperty.f;
	var nativeGetOwnPropertyNames$1 = objectGetOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable$1 = objectPropertyIsEnumerable.f;
	var AllSymbols = shared('symbols');
	var ObjectPrototypeSymbols = shared('op-symbols');
	var StringToSymbolRegistry = shared('string-to-symbol-registry');
	var SymbolToStringRegistry = shared('symbol-to-string-registry');
	var WellKnownSymbolsStore$1 = shared('wks');
	var QObject = global_1.QObject; // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173

	var USE_SETTER = !QObject || !QObject[PROTOTYPE$1] || !QObject[PROTOTYPE$1].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687

	var setSymbolDescriptor = descriptors && fails(function () {
	  return objectCreate(nativeDefineProperty$1({}, 'a', {
	    get: function () {
	      return nativeDefineProperty$1(this, 'a', {
	        value: 7
	      }).a;
	    }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
	  nativeDefineProperty$1(O, P, Attributes);

	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
	    nativeDefineProperty$1(ObjectPrototype, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty$1;

	var wrap = function (tag, description) {
	  var symbol = AllSymbols[tag] = objectCreate($Symbol[PROTOTYPE$1]);
	  setInternalState(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!descriptors) symbol.description = description;
	  return symbol;
	};

	var isSymbol = useSymbolAsUid ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  return Object(it) instanceof $Symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject(O);
	  var key = toPrimitive(P, true);
	  anObject(Attributes);

	  if (has(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!has(O, HIDDEN)) nativeDefineProperty$1(O, HIDDEN, createPropertyDescriptor(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (has(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = objectCreate(Attributes, {
	        enumerable: createPropertyDescriptor(0, false)
	      });
	    }

	    return setSymbolDescriptor(O, key, Attributes);
	  }

	  return nativeDefineProperty$1(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject(O);
	  var properties = toIndexedObject(Properties);
	  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
	  $forEach$1(keys, function (key) {
	    if (!descriptors || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? objectCreate(O) : $defineProperties(objectCreate(O), Properties);
	};

	var $propertyIsEnumerable = function propertyIsEnumerable(V) {
	  var P = toPrimitive(V, true);
	  var enumerable = nativePropertyIsEnumerable$1.call(this, P);
	  if (this === ObjectPrototype && has(AllSymbols, P) && !has(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !has(this, P) || !has(AllSymbols, P) || has(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject(O);
	  var key = toPrimitive(P, true);
	  if (it === ObjectPrototype && has(AllSymbols, key) && !has(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);

	  if (descriptor && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }

	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames$1(toIndexedObject(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (!has(AllSymbols, key) && !has(hiddenKeys, key)) result.push(key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
	  var names = nativeGetOwnPropertyNames$1(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (has(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has(ObjectPrototype, key))) {
	      result.push(AllSymbols[key]);
	    }
	  });
	  return result;
	}; // `Symbol` constructor
	// https://tc39.github.io/ecma262/#sec-symbol-constructor


	if (!nativeSymbol) {
	  $Symbol = function Symbol() {
	    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : String(arguments[0]);
	    var tag = uid(description);

	    var setter = function (value) {
	      if (this === ObjectPrototype) setter.call(ObjectPrototypeSymbols, value);
	      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
	    };

	    if (descriptors && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, {
	      configurable: true,
	      set: setter
	    });
	    return wrap(tag, description);
	  };

	  redefine($Symbol[PROTOTYPE$1], 'toString', function toString() {
	    return getInternalState(this).tag;
	  });
	  redefine($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid(description), description);
	  });
	  objectPropertyIsEnumerable.f = $propertyIsEnumerable;
	  objectDefineProperty.f = $defineProperty;
	  objectGetOwnPropertyDescriptor.f = $getOwnPropertyDescriptor;
	  objectGetOwnPropertyNames.f = objectGetOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  objectGetOwnPropertySymbols.f = $getOwnPropertySymbols;

	  wellKnownSymbolWrapped.f = function (name) {
	    return wrap(wellKnownSymbol(name), name);
	  };

	  if (descriptors) {
	    // https://github.com/tc39/proposal-Symbol-description
	    nativeDefineProperty$1($Symbol[PROTOTYPE$1], 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState(this).description;
	      }
	    });

	    {
	      redefine(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, {
	        unsafe: true
	      });
	    }
	  }
	}

	_export({
	  global: true,
	  wrap: true,
	  forced: !nativeSymbol,
	  sham: !nativeSymbol
	}, {
	  Symbol: $Symbol
	});
	$forEach$1(objectKeys(WellKnownSymbolsStore$1), function (name) {
	  defineWellKnownSymbol(name);
	});
	_export({
	  target: SYMBOL,
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Symbol.for` method
	  // https://tc39.github.io/ecma262/#sec-symbol.for
	  'for': function (key) {
	    var string = String(key);
	    if (has(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = $Symbol(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry[symbol] = string;
	    return symbol;
	  },
	  // `Symbol.keyFor` method
	  // https://tc39.github.io/ecma262/#sec-symbol.keyfor
	  keyFor: function keyFor(sym) {
	    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol');
	    if (has(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  },
	  useSetter: function () {
	    USE_SETTER = true;
	  },
	  useSimple: function () {
	    USE_SETTER = false;
	  }
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol,
	  sham: !descriptors
	}, {
	  // `Object.create` method
	  // https://tc39.github.io/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames,
	  // `Object.getOwnPropertySymbols` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertysymbols
	  getOwnPropertySymbols: $getOwnPropertySymbols
	}); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443

	_export({
	  target: 'Object',
	  stat: true,
	  forced: fails(function () {
	    objectGetOwnPropertySymbols.f(1);
	  })
	}, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    return objectGetOwnPropertySymbols.f(toObject(it));
	  }
	}); // `JSON.stringify` method behavior with symbols
	// https://tc39.github.io/ecma262/#sec-json.stringify

	if ($stringify) {
	  var FORCED_JSON_STRINGIFY = !nativeSymbol || fails(function () {
	    var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}

	    return $stringify([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
	    || $stringify({
	      a: symbol
	    }) != '{}' // V8 throws on boxed symbols
	    || $stringify(Object(symbol)) != '{}';
	  });
	  _export({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED_JSON_STRINGIFY
	  }, {
	    // eslint-disable-next-line no-unused-vars
	    stringify: function stringify(it, replacer, space) {
	      var args = [it];
	      var index = 1;
	      var $replacer;

	      while (arguments.length > index) args.push(arguments[index++]);

	      $replacer = replacer;
	      if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined

	      if (!isArray(replacer)) replacer = function (key, value) {
	        if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
	        if (!isSymbol(value)) return value;
	      };
	      args[1] = replacer;
	      return $stringify.apply(null, args);
	    }
	  });
	} // `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@toprimitive


	if (!$Symbol[PROTOTYPE$1][TO_PRIMITIVE]) {
	  createNonEnumerableProperty($Symbol[PROTOTYPE$1], TO_PRIMITIVE, $Symbol[PROTOTYPE$1].valueOf);
	} // `Symbol.prototype[@@toStringTag]` property
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@tostringtag


	setToStringTag($Symbol, SYMBOL);
	hiddenKeys[HIDDEN] = true;

	var defineProperty$3 = objectDefineProperty.f;
	var NativeSymbol = global_1.Symbol;

	if (descriptors && typeof NativeSymbol == 'function' && (!('description' in NativeSymbol.prototype) || // Safari 12 bug
	NativeSymbol().description !== undefined)) {
	  var EmptyStringDescriptionStore = {}; // wrap Symbol constructor for correct work with undefined description

	  var SymbolWrapper = function Symbol() {
	    var description = arguments.length < 1 || arguments[0] === undefined ? undefined : String(arguments[0]);
	    var result = this instanceof SymbolWrapper ? new NativeSymbol(description) // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
	    : description === undefined ? NativeSymbol() : NativeSymbol(description);
	    if (description === '') EmptyStringDescriptionStore[result] = true;
	    return result;
	  };

	  copyConstructorProperties(SymbolWrapper, NativeSymbol);
	  var symbolPrototype = SymbolWrapper.prototype = NativeSymbol.prototype;
	  symbolPrototype.constructor = SymbolWrapper;
	  var symbolToString = symbolPrototype.toString;
	  var native = String(NativeSymbol('test')) == 'Symbol(test)';
	  var regexp = /^Symbol\((.*)\)[^)]+$/;
	  defineProperty$3(symbolPrototype, 'description', {
	    configurable: true,
	    get: function description() {
	      var symbol = isObject(this) ? this.valueOf() : this;
	      var string = symbolToString.call(symbol);
	      if (has(EmptyStringDescriptionStore, symbol)) return '';
	      var desc = native ? string.slice(7, -1) : string.replace(regexp, '$1');
	      return desc === '' ? undefined : desc;
	    }
	  });
	  _export({
	    global: true,
	    forced: true
	  }, {
	    Symbol: SymbolWrapper
	  });
	}

	// https://tc39.github.io/ecma262/#sec-symbol.iterator

	defineWellKnownSymbol('iterator');

	var createProperty = function (object, key, value) {
	  var propertyKey = toPrimitive(key);
	  if (propertyKey in object) objectDefineProperty.f(object, propertyKey, createPropertyDescriptor(0, value));else object[propertyKey] = value;
	};

	var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679

	var IS_CONCAT_SPREADABLE_SUPPORT = engineV8Version >= 51 || !fails(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});
	var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

	var isConcatSpreadable = function (O) {
	  if (!isObject(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray(O);
	};

	var FORCED$1 = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$1
	}, {
	  concat: function concat(arg) {
	    // eslint-disable-line no-unused-vars
	    var O = toObject(this);
	    var A = arraySpeciesCreate(O, 0);
	    var n = 0;
	    var i, k, length, len, E;

	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];

	      if (isConcatSpreadable(E)) {
	        len = toLength(E.length);
	        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

	        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
	      } else {
	        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
	        createProperty(A, n++, E);
	      }
	    }

	    A.length = n;
	    return A;
	  }
	});

	var UNSCOPABLES = wellKnownSymbol('unscopables');
	var ArrayPrototype = Array.prototype; // Array.prototype[@@unscopables]
	// https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	if (ArrayPrototype[UNSCOPABLES] == undefined) {
	  objectDefineProperty.f(ArrayPrototype, UNSCOPABLES, {
	    configurable: true,
	    value: objectCreate(null)
	  });
	} // add a key to Array.prototype[@@unscopables]


	var addToUnscopables = function (key) {
	  ArrayPrototype[UNSCOPABLES][key] = true;
	};

	var $find = arrayIteration.find;
	var FIND = 'find';
	var SKIPS_HOLES = true;
	var USES_TO_LENGTH$4 = arrayMethodUsesToLength(FIND); // Shouldn't skip holes

	if (FIND in []) Array(1)[FIND](function () {
	  SKIPS_HOLES = false;
	}); // `Array.prototype.find` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.find

	_export({
	  target: 'Array',
	  proto: true,
	  forced: SKIPS_HOLES || !USES_TO_LENGTH$4
	}, {
	  find: function find(callbackfn
	  /* , that = undefined */
	  ) {
	    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables(FIND);

	var iterators = {};

	var correctPrototypeGetter = !fails(function () {
	  function F() {
	    /* empty */
	  }

	  F.prototype.constructor = null;
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var IE_PROTO$1 = sharedKey('IE_PROTO');
	var ObjectPrototype$1 = Object.prototype; // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	var objectGetPrototypeOf = correctPrototypeGetter ? Object.getPrototypeOf : function (O) {
	  O = toObject(O);
	  if (has(O, IE_PROTO$1)) return O[IE_PROTO$1];

	  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
	    return O.constructor.prototype;
	  }

	  return O instanceof Object ? ObjectPrototype$1 : null;
	};

	var ITERATOR = wellKnownSymbol('iterator');
	var BUGGY_SAFARI_ITERATORS = false;

	var returnThis = function () {
	  return this;
	}; // `%IteratorPrototype%` object
	// https://tc39.github.io/ecma262/#sec-%iteratorprototype%-object


	var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

	if ([].keys) {
	  arrayIterator = [].keys(); // Safari 8 has buggy iterators w/o `next`

	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;else {
	    PrototypeOfArrayIteratorPrototype = objectGetPrototypeOf(objectGetPrototypeOf(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
	  }
	}

	if (IteratorPrototype == undefined) IteratorPrototype = {}; // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()

	if ( !has(IteratorPrototype, ITERATOR)) {
	  createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
	}

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
	};

	var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;

	var returnThis$1 = function () {
	  return this;
	};

	var createIteratorConstructor = function (IteratorConstructor, NAME, next) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = objectCreate(IteratorPrototype$1, {
	    next: createPropertyDescriptor(1, next)
	  });
	  setToStringTag(IteratorConstructor, TO_STRING_TAG, false);
	  iterators[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};

	var aPossiblePrototype = function (it) {
	  if (!isObject(it) && it !== null) {
	    throw TypeError("Can't set " + String(it) + ' as a prototype');
	  }

	  return it;
	};

	// https://tc39.github.io/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.

	/* eslint-disable no-proto */

	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;

	  try {
	    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
	    setter.call(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {
	    /* empty */
	  }

	  return function setPrototypeOf(O, proto) {
	    anObject(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter.call(O, proto);else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	var IteratorPrototype$2 = iteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS$1 = iteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$1 = wellKnownSymbol('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis$2 = function () {
	  return this;
	};

	var defineIterator = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS$1 && KIND in IterablePrototype) return IterablePrototype[KIND];

	    switch (KIND) {
	      case KEYS:
	        return function keys() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case VALUES:
	        return function values() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case ENTRIES:
	        return function entries() {
	          return new IteratorConstructor(this, KIND);
	        };
	    }

	    return function () {
	      return new IteratorConstructor(this);
	    };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$1] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS$1 && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY; // fix native

	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = objectGetPrototypeOf(anyNativeIterator.call(new Iterable()));

	    if (IteratorPrototype$2 !== Object.prototype && CurrentIteratorPrototype.next) {
	      if ( objectGetPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype$2) {
	        if (objectSetPrototypeOf) {
	          objectSetPrototypeOf(CurrentIteratorPrototype, IteratorPrototype$2);
	        } else if (typeof CurrentIteratorPrototype[ITERATOR$1] != 'function') {
	          createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR$1, returnThis$2);
	        }
	      } // Set @@toStringTag to native iterators


	      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true);
	    }
	  } // fix Array#{values, @@iterator}.name in V8 / FF


	  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    INCORRECT_VALUES_NAME = true;

	    defaultIterator = function values() {
	      return nativeIterator.call(this);
	    };
	  } // define iterator


	  if ( IterablePrototype[ITERATOR$1] !== defaultIterator) {
	    createNonEnumerableProperty(IterablePrototype, ITERATOR$1, defaultIterator);
	  }

	  iterators[NAME] = defaultIterator; // export additional methods

	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        redefine(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else _export({
	      target: NAME,
	      proto: true,
	      forced: BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME
	    }, methods);
	  }

	  return methods;
	};

	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$1 = internalState.set;
	var getInternalState$1 = internalState.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.github.io/ecma262/#sec-createarrayiterator

	var es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
	  setInternalState$1(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject(iterated),
	    // target
	    index: 0,
	    // next index
	    kind: kind // kind

	  }); // `%ArrayIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$1(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;

	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return {
	      value: undefined,
	      done: true
	    };
	  }

	  if (kind == 'keys') return {
	    value: index,
	    done: false
	  };
	  if (kind == 'values') return {
	    value: target[index],
	    done: false
	  };
	  return {
	    value: [index, target[index]],
	    done: false
	  };
	}, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.github.io/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.github.io/ecma262/#sec-createmappedargumentsobject

	iterators.Arguments = iterators.Array; // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('keys');
	addToUnscopables('values');
	addToUnscopables('entries');

	var nativeJoin = [].join;
	var ES3_STRINGS = indexedObject != Object;
	var STRICT_METHOD$3 = arrayMethodIsStrict('join', ','); // `Array.prototype.join` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.join

	_export({
	  target: 'Array',
	  proto: true,
	  forced: ES3_STRINGS || !STRICT_METHOD$3
	}, {
	  join: function join(separator) {
	    return nativeJoin.call(toIndexedObject(this), separator === undefined ? ',' : separator);
	  }
	});

	var $map = arrayIteration.map;
	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport('map'); // FF49- issue

	var USES_TO_LENGTH$5 = arrayMethodUsesToLength('map'); // `Array.prototype.map` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.map
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$1 || !USES_TO_LENGTH$5
	}, {
	  map: function map(callbackfn
	  /* , thisArg */
	  ) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport('slice');
	var USES_TO_LENGTH$6 = arrayMethodUsesToLength('slice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var SPECIES$4 = wellKnownSymbol('species');
	var nativeSlice = [].slice;
	var max$1 = Math.max; // `Array.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$2 || !USES_TO_LENGTH$6
	}, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject(this);
	    var length = toLength(O.length);
	    var k = toAbsoluteIndex(start, length);
	    var fin = toAbsoluteIndex(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

	    var Constructor, result, n;

	    if (isArray(O)) {
	      Constructor = O.constructor; // cross-realm fallback

	      if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject(Constructor)) {
	        Constructor = Constructor[SPECIES$4];
	        if (Constructor === null) Constructor = undefined;
	      }

	      if (Constructor === Array || Constructor === undefined) {
	        return nativeSlice.call(O, k, fin);
	      }
	    }

	    result = new (Constructor === undefined ? Array : Constructor)(max$1(fin - k, 0));

	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);

	    result.length = n;
	    return result;
	  }
	});

	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport('splice');
	var USES_TO_LENGTH$7 = arrayMethodUsesToLength('splice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var max$2 = Math.max;
	var min$5 = Math.min;
	var MAX_SAFE_INTEGER$1 = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.splice
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$3 || !USES_TO_LENGTH$7
	}, {
	  splice: function splice(start, deleteCount
	  /* , ...items */
	  ) {
	    var O = toObject(this);
	    var len = toLength(O.length);
	    var actualStart = toAbsoluteIndex(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;

	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min$5(max$2(toInteger(deleteCount), 0), len - actualStart);
	    }

	    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER$1) {
	      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
	    }

	    A = arraySpeciesCreate(O, actualDeleteCount);

	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty(A, k, O[from]);
	    }

	    A.length = actualDeleteCount;

	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }

	      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }
	    }

	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }

	    O.length = len - actualDeleteCount + insertCount;
	    return A;
	  }
	});

	var defineProperty$4 = objectDefineProperty.f;
	var FunctionPrototype = Function.prototype;
	var FunctionPrototypeToString = FunctionPrototype.toString;
	var nameRE = /^\s*function ([^ (]*)/;
	var NAME = 'name'; // Function instances `.name` property
	// https://tc39.github.io/ecma262/#sec-function-instances-name

	if (descriptors && !(NAME in FunctionPrototype)) {
	  defineProperty$4(FunctionPrototype, NAME, {
	    configurable: true,
	    get: function () {
	      try {
	        return FunctionPrototypeToString.call(this).match(nameRE)[1];
	      } catch (error) {
	        return '';
	      }
	    }
	  });
	}

	var FAILS_ON_PRIMITIVES = fails(function () {
	  objectGetPrototypeOf(1);
	}); // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES,
	  sham: !correctPrototypeGetter
	}, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return objectGetPrototypeOf(toObject(it));
	  }
	});

	var TO_STRING_TAG$1 = wellKnownSymbol('toStringTag');
	var test = {};
	test[TO_STRING_TAG$1] = 'z';
	var toStringTagSupport = String(test) === '[object z]';

	var TO_STRING_TAG$2 = wellKnownSymbol('toStringTag'); // ES3 wrong here

	var CORRECT_ARGUMENTS = classofRaw(function () {
	  return arguments;
	}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) {
	    /* empty */
	  }
	}; // getting tag from ES6+ `Object.prototype.toString`


	var classof = toStringTagSupport ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
	  : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG$2)) == 'string' ? tag // builtinTag case
	  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
	  : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
	};

	// https://tc39.github.io/ecma262/#sec-object.prototype.tostring


	var objectToString = toStringTagSupport ? {}.toString : function toString() {
	  return '[object ' + classof(this) + ']';
	};

	// https://tc39.github.io/ecma262/#sec-object.prototype.tostring

	if (!toStringTagSupport) {
	  redefine(Object.prototype, 'toString', objectToString, {
	    unsafe: true
	  });
	}

	var inheritIfRequired = function ($this, dummy, Wrapper) {
	  var NewTarget, NewTargetPrototype;
	  if ( // it can work only with native `setPrototypeOf`
	  objectSetPrototypeOf && // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
	  typeof (NewTarget = dummy.constructor) == 'function' && NewTarget !== Wrapper && isObject(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype) objectSetPrototypeOf($this, NewTargetPrototype);
	  return $this;
	};

	var SPECIES$5 = wellKnownSymbol('species');

	var setSpecies = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
	  var defineProperty = objectDefineProperty.f;

	  if (descriptors && Constructor && !Constructor[SPECIES$5]) {
	    defineProperty(Constructor, SPECIES$5, {
	      configurable: true,
	      get: function () {
	        return this;
	      }
	    });
	  }
	};

	var defineProperty$5 = objectDefineProperty.f;
	var getOwnPropertyNames = objectGetOwnPropertyNames.f;
	var setInternalState$2 = internalState.set;
	var MATCH$2 = wellKnownSymbol('match');
	var NativeRegExp = global_1.RegExp;
	var RegExpPrototype = NativeRegExp.prototype;
	var re1 = /a/g;
	var re2 = /a/g; // "new" should create a new object, old webkit bug

	var CORRECT_NEW = new NativeRegExp(re1) !== re1;
	var UNSUPPORTED_Y$2 = regexpStickyHelpers.UNSUPPORTED_Y;
	var FORCED$2 = descriptors && isForced_1('RegExp', !CORRECT_NEW || UNSUPPORTED_Y$2 || fails(function () {
	  re2[MATCH$2] = false; // RegExp constructor can alter flags and IsRegExp works correct with @@match

	  return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
	})); // `RegExp` constructor
	// https://tc39.github.io/ecma262/#sec-regexp-constructor

	if (FORCED$2) {
	  var RegExpWrapper = function RegExp(pattern, flags) {
	    var thisIsRegExp = this instanceof RegExpWrapper;
	    var patternIsRegExp = isRegexp(pattern);
	    var flagsAreUndefined = flags === undefined;
	    var sticky;

	    if (!thisIsRegExp && patternIsRegExp && pattern.constructor === RegExpWrapper && flagsAreUndefined) {
	      return pattern;
	    }

	    if (CORRECT_NEW) {
	      if (patternIsRegExp && !flagsAreUndefined) pattern = pattern.source;
	    } else if (pattern instanceof RegExpWrapper) {
	      if (flagsAreUndefined) flags = regexpFlags.call(pattern);
	      pattern = pattern.source;
	    }

	    if (UNSUPPORTED_Y$2) {
	      sticky = !!flags && flags.indexOf('y') > -1;
	      if (sticky) flags = flags.replace(/y/g, '');
	    }

	    var result = inheritIfRequired(CORRECT_NEW ? new NativeRegExp(pattern, flags) : NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype, RegExpWrapper);
	    if (UNSUPPORTED_Y$2 && sticky) setInternalState$2(result, {
	      sticky: sticky
	    });
	    return result;
	  };

	  var proxy = function (key) {
	    key in RegExpWrapper || defineProperty$5(RegExpWrapper, key, {
	      configurable: true,
	      get: function () {
	        return NativeRegExp[key];
	      },
	      set: function (it) {
	        NativeRegExp[key] = it;
	      }
	    });
	  };

	  var keys$1 = getOwnPropertyNames(NativeRegExp);
	  var index = 0;

	  while (keys$1.length > index) proxy(keys$1[index++]);

	  RegExpPrototype.constructor = RegExpWrapper;
	  RegExpWrapper.prototype = RegExpPrototype;
	  redefine(global_1, 'RegExp', RegExpWrapper);
	} // https://tc39.github.io/ecma262/#sec-get-regexp-@@species


	setSpecies('RegExp');

	var TO_STRING = 'toString';
	var RegExpPrototype$1 = RegExp.prototype;
	var nativeToString = RegExpPrototype$1[TO_STRING];
	var NOT_GENERIC = fails(function () {
	  return nativeToString.call({
	    source: 'a',
	    flags: 'b'
	  }) != '/a/b';
	}); // FF44- RegExp#toString has a wrong name

	var INCORRECT_NAME = nativeToString.name != TO_STRING; // `RegExp.prototype.toString` method
	// https://tc39.github.io/ecma262/#sec-regexp.prototype.tostring

	if (NOT_GENERIC || INCORRECT_NAME) {
	  redefine(RegExp.prototype, TO_STRING, function toString() {
	    var R = anObject(this);
	    var p = String(R.source);
	    var rf = R.flags;
	    var f = String(rf === undefined && R instanceof RegExp && !('flags' in RegExpPrototype$1) ? regexpFlags.call(R) : rf);
	    return '/' + p + '/' + f;
	  }, {
	    unsafe: true
	  });
	}

	var charAt$1 = stringMultibyte.charAt;
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$3 = internalState.set;
	var getInternalState$2 = internalState.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-string.prototype-@@iterator

	defineIterator(String, 'String', function (iterated) {
	  setInternalState$3(this, {
	    type: STRING_ITERATOR,
	    string: String(iterated),
	    index: 0
	  }); // `%StringIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$2(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return {
	    value: undefined,
	    done: true
	  };
	  point = charAt$1(string, index);
	  state.index += point.length;
	  return {
	    value: point,
	    done: false
	  };
	});

	fixRegexpWellKnownSymbolLogic('match', 1, function (MATCH, nativeMatch, maybeCallNative) {
	  return [// `String.prototype.match` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.match
	  function match(regexp) {
	    var O = requireObjectCoercible(this);
	    var matcher = regexp == undefined ? undefined : regexp[MATCH];
	    return matcher !== undefined ? matcher.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
	  }, // `RegExp.prototype[@@match]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@match
	  function (regexp) {
	    var res = maybeCallNative(nativeMatch, regexp, this);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    if (!rx.global) return regexpExecAbstract(rx, S);
	    var fullUnicode = rx.unicode;
	    rx.lastIndex = 0;
	    var A = [];
	    var n = 0;
	    var result;

	    while ((result = regexpExecAbstract(rx, S)) !== null) {
	      var matchStr = String(result[0]);
	      A[n] = matchStr;
	      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
	      n++;
	    }

	    return n === 0 ? null : A;
	  }];
	});

	var max$3 = Math.max;
	var min$6 = Math.min;
	var floor$1 = Math.floor;
	var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d\d?|<[^>]*>)/g;
	var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d\d?)/g;

	var maybeToString = function (it) {
	  return it === undefined ? it : String(it);
	}; // @@replace logic


	fixRegexpWellKnownSymbolLogic('replace', 2, function (REPLACE, nativeReplace, maybeCallNative, reason) {
	  var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = reason.REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE;
	  var REPLACE_KEEPS_$0 = reason.REPLACE_KEEPS_$0;
	  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
	  return [// `String.prototype.replace` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.replace
	  function replace(searchValue, replaceValue) {
	    var O = requireObjectCoercible(this);
	    var replacer = searchValue == undefined ? undefined : searchValue[REPLACE];
	    return replacer !== undefined ? replacer.call(searchValue, O, replaceValue) : nativeReplace.call(String(O), searchValue, replaceValue);
	  }, // `RegExp.prototype[@@replace]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
	  function (regexp, replaceValue) {
	    if (!REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE && REPLACE_KEEPS_$0 || typeof replaceValue === 'string' && replaceValue.indexOf(UNSAFE_SUBSTITUTE) === -1) {
	      var res = maybeCallNative(nativeReplace, regexp, this, replaceValue);
	      if (res.done) return res.value;
	    }

	    var rx = anObject(regexp);
	    var S = String(this);
	    var functionalReplace = typeof replaceValue === 'function';
	    if (!functionalReplace) replaceValue = String(replaceValue);
	    var global = rx.global;

	    if (global) {
	      var fullUnicode = rx.unicode;
	      rx.lastIndex = 0;
	    }

	    var results = [];

	    while (true) {
	      var result = regexpExecAbstract(rx, S);
	      if (result === null) break;
	      results.push(result);
	      if (!global) break;
	      var matchStr = String(result[0]);
	      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
	    }

	    var accumulatedResult = '';
	    var nextSourcePosition = 0;

	    for (var i = 0; i < results.length; i++) {
	      result = results[i];
	      var matched = String(result[0]);
	      var position = max$3(min$6(toInteger(result.index), S.length), 0);
	      var captures = []; // NOTE: This is equivalent to
	      //   captures = result.slice(1).map(maybeToString)
	      // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
	      // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
	      // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.

	      for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));

	      var namedCaptures = result.groups;

	      if (functionalReplace) {
	        var replacerArgs = [matched].concat(captures, position, S);
	        if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);
	        var replacement = String(replaceValue.apply(undefined, replacerArgs));
	      } else {
	        replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
	      }

	      if (position >= nextSourcePosition) {
	        accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
	        nextSourcePosition = position + matched.length;
	      }
	    }

	    return accumulatedResult + S.slice(nextSourcePosition);
	  }]; // https://tc39.github.io/ecma262/#sec-getsubstitution

	  function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
	    var tailPos = position + matched.length;
	    var m = captures.length;
	    var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;

	    if (namedCaptures !== undefined) {
	      namedCaptures = toObject(namedCaptures);
	      symbols = SUBSTITUTION_SYMBOLS;
	    }

	    return nativeReplace.call(replacement, symbols, function (match, ch) {
	      var capture;

	      switch (ch.charAt(0)) {
	        case '$':
	          return '$';

	        case '&':
	          return matched;

	        case '`':
	          return str.slice(0, position);

	        case "'":
	          return str.slice(tailPos);

	        case '<':
	          capture = namedCaptures[ch.slice(1, -1)];
	          break;

	        default:
	          // \d\d?
	          var n = +ch;
	          if (n === 0) return match;

	          if (n > m) {
	            var f = floor$1(n / 10);
	            if (f === 0) return match;
	            if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
	            return match;
	          }

	          capture = captures[n - 1];
	      }

	      return capture === undefined ? '' : capture;
	    });
	  }
	});

	var ITERATOR$2 = wellKnownSymbol('iterator');
	var TO_STRING_TAG$3 = wellKnownSymbol('toStringTag');
	var ArrayValues = es_array_iterator.values;

	for (var COLLECTION_NAME$1 in domIterables) {
	  var Collection$1 = global_1[COLLECTION_NAME$1];
	  var CollectionPrototype$1 = Collection$1 && Collection$1.prototype;

	  if (CollectionPrototype$1) {
	    // some Chrome versions have non-configurable methods on DOMTokenList
	    if (CollectionPrototype$1[ITERATOR$2] !== ArrayValues) try {
	      createNonEnumerableProperty(CollectionPrototype$1, ITERATOR$2, ArrayValues);
	    } catch (error) {
	      CollectionPrototype$1[ITERATOR$2] = ArrayValues;
	    }

	    if (!CollectionPrototype$1[TO_STRING_TAG$3]) {
	      createNonEnumerableProperty(CollectionPrototype$1, TO_STRING_TAG$3, COLLECTION_NAME$1);
	    }

	    if (domIterables[COLLECTION_NAME$1]) for (var METHOD_NAME in es_array_iterator) {
	      // some Chrome versions have non-configurable methods on DOMTokenList
	      if (CollectionPrototype$1[METHOD_NAME] !== es_array_iterator[METHOD_NAME]) try {
	        createNonEnumerableProperty(CollectionPrototype$1, METHOD_NAME, es_array_iterator[METHOD_NAME]);
	      } catch (error) {
	        CollectionPrototype$1[METHOD_NAME] = es_array_iterator[METHOD_NAME];
	      }
	    }
	  }
	}

	/*!
	 * jQuery JavaScript Library v3.3.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/parseXML,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-event/ajax,-effects,-effects/Tween,-effects/animatedSelector
	 * https://jquery.com/
	 *
	 * Includes Sizzle.js
	 * https://sizzlejs.com/
	 *
	 * Copyright JS Foundation and other contributors
	 * Released under the MIT license
	 * https://jquery.org/license
	 *
	 * Date: 2018-01-20T17:24Z
	 */
	var arr = [];
	var document$2 = window.document;
	var getProto = Object.getPrototypeOf;
	var _slice = arr.slice;
	var concat = arr.concat;
	var push$1 = arr.push;
	var indexOf$1 = arr.indexOf;
	var class2type = {};
	var toString$2 = class2type.toString;
	var hasOwn = class2type.hasOwnProperty;
	var fnToString = hasOwn.toString;
	var ObjectFunctionString = fnToString.call(Object);
	var support = {};

	var isFunction = function isFunction(obj) {
	  // Support: Chrome <=57, Firefox <=52
	  // In some browsers, typeof returns "function" for HTML <object> elements
	  // (i.e., `typeof document.createElement( "object" ) === "function"`).
	  // We don't want to classify *any* DOM node as a function.
	  return typeof obj === "function" && typeof obj.nodeType !== "number";
	};

	var isWindow = function isWindow(obj) {
	  return obj != null && obj === obj.window;
	};

	var preservedScriptAttributes = {
	  type: true,
	  src: true,
	  noModule: true
	};

	function DOMEval(code, doc, node) {
	  doc = doc || document$2;
	  var i,
	      script = doc.createElement("script");
	  script.text = code;

	  if (node) {
	    for (i in preservedScriptAttributes) {
	      if (node[i]) {
	        script[i] = node[i];
	      }
	    }
	  }

	  doc.head.appendChild(script).parentNode.removeChild(script);
	}

	function toType(obj) {
	  if (obj == null) {
	    return obj + "";
	  } // Support: Android <=2.3 only (functionish RegExp)


	  return _typeof(obj) === "object" || typeof obj === "function" ? class2type[toString$2.call(obj)] || "object" : _typeof(obj);
	} // global Symbol
	// Defining this global in .eslintrc.json would create a danger of using the global
	// unguarded in another place, it seems safer to define global only for this module


	var version$1 = "3.3.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/parseXML,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-event/ajax,-effects,-effects/Tween,-effects/animatedSelector",
	    // Define a local copy of jQuery
	jQuery = function jQuery(selector, context) {
	  // The jQuery object is actually just the init constructor 'enhanced'
	  // Need init if jQuery is called (just allow error to be thrown if not included)
	  return new jQuery.fn.init(selector, context);
	},
	    // Support: Android <=4.0 only
	// Make sure we trim BOM and NBSP
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

	jQuery.fn = jQuery.prototype = {
	  // The current version of jQuery being used
	  jquery: version$1,
	  constructor: jQuery,
	  // The default length of a jQuery object is 0
	  length: 0,
	  toArray: function toArray() {
	    return _slice.call(this);
	  },
	  // Get the Nth element in the matched element set OR
	  // Get the whole matched element set as a clean array
	  get: function get(num) {
	    // Return all the elements in a clean array
	    if (num == null) {
	      return _slice.call(this);
	    } // Return just the one element from the set


	    return num < 0 ? this[num + this.length] : this[num];
	  },
	  // Take an array of elements and push it onto the stack
	  // (returning the new matched element set)
	  pushStack: function pushStack(elems) {
	    // Build a new jQuery matched element set
	    var ret = jQuery.merge(this.constructor(), elems); // Add the old object onto the stack (as a reference)

	    ret.prevObject = this; // Return the newly-formed element set

	    return ret;
	  },
	  // Execute a callback for every element in the matched set.
	  each: function each(callback) {
	    return jQuery.each(this, callback);
	  },
	  map: function map(callback) {
	    return this.pushStack(jQuery.map(this, function (elem, i) {
	      return callback.call(elem, i, elem);
	    }));
	  },
	  slice: function slice() {
	    return this.pushStack(_slice.apply(this, arguments));
	  },
	  first: function first() {
	    return this.eq(0);
	  },
	  last: function last() {
	    return this.eq(-1);
	  },
	  eq: function eq(i) {
	    var len = this.length,
	        j = +i + (i < 0 ? len : 0);
	    return this.pushStack(j >= 0 && j < len ? [this[j]] : []);
	  },
	  end: function end() {
	    return this.prevObject || this.constructor();
	  },
	  // For internal use only.
	  // Behaves like an Array's method, not like a jQuery method.
	  push: push$1,
	  sort: arr.sort,
	  splice: arr.splice
	};

	jQuery.extend = jQuery.fn.extend = function () {
	  var options,
	      name,
	      src,
	      copy,
	      copyIsArray,
	      clone,
	      target = arguments[0] || {},
	      i = 1,
	      length = arguments.length,
	      deep = false; // Handle a deep copy situation

	  if (typeof target === "boolean") {
	    deep = target; // Skip the boolean and the target

	    target = arguments[i] || {};
	    i++;
	  } // Handle case when target is a string or something (possible in deep copy)


	  if (_typeof(target) !== "object" && !isFunction(target)) {
	    target = {};
	  } // Extend jQuery itself if only one argument is passed


	  if (i === length) {
	    target = this;
	    i--;
	  }

	  for (; i < length; i++) {
	    // Only deal with non-null/undefined values
	    if ((options = arguments[i]) != null) {
	      // Extend the base object
	      for (name in options) {
	        src = target[name];
	        copy = options[name]; // Prevent never-ending loop

	        if (target === copy) {
	          continue;
	        } // Recurse if we're merging plain objects or arrays


	        if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = Array.isArray(copy)))) {
	          if (copyIsArray) {
	            copyIsArray = false;
	            clone = src && Array.isArray(src) ? src : [];
	          } else {
	            clone = src && jQuery.isPlainObject(src) ? src : {};
	          } // Never move original objects, clone them


	          target[name] = jQuery.extend(deep, clone, copy); // Don't bring in undefined values
	        } else if (copy !== undefined) {
	          target[name] = copy;
	        }
	      }
	    }
	  } // Return the modified object


	  return target;
	};

	jQuery.extend({
	  // Unique for each copy of jQuery on the page
	  expando: "jQuery" + (version$1 + Math.random()).replace(/\D/g, ""),
	  // Assume jQuery is ready without the ready module
	  isReady: true,
	  error: function error(msg) {
	    throw new Error(msg);
	  },
	  noop: function noop() {},
	  isPlainObject: function isPlainObject(obj) {
	    var proto, Ctor; // Detect obvious negatives
	    // Use toString instead of jQuery.type to catch host objects

	    if (!obj || toString$2.call(obj) !== "[object Object]") {
	      return false;
	    }

	    proto = getProto(obj); // Objects with no prototype (e.g., `Object.create( null )`) are plain

	    if (!proto) {
	      return true;
	    } // Objects with prototype are plain iff they were constructed by a global Object function


	    Ctor = hasOwn.call(proto, "constructor") && proto.constructor;
	    return typeof Ctor === "function" && fnToString.call(Ctor) === ObjectFunctionString;
	  },
	  isEmptyObject: function isEmptyObject(obj) {
	    /* eslint-disable no-unused-vars */
	    // See https://github.com/eslint/eslint/issues/6125
	    var name;

	    for (name in obj) {
	      return false;
	    }

	    return true;
	  },
	  // Evaluates a script in a global context
	  globalEval: function globalEval(code) {
	    DOMEval(code);
	  },
	  each: function each(obj, callback) {
	    var length,
	        i = 0;

	    if (isArrayLike(obj)) {
	      length = obj.length;

	      for (; i < length; i++) {
	        if (callback.call(obj[i], i, obj[i]) === false) {
	          break;
	        }
	      }
	    } else {
	      for (i in obj) {
	        if (callback.call(obj[i], i, obj[i]) === false) {
	          break;
	        }
	      }
	    }

	    return obj;
	  },
	  // Support: Android <=4.0 only
	  trim: function trim(text) {
	    return text == null ? "" : (text + "").replace(rtrim, "");
	  },
	  // results is for internal usage only
	  makeArray: function makeArray(arr, results) {
	    var ret = results || [];

	    if (arr != null) {
	      if (isArrayLike(Object(arr))) {
	        jQuery.merge(ret, typeof arr === "string" ? [arr] : arr);
	      } else {
	        push$1.call(ret, arr);
	      }
	    }

	    return ret;
	  },
	  inArray: function inArray(elem, arr, i) {
	    return arr == null ? -1 : indexOf$1.call(arr, elem, i);
	  },
	  // Support: Android <=4.0 only, PhantomJS 1 only
	  // push.apply(_, arraylike) throws on ancient WebKit
	  merge: function merge(first, second) {
	    var len = +second.length,
	        j = 0,
	        i = first.length;

	    for (; j < len; j++) {
	      first[i++] = second[j];
	    }

	    first.length = i;
	    return first;
	  },
	  grep: function grep(elems, callback, invert) {
	    var callbackInverse,
	        matches = [],
	        i = 0,
	        length = elems.length,
	        callbackExpect = !invert; // Go through the array, only saving the items
	    // that pass the validator function

	    for (; i < length; i++) {
	      callbackInverse = !callback(elems[i], i);

	      if (callbackInverse !== callbackExpect) {
	        matches.push(elems[i]);
	      }
	    }

	    return matches;
	  },
	  // arg is for internal usage only
	  map: function map(elems, callback, arg) {
	    var length,
	        value,
	        i = 0,
	        ret = []; // Go through the array, translating each of the items to their new values

	    if (isArrayLike(elems)) {
	      length = elems.length;

	      for (; i < length; i++) {
	        value = callback(elems[i], i, arg);

	        if (value != null) {
	          ret.push(value);
	        }
	      } // Go through every key on the object,

	    } else {
	      for (i in elems) {
	        value = callback(elems[i], i, arg);

	        if (value != null) {
	          ret.push(value);
	        }
	      }
	    } // Flatten any nested arrays


	    return concat.apply([], ret);
	  },
	  // A global GUID counter for objects
	  guid: 1,
	  // jQuery.support is not used in Core but other projects attach their
	  // properties to it so it needs to exist.
	  support: support
	});

	if (typeof Symbol === "function") {
	  jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
	} // Populate the class2type map


	jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function (i, name) {
	  class2type["[object " + name + "]"] = name.toLowerCase();
	});

	function isArrayLike(obj) {
	  // Support: real iOS 8.2 only (not reproducible in simulator)
	  // `in` check used to prevent JIT error (gh-2145)
	  // hasOwn isn't used here due to false negatives
	  // regarding Nodelist length in IE
	  var length = !!obj && "length" in obj && obj.length,
	      type = toType(obj);

	  if (isFunction(obj) || isWindow(obj)) {
	    return false;
	  }

	  return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
	}

	var Sizzle =
	/*!
	* Sizzle CSS Selector Engine v2.3.3
	* https://sizzlejs.com/
	*
	* Copyright jQuery Foundation and other contributors
	* Released under the MIT license
	* http://jquery.org/license
	*
	* Date: 2016-08-08
	*/
	function (window) {
	  var i,
	      support,
	      Expr,
	      getText,
	      isXML,
	      tokenize,
	      compile,
	      select,
	      outermostContext,
	      sortInput,
	      hasDuplicate,
	      // Local document vars
	  setDocument,
	      document,
	      docElem,
	      documentIsHTML,
	      rbuggyQSA,
	      rbuggyMatches,
	      matches,
	      contains,
	      // Instance-specific data
	  expando = "sizzle" + 1 * new Date(),
	      preferredDoc = window.document,
	      dirruns = 0,
	      done = 0,
	      classCache = createCache(),
	      tokenCache = createCache(),
	      compilerCache = createCache(),
	      sortOrder = function sortOrder(a, b) {
	    if (a === b) {
	      hasDuplicate = true;
	    }

	    return 0;
	  },
	      // Instance methods
	  hasOwn = {}.hasOwnProperty,
	      arr = [],
	      pop = arr.pop,
	      push_native = arr.push,
	      push = arr.push,
	      slice = arr.slice,
	      // Use a stripped-down indexOf as it's faster than native
	  // https://jsperf.com/thor-indexof-vs-for/5
	  indexOf = function indexOf(list, elem) {
	    var i = 0,
	        len = list.length;

	    for (; i < len; i++) {
	      if (list[i] === elem) {
	        return i;
	      }
	    }

	    return -1;
	  },
	      booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",
	      // Regular expressions
	  // http://www.w3.org/TR/css3-selectors/#whitespace
	  whitespace = "[\\x20\\t\\r\\n\\f]",
	      // http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	  identifier = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+",
	      // Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	  attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace + // Operator (capture 2)
	  "*([*^$|!~]?=)" + whitespace + // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
	  "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace + "*\\]",
	      pseudos = ":(" + identifier + ")(?:\\((" + // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
	  // 1. quoted (capture 3; capture 4 or capture 5)
	  "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" + // 2. simple (capture 6)
	  "((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" + // 3. anything else (capture 2)
	  ".*" + ")\\)|)",
	      // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	  rwhitespace = new RegExp(whitespace + "+", "g"),
	      rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),
	      rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
	      rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"),
	      rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"),
	      rpseudo = new RegExp(pseudos),
	      ridentifier = new RegExp("^" + identifier + "$"),
	      matchExpr = {
	    "ID": new RegExp("^#(" + identifier + ")"),
	    "CLASS": new RegExp("^\\.(" + identifier + ")"),
	    "TAG": new RegExp("^(" + identifier + "|[*])"),
	    "ATTR": new RegExp("^" + attributes),
	    "PSEUDO": new RegExp("^" + pseudos),
	    "CHILD": new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
	    "bool": new RegExp("^(?:" + booleans + ")$", "i"),
	    // For use in libraries implementing .is()
	    // We use this for POS matching in `select`
	    "needsContext": new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
	  },
	      rinputs = /^(?:input|select|textarea|button)$/i,
	      rheader = /^h\d$/i,
	      rnative = /^[^{]+\{\s*\[native \w/,
	      // Easily-parseable/retrievable ID or TAG or CLASS selectors
	  rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,
	      rsibling = /[+~]/,
	      // CSS escapes
	  // http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	  runescape = new RegExp("\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig"),
	      funescape = function funescape(_, escaped, escapedWhitespace) {
	    var high = "0x" + escaped - 0x10000; // NaN means non-codepoint
	    // Support: Firefox<24
	    // Workaround erroneous numeric interpretation of +"0x"

	    return high !== high || escapedWhitespace ? escaped : high < 0 ? // BMP codepoint
	    String.fromCharCode(high + 0x10000) : // Supplemental Plane codepoint (surrogate pair)
	    String.fromCharCode(high >> 10 | 0xD800, high & 0x3FF | 0xDC00);
	  },
	      // CSS string/identifier serialization
	  // https://drafts.csswg.org/cssom/#common-serializing-idioms
	  // eslint-disable-next-line no-control-regex
	  rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	      fcssescape = function fcssescape(ch, asCodePoint) {
	    if (asCodePoint) {
	      // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
	      if (ch === "\0") {
	        return "\uFFFD";
	      } // Control characters and (dependent upon position) numbers get escaped as code points


	      return ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " ";
	    } // Other potentially-special ASCII characters get backslash-escaped


	    return "\\" + ch;
	  },
	      // Used for iframes
	  // See setDocument()
	  // Removing the function wrapper causes a "Permission Denied"
	  // error in IE
	  unloadHandler = function unloadHandler() {
	    setDocument();
	  },
	      disabledAncestor = addCombinator(function (elem) {
	    return elem.disabled === true && ("form" in elem || "label" in elem);
	  }, {
	    dir: "parentNode",
	    next: "legend"
	  }); // Optimize for push.apply( _, NodeList )


	  try {
	    push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes); // Support: Android<4.0
	    // Detect silently failing push.apply

	    arr[preferredDoc.childNodes.length].nodeType;
	  } catch (e) {
	    push = {
	      apply: arr.length ? // Leverage slice if possible
	      function (target, els) {
	        push_native.apply(target, slice.call(els));
	      } : // Support: IE<9
	      // Otherwise append directly
	      function (target, els) {
	        var j = target.length,
	            i = 0; // Can't trust NodeList.length

	        while (target[j++] = els[i++]) {}

	        target.length = j - 1;
	      }
	    };
	  }

	  function Sizzle(selector, context, results, seed) {
	    var m,
	        i,
	        elem,
	        nid,
	        match,
	        groups,
	        newSelector,
	        newContext = context && context.ownerDocument,
	        // nodeType defaults to 9, since context defaults to document
	    nodeType = context ? context.nodeType : 9;
	    results = results || []; // Return early from calls with invalid selector or context

	    if (typeof selector !== "string" || !selector || nodeType !== 1 && nodeType !== 9 && nodeType !== 11) {
	      return results;
	    } // Try to shortcut find operations (as opposed to filters) in HTML documents


	    if (!seed) {
	      if ((context ? context.ownerDocument || context : preferredDoc) !== document) {
	        setDocument(context);
	      }

	      context = context || document;

	      if (documentIsHTML) {
	        // If the selector is sufficiently simple, try using a "get*By*" DOM method
	        // (excepting DocumentFragment context, where the methods don't exist)
	        if (nodeType !== 11 && (match = rquickExpr.exec(selector))) {
	          // ID selector
	          if (m = match[1]) {
	            // Document context
	            if (nodeType === 9) {
	              if (elem = context.getElementById(m)) {
	                // Support: IE, Opera, Webkit
	                // TODO: identify versions
	                // getElementById can match elements by name instead of ID
	                if (elem.id === m) {
	                  results.push(elem);
	                  return results;
	                }
	              } else {
	                return results;
	              } // Element context

	            } else {
	              // Support: IE, Opera, Webkit
	              // TODO: identify versions
	              // getElementById can match elements by name instead of ID
	              if (newContext && (elem = newContext.getElementById(m)) && contains(context, elem) && elem.id === m) {
	                results.push(elem);
	                return results;
	              }
	            } // Type selector

	          } else if (match[2]) {
	            push.apply(results, context.getElementsByTagName(selector));
	            return results; // Class selector
	          } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {
	            push.apply(results, context.getElementsByClassName(m));
	            return results;
	          }
	        } // Take advantage of querySelectorAll


	        if (support.qsa && !compilerCache[selector + " "] && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
	          if (nodeType !== 1) {
	            newContext = context;
	            newSelector = selector; // qSA looks outside Element context, which is not what we want
	            // Thanks to Andrew Dupont for this workaround technique
	            // Support: IE <=8
	            // Exclude object elements
	          } else if (context.nodeName.toLowerCase() !== "object") {
	            // Capture the context ID, setting it first if necessary
	            if (nid = context.getAttribute("id")) {
	              nid = nid.replace(rcssescape, fcssescape);
	            } else {
	              context.setAttribute("id", nid = expando);
	            } // Prefix every selector in the list


	            groups = tokenize(selector);
	            i = groups.length;

	            while (i--) {
	              groups[i] = "#" + nid + " " + toSelector(groups[i]);
	            }

	            newSelector = groups.join(","); // Expand context for sibling selectors

	            newContext = rsibling.test(selector) && testContext(context.parentNode) || context;
	          }

	          if (newSelector) {
	            try {
	              push.apply(results, newContext.querySelectorAll(newSelector));
	              return results;
	            } catch (qsaError) {} finally {
	              if (nid === expando) {
	                context.removeAttribute("id");
	              }
	            }
	          }
	        }
	      }
	    } // All others


	    return select(selector.replace(rtrim, "$1"), context, results, seed);
	  }
	  /**
	   * Create key-value caches of limited size
	   * @returns {function(string, object)} Returns the Object data after storing it on itself with
	   *    property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
	   *    deleting the oldest entry
	   */


	  function createCache() {
	    var keys = [];

	    function cache(key, value) {
	      // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
	      if (keys.push(key + " ") > Expr.cacheLength) {
	        // Only keep the most recent entries
	        delete cache[keys.shift()];
	      }

	      return cache[key + " "] = value;
	    }

	    return cache;
	  }
	  /**
	   * Mark a function for special use by Sizzle
	   * @param {Function} fn The function to mark
	   */


	  function markFunction(fn) {
	    fn[expando] = true;
	    return fn;
	  }
	  /**
	   * Support testing using an element
	   * @param {Function} fn Passed the created element and returns a boolean result
	   */


	  function assert(fn) {
	    var el = document.createElement("fieldset");

	    try {
	      return !!fn(el);
	    } catch (e) {
	      return false;
	    } finally {
	      // Remove from its parent by default
	      if (el.parentNode) {
	        el.parentNode.removeChild(el);
	      } // release memory in IE


	      el = null;
	    }
	  }
	  /**
	   * Checks document order of two siblings
	   * @param {Element} a
	   * @param {Element} b
	   * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
	   */


	  function siblingCheck(a, b) {
	    var cur = b && a,
	        diff = cur && a.nodeType === 1 && b.nodeType === 1 && a.sourceIndex - b.sourceIndex; // Use IE sourceIndex if available on both nodes

	    if (diff) {
	      return diff;
	    } // Check if b follows a


	    if (cur) {
	      while (cur = cur.nextSibling) {
	        if (cur === b) {
	          return -1;
	        }
	      }
	    }

	    return a ? 1 : -1;
	  }
	  /**
	   * Returns a function to use in pseudos for input types
	   * @param {String} type
	   */


	  function createInputPseudo(type) {
	    return function (elem) {
	      var name = elem.nodeName.toLowerCase();
	      return name === "input" && elem.type === type;
	    };
	  }
	  /**
	   * Returns a function to use in pseudos for buttons
	   * @param {String} type
	   */


	  function createButtonPseudo(type) {
	    return function (elem) {
	      var name = elem.nodeName.toLowerCase();
	      return (name === "input" || name === "button") && elem.type === type;
	    };
	  }
	  /**
	   * Returns a function to use in pseudos for :enabled/:disabled
	   * @param {Boolean} disabled true for :disabled; false for :enabled
	   */


	  function createDisabledPseudo(disabled) {
	    // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	    return function (elem) {
	      // Only certain elements can match :enabled or :disabled
	      // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
	      // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
	      if ("form" in elem) {
	        // Check for inherited disabledness on relevant non-disabled elements:
	        // * listed form-associated elements in a disabled fieldset
	        //   https://html.spec.whatwg.org/multipage/forms.html#category-listed
	        //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
	        // * option elements in a disabled optgroup
	        //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
	        // All such elements have a "form" property.
	        if (elem.parentNode && elem.disabled === false) {
	          // Option elements defer to a parent optgroup if present
	          if ("label" in elem) {
	            if ("label" in elem.parentNode) {
	              return elem.parentNode.disabled === disabled;
	            } else {
	              return elem.disabled === disabled;
	            }
	          } // Support: IE 6 - 11
	          // Use the isDisabled shortcut property to check for disabled fieldset ancestors


	          return elem.isDisabled === disabled || // Where there is no isDisabled, check manually

	          /* jshint -W018 */
	          elem.isDisabled !== !disabled && disabledAncestor(elem) === disabled;
	        }

	        return elem.disabled === disabled; // Try to winnow out elements that can't be disabled before trusting the disabled property.
	        // Some victims get caught in our net (label, legend, menu, track), but it shouldn't
	        // even exist on them, let alone have a boolean value.
	      } else if ("label" in elem) {
	        return elem.disabled === disabled;
	      } // Remaining elements are neither :enabled nor :disabled


	      return false;
	    };
	  }
	  /**
	   * Returns a function to use in pseudos for positionals
	   * @param {Function} fn
	   */


	  function createPositionalPseudo(fn) {
	    return markFunction(function (argument) {
	      argument = +argument;
	      return markFunction(function (seed, matches) {
	        var j,
	            matchIndexes = fn([], seed.length, argument),
	            i = matchIndexes.length; // Match elements found at the specified indexes

	        while (i--) {
	          if (seed[j = matchIndexes[i]]) {
	            seed[j] = !(matches[j] = seed[j]);
	          }
	        }
	      });
	    });
	  }
	  /**
	   * Checks a node for validity as a Sizzle context
	   * @param {Element|Object=} context
	   * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
	   */


	  function testContext(context) {
	    return context && typeof context.getElementsByTagName !== "undefined" && context;
	  } // Expose support vars for convenience


	  support = Sizzle.support = {};
	  /**
	   * Detects XML nodes
	   * @param {Element|Object} elem An element or a document
	   * @returns {Boolean} True iff elem is a non-HTML XML node
	   */

	  isXML = Sizzle.isXML = function (elem) {
	    // documentElement is verified for cases where it doesn't yet exist
	    // (such as loading iframes in IE - #4833)
	    var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	    return documentElement ? documentElement.nodeName !== "HTML" : false;
	  };
	  /**
	   * Sets document-related variables once based on the current document
	   * @param {Element|Object} [doc] An element or document object to use to set the document
	   * @returns {Object} Returns the current document
	   */


	  setDocument = Sizzle.setDocument = function (node) {
	    var hasCompare,
	        subWindow,
	        doc = node ? node.ownerDocument || node : preferredDoc; // Return early if doc is invalid or already selected

	    if (doc === document || doc.nodeType !== 9 || !doc.documentElement) {
	      return document;
	    } // Update global variables


	    document = doc;
	    docElem = document.documentElement;
	    documentIsHTML = !isXML(document); // Support: IE 9-11, Edge
	    // Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)

	    if (preferredDoc !== document && (subWindow = document.defaultView) && subWindow.top !== subWindow) {
	      // Support: IE 11, Edge
	      if (subWindow.addEventListener) {
	        subWindow.addEventListener("unload", unloadHandler, false); // Support: IE 9 - 10 only
	      } else if (subWindow.attachEvent) {
	        subWindow.attachEvent("onunload", unloadHandler);
	      }
	    }
	    /* Attributes
	    ---------------------------------------------------------------------- */
	    // Support: IE<8
	    // Verify that getAttribute really returns attributes and not properties
	    // (excepting IE8 booleans)


	    support.attributes = assert(function (el) {
	      el.className = "i";
	      return !el.getAttribute("className");
	    });
	    /* getElement(s)By*
	    ---------------------------------------------------------------------- */
	    // Check if getElementsByTagName("*") returns only elements

	    support.getElementsByTagName = assert(function (el) {
	      el.appendChild(document.createComment(""));
	      return !el.getElementsByTagName("*").length;
	    }); // Support: IE<9

	    support.getElementsByClassName = rnative.test(document.getElementsByClassName); // Support: IE<10
	    // Check if getElementById returns elements by name
	    // The broken getElementById methods don't pick up programmatically-set names,
	    // so use a roundabout getElementsByName test

	    support.getById = assert(function (el) {
	      docElem.appendChild(el).id = expando;
	      return !document.getElementsByName || !document.getElementsByName(expando).length;
	    }); // ID filter and find

	    if (support.getById) {
	      Expr.filter["ID"] = function (id) {
	        var attrId = id.replace(runescape, funescape);
	        return function (elem) {
	          return elem.getAttribute("id") === attrId;
	        };
	      };

	      Expr.find["ID"] = function (id, context) {
	        if (typeof context.getElementById !== "undefined" && documentIsHTML) {
	          var elem = context.getElementById(id);
	          return elem ? [elem] : [];
	        }
	      };
	    } else {
	      Expr.filter["ID"] = function (id) {
	        var attrId = id.replace(runescape, funescape);
	        return function (elem) {
	          var node = typeof elem.getAttributeNode !== "undefined" && elem.getAttributeNode("id");
	          return node && node.value === attrId;
	        };
	      }; // Support: IE 6 - 7 only
	      // getElementById is not reliable as a find shortcut


	      Expr.find["ID"] = function (id, context) {
	        if (typeof context.getElementById !== "undefined" && documentIsHTML) {
	          var node,
	              i,
	              elems,
	              elem = context.getElementById(id);

	          if (elem) {
	            // Verify the id attribute
	            node = elem.getAttributeNode("id");

	            if (node && node.value === id) {
	              return [elem];
	            } // Fall back on getElementsByName


	            elems = context.getElementsByName(id);
	            i = 0;

	            while (elem = elems[i++]) {
	              node = elem.getAttributeNode("id");

	              if (node && node.value === id) {
	                return [elem];
	              }
	            }
	          }

	          return [];
	        }
	      };
	    } // Tag


	    Expr.find["TAG"] = support.getElementsByTagName ? function (tag, context) {
	      if (typeof context.getElementsByTagName !== "undefined") {
	        return context.getElementsByTagName(tag); // DocumentFragment nodes don't have gEBTN
	      } else if (support.qsa) {
	        return context.querySelectorAll(tag);
	      }
	    } : function (tag, context) {
	      var elem,
	          tmp = [],
	          i = 0,
	          // By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
	      results = context.getElementsByTagName(tag); // Filter out possible comments

	      if (tag === "*") {
	        while (elem = results[i++]) {
	          if (elem.nodeType === 1) {
	            tmp.push(elem);
	          }
	        }

	        return tmp;
	      }

	      return results;
	    }; // Class

	    Expr.find["CLASS"] = support.getElementsByClassName && function (className, context) {
	      if (typeof context.getElementsByClassName !== "undefined" && documentIsHTML) {
	        return context.getElementsByClassName(className);
	      }
	    };
	    /* QSA/matchesSelector
	    ---------------------------------------------------------------------- */
	    // QSA and matchesSelector support
	    // matchesSelector(:active) reports false when true (IE9/Opera 11.5)


	    rbuggyMatches = []; // qSa(:focus) reports false when true (Chrome 21)
	    // We allow this because of a bug in IE8/9 that throws an error
	    // whenever `document.activeElement` is accessed on an iframe
	    // So, we allow :focus to pass through QSA all the time to avoid the IE error
	    // See https://bugs.jquery.com/ticket/13378

	    rbuggyQSA = [];

	    if (support.qsa = rnative.test(document.querySelectorAll)) {
	      // Build QSA regex
	      // Regex strategy adopted from Diego Perini
	      assert(function (el) {
	        // Select is set to empty string on purpose
	        // This is to test IE's treatment of not explicitly
	        // setting a boolean content attribute,
	        // since its presence should be enough
	        // https://bugs.jquery.com/ticket/12359
	        docElem.appendChild(el).innerHTML = "<a id='" + expando + "'></a>" + "<select id='" + expando + "-\r\\' msallowcapture=''>" + "<option selected=''></option></select>"; // Support: IE8, Opera 11-12.16
	        // Nothing should be selected when empty strings follow ^= or $= or *=
	        // The test attribute must be unknown in Opera but "safe" for WinRT
	        // https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section

	        if (el.querySelectorAll("[msallowcapture^='']").length) {
	          rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")");
	        } // Support: IE8
	        // Boolean attributes and "value" are not treated correctly


	        if (!el.querySelectorAll("[selected]").length) {
	          rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")");
	        } // Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+


	        if (!el.querySelectorAll("[id~=" + expando + "-]").length) {
	          rbuggyQSA.push("~=");
	        } // Webkit/Opera - :checked should return selected option elements
	        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
	        // IE8 throws error here and will not see later tests


	        if (!el.querySelectorAll(":checked").length) {
	          rbuggyQSA.push(":checked");
	        } // Support: Safari 8+, iOS 8+
	        // https://bugs.webkit.org/show_bug.cgi?id=136851
	        // In-page `selector#id sibling-combinator selector` fails


	        if (!el.querySelectorAll("a#" + expando + "+*").length) {
	          rbuggyQSA.push(".#.+[+~]");
	        }
	      });
	      assert(function (el) {
	        el.innerHTML = "<a href='' disabled='disabled'></a>" + "<select disabled='disabled'><option/></select>"; // Support: Windows 8 Native Apps
	        // The type and name attributes are restricted during .innerHTML assignment

	        var input = document.createElement("input");
	        input.setAttribute("type", "hidden");
	        el.appendChild(input).setAttribute("name", "D"); // Support: IE8
	        // Enforce case-sensitivity of name attribute

	        if (el.querySelectorAll("[name=d]").length) {
	          rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
	        } // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
	        // IE8 throws error here and will not see later tests


	        if (el.querySelectorAll(":enabled").length !== 2) {
	          rbuggyQSA.push(":enabled", ":disabled");
	        } // Support: IE9-11+
	        // IE's :disabled selector does not pick up the children of disabled fieldsets


	        docElem.appendChild(el).disabled = true;

	        if (el.querySelectorAll(":disabled").length !== 2) {
	          rbuggyQSA.push(":enabled", ":disabled");
	        } // Opera 10-11 does not throw on post-comma invalid pseudos


	        el.querySelectorAll("*,:x");
	        rbuggyQSA.push(",.*:");
	      });
	    }

	    if (support.matchesSelector = rnative.test(matches = docElem.matches || docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) {
	      assert(function (el) {
	        // Check to see if it's possible to do matchesSelector
	        // on a disconnected node (IE 9)
	        support.disconnectedMatch = matches.call(el, "*"); // This should fail with an exception
	        // Gecko does not error, returns false instead

	        matches.call(el, "[s!='']:x");
	        rbuggyMatches.push("!=", pseudos);
	      });
	    }

	    rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
	    rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));
	    /* Contains
	    ---------------------------------------------------------------------- */

	    hasCompare = rnative.test(docElem.compareDocumentPosition); // Element contains another
	    // Purposefully self-exclusive
	    // As in, an element does not contain itself

	    contains = hasCompare || rnative.test(docElem.contains) ? function (a, b) {
	      var adown = a.nodeType === 9 ? a.documentElement : a,
	          bup = b && b.parentNode;
	      return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));
	    } : function (a, b) {
	      if (b) {
	        while (b = b.parentNode) {
	          if (b === a) {
	            return true;
	          }
	        }
	      }

	      return false;
	    };
	    /* Sorting
	    ---------------------------------------------------------------------- */
	    // Document order sorting

	    sortOrder = hasCompare ? function (a, b) {
	      // Flag for duplicate removal
	      if (a === b) {
	        hasDuplicate = true;
	        return 0;
	      } // Sort on method existence if only one input has compareDocumentPosition


	      var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;

	      if (compare) {
	        return compare;
	      } // Calculate position if both inputs belong to the same document


	      compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : // Otherwise we know they are disconnected
	      1; // Disconnected nodes

	      if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {
	        // Choose the first element that is related to our preferred document
	        if (a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) {
	          return -1;
	        }

	        if (b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b)) {
	          return 1;
	        } // Maintain original order


	        return sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0;
	      }

	      return compare & 4 ? -1 : 1;
	    } : function (a, b) {
	      // Exit early if the nodes are identical
	      if (a === b) {
	        hasDuplicate = true;
	        return 0;
	      }

	      var cur,
	          i = 0,
	          aup = a.parentNode,
	          bup = b.parentNode,
	          ap = [a],
	          bp = [b]; // Parentless nodes are either documents or disconnected

	      if (!aup || !bup) {
	        return a === document ? -1 : b === document ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0; // If the nodes are siblings, we can do a quick check
	      } else if (aup === bup) {
	        return siblingCheck(a, b);
	      } // Otherwise we need full lists of their ancestors for comparison


	      cur = a;

	      while (cur = cur.parentNode) {
	        ap.unshift(cur);
	      }

	      cur = b;

	      while (cur = cur.parentNode) {
	        bp.unshift(cur);
	      } // Walk down the tree looking for a discrepancy


	      while (ap[i] === bp[i]) {
	        i++;
	      }

	      return i ? // Do a sibling check if the nodes have a common ancestor
	      siblingCheck(ap[i], bp[i]) : // Otherwise nodes in our document sort first
	      ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0;
	    };
	    return document;
	  };

	  Sizzle.matches = function (expr, elements) {
	    return Sizzle(expr, null, null, elements);
	  };

	  Sizzle.matchesSelector = function (elem, expr) {
	    // Set document vars if needed
	    if ((elem.ownerDocument || elem) !== document) {
	      setDocument(elem);
	    } // Make sure that attribute selectors are quoted


	    expr = expr.replace(rattributeQuotes, "='$1']");

	    if (support.matchesSelector && documentIsHTML && !compilerCache[expr + " "] && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) {
	      try {
	        var ret = matches.call(elem, expr); // IE 9's matchesSelector returns false on disconnected nodes

	        if (ret || support.disconnectedMatch || // As well, disconnected nodes are said to be in a document
	        // fragment in IE 9
	        elem.document && elem.document.nodeType !== 11) {
	          return ret;
	        }
	      } catch (e) {}
	    }

	    return Sizzle(expr, document, null, [elem]).length > 0;
	  };

	  Sizzle.contains = function (context, elem) {
	    // Set document vars if needed
	    if ((context.ownerDocument || context) !== document) {
	      setDocument(context);
	    }

	    return contains(context, elem);
	  };

	  Sizzle.attr = function (elem, name) {
	    // Set document vars if needed
	    if ((elem.ownerDocument || elem) !== document) {
	      setDocument(elem);
	    }

	    var fn = Expr.attrHandle[name.toLowerCase()],
	        // Don't get fooled by Object.prototype properties (jQuery #13807)
	    val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;
	    return val !== undefined ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
	  };

	  Sizzle.escape = function (sel) {
	    return (sel + "").replace(rcssescape, fcssescape);
	  };

	  Sizzle.error = function (msg) {
	    throw new Error("Syntax error, unrecognized expression: " + msg);
	  };
	  /**
	   * Document sorting and removing duplicates
	   * @param {ArrayLike} results
	   */


	  Sizzle.uniqueSort = function (results) {
	    var elem,
	        duplicates = [],
	        j = 0,
	        i = 0; // Unless we *know* we can detect duplicates, assume their presence

	    hasDuplicate = !support.detectDuplicates;
	    sortInput = !support.sortStable && results.slice(0);
	    results.sort(sortOrder);

	    if (hasDuplicate) {
	      while (elem = results[i++]) {
	        if (elem === results[i]) {
	          j = duplicates.push(i);
	        }
	      }

	      while (j--) {
	        results.splice(duplicates[j], 1);
	      }
	    } // Clear input after sorting to release objects
	    // See https://github.com/jquery/sizzle/pull/225


	    sortInput = null;
	    return results;
	  };
	  /**
	   * Utility function for retrieving the text value of an array of DOM nodes
	   * @param {Array|Element} elem
	   */


	  getText = Sizzle.getText = function (elem) {
	    var node,
	        ret = "",
	        i = 0,
	        nodeType = elem.nodeType;

	    if (!nodeType) {
	      // If no nodeType, this is expected to be an array
	      while (node = elem[i++]) {
	        // Do not traverse comment nodes
	        ret += getText(node);
	      }
	    } else if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
	      // Use textContent for elements
	      // innerText usage removed for consistency of new lines (jQuery #11153)
	      if (typeof elem.textContent === "string") {
	        return elem.textContent;
	      } else {
	        // Traverse its children
	        for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
	          ret += getText(elem);
	        }
	      }
	    } else if (nodeType === 3 || nodeType === 4) {
	      return elem.nodeValue;
	    } // Do not include comment or processing instruction nodes


	    return ret;
	  };

	  Expr = Sizzle.selectors = {
	    // Can be adjusted by the user
	    cacheLength: 50,
	    createPseudo: markFunction,
	    match: matchExpr,
	    attrHandle: {},
	    find: {},
	    relative: {
	      ">": {
	        dir: "parentNode",
	        first: true
	      },
	      " ": {
	        dir: "parentNode"
	      },
	      "+": {
	        dir: "previousSibling",
	        first: true
	      },
	      "~": {
	        dir: "previousSibling"
	      }
	    },
	    preFilter: {
	      "ATTR": function ATTR(match) {
	        match[1] = match[1].replace(runescape, funescape); // Move the given value to match[3] whether quoted or unquoted

	        match[3] = (match[3] || match[4] || match[5] || "").replace(runescape, funescape);

	        if (match[2] === "~=") {
	          match[3] = " " + match[3] + " ";
	        }

	        return match.slice(0, 4);
	      },
	      "CHILD": function CHILD(match) {
	        /* matches from matchExpr["CHILD"]
	        1 type (only|nth|...)
	        2 what (child|of-type)
	        3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
	        4 xn-component of xn+y argument ([+-]?\d*n|)
	        5 sign of xn-component
	        6 x of xn-component
	        7 sign of y-component
	        8 y of y-component
	        */
	        match[1] = match[1].toLowerCase();

	        if (match[1].slice(0, 3) === "nth") {
	          // nth-* requires argument
	          if (!match[3]) {
	            Sizzle.error(match[0]);
	          } // numeric x and y parameters for Expr.filter.CHILD
	          // remember that false/true cast respectively to 0/1


	          match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === "even" || match[3] === "odd"));
	          match[5] = +(match[7] + match[8] || match[3] === "odd"); // other types prohibit arguments
	        } else if (match[3]) {
	          Sizzle.error(match[0]);
	        }

	        return match;
	      },
	      "PSEUDO": function PSEUDO(match) {
	        var excess,
	            unquoted = !match[6] && match[2];

	        if (matchExpr["CHILD"].test(match[0])) {
	          return null;
	        } // Accept quoted arguments as-is


	        if (match[3]) {
	          match[2] = match[4] || match[5] || ""; // Strip excess characters from unquoted arguments
	        } else if (unquoted && rpseudo.test(unquoted) && ( // Get excess from tokenize (recursively)
	        excess = tokenize(unquoted, true)) && ( // advance to the next closing parenthesis
	        excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {
	          // excess is a negative index
	          match[0] = match[0].slice(0, excess);
	          match[2] = unquoted.slice(0, excess);
	        } // Return only captures needed by the pseudo filter method (type and argument)


	        return match.slice(0, 3);
	      }
	    },
	    filter: {
	      "TAG": function TAG(nodeNameSelector) {
	        var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
	        return nodeNameSelector === "*" ? function () {
	          return true;
	        } : function (elem) {
	          return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
	        };
	      },
	      "CLASS": function CLASS(className) {
	        var pattern = classCache[className + " "];
	        return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function (elem) {
	          return pattern.test(typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "");
	        });
	      },
	      "ATTR": function ATTR(name, operator, check) {
	        return function (elem) {
	          var result = Sizzle.attr(elem, name);

	          if (result == null) {
	            return operator === "!=";
	          }

	          if (!operator) {
	            return true;
	          }

	          result += "";
	          return operator === "=" ? result === check : operator === "!=" ? result !== check : operator === "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result.replace(rwhitespace, " ") + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : false;
	        };
	      },
	      "CHILD": function CHILD(type, what, argument, first, last) {
	        var simple = type.slice(0, 3) !== "nth",
	            forward = type.slice(-4) !== "last",
	            ofType = what === "of-type";
	        return first === 1 && last === 0 ? // Shortcut for :nth-*(n)
	        function (elem) {
	          return !!elem.parentNode;
	        } : function (elem, context, xml) {
	          var cache,
	              uniqueCache,
	              outerCache,
	              node,
	              nodeIndex,
	              start,
	              dir = simple !== forward ? "nextSibling" : "previousSibling",
	              parent = elem.parentNode,
	              name = ofType && elem.nodeName.toLowerCase(),
	              useCache = !xml && !ofType,
	              diff = false;

	          if (parent) {
	            // :(first|last|only)-(child|of-type)
	            if (simple) {
	              while (dir) {
	                node = elem;

	                while (node = node[dir]) {
	                  if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) {
	                    return false;
	                  }
	                } // Reverse direction for :only-* (if we haven't yet done so)


	                start = dir = type === "only" && !start && "nextSibling";
	              }

	              return true;
	            }

	            start = [forward ? parent.firstChild : parent.lastChild]; // non-xml :nth-child(...) stores cache data on `parent`

	            if (forward && useCache) {
	              // Seek `elem` from a previously-cached index
	              // ...in a gzip-friendly way
	              node = parent;
	              outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
	              // Defend against cloned attroperties (jQuery gh-1709)

	              uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
	              cache = uniqueCache[type] || [];
	              nodeIndex = cache[0] === dirruns && cache[1];
	              diff = nodeIndex && cache[2];
	              node = nodeIndex && parent.childNodes[nodeIndex];

	              while (node = ++nodeIndex && node && node[dir] || ( // Fallback to seeking `elem` from the start
	              diff = nodeIndex = 0) || start.pop()) {
	                // When found, cache indexes on `parent` and break
	                if (node.nodeType === 1 && ++diff && node === elem) {
	                  uniqueCache[type] = [dirruns, nodeIndex, diff];
	                  break;
	                }
	              }
	            } else {
	              // Use previously-cached element index if available
	              if (useCache) {
	                // ...in a gzip-friendly way
	                node = elem;
	                outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
	                // Defend against cloned attroperties (jQuery gh-1709)

	                uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
	                cache = uniqueCache[type] || [];
	                nodeIndex = cache[0] === dirruns && cache[1];
	                diff = nodeIndex;
	              } // xml :nth-child(...)
	              // or :nth-last-child(...) or :nth(-last)?-of-type(...)


	              if (diff === false) {
	                // Use the same loop as above to seek `elem` from the start
	                while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {
	                  if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {
	                    // Cache the index of each encountered element
	                    if (useCache) {
	                      outerCache = node[expando] || (node[expando] = {}); // Support: IE <9 only
	                      // Defend against cloned attroperties (jQuery gh-1709)

	                      uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
	                      uniqueCache[type] = [dirruns, diff];
	                    }

	                    if (node === elem) {
	                      break;
	                    }
	                  }
	                }
	              }
	            } // Incorporate the offset, then check against cycle size


	            diff -= last;
	            return diff === first || diff % first === 0 && diff / first >= 0;
	          }
	        };
	      },
	      "PSEUDO": function PSEUDO(pseudo, argument) {
	        // pseudo-class names are case-insensitive
	        // http://www.w3.org/TR/selectors/#pseudo-classes
	        // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
	        // Remember that setFilters inherits from pseudos
	        var args,
	            fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo); // The user may use createPseudo to indicate that
	        // arguments are needed to create the filter function
	        // just as Sizzle does

	        if (fn[expando]) {
	          return fn(argument);
	        } // But maintain support for old signatures


	        if (fn.length > 1) {
	          args = [pseudo, pseudo, "", argument];
	          return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function (seed, matches) {
	            var idx,
	                matched = fn(seed, argument),
	                i = matched.length;

	            while (i--) {
	              idx = indexOf(seed, matched[i]);
	              seed[idx] = !(matches[idx] = matched[i]);
	            }
	          }) : function (elem) {
	            return fn(elem, 0, args);
	          };
	        }

	        return fn;
	      }
	    },
	    pseudos: {
	      // Potentially complex pseudos
	      "not": markFunction(function (selector) {
	        // Trim the selector passed to compile
	        // to avoid treating leading and trailing
	        // spaces as combinators
	        var input = [],
	            results = [],
	            matcher = compile(selector.replace(rtrim, "$1"));
	        return matcher[expando] ? markFunction(function (seed, matches, context, xml) {
	          var elem,
	              unmatched = matcher(seed, null, xml, []),
	              i = seed.length; // Match elements unmatched by `matcher`

	          while (i--) {
	            if (elem = unmatched[i]) {
	              seed[i] = !(matches[i] = elem);
	            }
	          }
	        }) : function (elem, context, xml) {
	          input[0] = elem;
	          matcher(input, null, xml, results); // Don't keep the element (issue #299)

	          input[0] = null;
	          return !results.pop();
	        };
	      }),
	      "has": markFunction(function (selector) {
	        return function (elem) {
	          return Sizzle(selector, elem).length > 0;
	        };
	      }),
	      "contains": markFunction(function (text) {
	        text = text.replace(runescape, funescape);
	        return function (elem) {
	          return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
	        };
	      }),
	      // "Whether an element is represented by a :lang() selector
	      // is based solely on the element's language value
	      // being equal to the identifier C,
	      // or beginning with the identifier C immediately followed by "-".
	      // The matching of C against the element's language value is performed case-insensitively.
	      // The identifier C does not have to be a valid language name."
	      // http://www.w3.org/TR/selectors/#lang-pseudo
	      "lang": markFunction(function (lang) {
	        // lang value must be a valid identifier
	        if (!ridentifier.test(lang || "")) {
	          Sizzle.error("unsupported lang: " + lang);
	        }

	        lang = lang.replace(runescape, funescape).toLowerCase();
	        return function (elem) {
	          var elemLang;

	          do {
	            if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) {
	              elemLang = elemLang.toLowerCase();
	              return elemLang === lang || elemLang.indexOf(lang + "-") === 0;
	            }
	          } while ((elem = elem.parentNode) && elem.nodeType === 1);

	          return false;
	        };
	      }),
	      // Miscellaneous
	      "target": function target(elem) {
	        var hash = window.location && window.location.hash;
	        return hash && hash.slice(1) === elem.id;
	      },
	      "root": function root(elem) {
	        return elem === docElem;
	      },
	      "focus": function focus(elem) {
	        return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
	      },
	      // Boolean properties
	      "enabled": createDisabledPseudo(false),
	      "disabled": createDisabledPseudo(true),
	      "checked": function checked(elem) {
	        // In CSS3, :checked should return both checked and selected elements
	        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
	        var nodeName = elem.nodeName.toLowerCase();
	        return nodeName === "input" && !!elem.checked || nodeName === "option" && !!elem.selected;
	      },
	      "selected": function selected(elem) {
	        // Accessing this property makes selected-by-default
	        // options in Safari work properly
	        if (elem.parentNode) {
	          elem.parentNode.selectedIndex;
	        }

	        return elem.selected === true;
	      },
	      // Contents
	      "empty": function empty(elem) {
	        // http://www.w3.org/TR/selectors/#empty-pseudo
	        // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
	        //   but not by others (comment: 8; processing instruction: 7; etc.)
	        // nodeType < 6 works because attributes (2) do not appear as children
	        for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
	          if (elem.nodeType < 6) {
	            return false;
	          }
	        }

	        return true;
	      },
	      "parent": function parent(elem) {
	        return !Expr.pseudos["empty"](elem);
	      },
	      // Element/input types
	      "header": function header(elem) {
	        return rheader.test(elem.nodeName);
	      },
	      "input": function input(elem) {
	        return rinputs.test(elem.nodeName);
	      },
	      "button": function button(elem) {
	        var name = elem.nodeName.toLowerCase();
	        return name === "input" && elem.type === "button" || name === "button";
	      },
	      "text": function text(elem) {
	        var attr;
	        return elem.nodeName.toLowerCase() === "input" && elem.type === "text" && ( // Support: IE<8
	        // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
	        (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text");
	      },
	      // Position-in-collection
	      "first": createPositionalPseudo(function () {
	        return [0];
	      }),
	      "last": createPositionalPseudo(function (matchIndexes, length) {
	        return [length - 1];
	      }),
	      "eq": createPositionalPseudo(function (matchIndexes, length, argument) {
	        return [argument < 0 ? argument + length : argument];
	      }),
	      "even": createPositionalPseudo(function (matchIndexes, length) {
	        var i = 0;

	        for (; i < length; i += 2) {
	          matchIndexes.push(i);
	        }

	        return matchIndexes;
	      }),
	      "odd": createPositionalPseudo(function (matchIndexes, length) {
	        var i = 1;

	        for (; i < length; i += 2) {
	          matchIndexes.push(i);
	        }

	        return matchIndexes;
	      }),
	      "lt": createPositionalPseudo(function (matchIndexes, length, argument) {
	        var i = argument < 0 ? argument + length : argument;

	        for (; --i >= 0;) {
	          matchIndexes.push(i);
	        }

	        return matchIndexes;
	      }),
	      "gt": createPositionalPseudo(function (matchIndexes, length, argument) {
	        var i = argument < 0 ? argument + length : argument;

	        for (; ++i < length;) {
	          matchIndexes.push(i);
	        }

	        return matchIndexes;
	      })
	    }
	  };
	  Expr.pseudos["nth"] = Expr.pseudos["eq"]; // Add button/input type pseudos

	  for (i in {
	    radio: true,
	    checkbox: true,
	    file: true,
	    password: true,
	    image: true
	  }) {
	    Expr.pseudos[i] = createInputPseudo(i);
	  }

	  for (i in {
	    submit: true,
	    reset: true
	  }) {
	    Expr.pseudos[i] = createButtonPseudo(i);
	  } // Easy API for creating new setFilters


	  function setFilters() {}

	  setFilters.prototype = Expr.filters = Expr.pseudos;
	  Expr.setFilters = new setFilters();

	  tokenize = Sizzle.tokenize = function (selector, parseOnly) {
	    var matched,
	        match,
	        tokens,
	        type,
	        soFar,
	        groups,
	        preFilters,
	        cached = tokenCache[selector + " "];

	    if (cached) {
	      return parseOnly ? 0 : cached.slice(0);
	    }

	    soFar = selector;
	    groups = [];
	    preFilters = Expr.preFilter;

	    while (soFar) {
	      // Comma and first run
	      if (!matched || (match = rcomma.exec(soFar))) {
	        if (match) {
	          // Don't consume trailing commas as valid
	          soFar = soFar.slice(match[0].length) || soFar;
	        }

	        groups.push(tokens = []);
	      }

	      matched = false; // Combinators

	      if (match = rcombinators.exec(soFar)) {
	        matched = match.shift();
	        tokens.push({
	          value: matched,
	          // Cast descendant combinators to space
	          type: match[0].replace(rtrim, " ")
	        });
	        soFar = soFar.slice(matched.length);
	      } // Filters


	      for (type in Expr.filter) {
	        if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] || (match = preFilters[type](match)))) {
	          matched = match.shift();
	          tokens.push({
	            value: matched,
	            type: type,
	            matches: match
	          });
	          soFar = soFar.slice(matched.length);
	        }
	      }

	      if (!matched) {
	        break;
	      }
	    } // Return the length of the invalid excess
	    // if we're just parsing
	    // Otherwise, throw an error or return tokens


	    return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : // Cache the tokens
	    tokenCache(selector, groups).slice(0);
	  };

	  function toSelector(tokens) {
	    var i = 0,
	        len = tokens.length,
	        selector = "";

	    for (; i < len; i++) {
	      selector += tokens[i].value;
	    }

	    return selector;
	  }

	  function addCombinator(matcher, combinator, base) {
	    var dir = combinator.dir,
	        skip = combinator.next,
	        key = skip || dir,
	        checkNonElements = base && key === "parentNode",
	        doneName = done++;
	    return combinator.first ? // Check against closest ancestor/preceding element
	    function (elem, context, xml) {
	      while (elem = elem[dir]) {
	        if (elem.nodeType === 1 || checkNonElements) {
	          return matcher(elem, context, xml);
	        }
	      }

	      return false;
	    } : // Check against all ancestor/preceding elements
	    function (elem, context, xml) {
	      var oldCache,
	          uniqueCache,
	          outerCache,
	          newCache = [dirruns, doneName]; // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching

	      if (xml) {
	        while (elem = elem[dir]) {
	          if (elem.nodeType === 1 || checkNonElements) {
	            if (matcher(elem, context, xml)) {
	              return true;
	            }
	          }
	        }
	      } else {
	        while (elem = elem[dir]) {
	          if (elem.nodeType === 1 || checkNonElements) {
	            outerCache = elem[expando] || (elem[expando] = {}); // Support: IE <9 only
	            // Defend against cloned attroperties (jQuery gh-1709)

	            uniqueCache = outerCache[elem.uniqueID] || (outerCache[elem.uniqueID] = {});

	            if (skip && skip === elem.nodeName.toLowerCase()) {
	              elem = elem[dir] || elem;
	            } else if ((oldCache = uniqueCache[key]) && oldCache[0] === dirruns && oldCache[1] === doneName) {
	              // Assign to newCache so results back-propagate to previous elements
	              return newCache[2] = oldCache[2];
	            } else {
	              // Reuse newcache so results back-propagate to previous elements
	              uniqueCache[key] = newCache; // A match means we're done; a fail means we have to keep checking

	              if (newCache[2] = matcher(elem, context, xml)) {
	                return true;
	              }
	            }
	          }
	        }
	      }

	      return false;
	    };
	  }

	  function elementMatcher(matchers) {
	    return matchers.length > 1 ? function (elem, context, xml) {
	      var i = matchers.length;

	      while (i--) {
	        if (!matchers[i](elem, context, xml)) {
	          return false;
	        }
	      }

	      return true;
	    } : matchers[0];
	  }

	  function multipleContexts(selector, contexts, results) {
	    var i = 0,
	        len = contexts.length;

	    for (; i < len; i++) {
	      Sizzle(selector, contexts[i], results);
	    }

	    return results;
	  }

	  function condense(unmatched, map, filter, context, xml) {
	    var elem,
	        newUnmatched = [],
	        i = 0,
	        len = unmatched.length,
	        mapped = map != null;

	    for (; i < len; i++) {
	      if (elem = unmatched[i]) {
	        if (!filter || filter(elem, context, xml)) {
	          newUnmatched.push(elem);

	          if (mapped) {
	            map.push(i);
	          }
	        }
	      }
	    }

	    return newUnmatched;
	  }

	  function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
	    if (postFilter && !postFilter[expando]) {
	      postFilter = setMatcher(postFilter);
	    }

	    if (postFinder && !postFinder[expando]) {
	      postFinder = setMatcher(postFinder, postSelector);
	    }

	    return markFunction(function (seed, results, context, xml) {
	      var temp,
	          i,
	          elem,
	          preMap = [],
	          postMap = [],
	          preexisting = results.length,
	          // Get initial elements from seed or context
	      elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),
	          // Prefilter to get matcher input, preserving a map for seed-results synchronization
	      matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems,
	          matcherOut = matcher ? // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
	      postFinder || (seed ? preFilter : preexisting || postFilter) ? // ...intermediate processing is necessary
	      [] : // ...otherwise use results directly
	      results : matcherIn; // Find primary matches

	      if (matcher) {
	        matcher(matcherIn, matcherOut, context, xml);
	      } // Apply postFilter


	      if (postFilter) {
	        temp = condense(matcherOut, postMap);
	        postFilter(temp, [], context, xml); // Un-match failing elements by moving them back to matcherIn

	        i = temp.length;

	        while (i--) {
	          if (elem = temp[i]) {
	            matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
	          }
	        }
	      }

	      if (seed) {
	        if (postFinder || preFilter) {
	          if (postFinder) {
	            // Get the final matcherOut by condensing this intermediate into postFinder contexts
	            temp = [];
	            i = matcherOut.length;

	            while (i--) {
	              if (elem = matcherOut[i]) {
	                // Restore matcherIn since elem is not yet a final match
	                temp.push(matcherIn[i] = elem);
	              }
	            }

	            postFinder(null, matcherOut = [], temp, xml);
	          } // Move matched elements from seed to results to keep them synchronized


	          i = matcherOut.length;

	          while (i--) {
	            if ((elem = matcherOut[i]) && (temp = postFinder ? indexOf(seed, elem) : preMap[i]) > -1) {
	              seed[temp] = !(results[temp] = elem);
	            }
	          }
	        } // Add elements to results, through postFinder if defined

	      } else {
	        matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut);

	        if (postFinder) {
	          postFinder(null, results, matcherOut, xml);
	        } else {
	          push.apply(results, matcherOut);
	        }
	      }
	    });
	  }

	  function matcherFromTokens(tokens) {
	    var checkContext,
	        matcher,
	        j,
	        len = tokens.length,
	        leadingRelative = Expr.relative[tokens[0].type],
	        implicitRelative = leadingRelative || Expr.relative[" "],
	        i = leadingRelative ? 1 : 0,
	        // The foundational matcher ensures that elements are reachable from top-level context(s)
	    matchContext = addCombinator(function (elem) {
	      return elem === checkContext;
	    }, implicitRelative, true),
	        matchAnyContext = addCombinator(function (elem) {
	      return indexOf(checkContext, elem) > -1;
	    }, implicitRelative, true),
	        matchers = [function (elem, context, xml) {
	      var ret = !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml)); // Avoid hanging onto element (issue #299)

	      checkContext = null;
	      return ret;
	    }];

	    for (; i < len; i++) {
	      if (matcher = Expr.relative[tokens[i].type]) {
	        matchers = [addCombinator(elementMatcher(matchers), matcher)];
	      } else {
	        matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches); // Return special upon seeing a positional matcher

	        if (matcher[expando]) {
	          // Find the next relative operator (if any) for proper handling
	          j = ++i;

	          for (; j < len; j++) {
	            if (Expr.relative[tokens[j].type]) {
	              break;
	            }
	          }

	          return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector( // If the preceding token was a descendant combinator, insert an implicit any-element `*`
	          tokens.slice(0, i - 1).concat({
	            value: tokens[i - 2].type === " " ? "*" : ""
	          })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens));
	        }

	        matchers.push(matcher);
	      }
	    }

	    return elementMatcher(matchers);
	  }

	  function matcherFromGroupMatchers(elementMatchers, setMatchers) {
	    var bySet = setMatchers.length > 0,
	        byElement = elementMatchers.length > 0,
	        superMatcher = function superMatcher(seed, context, xml, results, outermost) {
	      var elem,
	          j,
	          matcher,
	          matchedCount = 0,
	          i = "0",
	          unmatched = seed && [],
	          setMatched = [],
	          contextBackup = outermostContext,
	          // We must always have either seed elements or outermost context
	      elems = seed || byElement && Expr.find["TAG"]("*", outermost),
	          // Use integer dirruns iff this is the outermost matcher
	      dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || 0.1,
	          len = elems.length;

	      if (outermost) {
	        outermostContext = context === document || context || outermost;
	      } // Add elements passing elementMatchers directly to results
	      // Support: IE<9, Safari
	      // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id


	      for (; i !== len && (elem = elems[i]) != null; i++) {
	        if (byElement && elem) {
	          j = 0;

	          if (!context && elem.ownerDocument !== document) {
	            setDocument(elem);
	            xml = !documentIsHTML;
	          }

	          while (matcher = elementMatchers[j++]) {
	            if (matcher(elem, context || document, xml)) {
	              results.push(elem);
	              break;
	            }
	          }

	          if (outermost) {
	            dirruns = dirrunsUnique;
	          }
	        } // Track unmatched elements for set filters


	        if (bySet) {
	          // They will have gone through all possible matchers
	          if (elem = !matcher && elem) {
	            matchedCount--;
	          } // Lengthen the array for every element, matched or not


	          if (seed) {
	            unmatched.push(elem);
	          }
	        }
	      } // `i` is now the count of elements visited above, and adding it to `matchedCount`
	      // makes the latter nonnegative.


	      matchedCount += i; // Apply set filters to unmatched elements
	      // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
	      // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
	      // no element matchers and no seed.
	      // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
	      // case, which will result in a "00" `matchedCount` that differs from `i` but is also
	      // numerically zero.

	      if (bySet && i !== matchedCount) {
	        j = 0;

	        while (matcher = setMatchers[j++]) {
	          matcher(unmatched, setMatched, context, xml);
	        }

	        if (seed) {
	          // Reintegrate element matches to eliminate the need for sorting
	          if (matchedCount > 0) {
	            while (i--) {
	              if (!(unmatched[i] || setMatched[i])) {
	                setMatched[i] = pop.call(results);
	              }
	            }
	          } // Discard index placeholder values to get only actual matches


	          setMatched = condense(setMatched);
	        } // Add matches to results


	        push.apply(results, setMatched); // Seedless set matches succeeding multiple successful matchers stipulate sorting

	        if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) {
	          Sizzle.uniqueSort(results);
	        }
	      } // Override manipulation of globals by nested matchers


	      if (outermost) {
	        dirruns = dirrunsUnique;
	        outermostContext = contextBackup;
	      }

	      return unmatched;
	    };

	    return bySet ? markFunction(superMatcher) : superMatcher;
	  }

	  compile = Sizzle.compile = function (selector, match
	  /* Internal Use Only */
	  ) {
	    var i,
	        setMatchers = [],
	        elementMatchers = [],
	        cached = compilerCache[selector + " "];

	    if (!cached) {
	      // Generate a function of recursive functions that can be used to check each element
	      if (!match) {
	        match = tokenize(selector);
	      }

	      i = match.length;

	      while (i--) {
	        cached = matcherFromTokens(match[i]);

	        if (cached[expando]) {
	          setMatchers.push(cached);
	        } else {
	          elementMatchers.push(cached);
	        }
	      } // Cache the compiled function


	      cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers)); // Save selector and tokenization

	      cached.selector = selector;
	    }

	    return cached;
	  };
	  /**
	   * A low-level selection function that works with Sizzle's compiled
	   *  selector functions
	   * @param {String|Function} selector A selector or a pre-compiled
	   *  selector function built with Sizzle.compile
	   * @param {Element} context
	   * @param {Array} [results]
	   * @param {Array} [seed] A set of elements to match against
	   */


	  select = Sizzle.select = function (selector, context, results, seed) {
	    var i,
	        tokens,
	        token,
	        type,
	        find,
	        compiled = typeof selector === "function" && selector,
	        match = !seed && tokenize(selector = compiled.selector || selector);
	    results = results || []; // Try to minimize operations if there is only one selector in the list and no seed
	    // (the latter of which guarantees us context)

	    if (match.length === 1) {
	      // Reduce context if the leading compound selector is an ID
	      tokens = match[0] = match[0].slice(0);

	      if (tokens.length > 2 && (token = tokens[0]).type === "ID" && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
	        context = (Expr.find["ID"](token.matches[0].replace(runescape, funescape), context) || [])[0];

	        if (!context) {
	          return results; // Precompiled matchers will still verify ancestry, so step up a level
	        } else if (compiled) {
	          context = context.parentNode;
	        }

	        selector = selector.slice(tokens.shift().value.length);
	      } // Fetch a seed set for right-to-left matching


	      i = matchExpr["needsContext"].test(selector) ? 0 : tokens.length;

	      while (i--) {
	        token = tokens[i]; // Abort if we hit a combinator

	        if (Expr.relative[type = token.type]) {
	          break;
	        }

	        if (find = Expr.find[type]) {
	          // Search, expanding context for leading sibling combinators
	          if (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {
	            // If seed is empty or no tokens remain, we can return early
	            tokens.splice(i, 1);
	            selector = seed.length && toSelector(tokens);

	            if (!selector) {
	              push.apply(results, seed);
	              return results;
	            }

	            break;
	          }
	        }
	      }
	    } // Compile and execute a filtering function if one is not provided
	    // Provide `match` to avoid retokenization if we modified the selector above


	    (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, !context || rsibling.test(selector) && testContext(context.parentNode) || context);
	    return results;
	  }; // One-time assignments
	  // Sort stability


	  support.sortStable = expando.split("").sort(sortOrder).join("") === expando; // Support: Chrome 14-35+
	  // Always assume duplicates if they aren't passed to the comparison function

	  support.detectDuplicates = !!hasDuplicate; // Initialize against the default document

	  setDocument();
	  return Sizzle;
	}(window);

	jQuery.find = Sizzle;
	jQuery.expr = Sizzle.selectors; // Deprecated

	jQuery.expr[":"] = jQuery.expr.pseudos;
	jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
	jQuery.text = Sizzle.getText;
	jQuery.isXMLDoc = Sizzle.isXML;
	jQuery.contains = Sizzle.contains;
	jQuery.escapeSelector = Sizzle.escape;

	var dir = function dir(elem, _dir, until) {
	  var matched = [],
	      truncate = until !== undefined;

	  while ((elem = elem[_dir]) && elem.nodeType !== 9) {
	    if (elem.nodeType === 1) {
	      if (truncate && jQuery(elem).is(until)) {
	        break;
	      }

	      matched.push(elem);
	    }
	  }

	  return matched;
	};

	var _siblings = function siblings(n, elem) {
	  var matched = [];

	  for (; n; n = n.nextSibling) {
	    if (n.nodeType === 1 && n !== elem) {
	      matched.push(n);
	    }
	  }

	  return matched;
	};

	var rneedsContext = jQuery.expr.match.needsContext;

	function nodeName(elem, name) {
	  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	}

	var rsingleTag = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i; // Implement the identical functionality for filter and not

	function winnow(elements, qualifier, not) {
	  if (isFunction(qualifier)) {
	    return jQuery.grep(elements, function (elem, i) {
	      return !!qualifier.call(elem, i, elem) !== not;
	    });
	  } // Single element


	  if (qualifier.nodeType) {
	    return jQuery.grep(elements, function (elem) {
	      return elem === qualifier !== not;
	    });
	  } // Arraylike of elements (jQuery, arguments, Array)


	  if (typeof qualifier !== "string") {
	    return jQuery.grep(elements, function (elem) {
	      return indexOf$1.call(qualifier, elem) > -1 !== not;
	    });
	  } // Filtered directly for both simple and complex selectors


	  return jQuery.filter(qualifier, elements, not);
	}

	jQuery.filter = function (expr, elems, not) {
	  var elem = elems[0];

	  if (not) {
	    expr = ":not(" + expr + ")";
	  }

	  if (elems.length === 1 && elem.nodeType === 1) {
	    return jQuery.find.matchesSelector(elem, expr) ? [elem] : [];
	  }

	  return jQuery.find.matches(expr, jQuery.grep(elems, function (elem) {
	    return elem.nodeType === 1;
	  }));
	};

	jQuery.fn.extend({
	  find: function find(selector) {
	    var i,
	        ret,
	        len = this.length,
	        self = this;

	    if (typeof selector !== "string") {
	      return this.pushStack(jQuery(selector).filter(function () {
	        for (i = 0; i < len; i++) {
	          if (jQuery.contains(self[i], this)) {
	            return true;
	          }
	        }
	      }));
	    }

	    ret = this.pushStack([]);

	    for (i = 0; i < len; i++) {
	      jQuery.find(selector, self[i], ret);
	    }

	    return len > 1 ? jQuery.uniqueSort(ret) : ret;
	  },
	  filter: function filter(selector) {
	    return this.pushStack(winnow(this, selector || [], false));
	  },
	  not: function not(selector) {
	    return this.pushStack(winnow(this, selector || [], true));
	  },
	  is: function is(selector) {
	    return !!winnow(this, // If this is a positional/relative selector, check membership in the returned set
	    // so $("p:first").is("p:last") won't return true for a doc with two "p".
	    typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length;
	  }
	}); // Initialize a jQuery object
	// A central reference to the root jQuery(document)

	var rootjQuery,
	    // A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,
	    init$2 = jQuery.fn.init = function (selector, context, root) {
	  var match, elem; // HANDLE: $(""), $(null), $(undefined), $(false)

	  if (!selector) {
	    return this;
	  } // Method init() accepts an alternate rootjQuery
	  // so migrate can support jQuery.sub (gh-2101)


	  root = root || rootjQuery; // Handle HTML strings

	  if (typeof selector === "string") {
	    if (selector[0] === "<" && selector[selector.length - 1] === ">" && selector.length >= 3) {
	      // Assume that strings that start and end with <> are HTML and skip the regex check
	      match = [null, selector, null];
	    } else {
	      match = rquickExpr.exec(selector);
	    } // Match html or make sure no context is specified for #id


	    if (match && (match[1] || !context)) {
	      // HANDLE: $(html) -> $(array)
	      if (match[1]) {
	        context = context instanceof jQuery ? context[0] : context; // Option to run scripts is true for back-compat
	        // Intentionally let the error be thrown if parseHTML is not present

	        jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document$2, true)); // HANDLE: $(html, props)

	        if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context)) {
	          for (match in context) {
	            // Properties of context are called as methods if possible
	            if (isFunction(this[match])) {
	              this[match](context[match]); // ...and otherwise set as attributes
	            } else {
	              this.attr(match, context[match]);
	            }
	          }
	        }

	        return this; // HANDLE: $(#id)
	      } else {
	        elem = document$2.getElementById(match[2]);

	        if (elem) {
	          // Inject the element directly into the jQuery object
	          this[0] = elem;
	          this.length = 1;
	        }

	        return this;
	      } // HANDLE: $(expr, $(...))

	    } else if (!context || context.jquery) {
	      return (context || root).find(selector); // HANDLE: $(expr, context)
	      // (which is just equivalent to: $(context).find(expr)
	    } else {
	      return this.constructor(context).find(selector);
	    } // HANDLE: $(DOMElement)

	  } else if (selector.nodeType) {
	    this[0] = selector;
	    this.length = 1;
	    return this; // HANDLE: $(function)
	    // Shortcut for document ready
	  } else if (isFunction(selector)) {
	    return root.ready !== undefined ? root.ready(selector) : // Execute immediately if ready is not present
	    selector(jQuery);
	  }

	  return jQuery.makeArray(selector, this);
	}; // Give the init function the jQuery prototype for later instantiation


	init$2.prototype = jQuery.fn; // Initialize central reference

	rootjQuery = jQuery(document$2);
	var rparentsprev = /^(?:parents|prev(?:Until|All))/,
	    // Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
	  children: true,
	  contents: true,
	  next: true,
	  prev: true
	};
	jQuery.fn.extend({
	  has: function has(target) {
	    var targets = jQuery(target, this),
	        l = targets.length;
	    return this.filter(function () {
	      var i = 0;

	      for (; i < l; i++) {
	        if (jQuery.contains(this, targets[i])) {
	          return true;
	        }
	      }
	    });
	  },
	  closest: function closest(selectors, context) {
	    var cur,
	        i = 0,
	        l = this.length,
	        matched = [],
	        targets = typeof selectors !== "string" && jQuery(selectors); // Positional selectors never match, since there's no _selection_ context

	    if (!rneedsContext.test(selectors)) {
	      for (; i < l; i++) {
	        for (cur = this[i]; cur && cur !== context; cur = cur.parentNode) {
	          // Always skip document fragments
	          if (cur.nodeType < 11 && (targets ? targets.index(cur) > -1 : // Don't pass non-elements to Sizzle
	          cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) {
	            matched.push(cur);
	            break;
	          }
	        }
	      }
	    }

	    return this.pushStack(matched.length > 1 ? jQuery.uniqueSort(matched) : matched);
	  },
	  // Determine the position of an element within the set
	  index: function index(elem) {
	    // No argument, return index in parent
	    if (!elem) {
	      return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
	    } // Index in selector


	    if (typeof elem === "string") {
	      return indexOf$1.call(jQuery(elem), this[0]);
	    } // Locate the position of the desired element


	    return indexOf$1.call(this, // If it receives a jQuery object, the first element is used
	    elem.jquery ? elem[0] : elem);
	  },
	  add: function add(selector, context) {
	    return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(), jQuery(selector, context))));
	  },
	  addBack: function addBack(selector) {
	    return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector));
	  }
	});

	function sibling(cur, dir) {
	  while ((cur = cur[dir]) && cur.nodeType !== 1) {}

	  return cur;
	}

	jQuery.each({
	  parent: function parent(elem) {
	    var parent = elem.parentNode;
	    return parent && parent.nodeType !== 11 ? parent : null;
	  },
	  parents: function parents(elem) {
	    return dir(elem, "parentNode");
	  },
	  parentsUntil: function parentsUntil(elem, i, until) {
	    return dir(elem, "parentNode", until);
	  },
	  next: function next(elem) {
	    return sibling(elem, "nextSibling");
	  },
	  prev: function prev(elem) {
	    return sibling(elem, "previousSibling");
	  },
	  nextAll: function nextAll(elem) {
	    return dir(elem, "nextSibling");
	  },
	  prevAll: function prevAll(elem) {
	    return dir(elem, "previousSibling");
	  },
	  nextUntil: function nextUntil(elem, i, until) {
	    return dir(elem, "nextSibling", until);
	  },
	  prevUntil: function prevUntil(elem, i, until) {
	    return dir(elem, "previousSibling", until);
	  },
	  siblings: function siblings(elem) {
	    return _siblings((elem.parentNode || {}).firstChild, elem);
	  },
	  children: function children(elem) {
	    return _siblings(elem.firstChild);
	  },
	  contents: function contents(elem) {
	    if (nodeName(elem, "iframe")) {
	      return elem.contentDocument;
	    } // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
	    // Treat the template element as a regular one in browsers that
	    // don't support it.


	    if (nodeName(elem, "template")) {
	      elem = elem.content || elem;
	    }

	    return jQuery.merge([], elem.childNodes);
	  }
	}, function (name, fn) {
	  jQuery.fn[name] = function (until, selector) {
	    var matched = jQuery.map(this, fn, until);

	    if (name.slice(-5) !== "Until") {
	      selector = until;
	    }

	    if (selector && typeof selector === "string") {
	      matched = jQuery.filter(selector, matched);
	    }

	    if (this.length > 1) {
	      // Remove duplicates
	      if (!guaranteedUnique[name]) {
	        jQuery.uniqueSort(matched);
	      } // Reverse order for parents* and prev-derivatives


	      if (rparentsprev.test(name)) {
	        matched.reverse();
	      }
	    }

	    return this.pushStack(matched);
	  };
	});
	var rnothtmlwhite = /[^\x20\t\r\n\f]+/g; // Convert String-formatted options into Object-formatted ones

	function createOptions(options) {
	  var object = {};
	  jQuery.each(options.match(rnothtmlwhite) || [], function (_, flag) {
	    object[flag] = true;
	  });
	  return object;
	}
	/*
	 * Create a callback list using the following parameters:
	 *
	 *	options: an optional list of space-separated options that will change how
	 *			the callback list behaves or a more traditional option object
	 *
	 * By default a callback list will act like an event callback list and can be
	 * "fired" multiple times.
	 *
	 * Possible options:
	 *
	 *	once:			will ensure the callback list can only be fired once (like a Deferred)
	 *
	 *	memory:			will keep track of previous values and will call any callback added
	 *					after the list has been fired right away with the latest "memorized"
	 *					values (like a Deferred)
	 *
	 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
	 *
	 *	stopOnFalse:	interrupt callings when a callback returns false
	 *
	 */


	jQuery.Callbacks = function (options) {
	  // Convert options from String-formatted to Object-formatted if needed
	  // (we check in cache first)
	  options = typeof options === "string" ? createOptions(options) : jQuery.extend({}, options);

	  var // Flag to know if list is currently firing
	  firing,
	      // Last fire value for non-forgettable lists
	  memory,
	      // Flag to know if list was already fired
	  _fired,
	      // Flag to prevent firing
	  _locked,
	      // Actual callback list
	  list = [],
	      // Queue of execution data for repeatable lists
	  queue = [],
	      // Index of currently firing callback (modified by add/remove as needed)
	  firingIndex = -1,
	      // Fire callbacks
	  fire = function fire() {
	    // Enforce single-firing
	    _locked = _locked || options.once; // Execute callbacks for all pending executions,
	    // respecting firingIndex overrides and runtime changes

	    _fired = firing = true;

	    for (; queue.length; firingIndex = -1) {
	      memory = queue.shift();

	      while (++firingIndex < list.length) {
	        // Run callback and check for early termination
	        if (list[firingIndex].apply(memory[0], memory[1]) === false && options.stopOnFalse) {
	          // Jump to end and forget the data so .add doesn't re-fire
	          firingIndex = list.length;
	          memory = false;
	        }
	      }
	    } // Forget the data if we're done with it


	    if (!options.memory) {
	      memory = false;
	    }

	    firing = false; // Clean up if we're done firing for good

	    if (_locked) {
	      // Keep an empty list if we have data for future add calls
	      if (memory) {
	        list = []; // Otherwise, this object is spent
	      } else {
	        list = "";
	      }
	    }
	  },
	      // Actual Callbacks object
	  self = {
	    // Add a callback or a collection of callbacks to the list
	    add: function add() {
	      if (list) {
	        // If we have memory from a past run, we should fire after adding
	        if (memory && !firing) {
	          firingIndex = list.length - 1;
	          queue.push(memory);
	        }

	        (function add(args) {
	          jQuery.each(args, function (_, arg) {
	            if (isFunction(arg)) {
	              if (!options.unique || !self.has(arg)) {
	                list.push(arg);
	              }
	            } else if (arg && arg.length && toType(arg) !== "string") {
	              // Inspect recursively
	              add(arg);
	            }
	          });
	        })(arguments);

	        if (memory && !firing) {
	          fire();
	        }
	      }

	      return this;
	    },
	    // Remove a callback from the list
	    remove: function remove() {
	      jQuery.each(arguments, function (_, arg) {
	        var index;

	        while ((index = jQuery.inArray(arg, list, index)) > -1) {
	          list.splice(index, 1); // Handle firing indexes

	          if (index <= firingIndex) {
	            firingIndex--;
	          }
	        }
	      });
	      return this;
	    },
	    // Check if a given callback is in the list.
	    // If no argument is given, return whether or not list has callbacks attached.
	    has: function has(fn) {
	      return fn ? jQuery.inArray(fn, list) > -1 : list.length > 0;
	    },
	    // Remove all callbacks from the list
	    empty: function empty() {
	      if (list) {
	        list = [];
	      }

	      return this;
	    },
	    // Disable .fire and .add
	    // Abort any current/pending executions
	    // Clear all callbacks and values
	    disable: function disable() {
	      _locked = queue = [];
	      list = memory = "";
	      return this;
	    },
	    disabled: function disabled() {
	      return !list;
	    },
	    // Disable .fire
	    // Also disable .add unless we have memory (since it would have no effect)
	    // Abort any pending executions
	    lock: function lock() {
	      _locked = queue = [];

	      if (!memory && !firing) {
	        list = memory = "";
	      }

	      return this;
	    },
	    locked: function locked() {
	      return !!_locked;
	    },
	    // Call all callbacks with the given context and arguments
	    fireWith: function fireWith(context, args) {
	      if (!_locked) {
	        args = args || [];
	        args = [context, args.slice ? args.slice() : args];
	        queue.push(args);

	        if (!firing) {
	          fire();
	        }
	      }

	      return this;
	    },
	    // Call all the callbacks with the given arguments
	    fire: function fire() {
	      self.fireWith(this, arguments);
	      return this;
	    },
	    // To know if the callbacks have already been called at least once
	    fired: function fired() {
	      return !!_fired;
	    }
	  };

	  return self;
	};

	function Identity(v) {
	  return v;
	}

	function Thrower(ex) {
	  throw ex;
	}

	function adoptValue(value, resolve, reject, noValue) {
	  var method;

	  try {
	    // Check for promise aspect first to privilege synchronous behavior
	    if (value && isFunction(method = value.promise)) {
	      method.call(value).done(resolve).fail(reject); // Other thenables
	    } else if (value && isFunction(method = value.then)) {
	      method.call(value, resolve, reject); // Other non-thenables
	    } else {
	      // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
	      // * false: [ value ].slice( 0 ) => resolve( value )
	      // * true: [ value ].slice( 1 ) => resolve()
	      resolve.apply(undefined, [value].slice(noValue));
	    } // For Promises/A+, convert exceptions into rejections
	    // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	    // Deferred#then to conditionally suppress rejection.

	  } catch (value) {
	    // Support: Android 4.0 only
	    // Strict mode functions invoked without .call/.apply get global-object context
	    reject.apply(undefined, [value]);
	  }
	}

	jQuery.extend({
	  Deferred: function Deferred(func) {
	    var tuples = [// action, add listener, callbacks,
	    // ... .then handlers, argument index, [final state]
	    ["notify", "progress", jQuery.Callbacks("memory"), jQuery.Callbacks("memory"), 2], ["resolve", "done", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 0, "resolved"], ["reject", "fail", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 1, "rejected"]],
	        _state = "pending",
	        _promise = {
	      state: function state() {
	        return _state;
	      },
	      always: function always() {
	        deferred.done(arguments).fail(arguments);
	        return this;
	      },
	      "catch": function _catch(fn) {
	        return _promise.then(null, fn);
	      },
	      // Keep pipe for back-compat
	      pipe: function pipe()
	      /* fnDone, fnFail, fnProgress */
	      {
	        var fns = arguments;
	        return jQuery.Deferred(function (newDefer) {
	          jQuery.each(tuples, function (i, tuple) {
	            // Map tuples (progress, done, fail) to arguments (done, fail, progress)
	            var fn = isFunction(fns[tuple[4]]) && fns[tuple[4]]; // deferred.progress(function() { bind to newDefer or newDefer.notify })
	            // deferred.done(function() { bind to newDefer or newDefer.resolve })
	            // deferred.fail(function() { bind to newDefer or newDefer.reject })

	            deferred[tuple[1]](function () {
	              var returned = fn && fn.apply(this, arguments);

	              if (returned && isFunction(returned.promise)) {
	                returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject);
	              } else {
	                newDefer[tuple[0] + "With"](this, fn ? [returned] : arguments);
	              }
	            });
	          });
	          fns = null;
	        }).promise();
	      },
	      then: function then(onFulfilled, onRejected, onProgress) {
	        var maxDepth = 0;

	        function resolve(depth, deferred, handler, special) {
	          return function () {
	            var that = this,
	                args = arguments,
	                mightThrow = function mightThrow() {
	              var returned, then; // Support: Promises/A+ section 2.3.3.3.3
	              // https://promisesaplus.com/#point-59
	              // Ignore double-resolution attempts

	              if (depth < maxDepth) {
	                return;
	              }

	              returned = handler.apply(that, args); // Support: Promises/A+ section 2.3.1
	              // https://promisesaplus.com/#point-48

	              if (returned === deferred.promise()) {
	                throw new TypeError("Thenable self-resolution");
	              } // Support: Promises/A+ sections 2.3.3.1, 3.5
	              // https://promisesaplus.com/#point-54
	              // https://promisesaplus.com/#point-75
	              // Retrieve `then` only once


	              then = returned && ( // Support: Promises/A+ section 2.3.4
	              // https://promisesaplus.com/#point-64
	              // Only check objects and functions for thenability
	              _typeof(returned) === "object" || typeof returned === "function") && returned.then; // Handle a returned thenable

	              if (isFunction(then)) {
	                // Special processors (notify) just wait for resolution
	                if (special) {
	                  then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special)); // Normal processors (resolve) also hook into progress
	                } else {
	                  // ...and disregard older resolution values
	                  maxDepth++;
	                  then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special), resolve(maxDepth, deferred, Identity, deferred.notifyWith));
	                } // Handle all other returned values

	              } else {
	                // Only substitute handlers pass on context
	                // and multiple values (non-spec behavior)
	                if (handler !== Identity) {
	                  that = undefined;
	                  args = [returned];
	                } // Process the value(s)
	                // Default process is resolve


	                (special || deferred.resolveWith)(that, args);
	              }
	            },
	                // Only normal processors (resolve) catch and reject exceptions
	            process = special ? mightThrow : function () {
	              try {
	                mightThrow();
	              } catch (e) {
	                if (jQuery.Deferred.exceptionHook) {
	                  jQuery.Deferred.exceptionHook(e, process.stackTrace);
	                } // Support: Promises/A+ section 2.3.3.3.4.1
	                // https://promisesaplus.com/#point-61
	                // Ignore post-resolution exceptions


	                if (depth + 1 >= maxDepth) {
	                  // Only substitute handlers pass on context
	                  // and multiple values (non-spec behavior)
	                  if (handler !== Thrower) {
	                    that = undefined;
	                    args = [e];
	                  }

	                  deferred.rejectWith(that, args);
	                }
	              }
	            }; // Support: Promises/A+ section 2.3.3.3.1
	            // https://promisesaplus.com/#point-57
	            // Re-resolve promises immediately to dodge false rejection from
	            // subsequent errors


	            if (depth) {
	              process();
	            } else {
	              // Call an optional hook to record the stack, in case of exception
	              // since it's otherwise lost when execution goes async
	              if (jQuery.Deferred.getStackHook) {
	                process.stackTrace = jQuery.Deferred.getStackHook();
	              }

	              window.setTimeout(process);
	            }
	          };
	        }

	        return jQuery.Deferred(function (newDefer) {
	          // progress_handlers.add( ... )
	          tuples[0][3].add(resolve(0, newDefer, isFunction(onProgress) ? onProgress : Identity, newDefer.notifyWith)); // fulfilled_handlers.add( ... )

	          tuples[1][3].add(resolve(0, newDefer, isFunction(onFulfilled) ? onFulfilled : Identity)); // rejected_handlers.add( ... )

	          tuples[2][3].add(resolve(0, newDefer, isFunction(onRejected) ? onRejected : Thrower));
	        }).promise();
	      },
	      // Get a promise for this deferred
	      // If obj is provided, the promise aspect is added to the object
	      promise: function promise(obj) {
	        return obj != null ? jQuery.extend(obj, _promise) : _promise;
	      }
	    },
	        deferred = {}; // Add list-specific methods

	    jQuery.each(tuples, function (i, tuple) {
	      var list = tuple[2],
	          stateString = tuple[5]; // promise.progress = list.add
	      // promise.done = list.add
	      // promise.fail = list.add

	      _promise[tuple[1]] = list.add; // Handle state

	      if (stateString) {
	        list.add(function () {
	          // state = "resolved" (i.e., fulfilled)
	          // state = "rejected"
	          _state = stateString;
	        }, // rejected_callbacks.disable
	        // fulfilled_callbacks.disable
	        tuples[3 - i][2].disable, // rejected_handlers.disable
	        // fulfilled_handlers.disable
	        tuples[3 - i][3].disable, // progress_callbacks.lock
	        tuples[0][2].lock, // progress_handlers.lock
	        tuples[0][3].lock);
	      } // progress_handlers.fire
	      // fulfilled_handlers.fire
	      // rejected_handlers.fire


	      list.add(tuple[3].fire); // deferred.notify = function() { deferred.notifyWith(...) }
	      // deferred.resolve = function() { deferred.resolveWith(...) }
	      // deferred.reject = function() { deferred.rejectWith(...) }

	      deferred[tuple[0]] = function () {
	        deferred[tuple[0] + "With"](this === deferred ? undefined : this, arguments);
	        return this;
	      }; // deferred.notifyWith = list.fireWith
	      // deferred.resolveWith = list.fireWith
	      // deferred.rejectWith = list.fireWith


	      deferred[tuple[0] + "With"] = list.fireWith;
	    }); // Make the deferred a promise

	    _promise.promise(deferred); // Call given func if any


	    if (func) {
	      func.call(deferred, deferred);
	    } // All done!


	    return deferred;
	  },
	  // Deferred helper
	  when: function when(singleValue) {
	    var // count of uncompleted subordinates
	    remaining = arguments.length,
	        // count of unprocessed arguments
	    i = remaining,
	        // subordinate fulfillment data
	    resolveContexts = Array(i),
	        resolveValues = _slice.call(arguments),
	        // the master Deferred
	    master = jQuery.Deferred(),
	        // subordinate callback factory
	    updateFunc = function updateFunc(i) {
	      return function (value) {
	        resolveContexts[i] = this;
	        resolveValues[i] = arguments.length > 1 ? _slice.call(arguments) : value;

	        if (! --remaining) {
	          master.resolveWith(resolveContexts, resolveValues);
	        }
	      };
	    }; // Single- and empty arguments are adopted like Promise.resolve


	    if (remaining <= 1) {
	      adoptValue(singleValue, master.done(updateFunc(i)).resolve, master.reject, !remaining); // Use .then() to unwrap secondary thenables (cf. gh-3000)

	      if (master.state() === "pending" || isFunction(resolveValues[i] && resolveValues[i].then)) {
	        return master.then();
	      }
	    } // Multiple arguments are aggregated like Promise.all array elements


	    while (i--) {
	      adoptValue(resolveValues[i], updateFunc(i), master.reject);
	    }

	    return master.promise();
	  }
	}); // These usually indicate a programmer mistake during development,
	// warn about them ASAP rather than swallowing them by default.

	var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

	jQuery.Deferred.exceptionHook = function (error, stack) {
	  // Support: IE 8 - 9 only
	  // Console exists when dev tools are open, which can happen at any time
	  if (window.console && window.console.warn && error && rerrorNames.test(error.name)) {
	    window.console.warn("jQuery.Deferred exception: " + error.message, error.stack, stack);
	  }
	};

	jQuery.readyException = function (error) {
	  window.setTimeout(function () {
	    throw error;
	  });
	}; // The deferred used on DOM ready


	var readyList = jQuery.Deferred();

	jQuery.fn.ready = function (fn) {
	  readyList.then(fn) // Wrap jQuery.readyException in a function so that the lookup
	  // happens at the time of error handling instead of callback
	  // registration.
	  .catch(function (error) {
	    jQuery.readyException(error);
	  });
	  return this;
	};

	jQuery.extend({
	  // Is the DOM ready to be used? Set to true once it occurs.
	  isReady: false,
	  // A counter to track how many items to wait for before
	  // the ready event fires. See #6781
	  readyWait: 1,
	  // Handle when the DOM is ready
	  ready: function ready(wait) {
	    // Abort if there are pending holds or we're already ready
	    if (wait === true ? --jQuery.readyWait : jQuery.isReady) {
	      return;
	    } // Remember that the DOM is ready


	    jQuery.isReady = true; // If a normal DOM Ready event fired, decrement, and wait if need be

	    if (wait !== true && --jQuery.readyWait > 0) {
	      return;
	    } // If there are functions bound, to execute


	    readyList.resolveWith(document$2, [jQuery]);
	  }
	});
	jQuery.ready.then = readyList.then; // The ready event handler and self cleanup method

	function completed() {
	  document$2.removeEventListener("DOMContentLoaded", completed);
	  window.removeEventListener("load", completed);
	  jQuery.ready();
	} // Catch cases where $(document).ready() is called
	// after the browser event has already occurred.
	// Support: IE <=9 - 10 only
	// Older IE sometimes signals "interactive" too soon


	if (document$2.readyState === "complete" || document$2.readyState !== "loading" && !document$2.documentElement.doScroll) {
	  // Handle it asynchronously to allow scripts the opportunity to delay ready
	  window.setTimeout(jQuery.ready);
	} else {
	  // Use the handy event callback
	  document$2.addEventListener("DOMContentLoaded", completed); // A fallback to window.onload, that will always work

	  window.addEventListener("load", completed);
	} // Multifunctional method to get and set values of a collection
	// The value/s can optionally be executed if it's a function


	var access = function access(elems, fn, key, value, chainable, emptyGet, raw) {
	  var i = 0,
	      len = elems.length,
	      bulk = key == null; // Sets many values

	  if (toType(key) === "object") {
	    chainable = true;

	    for (i in key) {
	      access(elems, fn, i, key[i], true, emptyGet, raw);
	    } // Sets one value

	  } else if (value !== undefined) {
	    chainable = true;

	    if (!isFunction(value)) {
	      raw = true;
	    }

	    if (bulk) {
	      // Bulk operations run against the entire set
	      if (raw) {
	        fn.call(elems, value);
	        fn = null; // ...except when executing function values
	      } else {
	        bulk = fn;

	        fn = function fn(elem, key, value) {
	          return bulk.call(jQuery(elem), value);
	        };
	      }
	    }

	    if (fn) {
	      for (; i < len; i++) {
	        fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)));
	      }
	    }
	  }

	  if (chainable) {
	    return elems;
	  } // Gets


	  if (bulk) {
	    return fn.call(elems);
	  }

	  return len ? fn(elems[0], key) : emptyGet;
	}; // Matches dashed string for camelizing


	var rmsPrefix = /^-ms-/,
	    rdashAlpha = /-([a-z])/g; // Used by camelCase as callback to replace()

	function fcamelCase(all, letter) {
	  return letter.toUpperCase();
	} // Convert dashed to camelCase; used by the css and data modules
	// Support: IE <=9 - 11, Edge 12 - 15
	// Microsoft forgot to hump their vendor prefix (#9572)


	function camelCase(string) {
	  return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
	}

	var acceptData = function acceptData(owner) {
	  // Accepts only:
	  //  - Node
	  //    - Node.ELEMENT_NODE
	  //    - Node.DOCUMENT_NODE
	  //  - Object
	  //    - Any
	  return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType;
	};

	function Data() {
	  this.expando = jQuery.expando + Data.uid++;
	}

	Data.uid = 1;
	Data.prototype = {
	  cache: function cache(owner) {
	    // Check if the owner object already has a cache
	    var value = owner[this.expando]; // If not, create one

	    if (!value) {
	      value = {}; // We can accept data for non-element nodes in modern browsers,
	      // but we should not, see #8335.
	      // Always return an empty object.

	      if (acceptData(owner)) {
	        // If it is a node unlikely to be stringify-ed or looped over
	        // use plain assignment
	        if (owner.nodeType) {
	          owner[this.expando] = value; // Otherwise secure it in a non-enumerable property
	          // configurable must be true to allow the property to be
	          // deleted when data is removed
	        } else {
	          Object.defineProperty(owner, this.expando, {
	            value: value,
	            configurable: true
	          });
	        }
	      }
	    }

	    return value;
	  },
	  set: function set(owner, data, value) {
	    var prop,
	        cache = this.cache(owner); // Handle: [ owner, key, value ] args
	    // Always use camelCase key (gh-2257)

	    if (typeof data === "string") {
	      cache[camelCase(data)] = value; // Handle: [ owner, { properties } ] args
	    } else {
	      // Copy the properties one-by-one to the cache object
	      for (prop in data) {
	        cache[camelCase(prop)] = data[prop];
	      }
	    }

	    return cache;
	  },
	  get: function get(owner, key) {
	    return key === undefined ? this.cache(owner) : // Always use camelCase key (gh-2257)
	    owner[this.expando] && owner[this.expando][camelCase(key)];
	  },
	  access: function access(owner, key, value) {
	    // In cases where either:
	    //
	    //   1. No key was specified
	    //   2. A string key was specified, but no value provided
	    //
	    // Take the "read" path and allow the get method to determine
	    // which value to return, respectively either:
	    //
	    //   1. The entire cache object
	    //   2. The data stored at the key
	    //
	    if (key === undefined || key && typeof key === "string" && value === undefined) {
	      return this.get(owner, key);
	    } // When the key is not a string, or both a key and value
	    // are specified, set or extend (existing objects) with either:
	    //
	    //   1. An object of properties
	    //   2. A key and value
	    //


	    this.set(owner, key, value); // Since the "set" path can have two possible entry points
	    // return the expected data based on which path was taken[*]

	    return value !== undefined ? value : key;
	  },
	  remove: function remove(owner, key) {
	    var i,
	        cache = owner[this.expando];

	    if (cache === undefined) {
	      return;
	    }

	    if (key !== undefined) {
	      // Support array or space separated string of keys
	      if (Array.isArray(key)) {
	        // If key is an array of keys...
	        // We always set camelCase keys, so remove that.
	        key = key.map(camelCase);
	      } else {
	        key = camelCase(key); // If a key with the spaces exists, use it.
	        // Otherwise, create an array by matching non-whitespace

	        key = key in cache ? [key] : key.match(rnothtmlwhite) || [];
	      }

	      i = key.length;

	      while (i--) {
	        delete cache[key[i]];
	      }
	    } // Remove the expando if there's no more data


	    if (key === undefined || jQuery.isEmptyObject(cache)) {
	      // Support: Chrome <=35 - 45
	      // Webkit & Blink performance suffers when deleting properties
	      // from DOM nodes, so set to undefined instead
	      // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
	      if (owner.nodeType) {
	        owner[this.expando] = undefined;
	      } else {
	        delete owner[this.expando];
	      }
	    }
	  },
	  hasData: function hasData(owner) {
	    var cache = owner[this.expando];
	    return cache !== undefined && !jQuery.isEmptyObject(cache);
	  }
	};
	var dataPriv = new Data();
	var dataUser = new Data(); //	Implementation Summary
	//
	//	1. Enforce API surface and semantic compatibility with 1.9.x branch
	//	2. Improve the module's maintainability by reducing the storage
	//		paths to a single mechanism.
	//	3. Use the same single mechanism to support "private" and "user" data.
	//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
	//	5. Avoid exposing implementation details on user objects (eg. expando properties)
	//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

	var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	    rmultiDash = /[A-Z]/g;

	function getData(data) {
	  if (data === "true") {
	    return true;
	  }

	  if (data === "false") {
	    return false;
	  }

	  if (data === "null") {
	    return null;
	  } // Only convert to a number if it doesn't change the string


	  if (data === +data + "") {
	    return +data;
	  }

	  if (rbrace.test(data)) {
	    return JSON.parse(data);
	  }

	  return data;
	}

	function dataAttr(elem, key, data) {
	  var name; // If nothing was found internally, try to fetch any
	  // data from the HTML5 data-* attribute

	  if (data === undefined && elem.nodeType === 1) {
	    name = "data-" + key.replace(rmultiDash, "-$&").toLowerCase();
	    data = elem.getAttribute(name);

	    if (typeof data === "string") {
	      try {
	        data = getData(data);
	      } catch (e) {} // Make sure we set the data so it isn't changed later


	      dataUser.set(elem, key, data);
	    } else {
	      data = undefined;
	    }
	  }

	  return data;
	}

	jQuery.extend({
	  hasData: function hasData(elem) {
	    return dataUser.hasData(elem) || dataPriv.hasData(elem);
	  },
	  data: function data(elem, name, _data) {
	    return dataUser.access(elem, name, _data);
	  },
	  removeData: function removeData(elem, name) {
	    dataUser.remove(elem, name);
	  },
	  // TODO: Now that all calls to _data and _removeData have been replaced
	  // with direct calls to dataPriv methods, these can be deprecated.
	  _data: function _data(elem, name, data) {
	    return dataPriv.access(elem, name, data);
	  },
	  _removeData: function _removeData(elem, name) {
	    dataPriv.remove(elem, name);
	  }
	});
	jQuery.fn.extend({
	  data: function data(key, value) {
	    var i,
	        name,
	        data,
	        elem = this[0],
	        attrs = elem && elem.attributes; // Gets all values

	    if (key === undefined) {
	      if (this.length) {
	        data = dataUser.get(elem);

	        if (elem.nodeType === 1 && !dataPriv.get(elem, "hasDataAttrs")) {
	          i = attrs.length;

	          while (i--) {
	            // Support: IE 11 only
	            // The attrs elements can be null (#14894)
	            if (attrs[i]) {
	              name = attrs[i].name;

	              if (name.indexOf("data-") === 0) {
	                name = camelCase(name.slice(5));
	                dataAttr(elem, name, data[name]);
	              }
	            }
	          }

	          dataPriv.set(elem, "hasDataAttrs", true);
	        }
	      }

	      return data;
	    } // Sets multiple values


	    if (_typeof(key) === "object") {
	      return this.each(function () {
	        dataUser.set(this, key);
	      });
	    }

	    return access(this, function (value) {
	      var data; // The calling jQuery object (element matches) is not empty
	      // (and therefore has an element appears at this[ 0 ]) and the
	      // `value` parameter was not undefined. An empty jQuery object
	      // will result in `undefined` for elem = this[ 0 ] which will
	      // throw an exception if an attempt to read a data cache is made.

	      if (elem && value === undefined) {
	        // Attempt to get data from the cache
	        // The key will always be camelCased in Data
	        data = dataUser.get(elem, key);

	        if (data !== undefined) {
	          return data;
	        } // Attempt to "discover" the data in
	        // HTML5 custom data-* attrs


	        data = dataAttr(elem, key);

	        if (data !== undefined) {
	          return data;
	        } // We tried really hard, but the data doesn't exist.


	        return;
	      } // Set the data...


	      this.each(function () {
	        // We always store the camelCased key
	        dataUser.set(this, key, value);
	      });
	    }, null, value, arguments.length > 1, null, true);
	  },
	  removeData: function removeData(key) {
	    return this.each(function () {
	      dataUser.remove(this, key);
	    });
	  }
	});
	jQuery.extend({
	  queue: function queue(elem, type, data) {
	    var queue;

	    if (elem) {
	      type = (type || "fx") + "queue";
	      queue = dataPriv.get(elem, type); // Speed up dequeue by getting out quickly if this is just a lookup

	      if (data) {
	        if (!queue || Array.isArray(data)) {
	          queue = dataPriv.access(elem, type, jQuery.makeArray(data));
	        } else {
	          queue.push(data);
	        }
	      }

	      return queue || [];
	    }
	  },
	  dequeue: function dequeue(elem, type) {
	    type = type || "fx";

	    var queue = jQuery.queue(elem, type),
	        startLength = queue.length,
	        fn = queue.shift(),
	        hooks = jQuery._queueHooks(elem, type),
	        next = function next() {
	      jQuery.dequeue(elem, type);
	    }; // If the fx queue is dequeued, always remove the progress sentinel


	    if (fn === "inprogress") {
	      fn = queue.shift();
	      startLength--;
	    }

	    if (fn) {
	      // Add a progress sentinel to prevent the fx queue from being
	      // automatically dequeued
	      if (type === "fx") {
	        queue.unshift("inprogress");
	      } // Clear up the last queue stop function


	      delete hooks.stop;
	      fn.call(elem, next, hooks);
	    }

	    if (!startLength && hooks) {
	      hooks.empty.fire();
	    }
	  },
	  // Not public - generate a queueHooks object, or return the current one
	  _queueHooks: function _queueHooks(elem, type) {
	    var key = type + "queueHooks";
	    return dataPriv.get(elem, key) || dataPriv.access(elem, key, {
	      empty: jQuery.Callbacks("once memory").add(function () {
	        dataPriv.remove(elem, [type + "queue", key]);
	      })
	    });
	  }
	});
	jQuery.fn.extend({
	  queue: function queue(type, data) {
	    var setter = 2;

	    if (typeof type !== "string") {
	      data = type;
	      type = "fx";
	      setter--;
	    }

	    if (arguments.length < setter) {
	      return jQuery.queue(this[0], type);
	    }

	    return data === undefined ? this : this.each(function () {
	      var queue = jQuery.queue(this, type, data); // Ensure a hooks for this queue

	      jQuery._queueHooks(this, type);

	      if (type === "fx" && queue[0] !== "inprogress") {
	        jQuery.dequeue(this, type);
	      }
	    });
	  },
	  dequeue: function dequeue(type) {
	    return this.each(function () {
	      jQuery.dequeue(this, type);
	    });
	  },
	  clearQueue: function clearQueue(type) {
	    return this.queue(type || "fx", []);
	  },
	  // Get a promise resolved when queues of a certain type
	  // are emptied (fx is the type by default)
	  promise: function promise(type, obj) {
	    var tmp,
	        count = 1,
	        defer = jQuery.Deferred(),
	        elements = this,
	        i = this.length,
	        resolve = function resolve() {
	      if (! --count) {
	        defer.resolveWith(elements, [elements]);
	      }
	    };

	    if (typeof type !== "string") {
	      obj = type;
	      type = undefined;
	    }

	    type = type || "fx";

	    while (i--) {
	      tmp = dataPriv.get(elements[i], type + "queueHooks");

	      if (tmp && tmp.empty) {
	        count++;
	        tmp.empty.add(resolve);
	      }
	    }

	    resolve();
	    return defer.promise(obj);
	  }
	});
	var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
	var rcssNum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i");
	var cssExpand = ["Top", "Right", "Bottom", "Left"];

	var isHiddenWithinTree = function isHiddenWithinTree(elem, el) {
	  // isHiddenWithinTree might be called from jQuery#filter function;
	  // in that case, element will be second argument
	  elem = el || elem; // Inline style trumps all

	  return elem.style.display === "none" || elem.style.display === "" && // Otherwise, check computed style
	  // Support: Firefox <=43 - 45
	  // Disconnected elements can have computed display: none, so first confirm that elem is
	  // in the document.
	  jQuery.contains(elem.ownerDocument, elem) && jQuery.css(elem, "display") === "none";
	};

	var swap = function swap(elem, options, callback, args) {
	  var ret,
	      name,
	      old = {}; // Remember the old values, and insert the new ones

	  for (name in options) {
	    old[name] = elem.style[name];
	    elem.style[name] = options[name];
	  }

	  ret = callback.apply(elem, args || []); // Revert the old values

	  for (name in options) {
	    elem.style[name] = old[name];
	  }

	  return ret;
	};

	function adjustCSS(elem, prop, valueParts, tween) {
	  var adjusted,
	      scale,
	      maxIterations = 20,
	      currentValue = tween ? function () {
	    return tween.cur();
	  } : function () {
	    return jQuery.css(elem, prop, "");
	  },
	      initial = currentValue(),
	      unit = valueParts && valueParts[3] || (jQuery.cssNumber[prop] ? "" : "px"),
	      // Starting value computation is required for potential unit mismatches
	  initialInUnit = (jQuery.cssNumber[prop] || unit !== "px" && +initial) && rcssNum.exec(jQuery.css(elem, prop));

	  if (initialInUnit && initialInUnit[3] !== unit) {
	    // Support: Firefox <=54
	    // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
	    initial = initial / 2; // Trust units reported by jQuery.css

	    unit = unit || initialInUnit[3]; // Iteratively approximate from a nonzero starting point

	    initialInUnit = +initial || 1;

	    while (maxIterations--) {
	      // Evaluate and update our best guess (doubling guesses that zero out).
	      // Finish if the scale equals or crosses 1 (making the old*new product non-positive).
	      jQuery.style(elem, prop, initialInUnit + unit);

	      if ((1 - scale) * (1 - (scale = currentValue() / initial || 0.5)) <= 0) {
	        maxIterations = 0;
	      }

	      initialInUnit = initialInUnit / scale;
	    }

	    initialInUnit = initialInUnit * 2;
	    jQuery.style(elem, prop, initialInUnit + unit); // Make sure we update the tween properties later on

	    valueParts = valueParts || [];
	  }

	  if (valueParts) {
	    initialInUnit = +initialInUnit || +initial || 0; // Apply relative offset (+=/-=) if specified

	    adjusted = valueParts[1] ? initialInUnit + (valueParts[1] + 1) * valueParts[2] : +valueParts[2];

	    if (tween) {
	      tween.unit = unit;
	      tween.start = initialInUnit;
	      tween.end = adjusted;
	    }
	  }

	  return adjusted;
	}

	var defaultDisplayMap = {};

	function getDefaultDisplay(elem) {
	  var temp,
	      doc = elem.ownerDocument,
	      nodeName = elem.nodeName,
	      display = defaultDisplayMap[nodeName];

	  if (display) {
	    return display;
	  }

	  temp = doc.body.appendChild(doc.createElement(nodeName));
	  display = jQuery.css(temp, "display");
	  temp.parentNode.removeChild(temp);

	  if (display === "none") {
	    display = "block";
	  }

	  defaultDisplayMap[nodeName] = display;
	  return display;
	}

	function showHide(elements, show) {
	  var display,
	      elem,
	      values = [],
	      index = 0,
	      length = elements.length; // Determine new display value for elements that need to change

	  for (; index < length; index++) {
	    elem = elements[index];

	    if (!elem.style) {
	      continue;
	    }

	    display = elem.style.display;

	    if (show) {
	      // Since we force visibility upon cascade-hidden elements, an immediate (and slow)
	      // check is required in this first loop unless we have a nonempty display value (either
	      // inline or about-to-be-restored)
	      if (display === "none") {
	        values[index] = dataPriv.get(elem, "display") || null;

	        if (!values[index]) {
	          elem.style.display = "";
	        }
	      }

	      if (elem.style.display === "" && isHiddenWithinTree(elem)) {
	        values[index] = getDefaultDisplay(elem);
	      }
	    } else {
	      if (display !== "none") {
	        values[index] = "none"; // Remember what we're overwriting

	        dataPriv.set(elem, "display", display);
	      }
	    }
	  } // Set the display of the elements in a second loop to avoid constant reflow


	  for (index = 0; index < length; index++) {
	    if (values[index] != null) {
	      elements[index].style.display = values[index];
	    }
	  }

	  return elements;
	}

	jQuery.fn.extend({
	  show: function show() {
	    return showHide(this, true);
	  },
	  hide: function hide() {
	    return showHide(this);
	  },
	  toggle: function toggle(state) {
	    if (typeof state === "boolean") {
	      return state ? this.show() : this.hide();
	    }

	    return this.each(function () {
	      if (isHiddenWithinTree(this)) {
	        jQuery(this).show();
	      } else {
	        jQuery(this).hide();
	      }
	    });
	  }
	});
	var rcheckableType = /^(?:checkbox|radio)$/i;
	var rtagName = /<([a-z][^\/\0>\x20\t\r\n\f]+)/i;
	var rscriptType = /^$|^module$|\/(?:java|ecma)script/i; // We have to close these tags to support XHTML (#13200)

	var wrapMap = {
	  // Support: IE <=9 only
	  option: [1, "<select multiple='multiple'>", "</select>"],
	  // XHTML parsers do not magically insert elements in the
	  // same way that tag soup parsers do. So we cannot shorten
	  // this by omitting <tbody> or other required elements.
	  thead: [1, "<table>", "</table>"],
	  col: [2, "<table><colgroup>", "</colgroup></table>"],
	  tr: [2, "<table><tbody>", "</tbody></table>"],
	  td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
	  _default: [0, "", ""]
	}; // Support: IE <=9 only

	wrapMap.optgroup = wrapMap.option;
	wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
	wrapMap.th = wrapMap.td;

	function getAll(context, tag) {
	  // Support: IE <=9 - 11 only
	  // Use typeof to avoid zero-argument method invocation on host objects (#15151)
	  var ret;

	  if (typeof context.getElementsByTagName !== "undefined") {
	    ret = context.getElementsByTagName(tag || "*");
	  } else if (typeof context.querySelectorAll !== "undefined") {
	    ret = context.querySelectorAll(tag || "*");
	  } else {
	    ret = [];
	  }

	  if (tag === undefined || tag && nodeName(context, tag)) {
	    return jQuery.merge([context], ret);
	  }

	  return ret;
	} // Mark scripts as having already been evaluated


	function setGlobalEval(elems, refElements) {
	  var i = 0,
	      l = elems.length;

	  for (; i < l; i++) {
	    dataPriv.set(elems[i], "globalEval", !refElements || dataPriv.get(refElements[i], "globalEval"));
	  }
	}

	var rhtml = /<|&#?\w+;/;

	function buildFragment(elems, context, scripts, selection, ignored) {
	  var elem,
	      tmp,
	      tag,
	      wrap,
	      contains,
	      j,
	      fragment = context.createDocumentFragment(),
	      nodes = [],
	      i = 0,
	      l = elems.length;

	  for (; i < l; i++) {
	    elem = elems[i];

	    if (elem || elem === 0) {
	      // Add nodes directly
	      if (toType(elem) === "object") {
	        // Support: Android <=4.0 only, PhantomJS 1 only
	        // push.apply(_, arraylike) throws on ancient WebKit
	        jQuery.merge(nodes, elem.nodeType ? [elem] : elem); // Convert non-html into a text node
	      } else if (!rhtml.test(elem)) {
	        nodes.push(context.createTextNode(elem)); // Convert html into DOM nodes
	      } else {
	        tmp = tmp || fragment.appendChild(context.createElement("div")); // Deserialize a standard representation

	        tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
	        wrap = wrapMap[tag] || wrapMap._default;
	        tmp.innerHTML = wrap[1] + jQuery.htmlPrefilter(elem) + wrap[2]; // Descend through wrappers to the right content

	        j = wrap[0];

	        while (j--) {
	          tmp = tmp.lastChild;
	        } // Support: Android <=4.0 only, PhantomJS 1 only
	        // push.apply(_, arraylike) throws on ancient WebKit


	        jQuery.merge(nodes, tmp.childNodes); // Remember the top-level container

	        tmp = fragment.firstChild; // Ensure the created nodes are orphaned (#12392)

	        tmp.textContent = "";
	      }
	    }
	  } // Remove wrapper from fragment


	  fragment.textContent = "";
	  i = 0;

	  while (elem = nodes[i++]) {
	    // Skip elements already in the context collection (trac-4087)
	    if (selection && jQuery.inArray(elem, selection) > -1) {
	      if (ignored) {
	        ignored.push(elem);
	      }

	      continue;
	    }

	    contains = jQuery.contains(elem.ownerDocument, elem); // Append to fragment

	    tmp = getAll(fragment.appendChild(elem), "script"); // Preserve script evaluation history

	    if (contains) {
	      setGlobalEval(tmp);
	    } // Capture executables


	    if (scripts) {
	      j = 0;

	      while (elem = tmp[j++]) {
	        if (rscriptType.test(elem.type || "")) {
	          scripts.push(elem);
	        }
	      }
	    }
	  }

	  return fragment;
	}

	(function () {
	  var fragment = document$2.createDocumentFragment(),
	      div = fragment.appendChild(document$2.createElement("div")),
	      input = document$2.createElement("input"); // Support: Android 4.0 - 4.3 only
	  // Check state lost if the name is set (#11217)
	  // Support: Windows Web Apps (WWA)
	  // `name` and `type` must use .setAttribute for WWA (#14901)

	  input.setAttribute("type", "radio");
	  input.setAttribute("checked", "checked");
	  input.setAttribute("name", "t");
	  div.appendChild(input); // Support: Android <=4.1 only
	  // Older WebKit doesn't clone checked state correctly in fragments

	  support.checkClone = div.cloneNode(true).cloneNode(true).lastChild.checked; // Support: IE <=11 only
	  // Make sure textarea (and checkbox) defaultValue is properly cloned

	  div.innerHTML = "<textarea>x</textarea>";
	  support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue;
	})();

	var documentElement = document$2.documentElement;
	var rkeyEvent = /^key/,
	    rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	    rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

	function returnTrue() {
	  return true;
	}

	function returnFalse() {
	  return false;
	} // Support: IE <=9 only
	// See #13393 for more info


	function safeActiveElement() {
	  try {
	    return document$2.activeElement;
	  } catch (err) {}
	}

	function _on(elem, types, selector, data, fn, one) {
	  var origFn, type; // Types can be a map of types/handlers

	  if (_typeof(types) === "object") {
	    // ( types-Object, selector, data )
	    if (typeof selector !== "string") {
	      // ( types-Object, data )
	      data = data || selector;
	      selector = undefined;
	    }

	    for (type in types) {
	      _on(elem, type, selector, data, types[type], one);
	    }

	    return elem;
	  }

	  if (data == null && fn == null) {
	    // ( types, fn )
	    fn = selector;
	    data = selector = undefined;
	  } else if (fn == null) {
	    if (typeof selector === "string") {
	      // ( types, selector, fn )
	      fn = data;
	      data = undefined;
	    } else {
	      // ( types, data, fn )
	      fn = data;
	      data = selector;
	      selector = undefined;
	    }
	  }

	  if (fn === false) {
	    fn = returnFalse;
	  } else if (!fn) {
	    return elem;
	  }

	  if (one === 1) {
	    origFn = fn;

	    fn = function fn(event) {
	      // Can use an empty set, since event contains the info
	      jQuery().off(event);
	      return origFn.apply(this, arguments);
	    }; // Use same guid so caller can remove using origFn


	    fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
	  }

	  return elem.each(function () {
	    jQuery.event.add(this, types, fn, data, selector);
	  });
	}
	/*
	 * Helper functions for managing events -- not part of the public interface.
	 * Props to Dean Edwards' addEvent library for many of the ideas.
	 */


	jQuery.event = {
	  global: {},
	  add: function add(elem, types, handler, data, selector) {
	    var handleObjIn,
	        eventHandle,
	        tmp,
	        events,
	        t,
	        handleObj,
	        special,
	        handlers,
	        type,
	        namespaces,
	        origType,
	        elemData = dataPriv.get(elem); // Don't attach events to noData or text/comment nodes (but allow plain objects)

	    if (!elemData) {
	      return;
	    } // Caller can pass in an object of custom data in lieu of the handler


	    if (handler.handler) {
	      handleObjIn = handler;
	      handler = handleObjIn.handler;
	      selector = handleObjIn.selector;
	    } // Ensure that invalid selectors throw exceptions at attach time
	    // Evaluate against documentElement in case elem is a non-element node (e.g., document)


	    if (selector) {
	      jQuery.find.matchesSelector(documentElement, selector);
	    } // Make sure that the handler has a unique ID, used to find/remove it later


	    if (!handler.guid) {
	      handler.guid = jQuery.guid++;
	    } // Init the element's event structure and main handler, if this is the first


	    if (!(events = elemData.events)) {
	      events = elemData.events = {};
	    }

	    if (!(eventHandle = elemData.handle)) {
	      eventHandle = elemData.handle = function (e) {
	        // Discard the second event of a jQuery.event.trigger() and
	        // when an event is called after a page has unloaded
	        return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ? jQuery.event.dispatch.apply(elem, arguments) : undefined;
	      };
	    } // Handle multiple events separated by a space


	    types = (types || "").match(rnothtmlwhite) || [""];
	    t = types.length;

	    while (t--) {
	      tmp = rtypenamespace.exec(types[t]) || [];
	      type = origType = tmp[1];
	      namespaces = (tmp[2] || "").split(".").sort(); // There *must* be a type, no attaching namespace-only handlers

	      if (!type) {
	        continue;
	      } // If event changes its type, use the special event handlers for the changed type


	      special = jQuery.event.special[type] || {}; // If selector defined, determine special event api type, otherwise given type

	      type = (selector ? special.delegateType : special.bindType) || type; // Update special based on newly reset type

	      special = jQuery.event.special[type] || {}; // handleObj is passed to all event handlers

	      handleObj = jQuery.extend({
	        type: type,
	        origType: origType,
	        data: data,
	        handler: handler,
	        guid: handler.guid,
	        selector: selector,
	        needsContext: selector && jQuery.expr.match.needsContext.test(selector),
	        namespace: namespaces.join(".")
	      }, handleObjIn); // Init the event handler queue if we're the first

	      if (!(handlers = events[type])) {
	        handlers = events[type] = [];
	        handlers.delegateCount = 0; // Only use addEventListener if the special events handler returns false

	        if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
	          if (elem.addEventListener) {
	            elem.addEventListener(type, eventHandle);
	          }
	        }
	      }

	      if (special.add) {
	        special.add.call(elem, handleObj);

	        if (!handleObj.handler.guid) {
	          handleObj.handler.guid = handler.guid;
	        }
	      } // Add to the element's handler list, delegates in front


	      if (selector) {
	        handlers.splice(handlers.delegateCount++, 0, handleObj);
	      } else {
	        handlers.push(handleObj);
	      } // Keep track of which events have ever been used, for event optimization


	      jQuery.event.global[type] = true;
	    }
	  },
	  // Detach an event or set of events from an element
	  remove: function remove(elem, types, handler, selector, mappedTypes) {
	    var j,
	        origCount,
	        tmp,
	        events,
	        t,
	        handleObj,
	        special,
	        handlers,
	        type,
	        namespaces,
	        origType,
	        elemData = dataPriv.hasData(elem) && dataPriv.get(elem);

	    if (!elemData || !(events = elemData.events)) {
	      return;
	    } // Once for each type.namespace in types; type may be omitted


	    types = (types || "").match(rnothtmlwhite) || [""];
	    t = types.length;

	    while (t--) {
	      tmp = rtypenamespace.exec(types[t]) || [];
	      type = origType = tmp[1];
	      namespaces = (tmp[2] || "").split(".").sort(); // Unbind all events (on this namespace, if provided) for the element

	      if (!type) {
	        for (type in events) {
	          jQuery.event.remove(elem, type + types[t], handler, selector, true);
	        }

	        continue;
	      }

	      special = jQuery.event.special[type] || {};
	      type = (selector ? special.delegateType : special.bindType) || type;
	      handlers = events[type] || [];
	      tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"); // Remove matching events

	      origCount = j = handlers.length;

	      while (j--) {
	        handleObj = handlers[j];

	        if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
	          handlers.splice(j, 1);

	          if (handleObj.selector) {
	            handlers.delegateCount--;
	          }

	          if (special.remove) {
	            special.remove.call(elem, handleObj);
	          }
	        }
	      } // Remove generic event handler if we removed something and no more handlers exist
	      // (avoids potential for endless recursion during removal of special event handlers)


	      if (origCount && !handlers.length) {
	        if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
	          jQuery.removeEvent(elem, type, elemData.handle);
	        }

	        delete events[type];
	      }
	    } // Remove data and the expando if it's no longer used


	    if (jQuery.isEmptyObject(events)) {
	      dataPriv.remove(elem, "handle events");
	    }
	  },
	  dispatch: function dispatch(nativeEvent) {
	    // Make a writable jQuery.Event from the native event object
	    var event = jQuery.event.fix(nativeEvent);
	    var i,
	        j,
	        ret,
	        matched,
	        handleObj,
	        handlerQueue,
	        args = new Array(arguments.length),
	        handlers = (dataPriv.get(this, "events") || {})[event.type] || [],
	        special = jQuery.event.special[event.type] || {}; // Use the fix-ed jQuery.Event rather than the (read-only) native event

	    args[0] = event;

	    for (i = 1; i < arguments.length; i++) {
	      args[i] = arguments[i];
	    }

	    event.delegateTarget = this; // Call the preDispatch hook for the mapped type, and let it bail if desired

	    if (special.preDispatch && special.preDispatch.call(this, event) === false) {
	      return;
	    } // Determine handlers


	    handlerQueue = jQuery.event.handlers.call(this, event, handlers); // Run delegates first; they may want to stop propagation beneath us

	    i = 0;

	    while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) {
	      event.currentTarget = matched.elem;
	      j = 0;

	      while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped()) {
	        // Triggered event must either 1) have no namespace, or 2) have namespace(s)
	        // a subset or equal to those in the bound event (both can have no namespace).
	        if (!event.rnamespace || event.rnamespace.test(handleObj.namespace)) {
	          event.handleObj = handleObj;
	          event.data = handleObj.data;
	          ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args);

	          if (ret !== undefined) {
	            if ((event.result = ret) === false) {
	              event.preventDefault();
	              event.stopPropagation();
	            }
	          }
	        }
	      }
	    } // Call the postDispatch hook for the mapped type


	    if (special.postDispatch) {
	      special.postDispatch.call(this, event);
	    }

	    return event.result;
	  },
	  handlers: function handlers(event, _handlers) {
	    var i,
	        handleObj,
	        sel,
	        matchedHandlers,
	        matchedSelectors,
	        handlerQueue = [],
	        delegateCount = _handlers.delegateCount,
	        cur = event.target; // Find delegate handlers

	    if (delegateCount && // Support: IE <=9
	    // Black-hole SVG <use> instance trees (trac-13180)
	    cur.nodeType && // Support: Firefox <=42
	    // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
	    // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
	    // Support: IE 11 only
	    // ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
	    !(event.type === "click" && event.button >= 1)) {
	      for (; cur !== this; cur = cur.parentNode || this) {
	        // Don't check non-elements (#13208)
	        // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
	        if (cur.nodeType === 1 && !(event.type === "click" && cur.disabled === true)) {
	          matchedHandlers = [];
	          matchedSelectors = {};

	          for (i = 0; i < delegateCount; i++) {
	            handleObj = _handlers[i]; // Don't conflict with Object.prototype properties (#13203)

	            sel = handleObj.selector + " ";

	            if (matchedSelectors[sel] === undefined) {
	              matchedSelectors[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) > -1 : jQuery.find(sel, this, null, [cur]).length;
	            }

	            if (matchedSelectors[sel]) {
	              matchedHandlers.push(handleObj);
	            }
	          }

	          if (matchedHandlers.length) {
	            handlerQueue.push({
	              elem: cur,
	              handlers: matchedHandlers
	            });
	          }
	        }
	      }
	    } // Add the remaining (directly-bound) handlers


	    cur = this;

	    if (delegateCount < _handlers.length) {
	      handlerQueue.push({
	        elem: cur,
	        handlers: _handlers.slice(delegateCount)
	      });
	    }

	    return handlerQueue;
	  },
	  addProp: function addProp(name, hook) {
	    Object.defineProperty(jQuery.Event.prototype, name, {
	      enumerable: true,
	      configurable: true,
	      get: isFunction(hook) ? function () {
	        if (this.originalEvent) {
	          return hook(this.originalEvent);
	        }
	      } : function () {
	        if (this.originalEvent) {
	          return this.originalEvent[name];
	        }
	      },
	      set: function set(value) {
	        Object.defineProperty(this, name, {
	          enumerable: true,
	          configurable: true,
	          writable: true,
	          value: value
	        });
	      }
	    });
	  },
	  fix: function fix(originalEvent) {
	    return originalEvent[jQuery.expando] ? originalEvent : new jQuery.Event(originalEvent);
	  },
	  special: {
	    load: {
	      // Prevent triggered image.load events from bubbling to window.load
	      noBubble: true
	    },
	    focus: {
	      // Fire native event if possible so blur/focus sequence is correct
	      trigger: function trigger() {
	        if (this !== safeActiveElement() && this.focus) {
	          this.focus();
	          return false;
	        }
	      },
	      delegateType: "focusin"
	    },
	    blur: {
	      trigger: function trigger() {
	        if (this === safeActiveElement() && this.blur) {
	          this.blur();
	          return false;
	        }
	      },
	      delegateType: "focusout"
	    },
	    click: {
	      // For checkbox, fire native event so checked state will be right
	      trigger: function trigger() {
	        if (this.type === "checkbox" && this.click && nodeName(this, "input")) {
	          this.click();
	          return false;
	        }
	      },
	      // For cross-browser consistency, don't fire native .click() on links
	      _default: function _default(event) {
	        return nodeName(event.target, "a");
	      }
	    },
	    beforeunload: {
	      postDispatch: function postDispatch(event) {
	        // Support: Firefox 20+
	        // Firefox doesn't alert if the returnValue field is not set.
	        if (event.result !== undefined && event.originalEvent) {
	          event.originalEvent.returnValue = event.result;
	        }
	      }
	    }
	  }
	};

	jQuery.removeEvent = function (elem, type, handle) {
	  // This "if" is needed for plain objects
	  if (elem.removeEventListener) {
	    elem.removeEventListener(type, handle);
	  }
	};

	jQuery.Event = function (src, props) {
	  // Allow instantiation without the 'new' keyword
	  if (!(this instanceof jQuery.Event)) {
	    return new jQuery.Event(src, props);
	  } // Event object


	  if (src && src.type) {
	    this.originalEvent = src;
	    this.type = src.type; // Events bubbling up the document may have been marked as prevented
	    // by a handler lower down the tree; reflect the correct value.

	    this.isDefaultPrevented = src.defaultPrevented || src.defaultPrevented === undefined && // Support: Android <=2.3 only
	    src.returnValue === false ? returnTrue : returnFalse; // Create target properties
	    // Support: Safari <=6 - 7 only
	    // Target should not be a text node (#504, #13143)

	    this.target = src.target && src.target.nodeType === 3 ? src.target.parentNode : src.target;
	    this.currentTarget = src.currentTarget;
	    this.relatedTarget = src.relatedTarget; // Event type
	  } else {
	    this.type = src;
	  } // Put explicitly provided properties onto the event object


	  if (props) {
	    jQuery.extend(this, props);
	  } // Create a timestamp if incoming event doesn't have one


	  this.timeStamp = src && src.timeStamp || Date.now(); // Mark it as fixed

	  this[jQuery.expando] = true;
	}; // jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
	// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html


	jQuery.Event.prototype = {
	  constructor: jQuery.Event,
	  isDefaultPrevented: returnFalse,
	  isPropagationStopped: returnFalse,
	  isImmediatePropagationStopped: returnFalse,
	  isSimulated: false,
	  preventDefault: function preventDefault() {
	    var e = this.originalEvent;
	    this.isDefaultPrevented = returnTrue;

	    if (e && !this.isSimulated) {
	      e.preventDefault();
	    }
	  },
	  stopPropagation: function stopPropagation() {
	    var e = this.originalEvent;
	    this.isPropagationStopped = returnTrue;

	    if (e && !this.isSimulated) {
	      e.stopPropagation();
	    }
	  },
	  stopImmediatePropagation: function stopImmediatePropagation() {
	    var e = this.originalEvent;
	    this.isImmediatePropagationStopped = returnTrue;

	    if (e && !this.isSimulated) {
	      e.stopImmediatePropagation();
	    }

	    this.stopPropagation();
	  }
	}; // Includes all common event props including KeyEvent and MouseEvent specific props

	jQuery.each({
	  altKey: true,
	  bubbles: true,
	  cancelable: true,
	  changedTouches: true,
	  ctrlKey: true,
	  detail: true,
	  eventPhase: true,
	  metaKey: true,
	  pageX: true,
	  pageY: true,
	  shiftKey: true,
	  view: true,
	  "char": true,
	  charCode: true,
	  key: true,
	  keyCode: true,
	  button: true,
	  buttons: true,
	  clientX: true,
	  clientY: true,
	  offsetX: true,
	  offsetY: true,
	  pointerId: true,
	  pointerType: true,
	  screenX: true,
	  screenY: true,
	  targetTouches: true,
	  toElement: true,
	  touches: true,
	  which: function which(event) {
	    var button = event.button; // Add which for key events

	    if (event.which == null && rkeyEvent.test(event.type)) {
	      return event.charCode != null ? event.charCode : event.keyCode;
	    } // Add which for click: 1 === left; 2 === middle; 3 === right


	    if (!event.which && button !== undefined && rmouseEvent.test(event.type)) {
	      if (button & 1) {
	        return 1;
	      }

	      if (button & 2) {
	        return 3;
	      }

	      if (button & 4) {
	        return 2;
	      }

	      return 0;
	    }

	    return event.which;
	  }
	}, jQuery.event.addProp); // Create mouseenter/leave events using mouseover/out and event-time checks
	// so that event delegation works in jQuery.
	// Do the same for pointerenter/pointerleave and pointerover/pointerout
	//
	// Support: Safari 7 only
	// Safari sends mouseenter too often; see:
	// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
	// for the description of the bug (it existed in older Chrome versions as well).

	jQuery.each({
	  mouseenter: "mouseover",
	  mouseleave: "mouseout",
	  pointerenter: "pointerover",
	  pointerleave: "pointerout"
	}, function (orig, fix) {
	  jQuery.event.special[orig] = {
	    delegateType: fix,
	    bindType: fix,
	    handle: function handle(event) {
	      var ret,
	          target = this,
	          related = event.relatedTarget,
	          handleObj = event.handleObj; // For mouseenter/leave call the handler if related is outside the target.
	      // NB: No relatedTarget if the mouse left/entered the browser window

	      if (!related || related !== target && !jQuery.contains(target, related)) {
	        event.type = handleObj.origType;
	        ret = handleObj.handler.apply(this, arguments);
	        event.type = fix;
	      }

	      return ret;
	    }
	  };
	});
	jQuery.fn.extend({
	  on: function on(types, selector, data, fn) {
	    return _on(this, types, selector, data, fn);
	  },
	  one: function one(types, selector, data, fn) {
	    return _on(this, types, selector, data, fn, 1);
	  },
	  off: function off(types, selector, fn) {
	    var handleObj, type;

	    if (types && types.preventDefault && types.handleObj) {
	      // ( event )  dispatched jQuery.Event
	      handleObj = types.handleObj;
	      jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler);
	      return this;
	    }

	    if (_typeof(types) === "object") {
	      // ( types-object [, selector] )
	      for (type in types) {
	        this.off(type, selector, types[type]);
	      }

	      return this;
	    }

	    if (selector === false || typeof selector === "function") {
	      // ( types [, fn] )
	      fn = selector;
	      selector = undefined;
	    }

	    if (fn === false) {
	      fn = returnFalse;
	    }

	    return this.each(function () {
	      jQuery.event.remove(this, types, fn, selector);
	    });
	  }
	});
	var
	/* eslint-disable max-len */
	// See https://github.com/eslint/eslint/issues/3229
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,

	/* eslint-enable */
	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,
	    // checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	    rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g; // Prefer a tbody over its parent table for containing new rows

	function manipulationTarget(elem, content) {
	  if (nodeName(elem, "table") && nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr")) {
	    return jQuery(elem).children("tbody")[0] || elem;
	  }

	  return elem;
	} // Replace/restore the type attribute of script elements for safe DOM manipulation


	function disableScript(elem) {
	  elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type;
	  return elem;
	}

	function restoreScript(elem) {
	  if ((elem.type || "").slice(0, 5) === "true/") {
	    elem.type = elem.type.slice(5);
	  } else {
	    elem.removeAttribute("type");
	  }

	  return elem;
	}

	function cloneCopyEvent(src, dest) {
	  var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

	  if (dest.nodeType !== 1) {
	    return;
	  } // 1. Copy private data: events, handlers, etc.


	  if (dataPriv.hasData(src)) {
	    pdataOld = dataPriv.access(src);
	    pdataCur = dataPriv.set(dest, pdataOld);
	    events = pdataOld.events;

	    if (events) {
	      delete pdataCur.handle;
	      pdataCur.events = {};

	      for (type in events) {
	        for (i = 0, l = events[type].length; i < l; i++) {
	          jQuery.event.add(dest, type, events[type][i]);
	        }
	      }
	    }
	  } // 2. Copy user data


	  if (dataUser.hasData(src)) {
	    udataOld = dataUser.access(src);
	    udataCur = jQuery.extend({}, udataOld);
	    dataUser.set(dest, udataCur);
	  }
	} // Fix IE bugs, see support tests


	function fixInput(src, dest) {
	  var nodeName = dest.nodeName.toLowerCase(); // Fails to persist the checked state of a cloned checkbox or radio button.

	  if (nodeName === "input" && rcheckableType.test(src.type)) {
	    dest.checked = src.checked; // Fails to return the selected option to the default selected state when cloning options
	  } else if (nodeName === "input" || nodeName === "textarea") {
	    dest.defaultValue = src.defaultValue;
	  }
	}

	function domManip(collection, args, callback, ignored) {
	  // Flatten any nested arrays
	  args = concat.apply([], args);
	  var fragment,
	      first,
	      scripts,
	      hasScripts,
	      node,
	      doc,
	      i = 0,
	      l = collection.length,
	      iNoClone = l - 1,
	      value = args[0],
	      valueIsFunction = isFunction(value); // We can't cloneNode fragments that contain checked, in WebKit

	  if (valueIsFunction || l > 1 && typeof value === "string" && !support.checkClone && rchecked.test(value)) {
	    return collection.each(function (index) {
	      var self = collection.eq(index);

	      if (valueIsFunction) {
	        args[0] = value.call(this, index, self.html());
	      }

	      domManip(self, args, callback, ignored);
	    });
	  }

	  if (l) {
	    fragment = buildFragment(args, collection[0].ownerDocument, false, collection, ignored);
	    first = fragment.firstChild;

	    if (fragment.childNodes.length === 1) {
	      fragment = first;
	    } // Require either new content or an interest in ignored elements to invoke the callback


	    if (first || ignored) {
	      scripts = jQuery.map(getAll(fragment, "script"), disableScript);
	      hasScripts = scripts.length; // Use the original fragment for the last item
	      // instead of the first because it can end up
	      // being emptied incorrectly in certain situations (#8070).

	      for (; i < l; i++) {
	        node = fragment;

	        if (i !== iNoClone) {
	          node = jQuery.clone(node, true, true); // Keep references to cloned scripts for later restoration

	          if (hasScripts) {
	            // Support: Android <=4.0 only, PhantomJS 1 only
	            // push.apply(_, arraylike) throws on ancient WebKit
	            jQuery.merge(scripts, getAll(node, "script"));
	          }
	        }

	        callback.call(collection[i], node, i);
	      }

	      if (hasScripts) {
	        doc = scripts[scripts.length - 1].ownerDocument; // Reenable scripts

	        jQuery.map(scripts, restoreScript); // Evaluate executable scripts on first document insertion

	        for (i = 0; i < hasScripts; i++) {
	          node = scripts[i];

	          if (rscriptType.test(node.type || "") && !dataPriv.access(node, "globalEval") && jQuery.contains(doc, node)) {
	            if (node.src && (node.type || "").toLowerCase() !== "module") {
	              // Optional AJAX dependency, but won't run scripts if not present
	              if (jQuery._evalUrl) {
	                jQuery._evalUrl(node.src);
	              }
	            } else {
	              DOMEval(node.textContent.replace(rcleanScript, ""), doc, node);
	            }
	          }
	        }
	      }
	    }
	  }

	  return collection;
	}

	function _remove(elem, selector, keepData) {
	  var node,
	      nodes = selector ? jQuery.filter(selector, elem) : elem,
	      i = 0;

	  for (; (node = nodes[i]) != null; i++) {
	    if (!keepData && node.nodeType === 1) {
	      jQuery.cleanData(getAll(node));
	    }

	    if (node.parentNode) {
	      if (keepData && jQuery.contains(node.ownerDocument, node)) {
	        setGlobalEval(getAll(node, "script"));
	      }

	      node.parentNode.removeChild(node);
	    }
	  }

	  return elem;
	}

	jQuery.extend({
	  htmlPrefilter: function htmlPrefilter(html) {
	    return html.replace(rxhtmlTag, "<$1></$2>");
	  },
	  clone: function clone(elem, dataAndEvents, deepDataAndEvents) {
	    var i,
	        l,
	        srcElements,
	        destElements,
	        clone = elem.cloneNode(true),
	        inPage = jQuery.contains(elem.ownerDocument, elem); // Fix IE cloning issues

	    if (!support.noCloneChecked && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem)) {
	      // We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
	      destElements = getAll(clone);
	      srcElements = getAll(elem);

	      for (i = 0, l = srcElements.length; i < l; i++) {
	        fixInput(srcElements[i], destElements[i]);
	      }
	    } // Copy the events from the original to the clone


	    if (dataAndEvents) {
	      if (deepDataAndEvents) {
	        srcElements = srcElements || getAll(elem);
	        destElements = destElements || getAll(clone);

	        for (i = 0, l = srcElements.length; i < l; i++) {
	          cloneCopyEvent(srcElements[i], destElements[i]);
	        }
	      } else {
	        cloneCopyEvent(elem, clone);
	      }
	    } // Preserve script evaluation history


	    destElements = getAll(clone, "script");

	    if (destElements.length > 0) {
	      setGlobalEval(destElements, !inPage && getAll(elem, "script"));
	    } // Return the cloned set


	    return clone;
	  },
	  cleanData: function cleanData(elems) {
	    var data,
	        elem,
	        type,
	        special = jQuery.event.special,
	        i = 0;

	    for (; (elem = elems[i]) !== undefined; i++) {
	      if (acceptData(elem)) {
	        if (data = elem[dataPriv.expando]) {
	          if (data.events) {
	            for (type in data.events) {
	              if (special[type]) {
	                jQuery.event.remove(elem, type); // This is a shortcut to avoid jQuery.event.remove's overhead
	              } else {
	                jQuery.removeEvent(elem, type, data.handle);
	              }
	            }
	          } // Support: Chrome <=35 - 45+
	          // Assign undefined instead of using delete, see Data#remove


	          elem[dataPriv.expando] = undefined;
	        }

	        if (elem[dataUser.expando]) {
	          // Support: Chrome <=35 - 45+
	          // Assign undefined instead of using delete, see Data#remove
	          elem[dataUser.expando] = undefined;
	        }
	      }
	    }
	  }
	});
	jQuery.fn.extend({
	  detach: function detach(selector) {
	    return _remove(this, selector, true);
	  },
	  remove: function remove(selector) {
	    return _remove(this, selector);
	  },
	  text: function text(value) {
	    return access(this, function (value) {
	      return value === undefined ? jQuery.text(this) : this.empty().each(function () {
	        if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
	          this.textContent = value;
	        }
	      });
	    }, null, value, arguments.length);
	  },
	  append: function append() {
	    return domManip(this, arguments, function (elem) {
	      if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
	        var target = manipulationTarget(this, elem);
	        target.appendChild(elem);
	      }
	    });
	  },
	  prepend: function prepend() {
	    return domManip(this, arguments, function (elem) {
	      if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
	        var target = manipulationTarget(this, elem);
	        target.insertBefore(elem, target.firstChild);
	      }
	    });
	  },
	  before: function before() {
	    return domManip(this, arguments, function (elem) {
	      if (this.parentNode) {
	        this.parentNode.insertBefore(elem, this);
	      }
	    });
	  },
	  after: function after() {
	    return domManip(this, arguments, function (elem) {
	      if (this.parentNode) {
	        this.parentNode.insertBefore(elem, this.nextSibling);
	      }
	    });
	  },
	  empty: function empty() {
	    var elem,
	        i = 0;

	    for (; (elem = this[i]) != null; i++) {
	      if (elem.nodeType === 1) {
	        // Prevent memory leaks
	        jQuery.cleanData(getAll(elem, false)); // Remove any remaining nodes

	        elem.textContent = "";
	      }
	    }

	    return this;
	  },
	  clone: function clone(dataAndEvents, deepDataAndEvents) {
	    dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
	    deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;
	    return this.map(function () {
	      return jQuery.clone(this, dataAndEvents, deepDataAndEvents);
	    });
	  },
	  html: function html(value) {
	    return access(this, function (value) {
	      var elem = this[0] || {},
	          i = 0,
	          l = this.length;

	      if (value === undefined && elem.nodeType === 1) {
	        return elem.innerHTML;
	      } // See if we can take a shortcut and just use innerHTML


	      if (typeof value === "string" && !rnoInnerhtml.test(value) && !wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {
	        value = jQuery.htmlPrefilter(value);

	        try {
	          for (; i < l; i++) {
	            elem = this[i] || {}; // Remove element nodes and prevent memory leaks

	            if (elem.nodeType === 1) {
	              jQuery.cleanData(getAll(elem, false));
	              elem.innerHTML = value;
	            }
	          }

	          elem = 0; // If using innerHTML throws an exception, use the fallback method
	        } catch (e) {}
	      }

	      if (elem) {
	        this.empty().append(value);
	      }
	    }, null, value, arguments.length);
	  },
	  replaceWith: function replaceWith() {
	    var ignored = []; // Make the changes, replacing each non-ignored context element with the new content

	    return domManip(this, arguments, function (elem) {
	      var parent = this.parentNode;

	      if (jQuery.inArray(this, ignored) < 0) {
	        jQuery.cleanData(getAll(this));

	        if (parent) {
	          parent.replaceChild(elem, this);
	        }
	      } // Force callback invocation

	    }, ignored);
	  }
	});
	jQuery.each({
	  appendTo: "append",
	  prependTo: "prepend",
	  insertBefore: "before",
	  insertAfter: "after",
	  replaceAll: "replaceWith"
	}, function (name, original) {
	  jQuery.fn[name] = function (selector) {
	    var elems,
	        ret = [],
	        insert = jQuery(selector),
	        last = insert.length - 1,
	        i = 0;

	    for (; i <= last; i++) {
	      elems = i === last ? this : this.clone(true);
	      jQuery(insert[i])[original](elems); // Support: Android <=4.0 only, PhantomJS 1 only
	      // .get() because push.apply(_, arraylike) throws on ancient WebKit

	      push$1.apply(ret, elems.get());
	    }

	    return this.pushStack(ret);
	  };
	});
	var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");

	var getStyles = function getStyles(elem) {
	  // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
	  // IE throws on elements created in popups
	  // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
	  var view = elem.ownerDocument.defaultView;

	  if (!view || !view.opener) {
	    view = window;
	  }

	  return view.getComputedStyle(elem);
	};

	var rboxStyle = new RegExp(cssExpand.join("|"), "i");

	(function () {
	  // Executing both pixelPosition & boxSizingReliable tests require only one layout
	  // so they're executed at the same time to save the second computation.
	  function computeStyleTests() {
	    // This is a singleton, we need to execute it only once
	    if (!div) {
	      return;
	    }

	    container.style.cssText = "position:absolute;left:-11111px;width:60px;" + "margin-top:1px;padding:0;border:0";
	    div.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;" + "margin:auto;border:1px;padding:1px;" + "width:60%;top:1%";
	    documentElement.appendChild(container).appendChild(div);
	    var divStyle = window.getComputedStyle(div);
	    pixelPositionVal = divStyle.top !== "1%"; // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44

	    reliableMarginLeftVal = roundPixelMeasures(divStyle.marginLeft) === 12; // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
	    // Some styles come back with percentage values, even though they shouldn't

	    div.style.right = "60%";
	    pixelBoxStylesVal = roundPixelMeasures(divStyle.right) === 36; // Support: IE 9 - 11 only
	    // Detect misreporting of content dimensions for box-sizing:border-box elements

	    boxSizingReliableVal = roundPixelMeasures(divStyle.width) === 36; // Support: IE 9 only
	    // Detect overflow:scroll screwiness (gh-3699)

	    div.style.position = "absolute";
	    scrollboxSizeVal = div.offsetWidth === 36 || "absolute";
	    documentElement.removeChild(container); // Nullify the div so it wouldn't be stored in the memory and
	    // it will also be a sign that checks already performed

	    div = null;
	  }

	  function roundPixelMeasures(measure) {
	    return Math.round(parseFloat(measure));
	  }

	  var pixelPositionVal,
	      boxSizingReliableVal,
	      scrollboxSizeVal,
	      pixelBoxStylesVal,
	      reliableMarginLeftVal,
	      container = document$2.createElement("div"),
	      div = document$2.createElement("div"); // Finish early in limited (non-browser) environments

	  if (!div.style) {
	    return;
	  } // Support: IE <=9 - 11 only
	  // Style of cloned element affects source element cloned (#8908)


	  div.style.backgroundClip = "content-box";
	  div.cloneNode(true).style.backgroundClip = "";
	  support.clearCloneStyle = div.style.backgroundClip === "content-box";
	  jQuery.extend(support, {
	    boxSizingReliable: function boxSizingReliable() {
	      computeStyleTests();
	      return boxSizingReliableVal;
	    },
	    pixelBoxStyles: function pixelBoxStyles() {
	      computeStyleTests();
	      return pixelBoxStylesVal;
	    },
	    pixelPosition: function pixelPosition() {
	      computeStyleTests();
	      return pixelPositionVal;
	    },
	    reliableMarginLeft: function reliableMarginLeft() {
	      computeStyleTests();
	      return reliableMarginLeftVal;
	    },
	    scrollboxSize: function scrollboxSize() {
	      computeStyleTests();
	      return scrollboxSizeVal;
	    }
	  });
	})();

	function curCSS(elem, name, computed) {
	  var width,
	      minWidth,
	      maxWidth,
	      ret,
	      // Support: Firefox 51+
	  // Retrieving style before computed somehow
	  // fixes an issue with getting wrong values
	  // on detached elements
	  style = elem.style;
	  computed = computed || getStyles(elem); // getPropertyValue is needed for:
	  //   .css('filter') (IE 9 only, #12537)
	  //   .css('--customProperty) (#3144)

	  if (computed) {
	    ret = computed.getPropertyValue(name) || computed[name];

	    if (ret === "" && !jQuery.contains(elem.ownerDocument, elem)) {
	      ret = jQuery.style(elem, name);
	    } // A tribute to the "awesome hack by Dean Edwards"
	    // Android Browser returns percentage for some values,
	    // but width seems to be reliably pixels.
	    // This is against the CSSOM draft spec:
	    // https://drafts.csswg.org/cssom/#resolved-values


	    if (!support.pixelBoxStyles() && rnumnonpx.test(ret) && rboxStyle.test(name)) {
	      // Remember the original values
	      width = style.width;
	      minWidth = style.minWidth;
	      maxWidth = style.maxWidth; // Put in the new values to get a computed value out

	      style.minWidth = style.maxWidth = style.width = ret;
	      ret = computed.width; // Revert the changed values

	      style.width = width;
	      style.minWidth = minWidth;
	      style.maxWidth = maxWidth;
	    }
	  }

	  return ret !== undefined ? // Support: IE <=9 - 11 only
	  // IE returns zIndex value as an integer.
	  ret + "" : ret;
	}

	function addGetHookIf(conditionFn, hookFn) {
	  // Define the hook, we'll check on the first run if it's really needed.
	  return {
	    get: function get() {
	      if (conditionFn()) {
	        // Hook not needed (or it's not possible to use it due
	        // to missing dependency), remove it.
	        delete this.get;
	        return;
	      } // Hook needed; redefine it so that the support test is not executed again.


	      return (this.get = hookFn).apply(this, arguments);
	    }
	  };
	}

	var // Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	    rcustomProp = /^--/,
	    cssShow = {
	  position: "absolute",
	  visibility: "hidden",
	  display: "block"
	},
	    cssNormalTransform = {
	  letterSpacing: "0",
	  fontWeight: "400"
	},
	    cssPrefixes = ["Webkit", "Moz", "ms"],
	    emptyStyle = document$2.createElement("div").style; // Return a css property mapped to a potentially vendor prefixed property

	function vendorPropName(name) {
	  // Shortcut for names that are not vendor prefixed
	  if (name in emptyStyle) {
	    return name;
	  } // Check for vendor prefixed names


	  var capName = name[0].toUpperCase() + name.slice(1),
	      i = cssPrefixes.length;

	  while (i--) {
	    name = cssPrefixes[i] + capName;

	    if (name in emptyStyle) {
	      return name;
	    }
	  }
	} // Return a property mapped along what jQuery.cssProps suggests or to
	// a vendor prefixed property.


	function finalPropName(name) {
	  var ret = jQuery.cssProps[name];

	  if (!ret) {
	    ret = jQuery.cssProps[name] = vendorPropName(name) || name;
	  }

	  return ret;
	}

	function setPositiveNumber(elem, value, subtract) {
	  // Any relative (+/-) values have already been
	  // normalized at this point
	  var matches = rcssNum.exec(value);
	  return matches ? // Guard against undefined "subtract", e.g., when used as in cssHooks
	  Math.max(0, matches[2] - (subtract || 0)) + (matches[3] || "px") : value;
	}

	function boxModelAdjustment(elem, dimension, box, isBorderBox, styles, computedVal) {
	  var i = dimension === "width" ? 1 : 0,
	      extra = 0,
	      delta = 0; // Adjustment may not be necessary

	  if (box === (isBorderBox ? "border" : "content")) {
	    return 0;
	  }

	  for (; i < 4; i += 2) {
	    // Both box models exclude margin
	    if (box === "margin") {
	      delta += jQuery.css(elem, box + cssExpand[i], true, styles);
	    } // If we get here with a content-box, we're seeking "padding" or "border" or "margin"


	    if (!isBorderBox) {
	      // Add padding
	      delta += jQuery.css(elem, "padding" + cssExpand[i], true, styles); // For "border" or "margin", add border

	      if (box !== "padding") {
	        delta += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles); // But still keep track of it otherwise
	      } else {
	        extra += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
	      } // If we get here with a border-box (content + padding + border), we're seeking "content" or
	      // "padding" or "margin"

	    } else {
	      // For "content", subtract padding
	      if (box === "content") {
	        delta -= jQuery.css(elem, "padding" + cssExpand[i], true, styles);
	      } // For "content" or "padding", subtract border


	      if (box !== "margin") {
	        delta -= jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
	      }
	    }
	  } // Account for positive content-box scroll gutter when requested by providing computedVal


	  if (!isBorderBox && computedVal >= 0) {
	    // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
	    // Assuming integer scroll gutter, subtract the rest and round down
	    delta += Math.max(0, Math.ceil(elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - computedVal - delta - extra - 0.5));
	  }

	  return delta;
	}

	function getWidthOrHeight(elem, dimension, extra) {
	  // Start with computed style
	  var styles = getStyles(elem),
	      val = curCSS(elem, dimension, styles),
	      isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box",
	      valueIsBorderBox = isBorderBox; // Support: Firefox <=54
	  // Return a confounding non-pixel value or feign ignorance, as appropriate.

	  if (rnumnonpx.test(val)) {
	    if (!extra) {
	      return val;
	    }

	    val = "auto";
	  } // Check for style in case a browser which returns unreliable values
	  // for getComputedStyle silently falls back to the reliable elem.style


	  valueIsBorderBox = valueIsBorderBox && (support.boxSizingReliable() || val === elem.style[dimension]); // Fall back to offsetWidth/offsetHeight when value is "auto"
	  // This happens for inline elements with no explicit setting (gh-3571)
	  // Support: Android <=4.1 - 4.3 only
	  // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)

	  if (val === "auto" || !parseFloat(val) && jQuery.css(elem, "display", false, styles) === "inline") {
	    val = elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)]; // offsetWidth/offsetHeight provide border-box values

	    valueIsBorderBox = true;
	  } // Normalize "" and auto


	  val = parseFloat(val) || 0; // Adjust for the element's box model

	  return val + boxModelAdjustment(elem, dimension, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles, // Provide the current computed size to request scroll gutter calculation (gh-3589)
	  val) + "px";
	}

	jQuery.extend({
	  // Add in style property hooks for overriding the default
	  // behavior of getting and setting a style property
	  cssHooks: {
	    opacity: {
	      get: function get(elem, computed) {
	        if (computed) {
	          // We should always get a number back from opacity
	          var ret = curCSS(elem, "opacity");
	          return ret === "" ? "1" : ret;
	        }
	      }
	    }
	  },
	  // Don't automatically add "px" to these possibly-unitless properties
	  cssNumber: {
	    "animationIterationCount": true,
	    "columnCount": true,
	    "fillOpacity": true,
	    "flexGrow": true,
	    "flexShrink": true,
	    "fontWeight": true,
	    "lineHeight": true,
	    "opacity": true,
	    "order": true,
	    "orphans": true,
	    "widows": true,
	    "zIndex": true,
	    "zoom": true
	  },
	  // Add in properties whose names you wish to fix before
	  // setting or getting the value
	  cssProps: {},
	  // Get and set the style property on a DOM Node
	  style: function style(elem, name, value, extra) {
	    // Don't set styles on text and comment nodes
	    if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
	      return;
	    } // Make sure that we're working with the right name


	    var ret,
	        type,
	        hooks,
	        origName = camelCase(name),
	        isCustomProp = rcustomProp.test(name),
	        style = elem.style; // Make sure that we're working with the right name. We don't
	    // want to query the value if it is a CSS custom property
	    // since they are user-defined.

	    if (!isCustomProp) {
	      name = finalPropName(origName);
	    } // Gets hook for the prefixed version, then unprefixed version


	    hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName]; // Check if we're setting a value

	    if (value !== undefined) {
	      type = _typeof(value); // Convert "+=" or "-=" to relative numbers (#7345)

	      if (type === "string" && (ret = rcssNum.exec(value)) && ret[1]) {
	        value = adjustCSS(elem, name, ret); // Fixes bug #9237

	        type = "number";
	      } // Make sure that null and NaN values aren't set (#7116)


	      if (value == null || value !== value) {
	        return;
	      } // If a number was passed in, add the unit (except for certain CSS properties)


	      if (type === "number") {
	        value += ret && ret[3] || (jQuery.cssNumber[origName] ? "" : "px");
	      } // background-* props affect original clone's values


	      if (!support.clearCloneStyle && value === "" && name.indexOf("background") === 0) {
	        style[name] = "inherit";
	      } // If a hook was provided, use that value, otherwise just set the specified value


	      if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
	        if (isCustomProp) {
	          style.setProperty(name, value);
	        } else {
	          style[name] = value;
	        }
	      }
	    } else {
	      // If a hook was provided get the non-computed value from there
	      if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
	        return ret;
	      } // Otherwise just get the value from the style object


	      return style[name];
	    }
	  },
	  css: function css(elem, name, extra, styles) {
	    var val,
	        num,
	        hooks,
	        origName = camelCase(name),
	        isCustomProp = rcustomProp.test(name); // Make sure that we're working with the right name. We don't
	    // want to modify the value if it is a CSS custom property
	    // since they are user-defined.

	    if (!isCustomProp) {
	      name = finalPropName(origName);
	    } // Try prefixed name followed by the unprefixed name


	    hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName]; // If a hook was provided get the computed value from there

	    if (hooks && "get" in hooks) {
	      val = hooks.get(elem, true, extra);
	    } // Otherwise, if a way to get the computed value exists, use that


	    if (val === undefined) {
	      val = curCSS(elem, name, styles);
	    } // Convert "normal" to computed value


	    if (val === "normal" && name in cssNormalTransform) {
	      val = cssNormalTransform[name];
	    } // Make numeric if forced or a qualifier was provided and val looks numeric


	    if (extra === "" || extra) {
	      num = parseFloat(val);
	      return extra === true || isFinite(num) ? num || 0 : val;
	    }

	    return val;
	  }
	});
	jQuery.each(["height", "width"], function (i, dimension) {
	  jQuery.cssHooks[dimension] = {
	    get: function get(elem, computed, extra) {
	      if (computed) {
	        // Certain elements can have dimension info if we invisibly show them
	        // but it must have a current display style that would benefit
	        return rdisplayswap.test(jQuery.css(elem, "display")) && ( // Support: Safari 8+
	        // Table columns in Safari have non-zero offsetWidth & zero
	        // getBoundingClientRect().width unless display is changed.
	        // Support: IE <=11 only
	        // Running getBoundingClientRect on a disconnected node
	        // in IE throws an error.
	        !elem.getClientRects().length || !elem.getBoundingClientRect().width) ? swap(elem, cssShow, function () {
	          return getWidthOrHeight(elem, dimension, extra);
	        }) : getWidthOrHeight(elem, dimension, extra);
	      }
	    },
	    set: function set(elem, value, extra) {
	      var matches,
	          styles = getStyles(elem),
	          isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box",
	          subtract = extra && boxModelAdjustment(elem, dimension, extra, isBorderBox, styles); // Account for unreliable border-box dimensions by comparing offset* to computed and
	      // faking a content-box to get border and padding (gh-3699)

	      if (isBorderBox && support.scrollboxSize() === styles.position) {
	        subtract -= Math.ceil(elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - parseFloat(styles[dimension]) - boxModelAdjustment(elem, dimension, "border", false, styles) - 0.5);
	      } // Convert to pixels if value adjustment is needed


	      if (subtract && (matches = rcssNum.exec(value)) && (matches[3] || "px") !== "px") {
	        elem.style[dimension] = value;
	        value = jQuery.css(elem, dimension);
	      }

	      return setPositiveNumber(elem, value, subtract);
	    }
	  };
	});
	jQuery.cssHooks.marginLeft = addGetHookIf(support.reliableMarginLeft, function (elem, computed) {
	  if (computed) {
	    return (parseFloat(curCSS(elem, "marginLeft")) || elem.getBoundingClientRect().left - swap(elem, {
	      marginLeft: 0
	    }, function () {
	      return elem.getBoundingClientRect().left;
	    })) + "px";
	  }
	}); // These hooks are used by animate to expand properties

	jQuery.each({
	  margin: "",
	  padding: "",
	  border: "Width"
	}, function (prefix, suffix) {
	  jQuery.cssHooks[prefix + suffix] = {
	    expand: function expand(value) {
	      var i = 0,
	          expanded = {},
	          // Assumes a single number if not a string
	      parts = typeof value === "string" ? value.split(" ") : [value];

	      for (; i < 4; i++) {
	        expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
	      }

	      return expanded;
	    }
	  };

	  if (prefix !== "margin") {
	    jQuery.cssHooks[prefix + suffix].set = setPositiveNumber;
	  }
	});
	jQuery.fn.extend({
	  css: function css(name, value) {
	    return access(this, function (elem, name, value) {
	      var styles,
	          len,
	          map = {},
	          i = 0;

	      if (Array.isArray(name)) {
	        styles = getStyles(elem);
	        len = name.length;

	        for (; i < len; i++) {
	          map[name[i]] = jQuery.css(elem, name[i], false, styles);
	        }

	        return map;
	      }

	      return value !== undefined ? jQuery.style(elem, name, value) : jQuery.css(elem, name);
	    }, name, value, arguments.length > 1);
	  }
	}); // Based off of the plugin by Clint Helfers, with permission.
	// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/

	jQuery.fn.delay = function (time, type) {
	  time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
	  type = type || "fx";
	  return this.queue(type, function (next, hooks) {
	    var timeout = window.setTimeout(next, time);

	    hooks.stop = function () {
	      window.clearTimeout(timeout);
	    };
	  });
	};

	(function () {
	  var input = document$2.createElement("input"),
	      select = document$2.createElement("select"),
	      opt = select.appendChild(document$2.createElement("option"));
	  input.type = "checkbox"; // Support: Android <=4.3 only
	  // Default value for a checkbox should be "on"

	  support.checkOn = input.value !== ""; // Support: IE <=11 only
	  // Must access selectedIndex to make default options select

	  support.optSelected = opt.selected; // Support: IE <=11 only
	  // An input loses its value after becoming a radio

	  input = document$2.createElement("input");
	  input.value = "t";
	  input.type = "radio";
	  support.radioValue = input.value === "t";
	})();

	var boolHook,
	    attrHandle = jQuery.expr.attrHandle;
	jQuery.fn.extend({
	  attr: function attr(name, value) {
	    return access(this, jQuery.attr, name, value, arguments.length > 1);
	  },
	  removeAttr: function removeAttr(name) {
	    return this.each(function () {
	      jQuery.removeAttr(this, name);
	    });
	  }
	});
	jQuery.extend({
	  attr: function attr(elem, name, value) {
	    var ret,
	        hooks,
	        nType = elem.nodeType; // Don't get/set attributes on text, comment and attribute nodes

	    if (nType === 3 || nType === 8 || nType === 2) {
	      return;
	    } // Fallback to prop when attributes are not supported


	    if (typeof elem.getAttribute === "undefined") {
	      return jQuery.prop(elem, name, value);
	    } // Attribute hooks are determined by the lowercase version
	    // Grab necessary hook if one is defined


	    if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
	      hooks = jQuery.attrHooks[name.toLowerCase()] || (jQuery.expr.match.bool.test(name) ? boolHook : undefined);
	    }

	    if (value !== undefined) {
	      if (value === null) {
	        jQuery.removeAttr(elem, name);
	        return;
	      }

	      if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
	        return ret;
	      }

	      elem.setAttribute(name, value + "");
	      return value;
	    }

	    if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
	      return ret;
	    }

	    ret = jQuery.find.attr(elem, name); // Non-existent attributes return null, we normalize to undefined

	    return ret == null ? undefined : ret;
	  },
	  attrHooks: {
	    type: {
	      set: function set(elem, value) {
	        if (!support.radioValue && value === "radio" && nodeName(elem, "input")) {
	          var val = elem.value;
	          elem.setAttribute("type", value);

	          if (val) {
	            elem.value = val;
	          }

	          return value;
	        }
	      }
	    }
	  },
	  removeAttr: function removeAttr(elem, value) {
	    var name,
	        i = 0,
	        // Attribute names can contain non-HTML whitespace characters
	    // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
	    attrNames = value && value.match(rnothtmlwhite);

	    if (attrNames && elem.nodeType === 1) {
	      while (name = attrNames[i++]) {
	        elem.removeAttribute(name);
	      }
	    }
	  }
	}); // Hooks for boolean attributes

	boolHook = {
	  set: function set(elem, value, name) {
	    if (value === false) {
	      // Remove boolean attributes when set to false
	      jQuery.removeAttr(elem, name);
	    } else {
	      elem.setAttribute(name, name);
	    }

	    return name;
	  }
	};
	jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function (i, name) {
	  var getter = attrHandle[name] || jQuery.find.attr;

	  attrHandle[name] = function (elem, name, isXML) {
	    var ret,
	        handle,
	        lowercaseName = name.toLowerCase();

	    if (!isXML) {
	      // Avoid an infinite loop by temporarily removing this function from the getter
	      handle = attrHandle[lowercaseName];
	      attrHandle[lowercaseName] = ret;
	      ret = getter(elem, name, isXML) != null ? lowercaseName : null;
	      attrHandle[lowercaseName] = handle;
	    }

	    return ret;
	  };
	});
	var rfocusable = /^(?:input|select|textarea|button)$/i,
	    rclickable = /^(?:a|area)$/i;
	jQuery.fn.extend({
	  prop: function prop(name, value) {
	    return access(this, jQuery.prop, name, value, arguments.length > 1);
	  },
	  removeProp: function removeProp(name) {
	    return this.each(function () {
	      delete this[jQuery.propFix[name] || name];
	    });
	  }
	});
	jQuery.extend({
	  prop: function prop(elem, name, value) {
	    var ret,
	        hooks,
	        nType = elem.nodeType; // Don't get/set properties on text, comment and attribute nodes

	    if (nType === 3 || nType === 8 || nType === 2) {
	      return;
	    }

	    if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
	      // Fix name and attach hooks
	      name = jQuery.propFix[name] || name;
	      hooks = jQuery.propHooks[name];
	    }

	    if (value !== undefined) {
	      if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
	        return ret;
	      }

	      return elem[name] = value;
	    }

	    if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
	      return ret;
	    }

	    return elem[name];
	  },
	  propHooks: {
	    tabIndex: {
	      get: function get(elem) {
	        // Support: IE <=9 - 11 only
	        // elem.tabIndex doesn't always return the
	        // correct value when it hasn't been explicitly set
	        // https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
	        // Use proper attribute retrieval(#12072)
	        var tabindex = jQuery.find.attr(elem, "tabindex");

	        if (tabindex) {
	          return parseInt(tabindex, 10);
	        }

	        if (rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href) {
	          return 0;
	        }

	        return -1;
	      }
	    }
	  },
	  propFix: {
	    "for": "htmlFor",
	    "class": "className"
	  }
	}); // Support: IE <=11 only
	// Accessing the selectedIndex property
	// forces the browser to respect setting selected
	// on the option
	// The getter ensures a default option is selected
	// when in an optgroup
	// eslint rule "no-unused-expressions" is disabled for this code
	// since it considers such accessions noop

	if (!support.optSelected) {
	  jQuery.propHooks.selected = {
	    get: function get(elem) {
	      /* eslint no-unused-expressions: "off" */
	      var parent = elem.parentNode;

	      if (parent && parent.parentNode) {
	        parent.parentNode.selectedIndex;
	      }

	      return null;
	    },
	    set: function set(elem) {
	      /* eslint no-unused-expressions: "off" */
	      var parent = elem.parentNode;

	      if (parent) {
	        parent.selectedIndex;

	        if (parent.parentNode) {
	          parent.parentNode.selectedIndex;
	        }
	      }
	    }
	  };
	}

	jQuery.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function () {
	  jQuery.propFix[this.toLowerCase()] = this;
	}); // Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace

	function stripAndCollapse(value) {
	  var tokens = value.match(rnothtmlwhite) || [];
	  return tokens.join(" ");
	}

	function getClass(elem) {
	  return elem.getAttribute && elem.getAttribute("class") || "";
	}

	function classesToArray(value) {
	  if (Array.isArray(value)) {
	    return value;
	  }

	  if (typeof value === "string") {
	    return value.match(rnothtmlwhite) || [];
	  }

	  return [];
	}

	jQuery.fn.extend({
	  addClass: function addClass(value) {
	    var classes,
	        elem,
	        cur,
	        curValue,
	        clazz,
	        j,
	        finalValue,
	        i = 0;

	    if (isFunction(value)) {
	      return this.each(function (j) {
	        jQuery(this).addClass(value.call(this, j, getClass(this)));
	      });
	    }

	    classes = classesToArray(value);

	    if (classes.length) {
	      while (elem = this[i++]) {
	        curValue = getClass(elem);
	        cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) + " ";

	        if (cur) {
	          j = 0;

	          while (clazz = classes[j++]) {
	            if (cur.indexOf(" " + clazz + " ") < 0) {
	              cur += clazz + " ";
	            }
	          } // Only assign if different to avoid unneeded rendering.


	          finalValue = stripAndCollapse(cur);

	          if (curValue !== finalValue) {
	            elem.setAttribute("class", finalValue);
	          }
	        }
	      }
	    }

	    return this;
	  },
	  removeClass: function removeClass(value) {
	    var classes,
	        elem,
	        cur,
	        curValue,
	        clazz,
	        j,
	        finalValue,
	        i = 0;

	    if (isFunction(value)) {
	      return this.each(function (j) {
	        jQuery(this).removeClass(value.call(this, j, getClass(this)));
	      });
	    }

	    if (!arguments.length) {
	      return this.attr("class", "");
	    }

	    classes = classesToArray(value);

	    if (classes.length) {
	      while (elem = this[i++]) {
	        curValue = getClass(elem); // This expression is here for better compressibility (see addClass)

	        cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) + " ";

	        if (cur) {
	          j = 0;

	          while (clazz = classes[j++]) {
	            // Remove *all* instances
	            while (cur.indexOf(" " + clazz + " ") > -1) {
	              cur = cur.replace(" " + clazz + " ", " ");
	            }
	          } // Only assign if different to avoid unneeded rendering.


	          finalValue = stripAndCollapse(cur);

	          if (curValue !== finalValue) {
	            elem.setAttribute("class", finalValue);
	          }
	        }
	      }
	    }

	    return this;
	  },
	  toggleClass: function toggleClass(value, stateVal) {
	    var type = _typeof(value),
	        isValidValue = type === "string" || Array.isArray(value);

	    if (typeof stateVal === "boolean" && isValidValue) {
	      return stateVal ? this.addClass(value) : this.removeClass(value);
	    }

	    if (isFunction(value)) {
	      return this.each(function (i) {
	        jQuery(this).toggleClass(value.call(this, i, getClass(this), stateVal), stateVal);
	      });
	    }

	    return this.each(function () {
	      var className, i, self, classNames;

	      if (isValidValue) {
	        // Toggle individual class names
	        i = 0;
	        self = jQuery(this);
	        classNames = classesToArray(value);

	        while (className = classNames[i++]) {
	          // Check each className given, space separated list
	          if (self.hasClass(className)) {
	            self.removeClass(className);
	          } else {
	            self.addClass(className);
	          }
	        } // Toggle whole class name

	      } else if (value === undefined || type === "boolean") {
	        className = getClass(this);

	        if (className) {
	          // Store className if set
	          dataPriv.set(this, "__className__", className);
	        } // If the element has a class name or if we're passed `false`,
	        // then remove the whole classname (if there was one, the above saved it).
	        // Otherwise bring back whatever was previously saved (if anything),
	        // falling back to the empty string if nothing was stored.


	        if (this.setAttribute) {
	          this.setAttribute("class", className || value === false ? "" : dataPriv.get(this, "__className__") || "");
	        }
	      }
	    });
	  },
	  hasClass: function hasClass(selector) {
	    var className,
	        elem,
	        i = 0;
	    className = " " + selector + " ";

	    while (elem = this[i++]) {
	      if (elem.nodeType === 1 && (" " + stripAndCollapse(getClass(elem)) + " ").indexOf(className) > -1) {
	        return true;
	      }
	    }

	    return false;
	  }
	});
	var rreturn = /\r/g;
	jQuery.fn.extend({
	  val: function val(value) {
	    var hooks,
	        ret,
	        valueIsFunction,
	        elem = this[0];

	    if (!arguments.length) {
	      if (elem) {
	        hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()];

	        if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
	          return ret;
	        }

	        ret = elem.value; // Handle most common string cases

	        if (typeof ret === "string") {
	          return ret.replace(rreturn, "");
	        } // Handle cases where value is null/undef or number


	        return ret == null ? "" : ret;
	      }

	      return;
	    }

	    valueIsFunction = isFunction(value);
	    return this.each(function (i) {
	      var val;

	      if (this.nodeType !== 1) {
	        return;
	      }

	      if (valueIsFunction) {
	        val = value.call(this, i, jQuery(this).val());
	      } else {
	        val = value;
	      } // Treat null/undefined as ""; convert numbers to string


	      if (val == null) {
	        val = "";
	      } else if (typeof val === "number") {
	        val += "";
	      } else if (Array.isArray(val)) {
	        val = jQuery.map(val, function (value) {
	          return value == null ? "" : value + "";
	        });
	      }

	      hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()]; // If set returns undefined, fall back to normal setting

	      if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
	        this.value = val;
	      }
	    });
	  }
	});
	jQuery.extend({
	  valHooks: {
	    option: {
	      get: function get(elem) {
	        var val = jQuery.find.attr(elem, "value");
	        return val != null ? val : // Support: IE <=10 - 11 only
	        // option.text throws exceptions (#14686, #14858)
	        // Strip and collapse whitespace
	        // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
	        stripAndCollapse(jQuery.text(elem));
	      }
	    },
	    select: {
	      get: function get(elem) {
	        var value,
	            option,
	            i,
	            options = elem.options,
	            index = elem.selectedIndex,
	            one = elem.type === "select-one",
	            values = one ? null : [],
	            max = one ? index + 1 : options.length;

	        if (index < 0) {
	          i = max;
	        } else {
	          i = one ? index : 0;
	        } // Loop through all the selected options


	        for (; i < max; i++) {
	          option = options[i]; // Support: IE <=9 only
	          // IE8-9 doesn't update selected after form reset (#2551)

	          if ((option.selected || i === index) && // Don't return options that are disabled or in a disabled optgroup
	          !option.disabled && (!option.parentNode.disabled || !nodeName(option.parentNode, "optgroup"))) {
	            // Get the specific value for the option
	            value = jQuery(option).val(); // We don't need an array for one selects

	            if (one) {
	              return value;
	            } // Multi-Selects return an array


	            values.push(value);
	          }
	        }

	        return values;
	      },
	      set: function set(elem, value) {
	        var optionSet,
	            option,
	            options = elem.options,
	            values = jQuery.makeArray(value),
	            i = options.length;

	        while (i--) {
	          option = options[i];
	          /* eslint-disable no-cond-assign */

	          if (option.selected = jQuery.inArray(jQuery.valHooks.option.get(option), values) > -1) {
	            optionSet = true;
	          }
	          /* eslint-enable no-cond-assign */

	        } // Force browsers to behave consistently when non-matching value is set


	        if (!optionSet) {
	          elem.selectedIndex = -1;
	        }

	        return values;
	      }
	    }
	  }
	}); // Radios and checkboxes getter/setter

	jQuery.each(["radio", "checkbox"], function () {
	  jQuery.valHooks[this] = {
	    set: function set(elem, value) {
	      if (Array.isArray(value)) {
	        return elem.checked = jQuery.inArray(jQuery(elem).val(), value) > -1;
	      }
	    }
	  };

	  if (!support.checkOn) {
	    jQuery.valHooks[this].get = function (elem) {
	      return elem.getAttribute("value") === null ? "on" : elem.value;
	    };
	  }
	}); // Return jQuery for attributes-only inclusion

	support.focusin = "onfocusin" in window;

	var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	    stopPropagationCallback = function stopPropagationCallback(e) {
	  e.stopPropagation();
	};

	jQuery.extend(jQuery.event, {
	  trigger: function trigger(event, data, elem, onlyHandlers) {
	    var i,
	        cur,
	        tmp,
	        bubbleType,
	        ontype,
	        handle,
	        special,
	        lastElement,
	        eventPath = [elem || document$2],
	        type = hasOwn.call(event, "type") ? event.type : event,
	        namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
	    cur = lastElement = tmp = elem = elem || document$2; // Don't do events on text and comment nodes

	    if (elem.nodeType === 3 || elem.nodeType === 8) {
	      return;
	    } // focus/blur morphs to focusin/out; ensure we're not firing them right now


	    if (rfocusMorph.test(type + jQuery.event.triggered)) {
	      return;
	    }

	    if (type.indexOf(".") > -1) {
	      // Namespaced trigger; create a regexp to match event type in handle()
	      namespaces = type.split(".");
	      type = namespaces.shift();
	      namespaces.sort();
	    }

	    ontype = type.indexOf(":") < 0 && "on" + type; // Caller can pass in a jQuery.Event object, Object, or just an event type string

	    event = event[jQuery.expando] ? event : new jQuery.Event(type, _typeof(event) === "object" && event); // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)

	    event.isTrigger = onlyHandlers ? 2 : 3;
	    event.namespace = namespaces.join(".");
	    event.rnamespace = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null; // Clean up the event in case it is being reused

	    event.result = undefined;

	    if (!event.target) {
	      event.target = elem;
	    } // Clone any incoming data and prepend the event, creating the handler arg list


	    data = data == null ? [event] : jQuery.makeArray(data, [event]); // Allow special events to draw outside the lines

	    special = jQuery.event.special[type] || {};

	    if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) {
	      return;
	    } // Determine event propagation path in advance, per W3C events spec (#9951)
	    // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)


	    if (!onlyHandlers && !special.noBubble && !isWindow(elem)) {
	      bubbleType = special.delegateType || type;

	      if (!rfocusMorph.test(bubbleType + type)) {
	        cur = cur.parentNode;
	      }

	      for (; cur; cur = cur.parentNode) {
	        eventPath.push(cur);
	        tmp = cur;
	      } // Only add window if we got to document (e.g., not plain obj or detached DOM)


	      if (tmp === (elem.ownerDocument || document$2)) {
	        eventPath.push(tmp.defaultView || tmp.parentWindow || window);
	      }
	    } // Fire handlers on the event path


	    i = 0;

	    while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
	      lastElement = cur;
	      event.type = i > 1 ? bubbleType : special.bindType || type; // jQuery handler

	      handle = (dataPriv.get(cur, "events") || {})[event.type] && dataPriv.get(cur, "handle");

	      if (handle) {
	        handle.apply(cur, data);
	      } // Native handler


	      handle = ontype && cur[ontype];

	      if (handle && handle.apply && acceptData(cur)) {
	        event.result = handle.apply(cur, data);

	        if (event.result === false) {
	          event.preventDefault();
	        }
	      }
	    }

	    event.type = type; // If nobody prevented the default action, do it now

	    if (!onlyHandlers && !event.isDefaultPrevented()) {
	      if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && acceptData(elem)) {
	        // Call a native DOM method on the target with the same name as the event.
	        // Don't do default actions on window, that's where global variables be (#6170)
	        if (ontype && isFunction(elem[type]) && !isWindow(elem)) {
	          // Don't re-trigger an onFOO event when we call its FOO() method
	          tmp = elem[ontype];

	          if (tmp) {
	            elem[ontype] = null;
	          } // Prevent re-triggering of the same event, since we already bubbled it above


	          jQuery.event.triggered = type;

	          if (event.isPropagationStopped()) {
	            lastElement.addEventListener(type, stopPropagationCallback);
	          }

	          elem[type]();

	          if (event.isPropagationStopped()) {
	            lastElement.removeEventListener(type, stopPropagationCallback);
	          }

	          jQuery.event.triggered = undefined;

	          if (tmp) {
	            elem[ontype] = tmp;
	          }
	        }
	      }
	    }

	    return event.result;
	  },
	  // Piggyback on a donor event to simulate a different one
	  // Used only for `focus(in | out)` events
	  simulate: function simulate(type, elem, event) {
	    var e = jQuery.extend(new jQuery.Event(), event, {
	      type: type,
	      isSimulated: true
	    });
	    jQuery.event.trigger(e, null, elem);
	  }
	});
	jQuery.fn.extend({
	  trigger: function trigger(type, data) {
	    return this.each(function () {
	      jQuery.event.trigger(type, data, this);
	    });
	  },
	  triggerHandler: function triggerHandler(type, data) {
	    var elem = this[0];

	    if (elem) {
	      return jQuery.event.trigger(type, data, elem, true);
	    }
	  }
	}); // Support: Firefox <=44
	// Firefox doesn't have focus(in | out) events
	// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
	//
	// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
	// focus(in | out) events fire after focus & blur events,
	// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
	// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857

	if (!support.focusin) {
	  jQuery.each({
	    focus: "focusin",
	    blur: "focusout"
	  }, function (orig, fix) {
	    // Attach a single capturing handler on the document while someone wants focusin/focusout
	    var handler = function handler(event) {
	      jQuery.event.simulate(fix, event.target, jQuery.event.fix(event));
	    };

	    jQuery.event.special[fix] = {
	      setup: function setup() {
	        var doc = this.ownerDocument || this,
	            attaches = dataPriv.access(doc, fix);

	        if (!attaches) {
	          doc.addEventListener(orig, handler, true);
	        }

	        dataPriv.access(doc, fix, (attaches || 0) + 1);
	      },
	      teardown: function teardown() {
	        var doc = this.ownerDocument || this,
	            attaches = dataPriv.access(doc, fix) - 1;

	        if (!attaches) {
	          doc.removeEventListener(orig, handler, true);
	          dataPriv.remove(doc, fix);
	        } else {
	          dataPriv.access(doc, fix, attaches);
	        }
	      }
	    };
	  });
	}

	var rbracket = /\[\]$/,
	    rCRLF = /\r?\n/g,
	    rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	    rsubmittable = /^(?:input|select|textarea|keygen)/i;

	function buildParams(prefix, obj, traditional, add) {
	  var name;

	  if (Array.isArray(obj)) {
	    // Serialize array item.
	    jQuery.each(obj, function (i, v) {
	      if (traditional || rbracket.test(prefix)) {
	        // Treat each array item as a scalar.
	        add(prefix, v);
	      } else {
	        // Item is non-scalar (array or object), encode its numeric index.
	        buildParams(prefix + "[" + (_typeof(v) === "object" && v != null ? i : "") + "]", v, traditional, add);
	      }
	    });
	  } else if (!traditional && toType(obj) === "object") {
	    // Serialize object item.
	    for (name in obj) {
	      buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
	    }
	  } else {
	    // Serialize scalar item.
	    add(prefix, obj);
	  }
	} // Serialize an array of form elements or a set of
	// key/values into a query string


	jQuery.param = function (a, traditional) {
	  var prefix,
	      s = [],
	      add = function add(key, valueOrFunction) {
	    // If value is a function, invoke it and use its return value
	    var value = isFunction(valueOrFunction) ? valueOrFunction() : valueOrFunction;
	    s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value == null ? "" : value);
	  }; // If an array was passed in, assume that it is an array of form elements.


	  if (Array.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) {
	    // Serialize the form elements
	    jQuery.each(a, function () {
	      add(this.name, this.value);
	    });
	  } else {
	    // If traditional, encode the "old" way (the way 1.3.2 or older
	    // did it), otherwise encode params recursively.
	    for (prefix in a) {
	      buildParams(prefix, a[prefix], traditional, add);
	    }
	  } // Return the resulting serialization


	  return s.join("&");
	};

	jQuery.fn.extend({
	  serialize: function serialize() {
	    return jQuery.param(this.serializeArray());
	  },
	  serializeArray: function serializeArray() {
	    return this.map(function () {
	      // Can add propHook for "elements" to filter or add form elements
	      var elements = jQuery.prop(this, "elements");
	      return elements ? jQuery.makeArray(elements) : this;
	    }).filter(function () {
	      var type = this.type; // Use .is( ":disabled" ) so that fieldset[disabled] works

	      return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type));
	    }).map(function (i, elem) {
	      var val = jQuery(this).val();

	      if (val == null) {
	        return null;
	      }

	      if (Array.isArray(val)) {
	        return jQuery.map(val, function (val) {
	          return {
	            name: elem.name,
	            value: val.replace(rCRLF, "\r\n")
	          };
	        });
	      }

	      return {
	        name: elem.name,
	        value: val.replace(rCRLF, "\r\n")
	      };
	    }).get();
	  }
	});
	jQuery.fn.extend({
	  wrapAll: function wrapAll(html) {
	    var wrap;

	    if (this[0]) {
	      if (isFunction(html)) {
	        html = html.call(this[0]);
	      } // The elements to wrap the target around


	      wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);

	      if (this[0].parentNode) {
	        wrap.insertBefore(this[0]);
	      }

	      wrap.map(function () {
	        var elem = this;

	        while (elem.firstElementChild) {
	          elem = elem.firstElementChild;
	        }

	        return elem;
	      }).append(this);
	    }

	    return this;
	  },
	  wrapInner: function wrapInner(html) {
	    if (isFunction(html)) {
	      return this.each(function (i) {
	        jQuery(this).wrapInner(html.call(this, i));
	      });
	    }

	    return this.each(function () {
	      var self = jQuery(this),
	          contents = self.contents();

	      if (contents.length) {
	        contents.wrapAll(html);
	      } else {
	        self.append(html);
	      }
	    });
	  },
	  wrap: function wrap(html) {
	    var htmlIsFunction = isFunction(html);
	    return this.each(function (i) {
	      jQuery(this).wrapAll(htmlIsFunction ? html.call(this, i) : html);
	    });
	  },
	  unwrap: function unwrap(selector) {
	    this.parent(selector).not("body").each(function () {
	      jQuery(this).replaceWith(this.childNodes);
	    });
	    return this;
	  }
	});

	jQuery.expr.pseudos.hidden = function (elem) {
	  return !jQuery.expr.pseudos.visible(elem);
	};

	jQuery.expr.pseudos.visible = function (elem) {
	  return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length);
	}; // Support: Safari 8 only
	// In Safari 8 documents created via document.implementation.createHTMLDocument
	// collapse sibling forms: the second one becomes a child of the first one.
	// Because of that, this security measure has to be disabled in Safari 8.
	// https://bugs.webkit.org/show_bug.cgi?id=137337


	support.createHTMLDocument = function () {
	  var body = document$2.implementation.createHTMLDocument("").body;
	  body.innerHTML = "<form></form><form></form>";
	  return body.childNodes.length === 2;
	}(); // Argument "data" should be string of html
	// context (optional): If specified, the fragment will be created in this context,
	// defaults to document
	// keepScripts (optional): If true, will include scripts passed in the html string


	jQuery.parseHTML = function (data, context, keepScripts) {
	  if (typeof data !== "string") {
	    return [];
	  }

	  if (typeof context === "boolean") {
	    keepScripts = context;
	    context = false;
	  }

	  var base, parsed, scripts;

	  if (!context) {
	    // Stop scripts or inline event handlers from being executed immediately
	    // by using document.implementation
	    if (support.createHTMLDocument) {
	      context = document$2.implementation.createHTMLDocument(""); // Set the base href for the created document
	      // so any parsed elements with URLs
	      // are based on the document's URL (gh-2965)

	      base = context.createElement("base");
	      base.href = document$2.location.href;
	      context.head.appendChild(base);
	    } else {
	      context = document$2;
	    }
	  }

	  parsed = rsingleTag.exec(data);
	  scripts = !keepScripts && []; // Single tag

	  if (parsed) {
	    return [context.createElement(parsed[1])];
	  }

	  parsed = buildFragment([data], context, scripts);

	  if (scripts && scripts.length) {
	    jQuery(scripts).remove();
	  }

	  return jQuery.merge([], parsed.childNodes);
	};

	jQuery.offset = {
	  setOffset: function setOffset(elem, options, i) {
	    var curPosition,
	        curLeft,
	        curCSSTop,
	        curTop,
	        curOffset,
	        curCSSLeft,
	        calculatePosition,
	        position = jQuery.css(elem, "position"),
	        curElem = jQuery(elem),
	        props = {}; // Set position first, in-case top/left are set even on static elem

	    if (position === "static") {
	      elem.style.position = "relative";
	    }

	    curOffset = curElem.offset();
	    curCSSTop = jQuery.css(elem, "top");
	    curCSSLeft = jQuery.css(elem, "left");
	    calculatePosition = (position === "absolute" || position === "fixed") && (curCSSTop + curCSSLeft).indexOf("auto") > -1; // Need to be able to calculate position if either
	    // top or left is auto and position is either absolute or fixed

	    if (calculatePosition) {
	      curPosition = curElem.position();
	      curTop = curPosition.top;
	      curLeft = curPosition.left;
	    } else {
	      curTop = parseFloat(curCSSTop) || 0;
	      curLeft = parseFloat(curCSSLeft) || 0;
	    }

	    if (isFunction(options)) {
	      // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
	      options = options.call(elem, i, jQuery.extend({}, curOffset));
	    }

	    if (options.top != null) {
	      props.top = options.top - curOffset.top + curTop;
	    }

	    if (options.left != null) {
	      props.left = options.left - curOffset.left + curLeft;
	    }

	    if ("using" in options) {
	      options.using.call(elem, props);
	    } else {
	      curElem.css(props);
	    }
	  }
	};
	jQuery.fn.extend({
	  // offset() relates an element's border box to the document origin
	  offset: function offset(options) {
	    // Preserve chaining for setter
	    if (arguments.length) {
	      return options === undefined ? this : this.each(function (i) {
	        jQuery.offset.setOffset(this, options, i);
	      });
	    }

	    var rect,
	        win,
	        elem = this[0];

	    if (!elem) {
	      return;
	    } // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
	    // Support: IE <=11 only
	    // Running getBoundingClientRect on a
	    // disconnected node in IE throws an error


	    if (!elem.getClientRects().length) {
	      return {
	        top: 0,
	        left: 0
	      };
	    } // Get document-relative position by adding viewport scroll to viewport-relative gBCR


	    rect = elem.getBoundingClientRect();
	    win = elem.ownerDocument.defaultView;
	    return {
	      top: rect.top + win.pageYOffset,
	      left: rect.left + win.pageXOffset
	    };
	  },
	  // position() relates an element's margin box to its offset parent's padding box
	  // This corresponds to the behavior of CSS absolute positioning
	  position: function position() {
	    if (!this[0]) {
	      return;
	    }

	    var offsetParent,
	        offset,
	        doc,
	        elem = this[0],
	        parentOffset = {
	      top: 0,
	      left: 0
	    }; // position:fixed elements are offset from the viewport, which itself always has zero offset

	    if (jQuery.css(elem, "position") === "fixed") {
	      // Assume position:fixed implies availability of getBoundingClientRect
	      offset = elem.getBoundingClientRect();
	    } else {
	      offset = this.offset(); // Account for the *real* offset parent, which can be the document or its root element
	      // when a statically positioned element is identified

	      doc = elem.ownerDocument;
	      offsetParent = elem.offsetParent || doc.documentElement;

	      while (offsetParent && (offsetParent === doc.body || offsetParent === doc.documentElement) && jQuery.css(offsetParent, "position") === "static") {
	        offsetParent = offsetParent.parentNode;
	      }

	      if (offsetParent && offsetParent !== elem && offsetParent.nodeType === 1) {
	        // Incorporate borders into its offset, since they are outside its content origin
	        parentOffset = jQuery(offsetParent).offset();
	        parentOffset.top += jQuery.css(offsetParent, "borderTopWidth", true);
	        parentOffset.left += jQuery.css(offsetParent, "borderLeftWidth", true);
	      }
	    } // Subtract parent offsets and element margins


	    return {
	      top: offset.top - parentOffset.top - jQuery.css(elem, "marginTop", true),
	      left: offset.left - parentOffset.left - jQuery.css(elem, "marginLeft", true)
	    };
	  },
	  // This method will return documentElement in the following cases:
	  // 1) For the element inside the iframe without offsetParent, this method will return
	  //    documentElement of the parent window
	  // 2) For the hidden or detached element
	  // 3) For body or html element, i.e. in case of the html node - it will return itself
	  //
	  // but those exceptions were never presented as a real life use-cases
	  // and might be considered as more preferable results.
	  //
	  // This logic, however, is not guaranteed and can change at any point in the future
	  offsetParent: function offsetParent() {
	    return this.map(function () {
	      var offsetParent = this.offsetParent;

	      while (offsetParent && jQuery.css(offsetParent, "position") === "static") {
	        offsetParent = offsetParent.offsetParent;
	      }

	      return offsetParent || documentElement;
	    });
	  }
	}); // Create scrollLeft and scrollTop methods

	jQuery.each({
	  scrollLeft: "pageXOffset",
	  scrollTop: "pageYOffset"
	}, function (method, prop) {
	  var top = "pageYOffset" === prop;

	  jQuery.fn[method] = function (val) {
	    return access(this, function (elem, method, val) {
	      // Coalesce documents and windows
	      var win;

	      if (isWindow(elem)) {
	        win = elem;
	      } else if (elem.nodeType === 9) {
	        win = elem.defaultView;
	      }

	      if (val === undefined) {
	        return win ? win[prop] : elem[method];
	      }

	      if (win) {
	        win.scrollTo(!top ? val : win.pageXOffset, top ? val : win.pageYOffset);
	      } else {
	        elem[method] = val;
	      }
	    }, method, val, arguments.length);
	  };
	}); // Support: Safari <=7 - 9.1, Chrome <=37 - 49
	// Add the top/left cssHooks using jQuery.fn.position
	// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
	// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
	// getComputedStyle returns percent when specified for top/left/bottom/right;
	// rather than make the css module depend on the offset module, just check for it here

	jQuery.each(["top", "left"], function (i, prop) {
	  jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function (elem, computed) {
	    if (computed) {
	      computed = curCSS(elem, prop); // If curCSS returns percentage, fallback to offset

	      return rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed;
	    }
	  });
	}); // Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods

	jQuery.each({
	  Height: "height",
	  Width: "width"
	}, function (name, type) {
	  jQuery.each({
	    padding: "inner" + name,
	    content: type,
	    "": "outer" + name
	  }, function (defaultExtra, funcName) {
	    // Margin is only for outerHeight, outerWidth
	    jQuery.fn[funcName] = function (margin, value) {
	      var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
	          extra = defaultExtra || (margin === true || value === true ? "margin" : "border");
	      return access(this, function (elem, type, value) {
	        var doc;

	        if (isWindow(elem)) {
	          // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
	          return funcName.indexOf("outer") === 0 ? elem["inner" + name] : elem.document.documentElement["client" + name];
	        } // Get document width or height


	        if (elem.nodeType === 9) {
	          doc = elem.documentElement; // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
	          // whichever is greatest

	          return Math.max(elem.body["scroll" + name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name]);
	        }

	        return value === undefined ? // Get width or height on the element, requesting but not forcing parseFloat
	        jQuery.css(elem, type, extra) : // Set width or height on the element
	        jQuery.style(elem, type, value, extra);
	      }, type, chainable ? margin : undefined, chainable);
	    };
	  });
	});
	jQuery.each(("blur focus focusin focusout resize scroll click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup contextmenu").split(" "), function (i, name) {
	  // Handle event binding
	  jQuery.fn[name] = function (data, fn) {
	    return arguments.length > 0 ? this.on(name, null, data, fn) : this.trigger(name);
	  };
	});
	jQuery.fn.extend({
	  hover: function hover(fnOver, fnOut) {
	    return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
	  }
	});
	jQuery.fn.extend({
	  bind: function bind(types, data, fn) {
	    return this.on(types, null, data, fn);
	  },
	  unbind: function unbind(types, fn) {
	    return this.off(types, null, fn);
	  },
	  delegate: function delegate(selector, types, data, fn) {
	    return this.on(types, selector, data, fn);
	  },
	  undelegate: function undelegate(selector, types, fn) {
	    // ( namespace ) or ( selector, types [, fn] )
	    return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
	  }
	}); // Bind a function to a context, optionally partially applying any
	// arguments.
	// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
	// However, it is not slated for removal any time soon

	jQuery.proxy = function (fn, context) {
	  var tmp, args, proxy;

	  if (typeof context === "string") {
	    tmp = fn[context];
	    context = fn;
	    fn = tmp;
	  } // Quick check to determine if target is callable, in the spec
	  // this throws a TypeError, but we will just return undefined.


	  if (!isFunction(fn)) {
	    return undefined;
	  } // Simulated bind


	  args = _slice.call(arguments, 2);

	  proxy = function proxy() {
	    return fn.apply(context || this, args.concat(_slice.call(arguments)));
	  }; // Set the guid of unique handler to the same of original handler, so it can be removed


	  proxy.guid = fn.guid = fn.guid || jQuery.guid++;
	  return proxy;
	};

	jQuery.holdReady = function (hold) {
	  if (hold) {
	    jQuery.readyWait++;
	  } else {
	    jQuery.ready(true);
	  }
	};

	jQuery.isArray = Array.isArray;
	jQuery.parseJSON = JSON.parse;
	jQuery.nodeName = nodeName;
	jQuery.isFunction = isFunction;
	jQuery.isWindow = isWindow;
	jQuery.camelCase = camelCase;
	jQuery.type = toType;
	jQuery.now = Date.now;

	jQuery.isNumeric = function (obj) {
	  // As of jQuery 3.0, isNumeric is limited to
	  // strings and numbers (primitives or objects)
	  // that can be coerced to finite numbers (gh-2662)
	  var type = jQuery.type(obj);
	  return (type === "number" || type === "string") && // parseFloat NaNs numeric-cast false positives ("")
	  // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
	  // subtraction forces infinities to NaN
	  !isNaN(obj - parseFloat(obj));
	};

	var $ = jQuery;

	// a string of all valid unicode whitespaces
	// eslint-disable-next-line max-len
	var whitespaces = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	var whitespace = '[' + whitespaces + ']';
	var ltrim = RegExp('^' + whitespace + whitespace + '*');
	var rtrim$1 = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

	var createMethod$3 = function (TYPE) {
	  return function ($this) {
	    var string = String(requireObjectCoercible($this));
	    if (TYPE & 1) string = string.replace(ltrim, '');
	    if (TYPE & 2) string = string.replace(rtrim$1, '');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$3(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimend
	  end: createMethod$3(2),
	  // `String.prototype.trim` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trim
	  trim: createMethod$3(3)
	};

	var getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var getOwnPropertyDescriptor$3 = objectGetOwnPropertyDescriptor.f;
	var defineProperty$6 = objectDefineProperty.f;
	var trim = stringTrim.trim;
	var NUMBER = 'Number';
	var NativeNumber = global_1[NUMBER];
	var NumberPrototype = NativeNumber.prototype; // Opera ~12 has broken Object#toString

	var BROKEN_CLASSOF = classofRaw(objectCreate(NumberPrototype)) == NUMBER; // `ToNumber` abstract operation
	// https://tc39.github.io/ecma262/#sec-tonumber

	var toNumber = function (argument) {
	  var it = toPrimitive(argument, false);
	  var first, third, radix, maxCode, digits, length, index, code;

	  if (typeof it == 'string' && it.length > 2) {
	    it = trim(it);
	    first = it.charCodeAt(0);

	    if (first === 43 || first === 45) {
	      third = it.charCodeAt(2);
	      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
	    } else if (first === 48) {
	      switch (it.charCodeAt(1)) {
	        case 66:
	        case 98:
	          radix = 2;
	          maxCode = 49;
	          break;
	        // fast equal of /^0b[01]+$/i

	        case 79:
	        case 111:
	          radix = 8;
	          maxCode = 55;
	          break;
	        // fast equal of /^0o[0-7]+$/i

	        default:
	          return +it;
	      }

	      digits = it.slice(2);
	      length = digits.length;

	      for (index = 0; index < length; index++) {
	        code = digits.charCodeAt(index); // parseInt parses a string to a first unavailable symbol
	        // but ToNumber should return NaN if a string contains unavailable symbols

	        if (code < 48 || code > maxCode) return NaN;
	      }

	      return parseInt(digits, radix);
	    }
	  }

	  return +it;
	}; // `Number` constructor
	// https://tc39.github.io/ecma262/#sec-number-constructor


	if (isForced_1(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
	  var NumberWrapper = function Number(value) {
	    var it = arguments.length < 1 ? 0 : value;
	    var dummy = this;
	    return dummy instanceof NumberWrapper // check on 1..constructor(foo) case
	    && (BROKEN_CLASSOF ? fails(function () {
	      NumberPrototype.valueOf.call(dummy);
	    }) : classofRaw(dummy) != NUMBER) ? inheritIfRequired(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
	  };

	  for (var keys$2 = descriptors ? getOwnPropertyNames$1(NativeNumber) : ( // ES3:
	  'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' + // ES2015 (in case, if modules with ES2015 Number statics required before):
	  'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' + 'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger').split(','), j = 0, key; keys$2.length > j; j++) {
	    if (has(NativeNumber, key = keys$2[j]) && !has(NumberWrapper, key)) {
	      defineProperty$6(NumberWrapper, key, getOwnPropertyDescriptor$3(NativeNumber, key));
	    }
	  }

	  NumberWrapper.prototype = NumberPrototype;
	  NumberPrototype.constructor = NumberWrapper;
	  redefine(global_1, NUMBER, NumberWrapper);
	}

	// https://tc39.github.io/ecma262/#sec-number.max_safe_integer

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  MAX_SAFE_INTEGER: 0x1FFFFFFFFFFFFF
	});

	var nativeGetOwnPropertyNames$2 = objectGetOwnPropertyNamesExternal.f;
	var FAILS_ON_PRIMITIVES$1 = fails(function () {
	  return !Object.getOwnPropertyNames(1);
	}); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$1
	}, {
	  getOwnPropertyNames: nativeGetOwnPropertyNames$2
	});

	var FAILS_ON_PRIMITIVES$2 = fails(function () {
	  objectKeys(1);
	}); // `Object.keys` method
	// https://tc39.github.io/ecma262/#sec-object.keys

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$2
	}, {
	  keys: function keys(it) {
	    return objectKeys(toObject(it));
	  }
	});

	var nativePromiseConstructor = global_1.Promise;

	var redefineAll = function (target, src, options) {
	  for (var key in src) redefine(target, key, src[key], options);

	  return target;
	};

	var anInstance = function (it, Constructor, name) {
	  if (!(it instanceof Constructor)) {
	    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
	  }

	  return it;
	};

	var ITERATOR$3 = wellKnownSymbol('iterator');
	var ArrayPrototype$1 = Array.prototype; // check on default Array iterator

	var isArrayIteratorMethod = function (it) {
	  return it !== undefined && (iterators.Array === it || ArrayPrototype$1[ITERATOR$3] === it);
	};

	var ITERATOR$4 = wellKnownSymbol('iterator');

	var getIteratorMethod = function (it) {
	  if (it != undefined) return it[ITERATOR$4] || it['@@iterator'] || iterators[classof(it)];
	};

	var callWithSafeIterationClosing = function (iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value); // 7.4.6 IteratorClose(iterator, completion)
	  } catch (error) {
	    var returnMethod = iterator['return'];
	    if (returnMethod !== undefined) anObject(returnMethod.call(iterator));
	    throw error;
	  }
	};

	var iterate_1 = createCommonjsModule(function (module) {
	  var Result = function (stopped, result) {
	    this.stopped = stopped;
	    this.result = result;
	  };

	  var iterate = module.exports = function (iterable, fn, that, AS_ENTRIES, IS_ITERATOR) {
	    var boundFunction = functionBindContext(fn, that, AS_ENTRIES ? 2 : 1);
	    var iterator, iterFn, index, length, result, next, step;

	    if (IS_ITERATOR) {
	      iterator = iterable;
	    } else {
	      iterFn = getIteratorMethod(iterable);
	      if (typeof iterFn != 'function') throw TypeError('Target is not iterable'); // optimisation for array iterators

	      if (isArrayIteratorMethod(iterFn)) {
	        for (index = 0, length = toLength(iterable.length); length > index; index++) {
	          result = AS_ENTRIES ? boundFunction(anObject(step = iterable[index])[0], step[1]) : boundFunction(iterable[index]);
	          if (result && result instanceof Result) return result;
	        }

	        return new Result(false);
	      }

	      iterator = iterFn.call(iterable);
	    }

	    next = iterator.next;

	    while (!(step = next.call(iterator)).done) {
	      result = callWithSafeIterationClosing(iterator, boundFunction, step.value, AS_ENTRIES);
	      if (typeof result == 'object' && result && result instanceof Result) return result;
	    }

	    return new Result(false);
	  };

	  iterate.stop = function (result) {
	    return new Result(true, result);
	  };
	});

	var ITERATOR$5 = wellKnownSymbol('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return {
	        done: !!called++
	      };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };

	  iteratorWithReturn[ITERATOR$5] = function () {
	    return this;
	  }; // eslint-disable-next-line no-throw-literal


	  Array.from(iteratorWithReturn, function () {
	    throw 2;
	  });
	} catch (error) {
	  /* empty */
	}

	var checkCorrectnessOfIteration = function (exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;

	  try {
	    var object = {};

	    object[ITERATOR$5] = function () {
	      return {
	        next: function () {
	          return {
	            done: ITERATION_SUPPORT = true
	          };
	        }
	      };
	    };

	    exec(object);
	  } catch (error) {
	    /* empty */
	  }

	  return ITERATION_SUPPORT;
	};

	var engineIsIos = /(iphone|ipod|ipad).*applewebkit/i.test(engineUserAgent);

	var location = global_1.location;
	var set$1 = global_1.setImmediate;
	var clear = global_1.clearImmediate;
	var process$2 = global_1.process;
	var MessageChannel$1 = global_1.MessageChannel;
	var Dispatch = global_1.Dispatch;
	var counter = 0;
	var queue = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var defer, channel, port;

	var run = function (id) {
	  // eslint-disable-next-line no-prototype-builtins
	  if (queue.hasOwnProperty(id)) {
	    var fn = queue[id];
	    delete queue[id];
	    fn();
	  }
	};

	var runner = function (id) {
	  return function () {
	    run(id);
	  };
	};

	var listener = function (event) {
	  run(event.data);
	};

	var post = function (id) {
	  // old engines have not location.origin
	  global_1.postMessage(id + '', location.protocol + '//' + location.host);
	}; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:


	if (!set$1 || !clear) {
	  set$1 = function setImmediate(fn) {
	    var args = [];
	    var i = 1;

	    while (arguments.length > i) args.push(arguments[i++]);

	    queue[++counter] = function () {
	      // eslint-disable-next-line no-new-func
	      (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
	    };

	    defer(counter);
	    return counter;
	  };

	  clear = function clearImmediate(id) {
	    delete queue[id];
	  }; // Node.js 0.8-


	  if (classofRaw(process$2) == 'process') {
	    defer = function (id) {
	      process$2.nextTick(runner(id));
	    }; // Sphere (JS game engine) Dispatch API

	  } else if (Dispatch && Dispatch.now) {
	    defer = function (id) {
	      Dispatch.now(runner(id));
	    }; // Browsers with MessageChannel, includes WebWorkers
	    // except iOS - https://github.com/zloirock/core-js/issues/624

	  } else if (MessageChannel$1 && !engineIsIos) {
	    channel = new MessageChannel$1();
	    port = channel.port2;
	    channel.port1.onmessage = listener;
	    defer = functionBindContext(port.postMessage, port, 1); // Browsers with postMessage, skip WebWorkers
	    // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (global_1.addEventListener && typeof postMessage == 'function' && !global_1.importScripts && !fails(post) && location.protocol !== 'file:') {
	    defer = post;
	    global_1.addEventListener('message', listener, false); // IE8-
	  } else if (ONREADYSTATECHANGE in documentCreateElement('script')) {
	    defer = function (id) {
	      html.appendChild(documentCreateElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    }; // Rest old browsers

	  } else {
	    defer = function (id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}

	var task = {
	  set: set$1,
	  clear: clear
	};

	var getOwnPropertyDescriptor$4 = objectGetOwnPropertyDescriptor.f;
	var macrotask = task.set;
	var MutationObserver = global_1.MutationObserver || global_1.WebKitMutationObserver;
	var process$3 = global_1.process;
	var Promise$1 = global_1.Promise;
	var IS_NODE = classofRaw(process$3) == 'process'; // Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`

	var queueMicrotaskDescriptor = getOwnPropertyDescriptor$4(global_1, 'queueMicrotask');
	var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
	var flush, head, last, notify, toggle, node, promise, then; // modern engines have queueMicrotask method

	if (!queueMicrotask) {
	  flush = function () {
	    var parent, fn;
	    if (IS_NODE && (parent = process$3.domain)) parent.exit();

	    while (head) {
	      fn = head.fn;
	      head = head.next;

	      try {
	        fn();
	      } catch (error) {
	        if (head) notify();else last = undefined;
	        throw error;
	      }
	    }

	    last = undefined;
	    if (parent) parent.enter();
	  }; // Node.js


	  if (IS_NODE) {
	    notify = function () {
	      process$3.nextTick(flush);
	    }; // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339

	  } else if (MutationObserver && !engineIsIos) {
	    toggle = true;
	    node = document.createTextNode('');
	    new MutationObserver(flush).observe(node, {
	      characterData: true
	    });

	    notify = function () {
	      node.data = toggle = !toggle;
	    }; // environments with maybe non-completely correct, but existent Promise

	  } else if (Promise$1 && Promise$1.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    promise = Promise$1.resolve(undefined);
	    then = promise.then;

	    notify = function () {
	      then.call(promise, flush);
	    }; // for other environments - macrotask based on:
	    // - setImmediate
	    // - MessageChannel
	    // - window.postMessag
	    // - onreadystatechange
	    // - setTimeout

	  } else {
	    notify = function () {
	      // strange IE + webpack dev server bug - use .call(global)
	      macrotask.call(global_1, flush);
	    };
	  }
	}

	var microtask = queueMicrotask || function (fn) {
	  var task = {
	    fn: fn,
	    next: undefined
	  };
	  if (last) last.next = task;

	  if (!head) {
	    head = task;
	    notify();
	  }

	  last = task;
	};

	var PromiseCapability = function (C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aFunction$1(resolve);
	  this.reject = aFunction$1(reject);
	}; // 25.4.1.5 NewPromiseCapability(C)


	var f$7 = function (C) {
	  return new PromiseCapability(C);
	};

	var newPromiseCapability = {
	  f: f$7
	};

	var promiseResolve = function (C, x) {
	  anObject(C);
	  if (isObject(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};

	var hostReportErrors = function (a, b) {
	  var console = global_1.console;

	  if (console && console.error) {
	    arguments.length === 1 ? console.error(a) : console.error(a, b);
	  }
	};

	var perform = function (exec) {
	  try {
	    return {
	      error: false,
	      value: exec()
	    };
	  } catch (error) {
	    return {
	      error: true,
	      value: error
	    };
	  }
	};

	var task$1 = task.set;
	var SPECIES$6 = wellKnownSymbol('species');
	var PROMISE = 'Promise';
	var getInternalState$3 = internalState.get;
	var setInternalState$4 = internalState.set;
	var getInternalPromiseState = internalState.getterFor(PROMISE);
	var PromiseConstructor = nativePromiseConstructor;
	var TypeError$1 = global_1.TypeError;
	var document$3 = global_1.document;
	var process$4 = global_1.process;
	var $fetch = getBuiltIn('fetch');
	var newPromiseCapability$1 = newPromiseCapability.f;
	var newGenericPromiseCapability = newPromiseCapability$1;
	var IS_NODE$1 = classofRaw(process$4) == 'process';
	var DISPATCH_EVENT = !!(document$3 && document$3.createEvent && global_1.dispatchEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;
	var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
	var FORCED$3 = isForced_1(PROMISE, function () {
	  var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);

	  if (!GLOBAL_CORE_JS_PROMISE) {
	    // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	    // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	    // We can't detect it synchronously, so just check versions
	    if (engineV8Version === 66) return true; // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test

	    if (!IS_NODE$1 && typeof PromiseRejectionEvent != 'function') return true;
	  } // We need Promise#finally in the pure version for preventing prototype pollution
	  // deoptimization and performance degradation
	  // https://github.com/zloirock/core-js/issues/679

	  if (engineV8Version >= 51 && /native code/.test(PromiseConstructor)) return false; // Detect correctness of subclassing with @@species support

	  var promise = PromiseConstructor.resolve(1);

	  var FakePromise = function (exec) {
	    exec(function () {
	      /* empty */
	    }, function () {
	      /* empty */
	    });
	  };

	  var constructor = promise.constructor = {};
	  constructor[SPECIES$6] = FakePromise;
	  return !(promise.then(function () {
	    /* empty */
	  }) instanceof FakePromise);
	});
	var INCORRECT_ITERATION = FORCED$3 || !checkCorrectnessOfIteration(function (iterable) {
	  PromiseConstructor.all(iterable)['catch'](function () {
	    /* empty */
	  });
	}); // helpers

	var isThenable = function (it) {
	  var then;
	  return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
	};

	var notify$1 = function (promise, state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  var chain = state.reactions;
	  microtask(function () {
	    var value = state.value;
	    var ok = state.state == FULFILLED;
	    var index = 0; // variable length - can't use forEach

	    while (chain.length > index) {
	      var reaction = chain[index++];
	      var handler = ok ? reaction.ok : reaction.fail;
	      var resolve = reaction.resolve;
	      var reject = reaction.reject;
	      var domain = reaction.domain;
	      var result, then, exited;

	      try {
	        if (handler) {
	          if (!ok) {
	            if (state.rejection === UNHANDLED) onHandleUnhandled(promise, state);
	            state.rejection = HANDLED;
	          }

	          if (handler === true) result = value;else {
	            if (domain) domain.enter();
	            result = handler(value); // can throw

	            if (domain) {
	              domain.exit();
	              exited = true;
	            }
	          }

	          if (result === reaction.promise) {
	            reject(TypeError$1('Promise-chain cycle'));
	          } else if (then = isThenable(result)) {
	            then.call(result, resolve, reject);
	          } else resolve(result);
	        } else reject(value);
	      } catch (error) {
	        if (domain && !exited) domain.exit();
	        reject(error);
	      }
	    }

	    state.reactions = [];
	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(promise, state);
	  });
	};

	var dispatchEvent = function (name, promise, reason) {
	  var event, handler;

	  if (DISPATCH_EVENT) {
	    event = document$3.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    global_1.dispatchEvent(event);
	  } else event = {
	    promise: promise,
	    reason: reason
	  };

	  if (handler = global_1['on' + name]) handler(event);else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};

	var onUnhandled = function (promise, state) {
	  task$1.call(global_1, function () {
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;

	    if (IS_UNHANDLED) {
	      result = perform(function () {
	        if (IS_NODE$1) {
	          process$4.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      }); // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should

	      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};

	var isUnhandled = function (state) {
	  return state.rejection !== HANDLED && !state.parent;
	};

	var onHandleUnhandled = function (promise, state) {
	  task$1.call(global_1, function () {
	    if (IS_NODE$1) {
	      process$4.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};

	var bind = function (fn, promise, state, unwrap) {
	  return function (value) {
	    fn(promise, state, value, unwrap);
	  };
	};

	var internalReject = function (promise, state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify$1(promise, state, true);
	};

	var internalResolve = function (promise, state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;

	  try {
	    if (promise === value) throw TypeError$1("Promise can't be resolved itself");
	    var then = isThenable(value);

	    if (then) {
	      microtask(function () {
	        var wrapper = {
	          done: false
	        };

	        try {
	          then.call(value, bind(internalResolve, promise, wrapper, state), bind(internalReject, promise, wrapper, state));
	        } catch (error) {
	          internalReject(promise, wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify$1(promise, state, false);
	    }
	  } catch (error) {
	    internalReject(promise, {
	      done: false
	    }, error, state);
	  }
	}; // constructor polyfill


	if (FORCED$3) {
	  // 25.4.3.1 Promise(executor)
	  PromiseConstructor = function Promise(executor) {
	    anInstance(this, PromiseConstructor, PROMISE);
	    aFunction$1(executor);
	    Internal.call(this);
	    var state = getInternalState$3(this);

	    try {
	      executor(bind(internalResolve, this, state), bind(internalReject, this, state));
	    } catch (error) {
	      internalReject(this, state, error);
	    }
	  }; // eslint-disable-next-line no-unused-vars


	  Internal = function Promise(executor) {
	    setInternalState$4(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: [],
	      rejection: false,
	      state: PENDING,
	      value: undefined
	    });
	  };

	  Internal.prototype = redefineAll(PromiseConstructor.prototype, {
	    // `Promise.prototype.then` method
	    // https://tc39.github.io/ecma262/#sec-promise.prototype.then
	    then: function then(onFulfilled, onRejected) {
	      var state = getInternalPromiseState(this);
	      var reaction = newPromiseCapability$1(speciesConstructor(this, PromiseConstructor));
	      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
	      reaction.fail = typeof onRejected == 'function' && onRejected;
	      reaction.domain = IS_NODE$1 ? process$4.domain : undefined;
	      state.parent = true;
	      state.reactions.push(reaction);
	      if (state.state != PENDING) notify$1(this, state, false);
	      return reaction.promise;
	    },
	    // `Promise.prototype.catch` method
	    // https://tc39.github.io/ecma262/#sec-promise.prototype.catch
	    'catch': function (onRejected) {
	      return this.then(undefined, onRejected);
	    }
	  });

	  OwnPromiseCapability = function () {
	    var promise = new Internal();
	    var state = getInternalState$3(promise);
	    this.promise = promise;
	    this.resolve = bind(internalResolve, promise, state);
	    this.reject = bind(internalReject, promise, state);
	  };

	  newPromiseCapability.f = newPromiseCapability$1 = function (C) {
	    return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
	  };

	  if ( typeof nativePromiseConstructor == 'function') {
	    nativeThen = nativePromiseConstructor.prototype.then; // wrap native Promise#then for native async functions

	    redefine(nativePromiseConstructor.prototype, 'then', function then(onFulfilled, onRejected) {
	      var that = this;
	      return new PromiseConstructor(function (resolve, reject) {
	        nativeThen.call(that, resolve, reject);
	      }).then(onFulfilled, onRejected); // https://github.com/zloirock/core-js/issues/640
	    }, {
	      unsafe: true
	    }); // wrap fetch result

	    if (typeof $fetch == 'function') _export({
	      global: true,
	      enumerable: true,
	      forced: true
	    }, {
	      // eslint-disable-next-line no-unused-vars
	      fetch: function fetch(input
	      /* , init */
	      ) {
	        return promiseResolve(PromiseConstructor, $fetch.apply(global_1, arguments));
	      }
	    });
	  }
	}

	_export({
	  global: true,
	  wrap: true,
	  forced: FORCED$3
	}, {
	  Promise: PromiseConstructor
	});
	setToStringTag(PromiseConstructor, PROMISE, false);
	setSpecies(PROMISE);
	PromiseWrapper = getBuiltIn(PROMISE); // statics

	_export({
	  target: PROMISE,
	  stat: true,
	  forced: FORCED$3
	}, {
	  // `Promise.reject` method
	  // https://tc39.github.io/ecma262/#sec-promise.reject
	  reject: function reject(r) {
	    var capability = newPromiseCapability$1(this);
	    capability.reject.call(undefined, r);
	    return capability.promise;
	  }
	});
	_export({
	  target: PROMISE,
	  stat: true,
	  forced:  FORCED$3
	}, {
	  // `Promise.resolve` method
	  // https://tc39.github.io/ecma262/#sec-promise.resolve
	  resolve: function resolve(x) {
	    return promiseResolve( this, x);
	  }
	});
	_export({
	  target: PROMISE,
	  stat: true,
	  forced: INCORRECT_ITERATION
	}, {
	  // `Promise.all` method
	  // https://tc39.github.io/ecma262/#sec-promise.all
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapability$1(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aFunction$1(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate_1(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        values.push(undefined);
	        remaining++;
	        $promiseResolve.call(C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  },
	  // `Promise.race` method
	  // https://tc39.github.io/ecma262/#sec-promise.race
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapability$1(C);
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aFunction$1(C.resolve);
	      iterate_1(iterable, function (promise) {
	        $promiseResolve.call(C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;
	var nativeStartsWith = ''.startsWith;
	var min$7 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC$1 = correctIsRegexpLogic('startsWith'); // https://github.com/zloirock/core-js/pull/702

	var MDN_POLYFILL_BUG$1 =  !CORRECT_IS_REGEXP_LOGIC$1 && !!function () {
	  var descriptor = getOwnPropertyDescriptor$5(String.prototype, 'startsWith');
	  return descriptor && !descriptor.writable;
	}(); // `String.prototype.startsWith` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.startswith

	_export({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG$1 && !CORRECT_IS_REGEXP_LOGIC$1
	}, {
	  startsWith: function startsWith(searchString
	  /* , position = 0 */
	  ) {
	    var that = String(requireObjectCoercible(this));
	    notARegexp(searchString);
	    var index = toLength(min$7(arguments.length > 1 ? arguments[1] : undefined, that.length));
	    var search = String(searchString);
	    return nativeStartsWith ? nativeStartsWith.call(that, search, index) : that.slice(index, index + search.length) === search;
	  }
	});

	var non = '\u200B\u0085\u180E'; // check that a method works with the correct list
	// of whitespaces and has a correct name

	var stringTrimForced = function (METHOD_NAME) {
	  return fails(function () {
	    return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
	  });
	};

	var $trim = stringTrim.trim; // `String.prototype.trim` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.trim

	_export({
	  target: 'String',
	  proto: true,
	  forced: stringTrimForced('trim')
	}, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});

	var ITERATOR$6 = wellKnownSymbol('iterator');
	var nativeUrl = !fails(function () {
	  var url = new URL('b?a=1&b=2&c=3', 'http://a');
	  var searchParams = url.searchParams;
	  var result = '';
	  url.pathname = 'c%20d';
	  searchParams.forEach(function (value, key) {
	    searchParams['delete']('b');
	    result += key + value;
	  });
	  return isPure && !url.toJSON || !searchParams.sort || url.href !== 'http://a/c%20d?a=1&c=3' || searchParams.get('c') !== '3' || String(new URLSearchParams('?a=1')) !== 'a=1' || !searchParams[ITERATOR$6] // throws in Edge
	  || new URL('https://a@b').username !== 'a' || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b' // not punycoded in Edge
	  || new URL('http://тест').host !== 'xn--e1aybc' // not escaped in Chrome 62-
	  || new URL('http://a#б').hash !== '#%D0%B1' // fails in Chrome 66-
	  || result !== 'a1c3' // throws in Safari
	  || new URL('http://x', undefined).host !== 'x';
	});

	var nativeAssign = Object.assign;
	var defineProperty$7 = Object.defineProperty; // `Object.assign` method
	// https://tc39.github.io/ecma262/#sec-object.assign

	var objectAssign = !nativeAssign || fails(function () {
	  // should have correct order of operations (Edge bug)
	  if (descriptors && nativeAssign({
	    b: 1
	  }, nativeAssign(defineProperty$7({}, 'a', {
	    enumerable: true,
	    get: function () {
	      defineProperty$7(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), {
	    b: 2
	  })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)

	  var A = {};
	  var B = {}; // eslint-disable-next-line no-undef

	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) {
	    B[chr] = chr;
	  });
	  return nativeAssign({}, A)[symbol] != 7 || objectKeys(nativeAssign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) {
	  // eslint-disable-line no-unused-vars
	  var T = toObject(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  var propertyIsEnumerable = objectPropertyIsEnumerable.f;

	  while (argumentsLength > index) {
	    var S = indexedObject(arguments[index++]);
	    var keys = getOwnPropertySymbols ? objectKeys(S).concat(getOwnPropertySymbols(S)) : objectKeys(S);
	    var length = keys.length;
	    var j = 0;
	    var key;

	    while (length > j) {
	      key = keys[j++];
	      if (!descriptors || propertyIsEnumerable.call(S, key)) T[key] = S[key];
	    }
	  }

	  return T;
	} : nativeAssign;

	// https://tc39.github.io/ecma262/#sec-array.from


	var arrayFrom = function from(arrayLike
	/* , mapfn = undefined, thisArg = undefined */
	) {
	  var O = toObject(arrayLike);
	  var C = typeof this == 'function' ? this : Array;
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  if (mapping) mapfn = functionBindContext(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2); // if the target is not iterable or it's an array with the default iterator - use a simple case

	  if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
	    iterator = iteratorMethod.call(O);
	    next = iterator.next;
	    result = new C();

	    for (; !(step = next.call(iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty(result, index, value);
	    }
	  } else {
	    length = toLength(O.length);
	    result = new C(length);

	    for (; length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty(result, index, value);
	    }
	  }

	  result.length = index;
	  return result;
	};

	var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

	var base = 36;
	var tMin = 1;
	var tMax = 26;
	var skew = 38;
	var damp = 700;
	var initialBias = 72;
	var initialN = 128; // 0x80

	var delimiter = '-'; // '\x2D'

	var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars

	var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

	var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
	var baseMinusTMin = base - tMin;
	var floor$2 = Math.floor;
	var stringFromCharCode = String.fromCharCode;
	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 */

	var ucs2decode = function (string) {
	  var output = [];
	  var counter = 0;
	  var length = string.length;

	  while (counter < length) {
	    var value = string.charCodeAt(counter++);

	    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
	      // It's a high surrogate, and there is a next character.
	      var extra = string.charCodeAt(counter++);

	      if ((extra & 0xFC00) == 0xDC00) {
	        // Low surrogate.
	        output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
	      } else {
	        // It's an unmatched surrogate; only append this code unit, in case the
	        // next code unit is the high surrogate of a surrogate pair.
	        output.push(value);
	        counter--;
	      }
	    } else {
	      output.push(value);
	    }
	  }

	  return output;
	};
	/**
	 * Converts a digit/integer into a basic code point.
	 */


	var digitToBasic = function (digit) {
	  //  0..25 map to ASCII a..z or A..Z
	  // 26..35 map to ASCII 0..9
	  return digit + 22 + 75 * (digit < 26);
	};
	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * https://tools.ietf.org/html/rfc3492#section-3.4
	 */


	var adapt = function (delta, numPoints, firstTime) {
	  var k = 0;
	  delta = firstTime ? floor$2(delta / damp) : delta >> 1;
	  delta += floor$2(delta / numPoints);

	  for (; delta > baseMinusTMin * tMax >> 1; k += base) {
	    delta = floor$2(delta / baseMinusTMin);
	  }

	  return floor$2(k + (baseMinusTMin + 1) * delta / (delta + skew));
	};
	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 */
	// eslint-disable-next-line  max-statements


	var encode = function (input) {
	  var output = []; // Convert the input in UCS-2 to an array of Unicode code points.

	  input = ucs2decode(input); // Cache the length.

	  var inputLength = input.length; // Initialize the state.

	  var n = initialN;
	  var delta = 0;
	  var bias = initialBias;
	  var i, currentValue; // Handle the basic code points.

	  for (i = 0; i < input.length; i++) {
	    currentValue = input[i];

	    if (currentValue < 0x80) {
	      output.push(stringFromCharCode(currentValue));
	    }
	  }

	  var basicLength = output.length; // number of basic code points.

	  var handledCPCount = basicLength; // number of code points that have been handled;
	  // Finish the basic string with a delimiter unless it's empty.

	  if (basicLength) {
	    output.push(delimiter);
	  } // Main encoding loop:


	  while (handledCPCount < inputLength) {
	    // All non-basic code points < n have been handled already. Find the next larger one:
	    var m = maxInt;

	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];

	      if (currentValue >= n && currentValue < m) {
	        m = currentValue;
	      }
	    } // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.


	    var handledCPCountPlusOne = handledCPCount + 1;

	    if (m - n > floor$2((maxInt - delta) / handledCPCountPlusOne)) {
	      throw RangeError(OVERFLOW_ERROR);
	    }

	    delta += (m - n) * handledCPCountPlusOne;
	    n = m;

	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];

	      if (currentValue < n && ++delta > maxInt) {
	        throw RangeError(OVERFLOW_ERROR);
	      }

	      if (currentValue == n) {
	        // Represent delta as a generalized variable-length integer.
	        var q = delta;

	        for (var k = base;;
	        /* no condition */
	        k += base) {
	          var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
	          if (q < t) break;
	          var qMinusT = q - t;
	          var baseMinusT = base - t;
	          output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
	          q = floor$2(qMinusT / baseMinusT);
	        }

	        output.push(stringFromCharCode(digitToBasic(q)));
	        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
	        delta = 0;
	        ++handledCPCount;
	      }
	    }

	    ++delta;
	    ++n;
	  }

	  return output.join('');
	};

	var stringPunycodeToAscii = function (input) {
	  var encoded = [];
	  var labels = input.toLowerCase().replace(regexSeparators, '\u002E').split('.');
	  var i, label;

	  for (i = 0; i < labels.length; i++) {
	    label = labels[i];
	    encoded.push(regexNonASCII.test(label) ? 'xn--' + encode(label) : label);
	  }

	  return encoded.join('.');
	};

	var getIterator = function (it) {
	  var iteratorMethod = getIteratorMethod(it);

	  if (typeof iteratorMethod != 'function') {
	    throw TypeError(String(it) + ' is not iterable');
	  }

	  return anObject(iteratorMethod.call(it));
	};

	var $fetch$1 = getBuiltIn('fetch');
	var Headers = getBuiltIn('Headers');
	var ITERATOR$7 = wellKnownSymbol('iterator');
	var URL_SEARCH_PARAMS = 'URLSearchParams';
	var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
	var setInternalState$5 = internalState.set;
	var getInternalParamsState = internalState.getterFor(URL_SEARCH_PARAMS);
	var getInternalIteratorState = internalState.getterFor(URL_SEARCH_PARAMS_ITERATOR);
	var plus = /\+/g;
	var sequences = Array(4);

	var percentSequence = function (bytes) {
	  return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
	};

	var percentDecode = function (sequence) {
	  try {
	    return decodeURIComponent(sequence);
	  } catch (error) {
	    return sequence;
	  }
	};

	var deserialize = function (it) {
	  var result = it.replace(plus, ' ');
	  var bytes = 4;

	  try {
	    return decodeURIComponent(result);
	  } catch (error) {
	    while (bytes) {
	      result = result.replace(percentSequence(bytes--), percentDecode);
	    }

	    return result;
	  }
	};

	var find = /[!'()~]|%20/g;
	var replace = {
	  '!': '%21',
	  "'": '%27',
	  '(': '%28',
	  ')': '%29',
	  '~': '%7E',
	  '%20': '+'
	};

	var replacer = function (match) {
	  return replace[match];
	};

	var serialize = function (it) {
	  return encodeURIComponent(it).replace(find, replacer);
	};

	var parseSearchParams = function (result, query) {
	  if (query) {
	    var attributes = query.split('&');
	    var index = 0;
	    var attribute, entry;

	    while (index < attributes.length) {
	      attribute = attributes[index++];

	      if (attribute.length) {
	        entry = attribute.split('=');
	        result.push({
	          key: deserialize(entry.shift()),
	          value: deserialize(entry.join('='))
	        });
	      }
	    }
	  }
	};

	var updateSearchParams = function (query) {
	  this.entries.length = 0;
	  parseSearchParams(this.entries, query);
	};

	var validateArgumentsLength = function (passed, required) {
	  if (passed < required) throw TypeError('Not enough arguments');
	};

	var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
	  setInternalState$5(this, {
	    type: URL_SEARCH_PARAMS_ITERATOR,
	    iterator: getIterator(getInternalParamsState(params).entries),
	    kind: kind
	  });
	}, 'Iterator', function next() {
	  var state = getInternalIteratorState(this);
	  var kind = state.kind;
	  var step = state.iterator.next();
	  var entry = step.value;

	  if (!step.done) {
	    step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [entry.key, entry.value];
	  }

	  return step;
	}); // `URLSearchParams` constructor
	// https://url.spec.whatwg.org/#interface-urlsearchparams

	var URLSearchParamsConstructor = function URLSearchParams()
	/* init */
	{
	  anInstance(this, URLSearchParamsConstructor, URL_SEARCH_PARAMS);
	  var init = arguments.length > 0 ? arguments[0] : undefined;
	  var that = this;
	  var entries = [];
	  var iteratorMethod, iterator, next, step, entryIterator, entryNext, first, second, key;
	  setInternalState$5(that, {
	    type: URL_SEARCH_PARAMS,
	    entries: entries,
	    updateURL: function () {
	      /* empty */
	    },
	    updateSearchParams: updateSearchParams
	  });

	  if (init !== undefined) {
	    if (isObject(init)) {
	      iteratorMethod = getIteratorMethod(init);

	      if (typeof iteratorMethod === 'function') {
	        iterator = iteratorMethod.call(init);
	        next = iterator.next;

	        while (!(step = next.call(iterator)).done) {
	          entryIterator = getIterator(anObject(step.value));
	          entryNext = entryIterator.next;
	          if ((first = entryNext.call(entryIterator)).done || (second = entryNext.call(entryIterator)).done || !entryNext.call(entryIterator).done) throw TypeError('Expected sequence with length 2');
	          entries.push({
	            key: first.value + '',
	            value: second.value + ''
	          });
	        }
	      } else for (key in init) if (has(init, key)) entries.push({
	        key: key,
	        value: init[key] + ''
	      });
	    } else {
	      parseSearchParams(entries, typeof init === 'string' ? init.charAt(0) === '?' ? init.slice(1) : init : init + '');
	    }
	  }
	};

	var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;
	redefineAll(URLSearchParamsPrototype, {
	  // `URLSearchParams.prototype.appent` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-append
	  append: function append(name, value) {
	    validateArgumentsLength(arguments.length, 2);
	    var state = getInternalParamsState(this);
	    state.entries.push({
	      key: name + '',
	      value: value + ''
	    });
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.delete` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
	  'delete': function (name) {
	    validateArgumentsLength(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var key = name + '';
	    var index = 0;

	    while (index < entries.length) {
	      if (entries[index].key === key) entries.splice(index, 1);else index++;
	    }

	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.get` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-get
	  get: function get(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var index = 0;

	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) return entries[index].value;
	    }

	    return null;
	  },
	  // `URLSearchParams.prototype.getAll` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
	  getAll: function getAll(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var result = [];
	    var index = 0;

	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) result.push(entries[index].value);
	    }

	    return result;
	  },
	  // `URLSearchParams.prototype.has` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-has
	  has: function has(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var index = 0;

	    while (index < entries.length) {
	      if (entries[index++].key === key) return true;
	    }

	    return false;
	  },
	  // `URLSearchParams.prototype.set` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-set
	  set: function set(name, value) {
	    validateArgumentsLength(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var found = false;
	    var key = name + '';
	    var val = value + '';
	    var index = 0;
	    var entry;

	    for (; index < entries.length; index++) {
	      entry = entries[index];

	      if (entry.key === key) {
	        if (found) entries.splice(index--, 1);else {
	          found = true;
	          entry.value = val;
	        }
	      }
	    }

	    if (!found) entries.push({
	      key: key,
	      value: val
	    });
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.sort` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-sort
	  sort: function sort() {
	    var state = getInternalParamsState(this);
	    var entries = state.entries; // Array#sort is not stable in some engines

	    var slice = entries.slice();
	    var entry, entriesIndex, sliceIndex;
	    entries.length = 0;

	    for (sliceIndex = 0; sliceIndex < slice.length; sliceIndex++) {
	      entry = slice[sliceIndex];

	      for (entriesIndex = 0; entriesIndex < sliceIndex; entriesIndex++) {
	        if (entries[entriesIndex].key > entry.key) {
	          entries.splice(entriesIndex, 0, entry);
	          break;
	        }
	      }

	      if (entriesIndex === sliceIndex) entries.push(entry);
	    }

	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.forEach` method
	  forEach: function forEach(callback
	  /* , thisArg */
	  ) {
	    var entries = getInternalParamsState(this).entries;
	    var boundFunction = functionBindContext(callback, arguments.length > 1 ? arguments[1] : undefined, 3);
	    var index = 0;
	    var entry;

	    while (index < entries.length) {
	      entry = entries[index++];
	      boundFunction(entry.value, entry.key, this);
	    }
	  },
	  // `URLSearchParams.prototype.keys` method
	  keys: function keys() {
	    return new URLSearchParamsIterator(this, 'keys');
	  },
	  // `URLSearchParams.prototype.values` method
	  values: function values() {
	    return new URLSearchParamsIterator(this, 'values');
	  },
	  // `URLSearchParams.prototype.entries` method
	  entries: function entries() {
	    return new URLSearchParamsIterator(this, 'entries');
	  }
	}, {
	  enumerable: true
	}); // `URLSearchParams.prototype[@@iterator]` method

	redefine(URLSearchParamsPrototype, ITERATOR$7, URLSearchParamsPrototype.entries); // `URLSearchParams.prototype.toString` method
	// https://url.spec.whatwg.org/#urlsearchparams-stringification-behavior

	redefine(URLSearchParamsPrototype, 'toString', function toString() {
	  var entries = getInternalParamsState(this).entries;
	  var result = [];
	  var index = 0;
	  var entry;

	  while (index < entries.length) {
	    entry = entries[index++];
	    result.push(serialize(entry.key) + '=' + serialize(entry.value));
	  }

	  return result.join('&');
	}, {
	  enumerable: true
	});
	setToStringTag(URLSearchParamsConstructor, URL_SEARCH_PARAMS);
	_export({
	  global: true,
	  forced: !nativeUrl
	}, {
	  URLSearchParams: URLSearchParamsConstructor
	}); // Wrap `fetch` for correct work with polyfilled `URLSearchParams`
	// https://github.com/zloirock/core-js/issues/674

	if (!nativeUrl && typeof $fetch$1 == 'function' && typeof Headers == 'function') {
	  _export({
	    global: true,
	    enumerable: true,
	    forced: true
	  }, {
	    fetch: function fetch(input
	    /* , init */
	    ) {
	      var args = [input];
	      var init, body, headers;

	      if (arguments.length > 1) {
	        init = arguments[1];

	        if (isObject(init)) {
	          body = init.body;

	          if (classof(body) === URL_SEARCH_PARAMS) {
	            headers = init.headers ? new Headers(init.headers) : new Headers();

	            if (!headers.has('content-type')) {
	              headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
	            }

	            init = objectCreate(init, {
	              body: createPropertyDescriptor(0, String(body)),
	              headers: createPropertyDescriptor(0, headers)
	            });
	          }
	        }

	        args.push(init);
	      }

	      return $fetch$1.apply(this, args);
	    }
	  });
	}

	var web_urlSearchParams = {
	  URLSearchParams: URLSearchParamsConstructor,
	  getState: getInternalParamsState
	};

	var codeAt = stringMultibyte.codeAt;
	var NativeURL = global_1.URL;
	var URLSearchParams$1 = web_urlSearchParams.URLSearchParams;
	var getInternalSearchParamsState = web_urlSearchParams.getState;
	var setInternalState$6 = internalState.set;
	var getInternalURLState = internalState.getterFor('URL');
	var floor$3 = Math.floor;
	var pow = Math.pow;
	var INVALID_AUTHORITY = 'Invalid authority';
	var INVALID_SCHEME = 'Invalid scheme';
	var INVALID_HOST = 'Invalid host';
	var INVALID_PORT = 'Invalid port';
	var ALPHA = /[A-Za-z]/;
	var ALPHANUMERIC = /[\d+-.A-Za-z]/;
	var DIGIT = /\d/;
	var HEX_START = /^(0x|0X)/;
	var OCT = /^[0-7]+$/;
	var DEC = /^\d+$/;
	var HEX = /^[\dA-Fa-f]+$/; // eslint-disable-next-line no-control-regex

	var FORBIDDEN_HOST_CODE_POINT = /[\u0000\u0009\u000A\u000D #%/:?@[\\]]/; // eslint-disable-next-line no-control-regex

	var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\u0000\u0009\u000A\u000D #/:?@[\\]]/; // eslint-disable-next-line no-control-regex

	var LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE = /^[\u0000-\u001F ]+|[\u0000-\u001F ]+$/g; // eslint-disable-next-line no-control-regex

	var TAB_AND_NEW_LINE = /[\u0009\u000A\u000D]/g;
	var EOF;

	var parseHost = function (url, input) {
	  var result, codePoints, index;

	  if (input.charAt(0) == '[') {
	    if (input.charAt(input.length - 1) != ']') return INVALID_HOST;
	    result = parseIPv6(input.slice(1, -1));
	    if (!result) return INVALID_HOST;
	    url.host = result; // opaque host
	  } else if (!isSpecial(url)) {
	    if (FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT.test(input)) return INVALID_HOST;
	    result = '';
	    codePoints = arrayFrom(input);

	    for (index = 0; index < codePoints.length; index++) {
	      result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
	    }

	    url.host = result;
	  } else {
	    input = stringPunycodeToAscii(input);
	    if (FORBIDDEN_HOST_CODE_POINT.test(input)) return INVALID_HOST;
	    result = parseIPv4(input);
	    if (result === null) return INVALID_HOST;
	    url.host = result;
	  }
	};

	var parseIPv4 = function (input) {
	  var parts = input.split('.');
	  var partsLength, numbers, index, part, radix, number, ipv4;

	  if (parts.length && parts[parts.length - 1] == '') {
	    parts.pop();
	  }

	  partsLength = parts.length;
	  if (partsLength > 4) return input;
	  numbers = [];

	  for (index = 0; index < partsLength; index++) {
	    part = parts[index];
	    if (part == '') return input;
	    radix = 10;

	    if (part.length > 1 && part.charAt(0) == '0') {
	      radix = HEX_START.test(part) ? 16 : 8;
	      part = part.slice(radix == 8 ? 1 : 2);
	    }

	    if (part === '') {
	      number = 0;
	    } else {
	      if (!(radix == 10 ? DEC : radix == 8 ? OCT : HEX).test(part)) return input;
	      number = parseInt(part, radix);
	    }

	    numbers.push(number);
	  }

	  for (index = 0; index < partsLength; index++) {
	    number = numbers[index];

	    if (index == partsLength - 1) {
	      if (number >= pow(256, 5 - partsLength)) return null;
	    } else if (number > 255) return null;
	  }

	  ipv4 = numbers.pop();

	  for (index = 0; index < numbers.length; index++) {
	    ipv4 += numbers[index] * pow(256, 3 - index);
	  }

	  return ipv4;
	}; // eslint-disable-next-line max-statements


	var parseIPv6 = function (input) {
	  var address = [0, 0, 0, 0, 0, 0, 0, 0];
	  var pieceIndex = 0;
	  var compress = null;
	  var pointer = 0;
	  var value, length, numbersSeen, ipv4Piece, number, swaps, swap;

	  var char = function () {
	    return input.charAt(pointer);
	  };

	  if (char() == ':') {
	    if (input.charAt(1) != ':') return;
	    pointer += 2;
	    pieceIndex++;
	    compress = pieceIndex;
	  }

	  while (char()) {
	    if (pieceIndex == 8) return;

	    if (char() == ':') {
	      if (compress !== null) return;
	      pointer++;
	      pieceIndex++;
	      compress = pieceIndex;
	      continue;
	    }

	    value = length = 0;

	    while (length < 4 && HEX.test(char())) {
	      value = value * 16 + parseInt(char(), 16);
	      pointer++;
	      length++;
	    }

	    if (char() == '.') {
	      if (length == 0) return;
	      pointer -= length;
	      if (pieceIndex > 6) return;
	      numbersSeen = 0;

	      while (char()) {
	        ipv4Piece = null;

	        if (numbersSeen > 0) {
	          if (char() == '.' && numbersSeen < 4) pointer++;else return;
	        }

	        if (!DIGIT.test(char())) return;

	        while (DIGIT.test(char())) {
	          number = parseInt(char(), 10);
	          if (ipv4Piece === null) ipv4Piece = number;else if (ipv4Piece == 0) return;else ipv4Piece = ipv4Piece * 10 + number;
	          if (ipv4Piece > 255) return;
	          pointer++;
	        }

	        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
	        numbersSeen++;
	        if (numbersSeen == 2 || numbersSeen == 4) pieceIndex++;
	      }

	      if (numbersSeen != 4) return;
	      break;
	    } else if (char() == ':') {
	      pointer++;
	      if (!char()) return;
	    } else if (char()) return;

	    address[pieceIndex++] = value;
	  }

	  if (compress !== null) {
	    swaps = pieceIndex - compress;
	    pieceIndex = 7;

	    while (pieceIndex != 0 && swaps > 0) {
	      swap = address[pieceIndex];
	      address[pieceIndex--] = address[compress + swaps - 1];
	      address[compress + --swaps] = swap;
	    }
	  } else if (pieceIndex != 8) return;

	  return address;
	};

	var findLongestZeroSequence = function (ipv6) {
	  var maxIndex = null;
	  var maxLength = 1;
	  var currStart = null;
	  var currLength = 0;
	  var index = 0;

	  for (; index < 8; index++) {
	    if (ipv6[index] !== 0) {
	      if (currLength > maxLength) {
	        maxIndex = currStart;
	        maxLength = currLength;
	      }

	      currStart = null;
	      currLength = 0;
	    } else {
	      if (currStart === null) currStart = index;
	      ++currLength;
	    }
	  }

	  if (currLength > maxLength) {
	    maxIndex = currStart;
	    maxLength = currLength;
	  }

	  return maxIndex;
	};

	var serializeHost = function (host) {
	  var result, index, compress, ignore0; // ipv4

	  if (typeof host == 'number') {
	    result = [];

	    for (index = 0; index < 4; index++) {
	      result.unshift(host % 256);
	      host = floor$3(host / 256);
	    }

	    return result.join('.'); // ipv6
	  } else if (typeof host == 'object') {
	    result = '';
	    compress = findLongestZeroSequence(host);

	    for (index = 0; index < 8; index++) {
	      if (ignore0 && host[index] === 0) continue;
	      if (ignore0) ignore0 = false;

	      if (compress === index) {
	        result += index ? ':' : '::';
	        ignore0 = true;
	      } else {
	        result += host[index].toString(16);
	        if (index < 7) result += ':';
	      }
	    }

	    return '[' + result + ']';
	  }

	  return host;
	};

	var C0ControlPercentEncodeSet = {};
	var fragmentPercentEncodeSet = objectAssign({}, C0ControlPercentEncodeSet, {
	  ' ': 1,
	  '"': 1,
	  '<': 1,
	  '>': 1,
	  '`': 1
	});
	var pathPercentEncodeSet = objectAssign({}, fragmentPercentEncodeSet, {
	  '#': 1,
	  '?': 1,
	  '{': 1,
	  '}': 1
	});
	var userinfoPercentEncodeSet = objectAssign({}, pathPercentEncodeSet, {
	  '/': 1,
	  ':': 1,
	  ';': 1,
	  '=': 1,
	  '@': 1,
	  '[': 1,
	  '\\': 1,
	  ']': 1,
	  '^': 1,
	  '|': 1
	});

	var percentEncode = function (char, set) {
	  var code = codeAt(char, 0);
	  return code > 0x20 && code < 0x7F && !has(set, char) ? char : encodeURIComponent(char);
	};

	var specialSchemes = {
	  ftp: 21,
	  file: null,
	  http: 80,
	  https: 443,
	  ws: 80,
	  wss: 443
	};

	var isSpecial = function (url) {
	  return has(specialSchemes, url.scheme);
	};

	var includesCredentials = function (url) {
	  return url.username != '' || url.password != '';
	};

	var cannotHaveUsernamePasswordPort = function (url) {
	  return !url.host || url.cannotBeABaseURL || url.scheme == 'file';
	};

	var isWindowsDriveLetter = function (string, normalized) {
	  var second;
	  return string.length == 2 && ALPHA.test(string.charAt(0)) && ((second = string.charAt(1)) == ':' || !normalized && second == '|');
	};

	var startsWithWindowsDriveLetter = function (string) {
	  var third;
	  return string.length > 1 && isWindowsDriveLetter(string.slice(0, 2)) && (string.length == 2 || (third = string.charAt(2)) === '/' || third === '\\' || third === '?' || third === '#');
	};

	var shortenURLsPath = function (url) {
	  var path = url.path;
	  var pathSize = path.length;

	  if (pathSize && (url.scheme != 'file' || pathSize != 1 || !isWindowsDriveLetter(path[0], true))) {
	    path.pop();
	  }
	};

	var isSingleDot = function (segment) {
	  return segment === '.' || segment.toLowerCase() === '%2e';
	};

	var isDoubleDot = function (segment) {
	  segment = segment.toLowerCase();
	  return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
	}; // States:


	var SCHEME_START = {};
	var SCHEME = {};
	var NO_SCHEME = {};
	var SPECIAL_RELATIVE_OR_AUTHORITY = {};
	var PATH_OR_AUTHORITY = {};
	var RELATIVE = {};
	var RELATIVE_SLASH = {};
	var SPECIAL_AUTHORITY_SLASHES = {};
	var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
	var AUTHORITY = {};
	var HOST = {};
	var HOSTNAME = {};
	var PORT = {};
	var FILE = {};
	var FILE_SLASH = {};
	var FILE_HOST = {};
	var PATH_START = {};
	var PATH = {};
	var CANNOT_BE_A_BASE_URL_PATH = {};
	var QUERY = {};
	var FRAGMENT = {}; // eslint-disable-next-line max-statements

	var parseURL = function (url, input, stateOverride, base) {
	  var state = stateOverride || SCHEME_START;
	  var pointer = 0;
	  var buffer = '';
	  var seenAt = false;
	  var seenBracket = false;
	  var seenPasswordToken = false;
	  var codePoints, char, bufferCodePoints, failure;

	  if (!stateOverride) {
	    url.scheme = '';
	    url.username = '';
	    url.password = '';
	    url.host = null;
	    url.port = null;
	    url.path = [];
	    url.query = null;
	    url.fragment = null;
	    url.cannotBeABaseURL = false;
	    input = input.replace(LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE, '');
	  }

	  input = input.replace(TAB_AND_NEW_LINE, '');
	  codePoints = arrayFrom(input);

	  while (pointer <= codePoints.length) {
	    char = codePoints[pointer];

	    switch (state) {
	      case SCHEME_START:
	        if (char && ALPHA.test(char)) {
	          buffer += char.toLowerCase();
	          state = SCHEME;
	        } else if (!stateOverride) {
	          state = NO_SCHEME;
	          continue;
	        } else return INVALID_SCHEME;

	        break;

	      case SCHEME:
	        if (char && (ALPHANUMERIC.test(char) || char == '+' || char == '-' || char == '.')) {
	          buffer += char.toLowerCase();
	        } else if (char == ':') {
	          if (stateOverride && (isSpecial(url) != has(specialSchemes, buffer) || buffer == 'file' && (includesCredentials(url) || url.port !== null) || url.scheme == 'file' && !url.host)) return;
	          url.scheme = buffer;

	          if (stateOverride) {
	            if (isSpecial(url) && specialSchemes[url.scheme] == url.port) url.port = null;
	            return;
	          }

	          buffer = '';

	          if (url.scheme == 'file') {
	            state = FILE;
	          } else if (isSpecial(url) && base && base.scheme == url.scheme) {
	            state = SPECIAL_RELATIVE_OR_AUTHORITY;
	          } else if (isSpecial(url)) {
	            state = SPECIAL_AUTHORITY_SLASHES;
	          } else if (codePoints[pointer + 1] == '/') {
	            state = PATH_OR_AUTHORITY;
	            pointer++;
	          } else {
	            url.cannotBeABaseURL = true;
	            url.path.push('');
	            state = CANNOT_BE_A_BASE_URL_PATH;
	          }
	        } else if (!stateOverride) {
	          buffer = '';
	          state = NO_SCHEME;
	          pointer = 0;
	          continue;
	        } else return INVALID_SCHEME;

	        break;

	      case NO_SCHEME:
	        if (!base || base.cannotBeABaseURL && char != '#') return INVALID_SCHEME;

	        if (base.cannotBeABaseURL && char == '#') {
	          url.scheme = base.scheme;
	          url.path = base.path.slice();
	          url.query = base.query;
	          url.fragment = '';
	          url.cannotBeABaseURL = true;
	          state = FRAGMENT;
	          break;
	        }

	        state = base.scheme == 'file' ? FILE : RELATIVE;
	        continue;

	      case SPECIAL_RELATIVE_OR_AUTHORITY:
	        if (char == '/' && codePoints[pointer + 1] == '/') {
	          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	          pointer++;
	        } else {
	          state = RELATIVE;
	          continue;
	        }

	        break;

	      case PATH_OR_AUTHORITY:
	        if (char == '/') {
	          state = AUTHORITY;
	          break;
	        } else {
	          state = PATH;
	          continue;
	        }

	      case RELATIVE:
	        url.scheme = base.scheme;

	        if (char == EOF) {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = base.query;
	        } else if (char == '/' || char == '\\' && isSpecial(url)) {
	          state = RELATIVE_SLASH;
	        } else if (char == '?') {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = '';
	          state = QUERY;
	        } else if (char == '#') {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = base.query;
	          url.fragment = '';
	          state = FRAGMENT;
	        } else {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.path.pop();
	          state = PATH;
	          continue;
	        }

	        break;

	      case RELATIVE_SLASH:
	        if (isSpecial(url) && (char == '/' || char == '\\')) {
	          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	        } else if (char == '/') {
	          state = AUTHORITY;
	        } else {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          state = PATH;
	          continue;
	        }

	        break;

	      case SPECIAL_AUTHORITY_SLASHES:
	        state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	        if (char != '/' || buffer.charAt(pointer + 1) != '/') continue;
	        pointer++;
	        break;

	      case SPECIAL_AUTHORITY_IGNORE_SLASHES:
	        if (char != '/' && char != '\\') {
	          state = AUTHORITY;
	          continue;
	        }

	        break;

	      case AUTHORITY:
	        if (char == '@') {
	          if (seenAt) buffer = '%40' + buffer;
	          seenAt = true;
	          bufferCodePoints = arrayFrom(buffer);

	          for (var i = 0; i < bufferCodePoints.length; i++) {
	            var codePoint = bufferCodePoints[i];

	            if (codePoint == ':' && !seenPasswordToken) {
	              seenPasswordToken = true;
	              continue;
	            }

	            var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
	            if (seenPasswordToken) url.password += encodedCodePoints;else url.username += encodedCodePoints;
	          }

	          buffer = '';
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url)) {
	          if (seenAt && buffer == '') return INVALID_AUTHORITY;
	          pointer -= arrayFrom(buffer).length + 1;
	          buffer = '';
	          state = HOST;
	        } else buffer += char;

	        break;

	      case HOST:
	      case HOSTNAME:
	        if (stateOverride && url.scheme == 'file') {
	          state = FILE_HOST;
	          continue;
	        } else if (char == ':' && !seenBracket) {
	          if (buffer == '') return INVALID_HOST;
	          failure = parseHost(url, buffer);
	          if (failure) return failure;
	          buffer = '';
	          state = PORT;
	          if (stateOverride == HOSTNAME) return;
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url)) {
	          if (isSpecial(url) && buffer == '') return INVALID_HOST;
	          if (stateOverride && buffer == '' && (includesCredentials(url) || url.port !== null)) return;
	          failure = parseHost(url, buffer);
	          if (failure) return failure;
	          buffer = '';
	          state = PATH_START;
	          if (stateOverride) return;
	          continue;
	        } else {
	          if (char == '[') seenBracket = true;else if (char == ']') seenBracket = false;
	          buffer += char;
	        }

	        break;

	      case PORT:
	        if (DIGIT.test(char)) {
	          buffer += char;
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url) || stateOverride) {
	          if (buffer != '') {
	            var port = parseInt(buffer, 10);
	            if (port > 0xFFFF) return INVALID_PORT;
	            url.port = isSpecial(url) && port === specialSchemes[url.scheme] ? null : port;
	            buffer = '';
	          }

	          if (stateOverride) return;
	          state = PATH_START;
	          continue;
	        } else return INVALID_PORT;

	        break;

	      case FILE:
	        url.scheme = 'file';
	        if (char == '/' || char == '\\') state = FILE_SLASH;else if (base && base.scheme == 'file') {
	          if (char == EOF) {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = base.query;
	          } else if (char == '?') {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = '';
	            state = QUERY;
	          } else if (char == '#') {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = base.query;
	            url.fragment = '';
	            state = FRAGMENT;
	          } else {
	            if (!startsWithWindowsDriveLetter(codePoints.slice(pointer).join(''))) {
	              url.host = base.host;
	              url.path = base.path.slice();
	              shortenURLsPath(url);
	            }

	            state = PATH;
	            continue;
	          }
	        } else {
	          state = PATH;
	          continue;
	        }
	        break;

	      case FILE_SLASH:
	        if (char == '/' || char == '\\') {
	          state = FILE_HOST;
	          break;
	        }

	        if (base && base.scheme == 'file' && !startsWithWindowsDriveLetter(codePoints.slice(pointer).join(''))) {
	          if (isWindowsDriveLetter(base.path[0], true)) url.path.push(base.path[0]);else url.host = base.host;
	        }

	        state = PATH;
	        continue;

	      case FILE_HOST:
	        if (char == EOF || char == '/' || char == '\\' || char == '?' || char == '#') {
	          if (!stateOverride && isWindowsDriveLetter(buffer)) {
	            state = PATH;
	          } else if (buffer == '') {
	            url.host = '';
	            if (stateOverride) return;
	            state = PATH_START;
	          } else {
	            failure = parseHost(url, buffer);
	            if (failure) return failure;
	            if (url.host == 'localhost') url.host = '';
	            if (stateOverride) return;
	            buffer = '';
	            state = PATH_START;
	          }

	          continue;
	        } else buffer += char;

	        break;

	      case PATH_START:
	        if (isSpecial(url)) {
	          state = PATH;
	          if (char != '/' && char != '\\') continue;
	        } else if (!stateOverride && char == '?') {
	          url.query = '';
	          state = QUERY;
	        } else if (!stateOverride && char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          state = PATH;
	          if (char != '/') continue;
	        }

	        break;

	      case PATH:
	        if (char == EOF || char == '/' || char == '\\' && isSpecial(url) || !stateOverride && (char == '?' || char == '#')) {
	          if (isDoubleDot(buffer)) {
	            shortenURLsPath(url);

	            if (char != '/' && !(char == '\\' && isSpecial(url))) {
	              url.path.push('');
	            }
	          } else if (isSingleDot(buffer)) {
	            if (char != '/' && !(char == '\\' && isSpecial(url))) {
	              url.path.push('');
	            }
	          } else {
	            if (url.scheme == 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
	              if (url.host) url.host = '';
	              buffer = buffer.charAt(0) + ':'; // normalize windows drive letter
	            }

	            url.path.push(buffer);
	          }

	          buffer = '';

	          if (url.scheme == 'file' && (char == EOF || char == '?' || char == '#')) {
	            while (url.path.length > 1 && url.path[0] === '') {
	              url.path.shift();
	            }
	          }

	          if (char == '?') {
	            url.query = '';
	            state = QUERY;
	          } else if (char == '#') {
	            url.fragment = '';
	            state = FRAGMENT;
	          }
	        } else {
	          buffer += percentEncode(char, pathPercentEncodeSet);
	        }

	        break;

	      case CANNOT_BE_A_BASE_URL_PATH:
	        if (char == '?') {
	          url.query = '';
	          state = QUERY;
	        } else if (char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          url.path[0] += percentEncode(char, C0ControlPercentEncodeSet);
	        }

	        break;

	      case QUERY:
	        if (!stateOverride && char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          if (char == "'" && isSpecial(url)) url.query += '%27';else if (char == '#') url.query += '%23';else url.query += percentEncode(char, C0ControlPercentEncodeSet);
	        }

	        break;

	      case FRAGMENT:
	        if (char != EOF) url.fragment += percentEncode(char, fragmentPercentEncodeSet);
	        break;
	    }

	    pointer++;
	  }
	}; // `URL` constructor
	// https://url.spec.whatwg.org/#url-class


	var URLConstructor = function URL(url
	/* , base */
	) {
	  var that = anInstance(this, URLConstructor, 'URL');
	  var base = arguments.length > 1 ? arguments[1] : undefined;
	  var urlString = String(url);
	  var state = setInternalState$6(that, {
	    type: 'URL'
	  });
	  var baseState, failure;

	  if (base !== undefined) {
	    if (base instanceof URLConstructor) baseState = getInternalURLState(base);else {
	      failure = parseURL(baseState = {}, String(base));
	      if (failure) throw TypeError(failure);
	    }
	  }

	  failure = parseURL(state, urlString, null, baseState);
	  if (failure) throw TypeError(failure);
	  var searchParams = state.searchParams = new URLSearchParams$1();
	  var searchParamsState = getInternalSearchParamsState(searchParams);
	  searchParamsState.updateSearchParams(state.query);

	  searchParamsState.updateURL = function () {
	    state.query = String(searchParams) || null;
	  };

	  if (!descriptors) {
	    that.href = serializeURL.call(that);
	    that.origin = getOrigin.call(that);
	    that.protocol = getProtocol.call(that);
	    that.username = getUsername.call(that);
	    that.password = getPassword.call(that);
	    that.host = getHost.call(that);
	    that.hostname = getHostname.call(that);
	    that.port = getPort.call(that);
	    that.pathname = getPathname.call(that);
	    that.search = getSearch.call(that);
	    that.searchParams = getSearchParams.call(that);
	    that.hash = getHash.call(that);
	  }
	};

	var URLPrototype = URLConstructor.prototype;

	var serializeURL = function () {
	  var url = getInternalURLState(this);
	  var scheme = url.scheme;
	  var username = url.username;
	  var password = url.password;
	  var host = url.host;
	  var port = url.port;
	  var path = url.path;
	  var query = url.query;
	  var fragment = url.fragment;
	  var output = scheme + ':';

	  if (host !== null) {
	    output += '//';

	    if (includesCredentials(url)) {
	      output += username + (password ? ':' + password : '') + '@';
	    }

	    output += serializeHost(host);
	    if (port !== null) output += ':' + port;
	  } else if (scheme == 'file') output += '//';

	  output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + path.join('/') : '';
	  if (query !== null) output += '?' + query;
	  if (fragment !== null) output += '#' + fragment;
	  return output;
	};

	var getOrigin = function () {
	  var url = getInternalURLState(this);
	  var scheme = url.scheme;
	  var port = url.port;
	  if (scheme == 'blob') try {
	    return new URL(scheme.path[0]).origin;
	  } catch (error) {
	    return 'null';
	  }
	  if (scheme == 'file' || !isSpecial(url)) return 'null';
	  return scheme + '://' + serializeHost(url.host) + (port !== null ? ':' + port : '');
	};

	var getProtocol = function () {
	  return getInternalURLState(this).scheme + ':';
	};

	var getUsername = function () {
	  return getInternalURLState(this).username;
	};

	var getPassword = function () {
	  return getInternalURLState(this).password;
	};

	var getHost = function () {
	  var url = getInternalURLState(this);
	  var host = url.host;
	  var port = url.port;
	  return host === null ? '' : port === null ? serializeHost(host) : serializeHost(host) + ':' + port;
	};

	var getHostname = function () {
	  var host = getInternalURLState(this).host;
	  return host === null ? '' : serializeHost(host);
	};

	var getPort = function () {
	  var port = getInternalURLState(this).port;
	  return port === null ? '' : String(port);
	};

	var getPathname = function () {
	  var url = getInternalURLState(this);
	  var path = url.path;
	  return url.cannotBeABaseURL ? path[0] : path.length ? '/' + path.join('/') : '';
	};

	var getSearch = function () {
	  var query = getInternalURLState(this).query;
	  return query ? '?' + query : '';
	};

	var getSearchParams = function () {
	  return getInternalURLState(this).searchParams;
	};

	var getHash = function () {
	  var fragment = getInternalURLState(this).fragment;
	  return fragment ? '#' + fragment : '';
	};

	var accessorDescriptor = function (getter, setter) {
	  return {
	    get: getter,
	    set: setter,
	    configurable: true,
	    enumerable: true
	  };
	};

	if (descriptors) {
	  objectDefineProperties(URLPrototype, {
	    // `URL.prototype.href` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-href
	    href: accessorDescriptor(serializeURL, function (href) {
	      var url = getInternalURLState(this);
	      var urlString = String(href);
	      var failure = parseURL(url, urlString);
	      if (failure) throw TypeError(failure);
	      getInternalSearchParamsState(url.searchParams).updateSearchParams(url.query);
	    }),
	    // `URL.prototype.origin` getter
	    // https://url.spec.whatwg.org/#dom-url-origin
	    origin: accessorDescriptor(getOrigin),
	    // `URL.prototype.protocol` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-protocol
	    protocol: accessorDescriptor(getProtocol, function (protocol) {
	      var url = getInternalURLState(this);
	      parseURL(url, String(protocol) + ':', SCHEME_START);
	    }),
	    // `URL.prototype.username` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-username
	    username: accessorDescriptor(getUsername, function (username) {
	      var url = getInternalURLState(this);
	      var codePoints = arrayFrom(String(username));
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      url.username = '';

	      for (var i = 0; i < codePoints.length; i++) {
	        url.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	      }
	    }),
	    // `URL.prototype.password` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-password
	    password: accessorDescriptor(getPassword, function (password) {
	      var url = getInternalURLState(this);
	      var codePoints = arrayFrom(String(password));
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      url.password = '';

	      for (var i = 0; i < codePoints.length; i++) {
	        url.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	      }
	    }),
	    // `URL.prototype.host` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-host
	    host: accessorDescriptor(getHost, function (host) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      parseURL(url, String(host), HOST);
	    }),
	    // `URL.prototype.hostname` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-hostname
	    hostname: accessorDescriptor(getHostname, function (hostname) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      parseURL(url, String(hostname), HOSTNAME);
	    }),
	    // `URL.prototype.port` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-port
	    port: accessorDescriptor(getPort, function (port) {
	      var url = getInternalURLState(this);
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      port = String(port);
	      if (port == '') url.port = null;else parseURL(url, port, PORT);
	    }),
	    // `URL.prototype.pathname` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-pathname
	    pathname: accessorDescriptor(getPathname, function (pathname) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      url.path = [];
	      parseURL(url, pathname + '', PATH_START);
	    }),
	    // `URL.prototype.search` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-search
	    search: accessorDescriptor(getSearch, function (search) {
	      var url = getInternalURLState(this);
	      search = String(search);

	      if (search == '') {
	        url.query = null;
	      } else {
	        if ('?' == search.charAt(0)) search = search.slice(1);
	        url.query = '';
	        parseURL(url, search, QUERY);
	      }

	      getInternalSearchParamsState(url.searchParams).updateSearchParams(url.query);
	    }),
	    // `URL.prototype.searchParams` getter
	    // https://url.spec.whatwg.org/#dom-url-searchparams
	    searchParams: accessorDescriptor(getSearchParams),
	    // `URL.prototype.hash` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-hash
	    hash: accessorDescriptor(getHash, function (hash) {
	      var url = getInternalURLState(this);
	      hash = String(hash);

	      if (hash == '') {
	        url.fragment = null;
	        return;
	      }

	      if ('#' == hash.charAt(0)) hash = hash.slice(1);
	      url.fragment = '';
	      parseURL(url, hash, FRAGMENT);
	    })
	  });
	} // `URL.prototype.toJSON` method
	// https://url.spec.whatwg.org/#dom-url-tojson


	redefine(URLPrototype, 'toJSON', function toJSON() {
	  return serializeURL.call(this);
	}, {
	  enumerable: true
	}); // `URL.prototype.toString` method
	// https://url.spec.whatwg.org/#URL-stringification-behavior

	redefine(URLPrototype, 'toString', function toString() {
	  return serializeURL.call(this);
	}, {
	  enumerable: true
	});

	if (NativeURL) {
	  var nativeCreateObjectURL = NativeURL.createObjectURL;
	  var nativeRevokeObjectURL = NativeURL.revokeObjectURL; // `URL.createObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/createObjectURL
	  // eslint-disable-next-line no-unused-vars

	  if (nativeCreateObjectURL) redefine(URLConstructor, 'createObjectURL', function createObjectURL(blob) {
	    return nativeCreateObjectURL.apply(NativeURL, arguments);
	  }); // `URL.revokeObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/revokeObjectURL
	  // eslint-disable-next-line no-unused-vars

	  if (nativeRevokeObjectURL) redefine(URLConstructor, 'revokeObjectURL', function revokeObjectURL(url) {
	    return nativeRevokeObjectURL.apply(NativeURL, arguments);
	  });
	}

	setToStringTag(URLConstructor, 'URL');
	_export({
	  global: true,
	  forced: !nativeUrl,
	  sham: !descriptors
	}, {
	  URL: URLConstructor
	});

	// https://url.spec.whatwg.org/#dom-url-tojson


	_export({
	  target: 'URL',
	  proto: true,
	  enumerable: true
	}, {
	  toJSON: function toJSON() {
	    return URL.prototype.toString.call(this);
	  }
	});

	var freezing = !fails(function () {
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var internalMetadata = createCommonjsModule(function (module) {
	  var defineProperty = objectDefineProperty.f;
	  var METADATA = uid('meta');
	  var id = 0;

	  var isExtensible = Object.isExtensible || function () {
	    return true;
	  };

	  var setMetadata = function (it) {
	    defineProperty(it, METADATA, {
	      value: {
	        objectID: 'O' + ++id,
	        // object ID
	        weakData: {} // weak collections IDs

	      }
	    });
	  };

	  var fastKey = function (it, create) {
	    // return a primitive with prefix
	    if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;

	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return 'F'; // not necessary to add metadata

	      if (!create) return 'E'; // add missing metadata

	      setMetadata(it); // return object ID
	    }

	    return it[METADATA].objectID;
	  };

	  var getWeakData = function (it, create) {
	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return true; // not necessary to add metadata

	      if (!create) return false; // add missing metadata

	      setMetadata(it); // return the store of weak collections IDs
	    }

	    return it[METADATA].weakData;
	  }; // add metadata on freeze-family methods calling


	  var onFreeze = function (it) {
	    if (freezing && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) setMetadata(it);
	    return it;
	  };

	  var meta = module.exports = {
	    REQUIRED: false,
	    fastKey: fastKey,
	    getWeakData: getWeakData,
	    onFreeze: onFreeze
	  };
	  hiddenKeys[METADATA] = true;
	});
	var internalMetadata_1 = internalMetadata.REQUIRED;
	var internalMetadata_2 = internalMetadata.fastKey;
	var internalMetadata_3 = internalMetadata.getWeakData;
	var internalMetadata_4 = internalMetadata.onFreeze;

	var collection = function (CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global_1[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var Constructor = NativeConstructor;
	  var exported = {};

	  var fixMethod = function (KEY) {
	    var nativeMethod = NativePrototype[KEY];
	    redefine(NativePrototype, KEY, KEY == 'add' ? function add(value) {
	      nativeMethod.call(this, value === 0 ? 0 : value);
	      return this;
	    } : KEY == 'delete' ? function (key) {
	      return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : KEY == 'get' ? function get(key) {
	      return IS_WEAK && !isObject(key) ? undefined : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : KEY == 'has' ? function has(key) {
	      return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : function set(key, value) {
	      nativeMethod.call(this, key === 0 ? 0 : key, value);
	      return this;
	    });
	  }; // eslint-disable-next-line max-len


	  if (isForced_1(CONSTRUCTOR_NAME, typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
	    new NativeConstructor().entries().next();
	  })))) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    internalMetadata.REQUIRED = true;
	  } else if (isForced_1(CONSTRUCTOR_NAME, true)) {
	    var instance = new Constructor(); // early implementations not supports chaining

	    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance; // V8 ~ Chromium 40- weak-collections throws on primitives, but should return false

	    var THROWS_ON_PRIMITIVES = fails(function () {
	      instance.has(1);
	    }); // most early implementations doesn't supports iterables, most modern - not close it correctly
	    // eslint-disable-next-line no-new

	    var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) {
	      new NativeConstructor(iterable);
	    }); // for early implementations -0 and +0 not the same

	    var BUGGY_ZERO = !IS_WEAK && fails(function () {
	      // V8 ~ Chromium 42- fails only with 5+ elements
	      var $instance = new NativeConstructor();
	      var index = 5;

	      while (index--) $instance[ADDER](index, index);

	      return !$instance.has(-0);
	    });

	    if (!ACCEPT_ITERABLES) {
	      Constructor = wrapper(function (dummy, iterable) {
	        anInstance(dummy, Constructor, CONSTRUCTOR_NAME);
	        var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
	        if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	        return that;
	      });
	      Constructor.prototype = NativePrototype;
	      NativePrototype.constructor = Constructor;
	    }

	    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
	      fixMethod('delete');
	      fixMethod('has');
	      IS_MAP && fixMethod('get');
	    }

	    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER); // weak collections should not contains .clear method

	    if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
	  }

	  exported[CONSTRUCTOR_NAME] = Constructor;
	  _export({
	    global: true,
	    forced: Constructor != NativeConstructor
	  }, exported);
	  setToStringTag(Constructor, CONSTRUCTOR_NAME);
	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
	  return Constructor;
	};

	var defineProperty$8 = objectDefineProperty.f;
	var fastKey = internalMetadata.fastKey;
	var setInternalState$7 = internalState.set;
	var internalStateGetterFor = internalState.getterFor;
	var collectionStrong = {
	  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var C = wrapper(function (that, iterable) {
	      anInstance(that, C, CONSTRUCTOR_NAME);
	      setInternalState$7(that, {
	        type: CONSTRUCTOR_NAME,
	        index: objectCreate(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!descriptors) that.size = 0;
	      if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	    });
	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

	    var define = function (that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index; // change existing entry

	      if (entry) {
	        entry.value = value; // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (descriptors) state.size++;else that.size++; // add to index

	        if (index !== 'F') state.index[index] = entry;
	      }

	      return that;
	    };

	    var getEntry = function (that, key) {
	      var state = getInternalState(that); // fast case

	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index]; // frozen object case

	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };

	    redefineAll(C.prototype, {
	      // 23.1.3.1 Map.prototype.clear()
	      // 23.2.3.2 Set.prototype.clear()
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;

	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }

	        state.first = state.last = undefined;
	        if (descriptors) state.size = 0;else that.size = 0;
	      },
	      // 23.1.3.3 Map.prototype.delete(key)
	      // 23.2.3.4 Set.prototype.delete(value)
	      'delete': function (key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);

	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (descriptors) state.size--;else that.size--;
	        }

	        return !!entry;
	      },
	      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
	      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
	      forEach: function forEach(callbackfn
	      /* , that = undefined */
	      ) {
	        var state = getInternalState(this);
	        var boundFunction = functionBindContext(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
	        var entry;

	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this); // revert to the last existing entry

	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // 23.1.3.7 Map.prototype.has(key)
	      // 23.2.3.7 Set.prototype.has(value)
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });
	    redefineAll(C.prototype, IS_MAP ? {
	      // 23.1.3.6 Map.prototype.get(key)
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // 23.1.3.9 Map.prototype.set(key, value)
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // 23.2.3.1 Set.prototype.add(value)
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (descriptors) defineProperty$8(C.prototype, 'size', {
	      get: function () {
	        return getInternalState(this).size;
	      }
	    });
	    return C;
	  },
	  setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME); // add .keys, .values, .entries, [@@iterator]
	    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11

	    defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState$7(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last; // revert to the last existing entry

	      while (entry && entry.removed) entry = entry.previous; // get next entry


	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return {
	          value: undefined,
	          done: true
	        };
	      } // return step by kind


	      if (kind == 'keys') return {
	        value: entry.key,
	        done: false
	      };
	      if (kind == 'values') return {
	        value: entry.value,
	        done: false
	      };
	      return {
	        value: [entry.key, entry.value],
	        done: false
	      };
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // add [@@species], 23.1.2.2, 23.2.2.2

	    setSpecies(CONSTRUCTOR_NAME);
	  }
	};

	// https://tc39.github.io/ecma262/#sec-set-objects


	var es_set = collection('Set', function (init) {
	  return function Set() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	// https://tc39.github.io/ecma262/#sec-array.prototype.fill


	var arrayFill = function fill(value
	/* , start = 0, end = @length */
	) {
	  var O = toObject(this);
	  var length = toLength(O.length);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);

	  while (endPos > index) O[index++] = value;

	  return O;
	};

	// https://tc39.github.io/ecma262/#sec-array.prototype.fill

	_export({
	  target: 'Array',
	  proto: true
	}, {
	  fill: arrayFill
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('fill');

	var IGVGraphics = {
	  setProperties: function setProperties(ctx, properties) {
	    for (var key in properties) {
	      if (properties.hasOwnProperty(key)) {
	        var value = properties[key];
	        ctx[key] = value;
	      }
	    }
	  },
	  strokeLine: function strokeLine(ctx, x1, y1, x2, y2, properties) {
	    x1 = Math.floor(x1) + 0.5;
	    y1 = Math.floor(y1) + 0.5;
	    x2 = Math.floor(x2) + 0.5;
	    y2 = Math.floor(y2) + 0.5;

	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    ctx.beginPath();
	    ctx.moveTo(x1, y1);
	    ctx.lineTo(x2, y2);
	    ctx.stroke();
	    if (properties) ctx.restore();
	  },
	  fillRect: function fillRect(ctx, x, y, w, h, properties) {
	    x = Math.round(x);
	    y = Math.round(y);

	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    ctx.fillRect(x, y, w, h);
	    if (properties) ctx.restore();
	  },
	  fillPolygon: function fillPolygon(ctx, x, y, properties) {
	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    doPath(ctx, x, y);
	    ctx.fill();
	    if (properties) ctx.restore();
	  },
	  strokePolygon: function strokePolygon(ctx, x, y, properties) {
	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    doPath(ctx, x, y);
	    ctx.stroke();
	    if (properties) ctx.restore();
	  },
	  fillText: function fillText(ctx, text, x, y, properties, transforms) {
	    if (properties || transforms) {
	      ctx.save();
	    }

	    if (properties) {
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    if (transforms) {
	      // Slow path with context saving and extra translate
	      ctx.translate(x, y);

	      for (var transform in transforms) {
	        var value = transforms[transform]; // TODO: Add error checking for robustness

	        if (transform === 'translate') {
	          ctx.translate(value['x'], value['y']);
	        }

	        if (transform === 'rotate') {
	          ctx.rotate(value['angle'] * Math.PI / 180);
	        }
	      }

	      ctx.fillText(text, 0, 0);
	    } else {
	      ctx.fillText(text, x, y);
	    }

	    if (properties || transforms) ctx.restore();
	  },
	  strokeText: function strokeText(ctx, text, x, y, properties, transforms) {
	    if (properties || transforms) {
	      ctx.save();
	    }

	    if (properties) {
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    if (transforms) {
	      ctx.translate(x, y);

	      for (var transform in transforms) {
	        var value = transforms[transform]; // TODO: Add error checking for robustness

	        if (transform === 'translate') {
	          ctx.translate(value['x'], value['y']);
	        }

	        if (transform === 'rotate') {
	          ctx.rotate(value['angle'] * Math.PI / 180);
	        }
	      }

	      ctx.strokeText(text, 0, 0);
	    } else {
	      ctx.strokeText(text, x, y);
	    }

	    if (properties || transforms) ctx.restore();
	  },
	  strokeCircle: function strokeCircle(ctx, x, y, radius, properties) {
	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    ctx.beginPath();
	    ctx.arc(x, y, radius, 0, 2 * Math.PI);
	    ctx.stroke();
	    if (properties) ctx.restore();
	  },
	  fillCircle: function fillCircle(ctx, x, y, radius, properties) {
	    if (properties) {
	      ctx.save();
	      IGVGraphics.setProperties(ctx, properties);
	    }

	    ctx.beginPath();
	    ctx.arc(x, y, radius, 0, 2 * Math.PI);
	    ctx.fill();
	    if (properties) ctx.restore();
	  },
	  drawArrowhead: function drawArrowhead(ctx, x, y, size, lineWidth) {
	    ctx.save();

	    if (!size) {
	      size = 5;
	    }

	    if (lineWidth) {
	      ctx.lineWidth = lineWidth;
	    }

	    ctx.beginPath();
	    ctx.moveTo(x, y - size / 2);
	    ctx.lineTo(x, y + size / 2);
	    ctx.lineTo(x + size, y);
	    ctx.lineTo(x, y - size / 2);
	    ctx.closePath();
	    ctx.fill();
	    ctx.restore();
	  },
	  dashedLine: function dashedLine(ctx, x1, y1, x2, y2, dashLen) {
	    var properties = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {};
	    if (dashLen === undefined) dashLen = 2;
	    ctx.setLineDash([dashLen, dashLen]);
	    IGVGraphics.strokeLine(ctx, x1, y1, x2, y2, properties);
	    ctx.setLineDash([]);
	  },
	  roundRect: function roundRect(ctx, x, y, width, height, radius, fill, stroke) {
	    if (typeof stroke == "undefined") {
	      stroke = true;
	    }

	    if (typeof radius === "undefined") {
	      radius = 5;
	    }

	    ctx.beginPath();
	    ctx.moveTo(x + radius, y);
	    ctx.lineTo(x + width - radius, y);
	    ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
	    ctx.lineTo(x + width, y + height - radius);
	    ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
	    ctx.lineTo(x + radius, y + height);
	    ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
	    ctx.lineTo(x, y + radius);
	    ctx.quadraticCurveTo(x, y, x + radius, y);
	    ctx.closePath();

	    if (stroke) {
	      ctx.stroke();
	    }

	    if (fill) {
	      ctx.fill();
	    }
	  },
	  polygon: function polygon(ctx, x, y, fill, stroke) {
	    if (typeof stroke == "undefined") {
	      stroke = true;
	    }

	    ctx.beginPath();
	    var len = x.length;
	    ctx.moveTo(x[0], y[0]);

	    for (var i = 1; i < len; i++) {
	      ctx.lineTo(x[i], y[i]); // this.moveTo(x[i], y[i]);
	    }

	    ctx.closePath();

	    if (stroke) {
	      ctx.stroke();
	    }

	    if (fill) {
	      ctx.fill();
	    }
	  }
	};

	function doPath(ctx, x, y) {
	  var i,
	      len = x.length;

	  for (i = 0; i < len; i++) {
	    x[i] = Math.round(x[i]);
	    y[i] = Math.round(y[i]);
	  }

	  ctx.beginPath();
	  ctx.moveTo(x[0], y[0]);

	  for (i = 1; i < len; i++) {
	    ctx.lineTo(x[i], y[i]);
	  }

	  ctx.closePath();
	}

	var ViewportBase = /*#__PURE__*/function () {
	  function ViewportBase(trackView, $viewportContainer, referenceFrame, width) {
	    _classCallCheck(this, ViewportBase);

	    this.guid = guid();
	    this.trackView = trackView;
	    this.referenceFrame = referenceFrame;
	    this.browser = trackView.browser;
	    this.$viewport = $('<div class="igv-viewport">');
	    $viewportContainer.append(this.$viewport); // store the viewport GUID for later use

	    this.$viewport.data('viewportGUID', this.guid);
	    this.$content = $("<div>", {
	      class: 'igv-viewport-content'
	    });
	    this.$viewport.append(this.$content);
	    this.$content.height(this.$viewport.height());
	    this.contentDiv = this.$content.get(0);
	    this.$canvas = $('<canvas class ="igv-canvas">');
	    this.$content.append(this.$canvas);
	    this.canvas = this.$canvas.get(0);
	    this.ctx = this.canvas.getContext("2d");
	    this.setWidth(width);
	    this.initializationHelper();
	  }

	  _createClass(ViewportBase, [{
	    key: "initializationHelper",
	    value: function initializationHelper() {}
	  }, {
	    key: "setTrackLabel",
	    value: function setTrackLabel(label) {}
	  }, {
	    key: "startSpinner",
	    value: function startSpinner() {}
	  }, {
	    key: "stopSpinner",
	    value: function stopSpinner() {}
	  }, {
	    key: "checkZoomIn",
	    value: function checkZoomIn() {
	      return true;
	    }
	  }, {
	    key: "showMessage",
	    value: function showMessage(message) {
	      if (!this.messageDiv) {
	        this.messageDiv = document.createElement('div');
	        this.messageDiv.className = 'igv-viewport-message';
	        this.contentDiv.append(this.messageDiv);
	      }

	      this.messageDiv.textContent = message;
	      this.messageDiv.style.display = 'inline-block';
	    }
	  }, {
	    key: "hideMessage",
	    value: function hideMessage(message) {
	      if (this.messageDiv) this.messageDiv.style.display = 'none';
	    }
	  }, {
	    key: "renderSVGContext",
	    value: function () {
	      var _renderSVGContext = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(context, offset) {
	        var str, index, id, bbox, yScrollDelta, dx, dy, _this$$viewport$get$g, width, height;

	        return regeneratorRuntime.wrap(function _callee$(_context) {
	          while (1) {
	            switch (_context.prev = _context.next) {
	              case 0:
	                if (!(this.$zoomInNotice && this.$zoomInNotice.is(":visible"))) {
	                  _context.next = 2;
	                  break;
	                }

	                return _context.abrupt("return");

	              case 2:
	                str = this.trackView.track.name || this.trackView.track.id;
	                str = str.replace(/\W/g, '');
	                index = this.browser.referenceFrameList.indexOf(this.referenceFrame);
	                id = str.toLowerCase() + '_genomic_state_index_' + index; // If present, paint axis canvas. Only in first multi-locus panel.

	                if (0 === index && typeof this.trackView.track.paintAxis === 'function') {
	                  bbox = this.trackView.controlCanvas.getBoundingClientRect();
	                  context.addTrackGroupWithTranslationAndClipRect(id + '_axis', offset.deltaX - bbox.width, offset.deltaY, bbox.width, bbox.height, 0);
	                  context.save();
	                  this.trackView.track.paintAxis(context, bbox.width, bbox.height);
	                  context.restore();
	                }

	                yScrollDelta = $(this.contentDiv).position().top;
	                dx = offset.deltaX + index * context.multiLocusGap;
	                dy = offset.deltaY + yScrollDelta;
	                _this$$viewport$get$g = this.$viewport.get(0).getBoundingClientRect(), width = _this$$viewport$get$g.width, height = _this$$viewport$get$g.height;
	                context.addTrackGroupWithTranslationAndClipRect(id, dx, dy, width, height, -yScrollDelta); // console.log(`ViewportBase render SVG. context.addGroup( id ${ id } dx ${ dx } dy ${ dy } width ${ width } height ${ height } -yScrollDelta ${ -yScrollDelta })`)

	                this.drawSVGWithContect(context, width, height);

	              case 13:
	              case "end":
	                return _context.stop();
	            }
	          }
	        }, _callee, this);
	      }));

	      function renderSVGContext(_x, _x2) {
	        return _renderSVGContext.apply(this, arguments);
	      }

	      return renderSVGContext;
	    }()
	  }, {
	    key: "drawSVGWithContect",
	    value: function drawSVGWithContect(context) {}
	  }, {
	    key: "saveSVG",
	    value: function saveSVG() {}
	  }, {
	    key: "isVisible",
	    value: function isVisible() {
	      return this.$viewport.width();
	    }
	  }, {
	    key: "setWidth",
	    value: function setWidth(width) {
	      this.$viewport.width(width);
	      this.canvas.style.width = "".concat(width, "px");
	      this.canvas.setAttribute('width', width);
	    }
	  }, {
	    key: "getWidth",
	    value: function getWidth() {
	      return this.$viewport.width();
	    }
	  }, {
	    key: "shift",
	    value: function shift() {}
	  }, {
	    key: "setTop",
	    value: function setTop(contentTop) {}
	  }, {
	    key: "loadFeatures",
	    value: function () {
	      var _loadFeatures = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	        return regeneratorRuntime.wrap(function _callee2$(_context2) {
	          while (1) {
	            switch (_context2.prev = _context2.next) {
	              case 0:
	                return _context2.abrupt("return", undefined);

	              case 1:
	              case "end":
	                return _context2.stop();
	            }
	          }
	        }, _callee2);
	      }));

	      function loadFeatures() {
	        return _loadFeatures.apply(this, arguments);
	      }

	      return loadFeatures;
	    }()
	  }, {
	    key: "setContentHeight",
	    value: function setContentHeight(contentHeight) {}
	  }, {
	    key: "isLoading",
	    value: function isLoading() {
	      return false;
	    }
	  }, {
	    key: "getContentHeight",
	    value: function getContentHeight() {
	      return this.$content.height();
	    }
	  }, {
	    key: "getContentTop",
	    value: function getContentTop() {
	      return this.contentDiv.offsetTop;
	    }
	  }, {
	    key: "containsPosition",
	    value: function containsPosition(chr, position) {
	      if (this.referenceFrame.chr === chr && position >= this.referenceFrame.start) {
	        return position <= this.referenceFrame.calculateEnd(this.getWidth());
	      } else {
	        return false;
	      }
	    }
	    /**
	     * Called when the associated track is removed.  Do any needed cleanup here.
	     */

	  }, {
	    key: "dispose",
	    value: function dispose() {
	      if (this.popover) {
	        this.popover.dispose();
	      }

	      this.$canvas.off();
	      this.$canvas.empty();
	      this.$content.off();
	      this.$content.empty();
	      this.$viewport.off();
	      this.$viewport.empty(); // Null out all properties -- this should not be neccessary, but just in case there is a
	      // reference to self somewhere we want to free memory.

	      for (var _i = 0, _Object$keys = Object.keys(this); _i < _Object$keys.length; _i++) {
	        var key = _Object$keys[_i];
	        this[key] = undefined;
	      }
	    }
	  }]);

	  return ViewportBase;
	}();

	/*!!
	 *  Canvas 2 Svg v1.0.19
	 *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
	 *
	 *  Licensed under the MIT license:
	 *  http://www.opensource.org/licenses/mit-license.php
	 *
	 *  Author:
	 *  Kerry Liu
	 *
	 *  Copyright (c) 2014 Gliffy Inc.
	 */

	var STYLES, _ctx, CanvasGradient, CanvasPattern, namedEntities; //helper function to format a string


	function format(str, args) {
	  var keys = Object.keys(args),
	      i;

	  for (i = 0; i < keys.length; i++) {
	    str = str.replace(new RegExp("\\{" + keys[i] + "\\}", "gi"), args[keys[i]]);
	  }

	  return str;
	} //helper function that generates a random string


	function randomString(holder) {
	  var chars, randomstring, i;

	  if (!holder) {
	    throw new Error("cannot create a random attribute name for an undefined object");
	  }

	  chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
	  randomstring = "";

	  do {
	    randomstring = "";

	    for (i = 0; i < 12; i++) {
	      randomstring += chars[Math.floor(Math.random() * chars.length)];
	    }
	  } while (holder[randomstring]);

	  return randomstring;
	} //helper function to map named to numbered entities


	function createNamedToNumberedLookup(items, radix) {
	  var i,
	      entity,
	      lookup = {},
	      base10;
	  items = items.split(',');
	  radix = radix || 10; // Map from named to numbered entities.

	  for (i = 0; i < items.length; i += 2) {
	    entity = '&' + items[i + 1] + ';';
	    base10 = parseInt(items[i], radix);
	    lookup[entity] = '&#' + base10 + ';';
	  } //FF and IE need to create a regex from hex values ie &nbsp; == \xa0


	  lookup["\\xa0"] = '&#160;';
	  return lookup;
	} //helper function to map canvas-textAlign to svg-textAnchor


	function getTextAnchor(textAlign) {
	  //TODO: support rtl languages
	  var mapping = {
	    "left": "start",
	    "right": "end",
	    "center": "middle",
	    "start": "start",
	    "end": "end"
	  };
	  return mapping[textAlign] || mapping.start;
	} //helper function to map canvas-textBaseline to svg-dominantBaseline


	function getDominantBaseline(textBaseline) {
	  //INFO: not supported in all browsers
	  var mapping = {
	    "alphabetic": "alphabetic",
	    "hanging": "hanging",
	    "top": "text-before-edge",
	    "bottom": "text-after-edge",
	    "middle": "central"
	  };
	  return mapping[textBaseline] || mapping.alphabetic;
	} // Unpack entities lookup where the numbers are in radix 32 to reduce the size
	// entity mapping courtesy of tinymce


	namedEntities = createNamedToNumberedLookup('50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' + '5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' + '5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' + '5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' + '68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' + '6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' + '6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' + '75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' + '7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' + '7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' + 'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' + 'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' + 't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' + 'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' + 'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' + '81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' + '8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' + '8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' + '8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' + '8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' + 'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' + 'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' + 'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' + '80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' + '811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro', 32); //Some basic mappings for attributes and default values.

	STYLES = {
	  "strokeStyle": {
	    svgAttr: "stroke",
	    //corresponding svg attribute
	    canvas: "#000000",
	    //canvas default
	    svg: "none",
	    //svg default
	    apply: "stroke" //apply on stroke() or fill()

	  },
	  "fillStyle": {
	    svgAttr: "fill",
	    canvas: "#000000",
	    svg: null,
	    //svg default is black, but we need to special case this to handle canvas stroke without fill
	    apply: "fill"
	  },
	  "lineCap": {
	    svgAttr: "stroke-linecap",
	    canvas: "butt",
	    svg: "butt",
	    apply: "stroke"
	  },
	  "lineJoin": {
	    svgAttr: "stroke-linejoin",
	    canvas: "miter",
	    svg: "miter",
	    apply: "stroke"
	  },
	  "miterLimit": {
	    svgAttr: "stroke-miterlimit",
	    canvas: 10,
	    svg: 4,
	    apply: "stroke"
	  },
	  "lineWidth": {
	    svgAttr: "stroke-width",
	    canvas: 1,
	    svg: 1,
	    apply: "stroke"
	  },
	  "globalAlpha": {
	    svgAttr: "opacity",
	    canvas: 1,
	    svg: 1,
	    apply: "fill stroke"
	  },
	  "font": {
	    //font converts to multiple svg attributes, there is custom logic for this
	    canvas: "10px sans-serif"
	  },
	  "shadowColor": {
	    canvas: "#000000"
	  },
	  "shadowOffsetX": {
	    canvas: 0
	  },
	  "shadowOffsetY": {
	    canvas: 0
	  },
	  "shadowBlur": {
	    canvas: 0
	  },
	  "textAlign": {
	    canvas: "start"
	  },
	  "textBaseline": {
	    canvas: "alphabetic"
	  },
	  "lineDash": {
	    svgAttr: "stroke-dasharray",
	    canvas: [],
	    svg: null,
	    apply: "stroke"
	  }
	};
	/**
	 *
	 * @param gradientNode - reference to the gradient
	 * @constructor
	 */

	CanvasGradient = function CanvasGradient(gradientNode, ctx) {
	  this.__root = gradientNode;
	  this.__ctx = ctx;
	};
	/**
	 * Adds a color stop to the gradient root
	 */


	CanvasGradient.prototype.addColorStop = function (offset, color) {
	  var stop = this.__ctx.__createElement("stop"),
	      regex,
	      matches;

	  stop.setAttribute("offset", offset);

	  if (color && color.indexOf("rgba") !== -1) {
	    //separate alpha value, since webkit can't handle it
	    regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
	    matches = regex.exec(color);
	    stop.setAttribute("stop-color", format("rgb({r},{g},{b})", {
	      r: matches[1],
	      g: matches[2],
	      b: matches[3]
	    }));
	    stop.setAttribute("stop-opacity", matches[4]);
	  } else {
	    stop.setAttribute("stop-color", color);
	  }

	  this.__root.appendChild(stop);
	};

	CanvasPattern = function CanvasPattern(pattern, ctx) {
	  this.__root = pattern;
	  this.__ctx = ctx;
	};
	/**
	 * The mock canvas context
	 * @param config - options include:
	 * ctx - existing Context2D to wrap around
	 * width - width of your canvas (defaults to 500)
	 * height - height of your canvas (defaults to 500)
	 * enableMirroring - enables canvas mirroring (get image data) (defaults to false)
	 * document - the document object (defaults to the current document)
	 */


	_ctx = function ctx(config) {
	  if (!(this instanceof _ctx)) {
	    //did someone call this without new?
	    return new _ctx(config);
	  } // clone config


	  this.config = config; //setup options

	  this.width = config.width;
	  this.height = config.height;
	  this.enableMirroring = config.enableMirroring || false;
	  this.canvas = this; ///point back to this instance!

	  this.__document = document; // allow passing in an existing context to wrap around
	  // if a context is passed in, we know a canvas already exist

	  if (config.ctx) {
	    this.__ctx = config.ctx;
	  } else {
	    this.__canvas = this.__document.createElement("canvas");
	    this.__ctx = this.__canvas.getContext("2d");
	  } // give this canvas a type


	  this.isSVG = true;

	  this.__setDefaultStyles();

	  this.__stack = [this.__getStyleState()];
	  this.__groupStack = []; // root svg element

	  this.__root = this.__createElement("svg");

	  this.__root.setAttribute("width", this.width);

	  this.__root.setAttribute("height", this.height); // allow contents to overflow svg bbox


	  this.__root.setAttribute('overflow', 'visible'); // viewbox


	  if (config.viewbox) {
	    var str = config.viewbox.x + ' ' + config.viewbox.y + ' ' + config.viewbox.width + ' ' + config.viewbox.height;

	    this.__root.setAttribute("viewBox", str);

	    this.viewbox = config.viewbox;
	  } // make sure we don't generate the same ids in defs


	  this.__ids = {}; // defs

	  this.__defs = this.__createElement("defs");

	  this.__root.appendChild(this.__defs);

	  this.multiLocusGap = config.multiLocusGap; // svg background color

	  var backdropConfig = {
	    id: 'svg_output_backdrop',
	    width: '100%',
	    height: '100%',
	    fill: config.backdropColor || 'white'
	  };

	  var backdropRect = this.__createElement('rect', backdropConfig);

	  this.__root.appendChild(backdropRect); // root group


	  this.__rootGroup = this.__createElement('g', {
	    id: 'root-group'
	  });

	  this.__root.appendChild(this.__rootGroup); // point current element to root group


	  this.__currentElement = this.__rootGroup;
	};

	_ctx.prototype.setWidth = function (width) {
	  this.width = width;

	  this.__root.setAttribute("width", this.width);

	  var str = this.config.viewbox.x + ' ' + this.config.viewbox.y + ' ' + width + ' ' + this.config.viewbox.height;

	  this.__root.setAttribute("viewBox", str);
	};

	_ctx.prototype.setHeight = function (height) {
	  this.height = height;

	  this.__root.setAttribute("height", this.height);

	  var str = this.config.viewbox.x + ' ' + this.config.viewbox.y + ' ' + this.config.viewbox.width + ' ' + height;

	  this.__root.setAttribute("viewBox", str);
	};
	/**
	 * Creates the specified svg element
	 * @private
	 */


	_ctx.prototype.__createElement = function (elementName, properties, resetFill) {
	  if (typeof properties === "undefined") {
	    properties = {};
	  }

	  var element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);

	  if (resetFill) {
	    //if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
	    element.setAttribute("fill", "none");
	    element.setAttribute("stroke", "none");
	  }

	  for (var _i = 0, _Object$keys = Object.keys(properties); _i < _Object$keys.length; _i++) {
	    var key = _Object$keys[_i];
	    element.setAttribute(key, properties[key]);
	  }

	  return element;
	};
	/**
	 * Applies default canvas styles to the context
	 * @private
	 */


	_ctx.prototype.__setDefaultStyles = function () {
	  //default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
	  var keys = Object.keys(STYLES),
	      i,
	      key;

	  for (i = 0; i < keys.length; i++) {
	    key = keys[i];
	    this[key] = STYLES[key].canvas;
	  }
	};
	/**
	 * Applies styles on restore
	 * @param styleState
	 * @private
	 */


	_ctx.prototype.__applyStyleState = function (styleState) {
	  var keys = Object.keys(styleState),
	      i,
	      key;

	  for (i = 0; i < keys.length; i++) {
	    key = keys[i];
	    this[key] = styleState[key];
	  }
	};
	/**
	 * Gets the current style state
	 * @return {Object}
	 * @private
	 */


	_ctx.prototype.__getStyleState = function () {
	  var i,
	      styleState = {},
	      keys = Object.keys(STYLES),
	      key;

	  for (i = 0; i < keys.length; i++) {
	    key = keys[i];
	    styleState[key] = this[key];
	  }

	  return styleState;
	};
	/**
	 * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
	 * @param type
	 * @private
	 */


	_ctx.prototype.__applyStyleToCurrentElement = function (type) {
	  var currentElement = this.__currentElement;
	  var currentStyleGroup = this.__currentElementsToStyle;

	  if (currentStyleGroup) {
	    currentElement.setAttribute(type, "");
	    currentElement = currentStyleGroup.element;
	    currentStyleGroup.children.forEach(function (node) {
	      node.setAttribute(type, "");
	    });
	  }

	  var keys = Object.keys(STYLES),
	      i,
	      style,
	      value,
	      id,
	      regex,
	      matches;

	  for (i = 0; i < keys.length; i++) {
	    style = STYLES[keys[i]];
	    value = this[keys[i]];

	    if (style.apply) {
	      //is this a gradient or pattern?
	      if (value instanceof CanvasPattern) {
	        //pattern
	        if (value.__ctx) {
	          //copy over defs
	          while (value.__ctx.__defs.childNodes.length) {
	            id = value.__ctx.__defs.childNodes[0].getAttribute("id");
	            this.__ids[id] = id;

	            this.__defs.appendChild(value.__ctx.__defs.childNodes[0]);
	          }
	        }

	        currentElement.setAttribute(style.apply, format("url(#{id})", {
	          id: value.__root.getAttribute("id")
	        }));
	      } else if (value instanceof CanvasGradient) {
	        //gradient
	        currentElement.setAttribute(style.apply, format("url(#{id})", {
	          id: value.__root.getAttribute("id")
	        }));
	      } else if (style && style.apply.indexOf(type) !== -1 && style.svg !== value) {
	        if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && value && value.indexOf("rgba") !== -1) {
	          //separate alpha value, since illustrator can't handle it
	          regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
	          matches = regex.exec(value);
	          currentElement.setAttribute(style.svgAttr, format("rgb({r},{g},{b})", {
	            r: matches[1],
	            g: matches[2],
	            b: matches[3]
	          })); //should take globalAlpha here

	          var opacity = matches[4];
	          var globalAlpha = this.globalAlpha;

	          if (globalAlpha != null) {
	            opacity *= globalAlpha;
	          }

	          currentElement.setAttribute(style.svgAttr + "-opacity", opacity);
	        } else {
	          var attr = style.svgAttr;

	          if (keys[i] === 'globalAlpha') {
	            attr = type + '-' + style.svgAttr;

	            if (currentElement.getAttribute(attr)) {
	              //fill-opacity or stroke-opacity has already been set by stroke or fill.
	              continue;
	            }
	          } //otherwise only update attribute if right type, and not svg default


	          currentElement.setAttribute(attr, value);
	        }
	      }
	    }
	  }
	};
	/**
	 * Will return the closest group or svg node. May return the current element.
	 * @private
	 */


	_ctx.prototype.__closestGroupOrSvg = function (node) {
	  node = node || this.__currentElement;

	  if (node.nodeName === "g" || node.nodeName === "svg") {
	    return node;
	  } else {
	    return this.__closestGroupOrSvg(node.parentNode);
	  }
	};
	/**
	 * Returns the serialized value of the svg so far
	 * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
	 *                           If true, we attempt to find all named entities and encode it as a numeric entity.
	 * @return serialized svg
	 */


	_ctx.prototype.getSerializedSvg = function (fixNamedEntities) {
	  var serialized = new XMLSerializer().serializeToString(this.__root),
	      keys,
	      i,
	      key,
	      value,
	      regexp;
	 //IE search for a duplicate xmnls because they didn't implement setAttributeNS correctly
	  // xmlns = /xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;
	  // if (xmlns.test(serialized)) {
	  //     serialized = serialized.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink');
	  // }

	  if (fixNamedEntities) {
	    keys = Object.keys(namedEntities); //loop over each named entity and replace with the proper equivalent.

	    for (i = 0; i < keys.length; i++) {
	      key = keys[i];
	      value = namedEntities[key];
	      regexp = new RegExp(key, "gi");

	      if (regexp.test(serialized)) {
	        serialized = serialized.replace(regexp, value);
	      }
	    }
	  }

	  return serialized;
	};
	/**
	 * Returns the root svg
	 * @return
	 */


	_ctx.prototype.getSvg = function () {
	  return this.__root;
	};
	/**
	 * Will generate a group tag.
	 */


	_ctx.prototype.save = function () {
	  var group = this.__createElement("g");

	  var parent = this.__closestGroupOrSvg();

	  this.__groupStack.push(parent);

	  parent.appendChild(group);
	  this.__currentElement = group;

	  this.__stack.push(this.__getStyleState());
	};
	/**
	 * Sets current element to parent, or just root if already root
	 */


	_ctx.prototype.restore = function () {
	  this.__currentElement = this.__groupStack.pop();
	  this.__currentElementsToStyle = null; //Clearing canvas will make the poped group invalid, currentElement is set to the root group node.

	  if (!this.__currentElement) {
	    this.__currentElement = this.__root.childNodes[1];
	  }

	  var state = this.__stack.pop();

	  this.__applyStyleState(state);
	};
	/**
	 * Helper method to add transform
	 * @private
	 */


	_ctx.prototype.__addTransform = function (t) {
	  //if the current element has siblings, add another group
	  var parent = this.__closestGroupOrSvg();

	  if (parent.childNodes.length > 0) {
	    if (this.__currentElement.nodeName === "path") {
	      if (!this.__currentElementsToStyle) this.__currentElementsToStyle = {
	        element: parent,
	        children: []
	      };

	      this.__currentElementsToStyle.children.push(this.__currentElement);

	      this.__applyCurrentDefaultPath();
	    }

	    var group = this.__createElement("g");

	    parent.appendChild(group);
	    this.__currentElement = group;
	  }

	  var transform = this.__currentElement.getAttribute("transform");

	  if (transform) {
	    transform += " ";
	  } else {
	    transform = "";
	  }

	  transform += t;

	  this.__currentElement.setAttribute("transform", transform);
	};

	_ctx.prototype.addTrackGroupWithTranslationAndClipRect = function (id, tx, ty, width, height, clipYOffset) {
	  // clip rect
	  var clip_id = id + '_clip_rect';

	  var clipPath = this.__createElement('clipPath', {
	    id: clip_id
	  });

	  this.__defs.appendChild(clipPath);

	  clipPath.appendChild(this.__createElement('rect', {
	    x: '0',
	    y: clipYOffset.toString(),
	    width: width.toString(),
	    height: height.toString()
	  }));

	  var group = this.__createElement('g');

	  this.__rootGroup.appendChild(group);

	  group.setAttribute('transform', format('translate({x},{y})', {
	    x: tx,
	    y: ty
	  }));
	  group.setAttribute('id', id + '_group'); // add clip rect

	  group.setAttribute('clip-path', format('url(#{id})', {
	    id: clip_id
	  }));
	  this.__currentElement = group;
	};
	/**
	 *  scales the current element
	 */


	_ctx.prototype.scale = function (x, y) {
	  if (y === undefined) {
	    y = x;
	  }

	  this.__addTransform(format("scale({x},{y})", {
	    x: x,
	    y: y
	  }));
	};
	/**
	 * rotates the current element
	 */


	_ctx.prototype.rotate = function (angle) {
	  var degrees = angle * 180 / Math.PI;

	  this.__addTransform(format("rotate({angle},{cx},{cy})", {
	    angle: degrees,
	    cx: 0,
	    cy: 0
	  }));
	};
	/**
	 * translates the current element
	 */


	_ctx.prototype.translate = function (x, y) {
	  this.__addTransform(format("translate({x},{y})", {
	    x: x,
	    y: y
	  }));
	};
	/**
	 * applies a transform to the current element
	 */


	_ctx.prototype.transform = function (a, b, c, d, e, f) {
	  this.__addTransform(format("matrix({a},{b},{c},{d},{e},{f})", {
	    a: a,
	    b: b,
	    c: c,
	    d: d,
	    e: e,
	    f: f
	  }));
	};
	/**
	 * Create a new Path Element
	 */


	_ctx.prototype.beginPath = function () {
	  var path, parent; // Note that there is only one current default path, it is not part of the drawing state.
	  // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path

	  this.__currentDefaultPath = "";
	  this.__currentPosition = {};
	  path = this.__createElement("path", {}, true);
	  parent = this.__closestGroupOrSvg();
	  parent.appendChild(path);
	  this.__currentElement = path;
	};
	/**
	 * Helper function to apply currentDefaultPath to current path element
	 * @private
	 */


	_ctx.prototype.__applyCurrentDefaultPath = function () {
	  var currentElement = this.__currentElement;

	  if (currentElement.nodeName === "path") {
	    currentElement.setAttribute("d", this.__currentDefaultPath);
	  } else {
	    console.error("Attempted to apply path command to node", currentElement.nodeName);
	  }
	};
	/**
	 * Helper function to add path command
	 * @private
	 */


	_ctx.prototype.__addPathCommand = function (command) {
	  this.__currentDefaultPath += " ";
	  this.__currentDefaultPath += command;
	};
	/**
	 * Adds the move command to the current path element,
	 * if the currentPathElement is not empty create a new path element
	 */


	_ctx.prototype.moveTo = function (x, y) {
	  if (this.__currentElement.nodeName !== "path") {
	    this.beginPath();
	  } // creates a new subpath with the given point


	  this.__currentPosition = {
	    x: x,
	    y: y
	  };

	  this.__addPathCommand(format("M {x} {y}", {
	    x: x,
	    y: y
	  }));
	};
	/**
	 * Closes the current path
	 */


	_ctx.prototype.closePath = function () {
	  if (this.__currentDefaultPath) {
	    this.__addPathCommand("Z");
	  }
	};
	/**
	 * Adds a line to command
	 */


	_ctx.prototype.lineTo = function (x, y) {
	  this.__currentPosition = {
	    x: x,
	    y: y
	  };

	  if (this.__currentDefaultPath && this.__currentDefaultPath.indexOf('M') > -1) {
	    this.__addPathCommand(format("L {x} {y}", {
	      x: x,
	      y: y
	    }));
	  } else {
	    this.__addPathCommand(format("M {x} {y}", {
	      x: x,
	      y: y
	    }));
	  }
	};
	/**
	 * Add a bezier command
	 */


	_ctx.prototype.bezierCurveTo = function (cp1x, cp1y, cp2x, cp2y, x, y) {
	  this.__currentPosition = {
	    x: x,
	    y: y
	  };

	  this.__addPathCommand(format("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}", {
	    cp1x: cp1x,
	    cp1y: cp1y,
	    cp2x: cp2x,
	    cp2y: cp2y,
	    x: x,
	    y: y
	  }));
	};
	/**
	 * Adds a quadratic curve to command
	 */


	_ctx.prototype.quadraticCurveTo = function (cpx, cpy, x, y) {
	  this.__currentPosition = {
	    x: x,
	    y: y
	  };

	  this.__addPathCommand(format("Q {cpx} {cpy} {x} {y}", {
	    cpx: cpx,
	    cpy: cpy,
	    x: x,
	    y: y
	  }));
	};
	/**
	 * Return a new normalized vector of given vector
	 */


	var normalize$1 = function normalize(vector) {
	  var len = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
	  return [vector[0] / len, vector[1] / len];
	};
	/**
	 * Adds the arcTo to the current path
	 *
	 * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
	 */


	_ctx.prototype.arcTo = function (x1, y1, x2, y2, radius) {
	  // Let the point (x0, y0) be the last point in the subpath.
	  var x0 = this.__currentPosition && this.__currentPosition.x;
	  var y0 = this.__currentPosition && this.__currentPosition.y; // First ensure there is a subpath for (x1, y1).

	  if (typeof x0 == "undefined" || typeof y0 == "undefined") {
	    return;
	  } // Negative values for radius must cause the implementation to throw an IndexSizeError exception.


	  if (radius < 0) {
	    throw new Error("IndexSizeError: The radius provided (" + radius + ") is negative.");
	  } // If the point (x0, y0) is equal to the point (x1, y1),
	  // or if the point (x1, y1) is equal to the point (x2, y2),
	  // or if the radius radius is zero,
	  // then the method must add the point (x1, y1) to the subpath,
	  // and connect that point to the previous point (x0, y0) by a straight line.


	  if (x0 === x1 && y0 === y1 || x1 === x2 && y1 === y2 || radius === 0) {
	    this.lineTo(x1, y1);
	    return;
	  } // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
	  // then the method must add the point (x1, y1) to the subpath,
	  // and connect that point to the previous point (x0, y0) by a straight line.


	  var unit_vec_p1_p0 = normalize$1([x0 - x1, y0 - y1]);
	  var unit_vec_p1_p2 = normalize$1([x2 - x1, y2 - y1]);

	  if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
	    this.lineTo(x1, y1);
	    return;
	  } // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
	  // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
	  // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
	  // The points at which this circle touches these two lines are called the start and end tangent points respectively.
	  // note that both vectors are unit vectors, so the length is 1


	  var cos = unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1];
	  var theta = Math.acos(Math.abs(cos)); // Calculate origin

	  var unit_vec_p1_origin = normalize$1([unit_vec_p1_p0[0] + unit_vec_p1_p2[0], unit_vec_p1_p0[1] + unit_vec_p1_p2[1]]);
	  var len_p1_origin = radius / Math.sin(theta / 2);
	  var x = x1 + len_p1_origin * unit_vec_p1_origin[0];
	  var y = y1 + len_p1_origin * unit_vec_p1_origin[1]; // Calculate start angle and end angle
	  // rotate 90deg clockwise (note that y axis points to its down)

	  var unit_vec_origin_start_tangent = [-unit_vec_p1_p0[1], unit_vec_p1_p0[0]]; // rotate 90deg counter clockwise (note that y axis points to its down)

	  var unit_vec_origin_end_tangent = [unit_vec_p1_p2[1], -unit_vec_p1_p2[0]];

	  var getAngle = function getAngle(vector) {
	    // get angle (clockwise) between vector and (1, 0)
	    var x = vector[0];
	    var y = vector[1];

	    if (y >= 0) {
	      // note that y axis points to its down
	      return Math.acos(x);
	    } else {
	      return -Math.acos(x);
	    }
	  };

	  var startAngle = getAngle(unit_vec_origin_start_tangent);
	  var endAngle = getAngle(unit_vec_origin_end_tangent); // Connect the point (x0, y0) to the start tangent point by a straight line

	  this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius); // Connect the start tangent point to the end tangent point by arc
	  // and adding the end tangent point to the subpath.

	  this.arc(x, y, radius, startAngle, endAngle);
	};
	/**
	 * Sets the stroke property on the current element
	 */


	_ctx.prototype.stroke = function () {
	  if (this.__currentElement.nodeName === "path") {
	    this.__currentElement.setAttribute("paint-order", "fill stroke markers");
	  }

	  this.__applyCurrentDefaultPath();

	  this.__applyStyleToCurrentElement("stroke");
	};
	/**
	 * Sets fill properties on the current element
	 */


	_ctx.prototype.fill = function () {
	  if (this.__currentElement.nodeName === "path") {
	    this.__currentElement.setAttribute("paint-order", "stroke fill markers");
	  }

	  this.__applyCurrentDefaultPath();

	  this.__applyStyleToCurrentElement("fill");
	};
	/**
	 *  Adds a rectangle to the path.
	 */


	_ctx.prototype.rect = function (x, y, width, height) {
	  if (this.__currentElement.nodeName !== "path") {
	    this.beginPath();
	  }

	  this.moveTo(x, y);
	  this.lineTo(x + width, y);
	  this.lineTo(x + width, y + height);
	  this.lineTo(x, y + height);
	  this.lineTo(x, y);
	  this.closePath();
	};
	/**
	 * adds a rectangle element
	 */


	_ctx.prototype.fillRect = function (x, y, width, height) {
	  if (height < 0) {
	    y += height;
	    height = -height;
	  }

	  if (width < 0) {
	    x += width;
	    width = -width;
	  } // See if rect instersects current viewbox


	  var r2 = {
	    x: x,
	    y: y,
	    width: width,
	    height: height
	  };

	  if (this.viewbox) {
	    if (!intersectRect(this.viewbox, r2)) {
	      return;
	    }
	  }

	  var rect, parent;
	  rect = this.__createElement("rect", r2, true);
	  parent = this.__closestGroupOrSvg();
	  parent.appendChild(rect);
	  this.__currentElement = rect;

	  this.__applyStyleToCurrentElement("fill");
	};

	function intersectRect(rect1, rect2) {
	  return rect1.x < rect2.x + rect2.width && rect1.x + rect1.width > rect2.x && rect1.y < rect2.y + rect2.height && rect1.y + rect1.height > rect2.y;
	}
	/**
	 * Draws a rectangle with no fill
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */


	_ctx.prototype.strokeRect = function (x, y, width, height) {
	  var rect, parent;
	  rect = this.__createElement("rect", {
	    x: x,
	    y: y,
	    width: width,
	    height: height
	  }, true);
	  parent = this.__closestGroupOrSvg();
	  parent.appendChild(rect);
	  this.__currentElement = rect;

	  this.__applyStyleToCurrentElement("stroke");
	};
	/**
	 * Clear entire canvas:
	 * 1. save current transforms
	 * 2. remove all the childNodes of the root g element
	 */


	_ctx.prototype.__clearCanvas = function () {
	  var current = this.__closestGroupOrSvg(),
	      transform = current.getAttribute("transform");

	  var rootGroup = this.__root.childNodes[1];
	  var childNodes = rootGroup.childNodes;

	  for (var i = childNodes.length - 1; i >= 0; i--) {
	    if (childNodes[i]) {
	      rootGroup.removeChild(childNodes[i]);
	    }
	  }

	  this.__currentElement = rootGroup; //reset __groupStack as all the child group nodes are all removed.

	  this.__groupStack = [];

	  if (transform) {
	    this.__addTransform(transform);
	  }
	};
	/**
	 * "Clears" a canvas by just drawing a white rectangle in the current group.
	 */


	_ctx.prototype.clearRect = function (x, y, width, height) {
	  //clear entire canvas
	  if (x === 0 && y === 0 && width === this.width && height === this.height) {
	    this.__clearCanvas();

	    return;
	  }

	  var rect,
	      parent = this.__closestGroupOrSvg();

	  rect = this.__createElement("rect", {
	    x: x,
	    y: y,
	    width: width,
	    height: height,
	    fill: "#FFFFFF"
	  }, true);
	  parent.appendChild(rect);
	};
	/**
	 * Adds a linear gradient to a defs tag.
	 * Returns a canvas gradient object that has a reference to it's parent def
	 */


	_ctx.prototype.createLinearGradient = function (x1, y1, x2, y2) {
	  var grad = this.__createElement("linearGradient", {
	    id: randomString(this.__ids),
	    x1: x1 + "px",
	    x2: x2 + "px",
	    y1: y1 + "px",
	    y2: y2 + "px",
	    "gradientUnits": "userSpaceOnUse"
	  }, false);

	  this.__defs.appendChild(grad);

	  return new CanvasGradient(grad, this);
	};
	/**
	 * Adds a radial gradient to a defs tag.
	 * Returns a canvas gradient object that has a reference to it's parent def
	 */


	_ctx.prototype.createRadialGradient = function (x0, y0, r0, x1, y1, r1) {
	  var grad = this.__createElement("radialGradient", {
	    id: randomString(this.__ids),
	    cx: x1 + "px",
	    cy: y1 + "px",
	    r: r1 + "px",
	    fx: x0 + "px",
	    fy: y0 + "px",
	    "gradientUnits": "userSpaceOnUse"
	  }, false);

	  this.__defs.appendChild(grad);

	  return new CanvasGradient(grad, this);
	};
	/**
	 * Parses the font string and returns svg mapping
	 * @private
	 */


	_ctx.prototype.__parseFont = function () {
	  var regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
	  var fontPart = regex.exec(this.font);
	  var data = {
	    style: fontPart[1] || 'normal',
	    size: fontPart[4] || '10px',
	    family: fontPart[6] || 'sans-serif',
	    weight: fontPart[3] || 'normal',
	    decoration: fontPart[2] || 'normal',
	    href: null
	  }; //canvas doesn't support underline natively, but we can pass this attribute

	  if (this.__fontUnderline === "underline") {
	    data.decoration = "underline";
	  } //canvas also doesn't support linking, but we can pass this as well


	  if (this.__fontHref) {
	    data.href = this.__fontHref;
	  }

	  return data;
	};
	/**
	 * Helper to link text fragments
	 * @param font
	 * @param element
	 * @return {*}
	 * @private
	 */


	_ctx.prototype.__wrapTextLink = function (font, element) {
	  if (font.href) {
	    var a = this.__createElement("a");

	    a.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", font.href);
	    a.appendChild(element);
	    return a;
	  }

	  return element;
	};
	/**
	 * Fills or strokes text
	 * @param text
	 * @param x
	 * @param y
	 * @param action - stroke or fill
	 * @private
	 */


	_ctx.prototype.__applyText = function (text, x, y, action) {
	  var font = this.__parseFont(),
	      parent = this.__closestGroupOrSvg(),
	      textElement = this.__createElement("text", {
	    "font-family": font.family,
	    "font-size": font.size,
	    "font-style": font.style,
	    "font-weight": font.weight,
	    "text-decoration": font.decoration,
	    "x": x,
	    "y": y,
	    "text-anchor": getTextAnchor(this.textAlign),
	    "dominant-baseline": getDominantBaseline(this.textBaseline)
	  }, true);

	  textElement.appendChild(this.__document.createTextNode(text));
	  this.__currentElement = textElement;

	  this.__applyStyleToCurrentElement(action);

	  parent.appendChild(this.__wrapTextLink(font, textElement));
	};
	/**
	 * Creates a text element
	 * @param text
	 * @param x
	 * @param y
	 */


	_ctx.prototype.fillText = function (text, x, y) {
	  this.__applyText(text, x, y, "fill");
	};
	/**
	 * Strokes text
	 * @param text
	 * @param x
	 * @param y
	 */


	_ctx.prototype.strokeText = function (text, x, y) {
	  this.__applyText(text, x, y, "stroke");
	};
	/**
	 * No need to implement this for svg.
	 * @param text
	 * @return {TextMetrics}
	 */


	_ctx.prototype.measureText = function (text) {
	  this.__ctx.font = this.font;
	  return this.__ctx.measureText(text);
	};
	/**
	 *  Arc command!
	 */


	_ctx.prototype.arc = function (x, y, radius, startAngle, endAngle, counterClockwise) {
	  // in canvas no circle is drawn if no angle is provided.
	  if (startAngle === endAngle) {
	    return;
	  }

	  startAngle = startAngle % (2 * Math.PI);
	  endAngle = endAngle % (2 * Math.PI);

	  if (startAngle === endAngle) {
	    //circle time! subtract some of the angle so svg is happy (svg elliptical arc can't draw a full circle)
	    endAngle = (endAngle + 2 * Math.PI - 0.001 * (counterClockwise ? -1 : 1)) % (2 * Math.PI);
	  }

	  var endX = x + radius * Math.cos(endAngle),
	      endY = y + radius * Math.sin(endAngle),
	      startX = x + radius * Math.cos(startAngle),
	      startY = y + radius * Math.sin(startAngle),
	      sweepFlag = counterClockwise ? 0 : 1,
	      largeArcFlag = 0,
	      diff = endAngle - startAngle; // https://github.com/gliffy/canvas2svg/issues/4

	  if (diff < 0) {
	    diff += 2 * Math.PI;
	  }

	  if (counterClockwise) {
	    largeArcFlag = diff > Math.PI ? 0 : 1;
	  } else {
	    largeArcFlag = diff > Math.PI ? 1 : 0;
	  }

	  this.lineTo(startX, startY);

	  this.__addPathCommand(format("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}", {
	    rx: radius,
	    ry: radius,
	    xAxisRotation: 0,
	    largeArcFlag: largeArcFlag,
	    sweepFlag: sweepFlag,
	    endX: endX,
	    endY: endY
	  }));

	  this.__currentPosition = {
	    x: endX,
	    y: endY
	  };
	};
	/**
	 * Generates a ClipPath from the clip command.
	 */


	_ctx.prototype.clip = function () {
	  var group = this.__closestGroupOrSvg(),
	      clipPath = this.__createElement("clipPath"),
	      id = randomString(this.__ids),
	      newGroup = this.__createElement("g");

	  this.__applyCurrentDefaultPath();

	  group.removeChild(this.__currentElement);
	  clipPath.setAttribute("id", id);
	  clipPath.appendChild(this.__currentElement);

	  this.__defs.appendChild(clipPath); //set the clip path to this group


	  group.setAttribute("clip-path", format("url(#{id})", {
	    id: id
	  })); //clip paths can be scaled and transformed, we need to add another wrapper group to avoid later transformations
	  // to this path

	  group.appendChild(newGroup);
	  this.__currentElement = newGroup;
	};
	/**
	 * Draws a canvas, image or mock context to this canvas.
	 * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
	 * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
	 */


	_ctx.prototype.drawImage = function () {
	  //convert arguments to a real array
	  var args = Array.prototype.slice.call(arguments),
	      image = args[0],
	      dx,
	      dy,
	      dw,
	      dh,
	      sx = 0,
	      sy = 0,
	      sw,
	      sh,
	      parent,
	      svg,
	      defs,
	      group,
	      currentElement,
	      svgImage,
	      canvas,
	      context,
	      id;

	  if (args.length === 3) {
	    dx = args[1];
	    dy = args[2];
	    sw = image.width;
	    sh = image.height;
	    dw = sw;
	    dh = sh;
	  } else if (args.length === 5) {
	    dx = args[1];
	    dy = args[2];
	    dw = args[3];
	    dh = args[4];
	    sw = image.width;
	    sh = image.height;
	  } else if (args.length === 9) {
	    sx = args[1];
	    sy = args[2];
	    sw = args[3];
	    sh = args[4];
	    dx = args[5];
	    dy = args[6];
	    dw = args[7];
	    dh = args[8];
	  } else {
	    throw new Error("Invalid number of arguments passed to drawImage: " + arguments.length);
	  }

	  parent = this.__closestGroupOrSvg();
	  currentElement = this.__currentElement;
	  var translateDirective = "translate(" + dx + ", " + dy + ")";

	  if (image instanceof _ctx) {
	    //canvas2svg mock canvas context. In the future we may want to clone nodes instead.
	    //also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
	    svg = image.getSvg().cloneNode(true);

	    if (svg.childNodes && svg.childNodes.length > 1) {
	      defs = svg.childNodes[0];

	      while (defs.childNodes.length) {
	        id = defs.childNodes[0].getAttribute("id");
	        this.__ids[id] = id;

	        this.__defs.appendChild(defs.childNodes[0]);
	      }

	      group = svg.childNodes[1];

	      if (group) {
	        //save original transform
	        var originTransform = group.getAttribute("transform");
	        var transformDirective;

	        if (originTransform) {
	          transformDirective = originTransform + " " + translateDirective;
	        } else {
	          transformDirective = translateDirective;
	        }

	        group.setAttribute("transform", transformDirective);
	        parent.appendChild(group);
	      }
	    }
	  } else if (image.nodeName === "CANVAS" || image.nodeName === "IMG") {
	    //canvas or image
	    svgImage = this.__createElement("image");
	    svgImage.setAttribute("width", dw);
	    svgImage.setAttribute("height", dh);
	    svgImage.setAttribute("preserveAspectRatio", "none");

	    if (sx || sy || sw !== image.width || sh !== image.height) {
	      //crop the image using a temporary canvas
	      canvas = this.__document.createElement("canvas");
	      canvas.width = dw;
	      canvas.height = dh;
	      context = canvas.getContext("2d");
	      context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
	      image = canvas;
	    }

	    svgImage.setAttribute("transform", translateDirective);
	    svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
	    parent.appendChild(svgImage);
	  }
	};
	/**
	 * Generates a pattern tag
	 */


	_ctx.prototype.createPattern = function (image, repetition) {
	  var pattern = this.__document.__createElement("pattern");

	  var id = randomString(this.__ids);
	  var img;
	  pattern.setAttribute("id", id);
	  pattern.setAttribute("width", image.width);
	  pattern.setAttribute("height", image.height);

	  if (image.nodeName === "CANVAS" || image.nodeName === "IMG") {
	    img = this.__createElement("image");
	    img.setAttribute("width", image.width);
	    img.setAttribute("height", image.height);
	    img.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
	    pattern.appendChild(img);

	    this.__defs.appendChild(pattern);
	  } else if (image instanceof _ctx) {
	    pattern.appendChild(image.__root.childNodes[1]);

	    this.__defs.appendChild(pattern);
	  }

	  return new CanvasPattern(pattern, this);
	};

	_ctx.prototype.setLineDash = function (dashArray) {
	  if (dashArray && dashArray.length > 0) {
	    this.lineDash = dashArray.join(",");
	  } else {
	    this.lineDash = null;
	  }
	};
	/**
	 * Not yet implemented
	 */


	_ctx.prototype.drawFocusRing = function () {};

	_ctx.prototype.createImageData = function () {};

	_ctx.prototype.getImageData = function () {};

	_ctx.prototype.putImageData = function () {};

	_ctx.prototype.globalCompositeOperation = function () {};

	_ctx.prototype.setTransform = function () {};

	var C2S = _ctx;

	var IdeogramViewport = /*#__PURE__*/function (_ViewportBase) {
	  _inherits(IdeogramViewport, _ViewportBase);

	  var _super = _createSuper(IdeogramViewport);

	  function IdeogramViewport(trackView, $viewportContainer, referenceFrame, width) {
	    var _this;

	    _classCallCheck(this, IdeogramViewport);

	    _this = _super.call(this, trackView, $viewportContainer, referenceFrame, width);

	    _this.$canvas.on('click', function (e) {
	      return _this.handleClick(e, _this.canvas);
	    });

	    return _this;
	  }

	  _createClass(IdeogramViewport, [{
	    key: "setWidth",
	    value: function setWidth(width) {
	      this.$viewport.width(width);
	      this.ctx.canvas.style.width = "".concat(width, "px");
	      this.ctx.canvas.width = window.devicePixelRatio * width;
	      this.ctx.canvas.style.height = "".concat(this.$viewport.height(), "px");
	      this.ctx.canvas.height = window.devicePixelRatio * this.$viewport.height();
	      this.ctx.scale(window.devicePixelRatio, window.devicePixelRatio);
	    }
	  }, {
	    key: "handleClick",
	    value: function handleClick(e, canvas) {
	      var _DOMUtils$translateMo = translateMouseCoordinates$1(e, canvas),
	          xNormalized = _DOMUtils$translateMo.xNormalized,
	          width = _DOMUtils$translateMo.width;

	      var _this$browser$genome$ = this.browser.genome.getChromosome(this.referenceFrame.chr),
	          bpLength = _this$browser$genome$.bpLength;

	      var locusLength = this.referenceFrame.bpPerPixel * width;
	      var chrCoveragePercentage = locusLength / bpLength;
	      var xPercentage = xNormalized;

	      if (xPercentage - chrCoveragePercentage / 2.0 < 0) {
	        xPercentage = chrCoveragePercentage / 2.0;
	      }

	      if (xPercentage + chrCoveragePercentage / 2.0 > 1.0) {
	        xPercentage = 1.0 - chrCoveragePercentage / 2.0;
	      }

	      var ss = Math.round((xPercentage - chrCoveragePercentage / 2.0) * bpLength);
	      var ee = Math.round((xPercentage + chrCoveragePercentage / 2.0) * bpLength);
	      this.referenceFrame.start = ss;
	      this.referenceFrame.initialEnd = ee;
	      this.referenceFrame.bpPerPixel = (ee - ss) / width;
	      this.browser.updateLocusSearchWidget(this.referenceFrame);
	      this.browser.updateViews();
	    }
	  }, {
	    key: "checkZoomIn",
	    value: function checkZoomIn() {
	      return true;
	    }
	  }, {
	    key: "setTop",
	    value: function setTop(contentTop) {} // TODO: Not needed. No menus on ideogram track

	  }, {
	    key: "saveSVG",
	    value: function saveSVG() {
	      var _this$$viewport$get$g = this.$viewport.get(0).getBoundingClientRect(),
	          width = _this$$viewport$get$g.width,
	          height = _this$$viewport$get$g.height;

	      var context = new C2S({
	        width: width,
	        height: height,
	        viewbox: {
	          x: 0,
	          y: -$(this.contentDiv).position().top,
	          width: width,
	          height: height
	        }
	      });
	      this.drawSVGWithContect(context, width, height);
	      var svg = context.getSerializedSvg(true);
	      var data = URL.createObjectURL(new Blob([svg], {
	        type: "application/octet-stream"
	      }));
	      download("".concat(this.trackView.track.id, ".svg"), data);
	    }
	  }, {
	    key: "drawSVGWithContect",
	    value: function drawSVGWithContect(context, width, height) {
	      var config = {
	        ctx: context,
	        width: width,
	        height: height,
	        genome: this.browser.genome,
	        referenceFrame: this.referenceFrame,
	        ideogramWidth: this.$content.width()
	      };
	      context.save();
	      repaintContext(config);
	      context.restore();
	    }
	  }, {
	    key: "repaint",
	    value: function repaint() {
	      var config = {
	        ctx: this.ctx,
	        width: this.$canvas.width(),
	        height: this.$canvas.height(),
	        genome: this.browser.genome,
	        referenceFrame: this.referenceFrame,
	        ideogramWidth: this.$content.width()
	      };
	      repaintContext(config);
	    }
	  }]);

	  return IdeogramViewport;
	}(ViewportBase);

	function repaintContext(_ref) {
	  var ctx = _ref.ctx,
	      width = _ref.width,
	      height = _ref.height,
	      genome = _ref.genome,
	      referenceFrame = _ref.referenceFrame,
	      ideogramWidth = _ref.ideogramWidth;
	  var chr = referenceFrame.chr;
	  var chromosome = genome.getChromosome(chr);

	  if (!chromosome || width <= 0 || height <= 0 || chr.toLowerCase() === "all") {
	    return;
	  }

	  var stainColors = [];
	  IGVGraphics.fillRect(ctx, 0, 0, width, height, {
	    fillStyle: IGVColor.greyScale(255)
	  });
	  drawIdeogram({
	    ctx: ctx,
	    chr: chr,
	    referenceFrame: referenceFrame,
	    genome: genome,
	    width: width,
	    height: height,
	    stainColors: stainColors
	  });
	  var widthBP = Math.round(referenceFrame.bpPerPixel * ideogramWidth);
	  var xBP = referenceFrame.start; // Total chromosome length can be > chromosome.bpLength for partial fastas.

	  var chrLength = chromosome.bpLength;
	  var cytobands = genome.getCytobands(chr);

	  if (cytobands && cytobands.length > 0) {
	    chrLength = Math.max(chrLength, cytobands[cytobands.length - 1].end);
	  }

	  if (widthBP < chrLength) {
	    var percentWidth = widthBP / chrLength;
	    var percentX = xBP / chrLength;
	    var x = Math.floor(percentX * width);
	    var ww = Math.floor(percentWidth * width);
	    x = Math.max(0, x);
	    x = Math.min(width - ww, x); // Push current context

	    ctx.save(); // Draw red box

	    ctx.strokeStyle = "red";
	    ctx.lineWidth = ww < 2 ? 1 : 2;
	    var xx = x + ctx.lineWidth / 2;
	    ww = ww < 2 ? 1 : ww - ctx.lineWidth;
	    var yy = ctx.lineWidth / 2;
	    var hh = height - ctx.lineWidth;
	    ctx.strokeRect(xx, yy, ww, hh); // Pop current context

	    ctx.restore();
	  }
	}

	function drawIdeogram(_ref2) {
	  var ctx = _ref2.ctx,
	      chr = _ref2.chr,
	      referenceFrame = _ref2.referenceFrame,
	      genome = _ref2.genome,
	      width = _ref2.width,
	      height = _ref2.height,
	      stainColors = _ref2.stainColors;
	  var shim, shim2, ideogramTop, cytobands, cytoband, center, xC, yC, chrLength, scale, start, end, i;
	  shim = 1;
	  shim2 = 0.5 * shim;
	  ideogramTop = 0;

	  if (undefined === genome) {
	    return;
	  }

	  IGVGraphics.fillRect(ctx, 0, 0, width, height, {
	    fillStyle: IGVColor.greyScale(255)
	  });
	  cytobands = genome.getCytobands(chr);

	  if (cytobands) {
	    center = ideogramTop + height / 2;
	    xC = [];
	    yC = [];

	    if (0 === cytobands.length) {
	      return;
	    }

	    chrLength = referenceFrame.genome.getChromosome(chr).bpLength;
	    scale = width / chrLength; // round rect clipping path

	    ctx.beginPath();
	    IGVGraphics.roundRect(ctx, shim2, shim2 + ideogramTop, width - 2 * shim2, height - 2 * shim2, (height - 2 * shim2) / 2, 0, 1);
	    ctx.clip();

	    for (i = 0; i < cytobands.length; i++) {
	      cytoband = cytobands[i];
	      start = scale * cytoband.start;
	      end = scale * cytoband.end;

	      if (cytoband.type === 'c') {
	        if (cytoband.name.charAt(0) === 'p') {
	          xC[0] = start;
	          yC[0] = height + ideogramTop;
	          xC[1] = start;
	          yC[1] = ideogramTop;
	          xC[2] = end;
	          yC[2] = center;
	        } else {
	          xC[0] = end;
	          yC[0] = height + ideogramTop;
	          xC[1] = end;
	          yC[1] = ideogramTop;
	          xC[2] = start;
	          yC[2] = center;
	        }

	        ctx.fillStyle = "rgb(150, 0, 0)";
	        ctx.strokeStyle = "rgb(150, 0, 0)";
	        IGVGraphics.polygon(ctx, xC, yC, 1, 0);
	      } else {
	        ctx.fillStyle = getCytobandColor(stainColors, cytoband);
	        IGVGraphics.fillRect(ctx, start, shim + ideogramTop, end - start, height - 2 * shim);
	      }
	    }
	  } // round rect border


	  ctx.strokeStyle = IGVColor.greyScale(41);
	  IGVGraphics.roundRect(ctx, shim2, shim2 + ideogramTop, width - 2 * shim2, height - 2 * shim2, (height - 2 * shim2) / 2, 0, 1);
	}

	function getCytobandColor(colors, data) {
	  if (data.type === 'c') {
	    // centermere: "acen"
	    return "rgb(150, 10, 10)";
	  } else {
	    var stain = data.stain; // + 4;

	    var shade = 230;

	    if (data.type === 'p') {
	      shade = Math.floor(230 - stain / 100.0 * 230);
	    }

	    var c = colors[shade];

	    if (!c) {
	      c = "rgb(" + shade + "," + shade + "," + shade + ")";
	      colors[shade] = c;
	    }

	    return c;
	  }
	}

	var createMethod$4 = function (IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aFunction$1(callbackfn);
	    var O = toObject(that);
	    var self = indexedObject(O);
	    var length = toLength(O.length);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }

	      index += i;

	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw TypeError('Reduce of empty array with no initial value');
	      }
	    }

	    for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }

	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
	  left: createMethod$4(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
	  right: createMethod$4(true)
	};

	var $reduce = arrayReduce.left;
	var STRICT_METHOD$4 = arrayMethodIsStrict('reduce');
	var USES_TO_LENGTH$8 = arrayMethodUsesToLength('reduce', {
	  1: 0
	}); // `Array.prototype.reduce` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.reduce

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$4 || !USES_TO_LENGTH$8
	}, {
	  reduce: function reduce(callbackfn
	  /* , initialValue */
	  ) {
	    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var trim$1 = stringTrim.trim;
	var $parseInt = global_1.parseInt;
	var hex = /^[+-]?0[Xx]/;
	var FORCED$4 = $parseInt(whitespaces + '08') !== 8 || $parseInt(whitespaces + '0x16') !== 22; // `parseInt` method
	// https://tc39.github.io/ecma262/#sec-parseint-string-radix

	var numberParseInt = FORCED$4 ? function parseInt(string, radix) {
	  var S = trim$1(String(string));
	  return $parseInt(S, radix >>> 0 || (hex.test(S) ? 16 : 10));
	} : $parseInt;

	// https://tc39.github.io/ecma262/#sec-number.parseint

	_export({
	  target: 'Number',
	  stat: true,
	  forced: Number.parseInt != numberParseInt
	}, {
	  parseInt: numberParseInt
	});

	// https://tc39.github.io/ecma262/#sec-object.assign

	_export({
	  target: 'Object',
	  stat: true,
	  forced: Object.assign !== objectAssign
	}, {
	  assign: objectAssign
	});

	var propertyIsEnumerable = objectPropertyIsEnumerable.f; // `Object.{ entries, values }` methods implementation

	var createMethod$5 = function (TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject(it);
	    var keys = objectKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;

	    while (length > i) {
	      key = keys[i++];

	      if (!descriptors || propertyIsEnumerable.call(O, key)) {
	        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }

	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.github.io/ecma262/#sec-object.entries
	  entries: createMethod$5(true),
	  // `Object.values` method
	  // https://tc39.github.io/ecma262/#sec-object.values
	  values: createMethod$5(false)
	};

	var $values = objectToArray.values; // `Object.values` method
	// https://tc39.github.io/ecma262/#sec-object.values

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var arrayBufferNative = typeof ArrayBuffer !== 'undefined' && typeof DataView !== 'undefined';

	var defineProperty$9 = objectDefineProperty.f;
	var Int8Array$1 = global_1.Int8Array;
	var Int8ArrayPrototype = Int8Array$1 && Int8Array$1.prototype;
	var Uint8ClampedArray = global_1.Uint8ClampedArray;
	var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
	var TypedArray = Int8Array$1 && objectGetPrototypeOf(Int8Array$1);
	var TypedArrayPrototype = Int8ArrayPrototype && objectGetPrototypeOf(Int8ArrayPrototype);
	var ObjectPrototype$2 = Object.prototype;
	var isPrototypeOf = ObjectPrototype$2.isPrototypeOf;
	var TO_STRING_TAG$4 = wellKnownSymbol('toStringTag');
	var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG'); // Fixing native typed arrays in Opera Presto crashes the browser, see #595

	var NATIVE_ARRAY_BUFFER_VIEWS = arrayBufferNative && !!objectSetPrototypeOf && classof(global_1.opera) !== 'Opera';
	var TYPED_ARRAY_TAG_REQIRED = false;
	var NAME$1;
	var TypedArrayConstructorsList = {
	  Int8Array: 1,
	  Uint8Array: 1,
	  Uint8ClampedArray: 1,
	  Int16Array: 2,
	  Uint16Array: 2,
	  Int32Array: 4,
	  Uint32Array: 4,
	  Float32Array: 4,
	  Float64Array: 8
	};

	var isView = function isView(it) {
	  var klass = classof(it);
	  return klass === 'DataView' || has(TypedArrayConstructorsList, klass);
	};

	var isTypedArray = function (it) {
	  return isObject(it) && has(TypedArrayConstructorsList, classof(it));
	};

	var aTypedArray = function (it) {
	  if (isTypedArray(it)) return it;
	  throw TypeError('Target is not a typed array');
	};

	var aTypedArrayConstructor = function (C) {
	  if (objectSetPrototypeOf) {
	    if (isPrototypeOf.call(TypedArray, C)) return C;
	  } else for (var ARRAY in TypedArrayConstructorsList) if (has(TypedArrayConstructorsList, NAME$1)) {
	    var TypedArrayConstructor = global_1[ARRAY];

	    if (TypedArrayConstructor && (C === TypedArrayConstructor || isPrototypeOf.call(TypedArrayConstructor, C))) {
	      return C;
	    }
	  }

	  throw TypeError('Target is not a typed array constructor');
	};

	var exportTypedArrayMethod = function (KEY, property, forced) {
	  if (!descriptors) return;
	  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
	    var TypedArrayConstructor = global_1[ARRAY];

	    if (TypedArrayConstructor && has(TypedArrayConstructor.prototype, KEY)) {
	      delete TypedArrayConstructor.prototype[KEY];
	    }
	  }

	  if (!TypedArrayPrototype[KEY] || forced) {
	    redefine(TypedArrayPrototype, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property);
	  }
	};

	var exportTypedArrayStaticMethod = function (KEY, property, forced) {
	  var ARRAY, TypedArrayConstructor;
	  if (!descriptors) return;

	  if (objectSetPrototypeOf) {
	    if (forced) for (ARRAY in TypedArrayConstructorsList) {
	      TypedArrayConstructor = global_1[ARRAY];

	      if (TypedArrayConstructor && has(TypedArrayConstructor, KEY)) {
	        delete TypedArrayConstructor[KEY];
	      }
	    }

	    if (!TypedArray[KEY] || forced) {
	      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
	      try {
	        return redefine(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8Array$1[KEY] || property);
	      } catch (error) {
	        /* empty */
	      }
	    } else return;
	  }

	  for (ARRAY in TypedArrayConstructorsList) {
	    TypedArrayConstructor = global_1[ARRAY];

	    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
	      redefine(TypedArrayConstructor, KEY, property);
	    }
	  }
	};

	for (NAME$1 in TypedArrayConstructorsList) {
	  if (!global_1[NAME$1]) NATIVE_ARRAY_BUFFER_VIEWS = false;
	} // WebKit bug - typed arrays constructors prototype is Object.prototype


	if (!NATIVE_ARRAY_BUFFER_VIEWS || typeof TypedArray != 'function' || TypedArray === Function.prototype) {
	  // eslint-disable-next-line no-shadow
	  TypedArray = function TypedArray() {
	    throw TypeError('Incorrect invocation');
	  };

	  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global_1[NAME$1]) objectSetPrototypeOf(global_1[NAME$1], TypedArray);
	  }
	}

	if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype$2) {
	  TypedArrayPrototype = TypedArray.prototype;
	  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global_1[NAME$1]) objectSetPrototypeOf(global_1[NAME$1].prototype, TypedArrayPrototype);
	  }
	} // WebKit bug - one more object in Uint8ClampedArray prototype chain


	if (NATIVE_ARRAY_BUFFER_VIEWS && objectGetPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
	  objectSetPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
	}

	if (descriptors && !has(TypedArrayPrototype, TO_STRING_TAG$4)) {
	  TYPED_ARRAY_TAG_REQIRED = true;
	  defineProperty$9(TypedArrayPrototype, TO_STRING_TAG$4, {
	    get: function () {
	      return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
	    }
	  });

	  for (NAME$1 in TypedArrayConstructorsList) if (global_1[NAME$1]) {
	    createNonEnumerableProperty(global_1[NAME$1], TYPED_ARRAY_TAG, NAME$1);
	  }
	}

	var arrayBufferViewCore = {
	  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
	  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQIRED && TYPED_ARRAY_TAG,
	  aTypedArray: aTypedArray,
	  aTypedArrayConstructor: aTypedArrayConstructor,
	  exportTypedArrayMethod: exportTypedArrayMethod,
	  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
	  isView: isView,
	  isTypedArray: isTypedArray,
	  TypedArray: TypedArray,
	  TypedArrayPrototype: TypedArrayPrototype
	};

	/* eslint-disable no-new */

	var NATIVE_ARRAY_BUFFER_VIEWS$1 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	var ArrayBuffer$1 = global_1.ArrayBuffer;
	var Int8Array$2 = global_1.Int8Array;
	var typedArrayConstructorsRequireWrappers = !NATIVE_ARRAY_BUFFER_VIEWS$1 || !fails(function () {
	  Int8Array$2(1);
	}) || !fails(function () {
	  new Int8Array$2(-1);
	}) || !checkCorrectnessOfIteration(function (iterable) {
	  new Int8Array$2();
	  new Int8Array$2(null);
	  new Int8Array$2(1.5);
	  new Int8Array$2(iterable);
	}, true) || fails(function () {
	  // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
	  return new Int8Array$2(new ArrayBuffer$1(2), 1, undefined).length !== 1;
	});

	// https://tc39.github.io/ecma262/#sec-toindex

	var toIndex = function (it) {
	  if (it === undefined) return 0;
	  var number = toInteger(it);
	  var length = toLength(number);
	  if (number !== length) throw RangeError('Wrong length or index');
	  return length;
	};

	// IEEE754 conversions based on https://github.com/feross/ieee754
	// eslint-disable-next-line no-shadow-restricted-names
	var Infinity$1 = 1 / 0;
	var abs = Math.abs;
	var pow$1 = Math.pow;
	var floor$4 = Math.floor;
	var log = Math.log;
	var LN2 = Math.LN2;

	var pack = function (number, mantissaLength, bytes) {
	  var buffer = new Array(bytes);
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var rt = mantissaLength === 23 ? pow$1(2, -24) - pow$1(2, -77) : 0;
	  var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
	  var index = 0;
	  var exponent, mantissa, c;
	  number = abs(number); // eslint-disable-next-line no-self-compare

	  if (number != number || number === Infinity$1) {
	    // eslint-disable-next-line no-self-compare
	    mantissa = number != number ? 1 : 0;
	    exponent = eMax;
	  } else {
	    exponent = floor$4(log(number) / LN2);

	    if (number * (c = pow$1(2, -exponent)) < 1) {
	      exponent--;
	      c *= 2;
	    }

	    if (exponent + eBias >= 1) {
	      number += rt / c;
	    } else {
	      number += rt * pow$1(2, 1 - eBias);
	    }

	    if (number * c >= 2) {
	      exponent++;
	      c /= 2;
	    }

	    if (exponent + eBias >= eMax) {
	      mantissa = 0;
	      exponent = eMax;
	    } else if (exponent + eBias >= 1) {
	      mantissa = (number * c - 1) * pow$1(2, mantissaLength);
	      exponent = exponent + eBias;
	    } else {
	      mantissa = number * pow$1(2, eBias - 1) * pow$1(2, mantissaLength);
	      exponent = 0;
	    }
	  }

	  for (; mantissaLength >= 8; buffer[index++] = mantissa & 255, mantissa /= 256, mantissaLength -= 8);

	  exponent = exponent << mantissaLength | mantissa;
	  exponentLength += mantissaLength;

	  for (; exponentLength > 0; buffer[index++] = exponent & 255, exponent /= 256, exponentLength -= 8);

	  buffer[--index] |= sign * 128;
	  return buffer;
	};

	var unpack = function (buffer, mantissaLength) {
	  var bytes = buffer.length;
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var nBits = exponentLength - 7;
	  var index = bytes - 1;
	  var sign = buffer[index--];
	  var exponent = sign & 127;
	  var mantissa;
	  sign >>= 7;

	  for (; nBits > 0; exponent = exponent * 256 + buffer[index], index--, nBits -= 8);

	  mantissa = exponent & (1 << -nBits) - 1;
	  exponent >>= -nBits;
	  nBits += mantissaLength;

	  for (; nBits > 0; mantissa = mantissa * 256 + buffer[index], index--, nBits -= 8);

	  if (exponent === 0) {
	    exponent = 1 - eBias;
	  } else if (exponent === eMax) {
	    return mantissa ? NaN : sign ? -Infinity$1 : Infinity$1;
	  } else {
	    mantissa = mantissa + pow$1(2, mantissaLength);
	    exponent = exponent - eBias;
	  }

	  return (sign ? -1 : 1) * mantissa * pow$1(2, exponent - mantissaLength);
	};

	var ieee754 = {
	  pack: pack,
	  unpack: unpack
	};

	var getOwnPropertyNames$2 = objectGetOwnPropertyNames.f;
	var defineProperty$a = objectDefineProperty.f;
	var getInternalState$4 = internalState.get;
	var setInternalState$8 = internalState.set;
	var ARRAY_BUFFER = 'ArrayBuffer';
	var DATA_VIEW = 'DataView';
	var PROTOTYPE$2 = 'prototype';
	var WRONG_LENGTH = 'Wrong length';
	var WRONG_INDEX = 'Wrong index';
	var NativeArrayBuffer = global_1[ARRAY_BUFFER];
	var $ArrayBuffer = NativeArrayBuffer;
	var $DataView = global_1[DATA_VIEW];
	var $DataViewPrototype = $DataView && $DataView[PROTOTYPE$2];
	var ObjectPrototype$3 = Object.prototype;
	var RangeError$1 = global_1.RangeError;
	var packIEEE754 = ieee754.pack;
	var unpackIEEE754 = ieee754.unpack;

	var packInt8 = function (number) {
	  return [number & 0xFF];
	};

	var packInt16 = function (number) {
	  return [number & 0xFF, number >> 8 & 0xFF];
	};

	var packInt32 = function (number) {
	  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
	};

	var unpackInt32 = function (buffer) {
	  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
	};

	var packFloat32 = function (number) {
	  return packIEEE754(number, 23, 4);
	};

	var packFloat64 = function (number) {
	  return packIEEE754(number, 52, 8);
	};

	var addGetter = function (Constructor, key) {
	  defineProperty$a(Constructor[PROTOTYPE$2], key, {
	    get: function () {
	      return getInternalState$4(this)[key];
	    }
	  });
	};

	var get$1 = function (view, count, index, isLittleEndian) {
	  var intIndex = toIndex(index);
	  var store = getInternalState$4(view);
	  if (intIndex + count > store.byteLength) throw RangeError$1(WRONG_INDEX);
	  var bytes = getInternalState$4(store.buffer).bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = bytes.slice(start, start + count);
	  return isLittleEndian ? pack : pack.reverse();
	};

	var set$2 = function (view, count, index, conversion, value, isLittleEndian) {
	  var intIndex = toIndex(index);
	  var store = getInternalState$4(view);
	  if (intIndex + count > store.byteLength) throw RangeError$1(WRONG_INDEX);
	  var bytes = getInternalState$4(store.buffer).bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = conversion(+value);

	  for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
	};

	if (!arrayBufferNative) {
	  $ArrayBuffer = function ArrayBuffer(length) {
	    anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
	    var byteLength = toIndex(length);
	    setInternalState$8(this, {
	      bytes: arrayFill.call(new Array(byteLength), 0),
	      byteLength: byteLength
	    });
	    if (!descriptors) this.byteLength = byteLength;
	  };

	  $DataView = function DataView(buffer, byteOffset, byteLength) {
	    anInstance(this, $DataView, DATA_VIEW);
	    anInstance(buffer, $ArrayBuffer, DATA_VIEW);
	    var bufferLength = getInternalState$4(buffer).byteLength;
	    var offset = toInteger(byteOffset);
	    if (offset < 0 || offset > bufferLength) throw RangeError$1('Wrong offset');
	    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
	    if (offset + byteLength > bufferLength) throw RangeError$1(WRONG_LENGTH);
	    setInternalState$8(this, {
	      buffer: buffer,
	      byteLength: byteLength,
	      byteOffset: offset
	    });

	    if (!descriptors) {
	      this.buffer = buffer;
	      this.byteLength = byteLength;
	      this.byteOffset = offset;
	    }
	  };

	  if (descriptors) {
	    addGetter($ArrayBuffer, 'byteLength');
	    addGetter($DataView, 'buffer');
	    addGetter($DataView, 'byteLength');
	    addGetter($DataView, 'byteOffset');
	  }

	  redefineAll($DataView[PROTOTYPE$2], {
	    getInt8: function getInt8(byteOffset) {
	      return get$1(this, 1, byteOffset)[0] << 24 >> 24;
	    },
	    getUint8: function getUint8(byteOffset) {
	      return get$1(this, 1, byteOffset)[0];
	    },
	    getInt16: function getInt16(byteOffset
	    /* , littleEndian */
	    ) {
	      var bytes = get$1(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
	    },
	    getUint16: function getUint16(byteOffset
	    /* , littleEndian */
	    ) {
	      var bytes = get$1(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return bytes[1] << 8 | bytes[0];
	    },
	    getInt32: function getInt32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackInt32(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
	    },
	    getUint32: function getUint32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackInt32(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
	    },
	    getFloat32: function getFloat32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackIEEE754(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
	    },
	    getFloat64: function getFloat64(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackIEEE754(get$1(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
	    },
	    setInt8: function setInt8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setInt16: function setInt16(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint16: function setUint16(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setInt32: function setInt32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint32: function setUint32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat32: function setFloat32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat64: function setFloat64(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
	    }
	  });
	} else {
	  if (!fails(function () {
	    NativeArrayBuffer(1);
	  }) || !fails(function () {
	    new NativeArrayBuffer(-1); // eslint-disable-line no-new
	  }) || fails(function () {
	    new NativeArrayBuffer(); // eslint-disable-line no-new

	    new NativeArrayBuffer(1.5); // eslint-disable-line no-new

	    new NativeArrayBuffer(NaN); // eslint-disable-line no-new

	    return NativeArrayBuffer.name != ARRAY_BUFFER;
	  })) {
	    $ArrayBuffer = function ArrayBuffer(length) {
	      anInstance(this, $ArrayBuffer);
	      return new NativeArrayBuffer(toIndex(length));
	    };

	    var ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE$2] = NativeArrayBuffer[PROTOTYPE$2];

	    for (var keys$3 = getOwnPropertyNames$2(NativeArrayBuffer), j$1 = 0, key$1; keys$3.length > j$1;) {
	      if (!((key$1 = keys$3[j$1++]) in $ArrayBuffer)) {
	        createNonEnumerableProperty($ArrayBuffer, key$1, NativeArrayBuffer[key$1]);
	      }
	    }

	    ArrayBufferPrototype.constructor = $ArrayBuffer;
	  } // WebKit bug - the same parent prototype for typed arrays and data view


	  if (objectSetPrototypeOf && objectGetPrototypeOf($DataViewPrototype) !== ObjectPrototype$3) {
	    objectSetPrototypeOf($DataViewPrototype, ObjectPrototype$3);
	  } // iOS Safari 7.x bug


	  var testView = new $DataView(new $ArrayBuffer(2));
	  var nativeSetInt8 = $DataViewPrototype.setInt8;
	  testView.setInt8(0, 2147483648);
	  testView.setInt8(1, 2147483649);
	  if (testView.getInt8(0) || !testView.getInt8(1)) redefineAll($DataViewPrototype, {
	    setInt8: function setInt8(byteOffset, value) {
	      nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
	    }
	  }, {
	    unsafe: true
	  });
	}

	setToStringTag($ArrayBuffer, ARRAY_BUFFER);
	setToStringTag($DataView, DATA_VIEW);
	var arrayBuffer = {
	  ArrayBuffer: $ArrayBuffer,
	  DataView: $DataView
	};

	var toPositiveInteger = function (it) {
	  var result = toInteger(it);
	  if (result < 0) throw RangeError("The argument can't be less than 0");
	  return result;
	};

	var toOffset = function (it, BYTES) {
	  var offset = toPositiveInteger(it);
	  if (offset % BYTES) throw RangeError('Wrong offset');
	  return offset;
	};

	var aTypedArrayConstructor$1 = arrayBufferViewCore.aTypedArrayConstructor;

	var typedArrayFrom = function from(source
	/* , mapfn, thisArg */
	) {
	  var O = toObject(source);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod(O);
	  var i, length, result, step, iterator, next;

	  if (iteratorMethod != undefined && !isArrayIteratorMethod(iteratorMethod)) {
	    iterator = iteratorMethod.call(O);
	    next = iterator.next;
	    O = [];

	    while (!(step = next.call(iterator)).done) {
	      O.push(step.value);
	    }
	  }

	  if (mapping && argumentsLength > 2) {
	    mapfn = functionBindContext(mapfn, arguments[2], 2);
	  }

	  length = toLength(O.length);
	  result = new (aTypedArrayConstructor$1(this))(length);

	  for (i = 0; length > i; i++) {
	    result[i] = mapping ? mapfn(O[i], i) : O[i];
	  }

	  return result;
	};

	var typedArrayConstructor = createCommonjsModule(function (module) {

	  var getOwnPropertyNames = objectGetOwnPropertyNames.f;
	  var forEach = arrayIteration.forEach;
	  var getInternalState = internalState.get;
	  var setInternalState = internalState.set;
	  var nativeDefineProperty = objectDefineProperty.f;
	  var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	  var round = Math.round;
	  var RangeError = global_1.RangeError;
	  var ArrayBuffer = arrayBuffer.ArrayBuffer;
	  var DataView = arrayBuffer.DataView;
	  var NATIVE_ARRAY_BUFFER_VIEWS = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	  var TYPED_ARRAY_TAG = arrayBufferViewCore.TYPED_ARRAY_TAG;
	  var TypedArray = arrayBufferViewCore.TypedArray;
	  var TypedArrayPrototype = arrayBufferViewCore.TypedArrayPrototype;
	  var aTypedArrayConstructor = arrayBufferViewCore.aTypedArrayConstructor;
	  var isTypedArray = arrayBufferViewCore.isTypedArray;
	  var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
	  var WRONG_LENGTH = 'Wrong length';

	  var fromList = function (C, list) {
	    var index = 0;
	    var length = list.length;
	    var result = new (aTypedArrayConstructor(C))(length);

	    while (length > index) result[index] = list[index++];

	    return result;
	  };

	  var addGetter = function (it, key) {
	    nativeDefineProperty(it, key, {
	      get: function () {
	        return getInternalState(this)[key];
	      }
	    });
	  };

	  var isArrayBuffer = function (it) {
	    var klass;
	    return it instanceof ArrayBuffer || (klass = classof(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
	  };

	  var isTypedArrayIndex = function (target, key) {
	    return isTypedArray(target) && typeof key != 'symbol' && key in target && String(+key) == String(key);
	  };

	  var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
	    return isTypedArrayIndex(target, key = toPrimitive(key, true)) ? createPropertyDescriptor(2, target[key]) : nativeGetOwnPropertyDescriptor(target, key);
	  };

	  var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
	    if (isTypedArrayIndex(target, key = toPrimitive(key, true)) && isObject(descriptor) && has(descriptor, 'value') && !has(descriptor, 'get') && !has(descriptor, 'set') // TODO: add validation descriptor w/o calling accessors
	    && !descriptor.configurable && (!has(descriptor, 'writable') || descriptor.writable) && (!has(descriptor, 'enumerable') || descriptor.enumerable)) {
	      target[key] = descriptor.value;
	      return target;
	    }

	    return nativeDefineProperty(target, key, descriptor);
	  };

	  if (descriptors) {
	    if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	      objectGetOwnPropertyDescriptor.f = wrappedGetOwnPropertyDescriptor;
	      objectDefineProperty.f = wrappedDefineProperty;
	      addGetter(TypedArrayPrototype, 'buffer');
	      addGetter(TypedArrayPrototype, 'byteOffset');
	      addGetter(TypedArrayPrototype, 'byteLength');
	      addGetter(TypedArrayPrototype, 'length');
	    }

	    _export({
	      target: 'Object',
	      stat: true,
	      forced: !NATIVE_ARRAY_BUFFER_VIEWS
	    }, {
	      getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
	      defineProperty: wrappedDefineProperty
	    });

	    module.exports = function (TYPE, wrapper, CLAMPED) {
	      var BYTES = TYPE.match(/\d+$/)[0] / 8;
	      var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
	      var GETTER = 'get' + TYPE;
	      var SETTER = 'set' + TYPE;
	      var NativeTypedArrayConstructor = global_1[CONSTRUCTOR_NAME];
	      var TypedArrayConstructor = NativeTypedArrayConstructor;
	      var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
	      var exported = {};

	      var getter = function (that, index) {
	        var data = getInternalState(that);
	        return data.view[GETTER](index * BYTES + data.byteOffset, true);
	      };

	      var setter = function (that, index, value) {
	        var data = getInternalState(that);
	        if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
	        data.view[SETTER](index * BYTES + data.byteOffset, value, true);
	      };

	      var addElement = function (that, index) {
	        nativeDefineProperty(that, index, {
	          get: function () {
	            return getter(this, index);
	          },
	          set: function (value) {
	            return setter(this, index, value);
	          },
	          enumerable: true
	        });
	      };

	      if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	        TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
	          anInstance(that, TypedArrayConstructor, CONSTRUCTOR_NAME);
	          var index = 0;
	          var byteOffset = 0;
	          var buffer, byteLength, length;

	          if (!isObject(data)) {
	            length = toIndex(data);
	            byteLength = length * BYTES;
	            buffer = new ArrayBuffer(byteLength);
	          } else if (isArrayBuffer(data)) {
	            buffer = data;
	            byteOffset = toOffset(offset, BYTES);
	            var $len = data.byteLength;

	            if ($length === undefined) {
	              if ($len % BYTES) throw RangeError(WRONG_LENGTH);
	              byteLength = $len - byteOffset;
	              if (byteLength < 0) throw RangeError(WRONG_LENGTH);
	            } else {
	              byteLength = toLength($length) * BYTES;
	              if (byteLength + byteOffset > $len) throw RangeError(WRONG_LENGTH);
	            }

	            length = byteLength / BYTES;
	          } else if (isTypedArray(data)) {
	            return fromList(TypedArrayConstructor, data);
	          } else {
	            return typedArrayFrom.call(TypedArrayConstructor, data);
	          }

	          setInternalState(that, {
	            buffer: buffer,
	            byteOffset: byteOffset,
	            byteLength: byteLength,
	            length: length,
	            view: new DataView(buffer)
	          });

	          while (index < length) addElement(that, index++);
	        });
	        if (objectSetPrototypeOf) objectSetPrototypeOf(TypedArrayConstructor, TypedArray);
	        TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = objectCreate(TypedArrayPrototype);
	      } else if (typedArrayConstructorsRequireWrappers) {
	        TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
	          anInstance(dummy, TypedArrayConstructor, CONSTRUCTOR_NAME);
	          return inheritIfRequired(function () {
	            if (!isObject(data)) return new NativeTypedArrayConstructor(toIndex(data));
	            if (isArrayBuffer(data)) return $length !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length) : typedArrayOffset !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES)) : new NativeTypedArrayConstructor(data);
	            if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
	            return typedArrayFrom.call(TypedArrayConstructor, data);
	          }(), dummy, TypedArrayConstructor);
	        });
	        if (objectSetPrototypeOf) objectSetPrototypeOf(TypedArrayConstructor, TypedArray);
	        forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
	          if (!(key in TypedArrayConstructor)) {
	            createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
	          }
	        });
	        TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
	      }

	      if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
	      }

	      if (TYPED_ARRAY_TAG) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
	      }

	      exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;
	      _export({
	        global: true,
	        forced: TypedArrayConstructor != NativeTypedArrayConstructor,
	        sham: !NATIVE_ARRAY_BUFFER_VIEWS
	      }, exported);

	      if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
	        createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
	      }

	      if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
	      }

	      setSpecies(CONSTRUCTOR_NAME);
	    };
	  } else module.exports = function () {
	    /* empty */
	  };
	});

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Uint8', function (init) {
	  return function Uint8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var min$8 = Math.min; // `Array.prototype.copyWithin` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.copywithin

	var arrayCopyWithin = [].copyWithin || function copyWithin(target
	/* = 0 */
	, start
	/* = 0, end = @length */
	) {
	  var O = toObject(this);
	  var len = toLength(O.length);
	  var to = toAbsoluteIndex(target, len);
	  var from = toAbsoluteIndex(start, len);
	  var end = arguments.length > 2 ? arguments[2] : undefined;
	  var count = min$8((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
	  var inc = 1;

	  if (from < to && to < from + count) {
	    inc = -1;
	    from += count - 1;
	    to += count - 1;
	  }

	  while (count-- > 0) {
	    if (from in O) O[to] = O[from];else delete O[to];
	    to += inc;
	    from += inc;
	  }

	  return O;
	};

	var aTypedArray$1 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$1 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.copyWithin` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.copywithin

	exportTypedArrayMethod$1('copyWithin', function copyWithin(target, start
	/* , end */
	) {
	  return arrayCopyWithin.call(aTypedArray$1(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
	});

	var $every = arrayIteration.every;
	var aTypedArray$2 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$2 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.every` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.every

	exportTypedArrayMethod$2('every', function every(callbackfn
	/* , thisArg */
	) {
	  return $every(aTypedArray$2(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var aTypedArray$3 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$3 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.fill` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.fill
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$3('fill', function fill(value
	/* , start, end */
	) {
	  return arrayFill.apply(aTypedArray$3(this), arguments);
	});

	var $filter$1 = arrayIteration.filter;
	var aTypedArray$4 = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$2 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$4 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.filter` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.filter

	exportTypedArrayMethod$4('filter', function filter(callbackfn
	/* , thisArg */
	) {
	  var list = $filter$1(aTypedArray$4(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  var C = speciesConstructor(this, this.constructor);
	  var index = 0;
	  var length = list.length;
	  var result = new (aTypedArrayConstructor$2(C))(length);

	  while (length > index) result[index] = list[index++];

	  return result;
	});

	var $find$1 = arrayIteration.find;
	var aTypedArray$5 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$5 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.find` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.find

	exportTypedArrayMethod$5('find', function find(predicate
	/* , thisArg */
	) {
	  return $find$1(aTypedArray$5(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var $findIndex = arrayIteration.findIndex;
	var aTypedArray$6 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$6 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.findIndex` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.findindex

	exportTypedArrayMethod$6('findIndex', function findIndex(predicate
	/* , thisArg */
	) {
	  return $findIndex(aTypedArray$6(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var $forEach$2 = arrayIteration.forEach;
	var aTypedArray$7 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$7 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.forEach` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.foreach

	exportTypedArrayMethod$7('forEach', function forEach(callbackfn
	/* , thisArg */
	) {
	  $forEach$2(aTypedArray$7(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var $includes = arrayIncludes.includes;
	var aTypedArray$8 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$8 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.includes

	exportTypedArrayMethod$8('includes', function includes(searchElement
	/* , fromIndex */
	) {
	  return $includes(aTypedArray$8(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});

	var $indexOf$1 = arrayIncludes.indexOf;
	var aTypedArray$9 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$9 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.indexOf` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.indexof

	exportTypedArrayMethod$9('indexOf', function indexOf(searchElement
	/* , fromIndex */
	) {
	  return $indexOf$1(aTypedArray$9(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});

	var ITERATOR$8 = wellKnownSymbol('iterator');
	var Uint8Array$1 = global_1.Uint8Array;
	var arrayValues = es_array_iterator.values;
	var arrayKeys = es_array_iterator.keys;
	var arrayEntries = es_array_iterator.entries;
	var aTypedArray$a = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$a = arrayBufferViewCore.exportTypedArrayMethod;
	var nativeTypedArrayIterator = Uint8Array$1 && Uint8Array$1.prototype[ITERATOR$8];
	var CORRECT_ITER_NAME = !!nativeTypedArrayIterator && (nativeTypedArrayIterator.name == 'values' || nativeTypedArrayIterator.name == undefined);

	var typedArrayValues = function values() {
	  return arrayValues.call(aTypedArray$a(this));
	}; // `%TypedArray%.prototype.entries` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.entries


	exportTypedArrayMethod$a('entries', function entries() {
	  return arrayEntries.call(aTypedArray$a(this));
	}); // `%TypedArray%.prototype.keys` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.keys

	exportTypedArrayMethod$a('keys', function keys() {
	  return arrayKeys.call(aTypedArray$a(this));
	}); // `%TypedArray%.prototype.values` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.values

	exportTypedArrayMethod$a('values', typedArrayValues, !CORRECT_ITER_NAME); // `%TypedArray%.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype-@@iterator

	exportTypedArrayMethod$a(ITERATOR$8, typedArrayValues, !CORRECT_ITER_NAME);

	var aTypedArray$b = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$b = arrayBufferViewCore.exportTypedArrayMethod;
	var $join = [].join; // `%TypedArray%.prototype.join` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.join
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$b('join', function join(separator) {
	  return $join.apply(aTypedArray$b(this), arguments);
	});

	var aTypedArray$c = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$c = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.lastIndexOf` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.lastindexof
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$c('lastIndexOf', function lastIndexOf(searchElement
	/* , fromIndex */
	) {
	  return arrayLastIndexOf.apply(aTypedArray$c(this), arguments);
	});

	var $map$1 = arrayIteration.map;
	var aTypedArray$d = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$3 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$d = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.map` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.map

	exportTypedArrayMethod$d('map', function map(mapfn
	/* , thisArg */
	) {
	  return $map$1(aTypedArray$d(this), mapfn, arguments.length > 1 ? arguments[1] : undefined, function (O, length) {
	    return new (aTypedArrayConstructor$3(speciesConstructor(O, O.constructor)))(length);
	  });
	});

	var $reduce$1 = arrayReduce.left;
	var aTypedArray$e = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$e = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduce` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduce

	exportTypedArrayMethod$e('reduce', function reduce(callbackfn
	/* , initialValue */
	) {
	  return $reduce$1(aTypedArray$e(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	});

	var $reduceRight = arrayReduce.right;
	var aTypedArray$f = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$f = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduceRicht` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduceright

	exportTypedArrayMethod$f('reduceRight', function reduceRight(callbackfn
	/* , initialValue */
	) {
	  return $reduceRight(aTypedArray$f(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	});

	var aTypedArray$g = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$g = arrayBufferViewCore.exportTypedArrayMethod;
	var floor$5 = Math.floor; // `%TypedArray%.prototype.reverse` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reverse

	exportTypedArrayMethod$g('reverse', function reverse() {
	  var that = this;
	  var length = aTypedArray$g(that).length;
	  var middle = floor$5(length / 2);
	  var index = 0;
	  var value;

	  while (index < middle) {
	    value = that[index];
	    that[index++] = that[--length];
	    that[length] = value;
	  }

	  return that;
	});

	var aTypedArray$h = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$h = arrayBufferViewCore.exportTypedArrayMethod;
	var FORCED$5 = fails(function () {
	  // eslint-disable-next-line no-undef
	  new Int8Array(1).set({});
	}); // `%TypedArray%.prototype.set` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.set

	exportTypedArrayMethod$h('set', function set(arrayLike
	/* , offset */
	) {
	  aTypedArray$h(this);
	  var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
	  var length = this.length;
	  var src = toObject(arrayLike);
	  var len = toLength(src.length);
	  var index = 0;
	  if (len + offset > length) throw RangeError('Wrong length');

	  while (index < len) this[offset + index] = src[index++];
	}, FORCED$5);

	var aTypedArray$i = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$4 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$i = arrayBufferViewCore.exportTypedArrayMethod;
	var $slice = [].slice;
	var FORCED$6 = fails(function () {
	  // eslint-disable-next-line no-undef
	  new Int8Array(1).slice();
	}); // `%TypedArray%.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.slice

	exportTypedArrayMethod$i('slice', function slice(start, end) {
	  var list = $slice.call(aTypedArray$i(this), start, end);
	  var C = speciesConstructor(this, this.constructor);
	  var index = 0;
	  var length = list.length;
	  var result = new (aTypedArrayConstructor$4(C))(length);

	  while (length > index) result[index] = list[index++];

	  return result;
	}, FORCED$6);

	var $some = arrayIteration.some;
	var aTypedArray$j = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$j = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.some` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.some

	exportTypedArrayMethod$j('some', function some(callbackfn
	/* , thisArg */
	) {
	  return $some(aTypedArray$j(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var aTypedArray$k = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$k = arrayBufferViewCore.exportTypedArrayMethod;
	var $sort = [].sort; // `%TypedArray%.prototype.sort` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.sort

	exportTypedArrayMethod$k('sort', function sort(comparefn) {
	  return $sort.call(aTypedArray$k(this), comparefn);
	});

	var aTypedArray$l = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$l = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.subarray` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.subarray

	exportTypedArrayMethod$l('subarray', function subarray(begin, end) {
	  var O = aTypedArray$l(this);
	  var length = O.length;
	  var beginIndex = toAbsoluteIndex(begin, length);
	  return new (speciesConstructor(O, O.constructor))(O.buffer, O.byteOffset + beginIndex * O.BYTES_PER_ELEMENT, toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - beginIndex));
	});

	var Int8Array$3 = global_1.Int8Array;
	var aTypedArray$m = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$m = arrayBufferViewCore.exportTypedArrayMethod;
	var $toLocaleString = [].toLocaleString;
	var $slice$1 = [].slice; // iOS Safari 6.x fails here

	var TO_LOCALE_STRING_BUG = !!Int8Array$3 && fails(function () {
	  $toLocaleString.call(new Int8Array$3(1));
	});
	var FORCED$7 = fails(function () {
	  return [1, 2].toLocaleString() != new Int8Array$3([1, 2]).toLocaleString();
	}) || !fails(function () {
	  Int8Array$3.prototype.toLocaleString.call([1, 2]);
	}); // `%TypedArray%.prototype.toLocaleString` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tolocalestring

	exportTypedArrayMethod$m('toLocaleString', function toLocaleString() {
	  return $toLocaleString.apply(TO_LOCALE_STRING_BUG ? $slice$1.call(aTypedArray$m(this)) : aTypedArray$m(this), arguments);
	}, FORCED$7);

	var exportTypedArrayMethod$n = arrayBufferViewCore.exportTypedArrayMethod;
	var Uint8Array$2 = global_1.Uint8Array;
	var Uint8ArrayPrototype = Uint8Array$2 && Uint8Array$2.prototype || {};
	var arrayToString = [].toString;
	var arrayJoin = [].join;

	if (fails(function () {
	  arrayToString.call({});
	})) {
	  arrayToString = function toString() {
	    return arrayJoin.call(this);
	  };
	}

	var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString; // `%TypedArray%.prototype.toString` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tostring

	exportTypedArrayMethod$n('toString', arrayToString, IS_NOT_ARRAY_METHOD);

	var Cytoband = function Cytoband(start, end, name, typestain) {
	  this.start = start;
	  this.end = end;
	  this.name = name;
	  this.stain = 0; // Set the type, either p, n, or c

	  if (typestain === 'acen') {
	    this.type = 'c';
	  } else {
	    this.type = typestain.charAt(1);

	    if (this.type === 'p') {
	      this.stain = parseInt(typestain.substring(4));
	    }
	  }
	};

	var GenomicInterval = function GenomicInterval(chr, start, end, features) {
	  this.chr = chr;
	  this.start = start;
	  this.end = end;
	  this.features = features;
	};

	GenomicInterval.prototype.contains = function (chr, start, end) {
	  return this.chr === chr && this.start <= start && this.end >= end;
	};

	GenomicInterval.prototype.containsRange = function (range) {
	  return this.chr === range.chr && this.start <= range.start && this.end >= range.end;
	};

	var Chromosome = function Chromosome(name, order, bpStart, bpLength, rangeLocus) {
	  this.name = name;
	  this.order = order;
	  this.bpStart = bpStart;
	  this.bpLength = bpLength;
	  this.rangeLocus = rangeLocus;
	};

	var $includes$1 = arrayIncludes.includes;
	var USES_TO_LENGTH$9 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.includes

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !USES_TO_LENGTH$9
	}, {
	  includes: function includes(el
	  /* , fromIndex = 0 */
	  ) {
	    return $includes$1(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('includes');

	var fromCharCode = String.fromCharCode;
	var nativeFromCodePoint = String.fromCodePoint; // length should be 1, old FF problem

	var INCORRECT_LENGTH = !!nativeFromCodePoint && nativeFromCodePoint.length != 1; // `String.fromCodePoint` method
	// https://tc39.github.io/ecma262/#sec-string.fromcodepoint

	_export({
	  target: 'String',
	  stat: true,
	  forced: INCORRECT_LENGTH
	}, {
	  fromCodePoint: function fromCodePoint(x) {
	    // eslint-disable-line no-unused-vars
	    var elements = [];
	    var length = arguments.length;
	    var i = 0;
	    var code;

	    while (length > i) {
	      code = +arguments[i++];
	      if (toAbsoluteIndex(code, 0x10FFFF) !== code) throw RangeError(code + ' is not a valid code point');
	      elements.push(code < 0x10000 ? fromCharCode(code) : fromCharCode(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00));
	    }

	    return elements.join('');
	  }
	});

	// https://tc39.github.io/ecma262/#sec-string.prototype.includes


	_export({
	  target: 'String',
	  proto: true,
	  forced: !correctIsRegexpLogic('includes')
	}, {
	  includes: function includes(searchString
	  /* , position = 0 */
	  ) {
	    return !!~String(requireObjectCoercible(this)).indexOf(notARegexp(searchString), arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	// Support for oauth token based authorization
	// This class supports explicit setting of an oauth token either globally or for specific hosts.
	//
	// The variable oauth.google.access_token, which becomes igv.oauth.google.access_token on ES5 conversion is
	// supported for backward compatibility
	var oauth = {
	  oauthTokens: {},
	  setToken: function setToken(token, host) {
	    if (!host) {
	      this.google.access_token = token;
	    } else {
	      this.oauthTokens[host] = token;
	    }
	  },
	  getToken: function getToken(host) {
	    var token;

	    if (!host) {
	      token = this.google.access_token;
	    } else {
	      for (var key in this.oauthTokens) {
	        var regex = wildcardToRegExp(key);

	        if (regex.test(host)) {
	          token = this.oauthTokens[key];
	          break;
	        }
	      }
	    }

	    return token;
	  },
	  removeToken: function removeToken(host) {
	    if (!host) {
	      delete oauth.google["access_token"];
	    } else {
	      delete this.oauthTokens[host];
	    }
	  },
	  // Special object for google -- legacy support
	  google: {
	    setToken: function setToken(token) {
	      this.access_token = token;
	    }
	  }
	};
	/**
	 * Creates a RegExp from the given string, converting asterisks to .* expressions,
	 * and escaping all other characters.
	 *
	 * credit https://gist.github.com/donmccurdy/6d073ce2c6f3951312dfa45da14a420f
	 */

	function wildcardToRegExp(s) {
	  return new RegExp('^' + s.split(/\*+/).map(regExpEscape).join('.*') + '$');
	}
	/**
	 * RegExp-escapes all characters in the given string.
	 *
	 * credit https://gist.github.com/donmccurdy/6d073ce2c6f3951312dfa45da14a420f
	 */


	function regExpEscape(s) {
	  return s.replace(/[|\\{}()[\]^$+*?.]/g, '\\$&');
	}

	// Uncompress data,  assumed to be series of bgzipped blocks

	function unbgzf(data, lim) {
	  var oBlockList = [];
	  var ptr = 0;
	  var totalSize = 0;
	  lim = lim || data.byteLength - 18;

	  while (ptr < lim) {
	    try {
	      var ba = new Uint8Array(data, ptr, 18);
	      var xlen = ba[11] << 8 | ba[10];
	      var si1 = ba[12];
	      var si2 = ba[13];
	      var slen = ba[15] << 8 | ba[14];
	      var bsize = (ba[17] << 8 | ba[16]) + 1;
	      var start = 12 + xlen + ptr; // Start of CDATA

	      var bytesLeft = data.byteLength - start;
	      var cDataSize = bsize - xlen - 19;
	      if (bytesLeft < cDataSize || cDataSize <= 0) break;
	      var a = new Uint8Array(data, start, cDataSize);
	      var inflate = new Zlib$1.RawInflate(a);
	      var unc = inflate.decompress();
	      ptr += inflate.ip + 26;
	      totalSize += unc.byteLength;
	      oBlockList.push(unc);
	    } catch (e) {
	      console.error(e);
	      break;
	    }
	  } // Concatenate decompressed blocks


	  if (oBlockList.length === 1) {
	    return oBlockList[0];
	  } else {
	    var out = new Uint8Array(totalSize);
	    var cursor = 0;

	    for (var i = 0; i < oBlockList.length; ++i) {
	      var b = new Uint8Array(oBlockList[i]);
	      arrayCopy(b, 0, out, cursor, b.length);
	      cursor += b.length;
	    }

	    return out;
	  }
	}

	function bgzBlockSize(data) {
	  var ba = new Uint8Array(data);
	  var bsize = ba[17] << 8 | ba[16] + 1;
	  return bsize;
	} // From Thomas Down's zlib implementation


	var testArray = new Uint8Array(1);
	var hasSubarray = typeof testArray.subarray === 'function';
	/* (typeof testArray.slice === 'function'); */
	// Chrome slice performance is so dire that we're currently not using it...

	function arrayCopy(src, srcOffset, dest, destOffset, count) {
	  if (count === 0) {
	    return;
	  }

	  if (!src) {
	    throw "Undef src";
	  } else if (!dest) {
	    throw "Undef dest";
	  }

	  if (srcOffset === 0 && count === src.length) {
	    arrayCopy_fast(src, dest, destOffset);
	  } else if (hasSubarray) {
	    arrayCopy_fast(src.subarray(srcOffset, srcOffset + count), dest, destOffset);
	  } else if (src.BYTES_PER_ELEMENT === 1 && count > 100) {
	    arrayCopy_fast(new Uint8Array(src.buffer, src.byteOffset + srcOffset, count), dest, destOffset);
	  } else {
	    arrayCopy_slow(src, srcOffset, dest, destOffset, count);
	  }
	}

	function arrayCopy_slow(src, srcOffset, dest, destOffset, count) {
	  for (var i = 0; i < count; ++i) {
	    dest[destOffset + i] = src[srcOffset + i];
	  }
	}

	function arrayCopy_fast(src, dest, destOffset) {
	  dest.set(src, destOffset);
	}

	var globalIsFinite = global_1.isFinite; // `Number.isFinite` method
	// https://tc39.github.io/ecma262/#sec-number.isfinite

	var numberIsFinite = Number.isFinite || function isFinite(it) {
	  return typeof it == 'number' && globalIsFinite(it);
	};

	// https://tc39.github.io/ecma262/#sec-number.isfinite

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isFinite: numberIsFinite
	});

	// https://tc39.github.io/ecma262/#sec-number.isnan

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isNaN: function isNaN(number) {
	    // eslint-disable-next-line no-self-compare
	    return number != number;
	  }
	});

	// https://tc39.github.io/ecma262/#sec-thisnumbervalue

	var thisNumberValue = function (value) {
	  if (typeof value != 'number' && classofRaw(value) != 'Number') {
	    throw TypeError('Incorrect invocation');
	  }

	  return +value;
	};

	// https://tc39.github.io/ecma262/#sec-string.prototype.repeat


	var stringRepeat = ''.repeat || function repeat(count) {
	  var str = String(requireObjectCoercible(this));
	  var result = '';
	  var n = toInteger(count);
	  if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');

	  for (; n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;

	  return result;
	};

	var nativeToFixed = 1.0.toFixed;
	var floor$6 = Math.floor;

	var pow$2 = function (x, n, acc) {
	  return n === 0 ? acc : n % 2 === 1 ? pow$2(x, n - 1, acc * x) : pow$2(x * x, n / 2, acc);
	};

	var log$1 = function (x) {
	  var n = 0;
	  var x2 = x;

	  while (x2 >= 4096) {
	    n += 12;
	    x2 /= 4096;
	  }

	  while (x2 >= 2) {
	    n += 1;
	    x2 /= 2;
	  }

	  return n;
	};

	var FORCED$8 = nativeToFixed && (0.00008.toFixed(3) !== '0.000' || 0.9.toFixed(0) !== '1' || 1.255.toFixed(2) !== '1.25' || 1000000000000000128.0.toFixed(0) !== '1000000000000000128') || !fails(function () {
	  // V8 ~ Android 4.3-
	  nativeToFixed.call({});
	}); // `Number.prototype.toFixed` method
	// https://tc39.github.io/ecma262/#sec-number.prototype.tofixed

	_export({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$8
	}, {
	  // eslint-disable-next-line max-statements
	  toFixed: function toFixed(fractionDigits) {
	    var number = thisNumberValue(this);
	    var fractDigits = toInteger(fractionDigits);
	    var data = [0, 0, 0, 0, 0, 0];
	    var sign = '';
	    var result = '0';
	    var e, z, j, k;

	    var multiply = function (n, c) {
	      var index = -1;
	      var c2 = c;

	      while (++index < 6) {
	        c2 += n * data[index];
	        data[index] = c2 % 1e7;
	        c2 = floor$6(c2 / 1e7);
	      }
	    };

	    var divide = function (n) {
	      var index = 6;
	      var c = 0;

	      while (--index >= 0) {
	        c += data[index];
	        data[index] = floor$6(c / n);
	        c = c % n * 1e7;
	      }
	    };

	    var dataToString = function () {
	      var index = 6;
	      var s = '';

	      while (--index >= 0) {
	        if (s !== '' || index === 0 || data[index] !== 0) {
	          var t = String(data[index]);
	          s = s === '' ? t : s + stringRepeat.call('0', 7 - t.length) + t;
	        }
	      }

	      return s;
	    };

	    if (fractDigits < 0 || fractDigits > 20) throw RangeError('Incorrect fraction digits'); // eslint-disable-next-line no-self-compare

	    if (number != number) return 'NaN';
	    if (number <= -1e21 || number >= 1e21) return String(number);

	    if (number < 0) {
	      sign = '-';
	      number = -number;
	    }

	    if (number > 1e-21) {
	      e = log$1(number * pow$2(2, 69, 1)) - 69;
	      z = e < 0 ? number * pow$2(2, -e, 1) : number / pow$2(2, e, 1);
	      z *= 0x10000000000000;
	      e = 52 - e;

	      if (e > 0) {
	        multiply(0, z);
	        j = fractDigits;

	        while (j >= 7) {
	          multiply(1e7, 0);
	          j -= 7;
	        }

	        multiply(pow$2(10, j, 1), 0);
	        j = e - 1;

	        while (j >= 23) {
	          divide(1 << 23);
	          j -= 23;
	        }

	        divide(1 << j);
	        multiply(1, 1);
	        divide(2);
	        result = dataToString();
	      } else {
	        multiply(0, z);
	        multiply(1 << -e, 0);
	        result = dataToString() + stringRepeat.call('0', fractDigits);
	      }
	    }

	    if (fractDigits > 0) {
	      k = result.length;
	      result = sign + (k <= fractDigits ? '0.' + stringRepeat.call('0', fractDigits - k) + result : result.slice(0, k - fractDigits) + '.' + result.slice(k - fractDigits));
	    } else {
	      result = sign + result;
	    }

	    return result;
	  }
	});

	/**
	 * Test if the given value is a string or number.  Not using typeof as it fails on boxed primitives.
	 *
	 * @param value
	 * @returns boolean
	 */


	function isSimpleType(value) {
	  var simpleTypes = new Set(["boolean", "number", "string", "symbol"]);

	  var valueType = _typeof(value);

	  return value !== undefined && (simpleTypes.has(valueType) || value.substring || value.toFixed);
	}

	function buildOptions(config, options) {
	  var defaultOptions = {
	    oauthToken: config.oauthToken,
	    headers: config.headers,
	    withCredentials: config.withCredentials,
	    filename: config.filename
	  };
	  return Object.assign(defaultOptions, options);
	}
	/**
	 * isMobile test from http://detectmobilebrowsers.com
	 * TODO -- improve UI design so this isn't neccessary
	 * @returns {boolean}
	 */
	// igv.isMobile = function () {
	//
	//     const a = (navigator.userAgent || navigator.vendor || window.opera);
	//     return (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
	//         /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4)))
	//
	// }


	var doAutoscale = function doAutoscale(features) {
	  var min, max;

	  if (features.length > 0) {
	    min = Number.MAX_VALUE;
	    max = -Number.MAX_VALUE;
	    features.forEach(function (f) {
	      if (!Number.isNaN(f.value)) {
	        min = Math.min(min, f.value);
	        max = Math.max(max, f.value);
	      }
	    }); // Insure we have a zero baseline

	    if (max > 0) min = Math.min(0, min);
	    if (max < 0) max = 0;
	  } else {
	    // No features -- default
	    min = 0;
	    max = 100;
	  }

	  return {
	    min: min,
	    max: max
	  };
	};

	var validateLocusExtent = function validateLocusExtent(chromosomeLengthBP, extent, minimumBP) {
	  var ss = extent.start;
	  var ee = extent.end;

	  if (undefined === ee) {
	    ss -= minimumBP / 2;
	    ee = ss + minimumBP;

	    if (ee > chromosomeLengthBP) {
	      ee = chromosomeLengthBP;
	      ss = ee - minimumBP;
	    } else if (ss < 0) {
	      ss = 0;
	      ee = minimumBP;
	    }
	  } else if (ee - ss < minimumBP) {
	    var center = (ee + ss) / 2;

	    if (center - minimumBP / 2 < 0) {
	      ss = 0;
	      ee = ss + minimumBP;
	    } else if (center + minimumBP / 2 > chromosomeLengthBP) {
	      ee = chromosomeLengthBP;
	      ss = ee - minimumBP;
	    } else {
	      ss = center - minimumBP / 2;
	      ee = ss + minimumBP;
	    }
	  }

	  extent.start = Math.ceil(ss);
	  extent.end = Math.floor(ee);
	};
	/*!
	 * is-number <https://github.com/jonschlinkert/is-number>
	 *
	 * Copyright (c) 2014-present, Jon Schlinkert.
	 * Released under the MIT License.
	 */


	var isNumber = function isNumber(num) {
	  if (typeof num === 'number') {
	    return num - num === 0;
	  }

	  if (typeof num === 'string' && num.trim() !== '') {
	    return Number.isFinite ? Number.isFinite(+num) : isFinite(+num);
	  }

	  return false;
	};

	function inferTrackType(config) {
	  translateDeprecatedTypes(config);

	  if (config.type) {
	    return config.type;
	  }

	  var format;

	  if ("file" === config.sourceType || undefined === config.sourceType && config.url) {
	    if (undefined === config.format) {
	      var path = isFilePath(config.url) ? config.url.name : config.url;
	      format = inferFileFormat(path);
	    } else {
	      format = config.format.toLowerCase();
	    }
	  }

	  if (format) {
	    switch (format) {
	      case "bw":
	      case "bigwig":
	      case "wig":
	      case "bedgraph":
	      case "tdf":
	        return "wig";

	      case "vcf":
	        return "variant";

	      case "seg":
	        return "seg";

	      case "bam":
	      case "cram":
	        return "alignment";

	      case "bedpe":
	      case "bedpe-loop":
	        return "interaction";

	      case "bp":
	        return "arc";

	      case "gwas":
	        return "gwas";

	      case "bed":
	      case "bigbed":
	      case "bb":
	        return "bedtype";

	      default:
	        return "annotation";
	    }
	  }
	}

	function translateDeprecatedTypes(config) {
	  if (config.featureType) {
	    // Translate deprecated "feature" type
	    config.type = config.type || config.featureType;
	    config.featureType = undefined;
	  }

	  if ("junctions" === config.type) {
	    config.type = "spliceJunctions";
	  } else if ("bed" === config.type) {
	    config.type = "annotation";
	    config.format = config.format || "bed";
	  } else if ("annotations" === config.type) {
	    config.type = "annotation";
	  } else if ("alignments" === config.type) {
	    config.type = "alignment";
	  } else if ("bam" === config.type) {
	    config.type = "alignment";
	    config.format = "bam";
	  } else if ("vcf" === config.type) {
	    config.type = "variant";
	    config.format = "vcf";
	  } else if ("t2d" === config.type) {
	    config.type = "gwas";
	  } else if ("FusionJuncSpan" === config.type && !config.format) {
	    config.format = "fusionjuncspan";
	  } else if ("aed" === config.type) {
	    config.type = "annotation";
	    config.format = config.format || "aed";
	  }
	}

	function getFilename$1(_x) {
	  return _getFilename.apply(this, arguments);
	}

	function _getFilename() {
	  _getFilename = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(url) {
	    var json;
	    return regeneratorRuntime.wrap(function _callee$(_context) {
	      while (1) {
	        switch (_context.prev = _context.next) {
	          case 0:
	            if (!(isString(url) && url.startsWith("https://drive.google.com"))) {
	              _context.next = 9;
	              break;
	            }

	            if (!(getApiKey() === undefined)) {
	              _context.next = 3;
	              break;
	            }

	            throw Error("Google drive is referenced, but API key is not defined.  An API key is required for Google Drive access");

	          case 3:
	            _context.next = 5;
	            return getDriveFileInfo(url);

	          case 5:
	            json = _context.sent;
	            return _context.abrupt("return", json.originalFileName || json.name);

	          case 9:
	            return _context.abrupt("return", getFilename(url));

	          case 10:
	          case "end":
	            return _context.stop();
	        }
	      }
	    }, _callee);
	  }));
	  return _getFilename.apply(this, arguments);
	}

	// The MIT License (MIT)

	function PromiseThrottle(options) {
	  this.requestsPerSecond = options.requestsPerSecond;
	  this.promiseImplementation = options.promiseImplementation || Promise;
	  this.lastStartTime = 0;
	  this.queued = [];
	}
	/**
	 * Adds a promise
	 * @param {Function} promise A function returning the promise to be added
	 * @param {Object} options A set of options.
	 * @param {number} options.signal An AbortSignal object that can be used to abort the returned promise
	 * @param {number} options.weight A "weight" of each operation resolving by array of promises
	 * @return {Promise} A promise
	 */


	PromiseThrottle.prototype.add = function (promise, options) {
	  var self = this;
	  var opt = options || {};
	  return new self.promiseImplementation(function (resolve, reject) {
	    self.queued.push({
	      resolve: resolve,
	      reject: reject,
	      promise: promise,
	      weight: opt.weight || 1,
	      signal: opt.signal
	    });
	    self.dequeue();
	  });
	};
	/**
	 * Adds all the promises passed as parameters
	 * @param {Function} promises An array of functions that return a promise
	 * @param {Object} options A set of options.
	 * @param {number} options.signal An AbortSignal object that can be used to abort the returned promise
	 * @param {number} options.weight A "weight" of each operation resolving by array of promises
	 * @return {Promise} A promise that succeeds when all the promises passed as options do
	 */


	PromiseThrottle.prototype.addAll = function (promises, options) {
	  var addedPromises = promises.map(function (promise) {
	    return this.add(promise, options);
	  }.bind(this));
	  return Promise.all(addedPromises);
	};
	/**
	 * Dequeues a promise
	 * @return {void}
	 */


	PromiseThrottle.prototype.dequeue = function () {
	  if (this.queued.length > 0) {
	    var now = new Date(),
	        weight = this.queued[0].weight,
	        inc = 1000 / this.requestsPerSecond * weight + 1,
	        elapsed = now - this.lastStartTime;

	    if (elapsed >= inc) {
	      this._execute();
	    } else {
	      // we have reached the limit, schedule a dequeue operation
	      setTimeout(function () {
	        this.dequeue();
	      }.bind(this), inc - elapsed);
	    }
	  }
	};
	/**
	 * Executes the promise
	 * @private
	 * @return {void}
	 */


	PromiseThrottle.prototype._execute = function () {
	  this.lastStartTime = new Date();
	  var candidate = this.queued.shift();
	  var aborted = candidate.signal && candidate.signal.aborted;

	  if (aborted) {
	    candidate.reject(new DOMException('', 'AbortError'));
	  } else {
	    candidate.promise().then(function (r) {
	      candidate.resolve(r);
	    }).catch(function (r) {
	      candidate.reject(r);
	    });
	  }
	};

	var _version = "2.7.0";

	function version$2() {
	  return _version;
	}

	var NONE = 0;
	var GZIP = 1;
	var BGZF = 2;
	var UNKNOWN = 3;
	var RANGE_WARNING_GIVEN = false;
	var promiseThrottle = new PromiseThrottle({
	  requestsPerSecond: 10,
	  promiseImplementation: Promise
	});
	var igvxhr = {
	  apiKey: undefined,
	  setApiKey: function setApiKey(key) {
	    this.apiKey = key;
	  },
	  load: load$1,
	  loadArrayBuffer: function () {
	    var _loadArrayBuffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(url, options) {
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              options = options || {};

	              if (!options.responseType) {
	                options.responseType = "arraybuffer";
	              }

	              if (!(url instanceof File)) {
	                _context.next = 6;
	                break;
	              }

	              return _context.abrupt("return", loadFileSlice(url, options));

	            case 6:
	              return _context.abrupt("return", load$1(url, options));

	            case 7:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee);
	    }));

	    function loadArrayBuffer(_x, _x2) {
	      return _loadArrayBuffer.apply(this, arguments);
	    }

	    return loadArrayBuffer;
	  }(),
	  loadJson: function () {
	    var _loadJson = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(url, options) {
	      var method, result;
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              options = options || {};
	              method = options.method || (options.sendData ? "POST" : "GET");

	              if (method === "POST") {
	                options.contentType = "application/json";
	              }

	              _context2.next = 5;
	              return this.loadString(url, options);

	            case 5:
	              result = _context2.sent;

	              if (!result) {
	                _context2.next = 10;
	                break;
	              }

	              return _context2.abrupt("return", JSON.parse(result));

	            case 10:
	              return _context2.abrupt("return", result);

	            case 11:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function loadJson(_x3, _x4) {
	      return _loadJson.apply(this, arguments);
	    }

	    return loadJson;
	  }(),
	  loadString: function () {
	    var _loadString = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(path, options) {
	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              options = options || {};

	              if (!(path instanceof File)) {
	                _context3.next = 5;
	                break;
	              }

	              return _context3.abrupt("return", loadStringFromFile(path, options));

	            case 5:
	              return _context3.abrupt("return", loadStringFromUrl(path, options));

	            case 6:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3);
	    }));

	    function loadString(_x5, _x6) {
	      return _loadString.apply(this, arguments);
	    }

	    return loadString;
	  }()
	};

	function load$1(_x7, _x8) {
	  return _load.apply(this, arguments);
	}

	function _load() {
	  _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(url, options) {
	    var urlType;
	    return regeneratorRuntime.wrap(function _callee4$(_context4) {
	      while (1) {
	        switch (_context4.prev = _context4.next) {
	          case 0:
	            options = options || {};
	            urlType = _typeof(url); // Resolve functions, promises, and functions that return promises

	            _context4.next = 4;
	            return typeof url === 'function' ? url() : url;

	          case 4:
	            url = _context4.sent;

	            if (!(url instanceof File)) {
	              _context4.next = 9;
	              break;
	            }

	            return _context4.abrupt("return", loadFileSlice(url, options));

	          case 9:
	            if (!(typeof url.startsWith === 'function')) {
	              _context4.next = 22;
	              break;
	            }

	            if (!url.startsWith("data:")) {
	              _context4.next = 14;
	              break;
	            }

	            return _context4.abrupt("return", decodeDataURI(url));

	          case 14:
	            if (url.startsWith("https://drive.google.com")) {
	              url = driveDownloadURL(url);
	            }

	            if (!isGoogleDriveURL(url)) {
	              _context4.next = 19;
	              break;
	            }

	            return _context4.abrupt("return", promiseThrottle.add(function () {
	              return loadURL(url, options);
	            }));

	          case 19:
	            return _context4.abrupt("return", loadURL(url, options));

	          case 20:
	            _context4.next = 23;
	            break;

	          case 22:
	            throw Error("url must be either a 'File', 'string', 'function', or 'Promise'.  Actual type: ".concat(urlType));

	          case 23:
	          case "end":
	            return _context4.stop();
	        }
	      }
	    }, _callee4);
	  }));
	  return _load.apply(this, arguments);
	}

	function loadURL(_x9, _x10) {
	  return _loadURL.apply(this, arguments);
	}

	function _loadURL() {
	  _loadURL = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(url, options) {
	    var oauthToken;
	    return regeneratorRuntime.wrap(function _callee6$(_context6) {
	      while (1) {
	        switch (_context6.prev = _context6.next) {
	          case 0:
	            //console.log(`${Date.now()}   ${url}`)
	            url = mapUrl(url);
	            options = options || {};
	            oauthToken = options.oauthToken || getOauthToken(url);

	            if (!oauthToken) {
	              _context6.next = 7;
	              break;
	            }

	            _context6.next = 6;
	            return typeof oauthToken === 'function' ? oauthToken() : oauthToken;

	          case 6:
	            oauthToken = _context6.sent;

	          case 7:
	            return _context6.abrupt("return", new Promise(function (resolve, reject) {
	              // Various Google tansformations
	              if (isGoogleURL(url)) {
	                if (url.startsWith("gs://")) {
	                  url = translateGoogleCloudURL(url);
	                } else if (isGoogleStorageURL(url)) {
	                  if (!url.includes("altMedia=")) {
	                    url += url.includes("?") ? "&altMedia=true" : "?altMedia=true";
	                  }
	                }

	                url = addApiKey(url);
	              }

	              var headers = options.headers || {};

	              if (oauthToken) {
	                addOauthHeaders(headers, oauthToken);
	              }

	              var range = options.range;
	              var isChrome = navigator.userAgent.indexOf('Chrome') > -1;
	              var isSafari = navigator.vendor.indexOf("Apple") === 0 && /\sSafari\//.test(navigator.userAgent);

	              if (range && isChrome && !isAmazonV4Signed(url)) {
	                // Hack to prevent caching for byte-ranges. Attempt to fix net:err-cache errors in Chrome
	                url += url.includes("?") ? "&" : "?";
	                url += "someRandomSeed=" + Math.random().toString(36);
	              }

	              var xhr = new XMLHttpRequest();
	              var sendData = options.sendData || options.body;
	              var method = options.method || (sendData ? "POST" : "GET");
	              var responseType = options.responseType;
	              var contentType = options.contentType;
	              var mimeType = options.mimeType;
	              xhr.open(method, url);

	              if (range) {
	                var rangeEnd = range.size ? range.start + range.size - 1 : "";
	                xhr.setRequestHeader("Range", "bytes=" + range.start + "-" + rangeEnd); //      xhr.setRequestHeader("Cache-Control", "no-cache");    <= This can cause CORS issues, disabled for now
	              }

	              if (contentType) {
	                xhr.setRequestHeader("Content-Type", contentType);
	              }

	              if (mimeType) {
	                xhr.overrideMimeType(mimeType);
	              }

	              if (responseType) {
	                xhr.responseType = responseType;
	              }

	              if (headers) {
	                for (var _i = 0, _Object$keys = Object.keys(headers); _i < _Object$keys.length; _i++) {
	                  var key = _Object$keys[_i];
	                  var value = headers[key];
	                  xhr.setRequestHeader(key, value);
	                }
	              } // NOTE: using withCredentials with servers that return "*" for access-allowed-origin will fail


	              if (options.withCredentials === true) {
	                xhr.withCredentials = true;
	              }

	              xhr.onload = /*#__PURE__*/function () {
	                var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(event) {
	                  var accessToken, response;
	                  return regeneratorRuntime.wrap(function _callee5$(_context5) {
	                    while (1) {
	                      switch (_context5.prev = _context5.next) {
	                        case 0:
	                          if (!(xhr.status === 0 || xhr.status >= 200 && xhr.status <= 300)) {
	                            _context5.next = 4;
	                            break;
	                          }

	                          if (range && xhr.status !== 206 && range.start !== 0) {
	                            // For small files a range starting at 0 can return the whole file => 200
	                            // Provide just the slice we asked for, throw out the rest quietly
	                            // If file is large warn user
	                            if (xhr.response.length > 100000 && !RANGE_WARNING_GIVEN) {
	                              alert("Warning: Range header ignored for URL: ".concat(url, ".  This can have performance impacts."));
	                            }

	                            resolve(xhr.response.slice(range.start, range.start + range.size));
	                          } else {
	                            resolve(xhr.response);
	                          }

	                          _context5.next = 23;
	                          break;

	                        case 4:
	                          if (!(typeof gapi !== "undefined" && (xhr.status === 404 || xhr.status === 401 || xhr.status === 403) && isGoogleURL(url) && !options.retries)) {
	                            _context5.next = 22;
	                            break;
	                          }

	                          _context5.prev = 5;
	                          _context5.next = 8;
	                          return fetchGoogleAccessToken(url);

	                        case 8:
	                          accessToken = _context5.sent;
	                          options.retries = 1;
	                          options.oauthToken = accessToken;
	                          _context5.next = 13;
	                          return load$1(url, options);

	                        case 13:
	                          response = _context5.sent;
	                          resolve(response);
	                          _context5.next = 20;
	                          break;

	                        case 17:
	                          _context5.prev = 17;
	                          _context5.t0 = _context5["catch"](5);
	                          handleError(_context5.t0);

	                        case 20:
	                          _context5.next = 23;
	                          break;

	                        case 22:
	                          if (xhr.status === 403) {
	                            handleError("Access forbidden: " + url);
	                          } else if (xhr.status === 416) {
	                            //  Tried to read off the end of the file.   This shouldn't happen, but if it does return an
	                            handleError("Unsatisfiable range");
	                          } else {
	                            handleError(xhr.status);
	                          }

	                        case 23:
	                        case "end":
	                          return _context5.stop();
	                      }
	                    }
	                  }, _callee5, null, [[5, 17]]);
	                }));

	                return function (_x20) {
	                  return _ref.apply(this, arguments);
	                };
	              }();

	              xhr.onerror = function (event) {
	                handleError("Error accessing resource: " + url + " Status: " + xhr.status);
	              };

	              xhr.ontimeout = function (event) {
	                handleError("Timed out");
	              };

	              xhr.onabort = function (event) {
	                reject(event);
	              };

	              try {
	                xhr.send(sendData);
	              } catch (e) {
	                reject(e);
	              }

	              function handleError(message) {
	                if (reject) {
	                  reject(new Error(message));
	                } else {
	                  throw new Error(message);
	                }
	              }
	            }));

	          case 8:
	          case "end":
	            return _context6.stop();
	        }
	      }
	    }, _callee6);
	  }));
	  return _loadURL.apply(this, arguments);
	}

	function loadFileSlice(_x11, _x12) {
	  return _loadFileSlice.apply(this, arguments);
	}

	function _loadFileSlice() {
	  _loadFileSlice = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(localfile, options) {
	    var blob;
	    return regeneratorRuntime.wrap(function _callee7$(_context7) {
	      while (1) {
	        switch (_context7.prev = _context7.next) {
	          case 0:
	            blob = options && options.range ? localfile.slice(options.range.start, options.range.start + options.range.size) : localfile;

	            if (!("arraybuffer" === options.responseType)) {
	              _context7.next = 5;
	              break;
	            }

	            return _context7.abrupt("return", blobToArrayBuffer(blob));

	          case 5:
	            return _context7.abrupt("return", new Promise(function (resolve, reject) {
	              var fileReader = new FileReader();

	              fileReader.onload = function (e) {
	                resolve(fileReader.result);
	              };

	              fileReader.onerror = function (e) {
	                console.error("reject uploading local file " + localfile.name);
	                reject(null, fileReader);
	              };

	              fileReader.readAsBinaryString(blob);
	              console.warn("Deprecated method used: readAsBinaryString");
	            }));

	          case 6:
	          case "end":
	            return _context7.stop();
	        }
	      }
	    }, _callee7);
	  }));
	  return _loadFileSlice.apply(this, arguments);
	}

	function loadStringFromFile(_x13, _x14) {
	  return _loadStringFromFile.apply(this, arguments);
	}

	function _loadStringFromFile() {
	  _loadStringFromFile = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(localfile, options) {
	    var blob, compression, arrayBuffer;
	    return regeneratorRuntime.wrap(function _callee8$(_context8) {
	      while (1) {
	        switch (_context8.prev = _context8.next) {
	          case 0:
	            blob = options.range ? localfile.slice(options.range.start, options.range.start + options.range.size) : localfile;
	            compression = NONE;

	            if (options && options.bgz || localfile.name.endsWith(".bgz")) {
	              compression = BGZF;
	            } else if (localfile.name.endsWith(".gz")) {
	              compression = GZIP;
	            }

	            if (!(compression === NONE)) {
	              _context8.next = 7;
	              break;
	            }

	            return _context8.abrupt("return", blobToText(blob));

	          case 7:
	            _context8.next = 9;
	            return blobToArrayBuffer(blob);

	          case 9:
	            arrayBuffer = _context8.sent;
	            return _context8.abrupt("return", arrayBufferToString(arrayBuffer, compression));

	          case 11:
	          case "end":
	            return _context8.stop();
	        }
	      }
	    }, _callee8);
	  }));
	  return _loadStringFromFile.apply(this, arguments);
	}

	function blobToArrayBuffer(_x15) {
	  return _blobToArrayBuffer.apply(this, arguments);
	}

	function _blobToArrayBuffer() {
	  _blobToArrayBuffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9(blob) {
	    return regeneratorRuntime.wrap(function _callee9$(_context9) {
	      while (1) {
	        switch (_context9.prev = _context9.next) {
	          case 0:
	            if (!(typeof blob.arrayBuffer === 'function')) {
	              _context9.next = 2;
	              break;
	            }

	            return _context9.abrupt("return", blob.arrayBuffer());

	          case 2:
	            return _context9.abrupt("return", new Promise(function (resolve, reject) {
	              var fileReader = new FileReader();

	              fileReader.onload = function (e) {
	                resolve(fileReader.result);
	              };

	              fileReader.onerror = function (e) {
	                console.error("reject uploading local file " + localfile.name);
	                reject(null, fileReader);
	              };

	              fileReader.readAsArrayBuffer(blob);
	            }));

	          case 3:
	          case "end":
	            return _context9.stop();
	        }
	      }
	    }, _callee9);
	  }));
	  return _blobToArrayBuffer.apply(this, arguments);
	}

	function blobToText(_x16) {
	  return _blobToText.apply(this, arguments);
	}

	function _blobToText() {
	  _blobToText = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10(blob) {
	    return regeneratorRuntime.wrap(function _callee10$(_context10) {
	      while (1) {
	        switch (_context10.prev = _context10.next) {
	          case 0:
	            if (!(typeof blob.text === 'function')) {
	              _context10.next = 2;
	              break;
	            }

	            return _context10.abrupt("return", blob.text());

	          case 2:
	            return _context10.abrupt("return", new Promise(function (resolve, reject) {
	              var fileReader = new FileReader();

	              fileReader.onload = function (e) {
	                resolve(fileReader.result);
	              };

	              fileReader.onerror = function (e) {
	                console.error("reject uploading local file " + localfile.name);
	                reject(null, fileReader);
	              };

	              fileReader.readAsText(blob);
	            }));

	          case 3:
	          case "end":
	            return _context10.stop();
	        }
	      }
	    }, _callee10);
	  }));
	  return _blobToText.apply(this, arguments);
	}

	function loadStringFromUrl(_x17, _x18) {
	  return _loadStringFromUrl.apply(this, arguments);
	}

	function _loadStringFromUrl() {
	  _loadStringFromUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11(url, options) {
	    var fn, compression, data;
	    return regeneratorRuntime.wrap(function _callee11$(_context11) {
	      while (1) {
	        switch (_context11.prev = _context11.next) {
	          case 0:
	            options = options || {};
	            _context11.t0 = options.filename;

	            if (_context11.t0) {
	              _context11.next = 6;
	              break;
	            }

	            _context11.next = 5;
	            return getFilename$1(url);

	          case 5:
	            _context11.t0 = _context11.sent;

	          case 6:
	            fn = _context11.t0;
	            compression = UNKNOWN;

	            if (options.bgz) {
	              compression = BGZF;
	            } else if (fn.endsWith(".gz")) {
	              compression = GZIP;
	            }

	            options.responseType = "arraybuffer";
	            _context11.next = 12;
	            return igvxhr.load(url, options);

	          case 12:
	            data = _context11.sent;
	            return _context11.abrupt("return", arrayBufferToString(data, compression));

	          case 14:
	          case "end":
	            return _context11.stop();
	        }
	      }
	    }, _callee11);
	  }));
	  return _loadStringFromUrl.apply(this, arguments);
	}

	function isAmazonV4Signed(url) {
	  return url.indexOf("X-Amz-Signature") > -1;
	}

	function getOauthToken(url) {
	  // Google is the default provider, don't try to parse host for google URLs
	  var host = isGoogleURL(url) ? undefined : parseUri(url).host;
	  var token = oauth.getToken(host);

	  if (token) {
	    return token;
	  } else if (host === undefined) {
	    if (googleToken && googleToken.expires_at > Date.now()) {
	      return googleToken.access_token;
	    }
	  }
	}
	/**
	 * Cached token from user signin -- not to be confused with explicitly set token from application (oauth.google.access_token)
	 */


	var googleToken;
	/**
	 * Return a Google oAuth token, triggering a sign in if required.   This method should not be called until we know
	 * a token is required, that is until we've tried the url and received a 401, 403, or 404.
	 *
	 * @param url
	 * @returns the oauth token
	 */

	function fetchGoogleAccessToken(_x19) {
	  return _fetchGoogleAccessToken.apply(this, arguments);
	}

	function _fetchGoogleAccessToken() {
	  _fetchGoogleAccessToken = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12(url) {
	    var scope;
	    return regeneratorRuntime.wrap(function _callee12$(_context12) {
	      while (1) {
	        switch (_context12.prev = _context12.next) {
	          case 0:
	            if (!(gapi && gapi.auth2 && gapi.auth2.getAuthInstance())) {
	              _context12.next = 8;
	              break;
	            }

	            scope = getScopeForURL(url);
	            _context12.next = 4;
	            return getAccessToken(scope);

	          case 4:
	            googleToken = _context12.sent;
	            return _context12.abrupt("return", googleToken.access_token);

	          case 8:
	            throw Error("Authorization is required, but Google oAuth has not been initalized. Contact your site administrator for assistance.");

	          case 9:
	          case "end":
	            return _context12.stop();
	        }
	      }
	    }, _callee12);
	  }));
	  return _fetchGoogleAccessToken.apply(this, arguments);
	}

	function addOauthHeaders(headers, acToken) {
	  if (acToken) {
	    headers["Cache-Control"] = "no-cache";
	    headers["Authorization"] = "Bearer " + acToken;
	  }

	  return headers;
	}

	function addApiKey(url) {
	  var apiKey = igvxhr.apiKey;

	  if (!apiKey && typeof gapi !== "undefined") {
	    apiKey = gapi.apiKey;
	  }

	  if (apiKey !== undefined && !url.includes("key=")) {
	    var paramSeparator = url.includes("?") ? "&" : "?";
	    url = url + paramSeparator + "key=" + apiKey;
	  }

	  return url;
	}
	/**
	 * Perform some well-known url mappings.
	 * @param url
	 */


	function mapUrl(url) {
	  if (url.includes("//www.dropbox.com")) {
	    return url.replace("//www.dropbox.com", "//dl.dropboxusercontent.com");
	  } else if (url.includes("//drive.google.com")) {
	    return driveDownloadURL(url);
	  } else if (url.includes("//www.broadinstitute.org/igvdata")) {
	    return url.replace("//www.broadinstitute.org/igvdata", "//data.broadinstitute.org/igvdata");
	  } else if (url.includes("//igvdata.broadinstitute.org")) {
	    return url.replace("//igvdata.broadinstitute.org", "https://dn7ywbm9isq8j.cloudfront.net");
	  } else if (url.startsWith("ftp://ftp.ncbi.nlm.nih.gov/geo")) {
	    return url.replace("ftp://", "https://");
	  } else {
	    return url;
	  }
	}

	function arrayBufferToString(arraybuffer, compression) {
	  if (compression === UNKNOWN && arraybuffer.byteLength > 2) {
	    var m = new Uint8Array(arraybuffer, 0, 2);

	    if (m[0] === 31 && m[1] === 139) {
	      compression = GZIP;
	    }
	  }

	  var plain;

	  if (compression === GZIP) {
	    var inflate = new Zlib$1.Gunzip(new Uint8Array(arraybuffer));
	    plain = inflate.decompress();
	  } else if (compression === BGZF) {
	    plain = unbgzf(arraybuffer);
	  } else {
	    plain = new Uint8Array(arraybuffer);
	  }

	  if ('TextDecoder' in getGlobalObject()) {
	    return new TextDecoder().decode(plain);
	  } else {
	    return decodeUTF8(plain);
	  }
	}
	/**
	 * Use when TextDecoder is not available (primarily IE).
	 *
	 * From: https://gist.github.com/Yaffle/5458286
	 *
	 * @param octets
	 * @returns {string}
	 */


	function decodeUTF8(octets) {
	  var string = "";
	  var i = 0;

	  while (i < octets.length) {
	    var octet = octets[i];
	    var bytesNeeded = 0;
	    var codePoint = 0;

	    if (octet <= 0x7F) {
	      bytesNeeded = 0;
	      codePoint = octet & 0xFF;
	    } else if (octet <= 0xDF) {
	      bytesNeeded = 1;
	      codePoint = octet & 0x1F;
	    } else if (octet <= 0xEF) {
	      bytesNeeded = 2;
	      codePoint = octet & 0x0F;
	    } else if (octet <= 0xF4) {
	      bytesNeeded = 3;
	      codePoint = octet & 0x07;
	    }

	    if (octets.length - i - bytesNeeded > 0) {
	      var k = 0;

	      while (k < bytesNeeded) {
	        octet = octets[i + k + 1];
	        codePoint = codePoint << 6 | octet & 0x3F;
	        k += 1;
	      }
	    } else {
	      codePoint = 0xFFFD;
	      bytesNeeded = octets.length - i;
	    }

	    string += String.fromCodePoint(codePoint);
	    i += bytesNeeded + 1;
	  }

	  return string;
	}

	function getGlobalObject() {
	  if (typeof self !== 'undefined') {
	    return self;
	  }

	  if (typeof global !== 'undefined') {
	    return global;
	  } else {
	    return window;
	  }
	} //Increments an anonymous usage count.  Count is anonymous, needed for our continued funding.  Please don't delete


	if (typeof window !== "undefined") {
	  var href = window.document.location.href;

	  if (!href.includes("localhost") && !href.includes("127.0.0.1")) {
	    var url = "https://data.broadinstitute.org/igv/projects/current/counter_igvjs.php?version=" + version$2();
	    igvxhr.load(url).then(function (ignore) {});
	  }
	}

	var splitLines$1 = splitLines;
	var reservedProperties = new Set(['fastaURL', 'indexURL', 'cytobandURL', 'indexed']);

	var FastaSequence = /*#__PURE__*/function () {
	  function FastaSequence(reference) {
	    _classCallCheck(this, FastaSequence);

	    if (typeof reference.fastaURL === 'string' && reference.fastaURL.startsWith('data:')) {
	      this.file = decodeDataUri(reference.fastaURL);
	      this.indexed = false; // dataURI is by definition not indexed

	      this.isDataURI = true;
	    } else {
	      this.file = reference.fastaURL;
	      this.indexed = reference.indexed !== false; // Indexed unless it explicitly is not

	      if (this.indexed) {
	        this.indexFile = reference.indexURL || reference.indexFile || this.file + ".fai";
	      }
	    }

	    this.withCredentials = reference.withCreden