from django.db.models import Q, F

# If manually pasting from reportbro and you have test data, search and replace \" with \\"
template = """
{
  "docElements": [
    {
      "elementType": "text",
      "id": 3,
      "containerId": "0_header",
      "x": 0,
      "y": 20,
      "width": 575,
      "height": 40,
      "content": "Families and Insurees",
      "eval": false,
      "styleId": "",
      "bold": true,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "center",
      "verticalAlignment": "middle",
      "textColor": "#6aa84f",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": "24",
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": 1,
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": 2,
      "paddingTop": 2,
      "paddingRight": 2,
      "paddingBottom": 2,
      "printIf": "",
      "removeEmptyElement": false,
      "alwaysPrintOnSamePage": true,
      "pattern": "",
      "link": "",
      "cs_condition": "",
      "cs_styleId": "",
      "cs_bold": false,
      "cs_italic": false,
      "cs_underline": false,
      "cs_strikethrough": false,
      "cs_horizontalAlignment": "left",
      "cs_verticalAlignment": "top",
      "cs_textColor": "#000000",
      "cs_backgroundColor": "",
      "cs_font": "helvetica",
      "cs_fontSize": 12,
      "cs_lineSpacing": 1,
      "cs_borderColor": "#000000",
      "cs_borderWidth": "1",
      "cs_borderAll": false,
      "cs_borderLeft": false,
      "cs_borderTop": false,
      "cs_borderRight": false,
      "cs_borderBottom": false,
      "cs_paddingLeft": 2,
      "cs_paddingTop": 2,
      "cs_paddingRight": 2,
      "cs_paddingBottom": 2,
      "spreadsheet_hide": false,
      "spreadsheet_column": "",
      "spreadsheet_colspan": "",
      "spreadsheet_addEmptyRow": false
    },
    {
      "elementType": "line",
      "id": 158,
      "containerId": "0_content",
      "x": 0,
      "y": 0,
      "width": 575,
      "height": 1,
      "color": "#000000",
      "printIf": ""
    },
    {
      "elementType": "text",
      "id": 193,
      "containerId": "0_content",
      "x": 0,
      "y": 10,
      "width": 575,
      "height": 20,
      "content": "List of families and insurees",
      "eval": false,
      "styleId": "",
      "bold": true,
      "italic": false,
      "underline": true,
      "strikethrough": false,
      "horizontalAlignment": "center",
      "verticalAlignment": "top",
      "textColor": "#000000",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": 12,
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": 1,
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": 2,
      "paddingTop": 2,
      "paddingRight": 2,
      "paddingBottom": 2,
      "printIf": "",
      "removeEmptyElement": false,
      "alwaysPrintOnSamePage": true,
      "pattern": "",
      "link": "",
      "cs_condition": "",
      "cs_styleId": "",
      "cs_bold": false,
      "cs_italic": false,
      "cs_underline": false,
      "cs_strikethrough": false,
      "cs_horizontalAlignment": "left",
      "cs_verticalAlignment": "top",
      "cs_textColor": "#000000",
      "cs_backgroundColor": "",
      "cs_font": "helvetica",
      "cs_fontSize": 12,
      "cs_lineSpacing": 1,
      "cs_borderColor": "#000000",
      "cs_borderWidth": "1",
      "cs_borderAll": false,
      "cs_borderLeft": false,
      "cs_borderTop": false,
      "cs_borderRight": false,
      "cs_borderBottom": false,
      "cs_paddingLeft": 2,
      "cs_paddingTop": 2,
      "cs_paddingRight": 2,
      "cs_paddingBottom": 2,
      "spreadsheet_hide": false,
      "spreadsheet_column": "",
      "spreadsheet_colspan": "",
      "spreadsheet_addEmptyRow": false
    },
    {
      "elementType": "table",
      "id": 195,
      "containerId": "0_content",
      "width": 574,
      "x": 0,
      "y": 40,
      "dataSource": "${data}",
      "columns": 4,
      "header": true,
      "contentRows": 4,
      "footer": false,
      "border": "grid",
      "borderColor": "#000000",
      "borderWidth": "1",
      "printIf": "",
      "removeEmptyElement": false,
      "spreadsheet_hide": false,
      "spreadsheet_column": "",
      "spreadsheet_addEmptyRow": false,
      "headerData": {
        "elementType": "none",
        "id": 196,
        "height": 20,
        "backgroundColor": "",
        "repeatHeader": true,
        "columnData": [
          {
            "elementType": "table_text",
            "id": 197,
            "width": 160,
            "content": "Insurance Number",
            "eval": false,
            "colspan": "",
            "styleId": "33",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": "12",
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "printIf": "",
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 205,
            "width": 175,
            "content": "Name",
            "eval": false,
            "colspan": "",
            "styleId": "33",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": "12",
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "printIf": "",
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 206,
            "width": 168,
            "content": "Enroll Date",
            "eval": false,
            "colspan": "",
            "styleId": "33",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": "12",
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "printIf": "",
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 239,
            "width": 71,
            "content": "Status",
            "eval": false,
            "colspan": "",
            "styleId": "33",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": "12",
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "printIf": "",
            "borderWidth": 1
          }
        ]
      },
      "contentDataRows": [
        {
          "elementType": "none",
          "id": 257,
          "height": 20,
          "backgroundColor": "",
          "alternateBackgroundColor": "",
          "groupExpression": "${district}",
          "printIf": "",
          "alwaysPrintOnSamePage": true,
          "columnData": [
            {
              "elementType": "table_text",
              "id": 258,
              "width": 160,
              "content": "${district}",
              "eval": false,
              "colspan": "4",
              "styleId": "33",
              "bold": true,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "middle",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": "12",
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 259,
              "width": 175,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 260,
              "width": 168,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 261,
              "width": 71,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            }
          ]
        },
        {
          "elementType": "none",
          "id": 252,
          "height": 20,
          "backgroundColor": "",
          "alternateBackgroundColor": "",
          "groupExpression": "${ward}",
          "printIf": "",
          "alwaysPrintOnSamePage": true,
          "columnData": [
            {
              "elementType": "table_text",
              "id": 253,
              "width": 160,
              "content": "   ${ward}",
              "eval": false,
              "colspan": "4",
              "styleId": "33",
              "bold": true,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "middle",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": "12",
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 254,
              "width": 175,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 255,
              "width": 168,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 256,
              "width": 71,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            }
          ]
        },
        {
          "elementType": "none",
          "id": 245,
          "height": 20,
          "backgroundColor": "",
          "alternateBackgroundColor": "",
          "groupExpression": "${village}",
          "printIf": "",
          "alwaysPrintOnSamePage": true,
          "columnData": [
            {
              "elementType": "table_text",
              "id": 246,
              "width": 160,
              "content": "      ${village}",
              "eval": false,
              "colspan": "4",
              "styleId": "33",
              "bold": true,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "middle",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": "12",
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 247,
              "width": 175,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 248,
              "width": 168,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 249,
              "width": 71,
              "content": "",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            }
          ]
        },
        {
          "elementType": "none",
          "id": 199,
          "height": 20,
          "backgroundColor": "",
          "alternateBackgroundColor": "#eeeeee",
          "groupExpression": "",
          "printIf": "",
          "alwaysPrintOnSamePage": false,
          "columnData": [
            {
              "elementType": "table_text",
              "id": 200,
              "width": 160,
              "content": "${chf_id}",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 208,
              "width": 175,
              "content": "${other_names} + ' ' + ${last_name}",
              "eval": true,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 209,
              "width": 168,
              "content": "${enroll_date}",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "yyyy/MM/dd",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            },
            {
              "elementType": "table_text",
              "id": 240,
              "width": 71,
              "content": "${status}",
              "eval": false,
              "colspan": "",
              "styleId": "",
              "bold": false,
              "italic": false,
              "underline": false,
              "strikethrough": false,
              "horizontalAlignment": "left",
              "verticalAlignment": "top",
              "textColor": "#000000",
              "backgroundColor": "",
              "font": "helvetica",
              "fontSize": 12,
              "lineSpacing": 1,
              "paddingLeft": 2,
              "paddingTop": 2,
              "paddingRight": 2,
              "paddingBottom": 2,
              "pattern": "",
              "link": "",
              "cs_condition": "",
              "cs_styleId": "",
              "cs_bold": false,
              "cs_italic": false,
              "cs_underline": false,
              "cs_strikethrough": false,
              "cs_horizontalAlignment": "left",
              "cs_verticalAlignment": "top",
              "cs_textColor": "#000000",
              "cs_backgroundColor": "",
              "cs_font": "helvetica",
              "cs_fontSize": 12,
              "cs_lineSpacing": 1,
              "cs_paddingLeft": 2,
              "cs_paddingTop": 2,
              "cs_paddingRight": 2,
              "cs_paddingBottom": 2,
              "borderWidth": 1
            }
          ]
        }
      ],
      "footerData": {
        "elementType": "none",
        "id": 202,
        "height": 20,
        "backgroundColor": "",
        "columnData": [
          {
            "elementType": "table_text",
            "id": 203,
            "width": 160,
            "content": "",
            "eval": false,
            "colspan": "",
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "top",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": 12,
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 211,
            "width": 175,
            "content": "",
            "eval": false,
            "colspan": "",
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "top",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": 12,
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 212,
            "width": 168,
            "content": "",
            "eval": false,
            "colspan": "",
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "top",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": 12,
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "borderWidth": 1
          },
          {
            "elementType": "table_text",
            "id": 241,
            "width": 71,
            "content": "",
            "eval": false,
            "colspan": "",
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "top",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "helvetica",
            "fontSize": 12,
            "lineSpacing": 1,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "borderWidth": 1
          }
        ]
      }
    },
    {
      "elementType": "text",
      "id": 7,
      "containerId": "0_footer",
      "x": 320,
      "y": 0,
      "width": 255,
      "height": 30,
      "content": "Page ${page_number} / ${page_count}",
      "eval": false,
      "styleId": "",
      "bold": false,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "right",
      "verticalAlignment": "middle",
      "textColor": "#666666",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": 12,
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": 1,
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": 2,
      "paddingTop": 2,
      "paddingRight": 2,
      "paddingBottom": 2,
      "printIf": "",
      "removeEmptyElement": false,
      "alwaysPrintOnSamePage": true,
      "pattern": "",
      "link": "",
      "cs_condition": "",
      "cs_styleId": "",
      "cs_bold": false,
      "cs_italic": false,
      "cs_underline": false,
      "cs_strikethrough": false,
      "cs_horizontalAlignment": "left",
      "cs_verticalAlignment": "top",
      "cs_textColor": "#000000",
      "cs_backgroundColor": "",
      "cs_font": "helvetica",
      "cs_fontSize": 12,
      "cs_lineSpacing": 1,
      "cs_borderColor": "#000000",
      "cs_borderWidth": "1",
      "cs_borderAll": false,
      "cs_borderLeft": false,
      "cs_borderTop": false,
      "cs_borderRight": false,
      "cs_borderBottom": false,
      "cs_paddingLeft": 2,
      "cs_paddingTop": 2,
      "cs_paddingRight": 2,
      "cs_paddingBottom": 2,
      "spreadsheet_hide": false,
      "spreadsheet_column": "",
      "spreadsheet_colspan": "",
      "spreadsheet_addEmptyRow": false
    },
    {
      "elementType": "text",
      "id": 8,
      "containerId": "0_footer",
      "x": 0,
      "y": 0,
      "width": 290,
      "height": 30,
      "content": "Created on ${current_date}",
      "eval": false,
      "styleId": "",
      "bold": false,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "left",
      "verticalAlignment": "middle",
      "textColor": "#666666",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": 12,
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": 1,
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": 2,
      "paddingTop": 2,
      "paddingRight": 2,
      "paddingBottom": 2,
      "printIf": "",
      "removeEmptyElement": false,
      "alwaysPrintOnSamePage": true,
      "pattern": "",
      "link": "",
      "cs_condition": "",
      "cs_styleId": "",
      "cs_bold": false,
      "cs_italic": false,
      "cs_underline": false,
      "cs_strikethrough": false,
      "cs_horizontalAlignment": "left",
      "cs_verticalAlignment": "top",
      "cs_textColor": "#000000",
      "cs_backgroundColor": "",
      "cs_font": "helvetica",
      "cs_fontSize": 12,
      "cs_lineSpacing": 1,
      "cs_borderColor": "#000000",
      "cs_borderWidth": "1",
      "cs_borderAll": false,
      "cs_borderLeft": false,
      "cs_borderTop": false,
      "cs_borderRight": false,
      "cs_borderBottom": false,
      "cs_paddingLeft": 2,
      "cs_paddingTop": 2,
      "cs_paddingRight": 2,
      "cs_paddingBottom": 2,
      "spreadsheet_hide": false,
      "spreadsheet_column": "",
      "spreadsheet_colspan": "",
      "spreadsheet_addEmptyRow": false
    }
  ],
  "parameters": [
    {
      "id": 1,
      "name": "page_count",
      "type": "number",
      "arrayItemType": "string",
      "eval": false,
      "nullable": false,
      "pattern": "",
      "expression": "",
      "showOnlyNameType": true,
      "testData": ""
    },
    {
      "id": 2,
      "name": "page_number",
      "type": "number",
      "arrayItemType": "string",
      "eval": false,
      "nullable": false,
      "pattern": "",
      "expression": "",
      "showOnlyNameType": true,
      "testData": ""
    },
    {
      "id": 9,
      "name": "current_date",
      "type": "date",
      "arrayItemType": "string",
      "eval": false,
      "nullable": false,
      "pattern": "d/M/yyyy H:mm",
      "expression": "",
      "showOnlyNameType": false,
      "testData": ""
    },
    {
      "id": 233,
      "name": "data",
      "type": "array",
      "arrayItemType": "string",
      "eval": false,
      "nullable": false,
      "pattern": "",
      "expression": "",
      "showOnlyNameType": false,
      "testData": "[{\\"chf_id\\":\\"1234567\\",\\"other_names\\":\\"oth\\",\\"last_name\\":\\"last\\",\\"enroll_date\\":\\"2022-01-01\\",\\"status\\":\\"READY\\",\\"village\\":\\"foo\\",\\"ward\\":\\"bar\\",\\"district\\":\\"klet\\"}]",
      "children": [
        {
          "id": 234,
          "name": "row_number",
          "type": "number",
          "arrayItemType": "string",
          "eval": false,
          "nullable": false,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": true,
          "testData": ""
        },
        {
          "id": 235,
          "name": "chf_id",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 236,
          "name": "other_names",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 262,
          "name": "last_name",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": false,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 237,
          "name": "enroll_date",
          "type": "date",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 242,
          "name": "status",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 244,
          "name": "village",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 250,
          "name": "ward",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        },
        {
          "id": 251,
          "name": "district",
          "type": "string",
          "arrayItemType": "string",
          "eval": false,
          "nullable": true,
          "pattern": "",
          "expression": "",
          "showOnlyNameType": false,
          "testData": ""
        }
      ]
    }
  ],
  "styles": [
    {
      "id": 33,
      "name": "Table Header",
      "bold": true,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "left",
      "verticalAlignment": "middle",
      "textColor": "#000000",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": "12",
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": "1",
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": "2",
      "paddingTop": "2",
      "paddingRight": "2",
      "paddingBottom": "2"
    },
    {
      "id": 34,
      "name": "Table Content",
      "bold": false,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "left",
      "verticalAlignment": "middle",
      "textColor": "#000000",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": "9",
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": "1",
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": "2",
      "paddingTop": "2",
      "paddingRight": "2",
      "paddingBottom": "2"
    },
    {
      "id": 35,
      "name": "Table Content Highlight",
      "bold": true,
      "italic": false,
      "underline": false,
      "strikethrough": false,
      "horizontalAlignment": "center",
      "verticalAlignment": "middle",
      "textColor": "#3d85c6",
      "backgroundColor": "",
      "font": "helvetica",
      "fontSize": "9",
      "lineSpacing": 1,
      "borderColor": "#000000",
      "borderWidth": "1",
      "borderAll": false,
      "borderLeft": false,
      "borderTop": false,
      "borderRight": false,
      "borderBottom": false,
      "paddingLeft": "2",
      "paddingTop": "2",
      "paddingRight": "2",
      "paddingBottom": "2"
    }
  ],
  "version": 3,
  "documentProperties": {
    "pageFormat": "A4",
    "pageWidth": "",
    "pageHeight": "",
    "unit": "mm",
    "orientation": "portrait",
    "contentHeight": "",
    "marginLeft": "10",
    "marginTop": "10",
    "marginRight": "10",
    "marginBottom": "10",
    "header": true,
    "headerSize": "80",
    "headerDisplay": "always",
    "footer": true,
    "footerSize": "30",
    "footerDisplay": "always",
    "patternLocale": "en",
    "patternCurrencySymbol": "$"
  }
}
"""


def insuree_family_overview_query(user, date_from=None, date_to=None, **kwargs):
    from ..models import Insuree
    from core import datetimedelta

    filters = Q(legacy_id__isnull=True) & Q(family__legacy_id__isnull=True)
    # TODO verify that we should use the validity_from and not the enrolment_date
    # TODO verify the day+1 approach
    if date_from:
        filters &= Q(validity_from__gte=date_from)
    if date_to:
        filters &= Q(validity_from__lte=date_to + datetimedelta(days=1))

    # TODO use auth from Quentin's PR
    # if settings.ROW_SECURITY:
    #     from location.models import UserDistrict
    #     dist = UserDistrict.get_user_districts(user._u)
    #     queryset = queryset.filter(
    #         health_facility__location__id__in=[l.location_id for l in dist]
    #     )

    queryset = (
        Insuree.objects.filter(filters)
        .values(
            "chf_id",
            "other_names",
            "last_name",
            enroll_date=F("validity_from"),
            village=F("family__location__name"),
            ward=F("family__location__parent__name"),
            district=F("family__location__parent__parent__name"),
        )
        .order_by("district", "ward", "village", "chf_id")
    )

    return {"data": list(queryset)}
