# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['waifu2x', 'waifu2x.loss']

package_data = \
{'': ['*'],
 'waifu2x': ['models/resnet10/*',
             'models/upconv7/*',
             'models/upresnet10/*',
             'models/vgg7/*']}

install_requires = \
['Pillow>=8.1.2,<10', 'Wand>=0.6.6,<2', 'chainer>=7.7.0,<9', 'numpy>=1.20.1,<3']

entry_points = \
{'console_scripts': ['waifu2x = waifu2x:main']}

setup_kwargs = {
    'name': 'waifu2x',
    'version': '2021.2',
    'description': 'Chainer implementation of waifu2x',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/Waifu2x.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/waifu2x.svg?style=for-the-badge)](https://pypistats.org/packages/waifu2x)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fwaifu2x)](https://pepy.tech/project/waifu2x)\n[![PyPI Version](https://img.shields.io/pypi/v/waifu2x.svg?style=for-the-badge)](https://pypi.org/project/waifu2x)\n\n<!-- omit in toc -->\n# Waifu2x\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nChainer implementation of waifu2x.\n\n## Help\n\n```raw\nusage: __main__.py [-h] [--gpu GPU] [--input INPUT] [--output OUTPUT]\n                   [--quality QUALITY] [--model_dir MODEL_DIR]\n                   [--scale_ratio SCALE_RATIO] [--tta]\n                   [--batch_size BATCH_SIZE] [--block_size BLOCK_SIZE]\n                   [--extension {png,webp}]\n                   [--arch {VGG7,0,UpConv7,1,ResNet10,2,UpResNet10,3}]\n                   [--method {noise,scale,noise_scale}]\n                   [--noise_level {0,1,2,3}] [--color {y,rgb}]\n                   [--tta_level {2,4,8}]\n                   [--width WIDTH | --height HEIGHT | --shorter_side SHORTER_SIDE | --longer_side LONGER_SIDE]\n\nChainer implementation of waifu2x\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --gpu GPU, -g GPU\n  --input INPUT, -i INPUT\n  --output OUTPUT, -o OUTPUT\n  --quality QUALITY, -q QUALITY\n  --model_dir MODEL_DIR, -d MODEL_DIR\n  --scale_ratio SCALE_RATIO, -s SCALE_RATIO\n  --tta, -t\n  --batch_size BATCH_SIZE, -b BATCH_SIZE\n  --block_size BLOCK_SIZE, -l BLOCK_SIZE\n  --extension {png,webp}, -e {png,webp}\n  --arch {VGG7,0,UpConv7,1,ResNet10,2,UpResNet10,3}, -a {VGG7,0,UpConv7,1,ResNet10,2,UpResNet10,3}\n  --method {noise,scale,noise_scale}, -m {noise,scale,noise_scale}\n  --noise_level {0,1,2,3}, -n {0,1,2,3}\n  --color {y,rgb}, -c {y,rgb}\n  --tta_level {2,4,8}, -T {2,4,8}\n  --width WIDTH, -W WIDTH\n  --height HEIGHT, -H HEIGHT\n  --shorter_side SHORTER_SIDE, -S SHORTER_SIDE\n  --longer_side LONGER_SIDE, -L LONGER_SIDE\n```\n\n<!-- omit in toc -->\n## Table of Contents\n\n- [Help](#help)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n\n```python\npip install waifu2x\n```\n\nHead to https://pypi.org/project/Waifu2x/ for more info\n\n## Language information\n\n### Built for\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/Waifu2x\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\nMIT License\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/waifu2x',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
