# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AddGroupMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        access_level: int = None,
        aliyun_pks: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.access_level = access_level
        self.aliyun_pks = aliyun_pks
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.aliyun_pks is not None:
            result['aliyunPks'] = self.aliyun_pks
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('aliyunPks') is not None:
            self.aliyun_pks = m.get('aliyunPks')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class AddGroupMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        source_id: int = None,
        state: str = None,
        username: str = None,
    ):
        self.access_level = access_level
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.source_id = source_id
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class AddGroupMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[AddGroupMemberResponseBodyResult] = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = AddGroupMemberResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddGroupMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGroupMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGroupMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPipelineRelationsRequest(TeaModel):
    def __init__(
        self,
        rel_object_ids: str = None,
        rel_object_type: str = None,
    ):
        self.rel_object_ids = rel_object_ids
        self.rel_object_type = rel_object_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rel_object_ids is not None:
            result['relObjectIds'] = self.rel_object_ids
        if self.rel_object_type is not None:
            result['relObjectType'] = self.rel_object_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('relObjectIds') is not None:
            self.rel_object_ids = m.get('relObjectIds')
        if m.get('relObjectType') is not None:
            self.rel_object_type = m.get('relObjectType')
        return self


class AddPipelineRelationsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddPipelineRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddPipelineRelationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPipelineRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddRepositoryMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        access_level: int = None,
        aliyun_pks: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.access_level = access_level
        self.aliyun_pks = aliyun_pks
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.aliyun_pks is not None:
            result['aliyunPks'] = self.aliyun_pks
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('aliyunPks') is not None:
            self.aliyun_pks = m.get('aliyunPks')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class AddRepositoryMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        state: str = None,
    ):
        self.access_level = access_level
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class AddRepositoryMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[AddRepositoryMemberResponseBodyResult] = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = AddRepositoryMemberResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddRepositoryMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddRepositoryMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddRepositoryMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWebhookRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        description: str = None,
        enable_ssl_verification: bool = None,
        merge_requests_events: bool = None,
        note_events: bool = None,
        push_events: bool = None,
        secret_token: str = None,
        tag_push_events: bool = None,
        url: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.description = description
        self.enable_ssl_verification = enable_ssl_verification
        self.merge_requests_events = merge_requests_events
        self.note_events = note_events
        self.push_events = push_events
        self.secret_token = secret_token
        self.tag_push_events = tag_push_events
        self.url = url
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.description is not None:
            result['description'] = self.description
        if self.enable_ssl_verification is not None:
            result['enableSslVerification'] = self.enable_ssl_verification
        if self.merge_requests_events is not None:
            result['mergeRequestsEvents'] = self.merge_requests_events
        if self.note_events is not None:
            result['noteEvents'] = self.note_events
        if self.push_events is not None:
            result['pushEvents'] = self.push_events
        if self.secret_token is not None:
            result['secretToken'] = self.secret_token
        if self.tag_push_events is not None:
            result['tagPushEvents'] = self.tag_push_events
        if self.url is not None:
            result['url'] = self.url
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableSslVerification') is not None:
            self.enable_ssl_verification = m.get('enableSslVerification')
        if m.get('mergeRequestsEvents') is not None:
            self.merge_requests_events = m.get('mergeRequestsEvents')
        if m.get('noteEvents') is not None:
            self.note_events = m.get('noteEvents')
        if m.get('pushEvents') is not None:
            self.push_events = m.get('pushEvents')
        if m.get('secretToken') is not None:
            self.secret_token = m.get('secretToken')
        if m.get('tagPushEvents') is not None:
            self.tag_push_events = m.get('tagPushEvents')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class AddWebhookResponseBodyResult(TeaModel):
    def __init__(
        self,
        created_at: str = None,
        description: str = None,
        enable_ssl_verification: bool = None,
        id: int = None,
        last_test_result: str = None,
        merge_requests_events: bool = None,
        note_events: bool = None,
        push_events: bool = None,
        repository_id: int = None,
        secret_token: str = None,
        tag_push_events: bool = None,
        url: str = None,
    ):
        self.created_at = created_at
        self.description = description
        self.enable_ssl_verification = enable_ssl_verification
        self.id = id
        self.last_test_result = last_test_result
        self.merge_requests_events = merge_requests_events
        self.note_events = note_events
        self.push_events = push_events
        self.repository_id = repository_id
        self.secret_token = secret_token
        self.tag_push_events = tag_push_events
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.description is not None:
            result['description'] = self.description
        if self.enable_ssl_verification is not None:
            result['enableSslVerification'] = self.enable_ssl_verification
        if self.id is not None:
            result['id'] = self.id
        if self.last_test_result is not None:
            result['lastTestResult'] = self.last_test_result
        if self.merge_requests_events is not None:
            result['mergeRequestsEvents'] = self.merge_requests_events
        if self.note_events is not None:
            result['noteEvents'] = self.note_events
        if self.push_events is not None:
            result['pushEvents'] = self.push_events
        if self.repository_id is not None:
            result['repositoryId'] = self.repository_id
        if self.secret_token is not None:
            result['secretToken'] = self.secret_token
        if self.tag_push_events is not None:
            result['tagPushEvents'] = self.tag_push_events
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableSslVerification') is not None:
            self.enable_ssl_verification = m.get('enableSslVerification')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('lastTestResult') is not None:
            self.last_test_result = m.get('lastTestResult')
        if m.get('mergeRequestsEvents') is not None:
            self.merge_requests_events = m.get('mergeRequestsEvents')
        if m.get('noteEvents') is not None:
            self.note_events = m.get('noteEvents')
        if m.get('pushEvents') is not None:
            self.push_events = m.get('pushEvents')
        if m.get('repositoryId') is not None:
            self.repository_id = m.get('repositoryId')
        if m.get('secretToken') is not None:
            self.secret_token = m.get('secretToken')
        if m.get('tagPushEvents') is not None:
            self.tag_push_events = m.get('tagPushEvents')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class AddWebhookResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: AddWebhookResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = AddWebhookResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddWebhookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddWebhookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWebhookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseMergeRequestRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CloseMergeRequestResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CloseMergeRequestResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CloseMergeRequestResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CloseMergeRequestResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CloseMergeRequestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CloseMergeRequestResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseMergeRequestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBranchRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        branch_name: str = None,
        ref: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.branch_name = branch_name
        self.ref = ref
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.ref is not None:
            result['ref'] = self.ref
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('ref') is not None:
            self.ref = m.get('ref')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateBranchResponseBodyResultCommit(TeaModel):
    def __init__(
        self,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        committed_date: str = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        title: str = None,
    ):
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.committed_date = committed_date
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CreateBranchResponseBodyResult(TeaModel):
    def __init__(
        self,
        commit: CreateBranchResponseBodyResultCommit = None,
        name: str = None,
        protected: bool = None,
    ):
        self.commit = commit
        self.name = name
        self.protected = protected

    def validate(self):
        if self.commit:
            self.commit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit is not None:
            result['commit'] = self.commit.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.protected is not None:
            result['protected'] = self.protected
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commit') is not None:
            temp_model = CreateBranchResponseBodyResultCommit()
            self.commit = temp_model.from_map(m['commit'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('protected') is not None:
            self.protected = m.get('protected')
        return self


class CreateBranchResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateBranchResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateBranchResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateBranchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBranchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBranchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeployKeyRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        key: str = None,
        title: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.key = key
        self.title = title
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.key is not None:
            result['key'] = self.key
        if self.title is not None:
            result['title'] = self.title
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateDeployKeyResponseBodyResult(TeaModel):
    def __init__(
        self,
        created_at: str = None,
        fingerprint: str = None,
        id: int = None,
        key: str = None,
        title: str = None,
    ):
        self.created_at = created_at
        self.fingerprint = fingerprint
        self.id = id
        self.key = key
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.fingerprint is not None:
            result['fingerprint'] = self.fingerprint
        if self.id is not None:
            result['id'] = self.id
        if self.key is not None:
            result['key'] = self.key
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('fingerprint') is not None:
            self.fingerprint = m.get('fingerprint')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CreateDeployKeyResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateDeployKeyResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateDeployKeyResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateDeployKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDeployKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeployKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        branch_name: str = None,
        commit_message: str = None,
        content: str = None,
        encoding: str = None,
        file_path: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.branch_name = branch_name
        self.commit_message = commit_message
        self.content = content
        self.encoding = encoding
        self.file_path = file_path
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.commit_message is not None:
            result['commitMessage'] = self.commit_message
        if self.content is not None:
            result['content'] = self.content
        if self.encoding is not None:
            result['encoding'] = self.encoding
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('commitMessage') is not None:
            self.commit_message = m.get('commitMessage')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('encoding') is not None:
            self.encoding = m.get('encoding')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateFileResponseBodyResult(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
        file_path: str = None,
    ):
        self.branch_name = branch_name
        self.file_path = file_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.file_path is not None:
            result['filePath'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        return self


class CreateFileResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateFileResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateFileResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowTagRequest(TeaModel):
    def __init__(
        self,
        color: str = None,
        flow_tag_group_id: int = None,
        name: str = None,
    ):
        self.color = color
        self.flow_tag_group_id = flow_tag_group_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.color is not None:
            result['color'] = self.color
        if self.flow_tag_group_id is not None:
            result['flowTagGroupId'] = self.flow_tag_group_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('color') is not None:
            self.color = m.get('color')
        if m.get('flowTagGroupId') is not None:
            self.flow_tag_group_id = m.get('flowTagGroupId')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateFlowTagResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.id = id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateFlowTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFlowTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFlowTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowTagGroupRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateFlowTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.id = id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateFlowTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFlowTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFlowTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHostGroupRequest(TeaModel):
    def __init__(
        self,
        aliyun_region: str = None,
        ecs_label_key: str = None,
        ecs_label_value: str = None,
        ecs_type: str = None,
        env_id: str = None,
        machine_infos: str = None,
        name: str = None,
        service_connection_id: int = None,
        tag_ids: str = None,
        type: str = None,
    ):
        self.aliyun_region = aliyun_region
        self.ecs_label_key = ecs_label_key
        self.ecs_label_value = ecs_label_value
        self.ecs_type = ecs_type
        self.env_id = env_id
        self.machine_infos = machine_infos
        self.name = name
        self.service_connection_id = service_connection_id
        self.tag_ids = tag_ids
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_region is not None:
            result['aliyunRegion'] = self.aliyun_region
        if self.ecs_label_key is not None:
            result['ecsLabelKey'] = self.ecs_label_key
        if self.ecs_label_value is not None:
            result['ecsLabelValue'] = self.ecs_label_value
        if self.ecs_type is not None:
            result['ecsType'] = self.ecs_type
        if self.env_id is not None:
            result['envId'] = self.env_id
        if self.machine_infos is not None:
            result['machineInfos'] = self.machine_infos
        if self.name is not None:
            result['name'] = self.name
        if self.service_connection_id is not None:
            result['serviceConnectionId'] = self.service_connection_id
        if self.tag_ids is not None:
            result['tagIds'] = self.tag_ids
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aliyunRegion') is not None:
            self.aliyun_region = m.get('aliyunRegion')
        if m.get('ecsLabelKey') is not None:
            self.ecs_label_key = m.get('ecsLabelKey')
        if m.get('ecsLabelValue') is not None:
            self.ecs_label_value = m.get('ecsLabelValue')
        if m.get('ecsType') is not None:
            self.ecs_type = m.get('ecsType')
        if m.get('envId') is not None:
            self.env_id = m.get('envId')
        if m.get('machineInfos') is not None:
            self.machine_infos = m.get('machineInfos')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('serviceConnectionId') is not None:
            self.service_connection_id = m.get('serviceConnectionId')
        if m.get('tagIds') is not None:
            self.tag_ids = m.get('tagIds')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        host_group_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.host_group_id = host_group_id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.host_group_id is not None:
            result['hostGroupId'] = self.host_group_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('hostGroupId') is not None:
            self.host_group_id = m.get('hostGroupId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMergeRequestRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        create_from: str = None,
        description: str = None,
        reviewer_ids: List[str] = None,
        source_branch: str = None,
        source_project_id: int = None,
        target_branch: str = None,
        target_project_id: int = None,
        title: str = None,
        work_item_ids: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.create_from = create_from
        self.description = description
        self.reviewer_ids = reviewer_ids
        self.source_branch = source_branch
        self.source_project_id = source_project_id
        self.target_branch = target_branch
        self.target_project_id = target_project_id
        self.title = title
        self.work_item_ids = work_item_ids
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.create_from is not None:
            result['createFrom'] = self.create_from
        if self.description is not None:
            result['description'] = self.description
        if self.reviewer_ids is not None:
            result['reviewerIds'] = self.reviewer_ids
        if self.source_branch is not None:
            result['sourceBranch'] = self.source_branch
        if self.source_project_id is not None:
            result['sourceProjectId'] = self.source_project_id
        if self.target_branch is not None:
            result['targetBranch'] = self.target_branch
        if self.target_project_id is not None:
            result['targetProjectId'] = self.target_project_id
        if self.title is not None:
            result['title'] = self.title
        if self.work_item_ids is not None:
            result['workItemIds'] = self.work_item_ids
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('createFrom') is not None:
            self.create_from = m.get('createFrom')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('reviewerIds') is not None:
            self.reviewer_ids = m.get('reviewerIds')
        if m.get('sourceBranch') is not None:
            self.source_branch = m.get('sourceBranch')
        if m.get('sourceProjectId') is not None:
            self.source_project_id = m.get('sourceProjectId')
        if m.get('targetBranch') is not None:
            self.target_branch = m.get('targetBranch')
        if m.get('targetProjectId') is not None:
            self.target_project_id = m.get('targetProjectId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('workItemIds') is not None:
            self.work_item_ids = m.get('workItemIds')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateMergeRequestResponseBodyResultAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateMergeRequestResponseBodyResultReviewers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        has_reviewed: bool = None,
        id: int = None,
        name: str = None,
        review_opinion_status: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.has_reviewed = has_reviewed
        self.id = id
        self.name = name
        self.review_opinion_status = review_opinion_status
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.has_reviewed is not None:
            result['hasReviewed'] = self.has_reviewed
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.review_opinion_status is not None:
            result['reviewOpinionStatus'] = self.review_opinion_status
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('hasReviewed') is not None:
            self.has_reviewed = m.get('hasReviewed')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('reviewOpinionStatus') is not None:
            self.review_opinion_status = m.get('reviewOpinionStatus')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateMergeRequestResponseBodyResultSubscribers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateMergeRequestResponseBodyResult(TeaModel):
    def __init__(
        self,
        ahead: int = None,
        all_requirements_pass: bool = None,
        author: CreateMergeRequestResponseBodyResultAuthor = None,
        behind: int = None,
        create_from: str = None,
        create_time: str = None,
        description: str = None,
        detail_url: str = None,
        local_id: int = None,
        mr_biz_id: str = None,
        mr_type: str = None,
        project_id: int = None,
        reviewers: List[CreateMergeRequestResponseBodyResultReviewers] = None,
        source_branch: str = None,
        source_project_id: int = None,
        status: str = None,
        subscribers: List[CreateMergeRequestResponseBodyResultSubscribers] = None,
        support_merge_fast_forward_only: bool = None,
        target_branch: str = None,
        target_project_id: int = None,
        title: str = None,
        update_time: str = None,
        web_url: str = None,
    ):
        self.ahead = ahead
        self.all_requirements_pass = all_requirements_pass
        self.author = author
        self.behind = behind
        self.create_from = create_from
        self.create_time = create_time
        self.description = description
        self.detail_url = detail_url
        self.local_id = local_id
        self.mr_biz_id = mr_biz_id
        self.mr_type = mr_type
        self.project_id = project_id
        self.reviewers = reviewers
        self.source_branch = source_branch
        self.source_project_id = source_project_id
        self.status = status
        self.subscribers = subscribers
        self.support_merge_fast_forward_only = support_merge_fast_forward_only
        self.target_branch = target_branch
        self.target_project_id = target_project_id
        self.title = title
        self.update_time = update_time
        self.web_url = web_url

    def validate(self):
        if self.author:
            self.author.validate()
        if self.reviewers:
            for k in self.reviewers:
                if k:
                    k.validate()
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ahead is not None:
            result['ahead'] = self.ahead
        if self.all_requirements_pass is not None:
            result['allRequirementsPass'] = self.all_requirements_pass
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.behind is not None:
            result['behind'] = self.behind
        if self.create_from is not None:
            result['createFrom'] = self.create_from
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url is not None:
            result['detailUrl'] = self.detail_url
        if self.local_id is not None:
            result['localId'] = self.local_id
        if self.mr_biz_id is not None:
            result['mrBizId'] = self.mr_biz_id
        if self.mr_type is not None:
            result['mrType'] = self.mr_type
        if self.project_id is not None:
            result['projectId'] = self.project_id
        result['reviewers'] = []
        if self.reviewers is not None:
            for k in self.reviewers:
                result['reviewers'].append(k.to_map() if k else None)
        if self.source_branch is not None:
            result['sourceBranch'] = self.source_branch
        if self.source_project_id is not None:
            result['sourceProjectId'] = self.source_project_id
        if self.status is not None:
            result['status'] = self.status
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.support_merge_fast_forward_only is not None:
            result['supportMergeFastForwardOnly'] = self.support_merge_fast_forward_only
        if self.target_branch is not None:
            result['targetBranch'] = self.target_branch
        if self.target_project_id is not None:
            result['targetProjectId'] = self.target_project_id
        if self.title is not None:
            result['title'] = self.title
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ahead') is not None:
            self.ahead = m.get('ahead')
        if m.get('allRequirementsPass') is not None:
            self.all_requirements_pass = m.get('allRequirementsPass')
        if m.get('author') is not None:
            temp_model = CreateMergeRequestResponseBodyResultAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('behind') is not None:
            self.behind = m.get('behind')
        if m.get('createFrom') is not None:
            self.create_from = m.get('createFrom')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            self.detail_url = m.get('detailUrl')
        if m.get('localId') is not None:
            self.local_id = m.get('localId')
        if m.get('mrBizId') is not None:
            self.mr_biz_id = m.get('mrBizId')
        if m.get('mrType') is not None:
            self.mr_type = m.get('mrType')
        if m.get('projectId') is not None:
            self.project_id = m.get('projectId')
        self.reviewers = []
        if m.get('reviewers') is not None:
            for k in m.get('reviewers'):
                temp_model = CreateMergeRequestResponseBodyResultReviewers()
                self.reviewers.append(temp_model.from_map(k))
        if m.get('sourceBranch') is not None:
            self.source_branch = m.get('sourceBranch')
        if m.get('sourceProjectId') is not None:
            self.source_project_id = m.get('sourceProjectId')
        if m.get('status') is not None:
            self.status = m.get('status')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = CreateMergeRequestResponseBodyResultSubscribers()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('supportMergeFastForwardOnly') is not None:
            self.support_merge_fast_forward_only = m.get('supportMergeFastForwardOnly')
        if m.get('targetBranch') is not None:
            self.target_branch = m.get('targetBranch')
        if m.get('targetProjectId') is not None:
            self.target_project_id = m.get('targetProjectId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class CreateMergeRequestResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateMergeRequestResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateMergeRequestResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateMergeRequestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMergeRequestResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMergeRequestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOAuthTokenRequest(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_secret: str = None,
        code: str = None,
        grant_type: str = None,
        login: str = None,
        scope: str = None,
    ):
        # clientId
        self.client_id = client_id
        # client_secret
        self.client_secret = client_secret
        self.code = code
        self.grant_type = grant_type
        self.login = login
        self.scope = scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['clientId'] = self.client_id
        if self.client_secret is not None:
            result['clientSecret'] = self.client_secret
        if self.code is not None:
            result['code'] = self.code
        if self.grant_type is not None:
            result['grantType'] = self.grant_type
        if self.login is not None:
            result['login'] = self.login
        if self.scope is not None:
            result['scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientId') is not None:
            self.client_id = m.get('clientId')
        if m.get('clientSecret') is not None:
            self.client_secret = m.get('clientSecret')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('grantType') is not None:
            self.grant_type = m.get('grantType')
        if m.get('login') is not None:
            self.login = m.get('login')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        return self


class CreateOAuthTokenResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        id: str = None,
        scope: str = None,
        token_type: str = None,
    ):
        self.access_token = access_token
        # id
        self.id = id
        self.scope = scope
        self.token_type = token_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.id is not None:
            result['id'] = self.id
        if self.scope is not None:
            result['scope'] = self.scope
        if self.token_type is not None:
            result['tokenType'] = self.token_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('tokenType') is not None:
            self.token_type = m.get('tokenType')
        return self


class CreateOAuthTokenResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateOAuthTokenResponseBodyResult = None,
        success: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateOAuthTokenResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateOAuthTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOAuthTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOAuthTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePipelineRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        name: str = None,
    ):
        self.content = content
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreatePipelineResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipelin_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipelin_id = pipelin_id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.pipelin_id is not None:
            result['pipelinId'] = self.pipelin_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('pipelinId') is not None:
            self.pipelin_id = m.get('pipelinId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreatePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePipelineGroupRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreatePipelineGroupResponseBodyPipelineGroup(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreatePipelineGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipeline_group: CreatePipelineGroupResponseBodyPipelineGroup = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipeline_group = pipeline_group
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.pipeline_group:
            self.pipeline_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.pipeline_group is not None:
            result['pipelineGroup'] = self.pipeline_group.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('pipelineGroup') is not None:
            temp_model = CreatePipelineGroupResponseBodyPipelineGroup()
            self.pipeline_group = temp_model.from_map(m['pipelineGroup'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreatePipelineGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePipelineGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePipelineGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectRequest(TeaModel):
    def __init__(
        self,
        custom_code: str = None,
        name: str = None,
        scope: str = None,
        template_identifier: str = None,
    ):
        self.custom_code = custom_code
        self.name = name
        self.scope = scope
        self.template_identifier = template_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.name is not None:
            result['name'] = self.name
        if self.scope is not None:
            result['scope'] = self.scope
        if self.template_identifier is not None:
            result['templateIdentifier'] = self.template_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('templateIdentifier') is not None:
            self.template_identifier = m.get('templateIdentifier')
        return self


class CreateProjectResponseBodyProject(TeaModel):
    def __init__(
        self,
        category_identifier: str = None,
        creator: str = None,
        custom_code: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        icon: str = None,
        identifier: str = None,
        logical_status: str = None,
        modifier: str = None,
        name: str = None,
        organization_identifier: str = None,
        scope: str = None,
        status_identifier: str = None,
        status_stage_identifier: str = None,
        type_identifier: str = None,
    ):
        self.category_identifier = category_identifier
        self.creator = creator
        self.custom_code = custom_code
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.icon = icon
        self.identifier = identifier
        self.logical_status = logical_status
        self.modifier = modifier
        self.name = name
        self.organization_identifier = organization_identifier
        self.scope = scope
        self.status_identifier = status_identifier
        self.status_stage_identifier = status_stage_identifier
        self.type_identifier = type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.icon is not None:
            result['icon'] = self.icon
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.logical_status is not None:
            result['logicalStatus'] = self.logical_status
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.organization_identifier is not None:
            result['organizationIdentifier'] = self.organization_identifier
        if self.scope is not None:
            result['scope'] = self.scope
        if self.status_identifier is not None:
            result['statusIdentifier'] = self.status_identifier
        if self.status_stage_identifier is not None:
            result['statusStageIdentifier'] = self.status_stage_identifier
        if self.type_identifier is not None:
            result['typeIdentifier'] = self.type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('logicalStatus') is not None:
            self.logical_status = m.get('logicalStatus')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organizationIdentifier') is not None:
            self.organization_identifier = m.get('organizationIdentifier')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('statusIdentifier') is not None:
            self.status_identifier = m.get('statusIdentifier')
        if m.get('statusStageIdentifier') is not None:
            self.status_stage_identifier = m.get('statusStageIdentifier')
        if m.get('typeIdentifier') is not None:
            self.type_identifier = m.get('typeIdentifier')
        return self


class CreateProjectResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        project: CreateProjectResponseBodyProject = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.project = project
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.project is not None:
            result['project'] = self.project.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('project') is not None:
            temp_model = CreateProjectResponseBodyProject()
            self.project = temp_model.from_map(m['project'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProtectdBranchRequestMergeRequestSetting(TeaModel):
    def __init__(
        self,
        allow_merge_request_roles: List[int] = None,
        default_assignees: List[str] = None,
        is_allow_self_approval: bool = None,
        is_require_discussion_processed: bool = None,
        is_required: bool = None,
        is_reset_approval_when_new_push: bool = None,
        minimum_approval: int = None,
        mr_mode: str = None,
        white_list: str = None,
    ):
        self.allow_merge_request_roles = allow_merge_request_roles
        self.default_assignees = default_assignees
        self.is_allow_self_approval = is_allow_self_approval
        self.is_require_discussion_processed = is_require_discussion_processed
        self.is_required = is_required
        self.is_reset_approval_when_new_push = is_reset_approval_when_new_push
        self.minimum_approval = minimum_approval
        self.mr_mode = mr_mode
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_merge_request_roles is not None:
            result['allowMergeRequestRoles'] = self.allow_merge_request_roles
        if self.default_assignees is not None:
            result['defaultAssignees'] = self.default_assignees
        if self.is_allow_self_approval is not None:
            result['isAllowSelfApproval'] = self.is_allow_self_approval
        if self.is_require_discussion_processed is not None:
            result['isRequireDiscussionProcessed'] = self.is_require_discussion_processed
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.is_reset_approval_when_new_push is not None:
            result['isResetApprovalWhenNewPush'] = self.is_reset_approval_when_new_push
        if self.minimum_approval is not None:
            result['minimumApproval'] = self.minimum_approval
        if self.mr_mode is not None:
            result['mrMode'] = self.mr_mode
        if self.white_list is not None:
            result['whiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowMergeRequestRoles') is not None:
            self.allow_merge_request_roles = m.get('allowMergeRequestRoles')
        if m.get('defaultAssignees') is not None:
            self.default_assignees = m.get('defaultAssignees')
        if m.get('isAllowSelfApproval') is not None:
            self.is_allow_self_approval = m.get('isAllowSelfApproval')
        if m.get('isRequireDiscussionProcessed') is not None:
            self.is_require_discussion_processed = m.get('isRequireDiscussionProcessed')
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('isResetApprovalWhenNewPush') is not None:
            self.is_reset_approval_when_new_push = m.get('isResetApprovalWhenNewPush')
        if m.get('minimumApproval') is not None:
            self.minimum_approval = m.get('minimumApproval')
        if m.get('mrMode') is not None:
            self.mr_mode = m.get('mrMode')
        if m.get('whiteList') is not None:
            self.white_list = m.get('whiteList')
        return self


class CreateProtectdBranchRequestTestSettingDTOCheckConfigCheckItems(TeaModel):
    def __init__(
        self,
        is_required: bool = None,
        name: str = None,
    ):
        self.is_required = is_required
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateProtectdBranchRequestTestSettingDTOCheckConfig(TeaModel):
    def __init__(
        self,
        check_items: List[CreateProtectdBranchRequestTestSettingDTOCheckConfigCheckItems] = None,
    ):
        self.check_items = check_items

    def validate(self):
        if self.check_items:
            for k in self.check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['checkItems'] = []
        if self.check_items is not None:
            for k in self.check_items:
                result['checkItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_items = []
        if m.get('checkItems') is not None:
            for k in m.get('checkItems'):
                temp_model = CreateProtectdBranchRequestTestSettingDTOCheckConfigCheckItems()
                self.check_items.append(temp_model.from_map(k))
        return self


class CreateProtectdBranchRequestTestSettingDTOCheckTaskQualityConfig(TeaModel):
    def __init__(
        self,
        biz_no: str = None,
        enabled: bool = None,
        message: str = None,
        task_name: str = None,
    ):
        self.biz_no = biz_no
        self.enabled = enabled
        self.message = message
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_no is not None:
            result['bizNo'] = self.biz_no
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        if self.task_name is not None:
            result['taskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizNo') is not None:
            self.biz_no = m.get('bizNo')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('taskName') is not None:
            self.task_name = m.get('taskName')
        return self


class CreateProtectdBranchRequestTestSettingDTOCodeGuidelinesDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateProtectdBranchRequestTestSettingDTOSensitiveInfoDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateProtectdBranchRequestTestSettingDTO(TeaModel):
    def __init__(
        self,
        check_config: CreateProtectdBranchRequestTestSettingDTOCheckConfig = None,
        check_task_quality_config: CreateProtectdBranchRequestTestSettingDTOCheckTaskQualityConfig = None,
        code_guidelines_detection: CreateProtectdBranchRequestTestSettingDTOCodeGuidelinesDetection = None,
        is_required: bool = None,
        sensitive_info_detection: CreateProtectdBranchRequestTestSettingDTOSensitiveInfoDetection = None,
    ):
        self.check_config = check_config
        self.check_task_quality_config = check_task_quality_config
        self.code_guidelines_detection = code_guidelines_detection
        self.is_required = is_required
        self.sensitive_info_detection = sensitive_info_detection

    def validate(self):
        if self.check_config:
            self.check_config.validate()
        if self.check_task_quality_config:
            self.check_task_quality_config.validate()
        if self.code_guidelines_detection:
            self.code_guidelines_detection.validate()
        if self.sensitive_info_detection:
            self.sensitive_info_detection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_config is not None:
            result['checkConfig'] = self.check_config.to_map()
        if self.check_task_quality_config is not None:
            result['checkTaskQualityConfig'] = self.check_task_quality_config.to_map()
        if self.code_guidelines_detection is not None:
            result['codeGuidelinesDetection'] = self.code_guidelines_detection.to_map()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.sensitive_info_detection is not None:
            result['sensitiveInfoDetection'] = self.sensitive_info_detection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkConfig') is not None:
            temp_model = CreateProtectdBranchRequestTestSettingDTOCheckConfig()
            self.check_config = temp_model.from_map(m['checkConfig'])
        if m.get('checkTaskQualityConfig') is not None:
            temp_model = CreateProtectdBranchRequestTestSettingDTOCheckTaskQualityConfig()
            self.check_task_quality_config = temp_model.from_map(m['checkTaskQualityConfig'])
        if m.get('codeGuidelinesDetection') is not None:
            temp_model = CreateProtectdBranchRequestTestSettingDTOCodeGuidelinesDetection()
            self.code_guidelines_detection = temp_model.from_map(m['codeGuidelinesDetection'])
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('sensitiveInfoDetection') is not None:
            temp_model = CreateProtectdBranchRequestTestSettingDTOSensitiveInfoDetection()
            self.sensitive_info_detection = temp_model.from_map(m['sensitiveInfoDetection'])
        return self


class CreateProtectdBranchRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        allow_merge_roles: List[int] = None,
        allow_merge_user_ids: List[str] = None,
        allow_push_roles: List[int] = None,
        allow_push_user_ids: List[str] = None,
        branch: str = None,
        id: int = None,
        merge_request_setting: CreateProtectdBranchRequestMergeRequestSetting = None,
        test_setting_dto: CreateProtectdBranchRequestTestSettingDTO = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.allow_merge_roles = allow_merge_roles
        self.allow_merge_user_ids = allow_merge_user_ids
        self.allow_push_roles = allow_push_roles
        self.allow_push_user_ids = allow_push_user_ids
        self.branch = branch
        self.id = id
        self.merge_request_setting = merge_request_setting
        self.test_setting_dto = test_setting_dto
        self.organization_id = organization_id

    def validate(self):
        if self.merge_request_setting:
            self.merge_request_setting.validate()
        if self.test_setting_dto:
            self.test_setting_dto.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.allow_merge_roles is not None:
            result['allowMergeRoles'] = self.allow_merge_roles
        if self.allow_merge_user_ids is not None:
            result['allowMergeUserIds'] = self.allow_merge_user_ids
        if self.allow_push_roles is not None:
            result['allowPushRoles'] = self.allow_push_roles
        if self.allow_push_user_ids is not None:
            result['allowPushUserIds'] = self.allow_push_user_ids
        if self.branch is not None:
            result['branch'] = self.branch
        if self.id is not None:
            result['id'] = self.id
        if self.merge_request_setting is not None:
            result['mergeRequestSetting'] = self.merge_request_setting.to_map()
        if self.test_setting_dto is not None:
            result['testSettingDTO'] = self.test_setting_dto.to_map()
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('allowMergeRoles') is not None:
            self.allow_merge_roles = m.get('allowMergeRoles')
        if m.get('allowMergeUserIds') is not None:
            self.allow_merge_user_ids = m.get('allowMergeUserIds')
        if m.get('allowPushRoles') is not None:
            self.allow_push_roles = m.get('allowPushRoles')
        if m.get('allowPushUserIds') is not None:
            self.allow_push_user_ids = m.get('allowPushUserIds')
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('mergeRequestSetting') is not None:
            temp_model = CreateProtectdBranchRequestMergeRequestSetting()
            self.merge_request_setting = temp_model.from_map(m['mergeRequestSetting'])
        if m.get('testSettingDTO') is not None:
            temp_model = CreateProtectdBranchRequestTestSettingDTO()
            self.test_setting_dto = temp_model.from_map(m['testSettingDTO'])
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateProtectdBranchResponseBodyResultMergeRequestSetting(TeaModel):
    def __init__(
        self,
        allow_merge_request_roles: List[int] = None,
        default_assignees: List[str] = None,
        is_allow_self_approval: bool = None,
        is_require_discussion_processed: bool = None,
        is_required: bool = None,
        is_reset_approval_when_new_push: bool = None,
        minimum_approval: int = None,
        mr_mode: str = None,
        white_list: str = None,
    ):
        self.allow_merge_request_roles = allow_merge_request_roles
        self.default_assignees = default_assignees
        self.is_allow_self_approval = is_allow_self_approval
        self.is_require_discussion_processed = is_require_discussion_processed
        self.is_required = is_required
        self.is_reset_approval_when_new_push = is_reset_approval_when_new_push
        self.minimum_approval = minimum_approval
        self.mr_mode = mr_mode
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_merge_request_roles is not None:
            result['allowMergeRequestRoles'] = self.allow_merge_request_roles
        if self.default_assignees is not None:
            result['defaultAssignees'] = self.default_assignees
        if self.is_allow_self_approval is not None:
            result['isAllowSelfApproval'] = self.is_allow_self_approval
        if self.is_require_discussion_processed is not None:
            result['isRequireDiscussionProcessed'] = self.is_require_discussion_processed
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.is_reset_approval_when_new_push is not None:
            result['isResetApprovalWhenNewPush'] = self.is_reset_approval_when_new_push
        if self.minimum_approval is not None:
            result['minimumApproval'] = self.minimum_approval
        if self.mr_mode is not None:
            result['mrMode'] = self.mr_mode
        if self.white_list is not None:
            result['whiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowMergeRequestRoles') is not None:
            self.allow_merge_request_roles = m.get('allowMergeRequestRoles')
        if m.get('defaultAssignees') is not None:
            self.default_assignees = m.get('defaultAssignees')
        if m.get('isAllowSelfApproval') is not None:
            self.is_allow_self_approval = m.get('isAllowSelfApproval')
        if m.get('isRequireDiscussionProcessed') is not None:
            self.is_require_discussion_processed = m.get('isRequireDiscussionProcessed')
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('isResetApprovalWhenNewPush') is not None:
            self.is_reset_approval_when_new_push = m.get('isResetApprovalWhenNewPush')
        if m.get('minimumApproval') is not None:
            self.minimum_approval = m.get('minimumApproval')
        if m.get('mrMode') is not None:
            self.mr_mode = m.get('mrMode')
        if m.get('whiteList') is not None:
            self.white_list = m.get('whiteList')
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfigCheckItems(TeaModel):
    def __init__(
        self,
        is_required: bool = None,
        name: str = None,
    ):
        self.is_required = is_required
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfig(TeaModel):
    def __init__(
        self,
        check_items: List[CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfigCheckItems] = None,
    ):
        self.check_items = check_items

    def validate(self):
        if self.check_items:
            for k in self.check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['checkItems'] = []
        if self.check_items is not None:
            for k in self.check_items:
                result['checkItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_items = []
        if m.get('checkItems') is not None:
            for k in m.get('checkItems'):
                temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfigCheckItems()
                self.check_items.append(temp_model.from_map(k))
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTOCheckTaskQualityConfig(TeaModel):
    def __init__(
        self,
        biz_no: str = None,
        enabled: bool = None,
        message: str = None,
        task_name: str = None,
    ):
        self.biz_no = biz_no
        self.enabled = enabled
        self.message = message
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_no is not None:
            result['bizNo'] = self.biz_no
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        if self.task_name is not None:
            result['taskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizNo') is not None:
            self.biz_no = m.get('bizNo')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('taskName') is not None:
            self.task_name = m.get('taskName')
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTOCodeGuidelinesDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTOSensitiveInfoDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateProtectdBranchResponseBodyResultTestSettingDTO(TeaModel):
    def __init__(
        self,
        check_config: CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfig = None,
        check_task_quality_config: CreateProtectdBranchResponseBodyResultTestSettingDTOCheckTaskQualityConfig = None,
        code_guidelines_detection: CreateProtectdBranchResponseBodyResultTestSettingDTOCodeGuidelinesDetection = None,
        is_required: bool = None,
        sensitive_info_detection: CreateProtectdBranchResponseBodyResultTestSettingDTOSensitiveInfoDetection = None,
    ):
        self.check_config = check_config
        self.check_task_quality_config = check_task_quality_config
        self.code_guidelines_detection = code_guidelines_detection
        self.is_required = is_required
        self.sensitive_info_detection = sensitive_info_detection

    def validate(self):
        if self.check_config:
            self.check_config.validate()
        if self.check_task_quality_config:
            self.check_task_quality_config.validate()
        if self.code_guidelines_detection:
            self.code_guidelines_detection.validate()
        if self.sensitive_info_detection:
            self.sensitive_info_detection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_config is not None:
            result['checkConfig'] = self.check_config.to_map()
        if self.check_task_quality_config is not None:
            result['checkTaskQualityConfig'] = self.check_task_quality_config.to_map()
        if self.code_guidelines_detection is not None:
            result['codeGuidelinesDetection'] = self.code_guidelines_detection.to_map()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.sensitive_info_detection is not None:
            result['sensitiveInfoDetection'] = self.sensitive_info_detection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkConfig') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTOCheckConfig()
            self.check_config = temp_model.from_map(m['checkConfig'])
        if m.get('checkTaskQualityConfig') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTOCheckTaskQualityConfig()
            self.check_task_quality_config = temp_model.from_map(m['checkTaskQualityConfig'])
        if m.get('codeGuidelinesDetection') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTOCodeGuidelinesDetection()
            self.code_guidelines_detection = temp_model.from_map(m['codeGuidelinesDetection'])
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('sensitiveInfoDetection') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTOSensitiveInfoDetection()
            self.sensitive_info_detection = temp_model.from_map(m['sensitiveInfoDetection'])
        return self


class CreateProtectdBranchResponseBodyResult(TeaModel):
    def __init__(
        self,
        allow_merge_roles: List[int] = None,
        allow_merge_user_ids: List[int] = None,
        allow_push_roles: List[int] = None,
        allow_push_user_ids: List[int] = None,
        branch: str = None,
        id: int = None,
        merge_request_setting: CreateProtectdBranchResponseBodyResultMergeRequestSetting = None,
        test_setting_dto: CreateProtectdBranchResponseBodyResultTestSettingDTO = None,
    ):
        self.allow_merge_roles = allow_merge_roles
        self.allow_merge_user_ids = allow_merge_user_ids
        self.allow_push_roles = allow_push_roles
        self.allow_push_user_ids = allow_push_user_ids
        self.branch = branch
        self.id = id
        self.merge_request_setting = merge_request_setting
        self.test_setting_dto = test_setting_dto

    def validate(self):
        if self.merge_request_setting:
            self.merge_request_setting.validate()
        if self.test_setting_dto:
            self.test_setting_dto.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_merge_roles is not None:
            result['allowMergeRoles'] = self.allow_merge_roles
        if self.allow_merge_user_ids is not None:
            result['allowMergeUserIds'] = self.allow_merge_user_ids
        if self.allow_push_roles is not None:
            result['allowPushRoles'] = self.allow_push_roles
        if self.allow_push_user_ids is not None:
            result['allowPushUserIds'] = self.allow_push_user_ids
        if self.branch is not None:
            result['branch'] = self.branch
        if self.id is not None:
            result['id'] = self.id
        if self.merge_request_setting is not None:
            result['mergeRequestSetting'] = self.merge_request_setting.to_map()
        if self.test_setting_dto is not None:
            result['testSettingDTO'] = self.test_setting_dto.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowMergeRoles') is not None:
            self.allow_merge_roles = m.get('allowMergeRoles')
        if m.get('allowMergeUserIds') is not None:
            self.allow_merge_user_ids = m.get('allowMergeUserIds')
        if m.get('allowPushRoles') is not None:
            self.allow_push_roles = m.get('allowPushRoles')
        if m.get('allowPushUserIds') is not None:
            self.allow_push_user_ids = m.get('allowPushUserIds')
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('mergeRequestSetting') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultMergeRequestSetting()
            self.merge_request_setting = temp_model.from_map(m['mergeRequestSetting'])
        if m.get('testSettingDTO') is not None:
            temp_model = CreateProtectdBranchResponseBodyResultTestSettingDTO()
            self.test_setting_dto = temp_model.from_map(m['testSettingDTO'])
        return self


class CreateProtectdBranchResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateProtectdBranchResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateProtectdBranchResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateProtectdBranchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProtectdBranchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProtectdBranchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePushRuleRequestRuleInfos(TeaModel):
    def __init__(
        self,
        checker_name: str = None,
        checker_type: str = None,
        extra_message: str = None,
        file_rule_regexes: List[str] = None,
    ):
        self.checker_name = checker_name
        self.checker_type = checker_type
        self.extra_message = extra_message
        self.file_rule_regexes = file_rule_regexes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_name is not None:
            result['checkerName'] = self.checker_name
        if self.checker_type is not None:
            result['checkerType'] = self.checker_type
        if self.extra_message is not None:
            result['extraMessage'] = self.extra_message
        if self.file_rule_regexes is not None:
            result['fileRuleRegexes'] = self.file_rule_regexes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkerName') is not None:
            self.checker_name = m.get('checkerName')
        if m.get('checkerType') is not None:
            self.checker_type = m.get('checkerType')
        if m.get('extraMessage') is not None:
            self.extra_message = m.get('extraMessage')
        if m.get('fileRuleRegexes') is not None:
            self.file_rule_regexes = m.get('fileRuleRegexes')
        return self


class CreatePushRuleRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        rule_infos: List[CreatePushRuleRequestRuleInfos] = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.rule_infos = rule_infos
        self.organization_id = organization_id

    def validate(self):
        if self.rule_infos:
            for k in self.rule_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        result['ruleInfos'] = []
        if self.rule_infos is not None:
            for k in self.rule_infos:
                result['ruleInfos'].append(k.to_map() if k else None)
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        self.rule_infos = []
        if m.get('ruleInfos') is not None:
            for k in m.get('ruleInfos'):
                temp_model = CreatePushRuleRequestRuleInfos()
                self.rule_infos.append(temp_model.from_map(k))
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreatePushRuleResponseBodyResultRuleInfos(TeaModel):
    def __init__(
        self,
        checker_name: str = None,
        checker_type: str = None,
        extra_message: str = None,
        file_rule_regexes: List[str] = None,
    ):
        self.checker_name = checker_name
        self.checker_type = checker_type
        self.extra_message = extra_message
        self.file_rule_regexes = file_rule_regexes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_name is not None:
            result['checkerName'] = self.checker_name
        if self.checker_type is not None:
            result['checkerType'] = self.checker_type
        if self.extra_message is not None:
            result['extraMessage'] = self.extra_message
        if self.file_rule_regexes is not None:
            result['fileRuleRegexes'] = self.file_rule_regexes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkerName') is not None:
            self.checker_name = m.get('checkerName')
        if m.get('checkerType') is not None:
            self.checker_type = m.get('checkerType')
        if m.get('extraMessage') is not None:
            self.extra_message = m.get('extraMessage')
        if m.get('fileRuleRegexes') is not None:
            self.file_rule_regexes = m.get('fileRuleRegexes')
        return self


class CreatePushRuleResponseBodyResult(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        rule_infos: List[CreatePushRuleResponseBodyResultRuleInfos] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.rule_infos = rule_infos

    def validate(self):
        if self.rule_infos:
            for k in self.rule_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['ruleInfos'] = []
        if self.rule_infos is not None:
            for k in self.rule_infos:
                result['ruleInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.rule_infos = []
        if m.get('ruleInfos') is not None:
            for k in m.get('ruleInfos'):
                temp_model = CreatePushRuleResponseBodyResultRuleInfos()
                self.rule_infos.append(temp_model.from_map(k))
        return self


class CreatePushRuleResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreatePushRuleResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreatePushRuleResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreatePushRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePushRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePushRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRepositoryRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        avatar_url: str = None,
        description: str = None,
        gitignore_type: str = None,
        import_account: str = None,
        import_demo_project: bool = None,
        import_repo_type: str = None,
        import_token: str = None,
        import_token_encrypted: str = None,
        import_url: str = None,
        init_standard_service: bool = None,
        is_crypto_enabled: bool = None,
        local_import_url: str = None,
        name: str = None,
        namespace_id: int = None,
        path: str = None,
        readme_type: str = None,
        visibility_level: int = None,
        create_parent_path: bool = None,
        organization_id: str = None,
        sync: bool = None,
    ):
        self.access_token = access_token
        self.avatar_url = avatar_url
        self.description = description
        self.gitignore_type = gitignore_type
        self.import_account = import_account
        self.import_demo_project = import_demo_project
        self.import_repo_type = import_repo_type
        self.import_token = import_token
        self.import_token_encrypted = import_token_encrypted
        self.import_url = import_url
        self.init_standard_service = init_standard_service
        self.is_crypto_enabled = is_crypto_enabled
        self.local_import_url = local_import_url
        self.name = name
        self.namespace_id = namespace_id
        self.path = path
        self.readme_type = readme_type
        self.visibility_level = visibility_level
        self.create_parent_path = create_parent_path
        self.organization_id = organization_id
        self.sync = sync

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.description is not None:
            result['description'] = self.description
        if self.gitignore_type is not None:
            result['gitignoreType'] = self.gitignore_type
        if self.import_account is not None:
            result['importAccount'] = self.import_account
        if self.import_demo_project is not None:
            result['importDemoProject'] = self.import_demo_project
        if self.import_repo_type is not None:
            result['importRepoType'] = self.import_repo_type
        if self.import_token is not None:
            result['importToken'] = self.import_token
        if self.import_token_encrypted is not None:
            result['importTokenEncrypted'] = self.import_token_encrypted
        if self.import_url is not None:
            result['importUrl'] = self.import_url
        if self.init_standard_service is not None:
            result['initStandardService'] = self.init_standard_service
        if self.is_crypto_enabled is not None:
            result['isCryptoEnabled'] = self.is_crypto_enabled
        if self.local_import_url is not None:
            result['localImportUrl'] = self.local_import_url
        if self.name is not None:
            result['name'] = self.name
        if self.namespace_id is not None:
            result['namespaceId'] = self.namespace_id
        if self.path is not None:
            result['path'] = self.path
        if self.readme_type is not None:
            result['readmeType'] = self.readme_type
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.create_parent_path is not None:
            result['createParentPath'] = self.create_parent_path
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.sync is not None:
            result['sync'] = self.sync
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gitignoreType') is not None:
            self.gitignore_type = m.get('gitignoreType')
        if m.get('importAccount') is not None:
            self.import_account = m.get('importAccount')
        if m.get('importDemoProject') is not None:
            self.import_demo_project = m.get('importDemoProject')
        if m.get('importRepoType') is not None:
            self.import_repo_type = m.get('importRepoType')
        if m.get('importToken') is not None:
            self.import_token = m.get('importToken')
        if m.get('importTokenEncrypted') is not None:
            self.import_token_encrypted = m.get('importTokenEncrypted')
        if m.get('importUrl') is not None:
            self.import_url = m.get('importUrl')
        if m.get('initStandardService') is not None:
            self.init_standard_service = m.get('initStandardService')
        if m.get('isCryptoEnabled') is not None:
            self.is_crypto_enabled = m.get('isCryptoEnabled')
        if m.get('localImportUrl') is not None:
            self.local_import_url = m.get('localImportUrl')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespaceId') is not None:
            self.namespace_id = m.get('namespaceId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readmeType') is not None:
            self.readme_type = m.get('readmeType')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('createParentPath') is not None:
            self.create_parent_path = m.get('createParentPath')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('sync') is not None:
            self.sync = m.get('sync')
        return self


class CreateRepositoryResponseBodyResultNamespace(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        created_at: str = None,
        description: str = None,
        id: int = None,
        name: str = None,
        owner_id: int = None,
        path: str = None,
        public: bool = None,
        updated_at: str = None,
        visibility_level: str = None,
    ):
        self.avatar = avatar
        self.created_at = created_at
        self.description = description
        # id
        self.id = id
        self.name = name
        self.owner_id = owner_id
        self.path = path
        self.public = public
        self.updated_at = updated_at
        self.visibility_level = visibility_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.path is not None:
            result['path'] = self.path
        if self.public is not None:
            result['public'] = self.public
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('public') is not None:
            self.public = m.get('public')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        return self


class CreateRepositoryResponseBodyResult(TeaModel):
    def __init__(
        self,
        import_from_svn: bool = None,
        archived: bool = None,
        avatar_url: str = None,
        created_at: str = None,
        creator_id: int = None,
        default_branch: str = None,
        demo_project: bool = None,
        description: str = None,
        http_url_to_repo: str = None,
        id: int = None,
        last_activity_at: str = None,
        name: str = None,
        name_with_namespace: str = None,
        namespace: CreateRepositoryResponseBodyResultNamespace = None,
        path: str = None,
        path_with_namespace: str = None,
        ssh_url_to_repo: str = None,
        visibility_level: str = None,
        web_url: str = None,
    ):
        self.import_from_svn = import_from_svn
        self.archived = archived
        self.avatar_url = avatar_url
        self.created_at = created_at
        self.creator_id = creator_id
        self.default_branch = default_branch
        self.demo_project = demo_project
        self.description = description
        self.http_url_to_repo = http_url_to_repo
        # id
        self.id = id
        self.last_activity_at = last_activity_at
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.namespace = namespace
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.ssh_url_to_repo = ssh_url_to_repo
        self.visibility_level = visibility_level
        # web url
        self.web_url = web_url

    def validate(self):
        if self.namespace:
            self.namespace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_from_svn is not None:
            result['Import_from_svn'] = self.import_from_svn
        if self.archived is not None:
            result['archived'] = self.archived
        if self.avatar_url is not None:
            result['avatar_url'] = self.avatar_url
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.default_branch is not None:
            result['defaultBranch'] = self.default_branch
        if self.demo_project is not None:
            result['demoProject'] = self.demo_project
        if self.description is not None:
            result['description'] = self.description
        if self.http_url_to_repo is not None:
            result['httpUrlToRepo'] = self.http_url_to_repo
        if self.id is not None:
            result['id'] = self.id
        if self.last_activity_at is not None:
            result['lastActivityAt'] = self.last_activity_at
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.namespace is not None:
            result['namespace'] = self.namespace.to_map()
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.ssh_url_to_repo is not None:
            result['sshUrlToRepo'] = self.ssh_url_to_repo
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Import_from_svn') is not None:
            self.import_from_svn = m.get('Import_from_svn')
        if m.get('archived') is not None:
            self.archived = m.get('archived')
        if m.get('avatar_url') is not None:
            self.avatar_url = m.get('avatar_url')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('defaultBranch') is not None:
            self.default_branch = m.get('defaultBranch')
        if m.get('demoProject') is not None:
            self.demo_project = m.get('demoProject')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('httpUrlToRepo') is not None:
            self.http_url_to_repo = m.get('httpUrlToRepo')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('lastActivityAt') is not None:
            self.last_activity_at = m.get('lastActivityAt')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('namespace') is not None:
            temp_model = CreateRepositoryResponseBodyResultNamespace()
            self.namespace = temp_model.from_map(m['namespace'])
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('sshUrlToRepo') is not None:
            self.ssh_url_to_repo = m.get('sshUrlToRepo')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class CreateRepositoryResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateRepositoryResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateRepositoryResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateRepositoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRepositoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRepositoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRepositoryGroupRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        avatar_url: str = None,
        description: str = None,
        name: str = None,
        parent_id: int = None,
        path: str = None,
        visibility_level: int = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.avatar_url = avatar_url
        self.description = description
        self.name = name
        self.parent_id = parent_id
        self.path = path
        self.visibility_level = visibility_level
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.path is not None:
            result['path'] = self.path
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateRepositoryGroupResponseBodyResult(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        description: str = None,
        id: int = None,
        name: str = None,
        name_with_namespace: str = None,
        owner_id: int = None,
        parent_id: int = None,
        path: str = None,
        path_with_namespace: str = None,
        type: str = None,
        visibility_level: int = None,
        web_url: str = None,
    ):
        self.avatar_url = avatar_url
        self.description = description
        self.id = id
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.owner_id = owner_id
        self.parent_id = parent_id
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.type = type
        self.visibility_level = visibility_level
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.type is not None:
            result['type'] = self.type
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class CreateRepositoryGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateRepositoryGroupResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateRepositoryGroupResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateRepositoryGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRepositoryGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRepositoryGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourceMemberRequest(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        role_name: str = None,
    ):
        self.account_id = account_id
        self.role_name = role_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.role_name is not None:
            result['roleName'] = self.role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('roleName') is not None:
            self.role_name = m.get('roleName')
        return self


class CreateResourceMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateResourceMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateResourceMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateResourceMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceAuthRequest(TeaModel):
    def __init__(
        self,
        service_auth_type: str = None,
    ):
        self.service_auth_type = service_auth_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_auth_type is not None:
            result['serviceAuthType'] = self.service_auth_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceAuthType') is not None:
            self.service_auth_type = m.get('serviceAuthType')
        return self


class CreateServiceAuthResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        id: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.id = id
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateServiceAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceAuthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceConnectionRequest(TeaModel):
    def __init__(
        self,
        auth_type: str = None,
        connection_name: str = None,
        connection_type: str = None,
        scope: str = None,
        service_auth_id: int = None,
    ):
        self.auth_type = auth_type
        self.connection_name = connection_name
        self.connection_type = connection_type
        self.scope = scope
        self.service_auth_id = service_auth_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_type is not None:
            result['authType'] = self.auth_type
        if self.connection_name is not None:
            result['connectionName'] = self.connection_name
        if self.connection_type is not None:
            result['connectionType'] = self.connection_type
        if self.scope is not None:
            result['scope'] = self.scope
        if self.service_auth_id is not None:
            result['serviceAuthId'] = self.service_auth_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authType') is not None:
            self.auth_type = m.get('authType')
        if m.get('connectionName') is not None:
            self.connection_name = m.get('connectionName')
        if m.get('connectionType') is not None:
            self.connection_type = m.get('connectionType')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('serviceAuthId') is not None:
            self.service_auth_id = m.get('serviceAuthId')
        return self


class CreateServiceConnectionResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.id = id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateServiceConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceCredentialRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        password: str = None,
        scope: str = None,
        type: str = None,
        username: str = None,
    ):
        self.name = name
        self.password = password
        self.scope = scope
        self.type = type
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.password is not None:
            result['password'] = self.password
        if self.scope is not None:
            result['scope'] = self.scope
        if self.type is not None:
            result['type'] = self.type
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateServiceCredentialResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.id = id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateServiceCredentialResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceCredentialResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceCredentialResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSprintRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        name: str = None,
        space_identifier: str = None,
        staff_ids: List[str] = None,
        start_date: str = None,
    ):
        self.end_date = end_date
        self.name = name
        self.space_identifier = space_identifier
        self.staff_ids = staff_ids
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.name is not None:
            result['name'] = self.name
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.staff_ids is not None:
            result['staffIds'] = self.staff_ids
        if self.start_date is not None:
            result['startDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('staffIds') is not None:
            self.staff_ids = m.get('staffIds')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        return self


class CreateSprintResponseBodySprint(TeaModel):
    def __init__(
        self,
        creator: str = None,
        description: str = None,
        end_date: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        modifier: str = None,
        name: str = None,
        scope: str = None,
        space_identifier: str = None,
        start_date: int = None,
        status: str = None,
    ):
        self.creator = creator
        self.description = description
        self.end_date = end_date
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.modifier = modifier
        self.name = name
        self.scope = scope
        self.space_identifier = space_identifier
        self.start_date = start_date
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.scope is not None:
            result['scope'] = self.scope
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.start_date is not None:
            result['startDate'] = self.start_date
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreateSprintResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        sprint: CreateSprintResponseBodySprint = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.sprint = sprint
        self.success = success

    def validate(self):
        if self.sprint:
            self.sprint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.sprint is not None:
            result['sprint'] = self.sprint.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('sprint') is not None:
            temp_model = CreateSprintResponseBodySprint()
            self.sprint = temp_model.from_map(m['sprint'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateSprintResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSprintResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSprintResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSshKeyResponseBodySshKey(TeaModel):
    def __init__(
        self,
        id: int = None,
        public_key: str = None,
    ):
        self.id = id
        self.public_key = public_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.public_key is not None:
            result['publicKey'] = self.public_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('publicKey') is not None:
            self.public_key = m.get('publicKey')
        return self


class CreateSshKeyResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        ssh_key: CreateSshKeyResponseBodySshKey = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.ssh_key = ssh_key
        self.success = success

    def validate(self):
        if self.ssh_key:
            self.ssh_key.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.ssh_key is not None:
            result['sshKey'] = self.ssh_key.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('sshKey') is not None:
            temp_model = CreateSshKeyResponseBodySshKey()
            self.ssh_key = temp_model.from_map(m['sshKey'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateSshKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSshKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSshKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTagRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        message: str = None,
        ref: str = None,
        tag_name: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.message = message
        self.ref = ref
        self.tag_name = tag_name
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.message is not None:
            result['message'] = self.message
        if self.ref is not None:
            result['ref'] = self.ref
        if self.tag_name is not None:
            result['tagName'] = self.tag_name
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('ref') is not None:
            self.ref = m.get('ref')
        if m.get('tagName') is not None:
            self.tag_name = m.get('tagName')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateTagResponseBodyResultCommit(TeaModel):
    def __init__(
        self,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        committed_date: str = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        title: str = None,
    ):
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.committed_date = committed_date
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CreateTagResponseBodyResult(TeaModel):
    def __init__(
        self,
        commit: CreateTagResponseBodyResultCommit = None,
        id: str = None,
        message: str = None,
        name: str = None,
    ):
        self.commit = commit
        self.id = id
        self.message = message
        self.name = name

    def validate(self):
        if self.commit:
            self.commit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit is not None:
            result['commit'] = self.commit.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commit') is not None:
            temp_model = CreateTagResponseBodyResultCommit()
            self.commit = temp_model.from_map(m['commit'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateTagResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateTagResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateTagResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTestCaseRequestFieldValueList(TeaModel):
    def __init__(
        self,
        field_identifier: str = None,
        value: str = None,
    ):
        self.field_identifier = field_identifier
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CreateTestCaseRequestTestcaseStepContentInfoStepResultList(TeaModel):
    def __init__(
        self,
        expected: str = None,
        step: str = None,
    ):
        self.expected = expected
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expected is not None:
            result['expected'] = self.expected
        if self.step is not None:
            result['step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expected') is not None:
            self.expected = m.get('expected')
        if m.get('step') is not None:
            self.step = m.get('step')
        return self


class CreateTestCaseRequestTestcaseStepContentInfo(TeaModel):
    def __init__(
        self,
        precondition: str = None,
        step_result_list: List[CreateTestCaseRequestTestcaseStepContentInfoStepResultList] = None,
        step_type: str = None,
    ):
        self.precondition = precondition
        self.step_result_list = step_result_list
        self.step_type = step_type

    def validate(self):
        if self.step_result_list:
            for k in self.step_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.precondition is not None:
            result['precondition'] = self.precondition
        result['stepResultList'] = []
        if self.step_result_list is not None:
            for k in self.step_result_list:
                result['stepResultList'].append(k.to_map() if k else None)
        if self.step_type is not None:
            result['stepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('precondition') is not None:
            self.precondition = m.get('precondition')
        self.step_result_list = []
        if m.get('stepResultList') is not None:
            for k in m.get('stepResultList'):
                temp_model = CreateTestCaseRequestTestcaseStepContentInfoStepResultList()
                self.step_result_list.append(temp_model.from_map(k))
        if m.get('stepType') is not None:
            self.step_type = m.get('stepType')
        return self


class CreateTestCaseRequest(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        directory_identifier: str = None,
        field_value_list: List[CreateTestCaseRequestFieldValueList] = None,
        priority: str = None,
        space_identifier: str = None,
        subject: str = None,
        tags: List[str] = None,
        testcase_step_content_info: CreateTestCaseRequestTestcaseStepContentInfo = None,
    ):
        self.assigned_to = assigned_to
        self.directory_identifier = directory_identifier
        self.field_value_list = field_value_list
        self.priority = priority
        self.space_identifier = space_identifier
        self.subject = subject
        self.tags = tags
        self.testcase_step_content_info = testcase_step_content_info

    def validate(self):
        if self.field_value_list:
            for k in self.field_value_list:
                if k:
                    k.validate()
        if self.testcase_step_content_info:
            self.testcase_step_content_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.directory_identifier is not None:
            result['directoryIdentifier'] = self.directory_identifier
        result['fieldValueList'] = []
        if self.field_value_list is not None:
            for k in self.field_value_list:
                result['fieldValueList'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['priority'] = self.priority
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.tags is not None:
            result['tags'] = self.tags
        if self.testcase_step_content_info is not None:
            result['testcaseStepContentInfo'] = self.testcase_step_content_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('directoryIdentifier') is not None:
            self.directory_identifier = m.get('directoryIdentifier')
        self.field_value_list = []
        if m.get('fieldValueList') is not None:
            for k in m.get('fieldValueList'):
                temp_model = CreateTestCaseRequestFieldValueList()
                self.field_value_list.append(temp_model.from_map(k))
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('testcaseStepContentInfo') is not None:
            temp_model = CreateTestCaseRequestTestcaseStepContentInfo()
            self.testcase_step_content_info = temp_model.from_map(m['testcaseStepContentInfo'])
        return self


class CreateTestCaseResponseBodyTestcaseAssignedTo(TeaModel):
    def __init__(
        self,
        assign_identifier: str = None,
        name: str = None,
        tb_role_id: str = None,
    ):
        self.assign_identifier = assign_identifier
        self.name = name
        self.tb_role_id = tb_role_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assign_identifier is not None:
            result['assignIdentifier'] = self.assign_identifier
        if self.name is not None:
            result['name'] = self.name
        if self.tb_role_id is not None:
            result['tbRoleId'] = self.tb_role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignIdentifier') is not None:
            self.assign_identifier = m.get('assignIdentifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('tbRoleId') is not None:
            self.tb_role_id = m.get('tbRoleId')
        return self


class CreateTestCaseResponseBodyTestcaseCreator(TeaModel):
    def __init__(
        self,
        create_identifier: str = None,
        name: str = None,
    ):
        self.create_identifier = create_identifier
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_identifier is not None:
            result['createIdentifier'] = self.create_identifier
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createIdentifier') is not None:
            self.create_identifier = m.get('createIdentifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateTestCaseResponseBodyTestcaseDetailInfoExpectedResult(TeaModel):
    def __init__(
        self,
        expect_content: str = None,
        expect_content_type: str = None,
        expect_identifier: str = None,
    ):
        self.expect_content = expect_content
        self.expect_content_type = expect_content_type
        self.expect_identifier = expect_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expect_content is not None:
            result['expectContent'] = self.expect_content
        if self.expect_content_type is not None:
            result['expectContentType'] = self.expect_content_type
        if self.expect_identifier is not None:
            result['expectIdentifier'] = self.expect_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expectContent') is not None:
            self.expect_content = m.get('expectContent')
        if m.get('expectContentType') is not None:
            self.expect_content_type = m.get('expectContentType')
        if m.get('expectIdentifier') is not None:
            self.expect_identifier = m.get('expectIdentifier')
        return self


class CreateTestCaseResponseBodyTestcaseDetailInfoPrecondition(TeaModel):
    def __init__(
        self,
        pre_content: str = None,
        pre_content_type: str = None,
        pre_identifier: str = None,
    ):
        self.pre_content = pre_content
        self.pre_content_type = pre_content_type
        self.pre_identifier = pre_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_content is not None:
            result['preContent'] = self.pre_content
        if self.pre_content_type is not None:
            result['preContentType'] = self.pre_content_type
        if self.pre_identifier is not None:
            result['preIdentifier'] = self.pre_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preContent') is not None:
            self.pre_content = m.get('preContent')
        if m.get('preContentType') is not None:
            self.pre_content_type = m.get('preContentType')
        if m.get('preIdentifier') is not None:
            self.pre_identifier = m.get('preIdentifier')
        return self


class CreateTestCaseResponseBodyTestcaseDetailInfoStepContent(TeaModel):
    def __init__(
        self,
        step_content: str = None,
        step_content_type: str = None,
        step_identifier: str = None,
    ):
        self.step_content = step_content
        self.step_content_type = step_content_type
        self.step_identifier = step_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.step_content is not None:
            result['stepContent'] = self.step_content
        if self.step_content_type is not None:
            result['stepContentType'] = self.step_content_type
        if self.step_identifier is not None:
            result['stepIdentifier'] = self.step_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('stepContent') is not None:
            self.step_content = m.get('stepContent')
        if m.get('stepContentType') is not None:
            self.step_content_type = m.get('stepContentType')
        if m.get('stepIdentifier') is not None:
            self.step_identifier = m.get('stepIdentifier')
        return self


class CreateTestCaseResponseBodyTestcaseDetailInfo(TeaModel):
    def __init__(
        self,
        expected_result: CreateTestCaseResponseBodyTestcaseDetailInfoExpectedResult = None,
        precondition: CreateTestCaseResponseBodyTestcaseDetailInfoPrecondition = None,
        step_content: CreateTestCaseResponseBodyTestcaseDetailInfoStepContent = None,
        step_type: str = None,
    ):
        self.expected_result = expected_result
        self.precondition = precondition
        self.step_content = step_content
        self.step_type = step_type

    def validate(self):
        if self.expected_result:
            self.expected_result.validate()
        if self.precondition:
            self.precondition.validate()
        if self.step_content:
            self.step_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expected_result is not None:
            result['expectedResult'] = self.expected_result.to_map()
        if self.precondition is not None:
            result['precondition'] = self.precondition.to_map()
        if self.step_content is not None:
            result['stepContent'] = self.step_content.to_map()
        if self.step_type is not None:
            result['stepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expectedResult') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseDetailInfoExpectedResult()
            self.expected_result = temp_model.from_map(m['expectedResult'])
        if m.get('precondition') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseDetailInfoPrecondition()
            self.precondition = temp_model.from_map(m['precondition'])
        if m.get('stepContent') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseDetailInfoStepContent()
            self.step_content = temp_model.from_map(m['stepContent'])
        if m.get('stepType') is not None:
            self.step_type = m.get('stepType')
        return self


class CreateTestCaseResponseBodyTestcaseDirectory(TeaModel):
    def __init__(
        self,
        child_identifier: str = None,
        directory_identifier: str = None,
        name: str = None,
        path_name: List[str] = None,
    ):
        self.child_identifier = child_identifier
        self.directory_identifier = directory_identifier
        self.name = name
        self.path_name = path_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_identifier is not None:
            result['childIdentifier'] = self.child_identifier
        if self.directory_identifier is not None:
            result['directoryIdentifier'] = self.directory_identifier
        if self.name is not None:
            result['name'] = self.name
        if self.path_name is not None:
            result['pathName'] = self.path_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('childIdentifier') is not None:
            self.child_identifier = m.get('childIdentifier')
        if m.get('directoryIdentifier') is not None:
            self.directory_identifier = m.get('directoryIdentifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pathName') is not None:
            self.path_name = m.get('pathName')
        return self


class CreateTestCaseResponseBodyTestcaseModifier(TeaModel):
    def __init__(
        self,
        modify_identifier: str = None,
        name: str = None,
    ):
        self.modify_identifier = modify_identifier
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modify_identifier is not None:
            result['modifyIdentifier'] = self.modify_identifier
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('modifyIdentifier') is not None:
            self.modify_identifier = m.get('modifyIdentifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateTestCaseResponseBodyTestcase(TeaModel):
    def __init__(
        self,
        assigned_to: CreateTestCaseResponseBodyTestcaseAssignedTo = None,
        category_identifier: str = None,
        creator: CreateTestCaseResponseBodyTestcaseCreator = None,
        detail_info: CreateTestCaseResponseBodyTestcaseDetailInfo = None,
        directory: CreateTestCaseResponseBodyTestcaseDirectory = None,
        identifier: str = None,
        modifier: CreateTestCaseResponseBodyTestcaseModifier = None,
        space_identifier: str = None,
        space_type: str = None,
        subject: str = None,
    ):
        self.assigned_to = assigned_to
        self.category_identifier = category_identifier
        self.creator = creator
        self.detail_info = detail_info
        self.directory = directory
        self.identifier = identifier
        self.modifier = modifier
        self.space_identifier = space_identifier
        self.space_type = space_type
        self.subject = subject

    def validate(self):
        if self.assigned_to:
            self.assigned_to.validate()
        if self.creator:
            self.creator.validate()
        if self.detail_info:
            self.detail_info.validate()
        if self.directory:
            self.directory.validate()
        if self.modifier:
            self.modifier.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to.to_map()
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator.to_map()
        if self.detail_info is not None:
            result['detailInfo'] = self.detail_info.to_map()
        if self.directory is not None:
            result['directory'] = self.directory.to_map()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier.to_map()
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.subject is not None:
            result['subject'] = self.subject
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseAssignedTo()
            self.assigned_to = temp_model.from_map(m['assignedTo'])
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseCreator()
            self.creator = temp_model.from_map(m['creator'])
        if m.get('detailInfo') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseDetailInfo()
            self.detail_info = temp_model.from_map(m['detailInfo'])
        if m.get('directory') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseDirectory()
            self.directory = temp_model.from_map(m['directory'])
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            temp_model = CreateTestCaseResponseBodyTestcaseModifier()
            self.modifier = temp_model.from_map(m['modifier'])
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        return self


class CreateTestCaseResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
        testcase: CreateTestCaseResponseBodyTestcase = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success
        self.testcase = testcase

    def validate(self):
        if self.testcase:
            self.testcase.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.testcase is not None:
            result['testcase'] = self.testcase.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('testcase') is not None:
            temp_model = CreateTestCaseResponseBodyTestcase()
            self.testcase = temp_model.from_map(m['testcase'])
        return self


class CreateTestCaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTestCaseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTestCaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserKeyRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        expire_time: str = None,
        key_scope: str = None,
        public_key: str = None,
        title: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.expire_time = expire_time
        self.key_scope = key_scope
        self.public_key = public_key
        self.title = title
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.key_scope is not None:
            result['keyScope'] = self.key_scope
        if self.public_key is not None:
            result['publicKey'] = self.public_key
        if self.title is not None:
            result['title'] = self.title
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('keyScope') is not None:
            self.key_scope = m.get('keyScope')
        if m.get('publicKey') is not None:
            self.public_key = m.get('publicKey')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class CreateUserKeyResponseBodyResult(TeaModel):
    def __init__(
        self,
        created_at: str = None,
        expire_time: str = None,
        finger_print: str = None,
        id: int = None,
        key_scope: str = None,
        last_used_time: str = None,
        public_key: str = None,
        title: str = None,
    ):
        self.created_at = created_at
        self.expire_time = expire_time
        self.finger_print = finger_print
        self.id = id
        self.key_scope = key_scope
        self.last_used_time = last_used_time
        self.public_key = public_key
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.finger_print is not None:
            result['fingerPrint'] = self.finger_print
        if self.id is not None:
            result['id'] = self.id
        if self.key_scope is not None:
            result['keyScope'] = self.key_scope
        if self.last_used_time is not None:
            result['lastUsedTime'] = self.last_used_time
        if self.public_key is not None:
            result['publicKey'] = self.public_key
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('fingerPrint') is not None:
            self.finger_print = m.get('fingerPrint')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('keyScope') is not None:
            self.key_scope = m.get('keyScope')
        if m.get('lastUsedTime') is not None:
            self.last_used_time = m.get('lastUsedTime')
        if m.get('publicKey') is not None:
            self.public_key = m.get('publicKey')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CreateUserKeyResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: CreateUserKeyResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = CreateUserKeyResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateUserKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUserKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVariableGroupRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        variables: str = None,
    ):
        self.description = description
        self.name = name
        self.variables = variables

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.variables is not None:
            result['variables'] = self.variables
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('variables') is not None:
            self.variables = m.get('variables')
        return self


class CreateVariableGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        variable_group_id: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.variable_group_id = variable_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.variable_group_id is not None:
            result['variableGroupId'] = self.variable_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('variableGroupId') is not None:
            self.variable_group_id = m.get('variableGroupId')
        return self


class CreateVariableGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVariableGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVariableGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkitemRequestFieldValueList(TeaModel):
    def __init__(
        self,
        field_identifier: str = None,
        value: str = None,
        workitem_identifier: str = None,
    ):
        self.field_identifier = field_identifier
        self.value = value
        self.workitem_identifier = workitem_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.value is not None:
            result['value'] = self.value
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemRequest(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        category: str = None,
        description: str = None,
        description_format: str = None,
        field_value_list: List[CreateWorkitemRequestFieldValueList] = None,
        parent: str = None,
        participant: List[str] = None,
        space: str = None,
        space_identifier: str = None,
        space_type: str = None,
        sprint: List[str] = None,
        subject: str = None,
        tracker: List[str] = None,
        verifier: List[str] = None,
        workitem_type: str = None,
    ):
        self.assigned_to = assigned_to
        self.category = category
        self.description = description
        self.description_format = description_format
        self.field_value_list = field_value_list
        self.parent = parent
        self.participant = participant
        self.space = space
        self.space_identifier = space_identifier
        self.space_type = space_type
        self.sprint = sprint
        self.subject = subject
        self.tracker = tracker
        self.verifier = verifier
        self.workitem_type = workitem_type

    def validate(self):
        if self.field_value_list:
            for k in self.field_value_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.category is not None:
            result['category'] = self.category
        if self.description is not None:
            result['description'] = self.description
        if self.description_format is not None:
            result['descriptionFormat'] = self.description_format
        result['fieldValueList'] = []
        if self.field_value_list is not None:
            for k in self.field_value_list:
                result['fieldValueList'].append(k.to_map() if k else None)
        if self.parent is not None:
            result['parent'] = self.parent
        if self.participant is not None:
            result['participant'] = self.participant
        if self.space is not None:
            result['space'] = self.space
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.sprint is not None:
            result['sprint'] = self.sprint
        if self.subject is not None:
            result['subject'] = self.subject
        if self.tracker is not None:
            result['tracker'] = self.tracker
        if self.verifier is not None:
            result['verifier'] = self.verifier
        if self.workitem_type is not None:
            result['workitemType'] = self.workitem_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('descriptionFormat') is not None:
            self.description_format = m.get('descriptionFormat')
        self.field_value_list = []
        if m.get('fieldValueList') is not None:
            for k in m.get('fieldValueList'):
                temp_model = CreateWorkitemRequestFieldValueList()
                self.field_value_list.append(temp_model.from_map(k))
        if m.get('parent') is not None:
            self.parent = m.get('parent')
        if m.get('participant') is not None:
            self.participant = m.get('participant')
        if m.get('space') is not None:
            self.space = m.get('space')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('sprint') is not None:
            self.sprint = m.get('sprint')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('tracker') is not None:
            self.tracker = m.get('tracker')
        if m.get('verifier') is not None:
            self.verifier = m.get('verifier')
        if m.get('workitemType') is not None:
            self.workitem_type = m.get('workitemType')
        return self


class CreateWorkitemResponseBodyWorkitem(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        category_identifier: str = None,
        creator: str = None,
        document: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        logical_status: str = None,
        modifier: str = None,
        parent_identifier: str = None,
        serial_number: str = None,
        space_identifier: str = None,
        space_name: str = None,
        space_type: str = None,
        sprint_identifier: str = None,
        status: str = None,
        status_identifier: str = None,
        status_stage_identifier: str = None,
        subject: str = None,
        update_status_at: int = None,
        workitem_type_identifier: str = None,
    ):
        self.assigned_to = assigned_to
        self.category_identifier = category_identifier
        self.creator = creator
        self.document = document
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.logical_status = logical_status
        self.modifier = modifier
        self.parent_identifier = parent_identifier
        self.serial_number = serial_number
        self.space_identifier = space_identifier
        self.space_name = space_name
        self.space_type = space_type
        self.sprint_identifier = sprint_identifier
        self.status = status
        self.status_identifier = status_identifier
        self.status_stage_identifier = status_stage_identifier
        self.subject = subject
        self.update_status_at = update_status_at
        self.workitem_type_identifier = workitem_type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        if self.document is not None:
            result['document'] = self.document
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.logical_status is not None:
            result['logicalStatus'] = self.logical_status
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.parent_identifier is not None:
            result['parentIdentifier'] = self.parent_identifier
        if self.serial_number is not None:
            result['serialNumber'] = self.serial_number
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.sprint_identifier is not None:
            result['sprintIdentifier'] = self.sprint_identifier
        if self.status is not None:
            result['status'] = self.status
        if self.status_identifier is not None:
            result['statusIdentifier'] = self.status_identifier
        if self.status_stage_identifier is not None:
            result['statusStageIdentifier'] = self.status_stage_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.update_status_at is not None:
            result['updateStatusAt'] = self.update_status_at
        if self.workitem_type_identifier is not None:
            result['workitemTypeIdentifier'] = self.workitem_type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('document') is not None:
            self.document = m.get('document')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('logicalStatus') is not None:
            self.logical_status = m.get('logicalStatus')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('parentIdentifier') is not None:
            self.parent_identifier = m.get('parentIdentifier')
        if m.get('serialNumber') is not None:
            self.serial_number = m.get('serialNumber')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('sprintIdentifier') is not None:
            self.sprint_identifier = m.get('sprintIdentifier')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('statusIdentifier') is not None:
            self.status_identifier = m.get('statusIdentifier')
        if m.get('statusStageIdentifier') is not None:
            self.status_stage_identifier = m.get('statusStageIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('updateStatusAt') is not None:
            self.update_status_at = m.get('updateStatusAt')
        if m.get('workitemTypeIdentifier') is not None:
            self.workitem_type_identifier = m.get('workitemTypeIdentifier')
        return self


class CreateWorkitemResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
        workitem: CreateWorkitemResponseBodyWorkitem = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.success = success
        self.workitem = workitem

    def validate(self):
        if self.workitem:
            self.workitem.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workitem is not None:
            result['workitem'] = self.workitem.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workitem') is not None:
            temp_model = CreateWorkitemResponseBodyWorkitem()
            self.workitem = temp_model.from_map(m['workitem'])
        return self


class CreateWorkitemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkitemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkitemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkitemCommentRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        format_type: str = None,
        parent_id: str = None,
        workitem_identifier: str = None,
    ):
        self.content = content
        self.format_type = format_type
        self.parent_id = parent_id
        self.workitem_identifier = workitem_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.format_type is not None:
            result['formatType'] = self.format_type
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('formatType') is not None:
            self.format_type = m.get('formatType')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemCommentResponseBodyCommentUser(TeaModel):
    def __init__(
        self,
        account: str = None,
        avatar: str = None,
        display_name: str = None,
        identifier: str = None,
        nick_name: str = None,
        real_name: str = None,
        target_type: str = None,
    ):
        self.account = account
        self.avatar = avatar
        self.display_name = display_name
        self.identifier = identifier
        self.nick_name = nick_name
        self.real_name = real_name
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['account'] = self.account
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.nick_name is not None:
            result['nickName'] = self.nick_name
        if self.real_name is not None:
            result['realName'] = self.real_name
        if self.target_type is not None:
            result['targetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('nickName') is not None:
            self.nick_name = m.get('nickName')
        if m.get('realName') is not None:
            self.real_name = m.get('realName')
        if m.get('targetType') is not None:
            self.target_type = m.get('targetType')
        return self


class CreateWorkitemCommentResponseBodyComment(TeaModel):
    def __init__(
        self,
        id: int = None,
        content: str = None,
        create_time: int = None,
        format_type: str = None,
        is_top: bool = None,
        modified_time: int = None,
        parent_id: int = None,
        target_identifier: str = None,
        target_type: str = None,
        top_time: int = None,
        user: CreateWorkitemCommentResponseBodyCommentUser = None,
    ):
        self.id = id
        self.content = content
        self.create_time = create_time
        self.format_type = format_type
        self.is_top = is_top
        self.modified_time = modified_time
        self.parent_id = parent_id
        self.target_identifier = target_identifier
        self.target_type = target_type
        self.top_time = top_time
        self.user = user

    def validate(self):
        if self.user:
            self.user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.content is not None:
            result['content'] = self.content
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.format_type is not None:
            result['formatType'] = self.format_type
        if self.is_top is not None:
            result['isTop'] = self.is_top
        if self.modified_time is not None:
            result['modifiedTime'] = self.modified_time
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.target_identifier is not None:
            result['targetIdentifier'] = self.target_identifier
        if self.target_type is not None:
            result['targetType'] = self.target_type
        if self.top_time is not None:
            result['topTime'] = self.top_time
        if self.user is not None:
            result['user'] = self.user.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('formatType') is not None:
            self.format_type = m.get('formatType')
        if m.get('isTop') is not None:
            self.is_top = m.get('isTop')
        if m.get('modifiedTime') is not None:
            self.modified_time = m.get('modifiedTime')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('targetIdentifier') is not None:
            self.target_identifier = m.get('targetIdentifier')
        if m.get('targetType') is not None:
            self.target_type = m.get('targetType')
        if m.get('topTime') is not None:
            self.top_time = m.get('topTime')
        if m.get('user') is not None:
            temp_model = CreateWorkitemCommentResponseBodyCommentUser()
            self.user = temp_model.from_map(m['user'])
        return self


class CreateWorkitemCommentResponseBody(TeaModel):
    def __init__(
        self,
        comment: CreateWorkitemCommentResponseBodyComment = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.comment = comment
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.comment:
            self.comment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment.to_map()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            temp_model = CreateWorkitemCommentResponseBodyComment()
            self.comment = temp_model.from_map(m['Comment'])
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateWorkitemCommentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkitemCommentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkitemCommentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkitemEstimateRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        record_user_identifier: str = None,
        spent_time: str = None,
        type: str = None,
        workitem_identifier: str = None,
    ):
        self.description = description
        self.record_user_identifier = record_user_identifier
        self.spent_time = spent_time
        self.type = type
        self.workitem_identifier = workitem_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.record_user_identifier is not None:
            result['recordUserIdentifier'] = self.record_user_identifier
        if self.spent_time is not None:
            result['spentTime'] = self.spent_time
        if self.type is not None:
            result['type'] = self.type
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('recordUserIdentifier') is not None:
            self.record_user_identifier = m.get('recordUserIdentifier')
        if m.get('spentTime') is not None:
            self.spent_time = m.get('spentTime')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemEstimateResponseBodyWorkitemTimeEstimateRecordUser(TeaModel):
    def __init__(
        self,
        account: str = None,
        avatar: str = None,
        ding_talk_id: str = None,
        display_name: str = None,
        display_nick_name: str = None,
        display_real_name: str = None,
        email: str = None,
        gender: str = None,
        identifier: str = None,
        is_disabled: bool = None,
        mobile: str = None,
        name_en: str = None,
        nick_name: str = None,
        nick_name_pinyin: str = None,
        real_name: str = None,
        real_name_pinyin: str = None,
        stamp: str = None,
        tb_role_id: str = None,
    ):
        self.account = account
        self.avatar = avatar
        self.ding_talk_id = ding_talk_id
        self.display_name = display_name
        self.display_nick_name = display_nick_name
        self.display_real_name = display_real_name
        self.email = email
        self.gender = gender
        self.identifier = identifier
        self.is_disabled = is_disabled
        self.mobile = mobile
        self.name_en = name_en
        self.nick_name = nick_name
        self.nick_name_pinyin = nick_name_pinyin
        self.real_name = real_name
        self.real_name_pinyin = real_name_pinyin
        self.stamp = stamp
        self.tb_role_id = tb_role_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['account'] = self.account
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.ding_talk_id is not None:
            result['dingTalkId'] = self.ding_talk_id
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.display_nick_name is not None:
            result['displayNickName'] = self.display_nick_name
        if self.display_real_name is not None:
            result['displayRealName'] = self.display_real_name
        if self.email is not None:
            result['email'] = self.email
        if self.gender is not None:
            result['gender'] = self.gender
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.is_disabled is not None:
            result['isDisabled'] = self.is_disabled
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name_en is not None:
            result['nameEn'] = self.name_en
        if self.nick_name is not None:
            result['nickName'] = self.nick_name
        if self.nick_name_pinyin is not None:
            result['nickNamePinyin'] = self.nick_name_pinyin
        if self.real_name is not None:
            result['realName'] = self.real_name
        if self.real_name_pinyin is not None:
            result['realNamePinyin'] = self.real_name_pinyin
        if self.stamp is not None:
            result['stamp'] = self.stamp
        if self.tb_role_id is not None:
            result['tbRoleId'] = self.tb_role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('dingTalkId') is not None:
            self.ding_talk_id = m.get('dingTalkId')
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('displayNickName') is not None:
            self.display_nick_name = m.get('displayNickName')
        if m.get('displayRealName') is not None:
            self.display_real_name = m.get('displayRealName')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('isDisabled') is not None:
            self.is_disabled = m.get('isDisabled')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('nameEn') is not None:
            self.name_en = m.get('nameEn')
        if m.get('nickName') is not None:
            self.nick_name = m.get('nickName')
        if m.get('nickNamePinyin') is not None:
            self.nick_name_pinyin = m.get('nickNamePinyin')
        if m.get('realName') is not None:
            self.real_name = m.get('realName')
        if m.get('realNamePinyin') is not None:
            self.real_name_pinyin = m.get('realNamePinyin')
        if m.get('stamp') is not None:
            self.stamp = m.get('stamp')
        if m.get('tbRoleId') is not None:
            self.tb_role_id = m.get('tbRoleId')
        return self


class CreateWorkitemEstimateResponseBodyWorkitemTimeEstimate(TeaModel):
    def __init__(
        self,
        description: str = None,
        identifier: str = None,
        record_user: CreateWorkitemEstimateResponseBodyWorkitemTimeEstimateRecordUser = None,
        spent_time: int = None,
        type: str = None,
        workitem_identifier: str = None,
    ):
        self.description = description
        self.identifier = identifier
        self.record_user = record_user
        self.spent_time = spent_time
        self.type = type
        self.workitem_identifier = workitem_identifier

    def validate(self):
        if self.record_user:
            self.record_user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.record_user is not None:
            result['recordUser'] = self.record_user.to_map()
        if self.spent_time is not None:
            result['spentTime'] = self.spent_time
        if self.type is not None:
            result['type'] = self.type
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('recordUser') is not None:
            temp_model = CreateWorkitemEstimateResponseBodyWorkitemTimeEstimateRecordUser()
            self.record_user = temp_model.from_map(m['recordUser'])
        if m.get('spentTime') is not None:
            self.spent_time = m.get('spentTime')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemEstimateResponseBody(TeaModel):
    def __init__(
        self,
        workitem_time_estimate: CreateWorkitemEstimateResponseBodyWorkitemTimeEstimate = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.workitem_time_estimate = workitem_time_estimate
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.workitem_time_estimate:
            self.workitem_time_estimate.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workitem_time_estimate is not None:
            result['WorkitemTimeEstimate'] = self.workitem_time_estimate.to_map()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkitemTimeEstimate') is not None:
            temp_model = CreateWorkitemEstimateResponseBodyWorkitemTimeEstimate()
            self.workitem_time_estimate = temp_model.from_map(m['WorkitemTimeEstimate'])
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateWorkitemEstimateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkitemEstimateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkitemEstimateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkitemRecordRequest(TeaModel):
    def __init__(
        self,
        actual_time: str = None,
        description: str = None,
        gmt_end: str = None,
        gmt_start: str = None,
        record_user_identifier: str = None,
        type: str = None,
        workitem_identifier: str = None,
    ):
        self.actual_time = actual_time
        self.description = description
        self.gmt_end = gmt_end
        self.gmt_start = gmt_start
        self.record_user_identifier = record_user_identifier
        self.type = type
        self.workitem_identifier = workitem_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_time is not None:
            result['actualTime'] = self.actual_time
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_end is not None:
            result['gmtEnd'] = self.gmt_end
        if self.gmt_start is not None:
            result['gmtStart'] = self.gmt_start
        if self.record_user_identifier is not None:
            result['recordUserIdentifier'] = self.record_user_identifier
        if self.type is not None:
            result['type'] = self.type
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualTime') is not None:
            self.actual_time = m.get('actualTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtEnd') is not None:
            self.gmt_end = m.get('gmtEnd')
        if m.get('gmtStart') is not None:
            self.gmt_start = m.get('gmtStart')
        if m.get('recordUserIdentifier') is not None:
            self.record_user_identifier = m.get('recordUserIdentifier')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemRecordResponseBodyWorkitemTimeRecordUser(TeaModel):
    def __init__(
        self,
        account: str = None,
        avatar: str = None,
        ding_talk_id: str = None,
        display_name: str = None,
        display_nick_name: str = None,
        display_real_name: str = None,
        email: str = None,
        gender: str = None,
        identifier: str = None,
        is_disabled: bool = None,
        mobile: str = None,
        name_en: str = None,
        nick_name: str = None,
        nick_name_pinyin: str = None,
        real_name: str = None,
        real_name_pinyin: str = None,
        stamp: str = None,
        tb_role_id: str = None,
    ):
        self.account = account
        self.avatar = avatar
        self.ding_talk_id = ding_talk_id
        self.display_name = display_name
        self.display_nick_name = display_nick_name
        self.display_real_name = display_real_name
        self.email = email
        self.gender = gender
        self.identifier = identifier
        self.is_disabled = is_disabled
        self.mobile = mobile
        self.name_en = name_en
        self.nick_name = nick_name
        self.nick_name_pinyin = nick_name_pinyin
        self.real_name = real_name
        self.real_name_pinyin = real_name_pinyin
        self.stamp = stamp
        self.tb_role_id = tb_role_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['account'] = self.account
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.ding_talk_id is not None:
            result['dingTalkId'] = self.ding_talk_id
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.display_nick_name is not None:
            result['displayNickName'] = self.display_nick_name
        if self.display_real_name is not None:
            result['displayRealName'] = self.display_real_name
        if self.email is not None:
            result['email'] = self.email
        if self.gender is not None:
            result['gender'] = self.gender
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.is_disabled is not None:
            result['isDisabled'] = self.is_disabled
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name_en is not None:
            result['nameEn'] = self.name_en
        if self.nick_name is not None:
            result['nickName'] = self.nick_name
        if self.nick_name_pinyin is not None:
            result['nickNamePinyin'] = self.nick_name_pinyin
        if self.real_name is not None:
            result['realName'] = self.real_name
        if self.real_name_pinyin is not None:
            result['realNamePinyin'] = self.real_name_pinyin
        if self.stamp is not None:
            result['stamp'] = self.stamp
        if self.tb_role_id is not None:
            result['tbRoleId'] = self.tb_role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('dingTalkId') is not None:
            self.ding_talk_id = m.get('dingTalkId')
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('displayNickName') is not None:
            self.display_nick_name = m.get('displayNickName')
        if m.get('displayRealName') is not None:
            self.display_real_name = m.get('displayRealName')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('isDisabled') is not None:
            self.is_disabled = m.get('isDisabled')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('nameEn') is not None:
            self.name_en = m.get('nameEn')
        if m.get('nickName') is not None:
            self.nick_name = m.get('nickName')
        if m.get('nickNamePinyin') is not None:
            self.nick_name_pinyin = m.get('nickNamePinyin')
        if m.get('realName') is not None:
            self.real_name = m.get('realName')
        if m.get('realNamePinyin') is not None:
            self.real_name_pinyin = m.get('realNamePinyin')
        if m.get('stamp') is not None:
            self.stamp = m.get('stamp')
        if m.get('tbRoleId') is not None:
            self.tb_role_id = m.get('tbRoleId')
        return self


class CreateWorkitemRecordResponseBodyWorkitemTime(TeaModel):
    def __init__(
        self,
        actual_time: int = None,
        description: str = None,
        gmt_end: int = None,
        gmt_start: int = None,
        identifier: str = None,
        record_user: CreateWorkitemRecordResponseBodyWorkitemTimeRecordUser = None,
        type: str = None,
        workitem_identifier: str = None,
    ):
        self.actual_time = actual_time
        self.description = description
        self.gmt_end = gmt_end
        self.gmt_start = gmt_start
        self.identifier = identifier
        self.record_user = record_user
        self.type = type
        self.workitem_identifier = workitem_identifier

    def validate(self):
        if self.record_user:
            self.record_user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_time is not None:
            result['actualTime'] = self.actual_time
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_end is not None:
            result['gmtEnd'] = self.gmt_end
        if self.gmt_start is not None:
            result['gmtStart'] = self.gmt_start
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.record_user is not None:
            result['recordUser'] = self.record_user.to_map()
        if self.type is not None:
            result['type'] = self.type
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualTime') is not None:
            self.actual_time = m.get('actualTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtEnd') is not None:
            self.gmt_end = m.get('gmtEnd')
        if m.get('gmtStart') is not None:
            self.gmt_start = m.get('gmtStart')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('recordUser') is not None:
            temp_model = CreateWorkitemRecordResponseBodyWorkitemTimeRecordUser()
            self.record_user = temp_model.from_map(m['recordUser'])
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemRecordResponseBody(TeaModel):
    def __init__(
        self,
        workitem_time: CreateWorkitemRecordResponseBodyWorkitemTime = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.workitem_time = workitem_time
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.workitem_time:
            self.workitem_time.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workitem_time is not None:
            result['WorkitemTime'] = self.workitem_time.to_map()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkitemTime') is not None:
            temp_model = CreateWorkitemRecordResponseBodyWorkitemTime()
            self.workitem_time = temp_model.from_map(m['WorkitemTime'])
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateWorkitemRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkitemRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkitemRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkitemV2RequestFieldValueList(TeaModel):
    def __init__(
        self,
        field_identifier: str = None,
        value: str = None,
    ):
        self.field_identifier = field_identifier
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CreateWorkitemV2Request(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        category: str = None,
        description: str = None,
        field_value_list: List[CreateWorkitemV2RequestFieldValueList] = None,
        parent_identifier: str = None,
        participants: List[str] = None,
        space_identifier: str = None,
        sprint_identifier: str = None,
        subject: str = None,
        tags: List[str] = None,
        trackers: List[str] = None,
        verifier: str = None,
        versions: List[str] = None,
        workitem_type_identifier: str = None,
    ):
        self.assigned_to = assigned_to
        self.category = category
        self.description = description
        self.field_value_list = field_value_list
        self.parent_identifier = parent_identifier
        self.participants = participants
        self.space_identifier = space_identifier
        self.sprint_identifier = sprint_identifier
        self.subject = subject
        self.tags = tags
        self.trackers = trackers
        self.verifier = verifier
        self.versions = versions
        self.workitem_type_identifier = workitem_type_identifier

    def validate(self):
        if self.field_value_list:
            for k in self.field_value_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.category is not None:
            result['category'] = self.category
        if self.description is not None:
            result['description'] = self.description
        result['fieldValueList'] = []
        if self.field_value_list is not None:
            for k in self.field_value_list:
                result['fieldValueList'].append(k.to_map() if k else None)
        if self.parent_identifier is not None:
            result['parentIdentifier'] = self.parent_identifier
        if self.participants is not None:
            result['participants'] = self.participants
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.sprint_identifier is not None:
            result['sprintIdentifier'] = self.sprint_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.tags is not None:
            result['tags'] = self.tags
        if self.trackers is not None:
            result['trackers'] = self.trackers
        if self.verifier is not None:
            result['verifier'] = self.verifier
        if self.versions is not None:
            result['versions'] = self.versions
        if self.workitem_type_identifier is not None:
            result['workitemTypeIdentifier'] = self.workitem_type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('description') is not None:
            self.description = m.get('description')
        self.field_value_list = []
        if m.get('fieldValueList') is not None:
            for k in m.get('fieldValueList'):
                temp_model = CreateWorkitemV2RequestFieldValueList()
                self.field_value_list.append(temp_model.from_map(k))
        if m.get('parentIdentifier') is not None:
            self.parent_identifier = m.get('parentIdentifier')
        if m.get('participants') is not None:
            self.participants = m.get('participants')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('sprintIdentifier') is not None:
            self.sprint_identifier = m.get('sprintIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('trackers') is not None:
            self.trackers = m.get('trackers')
        if m.get('verifier') is not None:
            self.verifier = m.get('verifier')
        if m.get('versions') is not None:
            self.versions = m.get('versions')
        if m.get('workitemTypeIdentifier') is not None:
            self.workitem_type_identifier = m.get('workitemTypeIdentifier')
        return self


class CreateWorkitemV2ResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: str = None,
        workitem_identifier: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workitem_identifier = workitem_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class CreateWorkitemV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkitemV2ResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkitemV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkspaceRequest(TeaModel):
    def __init__(
        self,
        code_url: str = None,
        code_version: str = None,
        file_path: str = None,
        name: str = None,
        request_from: str = None,
        resource_identifier: str = None,
        reuse: bool = None,
        workspace_template: str = None,
    ):
        self.code_url = code_url
        self.code_version = code_version
        self.file_path = file_path
        self.name = name
        self.request_from = request_from
        self.resource_identifier = resource_identifier
        self.reuse = reuse
        self.workspace_template = workspace_template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_url is not None:
            result['codeUrl'] = self.code_url
        if self.code_version is not None:
            result['codeVersion'] = self.code_version
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.name is not None:
            result['name'] = self.name
        if self.request_from is not None:
            result['requestFrom'] = self.request_from
        if self.resource_identifier is not None:
            result['resourceIdentifier'] = self.resource_identifier
        if self.reuse is not None:
            result['reuse'] = self.reuse
        if self.workspace_template is not None:
            result['workspaceTemplate'] = self.workspace_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('codeUrl') is not None:
            self.code_url = m.get('codeUrl')
        if m.get('codeVersion') is not None:
            self.code_version = m.get('codeVersion')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestFrom') is not None:
            self.request_from = m.get('requestFrom')
        if m.get('resourceIdentifier') is not None:
            self.resource_identifier = m.get('resourceIdentifier')
        if m.get('reuse') is not None:
            self.reuse = m.get('reuse')
        if m.get('workspaceTemplate') is not None:
            self.workspace_template = m.get('workspaceTemplate')
        return self


class CreateWorkspaceResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        creator: str = None,
        id: str = None,
        name: str = None,
        status: str = None,
        template: str = None,
    ):
        self.create_time = create_time
        self.creator = creator
        self.id = id
        self.name = name
        self.status = status
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator is not None:
            result['creator'] = self.creator
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.status is not None:
            result['status'] = self.status
        if self.template is not None:
            result['template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('template') is not None:
            self.template = m.get('template')
        return self


class CreateWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        workspace: CreateWorkspaceResponseBodyWorkspace = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            self.workspace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workspace is not None:
            result['workspace'] = self.workspace.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workspace') is not None:
            temp_model = CreateWorkspaceResponseBodyWorkspace()
            self.workspace = temp_model.from_map(m['workspace'])
        return self


class CreateWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBranchRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        branch_name: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.branch_name = branch_name
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteBranchResponseBodyResult(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
    ):
        self.branch_name = branch_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        return self


class DeleteBranchResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteBranchResponseBodyResult = None,
        success: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteBranchResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteBranchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBranchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBranchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        branch_name: str = None,
        commit_message: str = None,
        file_path: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.branch_name = branch_name
        self.commit_message = commit_message
        self.file_path = file_path
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.commit_message is not None:
            result['commitMessage'] = self.commit_message
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('commitMessage') is not None:
            self.commit_message = m.get('commitMessage')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteFileResponseBodyResult(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
        file_path: str = None,
    ):
        self.branch_name = branch_name
        self.file_path = file_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.file_path is not None:
            result['filePath'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        return self


class DeleteFileResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteFileResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteFileResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowTagResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteFlowTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFlowTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFlowTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteFlowTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFlowTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFlowTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        aliyun_pk: str = None,
        member_type: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.aliyun_pk = aliyun_pk
        self.member_type = member_type
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.aliyun_pk is not None:
            result['aliyunPk'] = self.aliyun_pk
        if self.member_type is not None:
            result['memberType'] = self.member_type
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('aliyunPk') is not None:
            self.aliyun_pk = m.get('aliyunPk')
        if m.get('memberType') is not None:
            self.member_type = m.get('memberType')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteGroupMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        avatar_url: str = None,
        id: int = None,
        member_type: str = None,
        name: str = None,
        source_id: int = None,
        state: str = None,
        username: str = None,
    ):
        self.access_level = access_level
        self.avatar_url = avatar_url
        self.id = id
        self.member_type = member_type
        self.name = name
        self.source_id = source_id
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.id is not None:
            result['id'] = self.id
        if self.member_type is not None:
            result['memberType'] = self.member_type
        if self.name is not None:
            result['name'] = self.name
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('memberType') is not None:
            self.member_type = m.get('memberType')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DeleteGroupMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteGroupMemberResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteGroupMemberResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteGroupMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeletePipelineGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePipelineGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRelationsRequest(TeaModel):
    def __init__(
        self,
        rel_object_id: str = None,
        rel_object_type: str = None,
    ):
        self.rel_object_id = rel_object_id
        self.rel_object_type = rel_object_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rel_object_id is not None:
            result['relObjectId'] = self.rel_object_id
        if self.rel_object_type is not None:
            result['relObjectType'] = self.rel_object_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('relObjectId') is not None:
            self.rel_object_id = m.get('relObjectId')
        if m.get('relObjectType') is not None:
            self.rel_object_type = m.get('relObjectType')
        return self


class DeletePipelineRelationsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeletePipelineRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePipelineRelationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectRequest(TeaModel):
    def __init__(
        self,
        identifier: str = None,
    ):
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        return self


class DeleteProjectResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        result: bool = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProtectedBranchRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteProtectedBranchResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteProtectedBranchResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteProtectedBranchResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteProtectedBranchResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteProtectedBranchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteProtectedBranchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProtectedBranchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePushRuleRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeletePushRuleResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeletePushRuleResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeletePushRuleResponseBodyResult = None,
        success: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeletePushRuleResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeletePushRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePushRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePushRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRepositoryRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        reason: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.reason = reason
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.reason is not None:
            result['reason'] = self.reason
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteRepositoryResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteRepositoryResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteRepositoryResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteRepositoryResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteRepositoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRepositoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRepositoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRepositoryGroupRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        reason: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.reason = reason
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.reason is not None:
            result['reason'] = self.reason
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteRepositoryGroupResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteRepositoryGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteRepositoryGroupResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteRepositoryGroupResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteRepositoryGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRepositoryGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRepositoryGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRepositoryMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        member_type: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.member_type = member_type
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.member_type is not None:
            result['memberType'] = self.member_type
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('memberType') is not None:
            self.member_type = m.get('memberType')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteRepositoryMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        create_at: str = None,
        id: int = None,
        source_id: int = None,
        source_type: str = None,
        update_at: str = None,
        user_id: int = None,
    ):
        self.access_level = access_level
        self.create_at = create_at
        self.id = id
        self.source_id = source_id
        self.source_type = source_type
        self.update_at = update_at
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.create_at is not None:
            result['createAt'] = self.create_at
        if self.id is not None:
            result['id'] = self.id
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.update_at is not None:
            result['updateAt'] = self.update_at
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('createAt') is not None:
            self.create_at = m.get('createAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('updateAt') is not None:
            self.update_at = m.get('updateAt')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class DeleteRepositoryMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteRepositoryMemberResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteRepositoryMemberResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteRepositoryMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRepositoryMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRepositoryMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRepositoryWebhookRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteRepositoryWebhookResponseBodyResult(TeaModel):
    def __init__(
        self,
        build_events: bool = None,
        created_at: str = None,
        description: str = None,
        enable_ssl_verification: bool = None,
        id: int = None,
        issues_events: bool = None,
        last_test_result: str = None,
        merge_requests_events: bool = None,
        note_events: bool = None,
        project_id: int = None,
        push_events: bool = None,
        secret_token: str = None,
        tag_push_events: bool = None,
        type: str = None,
        url: str = None,
    ):
        self.build_events = build_events
        self.created_at = created_at
        self.description = description
        self.enable_ssl_verification = enable_ssl_verification
        self.id = id
        self.issues_events = issues_events
        self.last_test_result = last_test_result
        self.merge_requests_events = merge_requests_events
        self.note_events = note_events
        self.project_id = project_id
        self.push_events = push_events
        self.secret_token = secret_token
        self.tag_push_events = tag_push_events
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_events is not None:
            result['buildEvents'] = self.build_events
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.description is not None:
            result['description'] = self.description
        if self.enable_ssl_verification is not None:
            result['enableSslVerification'] = self.enable_ssl_verification
        if self.id is not None:
            result['id'] = self.id
        if self.issues_events is not None:
            result['issuesEvents'] = self.issues_events
        if self.last_test_result is not None:
            result['lastTestResult'] = self.last_test_result
        if self.merge_requests_events is not None:
            result['mergeRequestsEvents'] = self.merge_requests_events
        if self.note_events is not None:
            result['noteEvents'] = self.note_events
        if self.project_id is not None:
            result['projectId'] = self.project_id
        if self.push_events is not None:
            result['pushEvents'] = self.push_events
        if self.secret_token is not None:
            result['secretToken'] = self.secret_token
        if self.tag_push_events is not None:
            result['tagPushEvents'] = self.tag_push_events
        if self.type is not None:
            result['type'] = self.type
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('buildEvents') is not None:
            self.build_events = m.get('buildEvents')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableSslVerification') is not None:
            self.enable_ssl_verification = m.get('enableSslVerification')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('issuesEvents') is not None:
            self.issues_events = m.get('issuesEvents')
        if m.get('lastTestResult') is not None:
            self.last_test_result = m.get('lastTestResult')
        if m.get('mergeRequestsEvents') is not None:
            self.merge_requests_events = m.get('mergeRequestsEvents')
        if m.get('noteEvents') is not None:
            self.note_events = m.get('noteEvents')
        if m.get('projectId') is not None:
            self.project_id = m.get('projectId')
        if m.get('pushEvents') is not None:
            self.push_events = m.get('pushEvents')
        if m.get('secretToken') is not None:
            self.secret_token = m.get('secretToken')
        if m.get('tagPushEvents') is not None:
            self.tag_push_events = m.get('tagPushEvents')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class DeleteRepositoryWebhookResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteRepositoryWebhookResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteRepositoryWebhookResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteRepositoryWebhookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRepositoryWebhookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRepositoryWebhookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteResourceMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteResourceMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteResourceMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteResourceMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
        tag_name: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.tag_name is not None:
            result['tagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('tagName') is not None:
            self.tag_name = m.get('tagName')
        return self


class DeleteTagResponseBodyResult(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
    ):
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['tagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tagName') is not None:
            self.tag_name = m.get('tagName')
        return self


class DeleteTagResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteTagResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteTagResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserKeyRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class DeleteUserKeyResponseBodyResult(TeaModel):
    def __init__(
        self,
        context: str = None,
        created_at: str = None,
        expire_time: str = None,
        finger_print: str = None,
        id: int = None,
        key_scope: str = None,
        last_used_time: str = None,
        public_key: str = None,
        sha_context: str = None,
        title: str = None,
        updated_at: str = None,
    ):
        self.context = context
        self.created_at = created_at
        self.expire_time = expire_time
        self.finger_print = finger_print
        self.id = id
        self.key_scope = key_scope
        self.last_used_time = last_used_time
        self.public_key = public_key
        self.sha_context = sha_context
        self.title = title
        self.updated_at = updated_at

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['context'] = self.context
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.finger_print is not None:
            result['fingerPrint'] = self.finger_print
        if self.id is not None:
            result['id'] = self.id
        if self.key_scope is not None:
            result['keyScope'] = self.key_scope
        if self.last_used_time is not None:
            result['lastUsedTime'] = self.last_used_time
        if self.public_key is not None:
            result['publicKey'] = self.public_key
        if self.sha_context is not None:
            result['shaContext'] = self.sha_context
        if self.title is not None:
            result['title'] = self.title
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('context') is not None:
            self.context = m.get('context')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('fingerPrint') is not None:
            self.finger_print = m.get('fingerPrint')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('keyScope') is not None:
            self.key_scope = m.get('keyScope')
        if m.get('lastUsedTime') is not None:
            self.last_used_time = m.get('lastUsedTime')
        if m.get('publicKey') is not None:
            self.public_key = m.get('publicKey')
        if m.get('shaContext') is not None:
            self.sha_context = m.get('shaContext')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        return self


class DeleteUserKeyResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: DeleteUserKeyResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = DeleteUserKeyResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteUserKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUserKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVariableGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteVariableGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVariableGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVariableGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkitemRequest(TeaModel):
    def __init__(
        self,
        identifier: str = None,
    ):
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        return self


class DeleteWorkitemResponseBody(TeaModel):
    def __init__(
        self,
        delete_flag: bool = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.delete_flag = delete_flag
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        # true/false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_flag is not None:
            result['deleteFlag'] = self.delete_flag
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteFlag') is not None:
            self.delete_flag = m.get('deleteFlag')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteWorkitemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWorkitemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWorkitemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkitemAllCommentRequest(TeaModel):
    def __init__(
        self,
        identifier: str = None,
    ):
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        return self


class DeleteWorkitemAllCommentResponseBody(TeaModel):
    def __init__(
        self,
        delete_flag: bool = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.delete_flag = delete_flag
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_flag is not None:
            result['deleteFlag'] = self.delete_flag
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteFlag') is not None:
            self.delete_flag = m.get('deleteFlag')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteWorkitemAllCommentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWorkitemAllCommentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWorkitemAllCommentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkitemCommentRequest(TeaModel):
    def __init__(
        self,
        comment_id: int = None,
        identifier: str = None,
    ):
        self.comment_id = comment_id
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment_id is not None:
            result['commentId'] = self.comment_id
        if self.identifier is not None:
            result['identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commentId') is not None:
            self.comment_id = m.get('commentId')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        return self


class DeleteWorkitemCommentResponseBody(TeaModel):
    def __init__(
        self,
        delete_flag: bool = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.delete_flag = delete_flag
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_flag is not None:
            result['deleteFlag'] = self.delete_flag
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteFlag') is not None:
            self.delete_flag = m.get('deleteFlag')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteWorkitemCommentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWorkitemCommentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWorkitemCommentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeployKeyRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class EnableDeployKeyResponseBodyResult(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class EnableDeployKeyResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: EnableDeployKeyResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = EnableDeployKeyResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EnableDeployKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableDeployKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDeployKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FrozenWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class FrozenWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FrozenWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FrozenWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBranchInfoRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        branch_name: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.branch_name = branch_name
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.branch_name is not None:
            result['branchName'] = self.branch_name
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('branchName') is not None:
            self.branch_name = m.get('branchName')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetBranchInfoResponseBodyResultCommitAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetBranchInfoResponseBodyResultCommitCommitter(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetBranchInfoResponseBodyResultCommitSignature(TeaModel):
    def __init__(
        self,
        gpg_key_id: str = None,
        verification_status: str = None,
    ):
        self.gpg_key_id = gpg_key_id
        self.verification_status = verification_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gpg_key_id is not None:
            result['gpgKeyId'] = self.gpg_key_id
        if self.verification_status is not None:
            result['verificationStatus'] = self.verification_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gpgKeyId') is not None:
            self.gpg_key_id = m.get('gpgKeyId')
        if m.get('verificationStatus') is not None:
            self.verification_status = m.get('verificationStatus')
        return self


class GetBranchInfoResponseBodyResultCommit(TeaModel):
    def __init__(
        self,
        author: GetBranchInfoResponseBodyResultCommitAuthor = None,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        comments_count: int = None,
        committed_date: str = None,
        committer: GetBranchInfoResponseBodyResultCommitCommitter = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        signature: GetBranchInfoResponseBodyResultCommitSignature = None,
        title: str = None,
    ):
        self.author = author
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.comments_count = comments_count
        self.committed_date = committed_date
        self.committer = committer
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.signature = signature
        self.title = title

    def validate(self):
        if self.author:
            self.author.validate()
        if self.committer:
            self.committer.validate()
        if self.signature:
            self.signature.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.comments_count is not None:
            result['commentsCount'] = self.comments_count
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer is not None:
            result['committer'] = self.committer.to_map()
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            temp_model = GetBranchInfoResponseBodyResultCommitAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('commentsCount') is not None:
            self.comments_count = m.get('commentsCount')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committer') is not None:
            temp_model = GetBranchInfoResponseBodyResultCommitCommitter()
            self.committer = temp_model.from_map(m['committer'])
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('signature') is not None:
            temp_model = GetBranchInfoResponseBodyResultCommitSignature()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetBranchInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        commit: GetBranchInfoResponseBodyResultCommit = None,
        name: str = None,
        protected: str = None,
    ):
        self.commit = commit
        self.name = name
        self.protected = protected

    def validate(self):
        if self.commit:
            self.commit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit is not None:
            result['commit'] = self.commit.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.protected is not None:
            result['protected'] = self.protected
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commit') is not None:
            temp_model = GetBranchInfoResponseBodyResultCommit()
            self.commit = temp_model.from_map(m['commit'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('protected') is not None:
            self.protected = m.get('protected')
        return self


class GetBranchInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetBranchInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetBranchInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetBranchInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBranchInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBranchInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCodeupOrganizationRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
    ):
        self.access_token = access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        return self


class GetCodeupOrganizationResponseBodyResult(TeaModel):
    def __init__(
        self,
        created_at: str = None,
        id: int = None,
        namespace_id: int = None,
        organization_id: str = None,
        path: str = None,
        updated_at: str = None,
        user_role: str = None,
    ):
        self.created_at = created_at
        self.id = id
        self.namespace_id = namespace_id
        self.organization_id = organization_id
        self.path = path
        self.updated_at = updated_at
        self.user_role = user_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.namespace_id is not None:
            result['namespaceId'] = self.namespace_id
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.path is not None:
            result['path'] = self.path
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.user_role is not None:
            result['userRole'] = self.user_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('namespaceId') is not None:
            self.namespace_id = m.get('namespaceId')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('userRole') is not None:
            self.user_role = m.get('userRole')
        return self


class GetCodeupOrganizationResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetCodeupOrganizationResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetCodeupOrganizationResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCodeupOrganizationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCodeupOrganizationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCodeupOrganizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCompareDetailRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        max_diff_byte: int = None,
        max_diff_file: int = None,
        merge_base: bool = None,
        organization_id: str = None,
        to: str = None,
    ):
        self.from_ = from_
        self.max_diff_byte = max_diff_byte
        self.max_diff_file = max_diff_file
        self.merge_base = merge_base
        self.organization_id = organization_id
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['from'] = self.from_
        if self.max_diff_byte is not None:
            result['maxDiffByte'] = self.max_diff_byte
        if self.max_diff_file is not None:
            result['maxDiffFile'] = self.max_diff_file
        if self.merge_base is not None:
            result['mergeBase'] = self.merge_base
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.to is not None:
            result['to'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('from') is not None:
            self.from_ = m.get('from')
        if m.get('maxDiffByte') is not None:
            self.max_diff_byte = m.get('maxDiffByte')
        if m.get('maxDiffFile') is not None:
            self.max_diff_file = m.get('maxDiffFile')
        if m.get('mergeBase') is not None:
            self.merge_base = m.get('mergeBase')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('to') is not None:
            self.to = m.get('to')
        return self


class GetCompareDetailResponseBodyResultCommitsAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetCompareDetailResponseBodyResultCommitsCommitter(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetCompareDetailResponseBodyResultCommits(TeaModel):
    def __init__(
        self,
        author: GetCompareDetailResponseBodyResultCommitsAuthor = None,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        comments_count: int = None,
        committed_date: str = None,
        committer: GetCompareDetailResponseBodyResultCommitsCommitter = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        title: str = None,
    ):
        self.author = author
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.comments_count = comments_count
        self.committed_date = committed_date
        self.committer = committer
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.title = title

    def validate(self):
        if self.author:
            self.author.validate()
        if self.committer:
            self.committer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.comments_count is not None:
            result['commentsCount'] = self.comments_count
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer is not None:
            result['committer'] = self.committer.to_map()
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            temp_model = GetCompareDetailResponseBodyResultCommitsAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('commentsCount') is not None:
            self.comments_count = m.get('commentsCount')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committer') is not None:
            temp_model = GetCompareDetailResponseBodyResultCommitsCommitter()
            self.committer = temp_model.from_map(m['committer'])
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetCompareDetailResponseBodyResultDiffs(TeaModel):
    def __init__(
        self,
        a_mode: str = None,
        b_mode: str = None,
        deleted_file: bool = None,
        diff: str = None,
        is_binary: bool = None,
        is_new_lfs: bool = None,
        is_old_lfs: bool = None,
        new_file: bool = None,
        new_id: str = None,
        new_path: str = None,
        old_id: str = None,
        old_path: str = None,
        renamed_file: bool = None,
    ):
        self.a_mode = a_mode
        self.b_mode = b_mode
        self.deleted_file = deleted_file
        self.diff = diff
        self.is_binary = is_binary
        self.is_new_lfs = is_new_lfs
        self.is_old_lfs = is_old_lfs
        self.new_file = new_file
        self.new_id = new_id
        self.new_path = new_path
        self.old_id = old_id
        self.old_path = old_path
        self.renamed_file = renamed_file

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.a_mode is not None:
            result['aMode'] = self.a_mode
        if self.b_mode is not None:
            result['bMode'] = self.b_mode
        if self.deleted_file is not None:
            result['deletedFile'] = self.deleted_file
        if self.diff is not None:
            result['diff'] = self.diff
        if self.is_binary is not None:
            result['isBinary'] = self.is_binary
        if self.is_new_lfs is not None:
            result['isNewLfs'] = self.is_new_lfs
        if self.is_old_lfs is not None:
            result['isOldLfs'] = self.is_old_lfs
        if self.new_file is not None:
            result['newFile'] = self.new_file
        if self.new_id is not None:
            result['newId'] = self.new_id
        if self.new_path is not None:
            result['newPath'] = self.new_path
        if self.old_id is not None:
            result['oldId'] = self.old_id
        if self.old_path is not None:
            result['oldPath'] = self.old_path
        if self.renamed_file is not None:
            result['renamedFile'] = self.renamed_file
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aMode') is not None:
            self.a_mode = m.get('aMode')
        if m.get('bMode') is not None:
            self.b_mode = m.get('bMode')
        if m.get('deletedFile') is not None:
            self.deleted_file = m.get('deletedFile')
        if m.get('diff') is not None:
            self.diff = m.get('diff')
        if m.get('isBinary') is not None:
            self.is_binary = m.get('isBinary')
        if m.get('isNewLfs') is not None:
            self.is_new_lfs = m.get('isNewLfs')
        if m.get('isOldLfs') is not None:
            self.is_old_lfs = m.get('isOldLfs')
        if m.get('newFile') is not None:
            self.new_file = m.get('newFile')
        if m.get('newId') is not None:
            self.new_id = m.get('newId')
        if m.get('newPath') is not None:
            self.new_path = m.get('newPath')
        if m.get('oldId') is not None:
            self.old_id = m.get('oldId')
        if m.get('oldPath') is not None:
            self.old_path = m.get('oldPath')
        if m.get('renamedFile') is not None:
            self.renamed_file = m.get('renamedFile')
        return self


class GetCompareDetailResponseBodyResult(TeaModel):
    def __init__(
        self,
        commits: List[GetCompareDetailResponseBodyResultCommits] = None,
        diffs: List[GetCompareDetailResponseBodyResultDiffs] = None,
        messages: List[str] = None,
    ):
        self.commits = commits
        self.diffs = diffs
        self.messages = messages

    def validate(self):
        if self.commits:
            for k in self.commits:
                if k:
                    k.validate()
        if self.diffs:
            for k in self.diffs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['commits'] = []
        if self.commits is not None:
            for k in self.commits:
                result['commits'].append(k.to_map() if k else None)
        result['diffs'] = []
        if self.diffs is not None:
            for k in self.diffs:
                result['diffs'].append(k.to_map() if k else None)
        if self.messages is not None:
            result['messages'] = self.messages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.commits = []
        if m.get('commits') is not None:
            for k in m.get('commits'):
                temp_model = GetCompareDetailResponseBodyResultCommits()
                self.commits.append(temp_model.from_map(k))
        self.diffs = []
        if m.get('diffs') is not None:
            for k in m.get('diffs'):
                temp_model = GetCompareDetailResponseBodyResultDiffs()
                self.diffs.append(temp_model.from_map(k))
        if m.get('messages') is not None:
            self.messages = m.get('messages')
        return self


class GetCompareDetailResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetCompareDetailResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetCompareDetailResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCompareDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCompareDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCompareDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomFieldOptionRequest(TeaModel):
    def __init__(
        self,
        space_identifier: str = None,
        space_type: str = None,
        workitem_type_identifier: str = None,
    ):
        self.space_identifier = space_identifier
        self.space_type = space_type
        self.workitem_type_identifier = workitem_type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.workitem_type_identifier is not None:
            result['workitemTypeIdentifier'] = self.workitem_type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('workitemTypeIdentifier') is not None:
            self.workitem_type_identifier = m.get('workitemTypeIdentifier')
        return self


class GetCustomFieldOptionResponseBodyFileds(TeaModel):
    def __init__(
        self,
        display_value: str = None,
        field_identifier: str = None,
        identifier: str = None,
        level: int = None,
        position: int = None,
        value: str = None,
        value_en: str = None,
    ):
        self.display_value = display_value
        self.field_identifier = field_identifier
        self.identifier = identifier
        self.level = level
        self.position = position
        self.value = value
        self.value_en = value_en

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_value is not None:
            result['displayValue'] = self.display_value
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.level is not None:
            result['level'] = self.level
        if self.position is not None:
            result['position'] = self.position
        if self.value is not None:
            result['value'] = self.value
        if self.value_en is not None:
            result['valueEn'] = self.value_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayValue') is not None:
            self.display_value = m.get('displayValue')
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueEn') is not None:
            self.value_en = m.get('valueEn')
        return self


class GetCustomFieldOptionResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        fileds: List[GetCustomFieldOptionResponseBodyFileds] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.fileds = fileds
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.fileds:
            for k in self.fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        result['fileds'] = []
        if self.fileds is not None:
            for k in self.fileds:
                result['fileds'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        self.fileds = []
        if m.get('fileds') is not None:
            for k in m.get('fileds'):
                temp_model = GetCustomFieldOptionResponseBodyFileds()
                self.fileds.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCustomFieldOptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomFieldOptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomFieldOptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileBlobsRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        file_path: str = None,
        from_: int = None,
        organization_id: str = None,
        ref: str = None,
        to: int = None,
    ):
        self.access_token = access_token
        self.file_path = file_path
        self.from_ = from_
        self.organization_id = organization_id
        self.ref = ref
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.from_ is not None:
            result['from'] = self.from_
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.ref is not None:
            result['ref'] = self.ref
        if self.to is not None:
            result['to'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('from') is not None:
            self.from_ = m.get('from')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('ref') is not None:
            self.ref = m.get('ref')
        if m.get('to') is not None:
            self.to = m.get('to')
        return self


class GetFileBlobsResponseBodyResult(TeaModel):
    def __init__(
        self,
        content: str = None,
        total_lines: int = None,
    ):
        self.content = content
        self.total_lines = total_lines

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.total_lines is not None:
            result['totalLines'] = self.total_lines
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('totalLines') is not None:
            self.total_lines = m.get('totalLines')
        return self


class GetFileBlobsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetFileBlobsResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetFileBlobsResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetFileBlobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileBlobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileBlobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileLastCommitRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        file_path: str = None,
        organization_id: str = None,
        sha: str = None,
        show_signature: bool = None,
    ):
        self.access_token = access_token
        self.file_path = file_path
        self.organization_id = organization_id
        self.sha = sha
        self.show_signature = show_signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.sha is not None:
            result['sha'] = self.sha
        if self.show_signature is not None:
            result['showSignature'] = self.show_signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('sha') is not None:
            self.sha = m.get('sha')
        if m.get('showSignature') is not None:
            self.show_signature = m.get('showSignature')
        return self


class GetFileLastCommitResponseBodyResultSignature(TeaModel):
    def __init__(
        self,
        gpg_key_id: str = None,
        verification_status: str = None,
    ):
        # GPG密钥ID
        self.gpg_key_id = gpg_key_id
        self.verification_status = verification_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gpg_key_id is not None:
            result['gpgKeyId'] = self.gpg_key_id
        if self.verification_status is not None:
            result['verificationStatus'] = self.verification_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gpgKeyId') is not None:
            self.gpg_key_id = m.get('gpgKeyId')
        if m.get('verificationStatus') is not None:
            self.verification_status = m.get('verificationStatus')
        return self


class GetFileLastCommitResponseBodyResult(TeaModel):
    def __init__(
        self,
        author_date: str = None,
        author_email: str = None,
        author_name: str = None,
        committed_date: str = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        signature: GetFileLastCommitResponseBodyResultSignature = None,
        title: str = None,
    ):
        self.author_date = author_date
        self.author_email = author_email
        self.author_name = author_name
        self.committed_date = committed_date
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.signature = signature
        self.title = title

    def validate(self):
        if self.signature:
            self.signature.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author_date is not None:
            result['authorDate'] = self.author_date
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authorDate') is not None:
            self.author_date = m.get('authorDate')
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('signature') is not None:
            temp_model = GetFileLastCommitResponseBodyResultSignature()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetFileLastCommitResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetFileLastCommitResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetFileLastCommitResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetFileLastCommitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileLastCommitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileLastCommitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFlowTagGroupResponseBodyFlowTagGroupFlowTagList(TeaModel):
    def __init__(
        self,
        color: str = None,
        creator_account_id: str = None,
        id: int = None,
        modifer_account_id: str = None,
        name: str = None,
    ):
        self.color = color
        self.creator_account_id = creator_account_id
        self.id = id
        self.modifer_account_id = modifer_account_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.color is not None:
            result['color'] = self.color
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.id is not None:
            result['id'] = self.id
        if self.modifer_account_id is not None:
            result['modiferAccountId'] = self.modifer_account_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('color') is not None:
            self.color = m.get('color')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modiferAccountId') is not None:
            self.modifer_account_id = m.get('modiferAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetFlowTagGroupResponseBodyFlowTagGroup(TeaModel):
    def __init__(
        self,
        creator_account_id: str = None,
        flow_tag_list: List[GetFlowTagGroupResponseBodyFlowTagGroupFlowTagList] = None,
        id: int = None,
        modifer_account_id: str = None,
        name: str = None,
    ):
        self.creator_account_id = creator_account_id
        self.flow_tag_list = flow_tag_list
        self.id = id
        self.modifer_account_id = modifer_account_id
        self.name = name

    def validate(self):
        if self.flow_tag_list:
            for k in self.flow_tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        result['flowTagList'] = []
        if self.flow_tag_list is not None:
            for k in self.flow_tag_list:
                result['flowTagList'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.modifer_account_id is not None:
            result['modiferAccountId'] = self.modifer_account_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        self.flow_tag_list = []
        if m.get('flowTagList') is not None:
            for k in m.get('flowTagList'):
                temp_model = GetFlowTagGroupResponseBodyFlowTagGroupFlowTagList()
                self.flow_tag_list.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modiferAccountId') is not None:
            self.modifer_account_id = m.get('modiferAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetFlowTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        flow_tag_group: GetFlowTagGroupResponseBodyFlowTagGroup = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.flow_tag_group = flow_tag_group
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.flow_tag_group:
            self.flow_tag_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.flow_tag_group is not None:
            result['flowTagGroup'] = self.flow_tag_group.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('flowTagGroup') is not None:
            temp_model = GetFlowTagGroupResponseBodyFlowTagGroup()
            self.flow_tag_group = temp_model.from_map(m['flowTagGroup'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetFlowTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFlowTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFlowTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGroupByPathRequest(TeaModel):
    def __init__(
        self,
        identity: str = None,
        organization_id: str = None,
    ):
        self.identity = identity
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity is not None:
            result['identity'] = self.identity
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identity') is not None:
            self.identity = m.get('identity')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetGroupByPathResponseBodyResult(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        description: str = None,
        id: int = None,
        name: str = None,
        name_with_namespace: str = None,
        owner_id: str = None,
        parent_id: str = None,
        path: str = None,
        path_with_namespace: str = None,
        visibility_level: int = None,
        web_url: str = None,
    ):
        self.avatar_url = avatar_url
        self.description = description
        self.id = id
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.owner_id = owner_id
        self.parent_id = parent_id
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.visibility_level = visibility_level
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class GetGroupByPathResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetGroupByPathResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetGroupByPathResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetGroupByPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGroupByPathResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGroupByPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGroupDetailRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        group_id: int = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.group_id = group_id
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetGroupDetailResponseBodyResult(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        description: str = None,
        id: int = None,
        name: str = None,
        name_with_namespace: str = None,
        owner_id: int = None,
        parent_id: int = None,
        path: str = None,
        path_with_namespace: str = None,
        type: str = None,
        visibility_level: int = None,
        web_url: str = None,
    ):
        self.avatar_url = avatar_url
        self.description = description
        self.id = id
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.owner_id = owner_id
        self.parent_id = parent_id
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.type = type
        self.visibility_level = visibility_level
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.type is not None:
            result['type'] = self.type
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class GetGroupDetailResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetGroupDetailResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetGroupDetailResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetGroupDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGroupDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGroupDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHostGroupResponseBodyHostGroupHostInfos(TeaModel):
    def __init__(
        self,
        aliyun_region_id: str = None,
        create_time: int = None,
        creator_account_id: str = None,
        instance_name: str = None,
        ip: str = None,
        machine_sn: str = None,
        modifier_account_id: str = None,
        object_type: str = None,
        update_time: int = None,
    ):
        self.aliyun_region_id = aliyun_region_id
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.instance_name = instance_name
        self.ip = ip
        self.machine_sn = machine_sn
        self.modifier_account_id = modifier_account_id
        self.object_type = object_type
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_region_id is not None:
            result['aliyunRegionId'] = self.aliyun_region_id
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.instance_name is not None:
            result['instanceName'] = self.instance_name
        if self.ip is not None:
            result['ip'] = self.ip
        if self.machine_sn is not None:
            result['machineSn'] = self.machine_sn
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.object_type is not None:
            result['objectType'] = self.object_type
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aliyunRegionId') is not None:
            self.aliyun_region_id = m.get('aliyunRegionId')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('instanceName') is not None:
            self.instance_name = m.get('instanceName')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('machineSn') is not None:
            self.machine_sn = m.get('machineSn')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('objectType') is not None:
            self.object_type = m.get('objectType')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetHostGroupResponseBodyHostGroup(TeaModel):
    def __init__(
        self,
        aliyun_region: str = None,
        create_time: int = None,
        creator_account_id: str = None,
        description: str = None,
        ecs_label_key: str = None,
        ecs_label_value: str = None,
        ecs_type: str = None,
        host_infos: List[GetHostGroupResponseBodyHostGroupHostInfos] = None,
        host_num: int = None,
        id: int = None,
        modifier_account_id: str = None,
        name: str = None,
        service_connection_id: int = None,
        type: str = None,
        upate_time: int = None,
    ):
        self.aliyun_region = aliyun_region
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.description = description
        self.ecs_label_key = ecs_label_key
        self.ecs_label_value = ecs_label_value
        self.ecs_type = ecs_type
        self.host_infos = host_infos
        self.host_num = host_num
        self.id = id
        self.modifier_account_id = modifier_account_id
        self.name = name
        self.service_connection_id = service_connection_id
        self.type = type
        self.upate_time = upate_time

    def validate(self):
        if self.host_infos:
            for k in self.host_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_region is not None:
            result['aliyunRegion'] = self.aliyun_region
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.description is not None:
            result['description'] = self.description
        if self.ecs_label_key is not None:
            result['ecsLabelKey'] = self.ecs_label_key
        if self.ecs_label_value is not None:
            result['ecsLabelValue'] = self.ecs_label_value
        if self.ecs_type is not None:
            result['ecsType'] = self.ecs_type
        result['hostInfos'] = []
        if self.host_infos is not None:
            for k in self.host_infos:
                result['hostInfos'].append(k.to_map() if k else None)
        if self.host_num is not None:
            result['hostNum'] = self.host_num
        if self.id is not None:
            result['id'] = self.id
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.name is not None:
            result['name'] = self.name
        if self.service_connection_id is not None:
            result['serviceConnectionId'] = self.service_connection_id
        if self.type is not None:
            result['type'] = self.type
        if self.upate_time is not None:
            result['upateTIme'] = self.upate_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aliyunRegion') is not None:
            self.aliyun_region = m.get('aliyunRegion')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('ecsLabelKey') is not None:
            self.ecs_label_key = m.get('ecsLabelKey')
        if m.get('ecsLabelValue') is not None:
            self.ecs_label_value = m.get('ecsLabelValue')
        if m.get('ecsType') is not None:
            self.ecs_type = m.get('ecsType')
        self.host_infos = []
        if m.get('hostInfos') is not None:
            for k in m.get('hostInfos'):
                temp_model = GetHostGroupResponseBodyHostGroupHostInfos()
                self.host_infos.append(temp_model.from_map(k))
        if m.get('hostNum') is not None:
            self.host_num = m.get('hostNum')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('serviceConnectionId') is not None:
            self.service_connection_id = m.get('serviceConnectionId')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('upateTIme') is not None:
            self.upate_time = m.get('upateTIme')
        return self


class GetHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        host_group: GetHostGroupResponseBodyHostGroup = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.host_group = host_group
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.host_group:
            self.host_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.host_group is not None:
            result['hostGroup'] = self.host_group.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('hostGroup') is not None:
            temp_model = GetHostGroupResponseBodyHostGroup()
            self.host_group = temp_model.from_map(m['hostGroup'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMergeRequestRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetMergeRequestResponseBodyResultAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetMergeRequestResponseBodyResultReviewers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        has_reviewed: bool = None,
        id: int = None,
        name: str = None,
        review_opinion_status: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.has_reviewed = has_reviewed
        self.id = id
        self.name = name
        self.review_opinion_status = review_opinion_status
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.has_reviewed is not None:
            result['hasReviewed'] = self.has_reviewed
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.review_opinion_status is not None:
            result['reviewOpinionStatus'] = self.review_opinion_status
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('hasReviewed') is not None:
            self.has_reviewed = m.get('hasReviewed')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('reviewOpinionStatus') is not None:
            self.review_opinion_status = m.get('reviewOpinionStatus')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetMergeRequestResponseBodyResultSubscribers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetMergeRequestResponseBodyResultTodoListRequirementCheckItems(TeaModel):
    def __init__(
        self,
        item_type: str = None,
        pass_: bool = None,
    ):
        self.item_type = item_type
        self.pass_ = pass_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_type is not None:
            result['itemType'] = self.item_type
        if self.pass_ is not None:
            result['pass'] = self.pass_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('itemType') is not None:
            self.item_type = m.get('itemType')
        if m.get('pass') is not None:
            self.pass_ = m.get('pass')
        return self


class GetMergeRequestResponseBodyResultTodoList(TeaModel):
    def __init__(
        self,
        requirement_check_items: List[GetMergeRequestResponseBodyResultTodoListRequirementCheckItems] = None,
    ):
        self.requirement_check_items = requirement_check_items

    def validate(self):
        if self.requirement_check_items:
            for k in self.requirement_check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['requirementCheckItems'] = []
        if self.requirement_check_items is not None:
            for k in self.requirement_check_items:
                result['requirementCheckItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.requirement_check_items = []
        if m.get('requirementCheckItems') is not None:
            for k in m.get('requirementCheckItems'):
                temp_model = GetMergeRequestResponseBodyResultTodoListRequirementCheckItems()
                self.requirement_check_items.append(temp_model.from_map(k))
        return self


class GetMergeRequestResponseBodyResult(TeaModel):
    def __init__(
        self,
        ahead: int = None,
        all_requirements_pass: bool = None,
        author: GetMergeRequestResponseBodyResultAuthor = None,
        behind: int = None,
        create_from: str = None,
        create_time: str = None,
        description: str = None,
        detail_url: str = None,
        local_id: int = None,
        mr_biz_id: str = None,
        mr_type: str = None,
        project_id: int = None,
        reviewers: List[GetMergeRequestResponseBodyResultReviewers] = None,
        source_branch: str = None,
        source_project_id: int = None,
        status: str = None,
        subscribers: List[GetMergeRequestResponseBodyResultSubscribers] = None,
        support_merge_fast_forward_only: bool = None,
        target_branch: str = None,
        target_project_id: int = None,
        target_project_name_with_namespace: str = None,
        target_project_path_with_namespace: str = None,
        title: str = None,
        todo_list: GetMergeRequestResponseBodyResultTodoList = None,
        update_time: str = None,
        web_url: str = None,
    ):
        self.ahead = ahead
        self.all_requirements_pass = all_requirements_pass
        self.author = author
        self.behind = behind
        self.create_from = create_from
        self.create_time = create_time
        self.description = description
        self.detail_url = detail_url
        self.local_id = local_id
        self.mr_biz_id = mr_biz_id
        self.mr_type = mr_type
        self.project_id = project_id
        self.reviewers = reviewers
        self.source_branch = source_branch
        self.source_project_id = source_project_id
        self.status = status
        self.subscribers = subscribers
        self.support_merge_fast_forward_only = support_merge_fast_forward_only
        self.target_branch = target_branch
        self.target_project_id = target_project_id
        self.target_project_name_with_namespace = target_project_name_with_namespace
        self.target_project_path_with_namespace = target_project_path_with_namespace
        self.title = title
        self.todo_list = todo_list
        self.update_time = update_time
        self.web_url = web_url

    def validate(self):
        if self.author:
            self.author.validate()
        if self.reviewers:
            for k in self.reviewers:
                if k:
                    k.validate()
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()
        if self.todo_list:
            self.todo_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ahead is not None:
            result['ahead'] = self.ahead
        if self.all_requirements_pass is not None:
            result['allRequirementsPass'] = self.all_requirements_pass
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.behind is not None:
            result['behind'] = self.behind
        if self.create_from is not None:
            result['createFrom'] = self.create_from
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url is not None:
            result['detailUrl'] = self.detail_url
        if self.local_id is not None:
            result['localId'] = self.local_id
        if self.mr_biz_id is not None:
            result['mrBizId'] = self.mr_biz_id
        if self.mr_type is not None:
            result['mrType'] = self.mr_type
        if self.project_id is not None:
            result['projectId'] = self.project_id
        result['reviewers'] = []
        if self.reviewers is not None:
            for k in self.reviewers:
                result['reviewers'].append(k.to_map() if k else None)
        if self.source_branch is not None:
            result['sourceBranch'] = self.source_branch
        if self.source_project_id is not None:
            result['sourceProjectId'] = self.source_project_id
        if self.status is not None:
            result['status'] = self.status
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.support_merge_fast_forward_only is not None:
            result['supportMergeFastForwardOnly'] = self.support_merge_fast_forward_only
        if self.target_branch is not None:
            result['targetBranch'] = self.target_branch
        if self.target_project_id is not None:
            result['targetProjectId'] = self.target_project_id
        if self.target_project_name_with_namespace is not None:
            result['targetProjectNameWithNamespace'] = self.target_project_name_with_namespace
        if self.target_project_path_with_namespace is not None:
            result['targetProjectPathWithNamespace'] = self.target_project_path_with_namespace
        if self.title is not None:
            result['title'] = self.title
        if self.todo_list is not None:
            result['todoList'] = self.todo_list.to_map()
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ahead') is not None:
            self.ahead = m.get('ahead')
        if m.get('allRequirementsPass') is not None:
            self.all_requirements_pass = m.get('allRequirementsPass')
        if m.get('author') is not None:
            temp_model = GetMergeRequestResponseBodyResultAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('behind') is not None:
            self.behind = m.get('behind')
        if m.get('createFrom') is not None:
            self.create_from = m.get('createFrom')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            self.detail_url = m.get('detailUrl')
        if m.get('localId') is not None:
            self.local_id = m.get('localId')
        if m.get('mrBizId') is not None:
            self.mr_biz_id = m.get('mrBizId')
        if m.get('mrType') is not None:
            self.mr_type = m.get('mrType')
        if m.get('projectId') is not None:
            self.project_id = m.get('projectId')
        self.reviewers = []
        if m.get('reviewers') is not None:
            for k in m.get('reviewers'):
                temp_model = GetMergeRequestResponseBodyResultReviewers()
                self.reviewers.append(temp_model.from_map(k))
        if m.get('sourceBranch') is not None:
            self.source_branch = m.get('sourceBranch')
        if m.get('sourceProjectId') is not None:
            self.source_project_id = m.get('sourceProjectId')
        if m.get('status') is not None:
            self.status = m.get('status')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = GetMergeRequestResponseBodyResultSubscribers()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('supportMergeFastForwardOnly') is not None:
            self.support_merge_fast_forward_only = m.get('supportMergeFastForwardOnly')
        if m.get('targetBranch') is not None:
            self.target_branch = m.get('targetBranch')
        if m.get('targetProjectId') is not None:
            self.target_project_id = m.get('targetProjectId')
        if m.get('targetProjectNameWithNamespace') is not None:
            self.target_project_name_with_namespace = m.get('targetProjectNameWithNamespace')
        if m.get('targetProjectPathWithNamespace') is not None:
            self.target_project_path_with_namespace = m.get('targetProjectPathWithNamespace')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('todoList') is not None:
            temp_model = GetMergeRequestResponseBodyResultTodoList()
            self.todo_list = temp_model.from_map(m['todoList'])
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class GetMergeRequestResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetMergeRequestResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetMergeRequestResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetMergeRequestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMergeRequestResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMergeRequestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOrganizationMemberResponseBodyMemberIdentities(TeaModel):
    def __init__(
        self,
        extern_uid: str = None,
        provider: str = None,
    ):
        self.extern_uid = extern_uid
        self.provider = provider

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extern_uid is not None:
            result['externUid'] = self.extern_uid
        if self.provider is not None:
            result['provider'] = self.provider
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('externUid') is not None:
            self.extern_uid = m.get('externUid')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        return self


class GetOrganizationMemberResponseBodyMember(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        birthday: int = None,
        dept_lists: List[str] = None,
        email: str = None,
        hired_date: int = None,
        identities: GetOrganizationMemberResponseBodyMemberIdentities = None,
        join_time: int = None,
        last_visit_time: int = None,
        mobile: str = None,
        organization_member_name: str = None,
        organization_role_id: str = None,
        organization_role_name: str = None,
        state: str = None,
    ):
        self.account_id = account_id
        self.birthday = birthday
        self.dept_lists = dept_lists
        self.email = email
        self.hired_date = hired_date
        self.identities = identities
        self.join_time = join_time
        self.last_visit_time = last_visit_time
        self.mobile = mobile
        self.organization_member_name = organization_member_name
        self.organization_role_id = organization_role_id
        self.organization_role_name = organization_role_name
        self.state = state

    def validate(self):
        if self.identities:
            self.identities.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.dept_lists is not None:
            result['deptLists'] = self.dept_lists
        if self.email is not None:
            result['email'] = self.email
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.identities is not None:
            result['identities'] = self.identities.to_map()
        if self.join_time is not None:
            result['joinTime'] = self.join_time
        if self.last_visit_time is not None:
            result['lastVisitTime'] = self.last_visit_time
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.organization_member_name is not None:
            result['organizationMemberName'] = self.organization_member_name
        if self.organization_role_id is not None:
            result['organizationRoleId'] = self.organization_role_id
        if self.organization_role_name is not None:
            result['organizationRoleName'] = self.organization_role_name
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('deptLists') is not None:
            self.dept_lists = m.get('deptLists')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('identities') is not None:
            temp_model = GetOrganizationMemberResponseBodyMemberIdentities()
            self.identities = temp_model.from_map(m['identities'])
        if m.get('joinTime') is not None:
            self.join_time = m.get('joinTime')
        if m.get('lastVisitTime') is not None:
            self.last_visit_time = m.get('lastVisitTime')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('organizationMemberName') is not None:
            self.organization_member_name = m.get('organizationMemberName')
        if m.get('organizationRoleId') is not None:
            self.organization_role_id = m.get('organizationRoleId')
        if m.get('organizationRoleName') is not None:
            self.organization_role_name = m.get('organizationRoleName')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class GetOrganizationMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        member: GetOrganizationMemberResponseBodyMember = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.member = member
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.member:
            self.member.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.member is not None:
            result['member'] = self.member.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('member') is not None:
            temp_model = GetOrganizationMemberResponseBodyMember()
            self.member = temp_model.from_map(m['member'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetOrganizationMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOrganizationMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOrganizationMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineResponseBodyPipelinePipelineConfigSourcesData(TeaModel):
    def __init__(
        self,
        branch: str = None,
        clone_depth: int = None,
        credential_id: int = None,
        credential_label: str = None,
        credential_type: str = None,
        events: List[str] = None,
        is_branch_mode: bool = None,
        is_clone_depth: bool = None,
        is_submodule: bool = None,
        is_trigger: bool = None,
        label: str = None,
        namespace: str = None,
        repo: str = None,
        service_connection_id: int = None,
        trigger_filter: str = None,
        webhook: str = None,
    ):
        self.branch = branch
        self.clone_depth = clone_depth
        # Credential Id
        self.credential_id = credential_id
        # Credential Label
        self.credential_label = credential_label
        # Credential Type
        self.credential_type = credential_type
        self.events = events
        self.is_branch_mode = is_branch_mode
        self.is_clone_depth = is_clone_depth
        self.is_submodule = is_submodule
        self.is_trigger = is_trigger
        self.label = label
        self.namespace = namespace
        self.repo = repo
        self.service_connection_id = service_connection_id
        self.trigger_filter = trigger_filter
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch is not None:
            result['branch'] = self.branch
        if self.clone_depth is not None:
            result['cloneDepth'] = self.clone_depth
        if self.credential_id is not None:
            result['credentialId'] = self.credential_id
        if self.credential_label is not None:
            result['credentialLabel'] = self.credential_label
        if self.credential_type is not None:
            result['credentialType'] = self.credential_type
        if self.events is not None:
            result['events'] = self.events
        if self.is_branch_mode is not None:
            result['isBranchMode'] = self.is_branch_mode
        if self.is_clone_depth is not None:
            result['isCloneDepth'] = self.is_clone_depth
        if self.is_submodule is not None:
            result['isSubmodule'] = self.is_submodule
        if self.is_trigger is not None:
            result['isTrigger'] = self.is_trigger
        if self.label is not None:
            result['label'] = self.label
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.repo is not None:
            result['repo'] = self.repo
        if self.service_connection_id is not None:
            result['serviceConnectionId'] = self.service_connection_id
        if self.trigger_filter is not None:
            result['triggerFilter'] = self.trigger_filter
        if self.webhook is not None:
            result['webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('cloneDepth') is not None:
            self.clone_depth = m.get('cloneDepth')
        if m.get('credentialId') is not None:
            self.credential_id = m.get('credentialId')
        if m.get('credentialLabel') is not None:
            self.credential_label = m.get('credentialLabel')
        if m.get('credentialType') is not None:
            self.credential_type = m.get('credentialType')
        if m.get('events') is not None:
            self.events = m.get('events')
        if m.get('isBranchMode') is not None:
            self.is_branch_mode = m.get('isBranchMode')
        if m.get('isCloneDepth') is not None:
            self.is_clone_depth = m.get('isCloneDepth')
        if m.get('isSubmodule') is not None:
            self.is_submodule = m.get('isSubmodule')
        if m.get('isTrigger') is not None:
            self.is_trigger = m.get('isTrigger')
        if m.get('label') is not None:
            self.label = m.get('label')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('repo') is not None:
            self.repo = m.get('repo')
        if m.get('serviceConnectionId') is not None:
            self.service_connection_id = m.get('serviceConnectionId')
        if m.get('triggerFilter') is not None:
            self.trigger_filter = m.get('triggerFilter')
        if m.get('webhook') is not None:
            self.webhook = m.get('webhook')
        return self


class GetPipelineResponseBodyPipelinePipelineConfigSources(TeaModel):
    def __init__(
        self,
        data: GetPipelineResponseBodyPipelinePipelineConfigSourcesData = None,
        sign: str = None,
        type: str = None,
    ):
        self.data = data
        self.sign = sign
        self.type = type

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.sign is not None:
            result['sign'] = self.sign
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            temp_model = GetPipelineResponseBodyPipelinePipelineConfigSourcesData()
            self.data = temp_model.from_map(m['data'])
        if m.get('sign') is not None:
            self.sign = m.get('sign')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetPipelineResponseBodyPipelinePipelineConfig(TeaModel):
    def __init__(
        self,
        flow: str = None,
        settings: str = None,
        sources: List[GetPipelineResponseBodyPipelinePipelineConfigSources] = None,
    ):
        self.flow = flow
        self.settings = settings
        self.sources = sources

    def validate(self):
        if self.sources:
            for k in self.sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['flow'] = self.flow
        if self.settings is not None:
            result['settings'] = self.settings
        result['sources'] = []
        if self.sources is not None:
            for k in self.sources:
                result['sources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flow') is not None:
            self.flow = m.get('flow')
        if m.get('settings') is not None:
            self.settings = m.get('settings')
        self.sources = []
        if m.get('sources') is not None:
            for k in m.get('sources'):
                temp_model = GetPipelineResponseBodyPipelinePipelineConfigSources()
                self.sources.append(temp_model.from_map(k))
        return self


class GetPipelineResponseBodyPipelineTagList(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        creator_account_id: str = None,
        env_id: int = None,
        env_name: str = None,
        group_id: int = None,
        modifier_account_id: str = None,
        name: str = None,
        pipeline_config: GetPipelineResponseBodyPipelinePipelineConfig = None,
        tag_list: List[GetPipelineResponseBodyPipelineTagList] = None,
        update_time: int = None,
    ):
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.env_id = env_id
        self.env_name = env_name
        self.group_id = group_id
        self.modifier_account_id = modifier_account_id
        self.name = name
        self.pipeline_config = pipeline_config
        self.tag_list = tag_list
        self.update_time = update_time

    def validate(self):
        if self.pipeline_config:
            self.pipeline_config.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.env_id is not None:
            result['envId'] = self.env_id
        if self.env_name is not None:
            result['envName'] = self.env_name
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.name is not None:
            result['name'] = self.name
        if self.pipeline_config is not None:
            result['pipelineConfig'] = self.pipeline_config.to_map()
        result['tagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['tagList'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('envId') is not None:
            self.env_id = m.get('envId')
        if m.get('envName') is not None:
            self.env_name = m.get('envName')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pipelineConfig') is not None:
            temp_model = GetPipelineResponseBodyPipelinePipelineConfig()
            self.pipeline_config = temp_model.from_map(m['pipelineConfig'])
        self.tag_list = []
        if m.get('tagList') is not None:
            for k in m.get('tagList'):
                temp_model = GetPipelineResponseBodyPipelineTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetPipelineResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipeline: GetPipelineResponseBodyPipeline = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipeline = pipeline
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.pipeline is not None:
            result['pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('pipeline') is not None:
            temp_model = GetPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['pipeline'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineArtifactUrlRequest(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        file_path: str = None,
    ):
        self.file_name = file_name
        self.file_path = file_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.file_path is not None:
            result['filePath'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        return self


class GetPipelineArtifactUrlResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        file_url: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.file_url = file_url
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.file_url is not None:
            result['fileUrl'] = self.file_url
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('fileUrl') is not None:
            self.file_url = m.get('fileUrl')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineArtifactUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineArtifactUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineArtifactUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineEmasArtifactUrlRequest(TeaModel):
    def __init__(
        self,
        service_connection_id: int = None,
    ):
        self.service_connection_id = service_connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_connection_id is not None:
            result['serviceConnectionId'] = self.service_connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceConnectionId') is not None:
            self.service_connection_id = m.get('serviceConnectionId')
        return self


class GetPipelineEmasArtifactUrlResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        file_url: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.file_url = file_url
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.file_url is not None:
            result['fileUrl'] = self.file_url
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('fileUrl') is not None:
            self.file_url = m.get('fileUrl')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineEmasArtifactUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineEmasArtifactUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineEmasArtifactUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineGroupResponseBodyPipelineGroup(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        id: int = None,
        name: str = None,
    ):
        self.create_time = create_time
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetPipelineGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipeline_group: GetPipelineGroupResponseBodyPipelineGroup = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipeline_group = pipeline_group
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.pipeline_group:
            self.pipeline_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.pipeline_group is not None:
            result['pipelineGroup'] = self.pipeline_group.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('pipelineGroup') is not None:
            temp_model = GetPipelineGroupResponseBodyPipelineGroup()
            self.pipeline_group = temp_model.from_map(m['pipelineGroup'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineRunResponseBodyPipelineRunSourcesData(TeaModel):
    def __init__(
        self,
        branch: str = None,
        commint: str = None,
        repo: str = None,
    ):
        self.branch = branch
        self.commint = commint
        self.repo = repo

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch is not None:
            result['branch'] = self.branch
        if self.commint is not None:
            result['commint'] = self.commint
        if self.repo is not None:
            result['repo'] = self.repo
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('commint') is not None:
            self.commint = m.get('commint')
        if m.get('repo') is not None:
            self.repo = m.get('repo')
        return self


class GetPipelineRunResponseBodyPipelineRunSources(TeaModel):
    def __init__(
        self,
        data: GetPipelineRunResponseBodyPipelineRunSourcesData = None,
        sign: str = None,
        type: str = None,
    ):
        self.data = data
        self.sign = sign
        self.type = type

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.sign is not None:
            result['sign'] = self.sign
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            temp_model = GetPipelineRunResponseBodyPipelineRunSourcesData()
            self.data = temp_model.from_map(m['data'])
        if m.get('sign') is not None:
            self.sign = m.get('sign')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobsActions(TeaModel):
    def __init__(
        self,
        disable: bool = None,
        params: Dict[str, Any] = None,
        type: str = None,
    ):
        self.disable = disable
        self.params = params
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable is not None:
            result['disable'] = self.disable
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobs(TeaModel):
    def __init__(
        self,
        actions: List[GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobsActions] = None,
        end_time: int = None,
        id: int = None,
        name: str = None,
        params: str = None,
        start_time: int = None,
        status: str = None,
    ):
        self.actions = actions
        self.end_time = end_time
        self.id = id
        self.name = name
        self.params = params
        self.start_time = start_time
        self.status = status

    def validate(self):
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.params is not None:
            result['params'] = self.params
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobsActions()
                self.actions.append(temp_model.from_map(k))
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetPipelineRunResponseBodyPipelineRunStagesStageInfo(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        jobs: List[GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobs] = None,
        name: str = None,
        start_time: int = None,
        status: str = None,
    ):
        self.end_time = end_time
        self.jobs = jobs
        self.name = name
        self.start_time = start_time
        self.status = status

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        result['jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['jobs'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        self.jobs = []
        if m.get('jobs') is not None:
            for k in m.get('jobs'):
                temp_model = GetPipelineRunResponseBodyPipelineRunStagesStageInfoJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetPipelineRunResponseBodyPipelineRunStages(TeaModel):
    def __init__(
        self,
        name: str = None,
        stage_info: GetPipelineRunResponseBodyPipelineRunStagesStageInfo = None,
    ):
        self.name = name
        self.stage_info = stage_info

    def validate(self):
        if self.stage_info:
            self.stage_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.stage_info is not None:
            result['stageInfo'] = self.stage_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('stageInfo') is not None:
            temp_model = GetPipelineRunResponseBodyPipelineRunStagesStageInfo()
            self.stage_info = temp_model.from_map(m['stageInfo'])
        return self


class GetPipelineRunResponseBodyPipelineRun(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        creator_account_id: str = None,
        modifier_account_id: str = None,
        pipeline_id: int = None,
        pipeline_run_id: int = None,
        sources: List[GetPipelineRunResponseBodyPipelineRunSources] = None,
        stage_group: List[List[str]] = None,
        stages: List[GetPipelineRunResponseBodyPipelineRunStages] = None,
        status: str = None,
        trigger_mode: int = None,
        update_time: int = None,
    ):
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.modifier_account_id = modifier_account_id
        self.pipeline_id = pipeline_id
        self.pipeline_run_id = pipeline_run_id
        self.sources = sources
        self.stage_group = stage_group
        self.stages = stages
        self.status = status
        self.trigger_mode = trigger_mode
        self.update_time = update_time

    def validate(self):
        if self.sources:
            for k in self.sources:
                if k:
                    k.validate()
        if self.stages:
            for k in self.stages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.pipeline_id is not None:
            result['pipelineId'] = self.pipeline_id
        if self.pipeline_run_id is not None:
            result['pipelineRunId'] = self.pipeline_run_id
        result['sources'] = []
        if self.sources is not None:
            for k in self.sources:
                result['sources'].append(k.to_map() if k else None)
        if self.stage_group is not None:
            result['stageGroup'] = self.stage_group
        result['stages'] = []
        if self.stages is not None:
            for k in self.stages:
                result['stages'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.trigger_mode is not None:
            result['triggerMode'] = self.trigger_mode
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('pipelineId') is not None:
            self.pipeline_id = m.get('pipelineId')
        if m.get('pipelineRunId') is not None:
            self.pipeline_run_id = m.get('pipelineRunId')
        self.sources = []
        if m.get('sources') is not None:
            for k in m.get('sources'):
                temp_model = GetPipelineRunResponseBodyPipelineRunSources()
                self.sources.append(temp_model.from_map(k))
        if m.get('stageGroup') is not None:
            self.stage_group = m.get('stageGroup')
        self.stages = []
        if m.get('stages') is not None:
            for k in m.get('stages'):
                temp_model = GetPipelineRunResponseBodyPipelineRunStages()
                self.stages.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('triggerMode') is not None:
            self.trigger_mode = m.get('triggerMode')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetPipelineRunResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipeline_run: GetPipelineRunResponseBodyPipelineRun = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipeline_run = pipeline_run
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.pipeline_run:
            self.pipeline_run.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.pipeline_run is not None:
            result['pipelineRun'] = self.pipeline_run.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('pipelineRun') is not None:
            temp_model = GetPipelineRunResponseBodyPipelineRun()
            self.pipeline_run = temp_model.from_map(m['pipelineRun'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineRunResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineRunResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineRunResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineScanReportUrlRequest(TeaModel):
    def __init__(
        self,
        report_path: str = None,
    ):
        self.report_path = report_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_path is not None:
            result['reportPath'] = self.report_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('reportPath') is not None:
            self.report_path = m.get('reportPath')
        return self


class GetPipelineScanReportUrlResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        report_url: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.report_url = report_url
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.report_url is not None:
            result['reportUrl'] = self.report_url
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('reportUrl') is not None:
            self.report_url = m.get('reportUrl')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPipelineScanReportUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineScanReportUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineScanReportUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectInfoResponseBodyProject(TeaModel):
    def __init__(
        self,
        category: str = None,
        category_identifier: str = None,
        creator: str = None,
        custom_code: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        icon: str = None,
        icon_big: str = None,
        icon_group: str = None,
        icon_small: str = None,
        id: str = None,
        identifier: str = None,
        identifier_path: str = None,
        logical_status: str = None,
        modifier: str = None,
        name: str = None,
        organization_identifier: str = None,
        parent_identifier: str = None,
        scope: str = None,
        status_identifier: str = None,
        status_stage_identifier: str = None,
        sub_type: str = None,
        type_identifier: str = None,
    ):
        self.category = category
        self.category_identifier = category_identifier
        self.creator = creator
        self.custom_code = custom_code
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.icon = icon
        self.icon_big = icon_big
        self.icon_group = icon_group
        self.icon_small = icon_small
        self.id = id
        self.identifier = identifier
        self.identifier_path = identifier_path
        self.logical_status = logical_status
        self.modifier = modifier
        self.name = name
        self.organization_identifier = organization_identifier
        self.parent_identifier = parent_identifier
        self.scope = scope
        self.status_identifier = status_identifier
        self.status_stage_identifier = status_stage_identifier
        self.sub_type = sub_type
        self.type_identifier = type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.icon is not None:
            result['icon'] = self.icon
        if self.icon_big is not None:
            result['iconBig'] = self.icon_big
        if self.icon_group is not None:
            result['iconGroup'] = self.icon_group
        if self.icon_small is not None:
            result['iconSmall'] = self.icon_small
        if self.id is not None:
            result['id'] = self.id
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.identifier_path is not None:
            result['identifierPath'] = self.identifier_path
        if self.logical_status is not None:
            result['logicalStatus'] = self.logical_status
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.organization_identifier is not None:
            result['organizationIdentifier'] = self.organization_identifier
        if self.parent_identifier is not None:
            result['parentIdentifier'] = self.parent_identifier
        if self.scope is not None:
            result['scope'] = self.scope
        if self.status_identifier is not None:
            result['statusIdentifier'] = self.status_identifier
        if self.status_stage_identifier is not None:
            result['statusStageIdentifier'] = self.status_stage_identifier
        if self.sub_type is not None:
            result['subType'] = self.sub_type
        if self.type_identifier is not None:
            result['typeIdentifier'] = self.type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('iconBig') is not None:
            self.icon_big = m.get('iconBig')
        if m.get('iconGroup') is not None:
            self.icon_group = m.get('iconGroup')
        if m.get('iconSmall') is not None:
            self.icon_small = m.get('iconSmall')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('identifierPath') is not None:
            self.identifier_path = m.get('identifierPath')
        if m.get('logicalStatus') is not None:
            self.logical_status = m.get('logicalStatus')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organizationIdentifier') is not None:
            self.organization_identifier = m.get('organizationIdentifier')
        if m.get('parentIdentifier') is not None:
            self.parent_identifier = m.get('parentIdentifier')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('statusIdentifier') is not None:
            self.status_identifier = m.get('statusIdentifier')
        if m.get('statusStageIdentifier') is not None:
            self.status_stage_identifier = m.get('statusStageIdentifier')
        if m.get('subType') is not None:
            self.sub_type = m.get('subType')
        if m.get('typeIdentifier') is not None:
            self.type_identifier = m.get('typeIdentifier')
        return self


class GetProjectInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        project: GetProjectInfoResponseBodyProject = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.project = project
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.project is not None:
            result['project'] = self.project.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('project') is not None:
            temp_model = GetProjectInfoResponseBodyProject()
            self.project = temp_model.from_map(m['project'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetProjectInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetProjectInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetProjectInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetProjectMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        avatar_url: str = None,
        id: int = None,
        name: str = None,
    ):
        self.access_level = access_level
        self.avatar_url = avatar_url
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetProjectMemberResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetProjectMemberResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPushRuleRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetPushRuleResponseBodyResultRuleInfos(TeaModel):
    def __init__(
        self,
        checker_name: str = None,
        checker_type: str = None,
        extra_message: str = None,
        file_rule_regexes: List[str] = None,
    ):
        self.checker_name = checker_name
        self.checker_type = checker_type
        self.extra_message = extra_message
        self.file_rule_regexes = file_rule_regexes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_name is not None:
            result['checkerName'] = self.checker_name
        if self.checker_type is not None:
            result['checkerType'] = self.checker_type
        if self.extra_message is not None:
            result['extraMessage'] = self.extra_message
        if self.file_rule_regexes is not None:
            result['fileRuleRegexes'] = self.file_rule_regexes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkerName') is not None:
            self.checker_name = m.get('checkerName')
        if m.get('checkerType') is not None:
            self.checker_type = m.get('checkerType')
        if m.get('extraMessage') is not None:
            self.extra_message = m.get('extraMessage')
        if m.get('fileRuleRegexes') is not None:
            self.file_rule_regexes = m.get('fileRuleRegexes')
        return self


class GetPushRuleResponseBodyResult(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        rule_infos: List[GetPushRuleResponseBodyResultRuleInfos] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.rule_infos = rule_infos

    def validate(self):
        if self.rule_infos:
            for k in self.rule_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['ruleInfos'] = []
        if self.rule_infos is not None:
            for k in self.rule_infos:
                result['ruleInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.rule_infos = []
        if m.get('ruleInfos') is not None:
            for k in m.get('ruleInfos'):
                temp_model = GetPushRuleResponseBodyResultRuleInfos()
                self.rule_infos.append(temp_model.from_map(k))
        return self


class GetPushRuleResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetPushRuleResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetPushRuleResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPushRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPushRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPushRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRepositoryRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        identity: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.identity = identity
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.identity is not None:
            result['identity'] = self.identity
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('identity') is not None:
            self.identity = m.get('identity')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetRepositoryResponseBodyRepositoryNamespace(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        created_at: str = None,
        description: str = None,
        id: int = None,
        name: str = None,
        owner_id: int = None,
        path: str = None,
        updated_at: str = None,
        visibility_level: int = None,
    ):
        self.avatar = avatar
        self.created_at = created_at
        self.description = description
        # id
        self.id = id
        self.name = name
        self.owner_id = owner_id
        self.path = path
        self.updated_at = updated_at
        self.visibility_level = visibility_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.path is not None:
            result['path'] = self.path
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        return self


class GetRepositoryResponseBodyRepository(TeaModel):
    def __init__(
        self,
        archive: bool = None,
        avatar_url: str = None,
        created_at: str = None,
        creator_id: int = None,
        default_branch: str = None,
        demo_project_status: bool = None,
        description: str = None,
        http_url_to_repository: str = None,
        id: int = None,
        last_activity_at: str = None,
        name: str = None,
        name_with_namespace: str = None,
        namespace: GetRepositoryResponseBodyRepositoryNamespace = None,
        path: str = None,
        path_with_namespace: str = None,
        ssh_url_to_repository: str = None,
        visibility_level: int = None,
        web_url: str = None,
    ):
        self.archive = archive
        self.avatar_url = avatar_url
        self.created_at = created_at
        self.creator_id = creator_id
        self.default_branch = default_branch
        self.demo_project_status = demo_project_status
        self.description = description
        self.http_url_to_repository = http_url_to_repository
        self.id = id
        self.last_activity_at = last_activity_at
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.namespace = namespace
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.ssh_url_to_repository = ssh_url_to_repository
        self.visibility_level = visibility_level
        self.web_url = web_url

    def validate(self):
        if self.namespace:
            self.namespace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archive is not None:
            result['archive'] = self.archive
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.default_branch is not None:
            result['defaultBranch'] = self.default_branch
        if self.demo_project_status is not None:
            result['demoProjectStatus'] = self.demo_project_status
        if self.description is not None:
            result['description'] = self.description
        if self.http_url_to_repository is not None:
            result['httpUrlToRepository'] = self.http_url_to_repository
        if self.id is not None:
            result['id'] = self.id
        if self.last_activity_at is not None:
            result['lastActivityAt'] = self.last_activity_at
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.namespace is not None:
            result['namespace'] = self.namespace.to_map()
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.ssh_url_to_repository is not None:
            result['sshUrlToRepository'] = self.ssh_url_to_repository
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('archive') is not None:
            self.archive = m.get('archive')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('defaultBranch') is not None:
            self.default_branch = m.get('defaultBranch')
        if m.get('demoProjectStatus') is not None:
            self.demo_project_status = m.get('demoProjectStatus')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('httpUrlToRepository') is not None:
            self.http_url_to_repository = m.get('httpUrlToRepository')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('lastActivityAt') is not None:
            self.last_activity_at = m.get('lastActivityAt')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('namespace') is not None:
            temp_model = GetRepositoryResponseBodyRepositoryNamespace()
            self.namespace = temp_model.from_map(m['namespace'])
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('sshUrlToRepository') is not None:
            self.ssh_url_to_repository = m.get('sshUrlToRepository')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class GetRepositoryResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        repository: GetRepositoryResponseBodyRepository = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.repository = repository
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.repository:
            self.repository.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.repository is not None:
            result['repository'] = self.repository.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('repository') is not None:
            temp_model = GetRepositoryResponseBodyRepository()
            self.repository = temp_model.from_map(m['repository'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetRepositoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRepositoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRepositoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRepositoryCommitRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
        show_signature: bool = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id
        self.show_signature = show_signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.show_signature is not None:
            result['showSignature'] = self.show_signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('showSignature') is not None:
            self.show_signature = m.get('showSignature')
        return self


class GetRepositoryCommitResponseBodyResultAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
        website_url: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username
        self.website_url = website_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        if self.website_url is not None:
            result['websiteUrl'] = self.website_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('websiteUrl') is not None:
            self.website_url = m.get('websiteUrl')
        return self


class GetRepositoryCommitResponseBodyResultCommitter(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
        website_url: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username
        self.website_url = website_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        if self.website_url is not None:
            result['websiteUrl'] = self.website_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('websiteUrl') is not None:
            self.website_url = m.get('websiteUrl')
        return self


class GetRepositoryCommitResponseBodyResultSignature(TeaModel):
    def __init__(
        self,
        gpg_key_id: str = None,
        verification_status: str = None,
    ):
        self.gpg_key_id = gpg_key_id
        self.verification_status = verification_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gpg_key_id is not None:
            result['gpgKeyId'] = self.gpg_key_id
        if self.verification_status is not None:
            result['verificationStatus'] = self.verification_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gpgKeyId') is not None:
            self.gpg_key_id = m.get('gpgKeyId')
        if m.get('verificationStatus') is not None:
            self.verification_status = m.get('verificationStatus')
        return self


class GetRepositoryCommitResponseBodyResult(TeaModel):
    def __init__(
        self,
        author: GetRepositoryCommitResponseBodyResultAuthor = None,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        comments_count: int = None,
        committed_date: str = None,
        committer: GetRepositoryCommitResponseBodyResultCommitter = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        signature: GetRepositoryCommitResponseBodyResultSignature = None,
        title: str = None,
    ):
        self.author = author
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.comments_count = comments_count
        self.committed_date = committed_date
        self.committer = committer
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.signature = signature
        self.title = title

    def validate(self):
        if self.author:
            self.author.validate()
        if self.committer:
            self.committer.validate()
        if self.signature:
            self.signature.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.comments_count is not None:
            result['commentsCount'] = self.comments_count
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer is not None:
            result['committer'] = self.committer.to_map()
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            temp_model = GetRepositoryCommitResponseBodyResultAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('commentsCount') is not None:
            self.comments_count = m.get('commentsCount')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committer') is not None:
            temp_model = GetRepositoryCommitResponseBodyResultCommitter()
            self.committer = temp_model.from_map(m['committer'])
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('signature') is not None:
            temp_model = GetRepositoryCommitResponseBodyResultSignature()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetRepositoryCommitResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetRepositoryCommitResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetRepositoryCommitResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetRepositoryCommitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRepositoryCommitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRepositoryCommitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRepositoryTagRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
        tag_name: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.tag_name is not None:
            result['tagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('tagName') is not None:
            self.tag_name = m.get('tagName')
        return self


class GetRepositoryTagResponseBodyResultCommitSignature(TeaModel):
    def __init__(
        self,
        gpg_key_id: str = None,
        verification_status: str = None,
    ):
        self.gpg_key_id = gpg_key_id
        self.verification_status = verification_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gpg_key_id is not None:
            result['gpgKeyId'] = self.gpg_key_id
        if self.verification_status is not None:
            result['verificationStatus'] = self.verification_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gpgKeyId') is not None:
            self.gpg_key_id = m.get('gpgKeyId')
        if m.get('verificationStatus') is not None:
            self.verification_status = m.get('verificationStatus')
        return self


class GetRepositoryTagResponseBodyResultCommit(TeaModel):
    def __init__(
        self,
        author_email: str = None,
        author_name: str = None,
        authored_date: str = None,
        committed_date: str = None,
        committer_email: str = None,
        committer_name: str = None,
        created_at: str = None,
        id: str = None,
        message: str = None,
        parent_ids: List[str] = None,
        short_id: str = None,
        signature: GetRepositoryTagResponseBodyResultCommitSignature = None,
        title: str = None,
    ):
        self.author_email = author_email
        self.author_name = author_name
        self.authored_date = authored_date
        self.committed_date = committed_date
        self.committer_email = committer_email
        self.committer_name = committer_name
        self.created_at = created_at
        self.id = id
        self.message = message
        self.parent_ids = parent_ids
        self.short_id = short_id
        self.signature = signature
        self.title = title

    def validate(self):
        if self.signature:
            self.signature.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author_email is not None:
            result['authorEmail'] = self.author_email
        if self.author_name is not None:
            result['authorName'] = self.author_name
        if self.authored_date is not None:
            result['authoredDate'] = self.authored_date
        if self.committed_date is not None:
            result['committedDate'] = self.committed_date
        if self.committer_email is not None:
            result['committerEmail'] = self.committer_email
        if self.committer_name is not None:
            result['committerName'] = self.committer_name
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.parent_ids is not None:
            result['parentIds'] = self.parent_ids
        if self.short_id is not None:
            result['shortId'] = self.short_id
        if self.signature is not None:
            result['signature'] = self.signature.to_map()
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authorEmail') is not None:
            self.author_email = m.get('authorEmail')
        if m.get('authorName') is not None:
            self.author_name = m.get('authorName')
        if m.get('authoredDate') is not None:
            self.authored_date = m.get('authoredDate')
        if m.get('committedDate') is not None:
            self.committed_date = m.get('committedDate')
        if m.get('committerEmail') is not None:
            self.committer_email = m.get('committerEmail')
        if m.get('committerName') is not None:
            self.committer_name = m.get('committerName')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('parentIds') is not None:
            self.parent_ids = m.get('parentIds')
        if m.get('shortId') is not None:
            self.short_id = m.get('shortId')
        if m.get('signature') is not None:
            temp_model = GetRepositoryTagResponseBodyResultCommitSignature()
            self.signature = temp_model.from_map(m['signature'])
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetRepositoryTagResponseBodyResult(TeaModel):
    def __init__(
        self,
        commit: GetRepositoryTagResponseBodyResultCommit = None,
        id: str = None,
        message: str = None,
        name: str = None,
    ):
        self.commit = commit
        self.id = id
        self.message = message
        self.name = name

    def validate(self):
        if self.commit:
            self.commit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit is not None:
            result['commit'] = self.commit.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.message is not None:
            result['message'] = self.message
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commit') is not None:
            temp_model = GetRepositoryTagResponseBodyResultCommit()
            self.commit = temp_model.from_map(m['commit'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetRepositoryTagResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetRepositoryTagResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetRepositoryTagResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetRepositoryTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRepositoryTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRepositoryTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSearchCodePreviewRequest(TeaModel):
    def __init__(
        self,
        doc_id: str = None,
        is_dsl: bool = None,
        keyword: str = None,
        organization_id: str = None,
    ):
        self.doc_id = doc_id
        self.is_dsl = is_dsl
        self.keyword = keyword
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_id is not None:
            result['docId'] = self.doc_id
        if self.is_dsl is not None:
            result['isDsl'] = self.is_dsl
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('docId') is not None:
            self.doc_id = m.get('docId')
        if m.get('isDsl') is not None:
            self.is_dsl = m.get('isDsl')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetSearchCodePreviewResponseBodyResultHighlightTextMap(TeaModel):
    def __init__(
        self,
        clob: str = None,
        file_name: str = None,
        organization_id: str = None,
    ):
        self.clob = clob
        self.file_name = file_name
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clob is not None:
            result['clob'] = self.clob
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clob') is not None:
            self.clob = m.get('clob')
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetSearchCodePreviewResponseBodyResultSource(TeaModel):
    def __init__(
        self,
        branch: str = None,
        checkin_date: str = None,
        file_name: str = None,
        file_path: str = None,
        language: str = None,
        organization_id: str = None,
        repo_path: str = None,
    ):
        self.branch = branch
        self.checkin_date = checkin_date
        self.file_name = file_name
        self.file_path = file_path
        self.language = language
        self.organization_id = organization_id
        self.repo_path = repo_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch is not None:
            result['branch'] = self.branch
        if self.checkin_date is not None:
            result['checkinDate'] = self.checkin_date
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.language is not None:
            result['language'] = self.language
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.repo_path is not None:
            result['repoPath'] = self.repo_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('checkinDate') is not None:
            self.checkin_date = m.get('checkinDate')
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('language') is not None:
            self.language = m.get('language')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('repoPath') is not None:
            self.repo_path = m.get('repoPath')
        return self


class GetSearchCodePreviewResponseBodyResult(TeaModel):
    def __init__(
        self,
        doc_id: str = None,
        highlight_text_map: GetSearchCodePreviewResponseBodyResultHighlightTextMap = None,
        source: GetSearchCodePreviewResponseBodyResultSource = None,
    ):
        self.doc_id = doc_id
        self.highlight_text_map = highlight_text_map
        self.source = source

    def validate(self):
        if self.highlight_text_map:
            self.highlight_text_map.validate()
        if self.source:
            self.source.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_id is not None:
            result['docId'] = self.doc_id
        if self.highlight_text_map is not None:
            result['highlightTextMap'] = self.highlight_text_map.to_map()
        if self.source is not None:
            result['source'] = self.source.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('docId') is not None:
            self.doc_id = m.get('docId')
        if m.get('highlightTextMap') is not None:
            temp_model = GetSearchCodePreviewResponseBodyResultHighlightTextMap()
            self.highlight_text_map = temp_model.from_map(m['highlightTextMap'])
        if m.get('source') is not None:
            temp_model = GetSearchCodePreviewResponseBodyResultSource()
            self.source = temp_model.from_map(m['source'])
        return self


class GetSearchCodePreviewResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetSearchCodePreviewResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetSearchCodePreviewResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetSearchCodePreviewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSearchCodePreviewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSearchCodePreviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSprintInfoResponseBodySprint(TeaModel):
    def __init__(
        self,
        creator: str = None,
        description: str = None,
        end_date: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        modifier: str = None,
        name: str = None,
        owners: List[str] = None,
        scope: str = None,
        space_identifier: str = None,
        start_date: int = None,
        status: str = None,
    ):
        self.creator = creator
        self.description = description
        self.end_date = end_date
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.modifier = modifier
        self.name = name
        self.owners = owners
        self.scope = scope
        self.space_identifier = space_identifier
        self.start_date = start_date
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.owners is not None:
            result['owners'] = self.owners
        if self.scope is not None:
            result['scope'] = self.scope
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.start_date is not None:
            result['startDate'] = self.start_date
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('owners') is not None:
            self.owners = m.get('owners')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetSprintInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        sprint: GetSprintInfoResponseBodySprint = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.sprint = sprint
        self.success = success

    def validate(self):
        if self.sprint:
            self.sprint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.sprint is not None:
            result['sprint'] = self.sprint.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('sprint') is not None:
            temp_model = GetSprintInfoResponseBodySprint()
            self.sprint = temp_model.from_map(m['sprint'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetSprintInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSprintInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSprintInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTestResultListRequest(TeaModel):
    def __init__(
        self,
        conditions: str = None,
        directory_identifier: str = None,
    ):
        self.conditions = conditions
        self.directory_identifier = directory_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditions is not None:
            result['conditions'] = self.conditions
        if self.directory_identifier is not None:
            result['directoryIdentifier'] = self.directory_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditions') is not None:
            self.conditions = m.get('conditions')
        if m.get('directoryIdentifier') is not None:
            self.directory_identifier = m.get('directoryIdentifier')
        return self


class GetTestResultListResponseBodyTestResultAssignedTo(TeaModel):
    def __init__(
        self,
        assigned_to_identtifier: str = None,
        name: str = None,
    ):
        self.assigned_to_identtifier = assigned_to_identtifier
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to_identtifier is not None:
            result['assignedToIdenttifier'] = self.assigned_to_identtifier
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedToIdenttifier') is not None:
            self.assigned_to_identtifier = m.get('assignedToIdenttifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetTestResultListResponseBodyTestResultCustomFields(TeaModel):
    def __init__(
        self,
        field_class_name: str = None,
        field_format: str = None,
        field_identifier: str = None,
        value: str = None,
    ):
        self.field_class_name = field_class_name
        self.field_format = field_format
        self.field_identifier = field_identifier
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_class_name is not None:
            result['fieldClassName'] = self.field_class_name
        if self.field_format is not None:
            result['fieldFormat'] = self.field_format
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldClassName') is not None:
            self.field_class_name = m.get('fieldClassName')
        if m.get('fieldFormat') is not None:
            self.field_format = m.get('fieldFormat')
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class GetTestResultListResponseBodyTestResultTestResultExecutor(TeaModel):
    def __init__(
        self,
        executor_identifier: str = None,
        name: str = None,
    ):
        self.executor_identifier = executor_identifier
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.executor_identifier is not None:
            result['executorIdentifier'] = self.executor_identifier
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executorIdentifier') is not None:
            self.executor_identifier = m.get('executorIdentifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetTestResultListResponseBodyTestResult(TeaModel):
    def __init__(
        self,
        assigned_to: GetTestResultListResponseBodyTestResultAssignedTo = None,
        bug_count: int = None,
        category_identifier: str = None,
        custom_fields: List[GetTestResultListResponseBodyTestResultCustomFields] = None,
        gmt_create: int = None,
        space_identifier: str = None,
        subject: str = None,
        test_result_executor: GetTestResultListResponseBodyTestResultTestResultExecutor = None,
        test_result_gmt_create: int = None,
        test_result_identifier: str = None,
        test_result_status: str = None,
        testcase_identifier: str = None,
    ):
        self.assigned_to = assigned_to
        self.bug_count = bug_count
        self.category_identifier = category_identifier
        self.custom_fields = custom_fields
        self.gmt_create = gmt_create
        self.space_identifier = space_identifier
        self.subject = subject
        self.test_result_executor = test_result_executor
        self.test_result_gmt_create = test_result_gmt_create
        self.test_result_identifier = test_result_identifier
        self.test_result_status = test_result_status
        self.testcase_identifier = testcase_identifier

    def validate(self):
        if self.assigned_to:
            self.assigned_to.validate()
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()
        if self.test_result_executor:
            self.test_result_executor.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to.to_map()
        if self.bug_count is not None:
            result['bugCount'] = self.bug_count
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        result['customFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['customFields'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.test_result_executor is not None:
            result['testResultExecutor'] = self.test_result_executor.to_map()
        if self.test_result_gmt_create is not None:
            result['testResultGmtCreate'] = self.test_result_gmt_create
        if self.test_result_identifier is not None:
            result['testResultIdentifier'] = self.test_result_identifier
        if self.test_result_status is not None:
            result['testResultStatus'] = self.test_result_status
        if self.testcase_identifier is not None:
            result['testcaseIdentifier'] = self.testcase_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            temp_model = GetTestResultListResponseBodyTestResultAssignedTo()
            self.assigned_to = temp_model.from_map(m['assignedTo'])
        if m.get('bugCount') is not None:
            self.bug_count = m.get('bugCount')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        self.custom_fields = []
        if m.get('customFields') is not None:
            for k in m.get('customFields'):
                temp_model = GetTestResultListResponseBodyTestResultCustomFields()
                self.custom_fields.append(temp_model.from_map(k))
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('testResultExecutor') is not None:
            temp_model = GetTestResultListResponseBodyTestResultTestResultExecutor()
            self.test_result_executor = temp_model.from_map(m['testResultExecutor'])
        if m.get('testResultGmtCreate') is not None:
            self.test_result_gmt_create = m.get('testResultGmtCreate')
        if m.get('testResultIdentifier') is not None:
            self.test_result_identifier = m.get('testResultIdentifier')
        if m.get('testResultStatus') is not None:
            self.test_result_status = m.get('testResultStatus')
        if m.get('testcaseIdentifier') is not None:
            self.testcase_identifier = m.get('testcaseIdentifier')
        return self


class GetTestResultListResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
        test_result: List[GetTestResultListResponseBodyTestResult] = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.success = success
        self.test_result = test_result

    def validate(self):
        if self.test_result:
            for k in self.test_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        result['testResult'] = []
        if self.test_result is not None:
            for k in self.test_result:
                result['testResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.test_result = []
        if m.get('testResult') is not None:
            for k in m.get('testResult'):
                temp_model = GetTestResultListResponseBodyTestResult()
                self.test_result.append(temp_model.from_map(k))
        return self


class GetTestResultListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTestResultListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTestResultListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTestcaseListRequest(TeaModel):
    def __init__(
        self,
        conditions: str = None,
        directory_identifier: str = None,
        max_result: str = None,
        next_token: str = None,
        space_identifier: str = None,
    ):
        self.conditions = conditions
        self.directory_identifier = directory_identifier
        self.max_result = max_result
        self.next_token = next_token
        self.space_identifier = space_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditions is not None:
            result['conditions'] = self.conditions
        if self.directory_identifier is not None:
            result['directoryIdentifier'] = self.directory_identifier
        if self.max_result is not None:
            result['maxResult'] = self.max_result
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditions') is not None:
            self.conditions = m.get('conditions')
        if m.get('directoryIdentifier') is not None:
            self.directory_identifier = m.get('directoryIdentifier')
        if m.get('maxResult') is not None:
            self.max_result = m.get('maxResult')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        return self


class GetTestcaseListResponseBodyTestcaseAssignedTo(TeaModel):
    def __init__(
        self,
        assigned_to_identtifier: str = None,
        name: str = None,
    ):
        self.assigned_to_identtifier = assigned_to_identtifier
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to_identtifier is not None:
            result['assignedToIdenttifier'] = self.assigned_to_identtifier
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedToIdenttifier') is not None:
            self.assigned_to_identtifier = m.get('assignedToIdenttifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetTestcaseListResponseBodyTestcaseCustomFields(TeaModel):
    def __init__(
        self,
        field_class_name: str = None,
        field_format: str = None,
        field_identifier: str = None,
        value: str = None,
    ):
        self.field_class_name = field_class_name
        self.field_format = field_format
        self.field_identifier = field_identifier
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_class_name is not None:
            result['fieldClassName'] = self.field_class_name
        if self.field_format is not None:
            result['fieldFormat'] = self.field_format
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldClassName') is not None:
            self.field_class_name = m.get('fieldClassName')
        if m.get('fieldFormat') is not None:
            self.field_format = m.get('fieldFormat')
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class GetTestcaseListResponseBodyTestcaseSpace(TeaModel):
    def __init__(
        self,
        space_identifier: str = None,
        type: str = None,
    ):
        self.space_identifier = space_identifier
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetTestcaseListResponseBodyTestcaseTags(TeaModel):
    def __init__(
        self,
        name: str = None,
        tag_identifier: str = None,
    ):
        self.name = name
        self.tag_identifier = tag_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.tag_identifier is not None:
            result['tagIdentifier'] = self.tag_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('tagIdentifier') is not None:
            self.tag_identifier = m.get('tagIdentifier')
        return self


class GetTestcaseListResponseBodyTestcase(TeaModel):
    def __init__(
        self,
        assigned_to: GetTestcaseListResponseBodyTestcaseAssignedTo = None,
        category_identifier: str = None,
        custom_fields: List[GetTestcaseListResponseBodyTestcaseCustomFields] = None,
        gmt_create: int = None,
        identifier: str = None,
        space: GetTestcaseListResponseBodyTestcaseSpace = None,
        subject: str = None,
        tags: List[GetTestcaseListResponseBodyTestcaseTags] = None,
    ):
        self.assigned_to = assigned_to
        self.category_identifier = category_identifier
        self.custom_fields = custom_fields
        self.gmt_create = gmt_create
        self.identifier = identifier
        self.space = space
        self.subject = subject
        self.tags = tags

    def validate(self):
        if self.assigned_to:
            self.assigned_to.validate()
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()
        if self.space:
            self.space.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to.to_map()
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        result['customFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['customFields'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.space is not None:
            result['space'] = self.space.to_map()
        if self.subject is not None:
            result['subject'] = self.subject
        result['tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            temp_model = GetTestcaseListResponseBodyTestcaseAssignedTo()
            self.assigned_to = temp_model.from_map(m['assignedTo'])
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        self.custom_fields = []
        if m.get('customFields') is not None:
            for k in m.get('customFields'):
                temp_model = GetTestcaseListResponseBodyTestcaseCustomFields()
                self.custom_fields.append(temp_model.from_map(k))
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('space') is not None:
            temp_model = GetTestcaseListResponseBodyTestcaseSpace()
            self.space = temp_model.from_map(m['space'])
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        self.tags = []
        if m.get('tags') is not None:
            for k in m.get('tags'):
                temp_model = GetTestcaseListResponseBodyTestcaseTags()
                self.tags.append(temp_model.from_map(k))
        return self


class GetTestcaseListResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        testcase: List[GetTestcaseListResponseBodyTestcase] = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.max_results = max_results
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.testcase = testcase
        self.total_count = total_count

    def validate(self):
        if self.testcase:
            for k in self.testcase:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        result['testcase'] = []
        if self.testcase is not None:
            for k in self.testcase:
                result['testcase'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.testcase = []
        if m.get('testcase') is not None:
            for k in m.get('testcase'):
                temp_model = GetTestcaseListResponseBodyTestcase()
                self.testcase.append(temp_model.from_map(k))
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class GetTestcaseListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTestcaseListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTestcaseListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserInfoRequest(TeaModel):
    def __init__(
        self,
        organization_id: str = None,
    ):
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class GetUserInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class GetUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: GetUserInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            temp_model = GetUserInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVMDeployOrderResponseBodyDeployOrderActions(TeaModel):
    def __init__(
        self,
        disable: bool = None,
        params: Any = None,
        type: str = None,
    ):
        self.disable = disable
        self.params = params
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable is not None:
            result['disable'] = self.disable
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachinesActions(TeaModel):
    def __init__(
        self,
        disable: bool = None,
        params: Any = None,
        type: str = None,
    ):
        self.disable = disable
        self.params = params
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable is not None:
            result['disable'] = self.disable
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachines(TeaModel):
    def __init__(
        self,
        actions: List[GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachinesActions] = None,
        batch_num: int = None,
        client_status: str = None,
        create_time: int = None,
        ip: str = None,
        machine_sn: str = None,
        status: str = None,
        update_time: int = None,
    ):
        self.actions = actions
        self.batch_num = batch_num
        self.client_status = client_status
        self.create_time = create_time
        self.ip = ip
        self.machine_sn = machine_sn
        self.status = status
        self.update_time = update_time

    def validate(self):
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        if self.batch_num is not None:
            result['batchNum'] = self.batch_num
        if self.client_status is not None:
            result['clientStatus'] = self.client_status
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.ip is not None:
            result['ip'] = self.ip
        if self.machine_sn is not None:
            result['machineSn'] = self.machine_sn
        if self.status is not None:
            result['status'] = self.status
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachinesActions()
                self.actions.append(temp_model.from_map(k))
        if m.get('batchNum') is not None:
            self.batch_num = m.get('batchNum')
        if m.get('clientStatus') is not None:
            self.client_status = m.get('clientStatus')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('machineSn') is not None:
            self.machine_sn = m.get('machineSn')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfo(TeaModel):
    def __init__(
        self,
        batch_num: int = None,
        deploy_machines: List[GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachines] = None,
        host_group_id: int = None,
    ):
        self.batch_num = batch_num
        self.deploy_machines = deploy_machines
        self.host_group_id = host_group_id

    def validate(self):
        if self.deploy_machines:
            for k in self.deploy_machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_num is not None:
            result['batchNum'] = self.batch_num
        result['deployMachines'] = []
        if self.deploy_machines is not None:
            for k in self.deploy_machines:
                result['deployMachines'].append(k.to_map() if k else None)
        if self.host_group_id is not None:
            result['hostGroupId'] = self.host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('batchNum') is not None:
            self.batch_num = m.get('batchNum')
        self.deploy_machines = []
        if m.get('deployMachines') is not None:
            for k in m.get('deployMachines'):
                temp_model = GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfoDeployMachines()
                self.deploy_machines.append(temp_model.from_map(k))
        if m.get('hostGroupId') is not None:
            self.host_group_id = m.get('hostGroupId')
        return self


class GetVMDeployOrderResponseBodyDeployOrder(TeaModel):
    def __init__(
        self,
        actions: List[GetVMDeployOrderResponseBodyDeployOrderActions] = None,
        create_time: int = None,
        creator: str = None,
        current_batch: int = None,
        deploy_machine_info: GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfo = None,
        deploy_order_id: str = None,
        exception_code: str = None,
        status: str = None,
        total_batch: int = None,
        update_time: int = None,
    ):
        self.actions = actions
        self.create_time = create_time
        self.creator = creator
        self.current_batch = current_batch
        self.deploy_machine_info = deploy_machine_info
        self.deploy_order_id = deploy_order_id
        self.exception_code = exception_code
        self.status = status
        self.total_batch = total_batch
        self.update_time = update_time

    def validate(self):
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()
        if self.deploy_machine_info:
            self.deploy_machine_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator is not None:
            result['creator'] = self.creator
        if self.current_batch is not None:
            result['currentBatch'] = self.current_batch
        if self.deploy_machine_info is not None:
            result['deployMachineInfo'] = self.deploy_machine_info.to_map()
        if self.deploy_order_id is not None:
            result['deployOrderId'] = self.deploy_order_id
        if self.exception_code is not None:
            result['exceptionCode'] = self.exception_code
        if self.status is not None:
            result['status'] = self.status
        if self.total_batch is not None:
            result['totalBatch'] = self.total_batch
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = GetVMDeployOrderResponseBodyDeployOrderActions()
                self.actions.append(temp_model.from_map(k))
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('currentBatch') is not None:
            self.current_batch = m.get('currentBatch')
        if m.get('deployMachineInfo') is not None:
            temp_model = GetVMDeployOrderResponseBodyDeployOrderDeployMachineInfo()
            self.deploy_machine_info = temp_model.from_map(m['deployMachineInfo'])
        if m.get('deployOrderId') is not None:
            self.deploy_order_id = m.get('deployOrderId')
        if m.get('exceptionCode') is not None:
            self.exception_code = m.get('exceptionCode')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('totalBatch') is not None:
            self.total_batch = m.get('totalBatch')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetVMDeployOrderResponseBody(TeaModel):
    def __init__(
        self,
        deploy_order: GetVMDeployOrderResponseBodyDeployOrder = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.deploy_order = deploy_order
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.deploy_order:
            self.deploy_order.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_order is not None:
            result['deployOrder'] = self.deploy_order.to_map()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployOrder') is not None:
            temp_model = GetVMDeployOrderResponseBodyDeployOrder()
            self.deploy_order = temp_model.from_map(m['deployOrder'])
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetVMDeployOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetVMDeployOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVMDeployOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVariableGroupResponseBodyVariableGroupRelatedPipelines(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetVariableGroupResponseBodyVariableGroupVariables(TeaModel):
    def __init__(
        self,
        is_encrypted: bool = None,
        name: str = None,
        value: str = None,
    ):
        self.is_encrypted = is_encrypted
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_encrypted is not None:
            result['isEncrypted'] = self.is_encrypted
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('isEncrypted') is not None:
            self.is_encrypted = m.get('isEncrypted')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class GetVariableGroupResponseBodyVariableGroup(TeaModel):
    def __init__(
        self,
        ccreator_account_id: str = None,
        create_time: int = None,
        description: str = None,
        id: int = None,
        modifier_account_id: str = None,
        name: str = None,
        related_pipelines: List[GetVariableGroupResponseBodyVariableGroupRelatedPipelines] = None,
        update_time: int = None,
        variables: List[GetVariableGroupResponseBodyVariableGroupVariables] = None,
    ):
        self.ccreator_account_id = ccreator_account_id
        self.create_time = create_time
        self.description = description
        self.id = id
        self.modifier_account_id = modifier_account_id
        self.name = name
        self.related_pipelines = related_pipelines
        self.update_time = update_time
        self.variables = variables

    def validate(self):
        if self.related_pipelines:
            for k in self.related_pipelines:
                if k:
                    k.validate()
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccreator_account_id is not None:
            result['ccreatorAccountId'] = self.ccreator_account_id
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.name is not None:
            result['name'] = self.name
        result['relatedPipelines'] = []
        if self.related_pipelines is not None:
            for k in self.related_pipelines:
                result['relatedPipelines'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        result['variables'] = []
        if self.variables is not None:
            for k in self.variables:
                result['variables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ccreatorAccountId') is not None:
            self.ccreator_account_id = m.get('ccreatorAccountId')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        self.related_pipelines = []
        if m.get('relatedPipelines') is not None:
            for k in m.get('relatedPipelines'):
                temp_model = GetVariableGroupResponseBodyVariableGroupRelatedPipelines()
                self.related_pipelines.append(temp_model.from_map(k))
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        self.variables = []
        if m.get('variables') is not None:
            for k in m.get('variables'):
                temp_model = GetVariableGroupResponseBodyVariableGroupVariables()
                self.variables.append(temp_model.from_map(k))
        return self


class GetVariableGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        variable_group: GetVariableGroupResponseBodyVariableGroup = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.variable_group = variable_group

    def validate(self):
        if self.variable_group:
            self.variable_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.variable_group is not None:
            result['variableGroup'] = self.variable_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('variableGroup') is not None:
            temp_model = GetVariableGroupResponseBodyVariableGroup()
            self.variable_group = temp_model.from_map(m['variableGroup'])
        return self


class GetVariableGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetVariableGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVariableGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkItemActivityResponseBodyActivitiesNewValue(TeaModel):
    def __init__(
        self,
        display_value: str = None,
        plain_value: str = None,
        resource_type: str = None,
    ):
        self.display_value = display_value
        self.plain_value = plain_value
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_value is not None:
            result['displayValue'] = self.display_value
        if self.plain_value is not None:
            result['plainValue'] = self.plain_value
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayValue') is not None:
            self.display_value = m.get('displayValue')
        if m.get('plainValue') is not None:
            self.plain_value = m.get('plainValue')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        return self


class GetWorkItemActivityResponseBodyActivitiesOldValue(TeaModel):
    def __init__(
        self,
        display_value: str = None,
        plain_value: str = None,
        resource_type: str = None,
    ):
        self.display_value = display_value
        self.plain_value = plain_value
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_value is not None:
            result['displayValue'] = self.display_value
        if self.plain_value is not None:
            result['plainValue'] = self.plain_value
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayValue') is not None:
            self.display_value = m.get('displayValue')
        if m.get('plainValue') is not None:
            self.plain_value = m.get('plainValue')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        return self


class GetWorkItemActivityResponseBodyActivitiesProperty(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        property_identifier: str = None,
        property_name: str = None,
        property_type: str = None,
    ):
        self.display_name = display_name
        self.property_identifier = property_identifier
        self.property_name = property_name
        self.property_type = property_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.property_identifier is not None:
            result['propertyIdentifier'] = self.property_identifier
        if self.property_name is not None:
            result['propertyName'] = self.property_name
        if self.property_type is not None:
            result['propertyType'] = self.property_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('propertyIdentifier') is not None:
            self.property_identifier = m.get('propertyIdentifier')
        if m.get('propertyName') is not None:
            self.property_name = m.get('propertyName')
        if m.get('propertyType') is not None:
            self.property_type = m.get('propertyType')
        return self


class GetWorkItemActivityResponseBodyActivities(TeaModel):
    def __init__(
        self,
        action_type: str = None,
        event_id: int = None,
        event_time: int = None,
        event_type: str = None,
        new_value: List[GetWorkItemActivityResponseBodyActivitiesNewValue] = None,
        old_value: List[GetWorkItemActivityResponseBodyActivitiesOldValue] = None,
        operator: str = None,
        parent_event_id: int = None,
        property: GetWorkItemActivityResponseBodyActivitiesProperty = None,
        resource_identifier: str = None,
    ):
        self.action_type = action_type
        self.event_id = event_id
        self.event_time = event_time
        self.event_type = event_type
        self.new_value = new_value
        self.old_value = old_value
        self.operator = operator
        self.parent_event_id = parent_event_id
        self.property = property
        self.resource_identifier = resource_identifier

    def validate(self):
        if self.new_value:
            for k in self.new_value:
                if k:
                    k.validate()
        if self.old_value:
            for k in self.old_value:
                if k:
                    k.validate()
        if self.property:
            self.property.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['actionType'] = self.action_type
        if self.event_id is not None:
            result['eventId'] = self.event_id
        if self.event_time is not None:
            result['eventTime'] = self.event_time
        if self.event_type is not None:
            result['eventType'] = self.event_type
        result['newValue'] = []
        if self.new_value is not None:
            for k in self.new_value:
                result['newValue'].append(k.to_map() if k else None)
        result['oldValue'] = []
        if self.old_value is not None:
            for k in self.old_value:
                result['oldValue'].append(k.to_map() if k else None)
        if self.operator is not None:
            result['operator'] = self.operator
        if self.parent_event_id is not None:
            result['parentEventId'] = self.parent_event_id
        if self.property is not None:
            result['property'] = self.property.to_map()
        if self.resource_identifier is not None:
            result['resourceIdentifier'] = self.resource_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionType') is not None:
            self.action_type = m.get('actionType')
        if m.get('eventId') is not None:
            self.event_id = m.get('eventId')
        if m.get('eventTime') is not None:
            self.event_time = m.get('eventTime')
        if m.get('eventType') is not None:
            self.event_type = m.get('eventType')
        self.new_value = []
        if m.get('newValue') is not None:
            for k in m.get('newValue'):
                temp_model = GetWorkItemActivityResponseBodyActivitiesNewValue()
                self.new_value.append(temp_model.from_map(k))
        self.old_value = []
        if m.get('oldValue') is not None:
            for k in m.get('oldValue'):
                temp_model = GetWorkItemActivityResponseBodyActivitiesOldValue()
                self.old_value.append(temp_model.from_map(k))
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('parentEventId') is not None:
            self.parent_event_id = m.get('parentEventId')
        if m.get('property') is not None:
            temp_model = GetWorkItemActivityResponseBodyActivitiesProperty()
            self.property = temp_model.from_map(m['property'])
        if m.get('resourceIdentifier') is not None:
            self.resource_identifier = m.get('resourceIdentifier')
        return self


class GetWorkItemActivityResponseBody(TeaModel):
    def __init__(
        self,
        activities: List[GetWorkItemActivityResponseBodyActivities] = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.activities = activities
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.activities:
            for k in self.activities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['activities'] = []
        if self.activities is not None:
            for k in self.activities:
                result['activities'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.activities = []
        if m.get('activities') is not None:
            for k in m.get('activities'):
                temp_model = GetWorkItemActivityResponseBodyActivities()
                self.activities.append(temp_model.from_map(k))
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetWorkItemActivityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkItemActivityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkItemActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkItemInfoResponseBodyWorkitemCustomFieldsValueList(TeaModel):
    def __init__(
        self,
        display_value: str = None,
        identifier: str = None,
        level: int = None,
        value: str = None,
        value_en: str = None,
    ):
        self.display_value = display_value
        self.identifier = identifier
        self.level = level
        self.value = value
        self.value_en = value_en

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_value is not None:
            result['displayValue'] = self.display_value
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.level is not None:
            result['level'] = self.level
        if self.value is not None:
            result['value'] = self.value
        if self.value_en is not None:
            result['valueEn'] = self.value_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayValue') is not None:
            self.display_value = m.get('displayValue')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueEn') is not None:
            self.value_en = m.get('valueEn')
        return self


class GetWorkItemInfoResponseBodyWorkitemCustomFields(TeaModel):
    def __init__(
        self,
        field_class_name: str = None,
        field_format: str = None,
        field_identifier: str = None,
        level: int = None,
        object_value: str = None,
        position: int = None,
        value: str = None,
        value_list: List[GetWorkItemInfoResponseBodyWorkitemCustomFieldsValueList] = None,
        workitem_identifier: str = None,
    ):
        self.field_class_name = field_class_name
        self.field_format = field_format
        self.field_identifier = field_identifier
        self.level = level
        self.object_value = object_value
        self.position = position
        self.value = value
        self.value_list = value_list
        self.workitem_identifier = workitem_identifier

    def validate(self):
        if self.value_list:
            for k in self.value_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_class_name is not None:
            result['fieldClassName'] = self.field_class_name
        if self.field_format is not None:
            result['fieldFormat'] = self.field_format
        if self.field_identifier is not None:
            result['fieldIdentifier'] = self.field_identifier
        if self.level is not None:
            result['level'] = self.level
        if self.object_value is not None:
            result['objectValue'] = self.object_value
        if self.position is not None:
            result['position'] = self.position
        if self.value is not None:
            result['value'] = self.value
        result['valueList'] = []
        if self.value_list is not None:
            for k in self.value_list:
                result['valueList'].append(k.to_map() if k else None)
        if self.workitem_identifier is not None:
            result['workitemIdentifier'] = self.workitem_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldClassName') is not None:
            self.field_class_name = m.get('fieldClassName')
        if m.get('fieldFormat') is not None:
            self.field_format = m.get('fieldFormat')
        if m.get('fieldIdentifier') is not None:
            self.field_identifier = m.get('fieldIdentifier')
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('objectValue') is not None:
            self.object_value = m.get('objectValue')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('value') is not None:
            self.value = m.get('value')
        self.value_list = []
        if m.get('valueList') is not None:
            for k in m.get('valueList'):
                temp_model = GetWorkItemInfoResponseBodyWorkitemCustomFieldsValueList()
                self.value_list.append(temp_model.from_map(k))
        if m.get('workitemIdentifier') is not None:
            self.workitem_identifier = m.get('workitemIdentifier')
        return self


class GetWorkItemInfoResponseBodyWorkitem(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        category_identifier: str = None,
        creator: str = None,
        custom_fields: List[GetWorkItemInfoResponseBodyWorkitemCustomFields] = None,
        document: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        logical_status: str = None,
        modifier: str = None,
        parent_identifier: str = None,
        participant: List[str] = None,
        serial_number: str = None,
        space_identifier: str = None,
        space_name: str = None,
        space_type: str = None,
        sprint: List[str] = None,
        status: str = None,
        status_identifier: str = None,
        status_stage_identifier: str = None,
        subject: str = None,
        tag: List[str] = None,
        tracker: List[str] = None,
        update_status_at: int = None,
        verifier: List[str] = None,
        workitem_type_identifier: str = None,
    ):
        self.assigned_to = assigned_to
        self.category_identifier = category_identifier
        self.creator = creator
        self.custom_fields = custom_fields
        self.document = document
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.logical_status = logical_status
        self.modifier = modifier
        self.parent_identifier = parent_identifier
        self.participant = participant
        self.serial_number = serial_number
        self.space_identifier = space_identifier
        self.space_name = space_name
        self.space_type = space_type
        self.sprint = sprint
        self.status = status
        self.status_identifier = status_identifier
        self.status_stage_identifier = status_stage_identifier
        self.subject = subject
        self.tag = tag
        self.tracker = tracker
        self.update_status_at = update_status_at
        self.verifier = verifier
        self.workitem_type_identifier = workitem_type_identifier

    def validate(self):
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        result['customFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['customFields'].append(k.to_map() if k else None)
        if self.document is not None:
            result['document'] = self.document
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.logical_status is not None:
            result['logicalStatus'] = self.logical_status
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.parent_identifier is not None:
            result['parentIdentifier'] = self.parent_identifier
        if self.participant is not None:
            result['participant'] = self.participant
        if self.serial_number is not None:
            result['serialNumber'] = self.serial_number
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.sprint is not None:
            result['sprint'] = self.sprint
        if self.status is not None:
            result['status'] = self.status
        if self.status_identifier is not None:
            result['statusIdentifier'] = self.status_identifier
        if self.status_stage_identifier is not None:
            result['statusStageIdentifier'] = self.status_stage_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.tag is not None:
            result['tag'] = self.tag
        if self.tracker is not None:
            result['tracker'] = self.tracker
        if self.update_status_at is not None:
            result['updateStatusAt'] = self.update_status_at
        if self.verifier is not None:
            result['verifier'] = self.verifier
        if self.workitem_type_identifier is not None:
            result['workitemTypeIdentifier'] = self.workitem_type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        self.custom_fields = []
        if m.get('customFields') is not None:
            for k in m.get('customFields'):
                temp_model = GetWorkItemInfoResponseBodyWorkitemCustomFields()
                self.custom_fields.append(temp_model.from_map(k))
        if m.get('document') is not None:
            self.document = m.get('document')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('logicalStatus') is not None:
            self.logical_status = m.get('logicalStatus')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('parentIdentifier') is not None:
            self.parent_identifier = m.get('parentIdentifier')
        if m.get('participant') is not None:
            self.participant = m.get('participant')
        if m.get('serialNumber') is not None:
            self.serial_number = m.get('serialNumber')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('sprint') is not None:
            self.sprint = m.get('sprint')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('statusIdentifier') is not None:
            self.status_identifier = m.get('statusIdentifier')
        if m.get('statusStageIdentifier') is not None:
            self.status_stage_identifier = m.get('statusStageIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('tracker') is not None:
            self.tracker = m.get('tracker')
        if m.get('updateStatusAt') is not None:
            self.update_status_at = m.get('updateStatusAt')
        if m.get('verifier') is not None:
            self.verifier = m.get('verifier')
        if m.get('workitemTypeIdentifier') is not None:
            self.workitem_type_identifier = m.get('workitemTypeIdentifier')
        return self


class GetWorkItemInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        workitem: GetWorkItemInfoResponseBodyWorkitem = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workitem = workitem

    def validate(self):
        if self.workitem:
            self.workitem.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workitem is not None:
            result['workitem'] = self.workitem.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workitem') is not None:
            temp_model = GetWorkItemInfoResponseBodyWorkitem()
            self.workitem = temp_model.from_map(m['workitem'])
        return self


class GetWorkItemInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkItemInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkItemInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkItemWorkFlowInfoRequest(TeaModel):
    def __init__(
        self,
        configuration_id: str = None,
    ):
        self.configuration_id = configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_id is not None:
            result['configurationId'] = self.configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configurationId') is not None:
            self.configuration_id = m.get('configurationId')
        return self


class GetWorkItemWorkFlowInfoResponseBodyWorkflowStatuses(TeaModel):
    def __init__(
        self,
        creator: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        modifier: str = None,
        name: str = None,
        resource_type: str = None,
        source: str = None,
        workflow_stage_identifier: str = None,
        workflow_stage_name: str = None,
    ):
        self.creator = creator
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.modifier = modifier
        self.name = name
        self.resource_type = resource_type
        self.source = source
        self.workflow_stage_identifier = workflow_stage_identifier
        self.workflow_stage_name = workflow_stage_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.source is not None:
            result['source'] = self.source
        if self.workflow_stage_identifier is not None:
            result['workflowStageIdentifier'] = self.workflow_stage_identifier
        if self.workflow_stage_name is not None:
            result['workflowStageName'] = self.workflow_stage_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('source') is not None:
            self.source = m.get('source')
        if m.get('workflowStageIdentifier') is not None:
            self.workflow_stage_identifier = m.get('workflowStageIdentifier')
        if m.get('workflowStageName') is not None:
            self.workflow_stage_name = m.get('workflowStageName')
        return self


class GetWorkItemWorkFlowInfoResponseBodyWorkflowWorkflowActions(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        next_workflow_status_identifier: str = None,
        workflow_identifier: str = None,
        workflow_status_identifier: str = None,
    ):
        self.id = id
        self.name = name
        self.next_workflow_status_identifier = next_workflow_status_identifier
        self.workflow_identifier = workflow_identifier
        self.workflow_status_identifier = workflow_status_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.next_workflow_status_identifier is not None:
            result['nextWorkflowStatusIdentifier'] = self.next_workflow_status_identifier
        if self.workflow_identifier is not None:
            result['workflowIdentifier'] = self.workflow_identifier
        if self.workflow_status_identifier is not None:
            result['workflowStatusIdentifier'] = self.workflow_status_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nextWorkflowStatusIdentifier') is not None:
            self.next_workflow_status_identifier = m.get('nextWorkflowStatusIdentifier')
        if m.get('workflowIdentifier') is not None:
            self.workflow_identifier = m.get('workflowIdentifier')
        if m.get('workflowStatusIdentifier') is not None:
            self.workflow_status_identifier = m.get('workflowStatusIdentifier')
        return self


class GetWorkItemWorkFlowInfoResponseBodyWorkflow(TeaModel):
    def __init__(
        self,
        creator: str = None,
        default_status_identifier: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        identifier: str = None,
        modifier: str = None,
        name: str = None,
        owner_space_identifier: str = None,
        owner_space_type: str = None,
        resource_type: str = None,
        source: str = None,
        status_order: str = None,
        statuses: List[GetWorkItemWorkFlowInfoResponseBodyWorkflowStatuses] = None,
        workflow_actions: List[GetWorkItemWorkFlowInfoResponseBodyWorkflowWorkflowActions] = None,
    ):
        self.creator = creator
        self.default_status_identifier = default_status_identifier
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.modifier = modifier
        self.name = name
        self.owner_space_identifier = owner_space_identifier
        self.owner_space_type = owner_space_type
        self.resource_type = resource_type
        self.source = source
        self.status_order = status_order
        self.statuses = statuses
        self.workflow_actions = workflow_actions

    def validate(self):
        if self.statuses:
            for k in self.statuses:
                if k:
                    k.validate()
        if self.workflow_actions:
            for k in self.workflow_actions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['creator'] = self.creator
        if self.default_status_identifier is not None:
            result['defaultStatusIdentifier'] = self.default_status_identifier
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.owner_space_identifier is not None:
            result['ownerSpaceIdentifier'] = self.owner_space_identifier
        if self.owner_space_type is not None:
            result['ownerSpaceType'] = self.owner_space_type
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.source is not None:
            result['source'] = self.source
        if self.status_order is not None:
            result['statusOrder'] = self.status_order
        result['statuses'] = []
        if self.statuses is not None:
            for k in self.statuses:
                result['statuses'].append(k.to_map() if k else None)
        result['workflowActions'] = []
        if self.workflow_actions is not None:
            for k in self.workflow_actions:
                result['workflowActions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('defaultStatusIdentifier') is not None:
            self.default_status_identifier = m.get('defaultStatusIdentifier')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ownerSpaceIdentifier') is not None:
            self.owner_space_identifier = m.get('ownerSpaceIdentifier')
        if m.get('ownerSpaceType') is not None:
            self.owner_space_type = m.get('ownerSpaceType')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('source') is not None:
            self.source = m.get('source')
        if m.get('statusOrder') is not None:
            self.status_order = m.get('statusOrder')
        self.statuses = []
        if m.get('statuses') is not None:
            for k in m.get('statuses'):
                temp_model = GetWorkItemWorkFlowInfoResponseBodyWorkflowStatuses()
                self.statuses.append(temp_model.from_map(k))
        self.workflow_actions = []
        if m.get('workflowActions') is not None:
            for k in m.get('workflowActions'):
                temp_model = GetWorkItemWorkFlowInfoResponseBodyWorkflowWorkflowActions()
                self.workflow_actions.append(temp_model.from_map(k))
        return self


class GetWorkItemWorkFlowInfoResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        workflow: GetWorkItemWorkFlowInfoResponseBodyWorkflow = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workflow = workflow

    def validate(self):
        if self.workflow:
            self.workflow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workflow is not None:
            result['workflow'] = self.workflow.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workflow') is not None:
            temp_model = GetWorkItemWorkFlowInfoResponseBodyWorkflow()
            self.workflow = temp_model.from_map(m['workflow'])
        return self


class GetWorkItemWorkFlowInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkItemWorkFlowInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkItemWorkFlowInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkitemAttachmentCreatemetaRequest(TeaModel):
    def __init__(
        self,
        file_name: str = None,
    ):
        self.file_name = file_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['fileName'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        return self


class GetWorkitemAttachmentCreatemetaResponseBodyUploadInfo(TeaModel):
    def __init__(
        self,
        accessid: str = None,
        dir: str = None,
        host: str = None,
        policy: str = None,
        signature: str = None,
    ):
        self.accessid = accessid
        self.dir = dir
        self.host = host
        self.policy = policy
        self.signature = signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accessid is not None:
            result['accessid'] = self.accessid
        if self.dir is not None:
            result['dir'] = self.dir
        if self.host is not None:
            result['host'] = self.host
        if self.policy is not None:
            result['policy'] = self.policy
        if self.signature is not None:
            result['signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessid') is not None:
            self.accessid = m.get('accessid')
        if m.get('dir') is not None:
            self.dir = m.get('dir')
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('policy') is not None:
            self.policy = m.get('policy')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        return self


class GetWorkitemAttachmentCreatemetaResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: str = None,
        upload_info: GetWorkitemAttachmentCreatemetaResponseBodyUploadInfo = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.upload_info = upload_info

    def validate(self):
        if self.upload_info:
            self.upload_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.upload_info is not None:
            result['uploadInfo'] = self.upload_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('uploadInfo') is not None:
            temp_model = GetWorkitemAttachmentCreatemetaResponseBodyUploadInfo()
            self.upload_info = temp_model.from_map(m['uploadInfo'])
        return self


class GetWorkitemAttachmentCreatemetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkitemAttachmentCreatemetaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkitemAttachmentCreatemetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkitemCommentListResponseBodyCommentListUser(TeaModel):
    def __init__(
        self,
        account: str = None,
        avatar: str = None,
        identifier: str = None,
        nick_name: str = None,
        real_name: str = None,
    ):
        self.account = account
        self.avatar = avatar
        self.identifier = identifier
        self.nick_name = nick_name
        self.real_name = real_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['account'] = self.account
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.nick_name is not None:
            result['nickName'] = self.nick_name
        if self.real_name is not None:
            result['realName'] = self.real_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('nickName') is not None:
            self.nick_name = m.get('nickName')
        if m.get('realName') is not None:
            self.real_name = m.get('realName')
        return self


class GetWorkitemCommentListResponseBodyCommentList(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: int = None,
        format_type: str = None,
        id: int = None,
        is_top: bool = None,
        modified_time: int = None,
        parent_id: int = None,
        target_identifier: str = None,
        target_type: str = None,
        top_time: int = None,
        user: GetWorkitemCommentListResponseBodyCommentListUser = None,
    ):
        self.content = content
        self.create_time = create_time
        self.format_type = format_type
        self.id = id
        self.is_top = is_top
        self.modified_time = modified_time
        self.parent_id = parent_id
        self.target_identifier = target_identifier
        self.target_type = target_type
        self.top_time = top_time
        self.user = user

    def validate(self):
        if self.user:
            self.user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.format_type is not None:
            result['formatType'] = self.format_type
        if self.id is not None:
            result['id'] = self.id
        if self.is_top is not None:
            result['isTop'] = self.is_top
        if self.modified_time is not None:
            result['modifiedTime'] = self.modified_time
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.target_identifier is not None:
            result['targetIdentifier'] = self.target_identifier
        if self.target_type is not None:
            result['targetType'] = self.target_type
        if self.top_time is not None:
            result['topTime'] = self.top_time
        if self.user is not None:
            result['user'] = self.user.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('formatType') is not None:
            self.format_type = m.get('formatType')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isTop') is not None:
            self.is_top = m.get('isTop')
        if m.get('modifiedTime') is not None:
            self.modified_time = m.get('modifiedTime')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('targetIdentifier') is not None:
            self.target_identifier = m.get('targetIdentifier')
        if m.get('targetType') is not None:
            self.target_type = m.get('targetType')
        if m.get('topTime') is not None:
            self.top_time = m.get('topTime')
        if m.get('user') is not None:
            temp_model = GetWorkitemCommentListResponseBodyCommentListUser()
            self.user = temp_model.from_map(m['user'])
        return self


class GetWorkitemCommentListResponseBody(TeaModel):
    def __init__(
        self,
        comment_list: List[GetWorkitemCommentListResponseBodyCommentList] = None,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.comment_list = comment_list
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.comment_list:
            for k in self.comment_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['commentList'] = []
        if self.comment_list is not None:
            for k in self.comment_list:
                result['commentList'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.comment_list = []
        if m.get('commentList') is not None:
            for k in m.get('commentList'):
                temp_model = GetWorkitemCommentListResponseBodyCommentList()
                self.comment_list.append(temp_model.from_map(k))
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetWorkitemCommentListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkitemCommentListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkitemCommentListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkitemRelationsRequest(TeaModel):
    def __init__(
        self,
        relation_type: str = None,
    ):
        self.relation_type = relation_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relation_type is not None:
            result['relationType'] = self.relation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('relationType') is not None:
            self.relation_type = m.get('relationType')
        return self


class GetWorkitemRelationsResponseBodyRelationList(TeaModel):
    def __init__(
        self,
        assigned_to: str = None,
        category_identifier: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        identifier: str = None,
        space_identifier: str = None,
        subject: str = None,
        workitem_type_identifier: str = None,
    ):
        self.assigned_to = assigned_to
        self.category_identifier = category_identifier
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.identifier = identifier
        self.space_identifier = space_identifier
        self.subject = subject
        self.workitem_type_identifier = workitem_type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_to is not None:
            result['assignedTo'] = self.assigned_to
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.subject is not None:
            result['subject'] = self.subject
        if self.workitem_type_identifier is not None:
            result['workitemTypeIdentifier'] = self.workitem_type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('assignedTo') is not None:
            self.assigned_to = m.get('assignedTo')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('workitemTypeIdentifier') is not None:
            self.workitem_type_identifier = m.get('workitemTypeIdentifier')
        return self


class GetWorkitemRelationsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        relation_list: List[GetWorkitemRelationsResponseBodyRelationList] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.relation_list = relation_list
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.relation_list:
            for k in self.relation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        result['relationList'] = []
        if self.relation_list is not None:
            for k in self.relation_list:
                result['relationList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        self.relation_list = []
        if m.get('relationList') is not None:
            for k in m.get('relationList'):
                temp_model = GetWorkitemRelationsResponseBodyRelationList()
                self.relation_list.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetWorkitemRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkitemRelationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkitemRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkitemTimeTypeListResponseBodyTimeType(TeaModel):
    def __init__(
        self,
        description: str = None,
        display_name: str = None,
        identifier: str = None,
        name: str = None,
        position: int = None,
    ):
        self.description = description
        self.display_name = display_name
        self.identifier = identifier
        self.name = name
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.name is not None:
            result['name'] = self.name
        if self.position is not None:
            result['position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('position') is not None:
            self.position = m.get('position')
        return self


class GetWorkitemTimeTypeListResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: str = None,
        time_type: List[GetWorkitemTimeTypeListResponseBodyTimeType] = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        # Id of the request
        self.request_id = request_id
        self.success = success
        self.time_type = time_type

    def validate(self):
        if self.time_type:
            for k in self.time_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        result['timeType'] = []
        if self.time_type is not None:
            for k in self.time_type:
                result['timeType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.time_type = []
        if m.get('timeType') is not None:
            for k in m.get('timeType'):
                temp_model = GetWorkitemTimeTypeListResponseBodyTimeType()
                self.time_type.append(temp_model.from_map(k))
        return self


class GetWorkitemTimeTypeListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkitemTimeTypeListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkitemTimeTypeListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkspaceResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        code_url: str = None,
        code_version: str = None,
        create_time: str = None,
        id: str = None,
        name: str = None,
        spec: str = None,
        status: str = None,
        template: str = None,
        user_id: str = None,
    ):
        self.code_url = code_url
        self.code_version = code_version
        self.create_time = create_time
        self.id = id
        self.name = name
        self.spec = spec
        self.status = status
        self.template = template
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_url is not None:
            result['codeUrl'] = self.code_url
        if self.code_version is not None:
            result['codeVersion'] = self.code_version
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.spec is not None:
            result['spec'] = self.spec
        if self.status is not None:
            result['status'] = self.status
        if self.template is not None:
            result['template'] = self.template
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('codeUrl') is not None:
            self.code_url = m.get('codeUrl')
        if m.get('codeVersion') is not None:
            self.code_version = m.get('codeVersion')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('spec') is not None:
            self.spec = m.get('spec')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('template') is not None:
            self.template = m.get('template')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        workspace: GetWorkspaceResponseBodyWorkspace = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            self.workspace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.workspace is not None:
            result['workspace'] = self.workspace.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('workspace') is not None:
            temp_model = GetWorkspaceResponseBodyWorkspace()
            self.workspace = temp_model.from_map(m['workspace'])
        return self


class GetWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinPipelineGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        pipeline_ids: str = None,
    ):
        self.group_id = group_id
        self.pipeline_ids = pipeline_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.pipeline_ids is not None:
            result['pipelineIds'] = self.pipeline_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('pipelineIds') is not None:
            self.pipeline_ids = m.get('pipelineIds')
        return self


class JoinPipelineGroupResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class JoinPipelineGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: JoinPipelineGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = JoinPipelineGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowTagGroupsResponseBodyFlowTagGroups(TeaModel):
    def __init__(
        self,
        creator_account_id: str = None,
        id: int = None,
        modifer_account_id: str = None,
        name: str = None,
    ):
        self.creator_account_id = creator_account_id
        self.id = id
        self.modifer_account_id = modifer_account_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.id is not None:
            result['id'] = self.id
        if self.modifer_account_id is not None:
            result['modiferAccountId'] = self.modifer_account_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modiferAccountId') is not None:
            self.modifer_account_id = m.get('modiferAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListFlowTagGroupsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        flow_tag_groups: List[ListFlowTagGroupsResponseBodyFlowTagGroups] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.flow_tag_groups = flow_tag_groups
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.flow_tag_groups:
            for k in self.flow_tag_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['flowTagGroups'] = []
        if self.flow_tag_groups is not None:
            for k in self.flow_tag_groups:
                result['flowTagGroups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.flow_tag_groups = []
        if m.get('flowTagGroups') is not None:
            for k in m.get('flowTagGroups'):
                temp_model = ListFlowTagGroupsResponseBodyFlowTagGroups()
                self.flow_tag_groups.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListFlowTagGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListFlowTagGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFlowTagGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGroupMemberRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class ListGroupMemberResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        member_type: str = None,
        name: str = None,
        source_id: int = None,
        state: str = None,
        username: str = None,
    ):
        self.access_level = access_level
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.member_type = member_type
        self.name = name
        self.source_id = source_id
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.member_type is not None:
            result['memberType'] = self.member_type
        if self.name is not None:
            result['name'] = self.name
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('memberType') is not None:
            self.member_type = m.get('memberType')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListGroupMemberResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListGroupMemberResponseBodyResult] = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListGroupMemberResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListGroupMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGroupMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGroupMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGroupRepositoriesRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
        page: int = None,
        page_size: int = None,
        search: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id
        self.page = page
        self.page_size = page_size
        self.search = search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.search is not None:
            result['search'] = self.search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('search') is not None:
            self.search = m.get('search')
        return self


class ListGroupRepositoriesResponseBodyResult(TeaModel):
    def __init__(
        self,
        archived: bool = None,
        commit_count: int = None,
        created_at: str = None,
        creator_id: int = None,
        description: str = None,
        http_url: str = None,
        id: int = None,
        import_url: str = None,
        is_stared: bool = None,
        issues_enabled: bool = None,
        last_activity_at: str = None,
        merge_requests_enabled: bool = None,
        name: str = None,
        name_with_namespace: str = None,
        namespace_id: bool = None,
        path: str = None,
        path_with_namespace: str = None,
        private_flag: bool = None,
        snippets_enabled: bool = None,
        ssh_url: str = None,
        star_count: int = None,
        updated_at: str = None,
        visibility_level: int = None,
        web_url: str = None,
        wiki_enabled: bool = None,
    ):
        self.archived = archived
        self.commit_count = commit_count
        self.created_at = created_at
        self.creator_id = creator_id
        self.description = description
        self.http_url = http_url
        self.id = id
        self.import_url = import_url
        self.is_stared = is_stared
        self.issues_enabled = issues_enabled
        self.last_activity_at = last_activity_at
        self.merge_requests_enabled = merge_requests_enabled
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.namespace_id = namespace_id
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.private_flag = private_flag
        self.snippets_enabled = snippets_enabled
        self.ssh_url = ssh_url
        self.star_count = star_count
        self.updated_at = updated_at
        self.visibility_level = visibility_level
        self.web_url = web_url
        self.wiki_enabled = wiki_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archived is not None:
            result['archived'] = self.archived
        if self.commit_count is not None:
            result['commitCount'] = self.commit_count
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.description is not None:
            result['description'] = self.description
        if self.http_url is not None:
            result['httpUrl'] = self.http_url
        if self.id is not None:
            result['id'] = self.id
        if self.import_url is not None:
            result['importUrl'] = self.import_url
        if self.is_stared is not None:
            result['isStared'] = self.is_stared
        if self.issues_enabled is not None:
            result['issuesEnabled'] = self.issues_enabled
        if self.last_activity_at is not None:
            result['lastActivityAt'] = self.last_activity_at
        if self.merge_requests_enabled is not None:
            result['mergeRequestsEnabled'] = self.merge_requests_enabled
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.namespace_id is not None:
            result['namespaceId'] = self.namespace_id
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.private_flag is not None:
            result['privateFlag'] = self.private_flag
        if self.snippets_enabled is not None:
            result['snippetsEnabled'] = self.snippets_enabled
        if self.ssh_url is not None:
            result['sshUrl'] = self.ssh_url
        if self.star_count is not None:
            result['starCount'] = self.star_count
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        if self.wiki_enabled is not None:
            result['wikiEnabled'] = self.wiki_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('archived') is not None:
            self.archived = m.get('archived')
        if m.get('commitCount') is not None:
            self.commit_count = m.get('commitCount')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('httpUrl') is not None:
            self.http_url = m.get('httpUrl')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('importUrl') is not None:
            self.import_url = m.get('importUrl')
        if m.get('isStared') is not None:
            self.is_stared = m.get('isStared')
        if m.get('issuesEnabled') is not None:
            self.issues_enabled = m.get('issuesEnabled')
        if m.get('lastActivityAt') is not None:
            self.last_activity_at = m.get('lastActivityAt')
        if m.get('mergeRequestsEnabled') is not None:
            self.merge_requests_enabled = m.get('mergeRequestsEnabled')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('namespaceId') is not None:
            self.namespace_id = m.get('namespaceId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('privateFlag') is not None:
            self.private_flag = m.get('privateFlag')
        if m.get('snippetsEnabled') is not None:
            self.snippets_enabled = m.get('snippetsEnabled')
        if m.get('sshUrl') is not None:
            self.ssh_url = m.get('sshUrl')
        if m.get('starCount') is not None:
            self.star_count = m.get('starCount')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        if m.get('wikiEnabled') is not None:
            self.wiki_enabled = m.get('wikiEnabled')
        return self


class ListGroupRepositoriesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListGroupRepositoriesResponseBodyResult] = None,
        success: bool = None,
        total: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success
        self.total = total

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListGroupRepositoriesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ListGroupRepositoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGroupRepositoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGroupRepositoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHostGroupsRequest(TeaModel):
    def __init__(
        self,
        create_end_time: int = None,
        create_start_time: int = None,
        creator_account_ids: str = None,
        ids: str = None,
        max_results: int = None,
        name: str = None,
        next_token: str = None,
        page_order: str = None,
        page_sort: str = None,
    ):
        self.create_end_time = create_end_time
        self.create_start_time = create_start_time
        self.creator_account_ids = creator_account_ids
        self.ids = ids
        self.max_results = max_results
        self.name = name
        self.next_token = next_token
        self.page_order = page_order
        self.page_sort = page_sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_end_time is not None:
            result['createEndTime'] = self.create_end_time
        if self.create_start_time is not None:
            result['createStartTime'] = self.create_start_time
        if self.creator_account_ids is not None:
            result['creatorAccountIds'] = self.creator_account_ids
        if self.ids is not None:
            result['ids'] = self.ids
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.name is not None:
            result['name'] = self.name
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.page_order is not None:
            result['pageOrder'] = self.page_order
        if self.page_sort is not None:
            result['pageSort'] = self.page_sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createEndTime') is not None:
            self.create_end_time = m.get('createEndTime')
        if m.get('createStartTime') is not None:
            self.create_start_time = m.get('createStartTime')
        if m.get('creatorAccountIds') is not None:
            self.creator_account_ids = m.get('creatorAccountIds')
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('pageOrder') is not None:
            self.page_order = m.get('pageOrder')
        if m.get('pageSort') is not None:
            self.page_sort = m.get('pageSort')
        return self


class ListHostGroupsResponseBodyHostGroups(TeaModel):
    def __init__(
        self,
        aliyun_region: str = None,
        create_time: int = None,
        creator_account_id: str = None,
        description: str = None,
        ecs_label_key: str = None,
        ecs_label_value: str = None,
        ecs_type: str = None,
        host_num: int = None,
        id: int = None,
        modifier_account_id: str = None,
        name: str = None,
        service_connection_id: int = None,
        type: str = None,
        update_time: int = None,
    ):
        self.aliyun_region = aliyun_region
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.description = description
        self.ecs_label_key = ecs_label_key
        self.ecs_label_value = ecs_label_value
        self.ecs_type = ecs_type
        self.host_num = host_num
        # 323232
        self.id = id
        self.modifier_account_id = modifier_account_id
        self.name = name
        self.service_connection_id = service_connection_id
        self.type = type
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_region is not None:
            result['aliyunRegion'] = self.aliyun_region
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.description is not None:
            result['description'] = self.description
        if self.ecs_label_key is not None:
            result['ecsLabelKey'] = self.ecs_label_key
        if self.ecs_label_value is not None:
            result['ecsLabelValue'] = self.ecs_label_value
        if self.ecs_type is not None:
            result['ecsType'] = self.ecs_type
        if self.host_num is not None:
            result['hostNum'] = self.host_num
        if self.id is not None:
            result['id'] = self.id
        if self.modifier_account_id is not None:
            result['modifierAccountId'] = self.modifier_account_id
        if self.name is not None:
            result['name'] = self.name
        if self.service_connection_id is not None:
            result['serviceConnectionId'] = self.service_connection_id
        if self.type is not None:
            result['type'] = self.type
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aliyunRegion') is not None:
            self.aliyun_region = m.get('aliyunRegion')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('ecsLabelKey') is not None:
            self.ecs_label_key = m.get('ecsLabelKey')
        if m.get('ecsLabelValue') is not None:
            self.ecs_label_value = m.get('ecsLabelValue')
        if m.get('ecsType') is not None:
            self.ecs_type = m.get('ecsType')
        if m.get('hostNum') is not None:
            self.host_num = m.get('hostNum')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modifierAccountId') is not None:
            self.modifier_account_id = m.get('modifierAccountId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('serviceConnectionId') is not None:
            self.service_connection_id = m.get('serviceConnectionId')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ListHostGroupsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        host_groups: List[ListHostGroupsResponseBodyHostGroups] = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.host_groups = host_groups
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.host_groups:
            for k in self.host_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['hostGroups'] = []
        if self.host_groups is not None:
            for k in self.host_groups:
                result['hostGroups'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.host_groups = []
        if m.get('hostGroups') is not None:
            for k in m.get('hostGroups'):
                temp_model = ListHostGroupsResponseBodyHostGroups()
                self.host_groups.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListHostGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHostGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHostGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMergeRequestsRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        author_ids: str = None,
        filter: str = None,
        group_ids: str = None,
        order_by: str = None,
        organization_id: str = None,
        page: int = None,
        page_size: int = None,
        project_ids: str = None,
        reviewer_ids: str = None,
        search: str = None,
        sort: str = None,
        state: str = None,
    ):
        self.access_token = access_token
        self.author_ids = author_ids
        self.filter = filter
        self.group_ids = group_ids
        self.order_by = order_by
        self.organization_id = organization_id
        self.page = page
        self.page_size = page_size
        self.project_ids = project_ids
        self.reviewer_ids = reviewer_ids
        self.search = search
        self.sort = sort
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.author_ids is not None:
            result['authorIds'] = self.author_ids
        if self.filter is not None:
            result['filter'] = self.filter
        if self.group_ids is not None:
            result['groupIds'] = self.group_ids
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.project_ids is not None:
            result['projectIds'] = self.project_ids
        if self.reviewer_ids is not None:
            result['reviewerIds'] = self.reviewer_ids
        if self.search is not None:
            result['search'] = self.search
        if self.sort is not None:
            result['sort'] = self.sort
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('authorIds') is not None:
            self.author_ids = m.get('authorIds')
        if m.get('filter') is not None:
            self.filter = m.get('filter')
        if m.get('groupIds') is not None:
            self.group_ids = m.get('groupIds')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('projectIds') is not None:
            self.project_ids = m.get('projectIds')
        if m.get('reviewerIds') is not None:
            self.reviewer_ids = m.get('reviewerIds')
        if m.get('search') is not None:
            self.search = m.get('search')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class ListMergeRequestsResponseBodyResultAuthor(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListMergeRequestsResponseBodyResultReviewers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        status: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.status = status
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.status is not None:
            result['status'] = self.status
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListMergeRequestsResponseBodyResultSubscribers(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        state: str = None,
        username: str = None,
    ):
        self.avatar_url = avatar_url
        self.email = email
        self.id = id
        self.name = name
        self.state = state
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.state is not None:
            result['state'] = self.state
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListMergeRequestsResponseBodyResult(TeaModel):
    def __init__(
        self,
        author: ListMergeRequestsResponseBodyResultAuthor = None,
        created_at: str = None,
        creation_method: str = None,
        description: str = None,
        detail_url: str = None,
        id: int = None,
        iid: int = None,
        local_id: int = None,
        mr_biz_id: str = None,
        name_with_namespace: str = None,
        new_merge_request_identifier: bool = None,
        new_version_state: str = None,
        project_id: int = None,
        reviewers: List[ListMergeRequestsResponseBodyResultReviewers] = None,
        source_branch: str = None,
        source_project_id: int = None,
        source_type: str = None,
        ssh_url: str = None,
        state: str = None,
        subscribers: List[ListMergeRequestsResponseBodyResultSubscribers] = None,
        support_merge_ffonly: bool = None,
        target_branch: str = None,
        target_project_id: int = None,
        target_type: str = None,
        title: str = None,
        updated_at: str = None,
        web_url: str = None,
        work_in_progress: bool = None,
    ):
        self.author = author
        self.created_at = created_at
        self.creation_method = creation_method
        self.description = description
        self.detail_url = detail_url
        self.id = id
        self.iid = iid
        self.local_id = local_id
        self.mr_biz_id = mr_biz_id
        self.name_with_namespace = name_with_namespace
        self.new_merge_request_identifier = new_merge_request_identifier
        self.new_version_state = new_version_state
        self.project_id = project_id
        self.reviewers = reviewers
        self.source_branch = source_branch
        self.source_project_id = source_project_id
        self.source_type = source_type
        self.ssh_url = ssh_url
        self.state = state
        self.subscribers = subscribers
        self.support_merge_ffonly = support_merge_ffonly
        self.target_branch = target_branch
        self.target_project_id = target_project_id
        self.target_type = target_type
        self.title = title
        self.updated_at = updated_at
        self.web_url = web_url
        self.work_in_progress = work_in_progress

    def validate(self):
        if self.author:
            self.author.validate()
        if self.reviewers:
            for k in self.reviewers:
                if k:
                    k.validate()
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.creation_method is not None:
            result['creationMethod'] = self.creation_method
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url is not None:
            result['detailUrl'] = self.detail_url
        if self.id is not None:
            result['id'] = self.id
        if self.iid is not None:
            result['iid'] = self.iid
        if self.local_id is not None:
            result['localId'] = self.local_id
        if self.mr_biz_id is not None:
            result['mrBizId'] = self.mr_biz_id
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.new_merge_request_identifier is not None:
            result['newMergeRequestIdentifier'] = self.new_merge_request_identifier
        if self.new_version_state is not None:
            result['newVersionState'] = self.new_version_state
        if self.project_id is not None:
            result['projectId'] = self.project_id
        result['reviewers'] = []
        if self.reviewers is not None:
            for k in self.reviewers:
                result['reviewers'].append(k.to_map() if k else None)
        if self.source_branch is not None:
            result['sourceBranch'] = self.source_branch
        if self.source_project_id is not None:
            result['sourceProjectId'] = self.source_project_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.ssh_url is not None:
            result['sshUrl'] = self.ssh_url
        if self.state is not None:
            result['state'] = self.state
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.support_merge_ffonly is not None:
            result['supportMergeFFOnly'] = self.support_merge_ffonly
        if self.target_branch is not None:
            result['targetBranch'] = self.target_branch
        if self.target_project_id is not None:
            result['targetProjectId'] = self.target_project_id
        if self.target_type is not None:
            result['targetType'] = self.target_type
        if self.title is not None:
            result['title'] = self.title
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        if self.work_in_progress is not None:
            result['workInProgress'] = self.work_in_progress
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            temp_model = ListMergeRequestsResponseBodyResultAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('creationMethod') is not None:
            self.creation_method = m.get('creationMethod')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            self.detail_url = m.get('detailUrl')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('iid') is not None:
            self.iid = m.get('iid')
        if m.get('localId') is not None:
            self.local_id = m.get('localId')
        if m.get('mrBizId') is not None:
            self.mr_biz_id = m.get('mrBizId')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('newMergeRequestIdentifier') is not None:
            self.new_merge_request_identifier = m.get('newMergeRequestIdentifier')
        if m.get('newVersionState') is not None:
            self.new_version_state = m.get('newVersionState')
        if m.get('projectId') is not None:
            self.project_id = m.get('projectId')
        self.reviewers = []
        if m.get('reviewers') is not None:
            for k in m.get('reviewers'):
                temp_model = ListMergeRequestsResponseBodyResultReviewers()
                self.reviewers.append(temp_model.from_map(k))
        if m.get('sourceBranch') is not None:
            self.source_branch = m.get('sourceBranch')
        if m.get('sourceProjectId') is not None:
            self.source_project_id = m.get('sourceProjectId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('sshUrl') is not None:
            self.ssh_url = m.get('sshUrl')
        if m.get('state') is not None:
            self.state = m.get('state')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = ListMergeRequestsResponseBodyResultSubscribers()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('supportMergeFFOnly') is not None:
            self.support_merge_ffonly = m.get('supportMergeFFOnly')
        if m.get('targetBranch') is not None:
            self.target_branch = m.get('targetBranch')
        if m.get('targetProjectId') is not None:
            self.target_project_id = m.get('targetProjectId')
        if m.get('targetType') is not None:
            self.target_type = m.get('targetType')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        if m.get('workInProgress') is not None:
            self.work_in_progress = m.get('workInProgress')
        return self


class ListMergeRequestsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListMergeRequestsResponseBodyResult] = None,
        success: bool = None,
        total: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        # Id of the request
        self.request_id = request_id
        self.result = result
        self.success = success
        self.total = total

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListMergeRequestsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ListMergeRequestsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListMergeRequestsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMergeRequestsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrganizationMembersRequest(TeaModel):
    def __init__(
        self,
        contains_extern_info: bool = None,
        extern_uid: str = None,
        join_time_from: int = None,
        join_time_to: int = None,
        max_results: int = None,
        next_token: str = None,
        organization_member_name: str = None,
        provider: str = None,
        state: str = None,
    ):
        # 返回信息中是否包含第三方信息，默认不包含。
        self.contains_extern_info = contains_extern_info
        self.extern_uid = extern_uid
        self.join_time_from = join_time_from
        self.join_time_to = join_time_to
        self.max_results = max_results
        self.next_token = next_token
        self.organization_member_name = organization_member_name
        self.provider = provider
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contains_extern_info is not None:
            result['containsExternInfo'] = self.contains_extern_info
        if self.extern_uid is not None:
            result['externUid'] = self.extern_uid
        if self.join_time_from is not None:
            result['joinTimeFrom'] = self.join_time_from
        if self.join_time_to is not None:
            result['joinTimeTo'] = self.join_time_to
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.organization_member_name is not None:
            result['organizationMemberName'] = self.organization_member_name
        if self.provider is not None:
            result['provider'] = self.provider
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containsExternInfo') is not None:
            self.contains_extern_info = m.get('containsExternInfo')
        if m.get('externUid') is not None:
            self.extern_uid = m.get('externUid')
        if m.get('joinTimeFrom') is not None:
            self.join_time_from = m.get('joinTimeFrom')
        if m.get('joinTimeTo') is not None:
            self.join_time_to = m.get('joinTimeTo')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('organizationMemberName') is not None:
            self.organization_member_name = m.get('organizationMemberName')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class ListOrganizationMembersResponseBodyMembersIdentities(TeaModel):
    def __init__(
        self,
        extern_uid: str = None,
        provider: str = None,
    ):
        self.extern_uid = extern_uid
        self.provider = provider

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extern_uid is not None:
            result['externUid'] = self.extern_uid
        if self.provider is not None:
            result['provider'] = self.provider
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('externUid') is not None:
            self.extern_uid = m.get('externUid')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        return self


class ListOrganizationMembersResponseBodyMembers(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        birthday: int = None,
        dept_lists: List[str] = None,
        email: str = None,
        hired_date: int = None,
        identities: ListOrganizationMembersResponseBodyMembersIdentities = None,
        join_time: int = None,
        last_visit_time: int = None,
        mobile: str = None,
        organization_member_name: str = None,
        organization_role_id: str = None,
        organization_role_name: str = None,
        state: str = None,
    ):
        self.account_id = account_id
        self.birthday = birthday
        self.dept_lists = dept_lists
        self.email = email
        self.hired_date = hired_date
        self.identities = identities
        self.join_time = join_time
        self.last_visit_time = last_visit_time
        self.mobile = mobile
        self.organization_member_name = organization_member_name
        self.organization_role_id = organization_role_id
        self.organization_role_name = organization_role_name
        self.state = state

    def validate(self):
        if self.identities:
            self.identities.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.dept_lists is not None:
            result['deptLists'] = self.dept_lists
        if self.email is not None:
            result['email'] = self.email
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.identities is not None:
            result['identities'] = self.identities.to_map()
        if self.join_time is not None:
            result['joinTime'] = self.join_time
        if self.last_visit_time is not None:
            result['lastVisitTime'] = self.last_visit_time
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.organization_member_name is not None:
            result['organizationMemberName'] = self.organization_member_name
        if self.organization_role_id is not None:
            result['organizationRoleId'] = self.organization_role_id
        if self.organization_role_name is not None:
            result['organizationRoleName'] = self.organization_role_name
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('deptLists') is not None:
            self.dept_lists = m.get('deptLists')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('identities') is not None:
            temp_model = ListOrganizationMembersResponseBodyMembersIdentities()
            self.identities = temp_model.from_map(m['identities'])
        if m.get('joinTime') is not None:
            self.join_time = m.get('joinTime')
        if m.get('lastVisitTime') is not None:
            self.last_visit_time = m.get('lastVisitTime')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('organizationMemberName') is not None:
            self.organization_member_name = m.get('organizationMemberName')
        if m.get('organizationRoleId') is not None:
            self.organization_role_id = m.get('organizationRoleId')
        if m.get('organizationRoleName') is not None:
            self.organization_role_name = m.get('organizationRoleName')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class ListOrganizationMembersResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        members: List[ListOrganizationMembersResponseBodyMembers] = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.members = members
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['members'] = []
        if self.members is not None:
            for k in self.members:
                result['members'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.members = []
        if m.get('members') is not None:
            for k in m.get('members'):
                temp_model = ListOrganizationMembersResponseBodyMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListOrganizationMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrganizationMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrganizationMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrganizationsRequest(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        min_access_level: int = None,
    ):
        self.access_level = access_level
        self.min_access_level = min_access_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.min_access_level is not None:
            result['minAccessLevel'] = self.min_access_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('minAccessLevel') is not None:
            self.min_access_level = m.get('minAccessLevel')
        return self


class ListOrganizationsResponseBodyResult(TeaModel):
    def __init__(
        self,
        access_level: int = None,
        id: int = None,
        organization_id: str = None,
        organization_name: str = None,
        organization_role: str = None,
    ):
        self.access_level = access_level
        self.id = id
        self.organization_id = organization_id
        self.organization_name = organization_name
        self.organization_role = organization_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.id is not None:
            result['id'] = self.id
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.organization_name is not None:
            result['organizationName'] = self.organization_name
        if self.organization_role is not None:
            result['organizationRole'] = self.organization_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('organizationName') is not None:
            self.organization_name = m.get('organizationName')
        if m.get('organizationRole') is not None:
            self.organization_role = m.get('organizationRole')
        return self


class ListOrganizationsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListOrganizationsResponseBodyResult] = None,
        success: bool = None,
        total: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success
        self.total = total

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListOrganizationsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ListOrganizationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrganizationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrganizationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineGroupPipelinesRequest(TeaModel):
    def __init__(
        self,
        create_end_time: int = None,
        create_start_time: int = None,
        execute_end_time: int = None,
        execute_start_time: int = None,
        max_results: int = None,
        next_token: str = None,
        pipeline_name: str = None,
        result_status_list: str = None,
    ):
        self.create_end_time = create_end_time
        self.create_start_time = create_start_time
        self.execute_end_time = execute_end_time
        self.execute_start_time = execute_start_time
        self.max_results = max_results
        self.next_token = next_token
        self.pipeline_name = pipeline_name
        self.result_status_list = result_status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_end_time is not None:
            result['createEndTime'] = self.create_end_time
        if self.create_start_time is not None:
            result['createStartTime'] = self.create_start_time
        if self.execute_end_time is not None:
            result['executeEndTime'] = self.execute_end_time
        if self.execute_start_time is not None:
            result['executeStartTime'] = self.execute_start_time
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.pipeline_name is not None:
            result['pipelineName'] = self.pipeline_name
        if self.result_status_list is not None:
            result['resultStatusList'] = self.result_status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createEndTime') is not None:
            self.create_end_time = m.get('createEndTime')
        if m.get('createStartTime') is not None:
            self.create_start_time = m.get('createStartTime')
        if m.get('executeEndTime') is not None:
            self.execute_end_time = m.get('executeEndTime')
        if m.get('executeStartTime') is not None:
            self.execute_start_time = m.get('executeStartTime')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('pipelineName') is not None:
            self.pipeline_name = m.get('pipelineName')
        if m.get('resultStatusList') is not None:
            self.result_status_list = m.get('resultStatusList')
        return self


class ListPipelineGroupPipelinesResponseBodyPipelines(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        pipeline_id: int = None,
        pipeline_name: str = None,
    ):
        self.create_time = create_time
        self.pipeline_id = pipeline_id
        self.pipeline_name = pipeline_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.pipeline_id is not None:
            result['pipelineId'] = self.pipeline_id
        if self.pipeline_name is not None:
            result['pipelineName'] = self.pipeline_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('pipelineId') is not None:
            self.pipeline_id = m.get('pipelineId')
        if m.get('pipelineName') is not None:
            self.pipeline_name = m.get('pipelineName')
        return self


class ListPipelineGroupPipelinesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        next_token: str = None,
        pipelines: List[ListPipelineGroupPipelinesResponseBodyPipelines] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.next_token = next_token
        self.pipelines = pipelines
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.pipelines:
            for k in self.pipelines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['pipelines'] = []
        if self.pipelines is not None:
            for k in self.pipelines:
                result['pipelines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.pipelines = []
        if m.get('pipelines') is not None:
            for k in m.get('pipelines'):
                temp_model = ListPipelineGroupPipelinesResponseBodyPipelines()
                self.pipelines.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListPipelineGroupPipelinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineGroupPipelinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineGroupPipelinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineGroupsRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
    ):
        self.max_results = max_results
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        return self


class ListPipelineGroupsResponseBodyPipelineGroups(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        id: int = None,
        name: str = None,
    ):
        self.create_time = create_time
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListPipelineGroupsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        next_token: str = None,
        pipeline_groups: List[ListPipelineGroupsResponseBodyPipelineGroups] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.next_token = next_token
        self.pipeline_groups = pipeline_groups
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.pipeline_groups:
            for k in self.pipeline_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['pipelineGroups'] = []
        if self.pipeline_groups is not None:
            for k in self.pipeline_groups:
                result['pipelineGroups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.pipeline_groups = []
        if m.get('pipelineGroups') is not None:
            for k in m.get('pipelineGroups'):
                temp_model = ListPipelineGroupsResponseBodyPipelineGroups()
                self.pipeline_groups.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListPipelineGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineJobHistorysRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        identifier: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        self.category = category
        self.identifier = identifier
        self.max_results = max_results
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        return self


class ListPipelineJobHistorysResponseBodyJobs(TeaModel):
    def __init__(
        self,
        execute_number: int = None,
        identifier: str = None,
        job_id: int = None,
        job_name: str = None,
        operator_account_id: str = None,
        pipeline_id: int = None,
        pipeline_run_id: int = None,
        sources: str = None,
        status: str = None,
    ):
        self.execute_number = execute_number
        self.identifier = identifier
        self.job_id = job_id
        self.job_name = job_name
        self.operator_account_id = operator_account_id
        self.pipeline_id = pipeline_id
        self.pipeline_run_id = pipeline_run_id
        self.sources = sources
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execute_number is not None:
            result['executeNumber'] = self.execute_number
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.job_id is not None:
            result['jobId'] = self.job_id
        if self.job_name is not None:
            result['jobName'] = self.job_name
        if self.operator_account_id is not None:
            result['operatorAccountId'] = self.operator_account_id
        if self.pipeline_id is not None:
            result['pipelineId'] = self.pipeline_id
        if self.pipeline_run_id is not None:
            result['pipelineRunId'] = self.pipeline_run_id
        if self.sources is not None:
            result['sources'] = self.sources
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executeNumber') is not None:
            self.execute_number = m.get('executeNumber')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('jobId') is not None:
            self.job_id = m.get('jobId')
        if m.get('jobName') is not None:
            self.job_name = m.get('jobName')
        if m.get('operatorAccountId') is not None:
            self.operator_account_id = m.get('operatorAccountId')
        if m.get('pipelineId') is not None:
            self.pipeline_id = m.get('pipelineId')
        if m.get('pipelineRunId') is not None:
            self.pipeline_run_id = m.get('pipelineRunId')
        if m.get('sources') is not None:
            self.sources = m.get('sources')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ListPipelineJobHistorysResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        jobs: List[ListPipelineJobHistorysResponseBodyJobs] = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.jobs = jobs
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['jobs'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.jobs = []
        if m.get('jobs') is not None:
            for k in m.get('jobs'):
                temp_model = ListPipelineJobHistorysResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListPipelineJobHistorysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineJobHistorysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineJobHistorysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineJobsRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
    ):
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        return self


class ListPipelineJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        job_name: str = None,
        last_job_id: int = None,
        last_job_params: str = None,
    ):
        self.identifier = identifier
        self.job_name = job_name
        self.last_job_id = last_job_id
        self.last_job_params = last_job_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.job_name is not None:
            result['jobName'] = self.job_name
        if self.last_job_id is not None:
            result['lastJobId'] = self.last_job_id
        if self.last_job_params is not None:
            result['lastJobParams'] = self.last_job_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('jobName') is not None:
            self.job_name = m.get('jobName')
        if m.get('lastJobId') is not None:
            self.last_job_id = m.get('lastJobId')
        if m.get('lastJobParams') is not None:
            self.last_job_params = m.get('lastJobParams')
        return self


class ListPipelineJobsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        jobs: List[ListPipelineJobsResponseBodyJobs] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.jobs = jobs
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['jobs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.jobs = []
        if m.get('jobs') is not None:
            for k in m.get('jobs'):
                temp_model = ListPipelineJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListPipelineJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineRelationsRequest(TeaModel):
    def __init__(
        self,
        rel_object_type: str = None,
    ):
        self.rel_object_type = rel_object_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rel_object_type is not None:
            result['relObjectType'] = self.rel_object_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('relObjectType') is not None:
            self.rel_object_type = m.get('relObjectType')
        return self


class ListPipelineRelationsResponseBodyPipelineRelations(TeaModel):
    def __init__(
        self,
        ref_object_id: int = None,
    ):
        self.ref_object_id = ref_object_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ref_object_id is not None:
            result['refObjectId'] = self.ref_object_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('refObjectId') is not None:
            self.ref_object_id = m.get('refObjectId')
        return self


class ListPipelineRelationsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        pipeline_relations: List[ListPipelineRelationsResponseBodyPipelineRelations] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.pipeline_relations = pipeline_relations
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.pipeline_relations:
            for k in self.pipeline_relations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        result['pipelineRelations'] = []
        if self.pipeline_relations is not None:
            for k in self.pipeline_relations:
                result['pipelineRelations'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        self.pipeline_relations = []
        if m.get('pipelineRelations') is not None:
            for k in m.get('pipelineRelations'):
                temp_model = ListPipelineRelationsResponseBodyPipelineRelations()
                self.pipeline_relations.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListPipelineRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineRelationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelineRunsRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        max_results: int = None,
        next_token: str = None,
        start_time: int = None,
        status: str = None,
        trigger_mode: int = None,
    ):
        self.end_time = end_time
        self.max_results = max_results
        self.next_token = next_token
        self.start_time = start_time
        self.status = status
        self.trigger_mode = trigger_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.trigger_mode is not None:
            result['triggerMode'] = self.trigger_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('triggerMode') is not None:
            self.trigger_mode = m.get('triggerMode')
        return self


class ListPipelineRunsResponseBodyPipelineRuns(TeaModel):
    def __init__(
        self,
        creator_account_id: str = None,
        end_time: int = None,
        pipeline_id: int = None,
        pipeline_run_id: int = None,
        start_time: int = None,
        status: str = None,
        trigger_mode: int = None,
    ):
        self.creator_account_id = creator_account_id
        self.end_time = end_time
        self.pipeline_id = pipeline_id
        self.pipeline_run_id = pipeline_run_id
        self.start_time = start_time
        self.status = status
        self.trigger_mode = trigger_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.pipeline_id is not None:
            result['pipelineId'] = self.pipeline_id
        if self.pipeline_run_id is not None:
            result['pipelineRunId'] = self.pipeline_run_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.trigger_mode is not None:
            result['triggerMode'] = self.trigger_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('pipelineId') is not None:
            self.pipeline_id = m.get('pipelineId')
        if m.get('pipelineRunId') is not None:
            self.pipeline_run_id = m.get('pipelineRunId')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('triggerMode') is not None:
            self.trigger_mode = m.get('triggerMode')
        return self


class ListPipelineRunsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        next_token: str = None,
        pipeline_runs: List[ListPipelineRunsResponseBodyPipelineRuns] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.next_token = next_token
        self.pipeline_runs = pipeline_runs
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.pipeline_runs:
            for k in self.pipeline_runs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['pipelineRuns'] = []
        if self.pipeline_runs is not None:
            for k in self.pipeline_runs:
                result['pipelineRuns'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.pipeline_runs = []
        if m.get('pipelineRuns') is not None:
            for k in m.get('pipelineRuns'):
                temp_model = ListPipelineRunsResponseBodyPipelineRuns()
                self.pipeline_runs.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListPipelineRunsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelineRunsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelineRunsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelinesRequest(TeaModel):
    def __init__(
        self,
        create_end_time: int = None,
        create_start_time: int = None,
        creator_account_ids: str = None,
        execute_account_ids: str = None,
        execute_end_time: int = None,
        execute_start_time: int = None,
        max_results: int = None,
        next_token: str = None,
        pipeline_name: str = None,
        status_list: str = None,
    ):
        self.create_end_time = create_end_time
        self.create_start_time = create_start_time
        self.creator_account_ids = creator_account_ids
        self.execute_account_ids = execute_account_ids
        self.execute_end_time = execute_end_time
        self.execute_start_time = execute_start_time
        self.max_results = max_results
        self.next_token = next_token
        self.pipeline_name = pipeline_name
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_end_time is not None:
            result['createEndTime'] = self.create_end_time
        if self.create_start_time is not None:
            result['createStartTime'] = self.create_start_time
        if self.creator_account_ids is not None:
            result['creatorAccountIds'] = self.creator_account_ids
        if self.execute_account_ids is not None:
            result['executeAccountIds'] = self.execute_account_ids
        if self.execute_end_time is not None:
            result['executeEndTime'] = self.execute_end_time
        if self.execute_start_time is not None:
            result['executeStartTime'] = self.execute_start_time
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.pipeline_name is not None:
            result['pipelineName'] = self.pipeline_name
        if self.status_list is not None:
            result['statusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createEndTime') is not None:
            self.create_end_time = m.get('createEndTime')
        if m.get('createStartTime') is not None:
            self.create_start_time = m.get('createStartTime')
        if m.get('creatorAccountIds') is not None:
            self.creator_account_ids = m.get('creatorAccountIds')
        if m.get('executeAccountIds') is not None:
            self.execute_account_ids = m.get('executeAccountIds')
        if m.get('executeEndTime') is not None:
            self.execute_end_time = m.get('executeEndTime')
        if m.get('executeStartTime') is not None:
            self.execute_start_time = m.get('executeStartTime')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('pipelineName') is not None:
            self.pipeline_name = m.get('pipelineName')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        return self


class ListPipelinesResponseBodyPipelines(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        creator_account_id: str = None,
        group_id: int = None,
        pipeline_id: int = None,
        pipeline_name: str = None,
    ):
        self.create_time = create_time
        self.creator_account_id = creator_account_id
        self.group_id = group_id
        self.pipeline_id = pipeline_id
        self.pipeline_name = pipeline_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.creator_account_id is not None:
            result['creatorAccountId'] = self.creator_account_id
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.pipeline_id is not None:
            result['pipelineId'] = self.pipeline_id
        if self.pipeline_name is not None:
            result['pipelineName'] = self.pipeline_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('creatorAccountId') is not None:
            self.creator_account_id = m.get('creatorAccountId')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('pipelineId') is not None:
            self.pipeline_id = m.get('pipelineId')
        if m.get('pipelineName') is not None:
            self.pipeline_name = m.get('pipelineName')
        return self


class ListPipelinesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        next_token: str = None,
        pipelines: List[ListPipelinesResponseBodyPipelines] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.next_token = next_token
        self.pipelines = pipelines
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.pipelines:
            for k in self.pipelines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['pipelines'] = []
        if self.pipelines is not None:
            for k in self.pipelines:
                result['pipelines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.pipelines = []
        if m.get('pipelines') is not None:
            for k in m.get('pipelines'):
                temp_model = ListPipelinesResponseBodyPipelines()
                self.pipelines.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListPipelinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProjectMembersRequest(TeaModel):
    def __init__(
        self,
        target_type: str = None,
    ):
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_type is not None:
            result['targetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('targetType') is not None:
            self.target_type = m.get('targetType')
        return self


class ListProjectMembersResponseBodyMembersDivision(TeaModel):
    def __init__(
        self,
        identifier: str = None,
    ):
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        return self


class ListProjectMembersResponseBodyMembersOrganizationUserInfo(TeaModel):
    def __init__(
        self,
        organization_identifier: str = None,
    ):
        self.organization_identifier = organization_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organization_identifier is not None:
            result['organizationIdentifier'] = self.organization_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('organizationIdentifier') is not None:
            self.organization_identifier = m.get('organizationIdentifier')
        return self


class ListProjectMembersResponseBodyMembers(TeaModel):
    def __init__(
        self,
        account: str = None,
        avatar: str = None,
        ding_talk_id: str = None,
        display_name: str = None,
        display_nick_name: str = None,
        display_real_name: str = None,
        division: ListProjectMembersResponseBodyMembersDivision = None,
        email: str = None,
        gender: str = None,
        identifier: str = None,
        mobile: str = None,
        name_en: str = None,
        nick_name: str = None,
        nick_name_pinyin: str = None,
        organization_user_info: ListProjectMembersResponseBodyMembersOrganizationUserInfo = None,
        real_name: str = None,
        real_name_pinyin: str = None,
        role_name: str = None,
        stamp: str = None,
        tb_role_id: str = None,
    ):
        self.account = account
        self.avatar = avatar
        self.ding_talk_id = ding_talk_id
        self.display_name = display_name
        self.display_nick_name = display_nick_name
        self.display_real_name = display_real_name
        self.division = division
        self.email = email
        self.gender = gender
        self.identifier = identifier
        self.mobile = mobile
        self.name_en = name_en
        self.nick_name = nick_name
        self.nick_name_pinyin = nick_name_pinyin
        self.organization_user_info = organization_user_info
        self.real_name = real_name
        self.real_name_pinyin = real_name_pinyin
        # 角色名称
        self.role_name = role_name
        self.stamp = stamp
        self.tb_role_id = tb_role_id

    def validate(self):
        if self.division:
            self.division.validate()
        if self.organization_user_info:
            self.organization_user_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['account'] = self.account
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.ding_talk_id is not None:
            result['dingTalkId'] = self.ding_talk_id
        if self.display_name is not None:
            result['displayName'] = self.display_name
        if self.display_nick_name is not None:
            result['displayNickName'] = self.display_nick_name
        if self.display_real_name is not None:
            result['displayRealName'] = self.display_real_name
        if self.division is not None:
            result['division'] = self.division.to_map()
        if self.email is not None:
            result['email'] = self.email
        if self.gender is not None:
            result['gender'] = self.gender
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name_en is not None:
            result['nameEn'] = self.name_en
        if self.nick_name is not None:
            result['nickName'] = self.nick_name
        if self.nick_name_pinyin is not None:
            result['nickNamePinyin'] = self.nick_name_pinyin
        if self.organization_user_info is not None:
            result['organizationUserInfo'] = self.organization_user_info.to_map()
        if self.real_name is not None:
            result['realName'] = self.real_name
        if self.real_name_pinyin is not None:
            result['realNamePinyin'] = self.real_name_pinyin
        if self.role_name is not None:
            result['roleName'] = self.role_name
        if self.stamp is not None:
            result['stamp'] = self.stamp
        if self.tb_role_id is not None:
            result['tbRoleId'] = self.tb_role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('dingTalkId') is not None:
            self.ding_talk_id = m.get('dingTalkId')
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        if m.get('displayNickName') is not None:
            self.display_nick_name = m.get('displayNickName')
        if m.get('displayRealName') is not None:
            self.display_real_name = m.get('displayRealName')
        if m.get('division') is not None:
            temp_model = ListProjectMembersResponseBodyMembersDivision()
            self.division = temp_model.from_map(m['division'])
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('nameEn') is not None:
            self.name_en = m.get('nameEn')
        if m.get('nickName') is not None:
            self.nick_name = m.get('nickName')
        if m.get('nickNamePinyin') is not None:
            self.nick_name_pinyin = m.get('nickNamePinyin')
        if m.get('organizationUserInfo') is not None:
            temp_model = ListProjectMembersResponseBodyMembersOrganizationUserInfo()
            self.organization_user_info = temp_model.from_map(m['organizationUserInfo'])
        if m.get('realName') is not None:
            self.real_name = m.get('realName')
        if m.get('realNamePinyin') is not None:
            self.real_name_pinyin = m.get('realNamePinyin')
        if m.get('roleName') is not None:
            self.role_name = m.get('roleName')
        if m.get('stamp') is not None:
            self.stamp = m.get('stamp')
        if m.get('tbRoleId') is not None:
            self.tb_role_id = m.get('tbRoleId')
        return self


class ListProjectMembersResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        members: List[ListProjectMembersResponseBodyMembers] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.members = members
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        result['members'] = []
        if self.members is not None:
            for k in self.members:
                result['members'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        self.members = []
        if m.get('members') is not None:
            for k in m.get('members'):
                temp_model = ListProjectMembersResponseBodyMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListProjectMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListProjectMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListProjectMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProjectTemplatesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
    ):
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        return self


class ListProjectTemplatesResponseBodyTemplates(TeaModel):
    def __init__(
        self,
        copy_from: str = None,
        creator: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        icon: str = None,
        identifier: str = None,
        modifier: str = None,
        name: str = None,
        name_en: str = None,
        resource_category: str = None,
        resource_type: str = None,
        space_identifier: str = None,
        space_type: str = None,
        type: int = None,
    ):
        self.copy_from = copy_from
        self.creator = creator
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.icon = icon
        self.identifier = identifier
        self.modifier = modifier
        self.name = name
        self.name_en = name_en
        self.resource_category = resource_category
        self.resource_type = resource_type
        self.space_identifier = space_identifier
        self.space_type = space_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.copy_from is not None:
            result['copyFrom'] = self.copy_from
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.icon is not None:
            result['icon'] = self.icon
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.name is not None:
            result['name'] = self.name
        if self.name_en is not None:
            result['nameEn'] = self.name_en
        if self.resource_category is not None:
            result['resourceCategory'] = self.resource_category
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.space_identifier is not None:
            result['spaceIdentifier'] = self.space_identifier
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('copyFrom') is not None:
            self.copy_from = m.get('copyFrom')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameEn') is not None:
            self.name_en = m.get('nameEn')
        if m.get('resourceCategory') is not None:
            self.resource_category = m.get('resourceCategory')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('spaceIdentifier') is not None:
            self.space_identifier = m.get('spaceIdentifier')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListProjectTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        request_id: str = None,
        success: bool = None,
        templates: List[ListProjectTemplatesResponseBodyTemplates] = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.request_id = request_id
        self.success = success
        self.templates = templates

    def validate(self):
        if self.templates:
            for k in self.templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        result['templates'] = []
        if self.templates is not None:
            for k in self.templates:
                result['templates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.templates = []
        if m.get('templates') is not None:
            for k in m.get('templates'):
                temp_model = ListProjectTemplatesResponseBodyTemplates()
                self.templates.append(temp_model.from_map(k))
        return self


class ListProjectTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListProjectTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListProjectTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProjectWorkitemTypesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        space_type: str = None,
    ):
        self.category = category
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        return self


class ListProjectWorkitemTypesResponseBodyWorkitemTypes(TeaModel):
    def __init__(
        self,
        add_user: str = None,
        category_identifier: str = None,
        creator: str = None,
        default_type: bool = None,
        description: str = None,
        enable: bool = None,
        gmt_add: int = None,
        gmt_create: int = None,
        identifier: str = None,
        name: str = None,
        name_en: str = None,
        system_default: bool = None,
    ):
        self.add_user = add_user
        self.category_identifier = category_identifier
        self.creator = creator
        self.default_type = default_type
        self.description = description
        self.enable = enable
        self.gmt_add = gmt_add
        self.gmt_create = gmt_create
        self.identifier = identifier
        self.name = name
        self.name_en = name_en
        self.system_default = system_default

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_user is not None:
            result['addUser'] = self.add_user
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        if self.default_type is not None:
            result['defaultType'] = self.default_type
        if self.description is not None:
            result['description'] = self.description
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_add is not None:
            result['gmtAdd'] = self.gmt_add
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.name is not None:
            result['name'] = self.name
        if self.name_en is not None:
            result['nameEn'] = self.name_en
        if self.system_default is not None:
            result['systemDefault'] = self.system_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addUser') is not None:
            self.add_user = m.get('addUser')
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('defaultType') is not None:
            self.default_type = m.get('defaultType')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmtAdd') is not None:
            self.gmt_add = m.get('gmtAdd')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameEn') is not None:
            self.name_en = m.get('nameEn')
        if m.get('systemDefault') is not None:
            self.system_default = m.get('systemDefault')
        return self


class ListProjectWorkitemTypesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        workitem_types: List[ListProjectWorkitemTypesResponseBodyWorkitemTypes] = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.workitem_types = workitem_types

    def validate(self):
        if self.workitem_types:
            for k in self.workitem_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        result['workitemTypes'] = []
        if self.workitem_types is not None:
            for k in self.workitem_types:
                result['workitemTypes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.workitem_types = []
        if m.get('workitemTypes') is not None:
            for k in m.get('workitemTypes'):
                temp_model = ListProjectWorkitemTypesResponseBodyWorkitemTypes()
                self.workitem_types.append(temp_model.from_map(k))
        return self


class ListProjectWorkitemTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListProjectWorkitemTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListProjectWorkitemTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProjectsRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        conditions: str = None,
        extra_conditions: str = None,
        max_results: int = None,
        next_token: str = None,
        scope: str = None,
    ):
        self.category = category
        # {"conditionGroups":[[]]}
        self.conditions = conditions
        self.extra_conditions = extra_conditions
        self.max_results = max_results
        self.next_token = next_token
        self.scope = scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.conditions is not None:
            result['conditions'] = self.conditions
        if self.extra_conditions is not None:
            result['extraConditions'] = self.extra_conditions
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.scope is not None:
            result['scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('conditions') is not None:
            self.conditions = m.get('conditions')
        if m.get('extraConditions') is not None:
            self.extra_conditions = m.get('extraConditions')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        return self


class ListProjectsResponseBodyProjects(TeaModel):
    def __init__(
        self,
        category_identifier: str = None,
        creator: str = None,
        custom_code: str = None,
        delete_time: int = None,
        description: str = None,
        gmt_create: int = None,
        icon: str = None,
        identifier: str = None,
        logical_status: str = None,
        name: str = None,
        scope: str = None,
        status_stage_identifier: str = None,
        type_identifier: str = None,
    ):
        self.category_identifier = category_identifier
        self.creator = creator
        self.custom_code = custom_code
        self.delete_time = delete_time
        self.description = description
        self.gmt_create = gmt_create
        self.icon = icon
        self.identifier = identifier
        self.logical_status = logical_status
        self.name = name
        self.scope = scope
        self.status_stage_identifier = status_stage_identifier
        self.type_identifier = type_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_identifier is not None:
            result['categoryIdentifier'] = self.category_identifier
        if self.creator is not None:
            result['creator'] = self.creator
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.delete_time is not None:
            result['deleteTime'] = self.delete_time
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.icon is not None:
            result['icon'] = self.icon
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.logical_status is not None:
            result['logicalStatus'] = self.logical_status
        if self.name is not None:
            result['name'] = self.name
        if self.scope is not None:
            result['scope'] = self.scope
        if self.status_stage_identifier is not None:
            result['statusStageIdentifier'] = self.status_stage_identifier
        if self.type_identifier is not None:
            result['typeIdentifier'] = self.type_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('categoryIdentifier') is not None:
            self.category_identifier = m.get('categoryIdentifier')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('deleteTime') is not None:
            self.delete_time = m.get('deleteTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('logicalStatus') is not None:
            self.logical_status = m.get('logicalStatus')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('statusStageIdentifier') is not None:
            self.status_stage_identifier = m.get('statusStageIdentifier')
        if m.get('typeIdentifier') is not None:
            self.type_identifier = m.get('typeIdentifier')
        return self


class ListProjectsResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_msg: str = None,
        max_results: int = None,
        next_token: str = None,
        projects: List[ListProjectsResponseBodyProjects] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.error_code = error_code
        self.error_msg = error_msg
        self.max_results = max_results
        self.next_token = next_token
        self.projects = projects
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.projects:
            for k in self.projects:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['projects'] = []
        if self.projects is not None:
            for k in self.projects:
                result['projects'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.projects = []
        if m.get('projects') is not None:
            for k in m.get('projects'):
                temp_model = ListProjectsResponseBodyProjects()
                self.projects.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListProjectsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProtectedBranchesRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class ListProtectedBranchesResponseBodyResultAllowMergeUsers(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        username: str = None,
    ):
        self.avatar = avatar
        self.email = email
        self.id = id
        self.name = name
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListProtectedBranchesResponseBodyResultAllowPushUsers(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        username: str = None,
    ):
        self.avatar = avatar
        self.email = email
        self.id = id
        self.name = name
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListProtectedBranchesResponseBodyResultMergeRequestSettingDefaultAssignees(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        email: str = None,
        id: int = None,
        name: str = None,
        username: str = None,
    ):
        self.avatar = avatar
        self.email = email
        self.id = id
        self.name = name
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.email is not None:
            result['email'] = self.email
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class ListProtectedBranchesResponseBodyResultMergeRequestSetting(TeaModel):
    def __init__(
        self,
        allow_merge_request_roles: List[int] = None,
        default_assignees: List[ListProtectedBranchesResponseBodyResultMergeRequestSettingDefaultAssignees] = None,
        is_allow_self_approval: bool = None,
        is_require_discussion_processed: bool = None,
        is_required: bool = None,
        is_reset_approval_when_new_push: bool = None,
        minimum_approval: int = None,
        mr_mode: str = None,
        white_list: str = None,
    ):
        self.allow_merge_request_roles = allow_merge_request_roles
        self.default_assignees = default_assignees
        self.is_allow_self_approval = is_allow_self_approval
        self.is_require_discussion_processed = is_require_discussion_processed
        self.is_required = is_required
        self.is_reset_approval_when_new_push = is_reset_approval_when_new_push
        self.minimum_approval = minimum_approval
        self.mr_mode = mr_mode
        self.white_list = white_list

    def validate(self):
        if self.default_assignees:
            for k in self.default_assignees:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_merge_request_roles is not None:
            result['allowMergeRequestRoles'] = self.allow_merge_request_roles
        result['defaultAssignees'] = []
        if self.default_assignees is not None:
            for k in self.default_assignees:
                result['defaultAssignees'].append(k.to_map() if k else None)
        if self.is_allow_self_approval is not None:
            result['isAllowSelfApproval'] = self.is_allow_self_approval
        if self.is_require_discussion_processed is not None:
            result['isRequireDiscussionProcessed'] = self.is_require_discussion_processed
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.is_reset_approval_when_new_push is not None:
            result['isResetApprovalWhenNewPush'] = self.is_reset_approval_when_new_push
        if self.minimum_approval is not None:
            result['minimumApproval'] = self.minimum_approval
        if self.mr_mode is not None:
            result['mrMode'] = self.mr_mode
        if self.white_list is not None:
            result['whiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowMergeRequestRoles') is not None:
            self.allow_merge_request_roles = m.get('allowMergeRequestRoles')
        self.default_assignees = []
        if m.get('defaultAssignees') is not None:
            for k in m.get('defaultAssignees'):
                temp_model = ListProtectedBranchesResponseBodyResultMergeRequestSettingDefaultAssignees()
                self.default_assignees.append(temp_model.from_map(k))
        if m.get('isAllowSelfApproval') is not None:
            self.is_allow_self_approval = m.get('isAllowSelfApproval')
        if m.get('isRequireDiscussionProcessed') is not None:
            self.is_require_discussion_processed = m.get('isRequireDiscussionProcessed')
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('isResetApprovalWhenNewPush') is not None:
            self.is_reset_approval_when_new_push = m.get('isResetApprovalWhenNewPush')
        if m.get('minimumApproval') is not None:
            self.minimum_approval = m.get('minimumApproval')
        if m.get('mrMode') is not None:
            self.mr_mode = m.get('mrMode')
        if m.get('whiteList') is not None:
            self.white_list = m.get('whiteList')
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfigCheckItems(TeaModel):
    def __init__(
        self,
        is_required: bool = None,
        name: str = None,
    ):
        self.is_required = is_required
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfig(TeaModel):
    def __init__(
        self,
        check_items: List[ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfigCheckItems] = None,
    ):
        self.check_items = check_items

    def validate(self):
        if self.check_items:
            for k in self.check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['checkItems'] = []
        if self.check_items is not None:
            for k in self.check_items:
                result['checkItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_items = []
        if m.get('checkItems') is not None:
            for k in m.get('checkItems'):
                temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfigCheckItems()
                self.check_items.append(temp_model.from_map(k))
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTOCheckTaskQualityConfig(TeaModel):
    def __init__(
        self,
        biz_no: str = None,
        enabled: bool = None,
        message: str = None,
        task_name: str = None,
    ):
        self.biz_no = biz_no
        self.enabled = enabled
        self.message = message
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_no is not None:
            result['bizNo'] = self.biz_no
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        if self.task_name is not None:
            result['taskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizNo') is not None:
            self.biz_no = m.get('bizNo')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('taskName') is not None:
            self.task_name = m.get('taskName')
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTOCodeGuidelinesDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTOSensitiveInfoDetection(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        message: str = None,
    ):
        self.enabled = enabled
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class ListProtectedBranchesResponseBodyResultTestSettingDTO(TeaModel):
    def __init__(
        self,
        check_config: ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfig = None,
        check_task_quality_config: ListProtectedBranchesResponseBodyResultTestSettingDTOCheckTaskQualityConfig = None,
        code_guidelines_detection: ListProtectedBranchesResponseBodyResultTestSettingDTOCodeGuidelinesDetection = None,
        is_required: bool = None,
        sensitive_info_detection: ListProtectedBranchesResponseBodyResultTestSettingDTOSensitiveInfoDetection = None,
    ):
        self.check_config = check_config
        self.check_task_quality_config = check_task_quality_config
        self.code_guidelines_detection = code_guidelines_detection
        self.is_required = is_required
        self.sensitive_info_detection = sensitive_info_detection

    def validate(self):
        if self.check_config:
            self.check_config.validate()
        if self.check_task_quality_config:
            self.check_task_quality_config.validate()
        if self.code_guidelines_detection:
            self.code_guidelines_detection.validate()
        if self.sensitive_info_detection:
            self.sensitive_info_detection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_config is not None:
            result['checkConfig'] = self.check_config.to_map()
        if self.check_task_quality_config is not None:
            result['checkTaskQualityConfig'] = self.check_task_quality_config.to_map()
        if self.code_guidelines_detection is not None:
            result['codeGuidelinesDetection'] = self.code_guidelines_detection.to_map()
        if self.is_required is not None:
            result['isRequired'] = self.is_required
        if self.sensitive_info_detection is not None:
            result['sensitiveInfoDetection'] = self.sensitive_info_detection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkConfig') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTOCheckConfig()
            self.check_config = temp_model.from_map(m['checkConfig'])
        if m.get('checkTaskQualityConfig') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTOCheckTaskQualityConfig()
            self.check_task_quality_config = temp_model.from_map(m['checkTaskQualityConfig'])
        if m.get('codeGuidelinesDetection') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTOCodeGuidelinesDetection()
            self.code_guidelines_detection = temp_model.from_map(m['codeGuidelinesDetection'])
        if m.get('isRequired') is not None:
            self.is_required = m.get('isRequired')
        if m.get('sensitiveInfoDetection') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTOSensitiveInfoDetection()
            self.sensitive_info_detection = temp_model.from_map(m['sensitiveInfoDetection'])
        return self


class ListProtectedBranchesResponseBodyResult(TeaModel):
    def __init__(
        self,
        allow_merge_roles: List[int] = None,
        allow_merge_user_ids: List[int] = None,
        allow_merge_users: List[ListProtectedBranchesResponseBodyResultAllowMergeUsers] = None,
        allow_push_roles: List[int] = None,
        allow_push_user_ids: List[int] = None,
        allow_push_users: List[ListProtectedBranchesResponseBodyResultAllowPushUsers] = None,
        branch: str = None,
        created_at: str = None,
        id: int = None,
        matches: List[str] = None,
        merge_request_setting: ListProtectedBranchesResponseBodyResultMergeRequestSetting = None,
        test_setting_dto: ListProtectedBranchesResponseBodyResultTestSettingDTO = None,
        updated_at: str = None,
    ):
        self.allow_merge_roles = allow_merge_roles
        self.allow_merge_user_ids = allow_merge_user_ids
        self.allow_merge_users = allow_merge_users
        self.allow_push_roles = allow_push_roles
        self.allow_push_user_ids = allow_push_user_ids
        self.allow_push_users = allow_push_users
        self.branch = branch
        self.created_at = created_at
        self.id = id
        self.matches = matches
        self.merge_request_setting = merge_request_setting
        self.test_setting_dto = test_setting_dto
        self.updated_at = updated_at

    def validate(self):
        if self.allow_merge_users:
            for k in self.allow_merge_users:
                if k:
                    k.validate()
        if self.allow_push_users:
            for k in self.allow_push_users:
                if k:
                    k.validate()
        if self.merge_request_setting:
            self.merge_request_setting.validate()
        if self.test_setting_dto:
            self.test_setting_dto.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_merge_roles is not None:
            result['allowMergeRoles'] = self.allow_merge_roles
        if self.allow_merge_user_ids is not None:
            result['allowMergeUserIds'] = self.allow_merge_user_ids
        result['allowMergeUsers'] = []
        if self.allow_merge_users is not None:
            for k in self.allow_merge_users:
                result['allowMergeUsers'].append(k.to_map() if k else None)
        if self.allow_push_roles is not None:
            result['allowPushRoles'] = self.allow_push_roles
        if self.allow_push_user_ids is not None:
            result['allowPushUserIds'] = self.allow_push_user_ids
        result['allowPushUsers'] = []
        if self.allow_push_users is not None:
            for k in self.allow_push_users:
                result['allowPushUsers'].append(k.to_map() if k else None)
        if self.branch is not None:
            result['branch'] = self.branch
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.id is not None:
            result['id'] = self.id
        if self.matches is not None:
            result['matches'] = self.matches
        if self.merge_request_setting is not None:
            result['mergeRequestSetting'] = self.merge_request_setting.to_map()
        if self.test_setting_dto is not None:
            result['testSettingDTO'] = self.test_setting_dto.to_map()
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowMergeRoles') is not None:
            self.allow_merge_roles = m.get('allowMergeRoles')
        if m.get('allowMergeUserIds') is not None:
            self.allow_merge_user_ids = m.get('allowMergeUserIds')
        self.allow_merge_users = []
        if m.get('allowMergeUsers') is not None:
            for k in m.get('allowMergeUsers'):
                temp_model = ListProtectedBranchesResponseBodyResultAllowMergeUsers()
                self.allow_merge_users.append(temp_model.from_map(k))
        if m.get('allowPushRoles') is not None:
            self.allow_push_roles = m.get('allowPushRoles')
        if m.get('allowPushUserIds') is not None:
            self.allow_push_user_ids = m.get('allowPushUserIds')
        self.allow_push_users = []
        if m.get('allowPushUsers') is not None:
            for k in m.get('allowPushUsers'):
                temp_model = ListProtectedBranchesResponseBodyResultAllowPushUsers()
                self.allow_push_users.append(temp_model.from_map(k))
        if m.get('branch') is not None:
            self.branch = m.get('branch')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('matches') is not None:
            self.matches = m.get('matches')
        if m.get('mergeRequestSetting') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultMergeRequestSetting()
            self.merge_request_setting = temp_model.from_map(m['mergeRequestSetting'])
        if m.get('testSettingDTO') is not None:
            temp_model = ListProtectedBranchesResponseBodyResultTestSettingDTO()
            self.test_setting_dto = temp_model.from_map(m['testSettingDTO'])
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        return self


class ListProtectedBranchesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListProtectedBranchesResponseBodyResult] = None,
        success: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListProtectedBranchesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListProtectedBranchesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListProtectedBranchesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListProtectedBranchesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPushRulesRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        organization_id: str = None,
    ):
        self.access_token = access_token
        self.organization_id = organization_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        return self


class ListPushRulesResponseBodyResultRuleInfos(TeaModel):
    def __init__(
        self,
        checker_name: str = None,
        checker_type: str = None,
        extra_message: str = None,
        file_rule_regexes: List[str] = None,
    ):
        self.checker_name = checker_name
        self.checker_type = checker_type
        self.extra_message = extra_message
        self.file_rule_regexes = file_rule_regexes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_name is not None:
            result['checkerName'] = self.checker_name
        if self.checker_type is not None:
            result['checkerType'] = self.checker_type
        if self.extra_message is not None:
            result['extraMessage'] = self.extra_message
        if self.file_rule_regexes is not None:
            result['fileRuleRegexes'] = self.file_rule_regexes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('checkerName') is not None:
            self.checker_name = m.get('checkerName')
        if m.get('checkerType') is not None:
            self.checker_type = m.get('checkerType')
        if m.get('extraMessage') is not None:
            self.extra_message = m.get('extraMessage')
        if m.get('fileRuleRegexes') is not None:
            self.file_rule_regexes = m.get('fileRuleRegexes')
        return self


class ListPushRulesResponseBodyResult(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        rule_infos: List[ListPushRulesResponseBodyResultRuleInfos] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.rule_infos = rule_infos

    def validate(self):
        if self.rule_infos:
            for k in self.rule_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['ruleInfos'] = []
        if self.rule_infos is not None:
            for k in self.rule_infos:
                result['ruleInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.rule_infos = []
        if m.get('ruleInfos') is not None:
            for k in m.get('ruleInfos'):
                temp_model = ListPushRulesResponseBodyResultRuleInfos()
                self.rule_infos.append(temp_model.from_map(k))
        return self


class ListPushRulesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListPushRulesResponseBodyResult] = None,
        success: bool = None,
        total: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success
        self.total = total

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListPushRulesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ListPushRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPushRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPushRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRepositoriesRequest(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        archived: bool = None,
        order_by: str = None,
        organization_id: str = None,
        page: int = None,
        per_page: int = None,
        search: str = None,
        sort: str = None,
    ):
        self.access_token = access_token
        self.archived = archived
        self.order_by = order_by
        self.organization_id = organization_id
        self.page = page
        self.per_page = per_page
        self.search = search
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['accessToken'] = self.access_token
        if self.archived is not None:
            result['archived'] = self.archived
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.organization_id is not None:
            result['organizationId'] = self.organization_id
        if self.page is not None:
            result['page'] = self.page
        if self.per_page is not None:
            result['perPage'] = self.per_page
        if self.search is not None:
            result['search'] = self.search
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessToken') is not None:
            self.access_token = m.get('accessToken')
        if m.get('archived') is not None:
            self.archived = m.get('archived')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('organizationId') is not None:
            self.organization_id = m.get('organizationId')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('perPage') is not None:
            self.per_page = m.get('perPage')
        if m.get('search') is not None:
            self.search = m.get('search')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class ListRepositoriesResponseBodyResult(TeaModel):
    def __init__(
        self,
        id: int = None,
        access_level: int = None,
        archive: bool = None,
        avatar_url: str = None,
        created_at: str = None,
        description: str = None,
        import_status: str = None,
        last_activity_at: str = None,
        name: str = None,
        name_with_namespace: str = None,
        namespace_id: int = None,
        path: str = None,
        path_with_namespace: str = None,
        star: bool = None,
        star_count: int = None,
        updated_at: str = None,
        visibility_level: str = None,
        web_url: str = None,
    ):
        self.id = id
        self.access_level = access_level
        self.archive = archive
        self.avatar_url = avatar_url
        self.created_at = created_at
        self.description = description
        self.import_status = import_status
        self.last_activity_at = last_activity_at
        self.name = name
        self.name_with_namespace = name_with_namespace
        self.namespace_id = namespace_id
        self.path = path
        self.path_with_namespace = path_with_namespace
        self.star = star
        self.star_count = star_count
        self.updated_at = updated_at
        self.visibility_level = visibility_level
        self.web_url = web_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.access_level is not None:
            result['accessLevel'] = self.access_level
        if self.archive is not None:
            result['archive'] = self.archive
        if self.avatar_url is not None:
            result['avatarUrl'] = self.avatar_url
        if self.created_at is not None:
            result['createdAt'] = self.created_at
        if self.description is not None:
            result['description'] = self.description
        if self.import_status is not None:
            result['importStatus'] = self.import_status
        if self.last_activity_at is not None:
            result['lastActivityAt'] = self.last_activity_at
        if self.name is not None:
            result['name'] = self.name
        if self.name_with_namespace is not None:
            result['nameWithNamespace'] = self.name_with_namespace
        if self.namespace_id is not None:
            result['namespaceId'] = self.namespace_id
        if self.path is not None:
            result['path'] = self.path
        if self.path_with_namespace is not None:
            result['pathWithNamespace'] = self.path_with_namespace
        if self.star is not None:
            result['star'] = self.star
        if self.star_count is not None:
            result['starCount'] = self.star_count
        if self.updated_at is not None:
            result['updatedAt'] = self.updated_at
        if self.visibility_level is not None:
            result['visibilityLevel'] = self.visibility_level
        if self.web_url is not None:
            result['webUrl'] = self.web_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('accessLevel') is not None:
            self.access_level = m.get('accessLevel')
        if m.get('archive') is not None:
            self.archive = m.get('archive')
        if m.get('avatarUrl') is not None:
            self.avatar_url = m.get('avatarUrl')
        if m.get('createdAt') is not None:
            self.created_at = m.get('createdAt')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('importStatus') is not None:
            self.import_status = m.get('importStatus')
        if m.get('lastActivityAt') is not None:
            self.last_activity_at = m.get('lastActivityAt')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameWithNamespace') is not None:
            self.name_with_namespace = m.get('nameWithNamespace')
        if m.get('namespaceId') is not None:
            self.namespace_id = m.get('namespaceId')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pathWithNamespace') is not None:
            self.path_with_namespace = m.get('pathWithNamespace')
        if m.get('star') is not None:
            self.star = m.get('star')
        if m.get('starCount') is not None:
            self.star_count = m.get('starCount')
        if m.get('updatedAt') is not None:
            self.updated_at = m.get('updatedAt')
        if m.get('visibilityLevel') is not None:
            self.visibility_level = m.get('visibilityLevel')
        if m.get('webUrl') is not None:
            self.web_url = m.get('webUrl')
        return self


class ListRepositoriesResponseBody(TeaModel):
    def __init__(
        self,
        error_code: int = None,
        error_message: str = None,
        request_id: str = None,
        result: List[ListRepositoriesResponseBodyResult] = None,
        success: bool = None,
        total: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.result = result
        self.success = success
        self.total = total

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage