"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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