# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class SecretRoleset(pulumi.CustomResource):
    backend: pulumi.Output[str]
    """
    Path where the GCP Secrets Engine is mounted
    """
    bindings: pulumi.Output[list]
    """
    Bindings to create for this roleset. This can be specified multiple times for multiple bindings. Structure is documented below.

      * `resource` (`str`) - Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings).
      * `roles` (`list`) - List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
    """
    project: pulumi.Output[str]
    """
    Name of the GCP project that this roleset's service account will belong to.
    """
    roleset: pulumi.Output[str]
    """
    Name of the Roleset to create
    """
    secret_type: pulumi.Output[str]
    """
    Type of secret generated for this role set. Accepted values: `access_token`, `service_account_key`. Defaults to `access_token`.
    """
    service_account_email: pulumi.Output[str]
    """
    Email of the service account created by Vault for this Roleset
    """
    token_scopes: pulumi.Output[list]
    """
    List of OAuth scopes to assign to `access_token` secrets generated under this role set (`access_token` role sets only).
    """
    def __init__(__self__, resource_name, opts=None, backend=None, bindings=None, project=None, roleset=None, secret_type=None, token_scopes=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates a Roleset in the [GCP Secrets Engine](https://www.vaultproject.io/docs/secrets/gcp/index.html) for Vault.

        Each Roleset is [tied](https://www.vaultproject.io/docs/secrets/gcp/index.html#service-accounts-are-tied-to-rolesets) to a Service Account, and can have one or more [bindings](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings) associated with it.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-vault/blob/master/website/docs/r/gcp_secret_roleset.html.md.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[list] bindings: Bindings to create for this roleset. This can be specified multiple times for multiple bindings. Structure is documented below.
        :param pulumi.Input[str] project: Name of the GCP project that this roleset's service account will belong to.
        :param pulumi.Input[str] roleset: Name of the Roleset to create
        :param pulumi.Input[str] secret_type: Type of secret generated for this role set. Accepted values: `access_token`, `service_account_key`. Defaults to `access_token`.
        :param pulumi.Input[list] token_scopes: List of OAuth scopes to assign to `access_token` secrets generated under this role set (`access_token` role sets only).

        The **bindings** object supports the following:

          * `resource` (`pulumi.Input[str]`) - Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings).
          * `roles` (`pulumi.Input[list]`) - List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            if bindings is None:
                raise TypeError("Missing required property 'bindings'")
            __props__['bindings'] = bindings
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if roleset is None:
                raise TypeError("Missing required property 'roleset'")
            __props__['roleset'] = roleset
            __props__['secret_type'] = secret_type
            __props__['token_scopes'] = token_scopes
            __props__['service_account_email'] = None
        super(SecretRoleset, __self__).__init__(
            'vault:gcp/secretRoleset:SecretRoleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, backend=None, bindings=None, project=None, roleset=None, secret_type=None, service_account_email=None, token_scopes=None):
        """
        Get an existing SecretRoleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[list] bindings: Bindings to create for this roleset. This can be specified multiple times for multiple bindings. Structure is documented below.
        :param pulumi.Input[str] project: Name of the GCP project that this roleset's service account will belong to.
        :param pulumi.Input[str] roleset: Name of the Roleset to create
        :param pulumi.Input[str] secret_type: Type of secret generated for this role set. Accepted values: `access_token`, `service_account_key`. Defaults to `access_token`.
        :param pulumi.Input[str] service_account_email: Email of the service account created by Vault for this Roleset
        :param pulumi.Input[list] token_scopes: List of OAuth scopes to assign to `access_token` secrets generated under this role set (`access_token` role sets only).

        The **bindings** object supports the following:

          * `resource` (`pulumi.Input[str]`) - Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings).
          * `roles` (`pulumi.Input[list]`) - List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["bindings"] = bindings
        __props__["project"] = project
        __props__["roleset"] = roleset
        __props__["secret_type"] = secret_type
        __props__["service_account_email"] = service_account_email
        __props__["token_scopes"] = token_scopes
        return SecretRoleset(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

