# Search
KISS: keyword based. Given `puddl bin` [^keystokes]:
```
~/puddl/bin
bin.puddl
```

Secure: scope-based (default search scope is `public`, meaning only officially
public things). Select the scopes you want to be present for activation in the
search interface. See also [Scopes](#Scopes).


[^keystokes]: `puddl bin` was typed as `pud<TAB> bi<TAB>` with **completion <10ms**.


# Scopes
Even though there are some variables called `scope`, we never touched the
subject before. With scopes you organize the things that should shared.

## Private by default
Anything flowing into puddl will only ever be available in the `private` scope.
Only you personally have access to the private scope, meaning the list of
members is `[you]`.

## Sharing built-in
If you wish to make things public, then you need to add a scope that is granted
to somebody else, for example:
```
old-school = [alice, bob, charlie]
```
In this case, Alice, Bob and Charlie are people, but you could as well enable
"concepts", that you may want to turn into bots in the future, e.g.
```
postgres = [database, (nice, comp-sci)]
```

## Naming Conventions
Think of scopes as tags with context. As they all share the same namespace, keep
them

- similar to unix directory names (also like SEO URLs)
- short, but memorable
- unique (Have many alices? Use `alice-wonder` and `alice-land`.)
- matching PCRE `^[-a-z0-9]+$`

## Namespaces
We do have namespaces. The default namespace is `default` making `default/alice`
and `alice` equal on a global level.
