# time.puddl
```
puddl db shell
CREATE EXTENSION IF NOT EXISTS hstore SCHEMA time;
```

```ipython
import puddl
from puddl.db.alchemy import App
app = App('time')
app.psql()
create table backlog(t timestamptz, context hstore);
```


# Label("annotate whiteboard")
The Task is to annotate a whiteboard picture:
```
>>> from puddl.tasks import Label
>>> x = Label("annotate whiteboard")
>>> x.image = "file:///home/felix/puddl/mnt/s7/pictures/20201108_143645.jpg"
>>> x.labels
[]
>>> x.labels.append("page")
# ...
```

Human Algorithm:

- remember image's URI
- parse image
  - order must be defined
    - strictly top-down
    - left to right afterwards
    - BACKREF write in a way that benefits from this order

```yaml
# automatically set
dt: Sun 08 Nov 2020 03:06:10 PM CET
task: annotate whiteboard

# set by recognition engine
path: file:///home/felix/puddl/mnt/s7/pictures/20201108_143645.jpg
labels:
  - page
  - server essentials
  - net
  - monthly exploration day
  - showcase
  - chorgesang
  - herd
  - moodmeter
```

## REST?
```
$ curl -XPOST https://p/label -d <<'YAML'
task: annotate whiteboard
image_path: file:///home/felix/puddl/mnt/s7/pictures/20201108_143645.jpg
YAML

> POST /label HTTP/2
> Host: p
> User-Agent: puddl/1.0.2
> Content-Type: text/yaml; charset=utf-8
>
< HTTP/2 303 See Other
< rel=https://p/label/23
<

$ curl https://p/label/23
> GET label/23
> Host: p
> User-Agent: puddl/1.0.2
> Accept: text/yaml
>
< HTTP/2 200 OK
< Server: puddl/2.7.5
< Date: Sun, 08 Nov 2020 14:33:26 GMT
< Content-Type: text/yaml; charset=utf-8
< Content-Length: 0000
< Last-Modified: Mon, 27 Jan 2020 12:25:16 GMT
< Etag: "5e2ed6ac-32e"
<
< # inputs
< task: annotate whiteboard
< image_path: file:///home/felix/puddl/mnt/s7/pictures/20201108_143645.jpg
< # outputs
< id: 23
< dt: Sun 08 Nov 2020 03:06:10 PM CET
< task: annotate whiteboard
< labels:
<   - page
<   - server essentials
<   - net
<   - monthly exploration day
<   - showcase
<   - chorgesang
<   - herd
<   - moodmeter
< 

```
