from django.conf import settings

DEFAULT_USES_WEBP = False
DEFAULT_USES_PROGRESSIVE_JPEG = False
DEFAULT_USES_PREVIEW = False

DEFAULT_PREVIEW_SIZE = (10, None)
DEFAULT_IMAGE_QUALITY = 80

DEFAULT_IMAGE_TEMPLATE = 'images/image.html.j2'
DEFAULT_IMAGE_CSS_CLASS = ''
DEFAULT_IMAGE_CONSTANT_CSS_CLASS = ''
DEFAULT_IMAGE_SRCSET_ATTRIBUTE = 'srcset'
DEFAULT_BREAKPOINTS = [
    (1280, 1280),
    (768, 1080),
    (350, 767),
    (None, 350),
]
DEFAULT_RATES = [1, 1.5, 2, 3]

BREAKPOINTS = getattr(settings, 'FILER_IMAGE_BREAKPOINTS', DEFAULT_BREAKPOINTS)
RATES = getattr(settings, 'FILER_IMAGE_RATES', DEFAULT_RATES)
PREVIEW_SIZE = getattr(settings, 'FILER_IMAGE_PREVIEW_SIZE', DEFAULT_PREVIEW_SIZE)
IMAGE_QUALITY = getattr(settings, 'FILER_IMAGE_QUALITY', DEFAULT_IMAGE_QUALITY)
USES_WEBP = getattr(settings, 'FILER_IMAGE_USES_WEBP', DEFAULT_USES_WEBP)
USES_PROGRESSIVE_JPEG = getattr(settings, 'FILER_IMAGE_USES_PROGRESSIVE_JPEG', DEFAULT_USES_PROGRESSIVE_JPEG)
USES_PREVIEW = getattr(settings, 'FILER_IMAGE_USES_PREVIEW', DEFAULT_USES_PREVIEW)

IMAGE_TEMPLATE = getattr(settings, 'FILER_IMAGE_DEFAULT_TEMPLATE', DEFAULT_IMAGE_TEMPLATE)
IMAGE_CSS_CLASS = getattr(settings, 'FILER_IMAGE_DEFAULT_CSS_CLASS', DEFAULT_IMAGE_CSS_CLASS)
IMAGE_CONSTANT_CSS_CLASS = getattr(settings, 'FILER_IMAGE_CONSTANT_CSS_CLASS', DEFAULT_IMAGE_CONSTANT_CSS_CLASS)
IMAGE_SRCSET_ATTRIBUTE = getattr(settings, 'FILER_IMAGE_DEFAULT_SRCSET_ATTRIBUTE', DEFAULT_IMAGE_SRCSET_ATTRIBUTE)
