/// Files: kernel/bpf/verifier.c include/linux/bpf_verifier.h
/// Fix: 9601148392520e2e134936e76788fc2a6371e7be
/// Fixes: 2c78ee898d8f10ae6fb2fa23a3fbaec96b1b7366

virtual detect

@bypass_spec_v1@
@@

struct bpf_verifier_env {
	...
	bool bypass_spec_v1;
	...
};

@err depends on bypass_spec_v1 exists@
identifier ptr_reg, env, known, smin_val, smax_val;
position p;
@@

adjust_ptr_min_max_vals(..., const struct bpf_reg_state *ptr_reg, ...)
{
	...
	switch(ptr_reg->type) {
	case PTR_TO_MAP_VALUE:
*		if (!env->allow_ptr_leaks@p && !known && (smin_val < 0) != (smax_val < 0)) {
			...
			return -EACCES;
		}
	}
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-29155')
