/// Files: arch/x86/kvm/svm/nested.c
/// Fix: a58d9166a756a0f4a6618e4f593232593d6df134
/// Fixes: 2fcf4876ada8a293d3b92a1033b8b990a7c613d3

virtual detect

@svm_allocate_nested@
@@

svm_allocate_nested(...) { ... }

@err_enter_svm_guest_mode depends on svm_allocate_nested exists@
identifier svm, vmcb12;
position p;
@@

enter_svm_guest_mode(struct vcpu_svm *svm, ...,
		     struct vmcb *vmcb12)
{
	...
*	load_nested_vmcb_control@p(svm, &vmcb12->control);
	...
}

@err_nested_svm_vmrun depends on svm_allocate_nested exists@
identifier svm;
statement S;
position p;
@@

nested_svm_vmrun(struct vcpu_svm *svm)
{
	...
*	if (!nested_vmcb_checks@p(svm, ...))
		S
	...
}

@script:python depends on detect@
p << err_enter_svm_guest_mode.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-29657')

@script:python depends on detect@
p << err_nested_svm_vmrun.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-29657')
