/// Files: kernel/bpf/verifier.c
/// Fix: 7d3baf0afa3aa9102d6a521a8e4c41888bb79882
/// Fixes: 37086bfdc737ea6f66bf68dcf16757004d68e1e1

virtual detect

@err@
identifier env, insn_idx, insn, load_reg, err;
symbol true;
position p;
@@

check_atomic(struct bpf_verifier_env *env, int insn_idx, struct bpf_insn *insn)
{
	...
	if (insn->imm & BPF_FETCH) {
		if (insn->imm == BPF_CMPXCHG)
*			load_reg = BPF_REG_0;
		else
*			load_reg = insn->src_reg;
    		...
	} else {
*		load_reg = -1;
	}
	...
*	err = check_mem_access@p(env, insn_idx, insn->dst_reg, insn->off,
*			       BPF_SIZE(insn->code), BPF_READ, \(-1\|load_reg\), true);
	... when != if (!err && load_reg >= 0) err = check_mem_access(env, insn_idx, insn->dst_reg, insn->off, BPF_SIZE(insn->code), BPF_READ, load_reg, true);
*	if (err)
*		return err;
	...
	BPF_WRITE
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-0264')
