"""
    Criteo API

    Criteo publicly exposed API  # noqa: E501

    The version of the OpenAPI document: 2022-04
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from criteo_api_retailmedia_v2022_04.api_client import ApiClient, Endpoint as _Endpoint
from criteo_api_retailmedia_v2022_04.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from criteo_api_retailmedia_v2022_04.model.add_to_basket_ids_update_model202110_request import AddToBasketIdsUpdateModel202110Request
from criteo_api_retailmedia_v2022_04.model.add_to_basket_target202110_request import AddToBasketTarget202110Request
from criteo_api_retailmedia_v2022_04.model.add_to_basket_target202110_response import AddToBasketTarget202110Response
from criteo_api_retailmedia_v2022_04.model.asset_response import AssetResponse
from criteo_api_retailmedia_v2022_04.model.auction_line_item_create_model_request import AuctionLineItemCreateModelRequest
from criteo_api_retailmedia_v2022_04.model.auction_line_item_paged_list_response import AuctionLineItemPagedListResponse
from criteo_api_retailmedia_v2022_04.model.auction_line_item_response import AuctionLineItemResponse
from criteo_api_retailmedia_v2022_04.model.auction_line_item_update_model_request import AuctionLineItemUpdateModelRequest
from criteo_api_retailmedia_v2022_04.model.audience_ids_update_model202110_request import AudienceIdsUpdateModel202110Request
from criteo_api_retailmedia_v2022_04.model.audience_target202110_request import AudienceTarget202110Request
from criteo_api_retailmedia_v2022_04.model.audience_target202110_response import AudienceTarget202110Response
from criteo_api_retailmedia_v2022_04.model.balance202110_paged_list_response import Balance202110PagedListResponse
from criteo_api_retailmedia_v2022_04.model.balance_campaign202110_list_request import BalanceCampaign202110ListRequest
from criteo_api_retailmedia_v2022_04.model.balance_campaign202110_paged_list_response import BalanceCampaign202110PagedListResponse
from criteo_api_retailmedia_v2022_04.model.category202204 import Category202204
from criteo_api_retailmedia_v2022_04.model.category202204_list_response import Category202204ListResponse
from criteo_api_retailmedia_v2022_04.model.common_line_item_paged_list_response import CommonLineItemPagedListResponse
from criteo_api_retailmedia_v2022_04.model.common_line_item_response import CommonLineItemResponse
from criteo_api_retailmedia_v2022_04.model.creative202110_list_response import Creative202110ListResponse
from criteo_api_retailmedia_v2022_04.model.external_post_campaign import ExternalPostCampaign
from criteo_api_retailmedia_v2022_04.model.external_put_campaign import ExternalPutCampaign
from criteo_api_retailmedia_v2022_04.model.external_retailer_pages202110 import ExternalRetailerPages202110
from criteo_api_retailmedia_v2022_04.model.json_api_page_response_of_account import JsonApiPageResponseOfAccount
from criteo_api_retailmedia_v2022_04.model.json_api_page_response_of_brand import JsonApiPageResponseOfBrand
from criteo_api_retailmedia_v2022_04.model.json_api_page_response_of_campaign import JsonApiPageResponseOfCampaign
from criteo_api_retailmedia_v2022_04.model.json_api_page_response_of_retailer import JsonApiPageResponseOfRetailer
from criteo_api_retailmedia_v2022_04.model.json_api_request_of_catalog_request import JsonApiRequestOfCatalogRequest
from criteo_api_retailmedia_v2022_04.model.json_api_single_response_of_campaign import JsonApiSingleResponseOfCampaign
from criteo_api_retailmedia_v2022_04.model.json_api_single_response_of_catalog_status import JsonApiSingleResponseOfCatalogStatus
from criteo_api_retailmedia_v2022_04.model.keyword_target202110_request import KeywordTarget202110Request
from criteo_api_retailmedia_v2022_04.model.keyword_target202110_response import KeywordTarget202110Response
from criteo_api_retailmedia_v2022_04.model.preferred_line_item202110_paged_list_response import PreferredLineItem202110PagedListResponse
from criteo_api_retailmedia_v2022_04.model.preferred_line_item202110_response import PreferredLineItem202110Response
from criteo_api_retailmedia_v2022_04.model.preferred_line_item_create_model202110_request import PreferredLineItemCreateModel202110Request
from criteo_api_retailmedia_v2022_04.model.preferred_line_item_update_model202110_request import PreferredLineItemUpdateModel202110Request
from criteo_api_retailmedia_v2022_04.model.promoted_product202110_list_request import PromotedProduct202110ListRequest
from criteo_api_retailmedia_v2022_04.model.promoted_product202110_paged_list_response import PromotedProduct202110PagedListResponse
from criteo_api_retailmedia_v2022_04.model.store_ids_update_model202110_request import StoreIdsUpdateModel202110Request
from criteo_api_retailmedia_v2022_04.model.store_target202110_request import StoreTarget202110Request
from criteo_api_retailmedia_v2022_04.model.store_target202110_response import StoreTarget202110Response


class CampaignApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_asset(
            self,
            asset_file,
            **kwargs
        ):
            """create_asset  # noqa: E501

            Creates an asset  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_asset(asset_file, async_req=True)
            >>> result = thread.get()

            Args:
                asset_file (file): The asset binary content

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_file'] = \
                asset_file
            return self.call_with_http_info(**kwargs)

        self.create_asset = _Endpoint(
            settings={
                'response_type': (AssetResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/assets',
                'operation_id': 'create_asset',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_file',
                ],
                'required': [
                    'asset_file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_file':
                        (file,),
                },
                'attribute_map': {
                    'asset_file': 'AssetFile',
                },
                'location_map': {
                    'asset_file': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__create_asset
        )

        def __get_api202110_external_account_balances_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api202110_external_account_balances_by_account_id  # noqa: E501

            Gets page of balance objects for the given account id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_account_balances_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The account to get balances for

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Balance202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_account_balances_by_account_id = _Endpoint(
            settings={
                'response_type': (Balance202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{account-id}/balances',
                'operation_id': 'get_api202110_external_account_balances_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_account_balances_by_account_id
        )

        def __get_api202110_external_account_creatives_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api202110_external_account_creatives_by_account_id  # noqa: E501

            Get account creatives  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_account_creatives_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): External account id to retrieve creatives for

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Creative202110ListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_account_creatives_by_account_id = _Endpoint(
            settings={
                'response_type': (Creative202110ListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{account-id}/creatives',
                'operation_id': 'get_api202110_external_account_creatives_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                },
                'location_map': {
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_account_creatives_by_account_id
        )

        def __get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id  # noqa: E501

            This endpoint gets the keyword target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                KeywordTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id = _Endpoint(
            settings={
                'response_type': (KeywordTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/auction-line-items/{line-item-id}/targeting/keywords',
                'operation_id': 'get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_auction_line_item_targeting_keywords_by_line_item_id
        )

        def __get_api202110_external_balance_campaigns_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """get_api202110_external_balance_campaigns_by_balance_id  # noqa: E501

            Gets page of campaigns for the given balanceId  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to get campaigns from

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BalanceCampaign202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_balance_campaigns_by_balance_id = _Endpoint(
            settings={
                'response_type': (BalanceCampaign202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/balances/{balance-id}/campaigns',
                'operation_id': 'get_api202110_external_balance_campaigns_by_balance_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'balance_id': 'balance-id',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'balance_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_balance_campaigns_by_balance_id
        )

        def __get_api202110_external_campaign_preferred_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """get_api202110_external_campaign_preferred_line_items_by_campaign_id  # noqa: E501

            Gets page of preferred line item objects for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_campaign_preferred_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferredLineItem202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_campaign_preferred_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (PreferredLineItem202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaign-id}/preferred-line-items',
                'operation_id': 'get_api202110_external_campaign_preferred_line_items_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'campaign_id': 'campaign-id',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_campaign_preferred_line_items_by_campaign_id
        )

        def __get_api202110_external_line_item_products_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_line_item_products_by_line_item_id  # noqa: E501

            This endpoint gets the promoted products on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PromotedProduct202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_line_item_products_by_line_item_id = _Endpoint(
            settings={
                'response_type': (PromotedProduct202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}/products',
                'operation_id': 'get_api202110_external_line_item_products_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_line_item_products_by_line_item_id
        )

        def __get_api202110_external_preferred_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_preferred_line_item_by_line_item_id  # noqa: E501

            Gets the preferred line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_preferred_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferredLineItem202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_preferred_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (PreferredLineItem202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}',
                'operation_id': 'get_api202110_external_preferred_line_item_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_preferred_line_item_by_line_item_id
        )

        def __get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id  # noqa: E501

            This endpoint gets the add to basket target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddToBasketTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AddToBasketTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/add-to-basket',
                'operation_id': 'get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id
        )

        def __get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id  # noqa: E501

            This endpoint gets the audience target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AudienceTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AudienceTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/audiences',
                'operation_id': 'get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id
        )

        def __get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id  # noqa: E501

            This endpoint gets the store target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StoreTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id = _Endpoint(
            settings={
                'response_type': (StoreTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/stores',
                'operation_id': 'get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_preferred_line_item_targeting_stores_by_line_item_id
        )

        def __get_api202110_external_retailer_pages_by_retailer_id(
            self,
            retailer_id,
            **kwargs
        ):
            """get_api202110_external_retailer_pages_by_retailer_id  # noqa: E501

            Get the page types available for the given retailer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202110_external_retailer_pages_by_retailer_id(retailer_id, async_req=True)
            >>> result = thread.get()

            Args:
                retailer_id (int): The retailers to fetch pages for

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExternalRetailerPages202110
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['retailer_id'] = \
                retailer_id
            return self.call_with_http_info(**kwargs)

        self.get_api202110_external_retailer_pages_by_retailer_id = _Endpoint(
            settings={
                'response_type': (ExternalRetailerPages202110,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/retailers/{retailerId}/pages',
                'operation_id': 'get_api202110_external_retailer_pages_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                },
                'location_map': {
                    'retailer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202110_external_retailer_pages_by_retailer_id
        )

        def __get_api202204_external_categorie_by_category_id(
            self,
            category_id,
            **kwargs
        ):
            """get_api202204_external_categorie_by_category_id  # noqa: E501

            Endpoint to search for a specific category by categoryId.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202204_external_categorie_by_category_id(category_id, async_req=True)
            >>> result = thread.get()

            Args:
                category_id (int): ID of the desired category

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Category202204
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['category_id'] = \
                category_id
            return self.call_with_http_info(**kwargs)

        self.get_api202204_external_categorie_by_category_id = _Endpoint(
            settings={
                'response_type': (Category202204,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/categories/{categoryId}',
                'operation_id': 'get_api202204_external_categorie_by_category_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_id',
                ],
                'required': [
                    'category_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_id':
                        (int,),
                },
                'attribute_map': {
                    'category_id': 'categoryId',
                },
                'location_map': {
                    'category_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202204_external_categorie_by_category_id
        )

        def __get_api202204_external_categories(
            self,
            **kwargs
        ):
            """get_api202204_external_categories  # noqa: E501

            Endpoint to search categories by text and retailer.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api202204_external_categories(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                retailer_id (int): The retailer id for which Categories fetched. [optional]
                text_substring (str): Query string to search across Categories. [optional]
                page_index (int): The start position in the overall list of matches. Must be zero or greater.. [optional] if omitted the server will use the default value of 0
                page_size (int): The maximum number of results to return with each call. Must be greater than zero.. [optional] if omitted the server will use the default value of 100
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Category202204ListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_api202204_external_categories = _Endpoint(
            settings={
                'response_type': (Category202204ListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/categories',
                'operation_id': 'get_api202204_external_categories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                    'text_substring',
                    'page_index',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_index',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_index',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                    'text_substring':
                        (str,),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                    'text_substring': 'textSubstring',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'retailer_id': 'query',
                    'text_substring': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api202204_external_categories
        )

        def __get_api_v1_external_account_brands_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_brands_by_account_id  # noqa: E501

            Gets page of retailer objects that are associated with the given account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_brands_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfBrand
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_brands_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfBrand,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{accountId}/brands',
                'operation_id': 'get_api_v1_external_account_brands_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_brands_by_account_id
        )

        def __get_api_v1_external_account_campaigns_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_campaigns_by_account_id  # noqa: E501

            Gets page of campaign objects for the given account id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_campaigns_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'get_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_campaigns_by_account_id
        )

        def __get_api_v1_external_account_retailers_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_retailers_by_account_id  # noqa: E501

            Gets page of retailer objects that are associated with the given account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_retailers_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfRetailer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_retailers_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfRetailer,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{accountId}/retailers',
                'operation_id': 'get_api_v1_external_account_retailers_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_retailers_by_account_id
        )

        def __get_api_v1_external_accounts(
            self,
            **kwargs
        ):
            """get_api_v1_external_accounts  # noqa: E501

            Gets page of account objects that the current user can access  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_accounts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_accounts = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfAccount,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts',
                'operation_id': 'get_api_v1_external_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_accounts
        )

        def __get_api_v1_external_campaign_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """get_api_v1_external_campaign_by_campaign_id  # noqa: E501

            Gets the campaign for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_campaign_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaignId}',
                'operation_id': 'get_api_v1_external_campaign_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_campaign_by_campaign_id
        )

        def __get_api_v1_external_catalog_output_by_catalog_id(
            self,
            catalog_id,
            **kwargs
        ):
            """get_api_v1_external_catalog_output_by_catalog_id  # noqa: E501

            Output the indicated catalog. Catalogs are only available for retrieval when their associated status request  is at a Success status.  Produces application/x-json-stream of v2021_07 CatalogProduct json objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_catalog_output_by_catalog_id(catalog_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalog_id (str): A catalog ID returned from an account catalog request.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalog_id'] = \
                catalog_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_catalog_output_by_catalog_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/catalogs/{catalogId}/output',
                'operation_id': 'get_api_v1_external_catalog_output_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/x-json-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_catalog_output_by_catalog_id
        )

        def __get_api_v1_external_catalog_status_by_catalog_id(
            self,
            catalog_id,
            **kwargs
        ):
            """get_api_v1_external_catalog_status_by_catalog_id  # noqa: E501

            Check the status of a catalog request.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_catalog_status_by_catalog_id(catalog_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalog_id (str): A catalog ID returned from an account catalog request.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCatalogStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalog_id'] = \
                catalog_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_catalog_status_by_catalog_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/catalogs/{catalogId}/status',
                'operation_id': 'get_api_v1_external_catalog_status_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_catalog_status_by_catalog_id
        )

        def __get_api_v2_external_account_line_items_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v2_external_account_line_items_by_account_id  # noqa: E501

            Gets page of line item objects for the given account id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v2_external_account_line_items_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_campaign_id ([str]): The campaign ids that you would like to limit your result set to. [optional]
                limit_to_type (str): The campaign types that you would like to limit your result set to. [optional]
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonLineItemPagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v2_external_account_line_items_by_account_id = _Endpoint(
            settings={
                'response_type': (CommonLineItemPagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{account-id}/line-items',
                'operation_id': 'get_api_v2_external_account_line_items_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_campaign_id',
                    'limit_to_type',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'limit_to_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('limit_to_type',): {

                        "UNKNOWN": "Unknown",
                        "AUCTION": "Auction",
                        "PREFERRED": "Preferred"
                    },
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_campaign_id':
                        ([str],),
                    'limit_to_type':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'limit_to_campaign_id': 'limitToCampaignId',
                    'limit_to_type': 'limitToType',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_campaign_id': 'query',
                    'limit_to_type': 'query',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_campaign_id': 'multi',
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v2_external_account_line_items_by_account_id
        )

        def __get_api_v2_external_auction_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api_v2_external_auction_line_item_by_line_item_id  # noqa: E501

            Gets the auction line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v2_external_auction_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuctionLineItemResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v2_external_auction_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AuctionLineItemResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/auction-line-items/{line-item-id}',
                'operation_id': 'get_api_v2_external_auction_line_item_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v2_external_auction_line_item_by_line_item_id
        )

        def __get_api_v2_external_campaign_auction_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """get_api_v2_external_campaign_auction_line_items_by_campaign_id  # noqa: E501

            Gets page of auction line item objects for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v2_external_campaign_auction_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuctionLineItemPagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v2_external_campaign_auction_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (AuctionLineItemPagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaign-id}/auction-line-items',
                'operation_id': 'get_api_v2_external_campaign_auction_line_items_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'campaign_id': 'campaign-id',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v2_external_campaign_auction_line_items_by_campaign_id
        )

        def __get_api_v2_external_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api_v2_external_line_item_by_line_item_id  # noqa: E501

            Gets the line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v2_external_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonLineItemResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v2_external_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (CommonLineItemResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}',
                'operation_id': 'get_api_v2_external_line_item_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v2_external_line_item_by_line_item_id
        )

        def __post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id  # noqa: E501

            This endpoint appends one or more keywords to targeting on the specified line item.  The resulting state of the keyword target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                keyword_target202110_request (KeywordTarget202110Request): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                KeywordTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id = _Endpoint(
            settings={
                'response_type': (KeywordTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/auction-line-items/{line-item-id}/targeting/keywords/append',
                'operation_id': 'post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'keyword_target202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'keyword_target202110_request':
                        (KeywordTarget202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'keyword_target202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_auction_line_item_targeting_keywords_append_by_line_item_id
        )

        def __post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id  # noqa: E501

            This endpoint removes one or more keywords from targeting on the specified line item.  The resulting state of the keyword target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                keyword_target202110_request (KeywordTarget202110Request): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                KeywordTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id = _Endpoint(
            settings={
                'response_type': (KeywordTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/auction-line-items/{line-item-id}/targeting/keywords/delete',
                'operation_id': 'post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'keyword_target202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'keyword_target202110_request':
                        (KeywordTarget202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'keyword_target202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_auction_line_item_targeting_keywords_delete_by_line_item_id
        )

        def __post_api202110_external_balance_campaigns_append_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """post_api202110_external_balance_campaigns_append_by_balance_id  # noqa: E501

            appends one or more campaigns to the specified balance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_balance_campaigns_append_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to add campaigns from

            Keyword Args:
                balance_campaign202110_list_request (BalanceCampaign202110ListRequest): The campaigns to append. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BalanceCampaign202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_balance_campaigns_append_by_balance_id = _Endpoint(
            settings={
                'response_type': (BalanceCampaign202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/balances/{balance-id}/campaigns/append',
                'operation_id': 'post_api202110_external_balance_campaigns_append_by_balance_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'balance_campaign202110_list_request',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'balance_campaign202110_list_request':
                        (BalanceCampaign202110ListRequest,),
                },
                'attribute_map': {
                    'balance_id': 'balance-id',
                },
                'location_map': {
                    'balance_id': 'path',
                    'balance_campaign202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_balance_campaigns_append_by_balance_id
        )

        def __post_api202110_external_balance_campaigns_delete_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """post_api202110_external_balance_campaigns_delete_by_balance_id  # noqa: E501

            Removes one or more campaigns on the specified balance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_balance_campaigns_delete_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to remove campaigns from

            Keyword Args:
                balance_campaign202110_list_request (BalanceCampaign202110ListRequest): The campaigns to append. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BalanceCampaign202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_balance_campaigns_delete_by_balance_id = _Endpoint(
            settings={
                'response_type': (BalanceCampaign202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/balances/{balance-id}/campaigns/delete',
                'operation_id': 'post_api202110_external_balance_campaigns_delete_by_balance_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'balance_campaign202110_list_request',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'balance_campaign202110_list_request':
                        (BalanceCampaign202110ListRequest,),
                },
                'attribute_map': {
                    'balance_id': 'balance-id',
                },
                'location_map': {
                    'balance_id': 'path',
                    'balance_campaign202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_balance_campaigns_delete_by_balance_id
        )

        def __post_api202110_external_campaign_preferred_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """post_api202110_external_campaign_preferred_line_items_by_campaign_id  # noqa: E501

            Creates a new preferred line item with the specified settings  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_campaign_preferred_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                preferred_line_item_create_model202110_request (PreferredLineItemCreateModel202110Request): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferredLineItem202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_campaign_preferred_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (PreferredLineItem202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaign-id}/preferred-line-items',
                'operation_id': 'post_api202110_external_campaign_preferred_line_items_by_campaign_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'preferred_line_item_create_model202110_request',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'preferred_line_item_create_model202110_request':
                        (PreferredLineItemCreateModel202110Request,),
                },
                'attribute_map': {
                    'campaign_id': 'campaign-id',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'preferred_line_item_create_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_campaign_preferred_line_items_by_campaign_id
        )

        def __post_api202110_external_line_item_products_append_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_line_item_products_append_by_line_item_id  # noqa: E501

            This endpoint appends one or more products to promote on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_line_item_products_append_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                promoted_product202110_list_request (PromotedProduct202110ListRequest): the products to append to this line item. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PromotedProduct202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_line_item_products_append_by_line_item_id = _Endpoint(
            settings={
                'response_type': (PromotedProduct202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}/products/append',
                'operation_id': 'post_api202110_external_line_item_products_append_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'promoted_product202110_list_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'promoted_product202110_list_request':
                        (PromotedProduct202110ListRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'promoted_product202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_line_item_products_append_by_line_item_id
        )

        def __post_api202110_external_line_item_products_delete_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_line_item_products_delete_by_line_item_id  # noqa: E501

            This endpoint removes one or more products from promotion on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_line_item_products_delete_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                promoted_product202110_list_request (PromotedProduct202110ListRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PromotedProduct202110PagedListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_line_item_products_delete_by_line_item_id = _Endpoint(
            settings={
                'response_type': (PromotedProduct202110PagedListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}/products/delete',
                'operation_id': 'post_api202110_external_line_item_products_delete_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'promoted_product202110_list_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'promoted_product202110_list_request':
                        (PromotedProduct202110ListRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'promoted_product202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_line_item_products_delete_by_line_item_id
        )

        def __post_api202110_external_line_item_products_pause_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_line_item_products_pause_by_line_item_id  # noqa: E501

            This endpoint pauses one or more promoted products on a specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_line_item_products_pause_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with.

            Keyword Args:
                promoted_product202110_list_request (PromotedProduct202110ListRequest): The products from which their IDs will be used to pause.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_line_item_products_pause_by_line_item_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}/products/pause',
                'operation_id': 'post_api202110_external_line_item_products_pause_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'promoted_product202110_list_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'promoted_product202110_list_request':
                        (PromotedProduct202110ListRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'promoted_product202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_line_item_products_pause_by_line_item_id
        )

        def __post_api202110_external_line_item_products_unpause_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_line_item_products_unpause_by_line_item_id  # noqa: E501

            This endpoint unpauses one or more promoted products on a specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_line_item_products_unpause_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with.

            Keyword Args:
                promoted_product202110_list_request (PromotedProduct202110ListRequest): The products from which their IDs will be used to unpause.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_line_item_products_unpause_by_line_item_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/line-items/{line-item-id}/products/unpause',
                'operation_id': 'post_api202110_external_line_item_products_unpause_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'promoted_product202110_list_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'promoted_product202110_list_request':
                        (PromotedProduct202110ListRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'promoted_product202110_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_line_item_products_unpause_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id  # noqa: E501

            This endpoint appends one or more add to basket ids to targeting on the specified line item.  The resulting state of the add to basket target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                add_to_basket_ids_update_model202110_request (AddToBasketIdsUpdateModel202110Request): Ids to append to the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddToBasketTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AddToBasketTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/add-to-basket/append',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'add_to_basket_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'add_to_basket_ids_update_model202110_request':
                        (AddToBasketIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'add_to_basket_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_add_to_basket_append_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id  # noqa: E501

            This endpoint removes one or more add to basket ids from targeting on the specified line item.  The resulting state of the add to basket target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                add_to_basket_ids_update_model202110_request (AddToBasketIdsUpdateModel202110Request): Ids to remove from the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddToBasketTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AddToBasketTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/add-to-basket/delete',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'add_to_basket_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'add_to_basket_ids_update_model202110_request':
                        (AddToBasketIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'add_to_basket_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_add_to_basket_delete_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id  # noqa: E501

            This endpoint appends one or more audiences ids to targeting on the specified line item.  The resulting state of the audience target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                audience_ids_update_model202110_request (AudienceIdsUpdateModel202110Request): Audience ids to append to the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AudienceTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AudienceTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/audiences/append',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'audience_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'audience_ids_update_model202110_request':
                        (AudienceIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'audience_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_audiences_append_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id  # noqa: E501

            This endpoint removes one or more audiences ids from targeting on the specified line item.  The resulting state of the audience target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                audience_ids_update_model202110_request (AudienceIdsUpdateModel202110Request): Audience ids to remove from the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AudienceTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AudienceTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/audiences/delete',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'audience_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'audience_ids_update_model202110_request':
                        (AudienceIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'audience_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_audiences_delete_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id  # noqa: E501

            This endpoint appends one or more store ids to targeting on the specified line item.  The resulting state of the store target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                store_ids_update_model202110_request (StoreIdsUpdateModel202110Request): Store ids to append to the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StoreTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id = _Endpoint(
            settings={
                'response_type': (StoreTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/stores/append',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'store_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'store_ids_update_model202110_request':
                        (StoreIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'store_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_stores_append_by_line_item_id
        )

        def __post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id  # noqa: E501

            This endpoint removes one or more store ids from targeting on the specified line item.  The resulting state of the store target is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                store_ids_update_model202110_request (StoreIdsUpdateModel202110Request): Store ids to remove from the target. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StoreTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id = _Endpoint(
            settings={
                'response_type': (StoreTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/stores/delete',
                'operation_id': 'post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'store_ids_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'store_ids_update_model202110_request':
                        (StoreIdsUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'store_ids_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api202110_external_preferred_line_item_targeting_stores_delete_by_line_item_id
        )

        def __post_api_v1_external_account_campaigns_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """post_api_v1_external_account_campaigns_by_account_id  # noqa: E501

            Creates a new campaign with the specified settings  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                external_post_campaign (ExternalPostCampaign): The campaign settings to create a campaign with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_account_campaigns_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'post_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'external_post_campaign',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'external_post_campaign':
                        (ExternalPostCampaign,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'external_post_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_account_campaigns_by_account_id
        )

        def __post_api_v1_external_account_catalogs_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """post_api_v1_external_account_catalogs_by_account_id  # noqa: E501

            Create a request for a Catalog available to the indicated account.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_account_catalogs_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The account to request the catalog for.

            Keyword Args:
                json_api_request_of_catalog_request (JsonApiRequestOfCatalogRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCatalogStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_account_catalogs_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/accounts/{accountId}/catalogs',
                'operation_id': 'post_api_v1_external_account_catalogs_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'json_api_request_of_catalog_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'json_api_request_of_catalog_request':
                        (JsonApiRequestOfCatalogRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'json_api_request_of_catalog_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_account_catalogs_by_account_id
        )

        def __post_api_v2_external_campaign_auction_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """post_api_v2_external_campaign_auction_line_items_by_campaign_id  # noqa: E501

            Creates new auction line item with the specified settings  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v2_external_campaign_auction_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                auction_line_item_create_model_request (AuctionLineItemCreateModelRequest): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuctionLineItemResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v2_external_campaign_auction_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (AuctionLineItemResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaign-id}/auction-line-items',
                'operation_id': 'post_api_v2_external_campaign_auction_line_items_by_campaign_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'auction_line_item_create_model_request',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'auction_line_item_create_model_request':
                        (AuctionLineItemCreateModelRequest,),
                },
                'attribute_map': {
                    'campaign_id': 'campaign-id',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'auction_line_item_create_model_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v2_external_campaign_auction_line_items_by_campaign_id
        )

        def __put_api202110_external_preferred_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api202110_external_preferred_line_item_by_line_item_id  # noqa: E501

            Updates the preferred line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api202110_external_preferred_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                preferred_line_item_update_model202110_request (PreferredLineItemUpdateModel202110Request): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferredLineItem202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api202110_external_preferred_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (PreferredLineItem202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}',
                'operation_id': 'put_api202110_external_preferred_line_item_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'preferred_line_item_update_model202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'preferred_line_item_update_model202110_request':
                        (PreferredLineItemUpdateModel202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'preferred_line_item_update_model202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api202110_external_preferred_line_item_by_line_item_id
        )

        def __put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id  # noqa: E501

            This endpoint sets the scope of the add to basket target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                add_to_basket_target202110_request (AddToBasketTarget202110Request): The add to basket target to set the scope for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddToBasketTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AddToBasketTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/add-to-basket',
                'operation_id': 'put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'add_to_basket_target202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'add_to_basket_target202110_request':
                        (AddToBasketTarget202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'add_to_basket_target202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api202110_external_preferred_line_item_targeting_add_to_basket_by_line_item_id
        )

        def __put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id  # noqa: E501

            This endpoint sets the scope of the audience target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                audience_target202110_request (AudienceTarget202110Request): The audience target to set the scope for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AudienceTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AudienceTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/audiences',
                'operation_id': 'put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'audience_target202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'audience_target202110_request':
                        (AudienceTarget202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'audience_target202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api202110_external_preferred_line_item_targeting_audiences_by_line_item_id
        )

        def __put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id  # noqa: E501

            This endpoint sets the scope of the store target on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                store_target202110_request (StoreTarget202110Request): The store target to set the scope for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StoreTarget202110Response
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id = _Endpoint(
            settings={
                'response_type': (StoreTarget202110Response,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/preferred-line-items/{line-item-id}/targeting/stores',
                'operation_id': 'put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'store_target202110_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'store_target202110_request':
                        (StoreTarget202110Request,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'store_target202110_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api202110_external_preferred_line_item_targeting_stores_by_line_item_id
        )

        def __put_api_v1_external_campaign_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """put_api_v1_external_campaign_by_campaign_id  # noqa: E501

            Updates the campaign for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                external_put_campaign (ExternalPutCampaign): The campaign settings to update that campaign with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v1_external_campaign_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/campaigns/{campaignId}',
                'operation_id': 'put_api_v1_external_campaign_by_campaign_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'external_put_campaign',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'external_put_campaign':
                        (ExternalPutCampaign,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'external_put_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v1_external_campaign_by_campaign_id
        )

        def __put_api_v2_external_auction_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api_v2_external_auction_line_item_by_line_item_id  # noqa: E501

            Updates the auction line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v2_external_auction_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                auction_line_item_update_model_request (AuctionLineItemUpdateModelRequest): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuctionLineItemResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v2_external_auction_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (AuctionLineItemResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/2022-04/retail-media/auction-line-items/{line-item-id}',
                'operation_id': 'put_api_v2_external_auction_line_item_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'auction_line_item_update_model_request',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'auction_line_item_update_model_request':
                        (AuctionLineItemUpdateModelRequest,),
                },
                'attribute_map': {
                    'line_item_id': 'line-item-id',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'auction_line_item_update_model_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v2_external_auction_line_item_by_line_item_id
        )
