import abc
from typing import Dict, List, Optional, TypeVar, Generic

from ....system.core import FunctionNode, NodeState

I = TypeVar('I', bound=FunctionNode)


class NodeService(abc.ABC, Generic[I]):

    def get_zones(self) -> List[str]: ...

    def get_nodes(self) -> List[I]: ...

    def get_nodes_by_name(self) -> Dict[str, I]: ...

    def find(self, node_name: str) -> Optional[I]: ...

    def find_nodes_in_zone(self, zone: str) -> List[I]: ...

    def add_node(self, node: I): ...

    def remove_nod(self, node: str): ...

    def set_state(self, node: str, state: NodeState): ...
