import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableTableIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html#instance BigtableTableIamPolicy#instance}.
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html#policy_data BigtableTableIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html#project BigtableTableIamPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html#table BigtableTableIamPolicy#table}.
     *
     * @stability stable
     */
    readonly table: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html google_bigtable_table_iam_policy}.
 *
 * @stability stable
 */
export declare class BigtableTableIamPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_policy.html google_bigtable_table_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableTableIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _policyData?;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _table?;
    /**
     * @stability stable
     */
    get table(): string;
    /**
     * @stability stable
     */
    set table(value: string);
    /**
     * @stability stable
     */
    get tableInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
