# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyfinra', 'pyfinra.financials', 'pyfinra.financials.tools']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.4.1,<2.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'pyfinra',
    'version': '0.2.1',
    'description': 'unofficial Finra api',
    'long_description': '# Unoffical Python Finra Wrapper\n\n**warning: this repository is still in alpha stage**\n\n## Installation\n\n### PIP\n\n```Bash\npip install pyfinra\n```\n\n### Build your self with Python-Poetry\n\n```Bash\npoetry install\npoetry build\n```\n\n## Example\n\n```Python\n\nfrom pyfinra import Ticker\n\n\ngme = Ticker("Gme")\nprint(gme.quote())\nprint(gme.financials_balancesheet())\nprint(gme.financials_inc_statement())\nprint(gme.financials_cash_flow())\n\n\n# {\'P/E\': \'27.5482\', \'market_cap\': \'2690259848850\', \'shares\': \'16319441000\', \'short_interest\': \'0.668\', \'currency\': \'USD\', \'P/S\': \'7.283949\', \'P/B\': \'37.400042\', \'P/CF\': \'24.551504\', \'exchange\': \'XNAS\'}\n#                                                      2017-09   2018-09   2019-09   2020-09   2021-09\n# Fiscal year ends in September. USD in millions ...                                                  \n# Assets                                                   NaN       NaN       NaN       NaN       NaN\n# Current assets                                           NaN       NaN       NaN       NaN       NaN\n# Cash                                                     NaN       NaN       NaN       NaN       NaN\n# Cash and cash equivalents                            20289.0   25913.0   48844.0   38016.0   34940.0\n# Short-term investments                               53892.0   40388.0   51713.0   52927.0   27699.0\n# Total cash                                           74181.0   66301.0  100557.0   90943.0   62639.0\n# Receivables                                          17874.0   23186.0   22926.0   16120.0   26278.0\n# Inventories                                           4855.0    3956.0    4106.0    4061.0    6580.0\n# Other current assets                                 31735.0   37896.0   35230.0   32589.0   39339.0\n# Total current assets                                128645.0  131339.0  162819.0  143713.0  134836.0\n# Non-current assets                                       NaN       NaN       NaN       NaN       NaN\n# Property, plant and equipment                            NaN       NaN       NaN       NaN       NaN\n# Gross property, plant and equipment                  75076.0   90403.0   95957.0  103526.0  109723.0\n# Accumulated Depreciation                            -41293.0  -49099.0  -58579.0  -66760.0  -70283.0\n# Net property, plant and equipment                    33783.0   41304.0   37378.0   36766.0   39440.0\n# Equity and other investments                        194714.0  170799.0  105341.0  100887.0  127877.0\n# Goodwill                                              5717.0       NaN       NaN       NaN       NaN\n# Intangible assets                                     2298.0       NaN       NaN       NaN       NaN\n# Other long-term assets                               10162.0   22283.0   32978.0   42522.0   48849.0\n# Total non-current assets                            246674.0  234386.0  175697.0  180175.0  216166.0\n# Total assets                                        375319.0  365725.0  338516.0  323888.0  351002.0\n# Liabilities and stockholders\' equity                     NaN       NaN       NaN       NaN       NaN\n# Liabilities                                              NaN       NaN       NaN       NaN       NaN\n# Current liabilities                                      NaN       NaN       NaN       NaN       NaN\n# Short-term debt                                      18473.0   20748.0   16240.0   13769.0   15613.0\n# Accounts payable                                     49049.0   55888.0   46236.0   42296.0   54763.0\n# Accrued liabilities                                  25744.0       NaN       NaN       NaN       NaN\n# Deferred revenues                                     7548.0    7543.0    5522.0    6643.0    7612.0\n# Other current liabilities                                NaN   32687.0   37720.0   42684.0   47493.0\n# Total current liabilities                           100814.0  116866.0  105718.0  105392.0  125481.0\n# Non-current liabilities                                  NaN       NaN       NaN       NaN       NaN\n# Long-term debt                                       97207.0   93735.0   91807.0   98667.0  109106.0\n# Deferred taxes liabilities                           31504.0     426.0       NaN       NaN       NaN\n# Deferred revenues                                     2836.0    2797.0       NaN       NaN       NaN\n# Other long-term liabilities                           8911.0   44754.0   50503.0   54490.0   53325.0\n# Total non-current liabilities                       140458.0  141712.0  142310.0  153157.0  162431.0\n# Total liabilities                                   241272.0  258578.0  248028.0  258549.0  287912.0\n# Stockholders\' equity                                     NaN       NaN       NaN       NaN       NaN\n# Common stock                                         35867.0   40201.0   45174.0   50779.0   57365.0\n# Retained earnings                                    98330.0   70400.0   45898.0   14966.0    5562.0\n# Accumulated other comprehensive income                -150.0   -3454.0    -584.0    -406.0     163.0\n# Total stockholders\' equity                          134047.0  107147.0   90488.0   65339.0   63090.0\n# Total liabilities and stockholders\' equity          375319.0  365725.0  338516.0  323888.0  351002.0\n#\n#                                                       2020-12   2021-03   2021-06   2021-09    2021-12        TTM\n# Fiscal year ends in September. USD in millions ...                                                               \n# Revenue                                             111439.00  89584.00  81434.00  83360.00  123945.00  378323.00\n# Cost of revenue                                      67111.00  51505.00  46179.00  48186.00   69702.00  215572.00\n# Gross profit                                         44328.00  38079.00  35255.00  35174.00   54243.00  162751.00\n# Operating expenses                                        NaN       NaN       NaN       NaN        NaN        NaN\n# Research and development                              5163.00   5262.00   5717.00   5772.00    6306.00   23057.00\n# Sales, General and administrative                     5631.00   5314.00   5412.00   5616.00    6449.00   22791.00\n# Total operating expenses                             10794.00  10576.00  11129.00  11388.00   12755.00   45848.00\n# Operating income                                     33534.00  27503.00  24126.00  23786.00   41488.00  116903.00\n# Interest Expense                                       638.00    670.00    665.00    672.00     694.00    2701.00\n# Other income (expense)                                 683.00   1178.00    908.00    134.00     447.00    2667.00\n# Income before taxes                                  33579.00  28011.00  24369.00  23248.00   41241.00  116869.00\n# Provision for income taxes                            4824.00   4381.00   2625.00   2697.00    6611.00   16314.00\n# Net income from continuing operations                28755.00  23630.00  21744.00  20551.00   34630.00  100555.00\n# Net income                                           28755.00  23630.00  21744.00  20551.00   34630.00  100555.00\n# Net income available to common shareholders          28755.00  23630.00  21744.00  20551.00   34630.00  100555.00\n# Earnings per share                                        NaN       NaN       NaN       NaN        NaN        NaN\n# Basic                                                    1.70      1.41      1.31      1.25       2.11       6.08\n# Diluted                                                  1.68      1.40      1.30      1.24       2.10       6.03\n# Weighted average shares outstanding                       NaN       NaN       NaN       NaN        NaN        NaN\n# Basic                                                16935.00  16753.00  16629.00  16487.00   16392.00   16565.00\n# Diluted                                              17114.00  16929.00  16782.00  16635.00   16519.00   16716.00\n# EBITDA                                               36883.00  31478.00  27866.00  26909.00   44632.00  130885.00\n#\n#                                                     2020-12  2021-03  2021-06  2021-09  2021-12\n# Fiscal year ends in September. USD in millions ...                                             \n# Cash Flows From Operating Activities                    NaN      NaN      NaN      NaN      NaN\n# Net income                                          28755.0  23630.0  21744.0  20551.0  34630.0\n# Depreciation & amortization                          2666.0   2797.0   2832.0   2989.0   2697.0\n# Deferred income taxes                                 -58.0   -149.0   -530.0  -4037.0    682.0\n# Stock based compensation                             2020.0   1981.0   1960.0   1945.0   2265.0\n# Change in working capital                            5355.0  -3779.0  -4697.0  -1790.0   6525.0\n# Accounts receivable                                -10945.0   8598.0   1031.0  -8809.0  -3934.0\n# Inventory                                            -950.0   -276.0     13.0  -1429.0    681.0\n# Accounts payable                                    21670.0 -23667.0    211.0  14112.0  19813.0\n# Other working capital                               -4420.0  11566.0  -5952.0  -5664.0 -10035.0\n# Other non-cash items                                   25.0   -499.0   -215.0    542.0    167.0\n# Net cash provided by operating activities           38763.0  23981.0  21094.0  20200.0  46966.0\n# Cash Flows From Investing Activities                    NaN      NaN      NaN      NaN      NaN\n# Investments in property, plant, and equipment       -3500.0  -2269.0  -2093.0  -3223.0  -2803.0\n# Acquisitions, net                                      -9.0      NaN     -4.0    -20.0      NaN\n# Purchases of investments                           -39800.0 -34624.0 -19628.0 -15637.0 -34913.0\n# Sales/Maturities of investments                     34521.0  26729.0  25375.0  20245.0  21984.0\n# Other investing activities                            204.0   -204.0    -78.0   -530.0   -374.0\n# Net cash used for investing activities              -8584.0 -10368.0   3572.0    835.0 -16106.0\n# Cash Flows From Financing Activities                    NaN      NaN      NaN      NaN      NaN\n# Debt issued                                             NaN      NaN   3000.0   3448.0      NaN\n# Debt repayment                                      -1000.0  -3500.0  -3000.0  -1250.0      NaN\n# Common stock issued                                     NaN    561.0      NaN    544.0      NaN\n# Common stock repurchased                           -24775.0 -18548.0 -22900.0 -19748.0 -20478.0\n# Dividend paid                                       -3613.0  -3447.0  -3767.0  -3640.0  -3732.0\n# Other financing activities                          -2861.0  13608.0  -2729.0    264.0  -3949.0\n# Net cash provided by (used for) financing activ... -32249.0 -11326.0 -29396.0 -20382.0 -28159.0\n# Net change in cash                                  -2070.0   2287.0  -4730.0    653.0   2701.0\n# Cash at beginning of period                         39789.0  37719.0  40006.0  35276.0  35929.0\n# Cash at end of period                               37719.0  40006.0  35276.0  35929.0  38630.0\n# Free Cash Flow                                          NaN      NaN      NaN      NaN      NaN\n# Operating cash flow                                 38763.0  23981.0  21094.0  20200.0  46966.0\n# Capital expenditure                                 -3500.0  -2269.0  -2093.0  -3223.0  -2803.0\n# Free cash flow                                      35263.0  21712.0  19001.0  16977.0  44163.0\n\n\n```\n',
    'author': 'T-136',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/T-136/pyfinra',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
