# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.2, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

    T = TypeVar("T")
    ClsType = Optional[
        Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]
    ]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_get_all_resumes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resumes")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_resume_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resumes")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    format = kwargs.pop('format', _params.pop('format', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resumes/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if format is not None:
        _params['format'] = _SERIALIZER.query("format", format, 'str')

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_update_resume_data_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resumes/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resumes/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_redacted_resumes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/redacted_resumes")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_redacted_resume_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/redacted_resumes")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_redacted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/redacted_resumes/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_redacted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/redacted_resumes/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_resume_search_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_get_resume_search_detail_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search/details/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_resume_search_match_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    resume = kwargs.pop('resume')  # type: str
    job_description = kwargs.pop('job_description')  # type: str
    index = kwargs.pop('index', _params.pop('index', None))  # type: Optional[str]
    search_expression = kwargs.pop('search_expression', _params.pop('search_expression', None))  # type: Optional[str]
    job_titles_weight = kwargs.pop('job_titles_weight', _params.pop('job_titles_weight', None))  # type: Optional[float]
    years_experience_weight = kwargs.pop('years_experience_weight', _params.pop('years_experience_weight', None))  # type: Optional[float]
    locations_weight = kwargs.pop('locations_weight', _params.pop('locations_weight', None))  # type: Optional[float]
    languages_weight = kwargs.pop('languages_weight', _params.pop('languages_weight', None))  # type: Optional[float]
    skills_weight = kwargs.pop('skills_weight', _params.pop('skills_weight', None))  # type: Optional[float]
    education_weight = kwargs.pop('education_weight', _params.pop('education_weight', None))  # type: Optional[float]
    search_expression_weight = kwargs.pop('search_expression_weight', _params.pop('search_expression_weight', None))  # type: Optional[float]
    soc_codes_weight = kwargs.pop('soc_codes_weight', _params.pop('soc_codes_weight', None))  # type: Optional[float]
    management_level_weight = kwargs.pop('management_level_weight', _params.pop('management_level_weight', None))  # type: Optional[float]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search/match")

    # Construct parameters
    _params['resume'] = _SERIALIZER.query("resume", resume, 'str')
    _params['job_description'] = _SERIALIZER.query("job_description", job_description, 'str')
    if index is not None:
        _params['index'] = _SERIALIZER.query("index", index, 'str')
    if search_expression is not None:
        _params['search_expression'] = _SERIALIZER.query("search_expression", search_expression, 'str')
    if job_titles_weight is not None:
        _params['job_titles_weight'] = _SERIALIZER.query("job_titles_weight", job_titles_weight, 'float', maximum=1, minimum=0)
    if years_experience_weight is not None:
        _params['years_experience_weight'] = _SERIALIZER.query("years_experience_weight", years_experience_weight, 'float', maximum=1, minimum=0)
    if locations_weight is not None:
        _params['locations_weight'] = _SERIALIZER.query("locations_weight", locations_weight, 'float', maximum=1, minimum=0)
    if languages_weight is not None:
        _params['languages_weight'] = _SERIALIZER.query("languages_weight", languages_weight, 'float', maximum=1, minimum=0)
    if skills_weight is not None:
        _params['skills_weight'] = _SERIALIZER.query("skills_weight", skills_weight, 'float', maximum=1, minimum=0)
    if education_weight is not None:
        _params['education_weight'] = _SERIALIZER.query("education_weight", education_weight, 'float', maximum=1, minimum=0)
    if search_expression_weight is not None:
        _params['search_expression_weight'] = _SERIALIZER.query("search_expression_weight", search_expression_weight, 'float', maximum=1, minimum=0)
    if soc_codes_weight is not None:
        _params['soc_codes_weight'] = _SERIALIZER.query("soc_codes_weight", soc_codes_weight, 'float', maximum=1, minimum=0)
    if management_level_weight is not None:
        _params['management_level_weight'] = _SERIALIZER.query("management_level_weight", management_level_weight, 'float', maximum=1, minimum=0)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_get_resume_search_config_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search/config")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_resume_search_config_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search/config")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_resume_search_embed_url_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/resume_search/embed")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_job_descriptions_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_descriptions")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_job_description_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_descriptions")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_job_description_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_descriptions/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_job_description_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_descriptions/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_job_description_search_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_description_search")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_get_job_description_search_detail_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_description_search/details/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_job_description_search_config_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_description_search/config")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_job_description_search_config_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_description_search/config")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_job_description_search_embed_url_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/job_description_search/embed")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_indexes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    document_type = kwargs.pop('document_type', _params.pop('document_type', None))  # type: Optional[Union[str, "_models.Enum1"]]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)
    if document_type is not None:
        _params['document_type'] = _SERIALIZER.query("document_type", document_type, 'str')

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_index_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_index_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index/{name}")
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_index_documents_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index/{name}/documents")
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_index_document_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index/{name}/documents")
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_index_document_request(
    name,  # type: str
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/index/{name}/documents/{identifier}")
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_invoices_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/invoices")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_invoice_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/invoices")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_invoice_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/invoices/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_delete_invoice_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/invoices/{identifier}")
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_list_occupation_groups_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/occupation_groups")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_all_users_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    offset = kwargs.pop('offset', _params.pop('offset', None))  # type: Optional[int]
    limit = kwargs.pop('limit', _params.pop('limit', 300))  # type: Optional[int]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/users")

    # Construct parameters
    if offset is not None:
        _params['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)
    if limit is not None:
        _params['limit'] = _SERIALIZER.query("limit", limit, 'int', maximum=300, minimum=1)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_user_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/users")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )

# fmt: on
class AffindaAPIOperationsMixin(object):  # pylint: disable=too-many-public-methods
    def get_all_resumes(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.GetAllDocumentsResults, _models.RequestError]
        """Get list of all resumes.

        Returns all the resume summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllDocumentsResults, _models.RequestError]]

        request = build_get_all_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {"url": "/resumes"}  # type: ignore

    def create_resume(
        self,
        file=None,  # type: Optional[IO]
        url=None,  # type: Optional[str]
        data=None,  # type: Optional[_models.ResumeData]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        language=None,  # type: Optional[str]
        expiry_time=None,  # type: Optional[datetime.datetime]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Resume, _models.RequestError]
        """Upload a resume for parsing.

        Uploads a resume for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/resumes/{identifier} <#get-/resumes/-identifier->`_ endpoint to check
        processing status and retrieve results.:code:`<br/>`
        Resumes can be uploaded as a file or a URL. In addition, data can be added directly if users
        want to upload directly without parsing any resume file. For uploading resume data, the
        ``data`` argument provided must be a JSON-encoded string. Data uploads will not impact upon
        parsing credits.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param data:  Default value is None.
        :type data: ~affinda.models.ResumeData
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Union[_models.Resume, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {"url": "/resumes"}  # type: ignore

    def get_resume(
        self,
        identifier,  # type: str
        format=None,  # type: Optional[str]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Resume, _models.RequestError]
        """Get parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :param format: Set this to "hr-xml" to get the response in HR-XML format. Currently the only
         supported value for this parameter is "hr-xml". Default value is None.
        :type format: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Union[_models.Resume, _models.RequestError]]

        request = build_get_resume_request(
            identifier=identifier,
            format=format,
            template_url=self.get_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    def update_resume_data(
        self,
        identifier,  # type: str
        body,  # type: _models.ResumeData
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[Optional[_models.ResumeData], _models.RequestError]
        """Update a resume's data.

        Update data of a parsed resume.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Resume data to update.
        :type body: ~affinda.models.ResumeData
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeData or None or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeData or None or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[Optional[_models.ResumeData], _models.RequestError]]

        _json = self._serialize.body(body, "ResumeData")

        request = build_update_resume_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeData", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_data.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    def delete_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    def get_all_redacted_resumes(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.GetAllDocumentsResults, _models.RequestError]
        """Get list of all redacted resumes.

        Returns all the redacted resume information for that resume.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllDocumentsResults, _models.RequestError]]

        request = build_get_all_redacted_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_redacted_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {"url": "/redacted_resumes"}  # type: ignore

    def create_redacted_resume(
        self,
        file=None,  # type: Optional[IO]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        url=None,  # type: Optional[str]
        language=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        redact_headshot=True,  # type: Optional[bool]
        redact_personal_details=True,  # type: Optional[bool]
        redact_work_details=True,  # type: Optional[bool]
        redact_education_details=True,  # type: Optional[bool]
        redact_referees=True,  # type: Optional[bool]
        redact_locations=True,  # type: Optional[bool]
        redact_dates=True,  # type: Optional[bool]
        redact_gender="true",  # type: Optional[str]
        expiry_time=None,  # type: Optional[datetime.datetime]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.RedactedResume, _models.RequestError]
        """Upload a resume for redacting.

        Uploads a resume for redacting.

        :param file:  Default value is None.
        :type file: IO
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param url:  Default value is None.
        :type url: str
        :param language:  Default value is None.
        :type language: str
        :param wait:  Default value is True.
        :type wait: bool
        :param redact_headshot: Whether to redact headshot. Default value is True.
        :type redact_headshot: bool
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
         Default value is True.
        :type redact_personal_details: bool
        :param redact_work_details: Whether to redact work details (e.g. company names). Default value
         is True.
        :type redact_work_details: bool
        :param redact_education_details: Whether to redact education details (e.g. university names).
         Default value is True.
        :type redact_education_details: bool
        :param redact_referees: Whether to redact referee details. Default value is True.
        :type redact_referees: bool
        :param redact_locations: Whether to redact location names. Default value is True.
        :type redact_locations: bool
        :param redact_dates: Whether to redact dates. Default value is True.
        :type redact_dates: bool
        :param redact_gender: Whether to redact gender. Default value is "true".
        :type redact_gender: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.RedactedResume, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "language": language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "redactGender": redact_gender,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {"url": "/redacted_resumes"}  # type: ignore

    def get_redacted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.RedactedResume, _models.RequestError]
        """Get redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#post-/redacted_resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.RedactedResume, _models.RequestError]]

        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    def delete_redacted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    def create_resume_search(
        self,
        body,  # type: _models.ResumeSearchParameters
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearch, _models.RequestError]
        """Search through parsed resumes.

        Searches through parsed resumes. Users have 3 options to create a search::code:`<br
        />`:code:`<br />` 1.    Match to a job description - a parsed job description is used to find
        candidates that suit it:code:`<br />` 2.  Match to a resume - a parsed resume is used to find
        other candidates that have similar attributes:code:`<br />` 3.  Search using custom
        criteria:code:`<br />`:code:`<br />` Users should only populate 1 of jobDescription, resume or
        the custom criteria.

        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearch, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_create_resume_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_resume_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize("ResumeSearch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search.metadata = {"url": "/resume_search"}  # type: ignore

    def get_resume_search_detail(
        self,
        identifier,  # type: str
        body,  # type: _models.ResumeSearchParameters
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearchDetail, _models.RequestError]
        """Get search result of specific resume.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this resume.
        The ``identifier`` is the unique ID returned via the `/resume_search <#post-/resume_search>`_
        endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchDetail or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchDetail or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchDetail, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_get_resume_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_resume_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchDetail", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_detail.metadata = {"url": "/resume_search/details/{identifier}"}  # type: ignore

    def get_resume_search_match(
        self,
        resume,  # type: str
        job_description,  # type: str
        index=None,  # type: Optional[str]
        search_expression=None,  # type: Optional[str]
        job_titles_weight=None,  # type: Optional[float]
        years_experience_weight=None,  # type: Optional[float]
        locations_weight=None,  # type: Optional[float]
        languages_weight=None,  # type: Optional[float]
        skills_weight=None,  # type: Optional[float]
        education_weight=None,  # type: Optional[float]
        search_expression_weight=None,  # type: Optional[float]
        soc_codes_weight=None,  # type: Optional[float]
        management_level_weight=None,  # type: Optional[float]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearchMatch, _models.RequestError]
        """Match a single resume and job description.

        Get the matching score between a resume and a job description. The score ranges between 0 and
        1, with 0 being not a match at all, and 1 being perfect match.:code:`<br/>` Note, this score
        will not directly match the score returned from POST `/resume_search/details/{identifier}
        <#post-/resume_search/details/-identifier->`_.

        :param resume: Identify the resume to match.
        :type resume: str
        :param job_description: Identify the job description to match.
        :type job_description: str
        :param index: Optionally, specify an index to search in. If not specified, will search in all
         indexes. Default value is None.
        :type index: str
        :param search_expression: Add keywords to the search criteria. Default value is None.
        :type search_expression: str
        :param job_titles_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type job_titles_weight: float
        :param years_experience_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type years_experience_weight: float
        :param locations_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type locations_weight: float
        :param languages_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type languages_weight: float
        :param skills_weight: How important is this criteria to the matching score, range from 0 to 1.
         Default value is None.
        :type skills_weight: float
        :param education_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type education_weight: float
        :param search_expression_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type search_expression_weight: float
        :param soc_codes_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type soc_codes_weight: float
        :param management_level_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type management_level_weight: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchMatch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchMatch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchMatch, _models.RequestError]]

        request = build_get_resume_search_match_request(
            resume=resume,
            job_description=job_description,
            index=index,
            search_expression=search_expression,
            job_titles_weight=job_titles_weight,
            years_experience_weight=years_experience_weight,
            locations_weight=locations_weight,
            languages_weight=languages_weight,
            skills_weight=skills_weight,
            education_weight=education_weight,
            search_expression_weight=search_expression_weight,
            soc_codes_weight=soc_codes_weight,
            management_level_weight=management_level_weight,
            template_url=self.get_resume_search_match.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchMatch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_match.metadata = {"url": "/resume_search/match"}  # type: ignore

    def get_resume_search_config(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearchConfig, _models.RequestError]
        """Get the config for the logged in user's embeddable resume search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchConfig, _models.RequestError]]

        request = build_get_resume_search_config_request(
            template_url=self.get_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    def update_resume_search_config(
        self,
        body,  # type: _models.ResumeSearchConfig
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearchConfig, _models.RequestError]
        """Update the config for the logged in user's embeddable resume search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :param body:
        :type body: ~affinda.models.ResumeSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchConfig, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchConfig")

        request = build_update_resume_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    def create_resume_search_embed_url(
        self,
        body=None,  # type: Optional[_models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.ResumeSearchEmbed, _models.RequestError]
        """Create a signed URL for the embeddable resume search tool.

        Create and return a signed URL of the resume search tool which then can be embedded on a web
        page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable resume search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchEmbed or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchEmbed or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchEmbed, _models.RequestError]]

        if body is not None:
            _json = self._serialize.body(
                body, "Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema"
            )
        else:
            _json = None

        request = build_create_resume_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resume_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchEmbed", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search_embed_url.metadata = {"url": "/resume_search/embed"}  # type: ignore

    def get_all_job_descriptions(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.GetAllJobDescriptionsResults, _models.RequestError]
        """Get list of all job descriptions.

        Returns all the job descriptions for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllJobDescriptionsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllJobDescriptionsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllJobDescriptionsResults, _models.RequestError]]

        request = build_get_all_job_descriptions_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_job_descriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllJobDescriptionsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_job_descriptions.metadata = {"url": "/job_descriptions"}  # type: ignore

    def create_job_description(
        self,
        file=None,  # type: Optional[IO]
        url=None,  # type: Optional[str]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        language=None,  # type: Optional[str]
        expiry_time=None,  # type: Optional[datetime.datetime]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescription, _models.RequestError]
        """Upload a job description for parsing.

        Uploads a job description for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/job_descriptions/{identifier} <#get-/job_descriptions/-identifier->`_ endpoint to check
        processing status and retrieve results.
        Job Descriptions can be uploaded as a file or a URL.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescription, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_job_description_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description.metadata = {"url": "/job_descriptions"}  # type: ignore

    def get_job_description(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescription, _models.RequestError]
        """Get job description results for a specific job description file.

        Returns all the results for that job description if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/job_descriptions <#post-/job_descriptions>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescription, _models.RequestError]]

        request = build_get_job_description_request(
            identifier=identifier,
            template_url=self.get_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    def delete_job_description(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete a job description.

        Deletes the specified job description from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_job_description_request(
            identifier=identifier,
            template_url=self.delete_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    def create_job_description_search(
        self,
        body,  # type: _models.JobDescriptionSearchParameters
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescriptionSearch, _models.RequestError]
        """Search through parsed job descriptions.

        Searches through parsed job descriptions. You can search with custom criterias or a resume.

        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearch, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_create_job_description_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_job_description_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescriptionSearch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search.metadata = {"url": "/job_description_search"}  # type: ignore

    def get_job_description_search_detail(
        self,
        identifier,  # type: str
        body,  # type: _models.JobDescriptionSearchParameters
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescriptionSearchDetail, _models.RequestError]
        """Get search result of specific job description.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this job description.
        The ``identifier`` is the unique ID returned via the `/job_description_search
        <#post-/job_description_search>`_ endpoint.

        :param identifier: Job Description identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchDetail or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchDetail or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchDetail, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_get_job_description_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_job_description_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchDetail", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_detail.metadata = {"url": "/job_description_search/details/{identifier}"}  # type: ignore

    def get_job_description_search_config(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescriptionSearchConfig, _models.RequestError]
        """Get the config for the logged in user's embeddable job description search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchConfig, _models.RequestError]]

        request = build_get_job_description_search_config_request(
            template_url=self.get_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    def update_job_description_search_config(
        self,
        body,  # type: _models.JobDescriptionSearchConfig
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescriptionSearchConfig, _models.RequestError]
        """Update the config for the logged in user's embeddable job description search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :param body:
        :type body: ~affinda.models.JobDescriptionSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchConfig, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchConfig")

        request = build_update_job_description_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    def create_job_description_search_embed_url(
        self,
        body=None,  # type: Optional[_models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.JobDescriptionSearchEmbed, _models.RequestError]
        """Create a signed URL for the embeddable job description search tool.

        Create and return a signed URL of the job description search tool which then can be embedded on
        a web page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchEmbed or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchEmbed or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchEmbed, _models.RequestError]]

        if body is not None:
            _json = self._serialize.body(
                body,
                "PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema",
            )
        else:
            _json = None

        request = build_create_job_description_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_job_description_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchEmbed", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search_embed_url.metadata = {"url": "/job_description_search/embed"}  # type: ignore

    def get_all_indexes(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        document_type=None,  # type: Optional[Union[str, "_models.Enum1"]]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, _models.RequestError]
        """Get list of all indexes.

        Returns all the indexes.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param document_type: Filter indices by a document type. Default value is None.
        :type document_type: str or ~affinda.models.Enum1
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_indexes_request(
            offset=offset,
            limit=limit,
            document_type=document_type,
            template_url=self.get_all_indexes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_indexes.metadata = {"url": "/index"}  # type: ignore

    def create_index(
        self,
        name=None,  # type: Optional[str]
        document_type=None,  # type: Optional[Union[str, "_models.PostContentSchemaDocumentType"]]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, _models.RequestError]
        """Create a new index.

        Create an index for the search tool.

        :param name:  Default value is None.
        :type name: str
        :param document_type:  Default value is None.
        :type document_type: str or ~affinda.models.PostContentSchemaDocumentType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        # Construct form data
        _files = {
            "name": name,
            "documentType": document_type,
        }

        request = build_create_index_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index.metadata = {"url": "/index"}  # type: ignore

    def delete_index(
        self,
        name,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete an index.

        Deletes the specified index from the database.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_index_request(
            name=name,
            template_url=self.delete_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_index.metadata = {"url": "/index/{name}"}  # type: ignore

    def get_all_index_documents(
        self,
        name,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema, _models.RequestError]
        """Get indexed documents for a specific index.

        Returns all the indexed documents for that index.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema or
         RequestError, or the result of cls(response)
        :rtype:
         ~affinda.models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_index_documents_request(
            name=name,
            template_url=self.get_all_index_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema",
                pipeline_response,
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_index_documents.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    def create_index_document(
        self,
        name,  # type: str
        body,  # type: _models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema, _models.RequestError]
        """Index a new document.

        Create an indexed document for the search tool.

        :param name: Index name.
        :type name: str
        :param body: Document to index.
        :type body:
         ~affinda.models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema or
         RequestError, or the result of cls(response)
        :rtype:
         ~affinda.models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        _json = self._serialize.body(
            body, "PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema"
        )

        request = build_create_index_document_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.create_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema",
                pipeline_response,
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index_document.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    def delete_index_document(
        self,
        name,  # type: str
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete an indexed document.

        Delete the specified indexed document from the database.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.delete_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_index_document.metadata = {"url": "/index/{name}/documents/{identifier}"}  # type: ignore

    def get_all_invoices(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.GetAllInvoicesResults, _models.RequestError]
        """Get list of all invoices.

        Returns all the invoice summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllInvoicesResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllInvoicesResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllInvoicesResults, _models.RequestError]]

        request = build_get_all_invoices_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_invoices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllInvoicesResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invoices.metadata = {"url": "/invoices"}  # type: ignore

    def create_invoice(
        self,
        file=None,  # type: Optional[IO]
        url=None,  # type: Optional[str]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        language=None,  # type: Optional[str]
        expiry_time=None,  # type: Optional[datetime.datetime]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Invoice, _models.RequestError]
        """Upload an invoice for parsing.

        Uploads an invoice for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/invoices/{identifier} <#get-/invoices/-identifier->`_ endpoint to check processing status and
        retrieve results.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Invoice or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Invoice, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_invoice_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invoice.metadata = {"url": "/invoices"}  # type: ignore

    def get_invoice(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.Invoice, _models.RequestError]
        """Get parse results for a specific invoice.

        Returns all the parse results for that invoice if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the invoice via the `/invoices
        <#post-/invoices>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Invoice or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Invoice, _models.RequestError]]

        request = build_get_invoice_request(
            identifier=identifier,
            template_url=self.get_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    def delete_invoice(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional[_models.RequestError]
        """Delete an invoice.

        Delete the specified invoice from the database. Note, any invoices deleted from the database
        will no longer be used in any tailored customer models.

        :param identifier: Invoice identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_invoice_request(
            identifier=identifier,
            template_url=self.delete_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    def list_occupation_groups(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union[List[_models.OccupationGroup], _models.RequestError]
        """List occupation groups.

        Returns the list of searchable occupation groups.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of OccupationGroup or RequestError, or the result of cls(response)
        :rtype: list[~affinda.models.OccupationGroup] or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[List[_models.OccupationGroup], _models.RequestError]]

        request = build_list_occupation_groups_request(
            template_url=self.list_occupation_groups.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("[OccupationGroup]", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_occupation_groups.metadata = {"url": "/occupation_groups"}  # type: ignore

    def get_all_users(
        self,
        offset=None,  # type: Optional[int]
        limit=300,  # type: Optional[int]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, _models.RequestError]
        """Get list of all users.

        Returns all the users.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_users_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_users.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_users.metadata = {"url": "/users"}  # type: ignore

    def create_user(
        self,
        username,  # type: str
        id=None,  # type: Optional[int]
        name=None,  # type: Optional[str]
        email=None,  # type: Optional[str]
        api_key=None,  # type: Optional[str]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union[_models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema, _models.RequestError]
        """Create a new user.

        Create an user as part of your account.

        :param username:
        :type username: str
        :param id:  Default value is None.
        :type id: int
        :param name:  Default value is None.
        :type name: str
        :param email:  Default value is None.
        :type email: str
        :param api_key:  Default value is None.
        :type api_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        # Construct form data
        _files = {
            "id": id,
            "name": name,
            "username": username,
            "email": email,
            "apiKey": api_key,
        }

        request = build_create_user_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_user.metadata = {"url": "/users"}  # type: ignore
