# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['CloudIntegrationNewRelic']


class CloudIntegrationNewRelic(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 app_filter_regex: Optional[pulumi.Input[str]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 host_filter_regex: Optional[pulumi.Input[str]] = None,
                 metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudIntegrationNewRelicMetricFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Wavefront Cloud Integration for NewRelic. This allows NewRelic cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        newrelic = wavefront.CloudIntegrationNewRelic("newrelic", api_key="example-api-key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] api_key: NewRelic REST api key
        :param pulumi.Input[str] app_filter_regex: A regular expression that an application name must match (case-insensitively) iun order to collect metrics
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudIntegrationNewRelicMetricFilterArgs']]]] metric_filters: See Metric Filter
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_tags'] = additional_tags
            if api_key is None:
                raise TypeError("Missing required property 'api_key'")
            __props__['api_key'] = api_key
            __props__['app_filter_regex'] = app_filter_regex
            __props__['force_save'] = force_save
            __props__['host_filter_regex'] = host_filter_regex
            __props__['metric_filters'] = metric_filters
            __props__['name'] = name
            if service is None:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['service_refresh_rate_in_minutes'] = service_refresh_rate_in_minutes
        super(CloudIntegrationNewRelic, __self__).__init__(
            'wavefront:index/cloudIntegrationNewRelic:CloudIntegrationNewRelic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            app_filter_regex: Optional[pulumi.Input[str]] = None,
            force_save: Optional[pulumi.Input[bool]] = None,
            host_filter_regex: Optional[pulumi.Input[str]] = None,
            metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudIntegrationNewRelicMetricFilterArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None) -> 'CloudIntegrationNewRelic':
        """
        Get an existing CloudIntegrationNewRelic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] api_key: NewRelic REST api key
        :param pulumi.Input[str] app_filter_regex: A regular expression that an application name must match (case-insensitively) iun order to collect metrics
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudIntegrationNewRelicMetricFilterArgs']]]] metric_filters: See Metric Filter
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_tags"] = additional_tags
        __props__["api_key"] = api_key
        __props__["app_filter_regex"] = app_filter_regex
        __props__["force_save"] = force_save
        __props__["host_filter_regex"] = host_filter_regex
        __props__["metric_filters"] = metric_filters
        __props__["name"] = name
        __props__["service"] = service
        __props__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationNewRelic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration
        """
        return pulumi.get(self, "additional_tags")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        NewRelic REST api key
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="appFilterRegex")
    def app_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        A regular expression that an application name must match (case-insensitively) iun order to collect metrics
        """
        return pulumi.get(self, "app_filter_regex")

    @property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> pulumi.Output[Optional[bool]]:
        """
        Forces this resource to save, even if errors are present
        """
        return pulumi.get(self, "force_save")

    @property
    @pulumi.getter(name="hostFilterRegex")
    def host_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        A regular expression that a host name must match (case-insensitively) in order to collect metrics
        """
        return pulumi.get(self, "host_filter_regex")

    @property
    @pulumi.getter(name="metricFilters")
    def metric_filters(self) -> pulumi.Output[Optional[Sequence['outputs.CloudIntegrationNewRelicMetricFilter']]]:
        """
        See Metric Filter
        """
        return pulumi.get(self, "metric_filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name of this integration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        A value denoting which cloud service this service integrates with
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        How often, in minutes, to refresh the service
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

