from typing import Self, SupportsIndex
from .vector2 import Vector2

class MVector2:
    @staticmethod
    def zero() -> MVector2: ...
    @staticmethod
    def one() -> MVector2: ...
    @staticmethod
    def up() -> MVector2: ...
    @staticmethod
    def down() -> MVector2: ...
    @staticmethod
    def left() -> MVector2: ...
    @staticmethod
    def right() -> MVector2: ...

    x: float
    y: float

    def __init__(self, x: float, y: float) -> None: ...

    @staticmethod
    def from_immutable(immutable: Vector2) -> MVector2: ...

    def __getitem__(self, i: SupportsIndex) -> float: ...

    def __repr__(self) -> str: ...

    def __len__(self) -> int: ...

    def __iadd__(self, other: MVector2 | Vector2) -> Self: ...

    def __isub__(self, other: MVector2 | Vector2) -> Self: ...

    def __imul__(self, other: MVector2 | Vector2 | float | int) -> Self: ...

    def __itruediv__(self, other: MVector2 | Vector2 | float | int) -> Self: ...

    def __ifloordiv__(self, other: MVector2 | Vector2 | float | int) -> Self: ...

    def __imod__(self, other: MVector2 | Vector2 | float | int) -> Self: ...

    def __eq__(self, other: MVector2) -> bool: ...

    @property
    def magnitude(self) -> float:
        """The length of this vector."""
        ...

    def copy(self) -> MVector2:
        """Make a new vector where the components' values match this vectors values."""
        ...

    @property
    def normalized(self) -> MVector2:
        """A copy of this vector with a magnitude of 1"""
        ...

    def normalize(self) -> None:
        """Make this vector keep its direction, but have a magnitude of 1. Operates in place."""
        ...

    @staticmethod
    def min(a: MVector2, b: MVector2) -> MVector2:
        """Create a new `MVector2` by selecting the smallest components of the two given `MVector2` instances."""
        ...

    @staticmethod
    def max(a: MVector2, b: MVector2) -> MVector2:
        """Create a new `MVector2` by selecting the largest components of the two given `MVector2` instances."""
        ...

    def to_immutable(self) -> Vector2: ...
    def to_tuple(self) -> tuple[float, float]: ...
    def to_dict(self) -> dict[str, float]: ...
