from typing import Self, SupportsIndex
from .vector2_int import Vector2Int

class MVector2Int:
    @staticmethod
    def zero() -> MVector2Int: ...
    @staticmethod
    def one() -> MVector2Int: ...
    @staticmethod
    def up() -> MVector2Int: ...
    @staticmethod
    def down() -> MVector2Int: ...
    @staticmethod
    def left() -> MVector2Int: ...
    @staticmethod
    def right() -> MVector2Int: ...

    x: int
    y: int

    def __init__(self, x: int, y: int) -> None: ...

    @staticmethod
    def from_immutable(immutable: Vector2Int) -> MVector2Int: ...

    def __getitem__(self, i: SupportsIndex) -> int: ...

    def __repr__(self) -> str: ...

    def __len__(self) -> int: ...

    def __iadd__(self, other: MVector2Int | Vector2Int) -> Self: ...

    def __isub__(self, other: MVector2Int | Vector2Int) -> Self: ...

    def __imul__(self, other: MVector2Int | Vector2Int | int) -> Self: ...

    def __ifloordiv__(self, other: MVector2Int | Vector2Int | int) -> Self: ...

    def __imod__(self, other: MVector2Int | Vector2Int | int) -> Self: ...

    def __eq__(self, other: MVector2Int) -> bool: ...

    @property
    def magnitude(self) -> float:
        """The length of this vector."""
        ...

    def copy(self) -> MVector2Int:
        """Make a new vector where the components' values match this vectors values."""
        ...

    @staticmethod
    def min(a: MVector2Int, b: MVector2Int) -> MVector2Int:
        """Create a new `MVector2Int` by selecting the smallest components of the two given `MVector2Int` instances."""
        ...

    @staticmethod
    def max(a: MVector2Int, b: MVector2Int) -> MVector2Int:
        """Create a new `MVector2Int` by selecting the largest components of the two given `MVector2Int` instances."""
        ...

    def to_immutable(self) -> Vector2Int: ...
    def to_tuple(self) -> tuple[int, int]: ...
    def to_dict(self) -> dict[str, int]: ...
