import networkx as nx

from neads import Plugin, PluginID


def method(_, name: str, /, *args, **kwargs):
    """Return an arbitrary network generated by NetworkX package.

    This method uses an arbitrary NetworkX generator to create a
    network, which may be analyzed in further steps.

    Parameters
    ----------
    _
        Formal parameter for use with SCM.
    name
        Name of the networks generator.
    *args
        Positional arguments for the generator.
    **kwargs
        Keyword arguments for the generator.

    Returns
    -------
        A network created via the specified generator.

    See Also
    --------
    https://networkx.org/documentation/stable/reference/generators.html
    """

    gen = getattr(nx, name)
    g = gen(*args, **kwargs)
    return g


networkx_generator = Plugin(PluginID('networkx_generator', 0), method)
