from typing import TYPE_CHECKING
import qtawesome as qta
from .toolbar import Toolbar, ToolbarAction

from ...config import Conf

if TYPE_CHECKING:
    from ..main_window import MainWindow
    from ..widgets.qsimulation_managers import QSimulationManagers


class SimgrToolbar(Toolbar):
    '''
    Debugger Contral Toolbar
    '''
    def __init__(self, main_window: 'MainWindow'):
        super().__init__(main_window, 'Simgr')
        self.main_window = main_window

        ico = lambda name: qta.icon(name, color=Conf.palette_buttontext)

        # pylint: disable=unnecessary-lambda
        # lambda added for late bind to simulation_managers which is not ready yet
        self.actions = [
            ToolbarAction(ico("fa5s.plus"),"New", "Start a new Simulation...",
                self.main_window.open_newstate_dialog),
            ToolbarAction(ico("fa5s.play"),"Explore", "",
                lambda : self.simulation_managers._on_explore_clicked()),
            ToolbarAction(ico("fa5s.step-forward"), "Step", "",
                lambda : self.simulation_managers._on_step_clicked()),
            ToolbarAction(ico("fa5s.code-branch"),"Step Until Branch", "",
                lambda : self.simulation_managers._on_step_until_branch_clicked()),
            ToolbarAction(ico("fa5s.pause"), "Interrupt", "",
                          main_window.interrupt_current_job),
        ]

    @property
    def simulation_managers(self) -> 'QSimulationManagers':
        return self.main_window.workspace._get_or_create_symexec_view()._simgrs
