# mypy-boto3-cloudwatch

[![PyPI - mypy-boto3-cloudwatch](https://img.shields.io/pypi/v/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudWatch 1.14.51](https://boto3.amazonaws.com/v1/documentation/api/1.14.51/reference/services/cloudwatch.html#CloudWatch) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudWatch` service.

```bash
python -m pip install boto3-stubs[cloudwatch]
```

## How to use

### Client annotations

`CloudWatchClient` provides annotations for `boto3.client("cloudwatch")`.

```python
import boto3

from mypy_boto3_cloudwatch import CloudWatchClient, CloudWatchServiceResource
from mypy_boto3_cloudwatch.paginator import (
    DescribeAlarmHistoryPaginator,
    DescribeAlarmsPaginator,
    GetMetricDataPaginator,
    ListDashboardsPaginator,
    ListMetricsPaginator,
)
from mypy_boto3_cloudwatch.service_resource import (
    Alarm,
    Metric,
    ServiceResourceAlarmsCollection,
    ServiceResourceMetricsCollection,
)
from mypy_boto3_cloudwatch.type_defs import AlarmHistoryItemTypeDef, ...
from mypy_boto3_cloudwatch.waiter import AlarmExistsWaiter, CompositeAlarmExistsWaiter

client: CloudWatchClient = boto3.client("cloudwatch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudWatchClient = session.client("cloudwatch")
```

### Paginators annotations

`mypy_boto3_cloudwatch.paginator` module contains type annotations for all paginators.

```python

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_alarm_history_paginator: DescribeAlarmHistoryPaginator = client.get_paginator("describe_alarm_history")
describe_alarms_paginator: DescribeAlarmsPaginator = client.get_paginator("describe_alarms")
get_metric_data_paginator: GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_dashboards_paginator: ListDashboardsPaginator = client.get_paginator("list_dashboards")
list_metrics_paginator: ListMetricsPaginator = client.get_paginator("list_metrics")
```


### Waiters annotations

`mypy_boto3_cloudwatch.waiter` module contains type annotations for all waiters.

```python

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
alarm_exists_waiter: AlarmExistsWaiter = client.get_waiter("alarm_exists")
composite_alarm_exists_waiter: CompositeAlarmExistsWaiter = client.get_waiter("composite_alarm_exists")
```


### Service Resource annotations

`CloudWatchServiceResource` provides annotations for `boto3.resource("cloudwatch")`.

```python

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: CloudWatchServiceResource = session.resource("cloudwatch")
```


### Other resources annotations

`mypy_boto3_cloudwatch.service_resource` module contains type annotations for all resources.

```python

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_alarm: Alarm = resource.Alarm(...)
my_metric: Metric = resource.Metric(...)
```



### Collections annotations

`mypy_boto3_cloudwatch.service_resource` module contains type annotations
for all `CloudWatchServiceResource` collections.

```python

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
alarms: cloudwatch_resources.ServiceResourceAlarmsCollection = resource.alarms
metrics: cloudwatch_resources.ServiceResourceMetricsCollection = resource.metrics
```




### Typed dictionations

`mypy_boto3_cloudwatch.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AlarmHistoryItemTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_cloudwatch` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("cloudwatch")
resource = boto3.resource("cloudwatch")

session_client = boto3.Session().client("cloudwatch")
session_resource = boto3.Session().resource("cloudwatch")
```
