# Getting Started with MCP Vector Search

Welcome! This guide will help you get up and running with MCP Vector Search in minutes.

## 📋 What You'll Learn

This section covers:
- **[Installation](installation.md)** - Install and deploy MCP Vector Search
- **[Configuration](configuration.md)** - Configure your project settings
- **[First Steps](first-steps.md)** - Your first search and beyond

## ⚡ Quick Start (60 seconds)

```bash
# 1. Install
pip install mcp-vector-search

# 2. Initialize your project
mcp-vector-search install

# 3. Search your code
mcp-vector-search search "authentication logic"
```

That's it! You're now searching your codebase semantically.

## 📖 Detailed Guides

### 1. Installation
Start here if you haven't installed MCP Vector Search yet.

**[→ Read the Installation Guide](installation.md)**

Topics covered:
- Installation methods (pip, uv, source)
- System requirements
- MCP integration setup
- Verification steps

### 2. Configuration
Learn how to configure MCP Vector Search for your project.

**[→ Read the Configuration Guide](configuration.md)**

Topics covered:
- Configuration file structure
- Common settings
- File extensions and languages
- Indexing behavior
- Advanced options

### 3. First Steps Tutorial
A hands-on tutorial to get you started.

**[→ Start the Tutorial](first-steps.md)**

You'll learn:
- How to index your first project
- Basic search techniques
- Understanding search results
- Common workflows

## 🎯 What's Next?

After completing the getting started guides:

1. **Learn More Techniques** - Check out the [User Guides](../guides/README.md) for detailed how-tos
2. **Explore Commands** - See the [CLI Reference](../reference/cli-commands.md) for all available commands
3. **Optimize Your Setup** - Visit [Advanced Topics](../advanced/README.md) for performance tuning

## 🆘 Need Help?

- **Common Issues**: Check [Troubleshooting](../advanced/troubleshooting.md)
- **Questions**: Visit [GitHub Discussions](https://github.com/bobmatnyc/mcp-vector-search/discussions)
- **Bugs**: Report on [GitHub Issues](https://github.com/bobmatnyc/mcp-vector-search/issues)

---

**[← Back to Documentation Index](../index.md)**
