# User Guides

Step-by-step guides for common tasks and workflows with MCP Vector Search.

## 📚 Available Guides

### Core Usage

#### [CLI Usage Guide](cli-usage.md)
Master the command-line interface with advanced features and tips.

**Topics**: Command groups, interactive mode, output formatting, command suggestions

#### [Searching Code](searching.md)
Learn effective code search strategies and techniques.

**Topics**: Basic search, semantic search, similarity search, filtering results, search operators

#### [Indexing Code](indexing.md)
Best practices for indexing your codebase.

**Topics**: Initial indexing, incremental updates, reindexing strategies, performance tips

### Integration

#### [MCP Integration](mcp-integration.md)
Integrate MCP Vector Search with AI tools like Claude Desktop, Cursor, and more.

**Topics**: Platform setup (Claude Desktop, Cursor, Windsurf, VS Code), configuration, usage examples

#### [File Watching](file-watching.md)
Keep your index automatically up-to-date with file watching.

**Topics**: Enabling file watching, configuration, performance considerations, troubleshooting

## 🎯 Choose Your Path

### I want to...

**Master the CLI**
→ [CLI Usage Guide](cli-usage.md)

**Search more effectively**
→ [Searching Guide](searching.md)

**Keep my index up-to-date**
→ [Indexing Guide](indexing.md) | [File Watching Guide](file-watching.md)

**Use with Claude Desktop/Cursor**
→ [MCP Integration Guide](mcp-integration.md)

## 💡 Tips for Using These Guides

1. **Progressive Learning**: Start with basics, move to advanced topics
2. **Hands-On**: Try examples in your own codebase
3. **Reference**: Use as a quick reference when needed
4. **Cross-Reference**: Links point to related topics

## 🔗 Related Documentation

- **[Getting Started](../getting-started/README.md)** - New to MCP Vector Search? Start here
- **[Reference](../reference/README.md)** - Complete command and feature reference
- **[Advanced Topics](../advanced/README.md)** - Performance tuning and extending

## 🆘 Need Help?

- **Troubleshooting**: [Common Issues Guide](../advanced/troubleshooting.md)
- **Community**: [GitHub Discussions](https://github.com/bobmatnyc/mcp-vector-search/discussions)
- **Support**: [GitHub Issues](https://github.com/bobmatnyc/mcp-vector-search/issues)

---

**[← Back to Documentation Index](../index.md)**
