# Reference Documentation

Complete technical reference for MCP Vector Search commands, configuration, and features.

## 📖 Quick Reference

### Command Reference
- **[CLI Commands](cli-commands.md)** - Complete command reference with all options

### Configuration Reference
- **[Configuration Options](configuration-options.md)** - All configuration settings explained

### Technical Reference
- **[Supported Languages](supported-languages.md)** - Language support matrix and features
- **[Architecture Overview](architecture.md)** - Project structure and organization
- **[Features](features.md)** - Complete feature list and capabilities

## 📋 Reference Sections

### CLI Commands
Complete reference for all command-line commands.

**[→ View CLI Commands Reference](cli-commands.md)**

All commands covered:
- `install` - Project and MCP setup
- `uninstall` - Remove MCP integrations
- `init` - Initialize project
- `index` - Index codebase
- `search` - Semantic search
- `auto-index` - Automatic reindexing
- `watch` - File watching
- `status` - Project information
- `config` - Configuration management

### Configuration Options
Detailed reference for all configuration settings.

**[→ View Configuration Reference](configuration-options.md)**

Settings covered:
- Core settings (project root, file extensions, embedding models)
- Indexing behavior (dotfiles, gitignore, auto-reindex)
- Search settings (similarity threshold, result limits)
- Performance settings (caching, pooling)
- Advanced settings

### Supported Languages
Language support matrix and parser features.

**[→ View Language Support](supported-languages.md)**

Information provided:
- Currently supported languages (Python, JavaScript, TypeScript, Dart, PHP, Ruby, HTML, Markdown)
- Parser features by language
- Planned language support
- Adding new languages

### Architecture Overview
Project structure and code organization.

**[→ View Architecture](architecture.md)**

Topics covered:
- Directory structure
- Module organization
- Data flow
- Extension points

### Features
Complete feature list and capabilities.

**[→ View Features](features.md)**

Feature categories:
- Core capabilities (semantic search, AST parsing, real-time indexing)
- Developer experience (CLI-first design, rich output, performance)
- Technical features (vector database, embedding models, smart reindexing)

## 🔍 How to Use This Reference

### For Quick Lookups
Jump directly to the specific reference you need:
- Need a command? → [CLI Commands](cli-commands.md)
- Need a config option? → [Configuration Options](configuration-options.md)
- Check language support? → [Supported Languages](supported-languages.md)

### For Comprehensive Understanding
Read the reference sections in order to understand the full capabilities:
1. Start with [Features](features.md) to see what's possible
2. Review [CLI Commands](cli-commands.md) to learn the interface
3. Study [Configuration Options](configuration-options.md) to customize
4. Check [Architecture](architecture.md) to understand the structure

## 🔗 Related Documentation

- **[Getting Started](../getting-started/README.md)** - Installation and initial setup
- **[Guides](../guides/README.md)** - Step-by-step how-to guides
- **[Development](../development/README.md)** - For contributors
- **[Advanced Topics](../advanced/README.md)** - Performance and extensions

## 💡 Tips

- **Search this page**: Use Ctrl+F to find specific commands or options
- **Bookmark**: Keep this reference handy for quick lookups
- **Cross-reference**: Follow links to related topics for deeper understanding

---

**[← Back to Documentation Index](../index.md)**
