from string import Template

from googlesheettranslate.transformers.corehelper import *
from googlesheettranslate.transformers.itransformer import InterfaceTransform


# coding=utf8
# the above tag defines encoding for this document and is for Python 2.x compatibility

class Jsi18n(InterfaceTransform):
    def __eq__(self, profile):
        return self.id == profile.id  # I made it up the id property.

    def __lt__(self, profile):
        return self.id < profile.id

    def __hash__(self):
        return hash(self.id)

    """ implementation of interface transformation """

    def autoGeneratedTag(self) -> str:
        return "// AUTO-GENERATED - DO NOT EDIT THE LINES BELOW "

    def autoFileName(self) -> str:
        return "_{}.json"

    def transformComment(self, comment: str) -> str:
        """comment replace"""
        return ""

    # You can manually specify the number of replacements by changing the 4th argument
    def transformKeyValue(self, key: str, value: str) -> str:
        if key.find(" ", 0) > -1:
            return self.transformComment(key)

        normalizedValue = RegexBoxNewLine(value)
        normalizedValue = RegexBoxDoubleQuote(normalizedValue)
        normalizedValue = RegexBoxDF(normalizedValue)
        normalizedValue = RegexBoxStrAt(normalizedValue)
        normalizedValue = RegexBoxAmp(normalizedValue)

        line_template = ' "{}": "{}"{}'
        return line_template.format(key, normalizedValue, ",")

    def insert(self, input: str, newValues: str) -> str:
        newValues = newValues[0:len(newValues) - 1]
        new = Template('{'
                       '$content'
                       '}')

        return new.substitute(content=newValues)
