from abc import abstractmethod, ABC


class InterfaceTransform(ABC):
    def __init__(self, args: any):
        pass

    @abstractmethod
    def autoFileName(self) -> str:
        """Generation of language file format"""
        pass

    @abstractmethod
    def autoGeneratedTag(self) -> str:
        """AUTO-GENERATED - DO NOT EDIT THE LINES BELOW"""
        pass

    @abstractmethod
    def transformComment(self, comment: str) -> str:
        """transform for the comment inline.

        write it as comment line
        """
        pass

    @abstractmethod
    def transformKeyValue(self, key: str, value: str) -> str:
        """transform the key and value

        transform the key for each line
        """
        pass

    @abstractmethod
    def insert(self, input: str, newValues: str) -> str:
        """ transform the input to output

        insert the format of the file from the start to the end
        """
        pass
