# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuthorityResult',
    'AwaitableGetAuthorityResult',
    'get_authority',
    'get_authority_output',
]

@pulumi.output_type
class GetAuthorityResult:
    """
    A collection of values returned by getAuthority.
    """
    def __init__(__self__, access_urls=None, certificate_authority_id=None, configs=None, create_time=None, deletion_protection=None, gcs_bucket=None, id=None, ignore_active_certificates_on_deletion=None, key_specs=None, labels=None, lifetime=None, location=None, name=None, pem_ca_certificates=None, pem_csr=None, pool=None, project=None, state=None, type=None, update_time=None):
        if access_urls and not isinstance(access_urls, list):
            raise TypeError("Expected argument 'access_urls' to be a list")
        pulumi.set(__self__, "access_urls", access_urls)
        if certificate_authority_id and not isinstance(certificate_authority_id, str):
            raise TypeError("Expected argument 'certificate_authority_id' to be a str")
        pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if gcs_bucket and not isinstance(gcs_bucket, str):
            raise TypeError("Expected argument 'gcs_bucket' to be a str")
        pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_active_certificates_on_deletion and not isinstance(ignore_active_certificates_on_deletion, bool):
            raise TypeError("Expected argument 'ignore_active_certificates_on_deletion' to be a bool")
        pulumi.set(__self__, "ignore_active_certificates_on_deletion", ignore_active_certificates_on_deletion)
        if key_specs and not isinstance(key_specs, list):
            raise TypeError("Expected argument 'key_specs' to be a list")
        pulumi.set(__self__, "key_specs", key_specs)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if lifetime and not isinstance(lifetime, str):
            raise TypeError("Expected argument 'lifetime' to be a str")
        pulumi.set(__self__, "lifetime", lifetime)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pem_ca_certificates and not isinstance(pem_ca_certificates, list):
            raise TypeError("Expected argument 'pem_ca_certificates' to be a list")
        pulumi.set(__self__, "pem_ca_certificates", pem_ca_certificates)
        if pem_csr and not isinstance(pem_csr, str):
            raise TypeError("Expected argument 'pem_csr' to be a str")
        pulumi.set(__self__, "pem_csr", pem_csr)
        if pool and not isinstance(pool, str):
            raise TypeError("Expected argument 'pool' to be a str")
        pulumi.set(__self__, "pool", pool)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accessUrls")
    def access_urls(self) -> Sequence['outputs.GetAuthorityAccessUrlResult']:
        return pulumi.get(self, "access_urls")

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> Optional[str]:
        return pulumi.get(self, "certificate_authority_id")

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetAuthorityConfigResult']:
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> str:
        return pulumi.get(self, "gcs_bucket")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreActiveCertificatesOnDeletion")
    def ignore_active_certificates_on_deletion(self) -> bool:
        return pulumi.get(self, "ignore_active_certificates_on_deletion")

    @property
    @pulumi.getter(name="keySpecs")
    def key_specs(self) -> Sequence['outputs.GetAuthorityKeySpecResult']:
        return pulumi.get(self, "key_specs")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> str:
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCaCertificates")
    def pem_ca_certificates(self) -> Sequence[str]:
        return pulumi.get(self, "pem_ca_certificates")

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> str:
        """
        The PEM-encoded signed certificate signing request (CSR). This is only set on subordinate certificate authorities.
        """
        return pulumi.get(self, "pem_csr")

    @property
    @pulumi.getter
    def pool(self) -> Optional[str]:
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        return pulumi.get(self, "update_time")


class AwaitableGetAuthorityResult(GetAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorityResult(
            access_urls=self.access_urls,
            certificate_authority_id=self.certificate_authority_id,
            configs=self.configs,
            create_time=self.create_time,
            deletion_protection=self.deletion_protection,
            gcs_bucket=self.gcs_bucket,
            id=self.id,
            ignore_active_certificates_on_deletion=self.ignore_active_certificates_on_deletion,
            key_specs=self.key_specs,
            labels=self.labels,
            lifetime=self.lifetime,
            location=self.location,
            name=self.name,
            pem_ca_certificates=self.pem_ca_certificates,
            pem_csr=self.pem_csr,
            pool=self.pool,
            project=self.project,
            state=self.state,
            type=self.type,
            update_time=self.update_time)


def get_authority(certificate_authority_id: Optional[str] = None,
                  location: Optional[str] = None,
                  pool: Optional[str] = None,
                  project: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorityResult:
    """
    Get info about a Google Cloud IAP Client.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificateauthority.get_authority(location="us-west1",
        pool="pool-name",
        certificate_authority_id="ca-id")
    pulumi.export("csr", default.pem_csr)
    ```


    :param str certificate_authority_id: ID of the certificate authority.
    :param str location: The location the certificate authority exists in.
    :param str pool: The name of the pool the certificate authority belongs to.
    :param str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    __args__['location'] = location
    __args__['pool'] = pool
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:certificateauthority/getAuthority:getAuthority', __args__, opts=opts, typ=GetAuthorityResult).value

    return AwaitableGetAuthorityResult(
        access_urls=__ret__.access_urls,
        certificate_authority_id=__ret__.certificate_authority_id,
        configs=__ret__.configs,
        create_time=__ret__.create_time,
        deletion_protection=__ret__.deletion_protection,
        gcs_bucket=__ret__.gcs_bucket,
        id=__ret__.id,
        ignore_active_certificates_on_deletion=__ret__.ignore_active_certificates_on_deletion,
        key_specs=__ret__.key_specs,
        labels=__ret__.labels,
        lifetime=__ret__.lifetime,
        location=__ret__.location,
        name=__ret__.name,
        pem_ca_certificates=__ret__.pem_ca_certificates,
        pem_csr=__ret__.pem_csr,
        pool=__ret__.pool,
        project=__ret__.project,
        state=__ret__.state,
        type=__ret__.type,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_authority)
def get_authority_output(certificate_authority_id: Optional[pulumi.Input[Optional[str]]] = None,
                         location: Optional[pulumi.Input[Optional[str]]] = None,
                         pool: Optional[pulumi.Input[Optional[str]]] = None,
                         project: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthorityResult]:
    """
    Get info about a Google Cloud IAP Client.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificateauthority.get_authority(location="us-west1",
        pool="pool-name",
        certificate_authority_id="ca-id")
    pulumi.export("csr", default.pem_csr)
    ```


    :param str certificate_authority_id: ID of the certificate authority.
    :param str location: The location the certificate authority exists in.
    :param str pool: The name of the pool the certificate authority belongs to.
    :param str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    ...
