# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionBackendServiceArgs', 'RegionBackendService']

@pulumi.input_type
class RegionBackendServiceArgs:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']] = None,
                 consistent_hash: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input['RegionBackendServiceIapArgs']] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 subsetting: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RegionBackendService resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs'] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[str] description: An optional description of this resource.
               Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input['RegionBackendServiceFailoverPolicyArgs'] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input['RegionBackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
        :param pulumi.Input['RegionBackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the cookie.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input['RegionBackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this RegionBackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        :param pulumi.Input[str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        :param pulumi.Input['RegionBackendServiceSubsettingArgs'] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
               and Internal HTTP(S) load balancing.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if connection_tracking_policy is not None:
            pulumi.set(__self__, "connection_tracking_policy", connection_tracking_policy)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if subsetting is not None:
            pulumi.set(__self__, "subsetting", subsetting)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @connection_tracking_policy.setter
    def connection_tracking_policy(self, value: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]):
        pulumi.set(self, "connection_tracking_policy", value)

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cdn", value)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]):
        pulumi.set(self, "failover_policy", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['RegionBackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['RegionBackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cookie.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this RegionBackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter
    def subsetting(self) -> Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
        and Internal HTTP(S) load balancing.
        """
        return pulumi.get(self, "subsetting")

    @subsetting.setter
    def subsetting(self, value: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]):
        pulumi.set(self, "subsetting", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.input_type
class _RegionBackendServiceState:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']] = None,
                 consistent_hash: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input['RegionBackendServiceIapArgs']] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 subsetting: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering RegionBackendService resources.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs'] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
               Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input['RegionBackendServiceFailoverPolicyArgs'] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        :param pulumi.Input[str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input['RegionBackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
        :param pulumi.Input['RegionBackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the cookie.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input['RegionBackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this RegionBackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        :param pulumi.Input[str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        :param pulumi.Input['RegionBackendServiceSubsettingArgs'] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
               and Internal HTTP(S) load balancing.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if connection_tracking_policy is not None:
            pulumi.set(__self__, "connection_tracking_policy", connection_tracking_policy)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if subsetting is not None:
            pulumi.set(__self__, "subsetting", subsetting)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @connection_tracking_policy.setter
    def connection_tracking_policy(self, value: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]):
        pulumi.set(self, "connection_tracking_policy", value)

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cdn", value)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]):
        pulumi.set(self, "failover_policy", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['RegionBackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['RegionBackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cookie.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this RegionBackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter
    def subsetting(self) -> Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
        and Internal HTTP(S) load balancing.
        """
        return pulumi.get(self, "subsetting")

    @subsetting.setter
    def subsetting(self, value: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]):
        pulumi.set(self, "subsetting", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


class RegionBackendService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionBackendServiceBackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCircuitBreakersArgs']]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConnectionTrackingPolicyArgs']]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConsistentHashArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceFailoverPolicyArgs']]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceIapArgs']]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceOutlierDetectionArgs']]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 subsetting: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceSubsettingArgs']]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        A Region Backend Service defines a regionally-scoped group of virtual
        machines that will serve traffic for load balancing.

        To get more information about RegionBackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/latest/regionBackendServices)
        * How-to Guides
            * [Internal TCP/UDP Load Balancing](https://cloud.google.com/compute/docs/load-balancing/internal/)

        > **Warning:** All arguments including `iap.oauth2_client_secret` and `iap.oauth2_client_secret_sha256` will be stored in the raw
        state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/language/state/sensitive-data.html).

        ## Example Usage
        ### Region Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("defaultHealthCheck",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="us-central1",
            health_checks=[default_health_check.id],
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        ```
        ### Region Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="us-central1",
            health_checks=[default_region_health_check.id],
            enable_cdn=True,
            cdn_policy=gcp.compute.RegionBackendServiceCdnPolicyArgs(
                cache_mode="CACHE_ALL_STATIC",
                default_ttl=3600,
                client_ttl=7200,
                max_ttl=10800,
                negative_caching=True,
                signed_url_cache_max_age_sec=7200,
            ),
            load_balancing_scheme="EXTERNAL",
            protocol="HTTP",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Region Backend Service Ilb Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("healthCheck", http_health_check=gcp.compute.HealthCheckHttpHealthCheckArgs(
            port=80,
        ))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Region Backend Service External

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Region Backend Service Ilb Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("healthCheck", http_health_check=gcp.compute.HealthCheckHttpHealthCheckArgs(
            port=80,
        ))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            protocol="HTTP",
            circuit_breakers=gcp.compute.RegionBackendServiceCircuitBreakersArgs(
                max_connections=10,
            ),
            consistent_hash=gcp.compute.RegionBackendServiceConsistentHashArgs(
                http_cookie=gcp.compute.RegionBackendServiceConsistentHashHttpCookieArgs(
                    ttl=gcp.compute.RegionBackendServiceConsistentHashHttpCookieTtlArgs(
                        seconds=11,
                        nanos=1111,
                    ),
                    name="mycookie",
                ),
            ),
            outlier_detection=gcp.compute.RegionBackendServiceOutlierDetectionArgs(
                consecutive_errors=2,
            ))
        ```
        ### Region Backend Service Balancing Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        default_network = gcp.compute.Network("defaultNetwork",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-medium",
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=default_network.id,
                subnetwork=default_subnetwork.id,
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=debian_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="internal-glb",
            target_size=1)
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=rigm.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            region="us-central1",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=[default_region_health_check.id])
        ```
        ### Region Backend Service Connection Tracking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=22,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP",
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            connection_tracking_policy=gcp.compute.RegionBackendServiceConnectionTrackingPolicyArgs(
                tracking_mode="PER_SESSION",
                connection_persistence_on_unhealthy_backends="NEVER_PERSIST",
                idle_timeout_sec=60,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        RegionBackendService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default projects/{{project}}/regions/{{region}}/backendServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionBackendServiceBackendArgs']]]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceCdnPolicyArgs']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceCircuitBreakersArgs']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceConnectionTrackingPolicyArgs']] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceConsistentHashArgs']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[str] description: An optional description of this resource.
               Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceFailoverPolicyArgs']] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceIapArgs']] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceLogConfigArgs']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the cookie.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceOutlierDetectionArgs']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this RegionBackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        :param pulumi.Input[str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceSubsettingArgs']] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
               and Internal HTTP(S) load balancing.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegionBackendServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Region Backend Service defines a regionally-scoped group of virtual
        machines that will serve traffic for load balancing.

        To get more information about RegionBackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/latest/regionBackendServices)
        * How-to Guides
            * [Internal TCP/UDP Load Balancing](https://cloud.google.com/compute/docs/load-balancing/internal/)

        > **Warning:** All arguments including `iap.oauth2_client_secret` and `iap.oauth2_client_secret_sha256` will be stored in the raw
        state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/language/state/sensitive-data.html).

        ## Example Usage
        ### Region Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("defaultHealthCheck",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="us-central1",
            health_checks=[default_health_check.id],
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        ```
        ### Region Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="us-central1",
            health_checks=[default_region_health_check.id],
            enable_cdn=True,
            cdn_policy=gcp.compute.RegionBackendServiceCdnPolicyArgs(
                cache_mode="CACHE_ALL_STATIC",
                default_ttl=3600,
                client_ttl=7200,
                max_ttl=10800,
                negative_caching=True,
                signed_url_cache_max_age_sec=7200,
            ),
            load_balancing_scheme="EXTERNAL",
            protocol="HTTP",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Region Backend Service Ilb Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("healthCheck", http_health_check=gcp.compute.HealthCheckHttpHealthCheckArgs(
            port=80,
        ))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Region Backend Service External

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Region Backend Service Ilb Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("healthCheck", http_health_check=gcp.compute.HealthCheckHttpHealthCheckArgs(
            port=80,
        ))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            protocol="HTTP",
            circuit_breakers=gcp.compute.RegionBackendServiceCircuitBreakersArgs(
                max_connections=10,
            ),
            consistent_hash=gcp.compute.RegionBackendServiceConsistentHashArgs(
                http_cookie=gcp.compute.RegionBackendServiceConsistentHashHttpCookieArgs(
                    ttl=gcp.compute.RegionBackendServiceConsistentHashHttpCookieTtlArgs(
                        seconds=11,
                        nanos=1111,
                    ),
                    name="mycookie",
                ),
            ),
            outlier_detection=gcp.compute.RegionBackendServiceOutlierDetectionArgs(
                consecutive_errors=2,
            ))
        ```
        ### Region Backend Service Balancing Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        default_network = gcp.compute.Network("defaultNetwork",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-medium",
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=default_network.id,
                subnetwork=default_subnetwork.id,
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=debian_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="internal-glb",
            target_size=1)
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=rigm.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            region="us-central1",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=[default_region_health_check.id])
        ```
        ### Region Backend Service Connection Tracking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=22,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            health_checks=[health_check.id],
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP",
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            connection_tracking_policy=gcp.compute.RegionBackendServiceConnectionTrackingPolicyArgs(
                tracking_mode="PER_SESSION",
                connection_persistence_on_unhealthy_backends="NEVER_PERSIST",
                idle_timeout_sec=60,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        RegionBackendService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default projects/{{project}}/regions/{{region}}/backendServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionBackendServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionBackendServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionBackendServiceBackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCircuitBreakersArgs']]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConnectionTrackingPolicyArgs']]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConsistentHashArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceFailoverPolicyArgs']]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceIapArgs']]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceOutlierDetectionArgs']]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 subsetting: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceSubsettingArgs']]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionBackendServiceArgs.__new__(RegionBackendServiceArgs)

            __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
            __props__.__dict__["backends"] = backends
            __props__.__dict__["cdn_policy"] = cdn_policy
            __props__.__dict__["circuit_breakers"] = circuit_breakers
            __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
            __props__.__dict__["connection_tracking_policy"] = connection_tracking_policy
            __props__.__dict__["consistent_hash"] = consistent_hash
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_cdn"] = enable_cdn
            __props__.__dict__["failover_policy"] = failover_policy
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["iap"] = iap
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["locality_lb_policy"] = locality_lb_policy
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["outlier_detection"] = outlier_detection
            __props__.__dict__["port_name"] = port_name
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["subsetting"] = subsetting
            __props__.__dict__["timeout_sec"] = timeout_sec
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["self_link"] = None
        super(RegionBackendService, __self__).__init__(
            'gcp:compute/regionBackendService:RegionBackendService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionBackendServiceBackendArgs']]]]] = None,
            cdn_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCdnPolicyArgs']]] = None,
            circuit_breakers: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceCircuitBreakersArgs']]] = None,
            connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
            connection_tracking_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConnectionTrackingPolicyArgs']]] = None,
            consistent_hash: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceConsistentHashArgs']]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_cdn: Optional[pulumi.Input[bool]] = None,
            failover_policy: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceFailoverPolicyArgs']]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            health_checks: Optional[pulumi.Input[str]] = None,
            iap: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceIapArgs']]] = None,
            load_balancing_scheme: Optional[pulumi.Input[str]] = None,
            locality_lb_policy: Optional[pulumi.Input[str]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceLogConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            outlier_detection: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceOutlierDetectionArgs']]] = None,
            port_name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            session_affinity: Optional[pulumi.Input[str]] = None,
            subsetting: Optional[pulumi.Input[pulumi.InputType['RegionBackendServiceSubsettingArgs']]] = None,
            timeout_sec: Optional[pulumi.Input[int]] = None) -> 'RegionBackendService':
        """
        Get an existing RegionBackendService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionBackendServiceBackendArgs']]]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceCdnPolicyArgs']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceCircuitBreakersArgs']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceConnectionTrackingPolicyArgs']] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceConsistentHashArgs']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
               Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceFailoverPolicyArgs']] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        :param pulumi.Input[str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceIapArgs']] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceLogConfigArgs']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the cookie.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceOutlierDetectionArgs']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
               Structure is documented below.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this RegionBackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        :param pulumi.Input[str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        :param pulumi.Input[pulumi.InputType['RegionBackendServiceSubsettingArgs']] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
               and Internal HTTP(S) load balancing.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionBackendServiceState.__new__(_RegionBackendServiceState)

        __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
        __props__.__dict__["backends"] = backends
        __props__.__dict__["cdn_policy"] = cdn_policy
        __props__.__dict__["circuit_breakers"] = circuit_breakers
        __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
        __props__.__dict__["connection_tracking_policy"] = connection_tracking_policy
        __props__.__dict__["consistent_hash"] = consistent_hash
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_cdn"] = enable_cdn
        __props__.__dict__["failover_policy"] = failover_policy
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["iap"] = iap
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["locality_lb_policy"] = locality_lb_policy
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["outlier_detection"] = outlier_detection
        __props__.__dict__["port_name"] = port_name
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["subsetting"] = subsetting
        __props__.__dict__["timeout_sec"] = timeout_sec
        return RegionBackendService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[Sequence['outputs.RegionBackendServiceBackend']]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> pulumi.Output['outputs.RegionBackendServiceCdnPolicy']:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceCircuitBreakers']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceConnectionTrackingPolicy']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceConsistentHash']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceFailoverPolicy']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def iap(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceIap']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        """
        return pulumi.get(self, "locality_lb_policy")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.RegionBackendServiceLogConfig']:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the cookie.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceOutlierDetection']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, or HTTP2.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[str]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol this RegionBackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `SSL`, `TCP`, `UDP`, `GRPC`, and `UNSPECIFIED`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[str]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, and `CLIENT_IP_NO_DESTINATION`.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter
    def subsetting(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceSubsetting']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing
        and Internal HTTP(S) load balancing.
        """
        return pulumi.get(self, "subsetting")

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[int]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

