# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GuestPoliciesAssignment',
    'GuestPoliciesAssignmentGroupLabel',
    'GuestPoliciesAssignmentOsType',
    'GuestPoliciesPackage',
    'GuestPoliciesPackageRepository',
    'GuestPoliciesPackageRepositoryApt',
    'GuestPoliciesPackageRepositoryGoo',
    'GuestPoliciesPackageRepositoryYum',
    'GuestPoliciesPackageRepositoryZypper',
    'GuestPoliciesRecipe',
    'GuestPoliciesRecipeArtifact',
    'GuestPoliciesRecipeArtifactGcs',
    'GuestPoliciesRecipeArtifactRemote',
    'GuestPoliciesRecipeInstallStep',
    'GuestPoliciesRecipeInstallStepArchiveExtraction',
    'GuestPoliciesRecipeInstallStepDpkgInstallation',
    'GuestPoliciesRecipeInstallStepFileCopy',
    'GuestPoliciesRecipeInstallStepFileExec',
    'GuestPoliciesRecipeInstallStepMsiInstallation',
    'GuestPoliciesRecipeInstallStepRpmInstallation',
    'GuestPoliciesRecipeInstallStepScriptRun',
    'GuestPoliciesRecipeUpdateStep',
    'GuestPoliciesRecipeUpdateStepArchiveExtraction',
    'GuestPoliciesRecipeUpdateStepDpkgInstallation',
    'GuestPoliciesRecipeUpdateStepFileCopy',
    'GuestPoliciesRecipeUpdateStepFileExec',
    'GuestPoliciesRecipeUpdateStepMsiInstallation',
    'GuestPoliciesRecipeUpdateStepRpmInstallation',
    'GuestPoliciesRecipeUpdateStepScriptRun',
    'OsPolicyAssignmentInstanceFilter',
    'OsPolicyAssignmentInstanceFilterExclusionLabel',
    'OsPolicyAssignmentInstanceFilterInclusionLabel',
    'OsPolicyAssignmentInstanceFilterInventory',
    'OsPolicyAssignmentOsPolicy',
    'OsPolicyAssignmentOsPolicyResourceGroup',
    'OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter',
    'OsPolicyAssignmentOsPolicyResourceGroupResource',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExec',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceFile',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkg',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgApt',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGooget',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsi',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcs',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYum',
    'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypper',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceRepository',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGoo',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum',
    'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper',
    'OsPolicyAssignmentRollout',
    'OsPolicyAssignmentRolloutDisruptionBudget',
    'PatchDeploymentInstanceFilter',
    'PatchDeploymentInstanceFilterGroupLabel',
    'PatchDeploymentOneTimeSchedule',
    'PatchDeploymentPatchConfig',
    'PatchDeploymentPatchConfigApt',
    'PatchDeploymentPatchConfigGoo',
    'PatchDeploymentPatchConfigPostStep',
    'PatchDeploymentPatchConfigPostStepLinuxExecStepConfig',
    'PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject',
    'PatchDeploymentPatchConfigPostStepWindowsExecStepConfig',
    'PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject',
    'PatchDeploymentPatchConfigPreStep',
    'PatchDeploymentPatchConfigPreStepLinuxExecStepConfig',
    'PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject',
    'PatchDeploymentPatchConfigPreStepWindowsExecStepConfig',
    'PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject',
    'PatchDeploymentPatchConfigWindowsUpdate',
    'PatchDeploymentPatchConfigYum',
    'PatchDeploymentPatchConfigZypper',
    'PatchDeploymentRecurringSchedule',
    'PatchDeploymentRecurringScheduleMonthly',
    'PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth',
    'PatchDeploymentRecurringScheduleTimeOfDay',
    'PatchDeploymentRecurringScheduleTimeZone',
    'PatchDeploymentRecurringScheduleWeekly',
    'PatchDeploymentRollout',
    'PatchDeploymentRolloutDisruptionBudget',
]

@pulumi.output_type
class GuestPoliciesAssignment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLabels":
            suggest = "group_labels"
        elif key == "instanceNamePrefixes":
            suggest = "instance_name_prefixes"
        elif key == "osTypes":
            suggest = "os_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesAssignment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesAssignment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesAssignment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_labels: Optional[Sequence['outputs.GuestPoliciesAssignmentGroupLabel']] = None,
                 instance_name_prefixes: Optional[Sequence[str]] = None,
                 instances: Optional[Sequence[str]] = None,
                 os_types: Optional[Sequence['outputs.GuestPoliciesAssignmentOsType']] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        :param Sequence['GuestPoliciesAssignmentGroupLabelArgs'] group_labels: Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups,
               for example "env=prod or env=staging".
               Structure is documented below.
        :param Sequence[str] instance_name_prefixes: Targets VM instances whose name starts with one of these prefixes.
               Like labels, this is another way to group VM instances when targeting configs,
               for example prefix="prod-".
               Only supported for project-level policies.
        :param Sequence[str] instances: Targets any of the instances specified. Instances are specified by their URI in the form
               zones/[ZONE]/instances/[INSTANCE_NAME].
               Instance targeting is uncommon and is supported to facilitate the management of changes
               by the instance or to target specific VM instances for development and testing.
               Only supported for project-level policies and must reference instances within this project.
        :param Sequence['GuestPoliciesAssignmentOsTypeArgs'] os_types: Targets VM instances matching at least one of the following OS types.
               VM instances must match all supplied criteria for a given OsType to be included.
               Structure is documented below.
        :param Sequence[str] zones: Targets instances in any of these zones. Leave empty to target instances in any zone.
               Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if os_types is not None:
            pulumi.set(__self__, "os_types", os_types)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[Sequence['outputs.GuestPoliciesAssignmentGroupLabel']]:
        """
        Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups,
        for example "env=prod or env=staging".
        Structure is documented below.
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[Sequence[str]]:
        """
        Targets VM instances whose name starts with one of these prefixes.
        Like labels, this is another way to group VM instances when targeting configs,
        for example prefix="prod-".
        Only supported for project-level policies.
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        Targets any of the instances specified. Instances are specified by their URI in the form
        zones/[ZONE]/instances/[INSTANCE_NAME].
        Instance targeting is uncommon and is supported to facilitate the management of changes
        by the instance or to target specific VM instances for development and testing.
        Only supported for project-level policies and must reference instances within this project.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="osTypes")
    def os_types(self) -> Optional[Sequence['outputs.GuestPoliciesAssignmentOsType']]:
        """
        Targets VM instances matching at least one of the following OS types.
        VM instances must match all supplied criteria for a given OsType to be included.
        Structure is documented below.
        """
        return pulumi.get(self, "os_types")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Targets instances in any of these zones. Leave empty to target instances in any zone.
        Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GuestPoliciesAssignmentGroupLabel(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        :param Mapping[str, str] labels: Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GuestPoliciesAssignmentOsType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osArchitecture":
            suggest = "os_architecture"
        elif key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesAssignmentOsType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesAssignmentOsType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesAssignmentOsType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_architecture: Optional[str] = None,
                 os_short_name: Optional[str] = None,
                 os_version: Optional[str] = None):
        """
        :param str os_architecture: Targets VM instances with OS Inventory enabled and having the following OS architecture.
        :param str os_short_name: Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        :param str os_version: Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_short_name is not None:
            pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[str]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS architecture.
        """
        return pulumi.get(self, "os_architecture")

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> Optional[str]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class GuestPoliciesPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 desired_state: Optional[str] = None,
                 manager: Optional[str] = None):
        """
        :param str name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param str desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe.
               INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
               INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
               if a higher version of the recipe is assigned to this instance.
               REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
               Default value is `INSTALLED`.
               Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        :param str manager: Type of package manager that can be used to install this package. If a system does not have the package manager,
               the package is not installed or removed no error message is returned. By default, or if you specify ANY,
               the agent attempts to install and remove this package using the default package manager.
               This is useful when creating a policy that applies to different types of systems.
               The default behavior is ANY.
               Default value is `ANY`.
               Possible values are `ANY`, `APT`, `YUM`, `ZYPPER`, and `GOO`.
        """
        pulumi.set(__self__, "name", name)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[str]:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe.
        INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
        INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
        if a higher version of the recipe is assigned to this instance.
        REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        Default value is `INSTALLED`.
        Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def manager(self) -> Optional[str]:
        """
        Type of package manager that can be used to install this package. If a system does not have the package manager,
        the package is not installed or removed no error message is returned. By default, or if you specify ANY,
        the agent attempts to install and remove this package using the default package manager.
        This is useful when creating a policy that applies to different types of systems.
        The default behavior is ANY.
        Default value is `ANY`.
        Possible values are `ANY`, `APT`, `YUM`, `ZYPPER`, and `GOO`.
        """
        return pulumi.get(self, "manager")


@pulumi.output_type
class GuestPoliciesPackageRepository(dict):
    def __init__(__self__, *,
                 apt: Optional['outputs.GuestPoliciesPackageRepositoryApt'] = None,
                 goo: Optional['outputs.GuestPoliciesPackageRepositoryGoo'] = None,
                 yum: Optional['outputs.GuestPoliciesPackageRepositoryYum'] = None,
                 zypper: Optional['outputs.GuestPoliciesPackageRepositoryZypper'] = None):
        """
        :param 'GuestPoliciesPackageRepositoryAptArgs' apt: An Apt Repository.
               Structure is documented below.
        :param 'GuestPoliciesPackageRepositoryGooArgs' goo: A Goo Repository.
               Structure is documented below.
        :param 'GuestPoliciesPackageRepositoryYumArgs' yum: A Yum Repository.
               Structure is documented below.
        :param 'GuestPoliciesPackageRepositoryZypperArgs' zypper: A Zypper Repository.
               Structure is documented below.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional['outputs.GuestPoliciesPackageRepositoryApt']:
        """
        An Apt Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> Optional['outputs.GuestPoliciesPackageRepositoryGoo']:
        """
        A Goo Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter
    def yum(self) -> Optional['outputs.GuestPoliciesPackageRepositoryYum']:
        """
        A Yum Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> Optional['outputs.GuestPoliciesPackageRepositoryZypper']:
        """
        A Zypper Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class GuestPoliciesPackageRepositoryApt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveType":
            suggest = "archive_type"
        elif key == "gpgKey":
            suggest = "gpg_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesPackageRepositoryApt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesPackageRepositoryApt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesPackageRepositoryApt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 components: Sequence[str],
                 distribution: str,
                 uri: str,
                 archive_type: Optional[str] = None,
                 gpg_key: Optional[str] = None):
        """
        :param Sequence[str] components: List of components for this repository. Must contain at least one item.
        :param str distribution: Distribution of this repository.
        :param str uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        :param str archive_type: Type of archive files in this repository. The default behavior is DEB.
               Default value is `DEB`.
               Possible values are `DEB` and `DEB_SRC`.
        :param str gpg_key: URI of the key file for this repository. The agent maintains a keyring at
               /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.
        """
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "uri", uri)
        if archive_type is not None:
            pulumi.set(__self__, "archive_type", archive_type)
        if gpg_key is not None:
            pulumi.set(__self__, "gpg_key", gpg_key)

    @property
    @pulumi.getter
    def components(self) -> Sequence[str]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> Optional[str]:
        """
        Type of archive files in this repository. The default behavior is DEB.
        Default value is `DEB`.
        Possible values are `DEB` and `DEB_SRC`.
        """
        return pulumi.get(self, "archive_type")

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> Optional[str]:
        """
        URI of the key file for this repository. The agent maintains a keyring at
        /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.
        """
        return pulumi.get(self, "gpg_key")


@pulumi.output_type
class GuestPoliciesPackageRepositoryGoo(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        :param str name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param str url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GuestPoliciesPackageRepositoryYum(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesPackageRepositoryYum. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesPackageRepositoryYum.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesPackageRepositoryYum.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 id: str,
                 display_name: Optional[str] = None,
                 gpg_keys: Optional[Sequence[str]] = None):
        """
        :param str base_url: The location of the repository directory.
        :param str id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[Sequence[str]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class GuestPoliciesPackageRepositoryZypper(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesPackageRepositoryZypper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesPackageRepositoryZypper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesPackageRepositoryZypper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 id: str,
                 display_name: Optional[str] = None,
                 gpg_keys: Optional[Sequence[str]] = None):
        """
        :param str base_url: The location of the repository directory.
        :param str id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[Sequence[str]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class GuestPoliciesRecipe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"
        elif key == "installSteps":
            suggest = "install_steps"
        elif key == "updateSteps":
            suggest = "update_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 artifacts: Optional[Sequence['outputs.GuestPoliciesRecipeArtifact']] = None,
                 desired_state: Optional[str] = None,
                 install_steps: Optional[Sequence['outputs.GuestPoliciesRecipeInstallStep']] = None,
                 update_steps: Optional[Sequence['outputs.GuestPoliciesRecipeUpdateStep']] = None,
                 version: Optional[str] = None):
        """
        :param str name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param Sequence['GuestPoliciesRecipeArtifactArgs'] artifacts: Resources available to be used in the steps in the recipe.
               Structure is documented below.
        :param str desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe.
               INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
               INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
               if a higher version of the recipe is assigned to this instance.
               REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
               Default value is `INSTALLED`.
               Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        :param Sequence['GuestPoliciesRecipeInstallStepArgs'] install_steps: Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation.
               Any steps taken (including partially completed steps) are not rolled back.
               Structure is documented below.
        :param Sequence['GuestPoliciesRecipeUpdateStepArgs'] update_steps: Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe.
               Any steps taken (including partially completed steps) are not rolled back.
               Structure is documented below.
        :param str version: The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        pulumi.set(__self__, "name", name)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if install_steps is not None:
            pulumi.set(__self__, "install_steps", install_steps)
        if update_steps is not None:
            pulumi.set(__self__, "update_steps", update_steps)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[Sequence['outputs.GuestPoliciesRecipeArtifact']]:
        """
        Resources available to be used in the steps in the recipe.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[str]:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe.
        INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
        INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
        if a higher version of the recipe is assigned to this instance.
        REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        Default value is `INSTALLED`.
        Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="installSteps")
    def install_steps(self) -> Optional[Sequence['outputs.GuestPoliciesRecipeInstallStep']]:
        """
        Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation.
        Any steps taken (including partially completed steps) are not rolled back.
        Structure is documented below.
        """
        return pulumi.get(self, "install_steps")

    @property
    @pulumi.getter(name="updateSteps")
    def update_steps(self) -> Optional[Sequence['outputs.GuestPoliciesRecipeUpdateStep']]:
        """
        Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe.
        Any steps taken (including partially completed steps) are not rolled back.
        Structure is documented below.
        """
        return pulumi.get(self, "update_steps")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GuestPoliciesRecipeArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.GuestPoliciesRecipeArtifactGcs'] = None,
                 remote: Optional['outputs.GuestPoliciesRecipeArtifactRemote'] = None):
        """
        :param str id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param bool allow_insecure: Defaults to false. When false, recipes are subject to validations based on the artifact type:
               Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
               GCS: An object generation number must be specified.
        :param 'GuestPoliciesRecipeArtifactGcsArgs' gcs: A Google Cloud Storage artifact.
               Structure is documented below.
        :param 'GuestPoliciesRecipeArtifactRemoteArgs' remote: A generic remote artifact.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, recipes are subject to validations based on the artifact type:
        Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
        GCS: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.GuestPoliciesRecipeArtifactGcs']:
        """
        A Google Cloud Storage artifact.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.GuestPoliciesRecipeArtifactRemote']:
        """
        A generic remote artifact.
        Structure is documented below.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class GuestPoliciesRecipeArtifactGcs(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 generation: Optional[int] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
               this value would be my-bucket.
        :param int generation: Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
               https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.
        :param str object: Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
               this value would be foo/bar.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
        this value would be my-bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
        https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
        this value would be foo/bar.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GuestPoliciesRecipeArtifactRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkSum":
            suggest = "check_sum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeArtifactRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeArtifactRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeArtifactRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_sum: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str check_sum: Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
               If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
               of the steps.
        :param str uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        if check_sum is not None:
            pulumi.set(__self__, "check_sum", check_sum)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="checkSum")
    def check_sum(self) -> Optional[str]:
        """
        Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
        If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
        of the steps.
        """
        return pulumi.get(self, "check_sum")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GuestPoliciesRecipeInstallStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveExtraction":
            suggest = "archive_extraction"
        elif key == "dpkgInstallation":
            suggest = "dpkg_installation"
        elif key == "fileCopy":
            suggest = "file_copy"
        elif key == "fileExec":
            suggest = "file_exec"
        elif key == "msiInstallation":
            suggest = "msi_installation"
        elif key == "rpmInstallation":
            suggest = "rpm_installation"
        elif key == "scriptRun":
            suggest = "script_run"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_extraction: Optional['outputs.GuestPoliciesRecipeInstallStepArchiveExtraction'] = None,
                 dpkg_installation: Optional['outputs.GuestPoliciesRecipeInstallStepDpkgInstallation'] = None,
                 file_copy: Optional['outputs.GuestPoliciesRecipeInstallStepFileCopy'] = None,
                 file_exec: Optional['outputs.GuestPoliciesRecipeInstallStepFileExec'] = None,
                 msi_installation: Optional['outputs.GuestPoliciesRecipeInstallStepMsiInstallation'] = None,
                 rpm_installation: Optional['outputs.GuestPoliciesRecipeInstallStepRpmInstallation'] = None,
                 script_run: Optional['outputs.GuestPoliciesRecipeInstallStepScriptRun'] = None):
        """
        :param 'GuestPoliciesRecipeInstallStepArchiveExtractionArgs' archive_extraction: Extracts an archive into the specified directory.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepDpkgInstallationArgs' dpkg_installation: Installs a deb file via dpkg.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepFileCopyArgs' file_copy: Copies a file onto the instance.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepFileExecArgs' file_exec: Executes an artifact or local file.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepMsiInstallationArgs' msi_installation: Installs an MSI file.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepRpmInstallationArgs' rpm_installation: Installs an rpm file via the rpm utility.
               Structure is documented below.
        :param 'GuestPoliciesRecipeInstallStepScriptRunArgs' script_run: Runs commands in a shell.
               Structure is documented below.
        """
        if archive_extraction is not None:
            pulumi.set(__self__, "archive_extraction", archive_extraction)
        if dpkg_installation is not None:
            pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        if file_copy is not None:
            pulumi.set(__self__, "file_copy", file_copy)
        if file_exec is not None:
            pulumi.set(__self__, "file_exec", file_exec)
        if msi_installation is not None:
            pulumi.set(__self__, "msi_installation", msi_installation)
        if rpm_installation is not None:
            pulumi.set(__self__, "rpm_installation", rpm_installation)
        if script_run is not None:
            pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepArchiveExtraction']:
        """
        Extracts an archive into the specified directory.
        Structure is documented below.
        """
        return pulumi.get(self, "archive_extraction")

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepDpkgInstallation']:
        """
        Installs a deb file via dpkg.
        Structure is documented below.
        """
        return pulumi.get(self, "dpkg_installation")

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepFileCopy']:
        """
        Copies a file onto the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "file_copy")

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepFileExec']:
        """
        Executes an artifact or local file.
        Structure is documented below.
        """
        return pulumi.get(self, "file_exec")

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepMsiInstallation']:
        """
        Installs an MSI file.
        Structure is documented below.
        """
        return pulumi.get(self, "msi_installation")

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepRpmInstallation']:
        """
        Installs an rpm file via the rpm utility.
        Structure is documented below.
        """
        return pulumi.get(self, "rpm_installation")

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> Optional['outputs.GuestPoliciesRecipeInstallStepScriptRun']:
        """
        Runs commands in a shell.
        Structure is documented below.
        """
        return pulumi.get(self, "script_run")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepArchiveExtraction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepArchiveExtraction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepArchiveExtraction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepArchiveExtraction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 type: str,
                 destination: Optional[str] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str type: The type of the archive to extract.
               Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        :param str destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "type", type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the archive to extract.
        Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepDpkgInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepDpkgInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepDpkgInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepDpkgInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepFileCopy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepFileCopy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepFileCopy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepFileCopy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 destination: str,
                 overwrite: Optional[bool] = None,
                 permissions: Optional[str] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        :param bool overwrite: Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
               is not overwritten and the step is considered a success. Defaults to false.
        :param str permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
               for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
               number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
               bit corresponds to the execute permission. Default behavior is 755.
               Below are some examples of permissions and their associated values:
               read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[bool]:
        """
        Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
        is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[str]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
        for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
        number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
        bit corresponds to the execute permission. Default behavior is 755.
        Below are some examples of permissions and their associated values:
        read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepFileExec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"
        elif key == "artifactId":
            suggest = "artifact_id"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepFileExec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepFileExec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepFileExec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_exit_codes: Optional[str] = None,
                 args: Optional[Sequence[str]] = None,
                 artifact_id: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param str allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param Sequence[str] args: Arguments to be passed to the provided executable.
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str local_path: The absolute path of the file on the local filesystem.
        """
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[str]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepMsiInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "allowedExitCodes":
            suggest = "allowed_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepMsiInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepMsiInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepMsiInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 allowed_exit_codes: Optional[Sequence[int]] = None,
                 flags: Optional[Sequence[str]] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param Sequence[str] flags: The flags to use when installing the MSI. Defaults to the install flag.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def flags(self) -> Optional[Sequence[str]]:
        """
        The flags to use when installing the MSI. Defaults to the install flag.
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepRpmInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepRpmInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepRpmInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepRpmInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class GuestPoliciesRecipeInstallStepScriptRun(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeInstallStepScriptRun. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeInstallStepScriptRun.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeInstallStepScriptRun.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script: str,
                 allowed_exit_codes: Optional[Sequence[int]] = None,
                 interpreter: Optional[str] = None):
        """
        :param str script: The shell script to be executed.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
               which likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        """
        pulumi.set(__self__, "script", script)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        The shell script to be executed.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
        which likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveExtraction":
            suggest = "archive_extraction"
        elif key == "dpkgInstallation":
            suggest = "dpkg_installation"
        elif key == "fileCopy":
            suggest = "file_copy"
        elif key == "fileExec":
            suggest = "file_exec"
        elif key == "msiInstallation":
            suggest = "msi_installation"
        elif key == "rpmInstallation":
            suggest = "rpm_installation"
        elif key == "scriptRun":
            suggest = "script_run"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_extraction: Optional['outputs.GuestPoliciesRecipeUpdateStepArchiveExtraction'] = None,
                 dpkg_installation: Optional['outputs.GuestPoliciesRecipeUpdateStepDpkgInstallation'] = None,
                 file_copy: Optional['outputs.GuestPoliciesRecipeUpdateStepFileCopy'] = None,
                 file_exec: Optional['outputs.GuestPoliciesRecipeUpdateStepFileExec'] = None,
                 msi_installation: Optional['outputs.GuestPoliciesRecipeUpdateStepMsiInstallation'] = None,
                 rpm_installation: Optional['outputs.GuestPoliciesRecipeUpdateStepRpmInstallation'] = None,
                 script_run: Optional['outputs.GuestPoliciesRecipeUpdateStepScriptRun'] = None):
        """
        :param 'GuestPoliciesRecipeUpdateStepArchiveExtractionArgs' archive_extraction: Extracts an archive into the specified directory.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepDpkgInstallationArgs' dpkg_installation: Installs a deb file via dpkg.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepFileCopyArgs' file_copy: Copies a file onto the instance.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepFileExecArgs' file_exec: Executes an artifact or local file.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepMsiInstallationArgs' msi_installation: Installs an MSI file.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepRpmInstallationArgs' rpm_installation: Installs an rpm file via the rpm utility.
               Structure is documented below.
        :param 'GuestPoliciesRecipeUpdateStepScriptRunArgs' script_run: Runs commands in a shell.
               Structure is documented below.
        """
        if archive_extraction is not None:
            pulumi.set(__self__, "archive_extraction", archive_extraction)
        if dpkg_installation is not None:
            pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        if file_copy is not None:
            pulumi.set(__self__, "file_copy", file_copy)
        if file_exec is not None:
            pulumi.set(__self__, "file_exec", file_exec)
        if msi_installation is not None:
            pulumi.set(__self__, "msi_installation", msi_installation)
        if rpm_installation is not None:
            pulumi.set(__self__, "rpm_installation", rpm_installation)
        if script_run is not None:
            pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepArchiveExtraction']:
        """
        Extracts an archive into the specified directory.
        Structure is documented below.
        """
        return pulumi.get(self, "archive_extraction")

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepDpkgInstallation']:
        """
        Installs a deb file via dpkg.
        Structure is documented below.
        """
        return pulumi.get(self, "dpkg_installation")

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepFileCopy']:
        """
        Copies a file onto the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "file_copy")

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepFileExec']:
        """
        Executes an artifact or local file.
        Structure is documented below.
        """
        return pulumi.get(self, "file_exec")

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepMsiInstallation']:
        """
        Installs an MSI file.
        Structure is documented below.
        """
        return pulumi.get(self, "msi_installation")

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepRpmInstallation']:
        """
        Installs an rpm file via the rpm utility.
        Structure is documented below.
        """
        return pulumi.get(self, "rpm_installation")

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> Optional['outputs.GuestPoliciesRecipeUpdateStepScriptRun']:
        """
        Runs commands in a shell.
        Structure is documented below.
        """
        return pulumi.get(self, "script_run")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepArchiveExtraction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepArchiveExtraction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepArchiveExtraction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepArchiveExtraction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 type: str,
                 destination: Optional[str] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str type: The type of the archive to extract.
               Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        :param str destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "type", type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the archive to extract.
        Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepDpkgInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepDpkgInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepDpkgInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepDpkgInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepFileCopy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepFileCopy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepFileCopy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepFileCopy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 destination: str,
                 overwrite: Optional[bool] = None,
                 permissions: Optional[str] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        :param bool overwrite: Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
               is not overwritten and the step is considered a success. Defaults to false.
        :param str permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
               for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
               number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
               bit corresponds to the execute permission. Default behavior is 755.
               Below are some examples of permissions and their associated values:
               read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[bool]:
        """
        Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
        is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[str]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
        for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
        number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
        bit corresponds to the execute permission. Default behavior is 755.
        Below are some examples of permissions and their associated values:
        read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepFileExec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"
        elif key == "artifactId":
            suggest = "artifact_id"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepFileExec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepFileExec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepFileExec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_exit_codes: Optional[Sequence[int]] = None,
                 args: Optional[Sequence[str]] = None,
                 artifact_id: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param Sequence[str] args: Arguments to be passed to the provided executable.
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str local_path: The absolute path of the file on the local filesystem.
        """
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepMsiInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "allowedExitCodes":
            suggest = "allowed_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepMsiInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepMsiInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepMsiInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 allowed_exit_codes: Optional[Sequence[int]] = None,
                 flags: Optional[Sequence[str]] = None):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param Sequence[str] flags: The flags to use when installing the MSI. Defaults to the install flag.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def flags(self) -> Optional[Sequence[str]]:
        """
        The flags to use when installing the MSI. Defaults to the install flag.
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepRpmInstallation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepRpmInstallation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepRpmInstallation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepRpmInstallation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        :param str artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class GuestPoliciesRecipeUpdateStepScriptRun(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestPoliciesRecipeUpdateStepScriptRun. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestPoliciesRecipeUpdateStepScriptRun.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestPoliciesRecipeUpdateStepScriptRun.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script: str,
                 allowed_exit_codes: Optional[Sequence[int]] = None,
                 interpreter: Optional[str] = None):
        """
        :param str script: The shell script to be executed.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
               which likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        """
        pulumi.set(__self__, "script", script)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        The shell script to be executed.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
        which likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")


@pulumi.output_type
class OsPolicyAssignmentInstanceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionLabels":
            suggest = "exclusion_labels"
        elif key == "inclusionLabels":
            suggest = "inclusion_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentInstanceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentInstanceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentInstanceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[bool] = None,
                 exclusion_labels: Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterExclusionLabel']] = None,
                 inclusion_labels: Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterInclusionLabel']] = None,
                 inventories: Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterInventory']] = None):
        """
        :param bool all: Target all VMs in the project. If true, no other criteria is permitted.
        :param Sequence['OsPolicyAssignmentInstanceFilterExclusionLabelArgs'] exclusion_labels: List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        :param Sequence['OsPolicyAssignmentInstanceFilterInclusionLabelArgs'] inclusion_labels: List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        :param Sequence['OsPolicyAssignmentInstanceFilterInventoryArgs'] inventories: List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if exclusion_labels is not None:
            pulumi.set(__self__, "exclusion_labels", exclusion_labels)
        if inclusion_labels is not None:
            pulumi.set(__self__, "inclusion_labels", inclusion_labels)
        if inventories is not None:
            pulumi.set(__self__, "inventories", inventories)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Target all VMs in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="exclusionLabels")
    def exclusion_labels(self) -> Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterExclusionLabel']]:
        """
        List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "exclusion_labels")

    @property
    @pulumi.getter(name="inclusionLabels")
    def inclusion_labels(self) -> Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterInclusionLabel']]:
        """
        List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "inclusion_labels")

    @property
    @pulumi.getter
    def inventories(self) -> Optional[Sequence['outputs.OsPolicyAssignmentInstanceFilterInventory']]:
        """
        List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        return pulumi.get(self, "inventories")


@pulumi.output_type
class OsPolicyAssignmentInstanceFilterExclusionLabel(dict):
    def __init__(__self__, *,
                 labels: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] labels: Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class OsPolicyAssignmentInstanceFilterInclusionLabel(dict):
    def __init__(__self__, *,
                 labels: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] labels: Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class OsPolicyAssignmentInstanceFilterInventory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentInstanceFilterInventory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentInstanceFilterInventory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentInstanceFilterInventory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: Optional[str] = None):
        """
        :param str os_short_name: Required. The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        Required. The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OsPolicyAssignmentOsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroups":
            suggest = "resource_groups"
        elif key == "allowNoResourceGroupMatch":
            suggest = "allow_no_resource_group_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 mode: str,
                 resource_groups: Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroup'],
                 allow_no_resource_group_match: Optional[bool] = None,
                 description: Optional[str] = None):
        """
        :param str id: Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        :param str mode: Required. Policy mode Possible values: MODE_UNSPECIFIED, VALIDATION, ENFORCEMENT
        :param Sequence['OsPolicyAssignmentOsPolicyResourceGroupArgs'] resource_groups: Required. List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        :param bool allow_no_resource_group_match: This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        :param str description: OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "resource_groups", resource_groups)
        if allow_no_resource_group_match is not None:
            pulumi.set(__self__, "allow_no_resource_group_match", allow_no_resource_group_match)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Required. Policy mode Possible values: MODE_UNSPECIFIED, VALIDATION, ENFORCEMENT
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroup']:
        """
        Required. List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        return pulumi.get(self, "resource_groups")

    @property
    @pulumi.getter(name="allowNoResourceGroupMatch")
    def allow_no_resource_group_match(self) -> Optional[bool]:
        """
        This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        """
        return pulumi.get(self, "allow_no_resource_group_match")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inventoryFilters":
            suggest = "inventory_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resources: Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroupResource'],
                 inventory_filters: Optional[Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter']] = None):
        """
        :param Sequence['OsPolicyAssignmentOsPolicyResourceGroupResourceArgs'] resources: Required. List of resources configured for this resource group. The resources are executed in the exact order specified here.
        :param Sequence['OsPolicyAssignmentOsPolicyResourceGroupInventoryFilterArgs'] inventory_filters: List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        """
        pulumi.set(__self__, "resources", resources)
        if inventory_filters is not None:
            pulumi.set(__self__, "inventory_filters", inventory_filters)

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroupResource']:
        """
        Required. List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="inventoryFilters")
    def inventory_filters(self) -> Optional[Sequence['outputs.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter']]:
        """
        List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        """
        return pulumi.get(self, "inventory_filters")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupInventoryFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: Optional[str] = None):
        """
        :param str os_short_name: Required. The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        Required. The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 exec_: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExec'] = None,
                 file: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFile'] = None,
                 pkg: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkg'] = None,
                 repository: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepository'] = None):
        """
        :param str id: Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs' exec_: Exec resource
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs' file: A remote or local source.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs' pkg: Package resource
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs' repository: Package repository resource
        """
        pulumi.set(__self__, "id", id)
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if pkg is not None:
            pulumi.set(__self__, "pkg", pkg)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExec']:
        """
        Exec resource
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFile']:
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def pkg(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkg']:
        """
        Package resource
        """
        return pulumi.get(self, "pkg")

    @property
    @pulumi.getter
    def repository(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepository']:
        """
        Package repository resource
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExec(dict):
    def __init__(__self__, *,
                 validate: 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate',
                 enforce: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce'] = None):
        """
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs' validate: Required. What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs' enforce: What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        pulumi.set(__self__, "validate", validate)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)

    @property
    @pulumi.getter
    def validate(self) -> 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate':
        """
        Required. What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        return pulumi.get(self, "validate")

    @property
    @pulumi.getter
    def enforce(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce']:
        """
        What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        return pulumi.get(self, "enforce")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputFilePath":
            suggest = "output_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforce.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interpreter: str,
                 args: Optional[Sequence[str]] = None,
                 file: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile'] = None,
                 output_file_path: Optional[str] = None,
                 script: Optional[str] = None):
        """
        :param str interpreter: Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
        :param Sequence[str] args: Optional arguments to pass to the source during execution.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs' file: A remote or local source.
        :param str output_file_path: Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        :param str script: An inline script. The size of the script is limited to 1024 characters.
        """
        pulumi.set(__self__, "interpreter", interpreter)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if output_file_path is not None:
            pulumi.set(__self__, "output_file_path", output_file_path)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Optional arguments to pass to the source during execution.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile']:
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="outputFilePath")
    def output_file_path(self) -> Optional[str]:
        """
        Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        """
        return pulumi.get(self, "output_file_path")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        An inline script. The size of the script is limited to 1024 characters.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputFilePath":
            suggest = "output_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interpreter: str,
                 args: Optional[Sequence[str]] = None,
                 file: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile'] = None,
                 output_file_path: Optional[str] = None,
                 script: Optional[str] = None):
        """
        :param str interpreter: Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
        :param Sequence[str] args: Optional arguments to pass to the source during execution.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs' file: A remote or local source.
        :param str output_file_path: Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        :param str script: An inline script. The size of the script is limited to 1024 characters.
        """
        pulumi.set(__self__, "interpreter", interpreter)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if output_file_path is not None:
            pulumi.set(__self__, "output_file_path", output_file_path)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Optional arguments to pass to the source during execution.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile']:
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="outputFilePath")
    def output_file_path(self) -> Optional[str]:
        """
        Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        """
        return pulumi.get(self, "output_file_path")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        An inline script. The size of the script is limited to 1024 characters.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceFile(dict):
    def __init__(__self__, *,
                 path: str,
                 state: str,
                 content: Optional[str] = None,
                 file: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile'] = None,
                 permissions: Optional[str] = None):
        """
        :param str path: Required. The absolute path of the file within the VM.
        :param str state: Required. Desired state of the file. Possible values: OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED, COMPLIANT, NON_COMPLIANT, UNKNOWN, NO_OS_POLICIES_APPLICABLE
        :param str content: A a file with this content. The size of the content is limited to 1024 characters.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs' file: A remote or local source.
        :param str permissions: -
               Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "state", state)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Required. The absolute path of the file within the VM.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Required. Desired state of the file. Possible values: OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED, COMPLIANT, NON_COMPLIANT, UNKNOWN, NO_OS_POLICIES_APPLICABLE
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        A a file with this content. The size of the content is limited to 1024 characters.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile']:
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[str]:
        """
        -
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceFileFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkg(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkg. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkg.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkg.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_state: str,
                 apt: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgApt'] = None,
                 deb: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb'] = None,
                 googet: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGooget'] = None,
                 msi: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsi'] = None,
                 rpm: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm'] = None,
                 yum: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYum'] = None,
                 zypper: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypper'] = None):
        """
        :param str desired_state: Required. The desired state the agent should maintain for this package. Possible values: DESIRED_STATE_UNSPECIFIED, INSTALLED, REMOVED
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs' apt: An Apt Repository.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs' deb: A deb package file.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGoogetArgs' googet: A package managed by GooGet.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs' msi: An MSI package.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs' rpm: An rpm package file.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYumArgs' yum: A Yum Repository.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypperArgs' zypper: A Zypper Repository.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if deb is not None:
            pulumi.set(__self__, "deb", deb)
        if googet is not None:
            pulumi.set(__self__, "googet", googet)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if rpm is not None:
            pulumi.set(__self__, "rpm", rpm)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        Required. The desired state the agent should maintain for this package. Possible values: DESIRED_STATE_UNSPECIFIED, INSTALLED, REMOVED
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def apt(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgApt']:
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def deb(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb']:
        """
        A deb package file.
        """
        return pulumi.get(self, "deb")

    @property
    @pulumi.getter
    def googet(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGooget']:
        """
        A package managed by GooGet.
        """
        return pulumi.get(self, "googet")

    @property
    @pulumi.getter
    def msi(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsi']:
        """
        An MSI package.
        """
        return pulumi.get(self, "msi")

    @property
    @pulumi.getter
    def rpm(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm']:
        """
        An rpm package file.
        """
        return pulumi.get(self, "rpm")

    @property
    @pulumi.getter
    def yum(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYum']:
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypper']:
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgApt(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Required. The name of the repository.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDeb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource',
                 pull_deps: Optional[bool] = None):
        """
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs' source: Required. An rpm package.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        pulumi.set(__self__, "source", source)
        if pull_deps is not None:
            pulumi.set(__self__, "pull_deps", pull_deps)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource':
        """
        Required. An rpm package.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> Optional[bool]:
        """
        Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        return pulumi.get(self, "pull_deps")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGooget(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Required. The name of the repository.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsi(dict):
    def __init__(__self__, *,
                 source: 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource',
                 properties: Optional[Sequence[str]] = None):
        """
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs' source: Required. An rpm package.
        :param Sequence[str] properties: Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        pulumi.set(__self__, "source", source)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource':
        """
        Required. An rpm package.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence[str]]:
        """
        Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource',
                 pull_deps: Optional[bool] = None):
        """
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs' source: Required. An rpm package.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        pulumi.set(__self__, "source", source)
        if pull_deps is not None:
            pulumi.set(__self__, "pull_deps", pull_deps)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource':
        """
        Required. An rpm package.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> Optional[bool]:
        """
        Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        return pulumi.get(self, "pull_deps")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: Optional[bool] = None,
                 gcs: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcs'] = None,
                 local_path: Optional[str] = None,
                 remote: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote'] = None):
        """
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcsArgs' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemoteArgs' remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcs']:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote']:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[int] = None):
        """
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str object: Required. Name of the Cloud Storage object.
        :param int generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 sha256_checksum: Optional[str] = None):
        """
        :param str uri: Required. URI for this repository.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[str]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYum(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Required. The name of the repository.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypper(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Required. The name of the repository.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceRepository(dict):
    def __init__(__self__, *,
                 apt: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt'] = None,
                 goo: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGoo'] = None,
                 yum: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum'] = None,
                 zypper: Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper'] = None):
        """
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryAptArgs' apt: An Apt Repository.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGooArgs' goo: A Goo Repository.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYumArgs' yum: A Yum Repository.
        :param 'OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypperArgs' zypper: A Zypper Repository.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt']:
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGoo']:
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter
    def yum(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum']:
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> Optional['outputs.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper']:
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveType":
            suggest = "archive_type"
        elif key == "gpgKey":
            suggest = "gpg_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryApt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_type: str,
                 components: Sequence[str],
                 distribution: str,
                 uri: str,
                 gpg_key: Optional[str] = None):
        """
        :param str archive_type: Required. Type of archive files in this repository. Possible values: ARCHIVE_TYPE_UNSPECIFIED, DEB, DEB_SRC
        :param Sequence[str] components: Required. List of components for this repository. Must contain at least one item.
        :param str distribution: Required. Distribution of this repository.
        :param str uri: Required. URI for this repository.
        :param str gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        pulumi.set(__self__, "archive_type", archive_type)
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "uri", uri)
        if gpg_key is not None:
            pulumi.set(__self__, "gpg_key", gpg_key)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> str:
        """
        Required. Type of archive files in this repository. Possible values: ARCHIVE_TYPE_UNSPECIFIED, DEB, DEB_SRC
        """
        return pulumi.get(self, "archive_type")

    @property
    @pulumi.getter
    def components(self) -> Sequence[str]:
        """
        Required. List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        Required. Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> Optional[str]:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        return pulumi.get(self, "gpg_key")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGoo(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        :param str name: Required. The name of the repository.
        :param str url: Required. The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Required. The url of the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYum.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 id: str,
                 display_name: Optional[str] = None,
                 gpg_keys: Optional[Sequence[str]] = None):
        """
        :param str base_url: Required. The location of the repository directory.
        :param str id: Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        Required. The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[Sequence[str]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 id: str,
                 display_name: Optional[str] = None,
                 gpg_keys: Optional[Sequence[str]] = None):
        """
        :param str base_url: Required. The location of the repository directory.
        :param str id: Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        Required. The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[Sequence[str]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OsPolicyAssignmentRollout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"
        elif key == "minWaitDuration":
            suggest = "min_wait_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsPolicyAssignmentRollout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsPolicyAssignmentRollout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsPolicyAssignmentRollout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.OsPolicyAssignmentRolloutDisruptionBudget',
                 min_wait_duration: str):
        """
        :param 'OsPolicyAssignmentRolloutDisruptionBudgetArgs' disruption_budget: Required. The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        :param str min_wait_duration: Required. This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "min_wait_duration", min_wait_duration)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.OsPolicyAssignmentRolloutDisruptionBudget':
        """
        Required. The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter(name="minWaitDuration")
    def min_wait_duration(self) -> str:
        """
        Required. This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        return pulumi.get(self, "min_wait_duration")


@pulumi.output_type
class OsPolicyAssignmentRolloutDisruptionBudget(dict):
    def __init__(__self__, *,
                 fixed: Optional[int] = None,
                 percent: Optional[int] = None):
        """
        :param int fixed: Specifies a fixed value.
        :param int percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[int]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> Optional[int]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class PatchDeploymentInstanceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLabels":
            suggest = "group_labels"
        elif key == "instanceNamePrefixes":
            suggest = "instance_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentInstanceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentInstanceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentInstanceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[bool] = None,
                 group_labels: Optional[Sequence['outputs.PatchDeploymentInstanceFilterGroupLabel']] = None,
                 instance_name_prefixes: Optional[Sequence[str]] = None,
                 instances: Optional[Sequence[str]] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        :param bool all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param Sequence['PatchDeploymentInstanceFilterGroupLabelArgs'] group_labels: Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
               Structure is documented below.
        :param Sequence[str] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
               VMs when targeting configs, for example prefix="prod-".
        :param Sequence[str] instances: Targets any of the VM instances specified. Instances are specified by their URI in the `form zones/{{zone}}/instances/{{instance_name}}`,
               `projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`, or
               `https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`
        :param Sequence[str] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[Sequence['outputs.PatchDeploymentInstanceFilterGroupLabel']]:
        """
        Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        Structure is documented below.
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[Sequence[str]]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
        VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the `form zones/{{zone}}/instances/{{instance_name}}`,
        `projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`, or
        `https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PatchDeploymentInstanceFilterGroupLabel(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        :param Mapping[str, str] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class PatchDeploymentOneTimeSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentOneTimeSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentOneTimeSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentOneTimeSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: str):
        """
        :param str execute_time: The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> str:
        """
        The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "execute_time")


@pulumi.output_type
class PatchDeploymentPatchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "migInstancesAllowed":
            suggest = "mig_instances_allowed"
        elif key == "postStep":
            suggest = "post_step"
        elif key == "preStep":
            suggest = "pre_step"
        elif key == "rebootConfig":
            suggest = "reboot_config"
        elif key == "windowsUpdate":
            suggest = "windows_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt: Optional['outputs.PatchDeploymentPatchConfigApt'] = None,
                 goo: Optional['outputs.PatchDeploymentPatchConfigGoo'] = None,
                 mig_instances_allowed: Optional[bool] = None,
                 post_step: Optional['outputs.PatchDeploymentPatchConfigPostStep'] = None,
                 pre_step: Optional['outputs.PatchDeploymentPatchConfigPreStep'] = None,
                 reboot_config: Optional[str] = None,
                 windows_update: Optional['outputs.PatchDeploymentPatchConfigWindowsUpdate'] = None,
                 yum: Optional['outputs.PatchDeploymentPatchConfigYum'] = None,
                 zypper: Optional['outputs.PatchDeploymentPatchConfigZypper'] = None):
        """
        :param 'PatchDeploymentPatchConfigAptArgs' apt: Apt update settings. Use this setting to override the default apt patch rules.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigGooArgs' goo: goo update settings. Use this setting to override the default goo patch rules.
               Structure is documented below.
        :param bool mig_instances_allowed: Allows the patch job to run on Managed instance groups (MIGs).
        :param 'PatchDeploymentPatchConfigPostStepArgs' post_step: The ExecStep to run after the patch update.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigPreStepArgs' pre_step: The ExecStep to run before the patch update.
               Structure is documented below.
        :param str reboot_config: Post-patch reboot settings.
               Possible values are `DEFAULT`, `ALWAYS`, and `NEVER`.
        :param 'PatchDeploymentPatchConfigWindowsUpdateArgs' windows_update: Windows update settings. Use this setting to override the default Windows patch rules.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigYumArgs' yum: Yum update settings. Use this setting to override the default yum patch rules.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigZypperArgs' zypper: zypper update settings. Use this setting to override the default zypper patch rules.
               Structure is documented below.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if mig_instances_allowed is not None:
            pulumi.set(__self__, "mig_instances_allowed", mig_instances_allowed)
        if post_step is not None:
            pulumi.set(__self__, "post_step", post_step)
        if pre_step is not None:
            pulumi.set(__self__, "pre_step", pre_step)
        if reboot_config is not None:
            pulumi.set(__self__, "reboot_config", reboot_config)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional['outputs.PatchDeploymentPatchConfigApt']:
        """
        Apt update settings. Use this setting to override the default apt patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> Optional['outputs.PatchDeploymentPatchConfigGoo']:
        """
        goo update settings. Use this setting to override the default goo patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter(name="migInstancesAllowed")
    def mig_instances_allowed(self) -> Optional[bool]:
        """
        Allows the patch job to run on Managed instance groups (MIGs).
        """
        return pulumi.get(self, "mig_instances_allowed")

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> Optional['outputs.PatchDeploymentPatchConfigPostStep']:
        """
        The ExecStep to run after the patch update.
        Structure is documented below.
        """
        return pulumi.get(self, "post_step")

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> Optional['outputs.PatchDeploymentPatchConfigPreStep']:
        """
        The ExecStep to run before the patch update.
        Structure is documented below.
        """
        return pulumi.get(self, "pre_step")

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> Optional[str]:
        """
        Post-patch reboot settings.
        Possible values are `DEFAULT`, `ALWAYS`, and `NEVER`.
        """
        return pulumi.get(self, "reboot_config")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional['outputs.PatchDeploymentPatchConfigWindowsUpdate']:
        """
        Windows update settings. Use this setting to override the default Windows patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_update")

    @property
    @pulumi.getter
    def yum(self) -> Optional['outputs.PatchDeploymentPatchConfigYum']:
        """
        Yum update settings. Use this setting to override the default yum patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> Optional['outputs.PatchDeploymentPatchConfigZypper']:
        """
        zypper update settings. Use this setting to override the default zypper patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class PatchDeploymentPatchConfigApt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigApt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigApt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigApt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 exclusive_packages: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated.
               If these packages are not installed, they will be ignored. This field cannot be specified with
               any other patch configuration fields.
        :param str type: By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead.
               Possible values are `DIST` and `UPGRADE`.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[Sequence[str]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated.
        If these packages are not installed, they will be ignored. This field cannot be specified with
        any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead.
        Possible values are `DIST` and `UPGRADE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PatchDeploymentPatchConfigGoo(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: goo update settings. Use this setting to override the default goo patch rules.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        goo update settings. Use this setting to override the default goo patch rules.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class PatchDeploymentPatchConfigPostStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxExecStepConfig":
            suggest = "linux_exec_step_config"
        elif key == "windowsExecStepConfig":
            suggest = "windows_exec_step_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPostStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPostStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPostStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_exec_step_config: Optional['outputs.PatchDeploymentPatchConfigPostStepLinuxExecStepConfig'] = None,
                 windows_exec_step_config: Optional['outputs.PatchDeploymentPatchConfigPostStepWindowsExecStepConfig'] = None):
        """
        :param 'PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs' linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs' windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
               Structure is documented below.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional['outputs.PatchDeploymentPatchConfigPostStepLinuxExecStepConfig']:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional['outputs.PatchDeploymentPatchConfigPostStepWindowsExecStepConfig']:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_exec_step_config")


@pulumi.output_type
class PatchDeploymentPatchConfigPostStepLinuxExecStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPostStepLinuxExecStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPostStepLinuxExecStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPostStepLinuxExecStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Optional[Sequence[int]] = None,
                 gcs_object: Optional['outputs.PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject'] = None,
                 interpreter: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs' gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param str local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[Sequence[int]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional['outputs.PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject']:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class PatchDeploymentPatchConfigPostStepWindowsExecStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPostStepWindowsExecStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPostStepWindowsExecStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPostStepWindowsExecStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Optional[Sequence[int]] = None,
                 gcs_object: Optional['outputs.PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject'] = None,
                 interpreter: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs' gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param str local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[Sequence[int]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional['outputs.PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject']:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class PatchDeploymentPatchConfigPreStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxExecStepConfig":
            suggest = "linux_exec_step_config"
        elif key == "windowsExecStepConfig":
            suggest = "windows_exec_step_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPreStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPreStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPreStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_exec_step_config: Optional['outputs.PatchDeploymentPatchConfigPreStepLinuxExecStepConfig'] = None,
                 windows_exec_step_config: Optional['outputs.PatchDeploymentPatchConfigPreStepWindowsExecStepConfig'] = None):
        """
        :param 'PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs' linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
               Structure is documented below.
        :param 'PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs' windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
               Structure is documented below.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional['outputs.PatchDeploymentPatchConfigPreStepLinuxExecStepConfig']:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional['outputs.PatchDeploymentPatchConfigPreStepWindowsExecStepConfig']:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_exec_step_config")


@pulumi.output_type
class PatchDeploymentPatchConfigPreStepLinuxExecStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPreStepLinuxExecStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPreStepLinuxExecStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPreStepLinuxExecStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Optional[Sequence[int]] = None,
                 gcs_object: Optional['outputs.PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject'] = None,
                 interpreter: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs' gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param str local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[Sequence[int]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional['outputs.PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject']:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class PatchDeploymentPatchConfigPreStepWindowsExecStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPreStepWindowsExecStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPreStepWindowsExecStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPreStepWindowsExecStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Optional[Sequence[int]] = None,
                 gcs_object: Optional['outputs.PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject'] = None,
                 interpreter: Optional[str] = None,
                 local_path: Optional[str] = None):
        """
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs' gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param str local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[Sequence[int]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional['outputs.PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject']:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[str]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[str]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class PatchDeploymentPatchConfigWindowsUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigWindowsUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigWindowsUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigWindowsUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications: Optional[Sequence[str]] = None,
                 excludes: Optional[Sequence[str]] = None,
                 exclusive_patches: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
               Each value may be one of `CRITICAL`, `SECURITY`, `DEFINITION`, `DRIVER`, `FEATURE_PACK`, `SERVICE_PACK`, `TOOL`, `UPDATE_ROLLUP`, and `UPDATE`.
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated.
               This field must not be used with other patch configurations.
        """
        if classifications is not None:
            pulumi.set(__self__, "classifications", classifications)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Optional[Sequence[str]]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        Each value may be one of `CRITICAL`, `SECURITY`, `DEFINITION`, `DRIVER`, `FEATURE_PACK`, `SERVICE_PACK`, `TOOL`, `UPDATE_ROLLUP`, and `UPDATE`.
        """
        return pulumi.get(self, "classifications")

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[Sequence[str]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated.
        This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")


@pulumi.output_type
class PatchDeploymentPatchConfigYum(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigYum. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigYum.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigYum.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 exclusive_packages: Optional[Sequence[str]] = None,
                 minimal: Optional[bool] = None,
                 security: Optional[bool] = None):
        """
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated.
               If these packages are not installed, they will be ignored. This field cannot be specified with
               any other patch configuration fields.
        :param bool minimal: Will cause patch to run yum update-minimal instead.
        :param bool security: Adds the --security flag to yum update. Not supported on all platforms.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if minimal is not None:
            pulumi.set(__self__, "minimal", minimal)
        if security is not None:
            pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[Sequence[str]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated.
        If these packages are not installed, they will be ignored. This field cannot be specified with
        any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def minimal(self) -> Optional[bool]:
        """
        Will cause patch to run yum update-minimal instead.
        """
        return pulumi.get(self, "minimal")

    @property
    @pulumi.getter
    def security(self) -> Optional[bool]:
        """
        Adds the --security flag to yum update. Not supported on all platforms.
        """
        return pulumi.get(self, "security")


@pulumi.output_type
class PatchDeploymentPatchConfigZypper(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"
        elif key == "withOptional":
            suggest = "with_optional"
        elif key == "withUpdate":
            suggest = "with_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentPatchConfigZypper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentPatchConfigZypper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentPatchConfigZypper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Optional[Sequence[str]] = None,
                 excludes: Optional[Sequence[str]] = None,
                 exclusive_patches: Optional[Sequence[str]] = None,
                 severities: Optional[Sequence[str]] = None,
                 with_optional: Optional[bool] = None,
                 with_update: Optional[bool] = None):
        """
        :param Sequence[str] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated.
               This field must not be used with other patch configurations.
        :param Sequence[str] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param bool with_optional: Adds the --with-optional flag to zypper patch.
        :param bool with_update: Adds the --with-update flag, to zypper patch.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)
        if with_optional is not None:
            pulumi.set(__self__, "with_optional", with_optional)
        if with_update is not None:
            pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[Sequence[str]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated.
        This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    @property
    @pulumi.getter
    def severities(self) -> Optional[Sequence[str]]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> Optional[bool]:
        """
        Adds the --with-optional flag to zypper patch.
        """
        return pulumi.get(self, "with_optional")

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> Optional[bool]:
        """
        Adds the --with-update flag, to zypper patch.
        """
        return pulumi.get(self, "with_update")


@pulumi.output_type
class PatchDeploymentRecurringSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeOfDay":
            suggest = "time_of_day"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "lastExecuteTime":
            suggest = "last_execute_time"
        elif key == "nextExecuteTime":
            suggest = "next_execute_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentRecurringSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentRecurringSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentRecurringSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_of_day: 'outputs.PatchDeploymentRecurringScheduleTimeOfDay',
                 time_zone: 'outputs.PatchDeploymentRecurringScheduleTimeZone',
                 end_time: Optional[str] = None,
                 last_execute_time: Optional[str] = None,
                 monthly: Optional['outputs.PatchDeploymentRecurringScheduleMonthly'] = None,
                 next_execute_time: Optional[str] = None,
                 start_time: Optional[str] = None,
                 weekly: Optional['outputs.PatchDeploymentRecurringScheduleWeekly'] = None):
        """
        :param 'PatchDeploymentRecurringScheduleTimeOfDayArgs' time_of_day: Time of the day to run a recurring deployment.
               Structure is documented below.
        :param 'PatchDeploymentRecurringScheduleTimeZoneArgs' time_zone: Defines the time zone that timeOfDay is relative to. The rules for daylight saving time are
               determined by the chosen time zone.
               Structure is documented below.
        :param str end_time: The end time at which a recurring patch deployment schedule is no longer active.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param str last_execute_time: -
               The time the last patch job ran successfully.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param 'PatchDeploymentRecurringScheduleMonthlyArgs' monthly: Schedule with monthly executions.
               Structure is documented below.
        :param str next_execute_time: -
               The time the next patch job is scheduled to run.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param str start_time: The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param 'PatchDeploymentRecurringScheduleWeeklyArgs' weekly: Schedule with weekly executions.
               Structure is documented below.
        """
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if last_execute_time is not None:
            pulumi.set(__self__, "last_execute_time", last_execute_time)
        if monthly is not None:
            pulumi.set(__self__, "monthly", monthly)
        if next_execute_time is not None:
            pulumi.set(__self__, "next_execute_time", next_execute_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> 'outputs.PatchDeploymentRecurringScheduleTimeOfDay':
        """
        Time of the day to run a recurring deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "time_of_day")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> 'outputs.PatchDeploymentRecurringScheduleTimeZone':
        """
        Defines the time zone that timeOfDay is relative to. The rules for daylight saving time are
        determined by the chosen time zone.
        Structure is documented below.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The end time at which a recurring patch deployment schedule is no longer active.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="lastExecuteTime")
    def last_execute_time(self) -> Optional[str]:
        """
        -
        The time the last patch job ran successfully.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_execute_time")

    @property
    @pulumi.getter
    def monthly(self) -> Optional['outputs.PatchDeploymentRecurringScheduleMonthly']:
        """
        Schedule with monthly executions.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly")

    @property
    @pulumi.getter(name="nextExecuteTime")
    def next_execute_time(self) -> Optional[str]:
        """
        -
        The time the next patch job is scheduled to run.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_execute_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def weekly(self) -> Optional['outputs.PatchDeploymentRecurringScheduleWeekly']:
        """
        Schedule with weekly executions.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly")


@pulumi.output_type
class PatchDeploymentRecurringScheduleMonthly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDay":
            suggest = "month_day"
        elif key == "weekDayOfMonth":
            suggest = "week_day_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentRecurringScheduleMonthly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentRecurringScheduleMonthly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentRecurringScheduleMonthly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 month_day: Optional[int] = None,
                 week_day_of_month: Optional['outputs.PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth'] = None):
        """
        :param int month_day: One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
               Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
               will not run in February, April, June, etc.
        :param 'PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs' week_day_of_month: Week day in a month.
               Structure is documented below.
        """
        if month_day is not None:
            pulumi.set(__self__, "month_day", month_day)
        if week_day_of_month is not None:
            pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> Optional[int]:
        """
        One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
        Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
        will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> Optional['outputs.PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth']:
        """
        Week day in a month.
        Structure is documented below.
        """
        return pulumi.get(self, "week_day_of_month")


@pulumi.output_type
class PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "weekOrdinal":
            suggest = "week_ordinal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 week_ordinal: int):
        """
        :param str day_of_week: A day of the week.
               Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        :param int week_ordinal: Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        A day of the week.
        Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> int:
        """
        Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")


@pulumi.output_type
class PatchDeploymentRecurringScheduleTimeOfDay(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class PatchDeploymentRecurringScheduleTimeZone(dict):
    def __init__(__self__, *,
                 id: str,
                 version: Optional[str] = None):
        """
        :param str id: IANA Time Zone Database time zone, e.g. "America/New_York".
        :param str version: IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        IANA Time Zone Database time zone, e.g. "America/New_York".
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PatchDeploymentRecurringScheduleWeekly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentRecurringScheduleWeekly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentRecurringScheduleWeekly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentRecurringScheduleWeekly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str):
        """
        :param str day_of_week: A day of the week.
               Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        A day of the week.
        Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")


@pulumi.output_type
class PatchDeploymentRollout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchDeploymentRollout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchDeploymentRollout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchDeploymentRollout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.PatchDeploymentRolloutDisruptionBudget',
                 mode: str):
        """
        :param 'PatchDeploymentRolloutDisruptionBudgetArgs' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up.
               During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps.
               A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget.
               For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone.
               For example, if the disruption budget has a fixed value of 10, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
               Structure is documented below.
        :param str mode: Mode of the patch rollout.
               Possible values are `ZONE_BY_ZONE` and `CONCURRENT_ZONES`.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.PatchDeploymentRolloutDisruptionBudget':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up.
        During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps.
        A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget.
        For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone.
        For example, if the disruption budget has a fixed value of 10, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        Structure is documented below.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode of the patch rollout.
        Possible values are `ZONE_BY_ZONE` and `CONCURRENT_ZONES`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class PatchDeploymentRolloutDisruptionBudget(dict):
    def __init__(__self__, *,
                 fixed: Optional[int] = None,
                 percentage: Optional[int] = None):
        """
        :param int fixed: Specifies a fixed value.
        :param int percentage: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[int]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percentage")


