# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Model.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os
import typer
from typer import echo
from tabulate import tabulate

from . import helper
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


@app.command()
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of records to offset at the beginning of the models list. If None, then the default value 0 will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of records to return from the server. If None, then the default value 100 will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to True, then only the deleted models will be displayed. Else, the default value "
        "False will be used to display only the list of active models.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only ids of model separated by space",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """List available models."""

    from ..client import Model

    df = Model.ls(offset=offset, limit=limit, disabled=disabled)

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def details(
    id: int = typer.Argument(
        ...,
        help="The model ID in the airt service.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return metadata of the given model."""

    from ..client import Model

    df = Model.details(id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def rm(
    id: int = typer.Argument(
        ...,
        help="The model ID in the airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the deleted model id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Remove the model from airt service."""

    from ..client import Model

    df = Model.delete(id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def predict(
    data_id: int = typer.Option(
        ...,
        "--data",
        help="The data ID in the airt service.",
    ),
    model_id: int = typer.Option(
        ...,
        "--model",
        help="The model ID in the airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the prediction id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Make predictions using the trained model."""

    from ..client import Model

    model = Model(model_id=int(model_id))

    prediction = model.predict(data_id=int(data_id))

    if quiet:
        prediction.wait()

        typer.echo(f"{prediction.prediction_id}")
    else:
        typer.echo(f"Running predictions for prediction id: {prediction.prediction_id}")
        prediction.progress_bar()


# Internal Cell


@app.command()
@helper.requires_auth_token
def evaluate(
    id: int = typer.Argument(
        ...,
        help="The model ID in the airt service.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Evaluate the performance of the trained model."""

    from ..client import Model

    model = Model(model_id=int(id))

    df = model.evaluate()

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))
