# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_User.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os

import typer
from typer import echo
from tabulate import tabulate
import datetime as dt
import pandas as pd

from ..client import Client
from . import helper
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


@app.command()
@helper.requires_auth_token
def create(
    username: str = typer.Option(
        ...,
        "--username",
        "-un",
        help="The username for the new user. If the passed username is already available in airt service,"
        "then an error message will be diplayed indicating the same.",
    ),
    first_name: str = typer.Option(
        ...,
        "--first_name",
        "-fn",
        help="The first name for the new user.",
    ),
    last_name: str = typer.Option(
        ...,
        "--last_name",
        "-ln",
        help="The last name for the new user.",
    ),
    email: str = typer.Option(
        ...,
        "--email",
        "-e",
        help="The email for the new user. If the passed email is already available in airt service, then an error message will be diplayed indicating the same.",
    ),
    password: str = typer.Option(
        ...,
        "--password",
        "-p",
        help="The password for the new user.",
    ),
    super_user: bool = typer.Option(
        False,
        "--super_user",
        "-su",
        help="If set to True, then the new user will have super user privilages. If None, then the default value False will be used.",
    ),
    quota: bool = typer.Option(
        False,
        "--quota",
        "-qt",
        help="If set to True, then the user will have access to all the routes. If None, then the default value False will be used and the user will have access only to `DataSource` routes.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Create a new user in airt service."""

    from ..client import User

    df = User.create(
        username=username,
        first_name=first_name,
        last_name=last_name,
        email=email,
        quota=quota,
        super_user=super_user,
        password=password,
    )

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of records to offset at the beginning of the users list. If None, then the default value 0 will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of records to return from the server. If None, then the default value 100 will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to True, then both active and disabled users will be displayed. If None, "
        "then the default value False will be used which will display only the list of active users.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only ids of users separated by space",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Display the list of available users."""

    from ..client import User

    df = User.ls(offset=offset, limit=limit, disabled=disabled)

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def disable(
    id: int = typer.Argument(
        ...,
        help="The user id to disabled in airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Disable a user in airt service."""

    from ..client import User

    df = User.disable(user_id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def enable(
    id: int = typer.Argument(
        ...,
        help="The id of the disabled user in airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Enable a disabled user in airt service."""

    from ..client import User

    df = User.enable(user_id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def update(
    user_id: int = typer.Option(
        ...,
        "--user_id",
        "-id",
        help="The id of the user in airt service.",
    ),
    username: str = typer.Option(
        None,
        "--username",
        "-un",
        help="New username for the user_id in airt service. If None (default value), then the username won't be updated for the user.",
    ),
    first_name: str = typer.Option(
        None,
        "--first_name",
        "-fn",
        help="New first_name for the user_id in airt service. If None (default value), then the first_name won't be updated for the user.",
    ),
    last_name: str = typer.Option(
        None,
        "--last_name",
        "-ln",
        help="New last_name for the user_id in airt service. If None (default value), then the last_name won't be updated for the user.",
    ),
    email: str = typer.Option(
        None,
        "--email",
        "-e",
        help="New email for the user_id in airt service. If None (default value), then the email won't be updated for the user.",
    ),
    password: str = typer.Option(
        None,
        "--password",
        "-p",
        help="New password for the user_id in airt service. If None (default value), then the password won't be updated for the user.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output user id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Update user details in airt service."""

    from ..client import User

    df = User.update(
        user_id=user_id,
        username=username,
        first_name=first_name,
        last_name=last_name,
        email=email,
        password=password,
    )

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))
