"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessContextManagerAccessLevelCondition = exports.AccessContextManagerAccessLevelConditionTimeoutsOutputReference = exports.accessContextManagerAccessLevelConditionTimeoutsToTerraform = exports.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference = exports.accessContextManagerAccessLevelConditionDevicePolicyToTerraform = exports.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList = exports.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference = exports.accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        minimum_version: cdktf.stringToTerraform(struct.minimumVersion),
        os_type: cdktf.stringToTerraform(struct.osType),
    };
}
exports.accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform = accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform;
class AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._minimumVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.minimumVersion = this._minimumVersion;
        }
        if (this._osType !== undefined) {
            hasAnyValues = true;
            internalValueResult.osType = this._osType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._minimumVersion = undefined;
            this._osType = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._minimumVersion = value.minimumVersion;
            this._osType = value.osType;
        }
    }
    get minimumVersion() {
        return this.getStringAttribute('minimum_version');
    }
    set minimumVersion(value) {
        this._minimumVersion = value;
    }
    resetMinimumVersion() {
        this._minimumVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minimumVersionInput() {
        return this._minimumVersion;
    }
    get osType() {
        return this.getStringAttribute('os_type');
    }
    set osType(value) {
        this._osType = value;
    }
    // Temporarily expose input value. Use with caution.
    get osTypeInput() {
        return this._osType;
    }
}
exports.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference = AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference[_a] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference", version: "2.0.46" };
class AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList = AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList;
_b = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList[_b] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList", version: "2.0.46" };
function accessContextManagerAccessLevelConditionDevicePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_device_management_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedDeviceManagementLevels),
        allowed_encryption_statuses: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedEncryptionStatuses),
        require_admin_approval: cdktf.booleanToTerraform(struct.requireAdminApproval),
        require_corp_owned: cdktf.booleanToTerraform(struct.requireCorpOwned),
        require_screen_lock: cdktf.booleanToTerraform(struct.requireScreenLock),
        os_constraints: cdktf.listMapper(accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform, true)(struct.osConstraints),
    };
}
exports.accessContextManagerAccessLevelConditionDevicePolicyToTerraform = accessContextManagerAccessLevelConditionDevicePolicyToTerraform;
class AccessContextManagerAccessLevelConditionDevicePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // os_constraints - computed: false, optional: true, required: false
        this._osConstraints = new AccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList(this, "os_constraints", false);
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedDeviceManagementLevels !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedDeviceManagementLevels = this._allowedDeviceManagementLevels;
        }
        if (this._allowedEncryptionStatuses !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedEncryptionStatuses = this._allowedEncryptionStatuses;
        }
        if (this._requireAdminApproval !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireAdminApproval = this._requireAdminApproval;
        }
        if (this._requireCorpOwned !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireCorpOwned = this._requireCorpOwned;
        }
        if (this._requireScreenLock !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireScreenLock = this._requireScreenLock;
        }
        if (this._osConstraints?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.osConstraints = this._osConstraints?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedDeviceManagementLevels = undefined;
            this._allowedEncryptionStatuses = undefined;
            this._requireAdminApproval = undefined;
            this._requireCorpOwned = undefined;
            this._requireScreenLock = undefined;
            this._osConstraints.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedDeviceManagementLevels = value.allowedDeviceManagementLevels;
            this._allowedEncryptionStatuses = value.allowedEncryptionStatuses;
            this._requireAdminApproval = value.requireAdminApproval;
            this._requireCorpOwned = value.requireCorpOwned;
            this._requireScreenLock = value.requireScreenLock;
            this._osConstraints.internalValue = value.osConstraints;
        }
    }
    get allowedDeviceManagementLevels() {
        return this.getListAttribute('allowed_device_management_levels');
    }
    set allowedDeviceManagementLevels(value) {
        this._allowedDeviceManagementLevels = value;
    }
    resetAllowedDeviceManagementLevels() {
        this._allowedDeviceManagementLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedDeviceManagementLevelsInput() {
        return this._allowedDeviceManagementLevels;
    }
    get allowedEncryptionStatuses() {
        return this.getListAttribute('allowed_encryption_statuses');
    }
    set allowedEncryptionStatuses(value) {
        this._allowedEncryptionStatuses = value;
    }
    resetAllowedEncryptionStatuses() {
        this._allowedEncryptionStatuses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedEncryptionStatusesInput() {
        return this._allowedEncryptionStatuses;
    }
    get requireAdminApproval() {
        return this.getBooleanAttribute('require_admin_approval');
    }
    set requireAdminApproval(value) {
        this._requireAdminApproval = value;
    }
    resetRequireAdminApproval() {
        this._requireAdminApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireAdminApprovalInput() {
        return this._requireAdminApproval;
    }
    get requireCorpOwned() {
        return this.getBooleanAttribute('require_corp_owned');
    }
    set requireCorpOwned(value) {
        this._requireCorpOwned = value;
    }
    resetRequireCorpOwned() {
        this._requireCorpOwned = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireCorpOwnedInput() {
        return this._requireCorpOwned;
    }
    get requireScreenLock() {
        return this.getBooleanAttribute('require_screen_lock');
    }
    set requireScreenLock(value) {
        this._requireScreenLock = value;
    }
    resetRequireScreenLock() {
        this._requireScreenLock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireScreenLockInput() {
        return this._requireScreenLock;
    }
    get osConstraints() {
        return this._osConstraints;
    }
    putOsConstraints(value) {
        this._osConstraints.internalValue = value;
    }
    resetOsConstraints() {
        this._osConstraints.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osConstraintsInput() {
        return this._osConstraints.internalValue;
    }
}
exports.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference = AccessContextManagerAccessLevelConditionDevicePolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionDevicePolicyOutputReference[_c] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference", version: "2.0.46" };
function accessContextManagerAccessLevelConditionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
    };
}
exports.accessContextManagerAccessLevelConditionTimeoutsToTerraform = accessContextManagerAccessLevelConditionTimeoutsToTerraform;
class AccessContextManagerAccessLevelConditionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
}
exports.AccessContextManagerAccessLevelConditionTimeoutsOutputReference = AccessContextManagerAccessLevelConditionTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionTimeoutsOutputReference", version: "2.0.46" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition}
*/
class AccessContextManagerAccessLevelCondition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessLevelConditionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_access_context_manager_access_level_condition',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // device_policy - computed: false, optional: true, required: false
        this._devicePolicy = new AccessContextManagerAccessLevelConditionDevicePolicyOutputReference(this, "device_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new AccessContextManagerAccessLevelConditionTimeoutsOutputReference(this, "timeouts");
        this._accessLevel = config.accessLevel;
        this._id = config.id;
        this._ipSubnetworks = config.ipSubnetworks;
        this._members = config.members;
        this._negate = config.negate;
        this._regions = config.regions;
        this._requiredAccessLevels = config.requiredAccessLevels;
        this._devicePolicy.internalValue = config.devicePolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get accessLevel() {
        return this.getStringAttribute('access_level');
    }
    set accessLevel(value) {
        this._accessLevel = value;
    }
    // Temporarily expose input value. Use with caution.
    get accessLevelInput() {
        return this._accessLevel;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ipSubnetworks() {
        return this.getListAttribute('ip_subnetworks');
    }
    set ipSubnetworks(value) {
        this._ipSubnetworks = value;
    }
    resetIpSubnetworks() {
        this._ipSubnetworks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipSubnetworksInput() {
        return this._ipSubnetworks;
    }
    get members() {
        return this.getListAttribute('members');
    }
    set members(value) {
        this._members = value;
    }
    resetMembers() {
        this._members = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membersInput() {
        return this._members;
    }
    get negate() {
        return this.getBooleanAttribute('negate');
    }
    set negate(value) {
        this._negate = value;
    }
    resetNegate() {
        this._negate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get negateInput() {
        return this._negate;
    }
    get regions() {
        return this.getListAttribute('regions');
    }
    set regions(value) {
        this._regions = value;
    }
    resetRegions() {
        this._regions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionsInput() {
        return this._regions;
    }
    get requiredAccessLevels() {
        return this.getListAttribute('required_access_levels');
    }
    set requiredAccessLevels(value) {
        this._requiredAccessLevels = value;
    }
    resetRequiredAccessLevels() {
        this._requiredAccessLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiredAccessLevelsInput() {
        return this._requiredAccessLevels;
    }
    get devicePolicy() {
        return this._devicePolicy;
    }
    putDevicePolicy(value) {
        this._devicePolicy.internalValue = value;
    }
    resetDevicePolicy() {
        this._devicePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get devicePolicyInput() {
        return this._devicePolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_level: cdktf.stringToTerraform(this._accessLevel),
            id: cdktf.stringToTerraform(this._id),
            ip_subnetworks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ipSubnetworks),
            members: cdktf.listMapper(cdktf.stringToTerraform, false)(this._members),
            negate: cdktf.booleanToTerraform(this._negate),
            regions: cdktf.listMapper(cdktf.stringToTerraform, false)(this._regions),
            required_access_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._requiredAccessLevels),
            device_policy: accessContextManagerAccessLevelConditionDevicePolicyToTerraform(this._devicePolicy.internalValue),
            timeouts: accessContextManagerAccessLevelConditionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.AccessContextManagerAccessLevelCondition = AccessContextManagerAccessLevelCondition;
_e = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelCondition[_e] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelCondition", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
AccessContextManagerAccessLevelCondition.tfResourceType = "google_access_context_manager_access_level_condition";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjZXNzLWNvbnRleHQtbWFuYWdlci1hY2Nlc3MtbGV2ZWwtY29uZGl0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2FjY2Vzcy1jb250ZXh0LW1hbmFnZXItYWNjZXNzLWxldmVsLWNvbmRpdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLCtCQUErQjtBQXNHL0IsU0FBZ0IsNEVBQTRFLENBQUMsTUFBOEY7SUFDekwsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxjQUFjLENBQUM7UUFDaEUsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO0tBQ2pELENBQUE7QUFDSCxDQUFDO0FBVEQsb0tBU0M7QUFFRCxNQUFhLGdGQUFpRixTQUFRLEtBQUssQ0FBQyxhQUFhO0lBSXZIOzs7OztNQUtFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCLEVBQUUsa0JBQTBCLEVBQUUsc0JBQStCO1FBQ3ZKLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxzQkFBc0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBVm5GLGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBVzlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFO1lBQ3hCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztTQUM3QjtRQUNELElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsZUFBZSxLQUFLLFNBQVMsRUFBRTtZQUN0QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDO1NBQzNEO1FBQ0QsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQXdHO1FBQy9ILElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztTQUMxQjthQUNJLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDL0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7U0FDOUI7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztZQUM1QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7U0FDN0I7SUFDSCxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBN0VILDRLQThFQzs7O0FBRUQsTUFBYSxxRUFBc0UsU0FBUSxLQUFLLENBQUMsV0FBVztJQUcxRzs7OztNQUlFO0lBQ0YsWUFBc0IsaUJBQTZDLEVBQVksa0JBQTBCLEVBQVksUUFBaUI7UUFDcEksS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFBO1FBRGxDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBNEI7UUFBWSx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFBWSxhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRXRJLENBQUM7SUFFRDs7TUFFRTtJQUNLLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sSUFBSSxnRkFBZ0YsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDckssQ0FBQzs7QUFqQkgsc0pBa0JDOzs7QUEyQ0QsU0FBZ0IsK0RBQStELENBQUMsTUFBbUk7SUFDak4sSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxnQ0FBZ0MsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxNQUFPLENBQUMsNkJBQTZCLENBQUM7UUFDekgsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUMsTUFBTyxDQUFDLHlCQUF5QixDQUFDO1FBQ2hILHNCQUFzQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsb0JBQW9CLENBQUM7UUFDOUUsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUN0RSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLGlCQUFpQixDQUFDO1FBQ3hFLGNBQWMsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLDRFQUE0RSxFQUFFLElBQUksQ0FBQyxDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7S0FDNUksQ0FBQTtBQUNILENBQUM7QUFiRCwwSUFhQztBQUVELE1BQWEsbUVBQW9FLFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHMUc7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7UUE2STlCLG9FQUFvRTtRQUM1RCxtQkFBYyxHQUFHLElBQUkscUVBQXFFLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxDQUFDO0lBdElsSSxDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsOEJBQThCLEtBQUssU0FBUyxFQUFFO1lBQ3JELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsNkJBQTZCLEdBQUcsSUFBSSxDQUFDLDhCQUE4QixDQUFDO1NBQ3pGO1FBQ0QsSUFBSSxJQUFJLENBQUMsMEJBQTBCLEtBQUssU0FBUyxFQUFFO1lBQ2pELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMseUJBQXlCLEdBQUcsSUFBSSxDQUFDLDBCQUEwQixDQUFDO1NBQ2pGO1FBQ0QsSUFBSSxJQUFJLENBQUMscUJBQXFCLEtBQUssU0FBUyxFQUFFO1lBQzVDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1NBQ3ZFO1FBQ0QsSUFBSSxJQUFJLENBQUMsaUJBQWlCLEtBQUssU0FBUyxFQUFFO1lBQ3hDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1NBQy9EO1FBQ0QsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssU0FBUyxFQUFFO1lBQ3pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1NBQ2pFO1FBQ0QsSUFBSSxJQUFJLENBQUMsY0FBYyxFQUFFLGFBQWEsS0FBSyxTQUFTLEVBQUU7WUFDcEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsRUFBRSxhQUFhLENBQUM7U0FDeEU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBdUU7UUFDOUYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxTQUFTLENBQUM7WUFDaEQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztZQUM1QyxJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO1lBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7WUFDbkMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztZQUNwQyxJQUFJLENBQUMsY0FBYyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7U0FDL0M7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyw4QkFBOEIsR0FBRyxLQUFLLENBQUMsNkJBQTZCLENBQUM7WUFDMUUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztZQUNsRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1lBQ3hELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7WUFDaEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztZQUNsRCxJQUFJLENBQUMsY0FBYyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1NBQ3pEO0lBQ0gsQ0FBQztJQUlELElBQVcsNkJBQTZCO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDbkUsQ0FBQztJQUNELElBQVcsNkJBQTZCLENBQUMsS0FBZTtRQUN0RCxJQUFJLENBQUMsOEJBQThCLEdBQUcsS0FBSyxDQUFDO0lBQzlDLENBQUM7SUFDTSxrQ0FBa0M7UUFDdkMsSUFBSSxDQUFDLDhCQUE4QixHQUFHLFNBQVMsQ0FBQztJQUNsRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0NBQWtDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLDhCQUE4QixDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQzlELENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQWU7UUFDbEQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7SUFDOUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFrQztRQUNoRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQWtDO1FBQzVELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsU0FBUyxDQUFDO0lBQ3JDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBa0M7UUFDN0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ00sZ0JBQWdCLENBQUMsS0FBOEY7UUFDcEgsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2hELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLGFBQWEsQ0FBQztJQUMzQyxDQUFDOztBQTVKSCxrSkE2SkM7OztBQVlELFNBQWdCLDJEQUEyRCxDQUFDLE1BQStJO0lBQ3pOLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVRELGtJQVNDO0FBRUQsTUFBYSwrREFBZ0UsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUl0Rzs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVJqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVM5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDN0I7UUFDRCxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUF1RjtRQUM5RyxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7U0FDMUI7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQzdCO0lBQ0gsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBOUVILDBJQStFQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLHdDQUF5QyxTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPbkYsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBc0Q7UUFDckcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxzREFBc0Q7WUFDN0UsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxRQUFRO2dCQUN0QixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUE2SEwsbUVBQW1FO1FBQzNELGtCQUFhLEdBQUcsSUFBSSxtRUFBbUUsQ0FBQyxJQUFJLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFldkgsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLCtEQUErRCxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztRQTdJeEcsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3ZELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7SUFDakQsQ0FBQztJQVFELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFlO1FBQ3RDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBZTtRQUNoQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFrQztRQUNsRCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBZTtRQUNoQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBZTtRQUM3QyxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDTSxlQUFlLENBQUMsS0FBMkQ7UUFDaEYsSUFBSSxDQUFDLGFBQWEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzNDLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQztJQUMxQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ00sV0FBVyxDQUFDLEtBQXVEO1FBQ3hFLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsRUFBRSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3JDLGNBQWMsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQ3JGLE9BQU8sRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ3hFLE1BQU0sRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztZQUM5QyxPQUFPLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUN4RSxzQkFBc0IsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDcEcsYUFBYSxFQUFFLCtEQUErRCxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDO1lBQ2hILFFBQVEsRUFBRSwyREFBMkQsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztTQUNwRyxDQUFDO0lBQ0osQ0FBQzs7QUE5TUgsNEZBK01DOzs7QUE3TUMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyx1REFBYyxHQUFHLHNEQUFzRCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvblxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25Db25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogVGhlIG5hbWUgb2YgdGhlIEFjY2VzcyBMZXZlbCB0byBhZGQgdGhpcyBjb25kaXRpb24gdG8uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uI2FjY2Vzc19sZXZlbCBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI2FjY2Vzc19sZXZlbH1cbiAgKi9cbiAgcmVhZG9ubHkgYWNjZXNzTGV2ZWw6IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uI2lkIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEEgbGlzdCBvZiBDSURSIGJsb2NrIElQIHN1Ym5ldHdvcmsgc3BlY2lmaWNhdGlvbi4gTWF5IGJlIElQdjRcbm9yIElQdjYuXG5Ob3RlIHRoYXQgZm9yIGEgQ0lEUiBJUCBhZGRyZXNzIGJsb2NrLCB0aGUgc3BlY2lmaWVkIElQIGFkZHJlc3NcbnBvcnRpb24gbXVzdCBiZSBwcm9wZXJseSB0cnVuY2F0ZWQgKGkuZS4gYWxsIHRoZSBob3N0IGJpdHMgbXVzdFxuYmUgemVybykgb3IgdGhlIGlucHV0IGlzIGNvbnNpZGVyZWQgbWFsZm9ybWVkLiBGb3IgZXhhbXBsZSxcblwiMTkyLjAuMi4wLzI0XCIgaXMgYWNjZXB0ZWQgYnV0IFwiMTkyLjAuMi4xLzI0XCIgaXMgbm90LiBTaW1pbGFybHksXG5mb3IgSVB2NiwgXCIyMDAxOmRiODo6LzMyXCIgaXMgYWNjZXB0ZWQgd2hlcmVhcyBcIjIwMDE6ZGI4OjoxLzMyXCJcbmlzIG5vdC4gVGhlIG9yaWdpbmF0aW5nIElQIG9mIGEgcmVxdWVzdCBtdXN0IGJlIGluIG9uZSBvZiB0aGVcbmxpc3RlZCBzdWJuZXRzIGluIG9yZGVyIGZvciB0aGlzIENvbmRpdGlvbiB0byBiZSB0cnVlLlxuSWYgZW1wdHksIGFsbCBJUCBhZGRyZXNzZXMgYXJlIGFsbG93ZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uI2lwX3N1Ym5ldHdvcmtzIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jaXBfc3VibmV0d29ya3N9XG4gICovXG4gIHJlYWRvbmx5IGlwU3VibmV0d29ya3M/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogQW4gYWxsb3dlZCBsaXN0IG9mIG1lbWJlcnMgKHVzZXJzLCBzZXJ2aWNlIGFjY291bnRzKS5cblVzaW5nIGdyb3VwcyBpcyBub3Qgc3VwcG9ydGVkIHlldC5cblxuVGhlIHNpZ25lZC1pbiB1c2VyIG9yaWdpbmF0aW5nIHRoZSByZXF1ZXN0IG11c3QgYmUgYSBwYXJ0IG9mIG9uZVxub2YgdGhlIHByb3ZpZGVkIG1lbWJlcnMuIElmIG5vdCBzcGVjaWZpZWQsIGEgcmVxdWVzdCBtYXkgY29tZVxuZnJvbSBhbnkgdXNlciAobG9nZ2VkIGluL25vdCBsb2dnZWQgaW4sIG5vdCBwcmVzZW50IGluIGFueVxuZ3JvdXBzLCBldGMuKS5cbkZvcm1hdHM6ICd1c2VyOntlbWFpbGlkfScsICdzZXJ2aWNlQWNjb3VudDp7ZW1haWxpZH0nXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uI21lbWJlcnMgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNtZW1iZXJzfVxuICAqL1xuICByZWFkb25seSBtZW1iZXJzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIFdoZXRoZXIgdG8gbmVnYXRlIHRoZSBDb25kaXRpb24uIElmIHRydWUsIHRoZSBDb25kaXRpb24gYmVjb21lc1xuYSBOQU5EIG92ZXIgaXRzIG5vbi1lbXB0eSBmaWVsZHMsIGVhY2ggZmllbGQgbXVzdCBiZSBmYWxzZSBmb3JcbnRoZSBDb25kaXRpb24gb3ZlcmFsbCB0byBiZSBzYXRpc2ZpZWQuIERlZmF1bHRzIHRvIGZhbHNlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNuZWdhdGUgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNuZWdhdGV9XG4gICovXG4gIHJlYWRvbmx5IG5lZ2F0ZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIHJlcXVlc3QgbXVzdCBvcmlnaW5hdGUgZnJvbSBvbmUgb2YgdGhlIHByb3ZpZGVkXG5jb3VudHJpZXMvcmVnaW9ucy5cbkZvcm1hdDogQSB2YWxpZCBJU08gMzE2Ni0xIGFscGhhLTIgY29kZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jcmVnaW9ucyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI3JlZ2lvbnN9XG4gICovXG4gIHJlYWRvbmx5IHJlZ2lvbnM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogQSBsaXN0IG9mIG90aGVyIGFjY2VzcyBsZXZlbHMgZGVmaW5lZCBpbiB0aGUgc2FtZSBQb2xpY3ksXG5yZWZlcmVuY2VkIGJ5IHJlc291cmNlIG5hbWUuIFJlZmVyZW5jaW5nIGFuIEFjY2Vzc0xldmVsIHdoaWNoXG5kb2VzIG5vdCBleGlzdCBpcyBhbiBlcnJvci4gQWxsIGFjY2VzcyBsZXZlbHMgbGlzdGVkIG11c3QgYmVcbmdyYW50ZWQgZm9yIHRoZSBDb25kaXRpb24gdG8gYmUgdHJ1ZS5cbkZvcm1hdDogYWNjZXNzUG9saWNpZXMve3BvbGljeV9pZH0vYWNjZXNzTGV2ZWxzL3tzaG9ydF9uYW1lfVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNyZXF1aXJlZF9hY2Nlc3NfbGV2ZWxzIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jcmVxdWlyZWRfYWNjZXNzX2xldmVsc31cbiAgKi9cbiAgcmVhZG9ubHkgcmVxdWlyZWRBY2Nlc3NMZXZlbHM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogZGV2aWNlX3BvbGljeSBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNkZXZpY2VfcG9saWN5IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jZGV2aWNlX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgZGV2aWNlUG9saWN5PzogQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeTtcbiAgLyoqXG4gICogdGltZW91dHMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jdGltZW91dHMgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiN0aW1lb3V0c31cbiAgKi9cbiAgcmVhZG9ubHkgdGltZW91dHM/OiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHM7XG59XG5leHBvcnQgaW50ZXJmYWNlIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPc0NvbnN0cmFpbnRzIHtcbiAgLyoqXG4gICogVGhlIG1pbmltdW0gYWxsb3dlZCBPUyB2ZXJzaW9uLiBJZiBub3Qgc2V0LCBhbnkgdmVyc2lvblxub2YgdGhpcyBPUyBzYXRpc2ZpZXMgdGhlIGNvbnN0cmFpbnQuXG5Gb3JtYXQ6IFwibWFqb3IubWlub3IucGF0Y2hcIiBzdWNoIGFzIFwiMTAuNS4zMDFcIiwgXCI5LjIuMVwiLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNtaW5pbXVtX3ZlcnNpb24gQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNtaW5pbXVtX3ZlcnNpb259XG4gICovXG4gIHJlYWRvbmx5IG1pbmltdW1WZXJzaW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgb3BlcmF0aW5nIHN5c3RlbSB0eXBlIG9mIHRoZSBkZXZpY2UuIFBvc3NpYmxlIHZhbHVlczogW1wiT1NfVU5TUEVDSUZJRURcIiwgXCJERVNLVE9QX01BQ1wiLCBcIkRFU0tUT1BfV0lORE9XU1wiLCBcIkRFU0tUT1BfTElOVVhcIiwgXCJERVNLVE9QX0NIUk9NRV9PU1wiLCBcIkFORFJPSURcIiwgXCJJT1NcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jb3NfdHlwZSBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI29zX3R5cGV9XG4gICovXG4gIHJlYWRvbmx5IG9zVHlwZTogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU9zQ29uc3RyYWludHNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5T3NDb25zdHJhaW50cyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIG1pbmltdW1fdmVyc2lvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5taW5pbXVtVmVyc2lvbiksXG4gICAgb3NfdHlwZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5vc1R5cGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5T3NDb25zdHJhaW50c091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgcHJpdmF0ZSByZXNvbHZhYmxlVmFsdWU/OiBjZGt0Zi5JUmVzb2x2YWJsZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKiBAcGFyYW0gY29tcGxleE9iamVjdEluZGV4IHRoZSBpbmRleCBvZiB0aGlzIGl0ZW0gaW4gdGhlIGxpc3RcbiAgKiBAcGFyYW0gY29tcGxleE9iamVjdElzRnJvbVNldCB3aGV0aGVyIHRoZSBsaXN0IGlzIHdyYXBwaW5nIGEgc2V0ICh3aWxsIGFkZCB0b2xpc3QoKSB0byBiZSBhYmxlIHRvIGFjY2VzcyBhbiBpdGVtIHZpYSBhbiBpbmRleClcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGNvbXBsZXhPYmplY3RJbmRleDogbnVtYmVyLCBjb21wbGV4T2JqZWN0SXNGcm9tU2V0OiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgY29tcGxleE9iamVjdElzRnJvbVNldCwgY29tcGxleE9iamVjdEluZGV4KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5T3NDb25zdHJhaW50cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAodGhpcy5yZXNvbHZhYmxlVmFsdWUpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlc29sdmFibGVWYWx1ZTtcbiAgICB9XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fbWluaW11bVZlcnNpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubWluaW11bVZlcnNpb24gPSB0aGlzLl9taW5pbXVtVmVyc2lvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX29zVHlwZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5vc1R5cGUgPSB0aGlzLl9vc1R5cGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5T3NDb25zdHJhaW50cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9taW5pbXVtVmVyc2lvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX29zVHlwZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSBpZiAoY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZSh2YWx1ZSkpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB2YWx1ZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9taW5pbXVtVmVyc2lvbiA9IHZhbHVlLm1pbmltdW1WZXJzaW9uO1xuICAgICAgdGhpcy5fb3NUeXBlID0gdmFsdWUub3NUeXBlO1xuICAgIH1cbiAgfVxuXG4gIC8vIG1pbmltdW1fdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9taW5pbXVtVmVyc2lvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbWluaW11bVZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtaW5pbXVtX3ZlcnNpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1pbmltdW1WZXJzaW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9taW5pbXVtVmVyc2lvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1pbmltdW1WZXJzaW9uKCkge1xuICAgIHRoaXMuX21pbmltdW1WZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtaW5pbXVtVmVyc2lvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9taW5pbXVtVmVyc2lvbjtcbiAgfVxuXG4gIC8vIG9zX3R5cGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfb3NUeXBlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBvc1R5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdvc190eXBlJyk7XG4gIH1cbiAgcHVibGljIHNldCBvc1R5cGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX29zVHlwZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBvc1R5cGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fb3NUeXBlO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5T3NDb25zdHJhaW50c0xpc3QgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4TGlzdCB7XG4gIHB1YmxpYyBpbnRlcm5hbFZhbHVlPyA6IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPc0NvbnN0cmFpbnRzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZVxuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqIEBwYXJhbSB3cmFwc1NldCB3aGV0aGVyIHRoZSBsaXN0IGlzIHdyYXBwaW5nIGEgc2V0ICh3aWxsIGFkZCB0b2xpc3QoKSB0byBiZSBhYmxlIHRvIGFjY2VzcyBhbiBpdGVtIHZpYSBhbiBpbmRleClcbiAgKi9cbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldClcbiAgfVxuXG4gIC8qKlxuICAqIEBwYXJhbSBpbmRleCB0aGUgaW5kZXggb2YgdGhlIGl0ZW0gdG8gcmV0dXJuXG4gICovXG4gIHB1YmxpYyBnZXQoaW5kZXg6IG51bWJlcik6IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPc0NvbnN0cmFpbnRzT3V0cHV0UmVmZXJlbmNlIHtcbiAgICByZXR1cm4gbmV3IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPc0NvbnN0cmFpbnRzT3V0cHV0UmVmZXJlbmNlKHRoaXMudGVycmFmb3JtUmVzb3VyY2UsIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLCBpbmRleCwgdGhpcy53cmFwc1NldCk7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeSB7XG4gIC8qKlxuICAqIEEgbGlzdCBvZiBhbGxvd2VkIGRldmljZSBtYW5hZ2VtZW50IGxldmVscy5cbkFuIGVtcHR5IGxpc3QgYWxsb3dzIGFsbCBtYW5hZ2VtZW50IGxldmVscy4gUG9zc2libGUgdmFsdWVzOiBbXCJNQU5BR0VNRU5UX1VOU1BFQ0lGSUVEXCIsIFwiTk9ORVwiLCBcIkJBU0lDXCIsIFwiQ09NUExFVEVcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jYWxsb3dlZF9kZXZpY2VfbWFuYWdlbWVudF9sZXZlbHMgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNhbGxvd2VkX2RldmljZV9tYW5hZ2VtZW50X2xldmVsc31cbiAgKi9cbiAgcmVhZG9ubHkgYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogQSBsaXN0IG9mIGFsbG93ZWQgZW5jcnlwdGlvbnMgc3RhdHVzZXMuXG5BbiBlbXB0eSBsaXN0IGFsbG93cyBhbGwgc3RhdHVzZXMuIFBvc3NpYmxlIHZhbHVlczogW1wiRU5DUllQVElPTl9VTlNQRUNJRklFRFwiLCBcIkVOQ1JZUFRJT05fVU5TVVBQT1JURURcIiwgXCJVTkVOQ1JZUFRFRFwiLCBcIkVOQ1JZUFRFRFwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNhbGxvd2VkX2VuY3J5cHRpb25fc3RhdHVzZXMgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNhbGxvd2VkX2VuY3J5cHRpb25fc3RhdHVzZXN9XG4gICovXG4gIHJlYWRvbmx5IGFsbG93ZWRFbmNyeXB0aW9uU3RhdHVzZXM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogV2hldGhlciB0aGUgZGV2aWNlIG5lZWRzIHRvIGJlIGFwcHJvdmVkIGJ5IHRoZSBjdXN0b21lciBhZG1pbi5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jcmVxdWlyZV9hZG1pbl9hcHByb3ZhbCBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI3JlcXVpcmVfYWRtaW5fYXBwcm92YWx9XG4gICovXG4gIHJlYWRvbmx5IHJlcXVpcmVBZG1pbkFwcHJvdmFsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGV0aGVyIHRoZSBkZXZpY2UgbmVlZHMgdG8gYmUgY29ycCBvd25lZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jcmVxdWlyZV9jb3JwX293bmVkIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jcmVxdWlyZV9jb3JwX293bmVkfVxuICAqL1xuICByZWFkb25seSByZXF1aXJlQ29ycE93bmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGV0aGVyIG9yIG5vdCBzY3JlZW5sb2NrIGlzIHJlcXVpcmVkIGZvciB0aGUgRGV2aWNlUG9saWN5XG50byBiZSB0cnVlLiBEZWZhdWx0cyB0byBmYWxzZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jcmVxdWlyZV9zY3JlZW5fbG9jayBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI3JlcXVpcmVfc2NyZWVuX2xvY2t9XG4gICovXG4gIHJlYWRvbmx5IHJlcXVpcmVTY3JlZW5Mb2NrPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBvc19jb25zdHJhaW50cyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNvc19jb25zdHJhaW50cyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uI29zX2NvbnN0cmFpbnRzfVxuICAqL1xuICByZWFkb25seSBvc0NvbnN0cmFpbnRzPzogQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU9zQ29uc3RyYWludHNbXSB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uRGV2aWNlUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGFsbG93ZWRfZGV2aWNlX21hbmFnZW1lbnRfbGV2ZWxzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5hbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscyksXG4gICAgYWxsb3dlZF9lbmNyeXB0aW9uX3N0YXR1c2VzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5hbGxvd2VkRW5jcnlwdGlvblN0YXR1c2VzKSxcbiAgICByZXF1aXJlX2FkbWluX2FwcHJvdmFsOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yZXF1aXJlQWRtaW5BcHByb3ZhbCksXG4gICAgcmVxdWlyZV9jb3JwX293bmVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yZXF1aXJlQ29ycE93bmVkKSxcbiAgICByZXF1aXJlX3NjcmVlbl9sb2NrOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yZXF1aXJlU2NyZWVuTG9jayksXG4gICAgb3NfY29uc3RyYWludHM6IGNka3RmLmxpc3RNYXBwZXIoYWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU9zQ29uc3RyYWludHNUb1RlcnJhZm9ybSwgdHJ1ZSkoc3RydWN0IS5vc0NvbnN0cmFpbnRzKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeSB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHMgPSB0aGlzLl9hbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscztcbiAgICB9XG4gICAgaWYgKHRoaXMuX2FsbG93ZWRFbmNyeXB0aW9uU3RhdHVzZXMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcyA9IHRoaXMuX2FsbG93ZWRFbmNyeXB0aW9uU3RhdHVzZXM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yZXF1aXJlQWRtaW5BcHByb3ZhbCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yZXF1aXJlQWRtaW5BcHByb3ZhbCA9IHRoaXMuX3JlcXVpcmVBZG1pbkFwcHJvdmFsO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVxdWlyZUNvcnBPd25lZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yZXF1aXJlQ29ycE93bmVkID0gdGhpcy5fcmVxdWlyZUNvcnBPd25lZDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3JlcXVpcmVTY3JlZW5Mb2NrICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlcXVpcmVTY3JlZW5Mb2NrID0gdGhpcy5fcmVxdWlyZVNjcmVlbkxvY2s7XG4gICAgfVxuICAgIGlmICh0aGlzLl9vc0NvbnN0cmFpbnRzPy5pbnRlcm5hbFZhbHVlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lm9zQ29uc3RyYWludHMgPSB0aGlzLl9vc0NvbnN0cmFpbnRzPy5pbnRlcm5hbFZhbHVlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2FsbG93ZWREZXZpY2VNYW5hZ2VtZW50TGV2ZWxzID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlcXVpcmVBZG1pbkFwcHJvdmFsID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcmVxdWlyZUNvcnBPd25lZCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlcXVpcmVTY3JlZW5Mb2NrID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fb3NDb25zdHJhaW50cy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9hbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscyA9IHZhbHVlLmFsbG93ZWREZXZpY2VNYW5hZ2VtZW50TGV2ZWxzO1xuICAgICAgdGhpcy5fYWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcyA9IHZhbHVlLmFsbG93ZWRFbmNyeXB0aW9uU3RhdHVzZXM7XG4gICAgICB0aGlzLl9yZXF1aXJlQWRtaW5BcHByb3ZhbCA9IHZhbHVlLnJlcXVpcmVBZG1pbkFwcHJvdmFsO1xuICAgICAgdGhpcy5fcmVxdWlyZUNvcnBPd25lZCA9IHZhbHVlLnJlcXVpcmVDb3JwT3duZWQ7XG4gICAgICB0aGlzLl9yZXF1aXJlU2NyZWVuTG9jayA9IHZhbHVlLnJlcXVpcmVTY3JlZW5Mb2NrO1xuICAgICAgdGhpcy5fb3NDb25zdHJhaW50cy5pbnRlcm5hbFZhbHVlID0gdmFsdWUub3NDb25zdHJhaW50cztcbiAgICB9XG4gIH1cblxuICAvLyBhbGxvd2VkX2RldmljZV9tYW5hZ2VtZW50X2xldmVscyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBhbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRMaXN0QXR0cmlidXRlKCdhbGxvd2VkX2RldmljZV9tYW5hZ2VtZW50X2xldmVscycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscygpIHtcbiAgICB0aGlzLl9hbGxvd2VkRGV2aWNlTWFuYWdlbWVudExldmVscyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxsb3dlZERldmljZU1hbmFnZW1lbnRMZXZlbHM7XG4gIH1cblxuICAvLyBhbGxvd2VkX2VuY3J5cHRpb25fc3RhdHVzZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBhbGxvd2VkRW5jcnlwdGlvblN0YXR1c2VzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2FsbG93ZWRfZW5jcnlwdGlvbl9zdGF0dXNlcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9hbGxvd2VkRW5jcnlwdGlvblN0YXR1c2VzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWxsb3dlZEVuY3J5cHRpb25TdGF0dXNlcygpIHtcbiAgICB0aGlzLl9hbGxvd2VkRW5jcnlwdGlvblN0YXR1c2VzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhbGxvd2VkRW5jcnlwdGlvblN0YXR1c2VzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FsbG93ZWRFbmNyeXB0aW9uU3RhdHVzZXM7XG4gIH1cblxuICAvLyByZXF1aXJlX2FkbWluX2FwcHJvdmFsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVpcmVBZG1pbkFwcHJvdmFsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCByZXF1aXJlQWRtaW5BcHByb3ZhbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdyZXF1aXJlX2FkbWluX2FwcHJvdmFsJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXF1aXJlQWRtaW5BcHByb3ZhbCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcmVxdWlyZUFkbWluQXBwcm92YWwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXF1aXJlQWRtaW5BcHByb3ZhbCgpIHtcbiAgICB0aGlzLl9yZXF1aXJlQWRtaW5BcHByb3ZhbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVxdWlyZUFkbWluQXBwcm92YWxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWlyZUFkbWluQXBwcm92YWw7XG4gIH1cblxuICAvLyByZXF1aXJlX2NvcnBfb3duZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWlyZUNvcnBPd25lZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcmVxdWlyZUNvcnBPd25lZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdyZXF1aXJlX2NvcnBfb3duZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcXVpcmVDb3JwT3duZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3JlcXVpcmVDb3JwT3duZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXF1aXJlQ29ycE93bmVkKCkge1xuICAgIHRoaXMuX3JlcXVpcmVDb3JwT3duZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVpcmVDb3JwT3duZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWlyZUNvcnBPd25lZDtcbiAgfVxuXG4gIC8vIHJlcXVpcmVfc2NyZWVuX2xvY2sgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWlyZVNjcmVlbkxvY2s/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHJlcXVpcmVTY3JlZW5Mb2NrKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3JlcXVpcmVfc2NyZWVuX2xvY2snKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcXVpcmVTY3JlZW5Mb2NrKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9yZXF1aXJlU2NyZWVuTG9jayA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlcXVpcmVTY3JlZW5Mb2NrKCkge1xuICAgIHRoaXMuX3JlcXVpcmVTY3JlZW5Mb2NrID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXF1aXJlU2NyZWVuTG9ja0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXF1aXJlU2NyZWVuTG9jaztcbiAgfVxuXG4gIC8vIG9zX2NvbnN0cmFpbnRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX29zQ29uc3RyYWludHMgPSBuZXcgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU9zQ29uc3RyYWludHNMaXN0KHRoaXMsIFwib3NfY29uc3RyYWludHNcIiwgZmFsc2UpO1xuICBwdWJsaWMgZ2V0IG9zQ29uc3RyYWludHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29zQ29uc3RyYWludHM7XG4gIH1cbiAgcHVibGljIHB1dE9zQ29uc3RyYWludHModmFsdWU6IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25EZXZpY2VQb2xpY3lPc0NvbnN0cmFpbnRzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX29zQ29uc3RyYWludHMuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE9zQ29uc3RyYWludHMoKSB7XG4gICAgdGhpcy5fb3NDb25zdHJhaW50cy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBvc0NvbnN0cmFpbnRzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29zQ29uc3RyYWludHMuaW50ZXJuYWxWYWx1ZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHMge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24jY3JlYXRlIEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb24jY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBjcmVhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbiNkZWxldGUgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiNkZWxldGV9XG4gICovXG4gIHJlYWRvbmx5IGRlbGV0ZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25UaW1lb3V0c1RvVGVycmFmb3JtKHN0cnVjdD86IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25UaW1lb3V0c091dHB1dFJlZmVyZW5jZSB8IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25UaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNyZWF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5jcmVhdGUpLFxuICAgIGRlbGV0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gIHByaXZhdGUgcmVzb2x2YWJsZVZhbHVlPzogY2RrdGYuSVJlc29sdmFibGU7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEFjY2Vzc0NvbnRleHRNYW5hZ2VyQWNjZXNzTGV2ZWxDb25kaXRpb25UaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAodGhpcy5yZXNvbHZhYmxlVmFsdWUpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlc29sdmFibGVWYWx1ZTtcbiAgICB9XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY3JlYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNyZWF0ZSA9IHRoaXMuX2NyZWF0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGUgPSB0aGlzLl9kZWxldGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsZXRlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIGlmIChjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHZhbHVlKSkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLnJlc29sdmFibGVWYWx1ZSA9IHZhbHVlO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLnJlc29sdmFibGVWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHZhbHVlLmNyZWF0ZTtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlLmRlbGV0ZTtcbiAgICB9XG4gIH1cblxuICAvLyBjcmVhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3JlYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjcmVhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjcmVhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNyZWF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3JlYXRlKCkge1xuICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY3JlYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NyZWF0ZTtcbiAgfVxuXG4gIC8vIGRlbGV0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWxldGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RlbGV0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGUoKSB7XG4gICAgdGhpcy5fZGVsZXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlO1xuICB9XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24gZ29vZ2xlX2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbn1cbiovXG5leHBvcnQgY2xhc3MgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbiBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJnb29nbGVfYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9hY2Nlc3NfY29udGV4dF9tYW5hZ2VyX2FjY2Vzc19sZXZlbF9jb25kaXRpb24gZ29vZ2xlX2FjY2Vzc19jb250ZXh0X21hbmFnZXJfYWNjZXNzX2xldmVsX2NvbmRpdGlvbn0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkNvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdnb29nbGVfYWNjZXNzX2NvbnRleHRfbWFuYWdlcl9hY2Nlc3NfbGV2ZWxfY29uZGl0aW9uJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2dvb2dsZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzQuMzguMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiA0LjAnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGUsXG4gICAgICBwcm92aXNpb25lcnM6IGNvbmZpZy5wcm92aXNpb25lcnMsXG4gICAgICBjb25uZWN0aW9uOiBjb25maWcuY29ubmVjdGlvbixcbiAgICAgIGZvckVhY2g6IGNvbmZpZy5mb3JFYWNoXG4gICAgfSk7XG4gICAgdGhpcy5fYWNjZXNzTGV2ZWwgPSBjb25maWcuYWNjZXNzTGV2ZWw7XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5faXBTdWJuZXR3b3JrcyA9IGNvbmZpZy5pcFN1Ym5ldHdvcmtzO1xuICAgIHRoaXMuX21lbWJlcnMgPSBjb25maWcubWVtYmVycztcbiAgICB0aGlzLl9uZWdhdGUgPSBjb25maWcubmVnYXRlO1xuICAgIHRoaXMuX3JlZ2lvbnMgPSBjb25maWcucmVnaW9ucztcbiAgICB0aGlzLl9yZXF1aXJlZEFjY2Vzc0xldmVscyA9IGNvbmZpZy5yZXF1aXJlZEFjY2Vzc0xldmVscztcbiAgICB0aGlzLl9kZXZpY2VQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5kZXZpY2VQb2xpY3k7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy50aW1lb3V0cztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWNjZXNzX2xldmVsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2FjY2Vzc0xldmVsPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhY2Nlc3NMZXZlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FjY2Vzc19sZXZlbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWNjZXNzTGV2ZWwodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2FjY2Vzc0xldmVsID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFjY2Vzc0xldmVsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjY2Vzc0xldmVsO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gaXBfc3VibmV0d29ya3MgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaXBTdWJuZXR3b3Jrcz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBpcFN1Ym5ldHdvcmtzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2lwX3N1Ym5ldHdvcmtzJyk7XG4gIH1cbiAgcHVibGljIHNldCBpcFN1Ym5ldHdvcmtzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX2lwU3VibmV0d29ya3MgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJcFN1Ym5ldHdvcmtzKCkge1xuICAgIHRoaXMuX2lwU3VibmV0d29ya3MgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlwU3VibmV0d29ya3NJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faXBTdWJuZXR3b3JrcztcbiAgfVxuXG4gIC8vIG1lbWJlcnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWVtYmVycz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBtZW1iZXJzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ21lbWJlcnMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1lbWJlcnModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fbWVtYmVycyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1lbWJlcnMoKSB7XG4gICAgdGhpcy5fbWVtYmVycyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWVtYmVyc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tZW1iZXJzO1xuICB9XG5cbiAgLy8gbmVnYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX25lZ2F0ZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgbmVnYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ25lZ2F0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmVnYXRlKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9uZWdhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXROZWdhdGUoKSB7XG4gICAgdGhpcy5fbmVnYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuZWdhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmVnYXRlO1xuICB9XG5cbiAgLy8gcmVnaW9ucyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZWdpb25zPzogc3RyaW5nW107IFxuICBwdWJsaWMgZ2V0IHJlZ2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgncmVnaW9ucycpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVnaW9ucyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9yZWdpb25zID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVnaW9ucygpIHtcbiAgICB0aGlzLl9yZWdpb25zID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZWdpb25zSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlZ2lvbnM7XG4gIH1cblxuICAvLyByZXF1aXJlZF9hY2Nlc3NfbGV2ZWxzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVpcmVkQWNjZXNzTGV2ZWxzPzogc3RyaW5nW107IFxuICBwdWJsaWMgZ2V0IHJlcXVpcmVkQWNjZXNzTGV2ZWxzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3JlcXVpcmVkX2FjY2Vzc19sZXZlbHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcXVpcmVkQWNjZXNzTGV2ZWxzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3JlcXVpcmVkQWNjZXNzTGV2ZWxzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVxdWlyZWRBY2Nlc3NMZXZlbHMoKSB7XG4gICAgdGhpcy5fcmVxdWlyZWRBY2Nlc3NMZXZlbHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVpcmVkQWNjZXNzTGV2ZWxzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVpcmVkQWNjZXNzTGV2ZWxzO1xuICB9XG5cbiAgLy8gZGV2aWNlX3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXZpY2VQb2xpY3kgPSBuZXcgQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcImRldmljZV9wb2xpY3lcIik7XG4gIHB1YmxpYyBnZXQgZGV2aWNlUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLl9kZXZpY2VQb2xpY3k7XG4gIH1cbiAgcHVibGljIHB1dERldmljZVBvbGljeSh2YWx1ZTogQWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeSkge1xuICAgIHRoaXMuX2RldmljZVBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGV2aWNlUG9saWN5KCkge1xuICAgIHRoaXMuX2RldmljZVBvbGljeS5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZXZpY2VQb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGV2aWNlUG9saWN5LmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyB0aW1lb3V0cyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aW1lb3V0cyA9IG5ldyBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ0aW1lb3V0c1wiKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBBY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHMpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGltZW91dHMoKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGltZW91dHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWNjZXNzX2xldmVsOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9hY2Nlc3NMZXZlbCksXG4gICAgICBpZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgaXBfc3VibmV0d29ya3M6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl9pcFN1Ym5ldHdvcmtzKSxcbiAgICAgIG1lbWJlcnM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl9tZW1iZXJzKSxcbiAgICAgIG5lZ2F0ZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX25lZ2F0ZSksXG4gICAgICByZWdpb25zOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fcmVnaW9ucyksXG4gICAgICByZXF1aXJlZF9hY2Nlc3NfbGV2ZWxzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fcmVxdWlyZWRBY2Nlc3NMZXZlbHMpLFxuICAgICAgZGV2aWNlX3BvbGljeTogYWNjZXNzQ29udGV4dE1hbmFnZXJBY2Nlc3NMZXZlbENvbmRpdGlvbkRldmljZVBvbGljeVRvVGVycmFmb3JtKHRoaXMuX2RldmljZVBvbGljeS5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIHRpbWVvdXRzOiBhY2Nlc3NDb250ZXh0TWFuYWdlckFjY2Vzc0xldmVsQ29uZGl0aW9uVGltZW91dHNUb1RlcnJhZm9ybSh0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=