import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeNatAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#id ApigeeNatAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Apigee instance associated with the Apigee environment,
  in the format 'organizations/{{org_name}}/instances/{{instance_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#instance_id ApigeeNatAddress#instance_id}
    */
    readonly instanceId: string;
    /**
    * Resource ID of the NAT address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#name ApigeeNatAddress#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#timeouts ApigeeNatAddress#timeouts}
    */
    readonly timeouts?: ApigeeNatAddressTimeouts;
}
export interface ApigeeNatAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#create ApigeeNatAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address#delete ApigeeNatAddress#delete}
    */
    readonly delete?: string;
}
export declare function apigeeNatAddressTimeoutsToTerraform(struct?: ApigeeNatAddressTimeoutsOutputReference | ApigeeNatAddressTimeouts | cdktf.IResolvable): any;
export declare class ApigeeNatAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeNatAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeNatAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address google_apigee_nat_address}
*/
export declare class ApigeeNatAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_nat_address";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_nat_address google_apigee_nat_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeNatAddressConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeNatAddressConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get ipAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): ApigeeNatAddressTimeoutsOutputReference;
    putTimeouts(value: ApigeeNatAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeNatAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
