import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineServiceNetworkSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#id AppEngineServiceNetworkSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#project AppEngineServiceNetworkSettings#project}
    */
    readonly project?: string;
    /**
    * The name of the service these settings apply to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#service AppEngineServiceNetworkSettings#service}
    */
    readonly service: string;
    /**
    * network_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#network_settings AppEngineServiceNetworkSettings#network_settings}
    */
    readonly networkSettings: AppEngineServiceNetworkSettingsNetworkSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#timeouts AppEngineServiceNetworkSettings#timeouts}
    */
    readonly timeouts?: AppEngineServiceNetworkSettingsTimeouts;
}
export interface AppEngineServiceNetworkSettingsNetworkSettings {
    /**
    * The ingress settings for version or service. Default value: "INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED" Possible values: ["INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED", "INGRESS_TRAFFIC_ALLOWED_ALL", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#ingress_traffic_allowed AppEngineServiceNetworkSettings#ingress_traffic_allowed}
    */
    readonly ingressTrafficAllowed?: string;
}
export declare function appEngineServiceNetworkSettingsNetworkSettingsToTerraform(struct?: AppEngineServiceNetworkSettingsNetworkSettingsOutputReference | AppEngineServiceNetworkSettingsNetworkSettings): any;
export declare class AppEngineServiceNetworkSettingsNetworkSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineServiceNetworkSettingsNetworkSettings | undefined;
    set internalValue(value: AppEngineServiceNetworkSettingsNetworkSettings | undefined);
    private _ingressTrafficAllowed?;
    get ingressTrafficAllowed(): string;
    set ingressTrafficAllowed(value: string);
    resetIngressTrafficAllowed(): void;
    get ingressTrafficAllowedInput(): string | undefined;
}
export interface AppEngineServiceNetworkSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#create AppEngineServiceNetworkSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#delete AppEngineServiceNetworkSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings#update AppEngineServiceNetworkSettings#update}
    */
    readonly update?: string;
}
export declare function appEngineServiceNetworkSettingsTimeoutsToTerraform(struct?: AppEngineServiceNetworkSettingsTimeoutsOutputReference | AppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable): any;
export declare class AppEngineServiceNetworkSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppEngineServiceNetworkSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings google_app_engine_service_network_settings}
*/
export declare class AppEngineServiceNetworkSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_service_network_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings google_app_engine_service_network_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppEngineServiceNetworkSettingsConfig
    */
    constructor(scope: Construct, id: string, config: AppEngineServiceNetworkSettingsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _networkSettings;
    get networkSettings(): AppEngineServiceNetworkSettingsNetworkSettingsOutputReference;
    putNetworkSettings(value: AppEngineServiceNetworkSettingsNetworkSettings): void;
    get networkSettingsInput(): AppEngineServiceNetworkSettingsNetworkSettings | undefined;
    private _timeouts;
    get timeouts(): AppEngineServiceNetworkSettingsTimeoutsOutputReference;
    putTimeouts(value: AppEngineServiceNetworkSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppEngineServiceNetworkSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
