import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional connection id that should be assigned to the created connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#connection_id BigqueryConnection#connection_id}
    */
    readonly connectionId?: string;
    /**
    * A descriptive description for the connection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#description BigqueryConnection#description}
    */
    readonly description?: string;
    /**
    * A descriptive name for the connection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#friendly_name BigqueryConnection#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#id BigqueryConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the connection should reside.
  Cloud SQL instance must be in the same location as the connection
  with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
  Examples: US, EU, asia-northeast1, us-central1, europe-west1.
  Spanner Connections same as spanner region
  AWS allowed regions are aws-us-east-1
  Azure allowed regions are azure-eastus2
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#location BigqueryConnection#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#project BigqueryConnection#project}
    */
    readonly project?: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#aws BigqueryConnection#aws}
    */
    readonly aws?: BigqueryConnectionAws;
    /**
    * azure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#azure BigqueryConnection#azure}
    */
    readonly azure?: BigqueryConnectionAzure;
    /**
    * cloud_resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#cloud_resource BigqueryConnection#cloud_resource}
    */
    readonly cloudResource?: BigqueryConnectionCloudResource;
    /**
    * cloud_spanner block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#cloud_spanner BigqueryConnection#cloud_spanner}
    */
    readonly cloudSpanner?: BigqueryConnectionCloudSpanner;
    /**
    * cloud_sql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#cloud_sql BigqueryConnection#cloud_sql}
    */
    readonly cloudSql?: BigqueryConnectionCloudSql;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#timeouts BigqueryConnection#timeouts}
    */
    readonly timeouts?: BigqueryConnectionTimeouts;
}
export interface BigqueryConnectionAwsAccessRole {
    /**
    * The user’s AWS IAM Role that trusts the Google-owned AWS IAM user Connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#iam_role_id BigqueryConnection#iam_role_id}
    */
    readonly iamRoleId: string;
}
export declare function bigqueryConnectionAwsAccessRoleToTerraform(struct?: BigqueryConnectionAwsAccessRoleOutputReference | BigqueryConnectionAwsAccessRole): any;
export declare class BigqueryConnectionAwsAccessRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionAwsAccessRole | undefined;
    set internalValue(value: BigqueryConnectionAwsAccessRole | undefined);
    private _iamRoleId?;
    get iamRoleId(): string;
    set iamRoleId(value: string);
    get iamRoleIdInput(): string | undefined;
    get identity(): string;
}
export interface BigqueryConnectionAws {
    /**
    * access_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#access_role BigqueryConnection#access_role}
    */
    readonly accessRole: BigqueryConnectionAwsAccessRole;
}
export declare function bigqueryConnectionAwsToTerraform(struct?: BigqueryConnectionAwsOutputReference | BigqueryConnectionAws): any;
export declare class BigqueryConnectionAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionAws | undefined;
    set internalValue(value: BigqueryConnectionAws | undefined);
    private _accessRole;
    get accessRole(): BigqueryConnectionAwsAccessRoleOutputReference;
    putAccessRole(value: BigqueryConnectionAwsAccessRole): void;
    get accessRoleInput(): BigqueryConnectionAwsAccessRole | undefined;
}
export interface BigqueryConnectionAzure {
    /**
    * The id of customer's directory that host the data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#customer_tenant_id BigqueryConnection#customer_tenant_id}
    */
    readonly customerTenantId: string;
}
export declare function bigqueryConnectionAzureToTerraform(struct?: BigqueryConnectionAzureOutputReference | BigqueryConnectionAzure): any;
export declare class BigqueryConnectionAzureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionAzure | undefined;
    set internalValue(value: BigqueryConnectionAzure | undefined);
    get application(): string;
    get clientId(): string;
    private _customerTenantId?;
    get customerTenantId(): string;
    set customerTenantId(value: string);
    get customerTenantIdInput(): string | undefined;
    get objectId(): string;
    get redirectUri(): string;
}
export interface BigqueryConnectionCloudResource {
}
export declare function bigqueryConnectionCloudResourceToTerraform(struct?: BigqueryConnectionCloudResourceOutputReference | BigqueryConnectionCloudResource): any;
export declare class BigqueryConnectionCloudResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionCloudResource | undefined;
    set internalValue(value: BigqueryConnectionCloudResource | undefined);
    get serviceAccountId(): string;
}
export interface BigqueryConnectionCloudSpanner {
    /**
    * Cloud Spanner database in the form 'project/instance/database'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#database BigqueryConnection#database}
    */
    readonly database: string;
    /**
    * If parallelism should be used when reading from Cloud Spanner
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#use_parallelism BigqueryConnection#use_parallelism}
    */
    readonly useParallelism?: boolean | cdktf.IResolvable;
}
export declare function bigqueryConnectionCloudSpannerToTerraform(struct?: BigqueryConnectionCloudSpannerOutputReference | BigqueryConnectionCloudSpanner): any;
export declare class BigqueryConnectionCloudSpannerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionCloudSpanner | undefined;
    set internalValue(value: BigqueryConnectionCloudSpanner | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _useParallelism?;
    get useParallelism(): boolean | cdktf.IResolvable;
    set useParallelism(value: boolean | cdktf.IResolvable);
    resetUseParallelism(): void;
    get useParallelismInput(): boolean | cdktf.IResolvable | undefined;
}
export interface BigqueryConnectionCloudSqlCredential {
    /**
    * Password for database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#password BigqueryConnection#password}
    */
    readonly password: string;
    /**
    * Username for database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#username BigqueryConnection#username}
    */
    readonly username: string;
}
export declare function bigqueryConnectionCloudSqlCredentialToTerraform(struct?: BigqueryConnectionCloudSqlCredentialOutputReference | BigqueryConnectionCloudSqlCredential): any;
export declare class BigqueryConnectionCloudSqlCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionCloudSqlCredential | undefined;
    set internalValue(value: BigqueryConnectionCloudSqlCredential | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface BigqueryConnectionCloudSql {
    /**
    * Database name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#database BigqueryConnection#database}
    */
    readonly database: string;
    /**
    * Cloud SQL instance ID in the form project:location:instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#instance_id BigqueryConnection#instance_id}
    */
    readonly instanceId: string;
    /**
    * Type of the Cloud SQL database. Possible values: ["DATABASE_TYPE_UNSPECIFIED", "POSTGRES", "MYSQL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#type BigqueryConnection#type}
    */
    readonly type: string;
    /**
    * credential block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#credential BigqueryConnection#credential}
    */
    readonly credential: BigqueryConnectionCloudSqlCredential;
}
export declare function bigqueryConnectionCloudSqlToTerraform(struct?: BigqueryConnectionCloudSqlOutputReference | BigqueryConnectionCloudSql): any;
export declare class BigqueryConnectionCloudSqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionCloudSql | undefined;
    set internalValue(value: BigqueryConnectionCloudSql | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _credential;
    get credential(): BigqueryConnectionCloudSqlCredentialOutputReference;
    putCredential(value: BigqueryConnectionCloudSqlCredential): void;
    get credentialInput(): BigqueryConnectionCloudSqlCredential | undefined;
}
export interface BigqueryConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#create BigqueryConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#delete BigqueryConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection#update BigqueryConnection#update}
    */
    readonly update?: string;
}
export declare function bigqueryConnectionTimeoutsToTerraform(struct?: BigqueryConnectionTimeoutsOutputReference | BigqueryConnectionTimeouts | cdktf.IResolvable): any;
export declare class BigqueryConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BigqueryConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection google_bigquery_connection}
*/
export declare class BigqueryConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_connection google_bigquery_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryConnectionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: BigqueryConnectionConfig);
    private _connectionId?;
    get connectionId(): string;
    set connectionId(value: string);
    resetConnectionId(): void;
    get connectionIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    get hasCredential(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _aws;
    get aws(): BigqueryConnectionAwsOutputReference;
    putAws(value: BigqueryConnectionAws): void;
    resetAws(): void;
    get awsInput(): BigqueryConnectionAws | undefined;
    private _azure;
    get azure(): BigqueryConnectionAzureOutputReference;
    putAzure(value: BigqueryConnectionAzure): void;
    resetAzure(): void;
    get azureInput(): BigqueryConnectionAzure | undefined;
    private _cloudResource;
    get cloudResource(): BigqueryConnectionCloudResourceOutputReference;
    putCloudResource(value: BigqueryConnectionCloudResource): void;
    resetCloudResource(): void;
    get cloudResourceInput(): BigqueryConnectionCloudResource | undefined;
    private _cloudSpanner;
    get cloudSpanner(): BigqueryConnectionCloudSpannerOutputReference;
    putCloudSpanner(value: BigqueryConnectionCloudSpanner): void;
    resetCloudSpanner(): void;
    get cloudSpannerInput(): BigqueryConnectionCloudSpanner | undefined;
    private _cloudSql;
    get cloudSql(): BigqueryConnectionCloudSqlOutputReference;
    putCloudSql(value: BigqueryConnectionCloudSql): void;
    resetCloudSql(): void;
    get cloudSqlInput(): BigqueryConnectionCloudSql | undefined;
    private _timeouts;
    get timeouts(): BigqueryConnectionTimeoutsOutputReference;
    putTimeouts(value: BigqueryConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BigqueryConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
