import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceFromTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires stopping the instance without setting this field, the update will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#allow_stopping_for_update ComputeInstanceFromTemplate#allow_stopping_for_update}
    */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
    * List of disks attached to the instance
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#attached_disk ComputeInstanceFromTemplate#attached_disk}
    */
    readonly attachedDisk?: ComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable;
    /**
    * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#can_ip_forward ComputeInstanceFromTemplate#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Whether deletion protection is enabled on this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#deletion_protection ComputeInstanceFromTemplate#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * A brief description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#description ComputeInstanceFromTemplate#description}
    */
    readonly description?: string;
    /**
    * Desired status of the instance. Either "RUNNING" or "TERMINATED".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#desired_status ComputeInstanceFromTemplate#desired_status}
    */
    readonly desiredStatus?: string;
    /**
    * Whether the instance has virtual displays enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_display ComputeInstanceFromTemplate#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#guest_accelerator ComputeInstanceFromTemplate#guest_accelerator}
    */
    readonly guestAccelerator?: ComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#hostname ComputeInstanceFromTemplate#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#id ComputeInstanceFromTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#labels ComputeInstanceFromTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#machine_type ComputeInstanceFromTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Metadata key/value pairs made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#metadata ComputeInstanceFromTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Metadata startup scripts made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#metadata_startup_script ComputeInstanceFromTemplate#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * The minimum CPU platform specified for the VM instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#min_cpu_platform ComputeInstanceFromTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#name ComputeInstanceFromTemplate#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#project ComputeInstanceFromTemplate#project}
    */
    readonly project?: string;
    /**
    * A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#resource_policies ComputeInstanceFromTemplate#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The scratch disks attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#scratch_disk ComputeInstanceFromTemplate#scratch_disk}
    */
    readonly scratchDisk?: ComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable;
    /**
    * The service account to attach to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#service_account ComputeInstanceFromTemplate#service_account}
    */
    readonly serviceAccount?: ComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable;
    /**
    * Name or self link of an instance template to create the instance based on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#source_instance_template ComputeInstanceFromTemplate#source_instance_template}
    */
    readonly sourceInstanceTemplate: string;
    /**
    * The list of tags attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#tags ComputeInstanceFromTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#zone ComputeInstanceFromTemplate#zone}
    */
    readonly zone?: string;
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#advanced_machine_features ComputeInstanceFromTemplate#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: ComputeInstanceFromTemplateAdvancedMachineFeatures;
    /**
    * boot_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#boot_disk ComputeInstanceFromTemplate#boot_disk}
    */
    readonly bootDisk?: ComputeInstanceFromTemplateBootDisk;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#confidential_instance_config ComputeInstanceFromTemplate#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: ComputeInstanceFromTemplateConfidentialInstanceConfig;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#network_interface ComputeInstanceFromTemplate#network_interface}
    */
    readonly networkInterface?: ComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#reservation_affinity ComputeInstanceFromTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: ComputeInstanceFromTemplateReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#scheduling ComputeInstanceFromTemplate#scheduling}
    */
    readonly scheduling?: ComputeInstanceFromTemplateScheduling;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#shielded_instance_config ComputeInstanceFromTemplate#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ComputeInstanceFromTemplateShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#timeouts ComputeInstanceFromTemplate#timeouts}
    */
    readonly timeouts?: ComputeInstanceFromTemplateTimeouts;
}
export interface ComputeInstanceFromTemplateAttachedDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#device_name ComputeInstanceFromTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#disk_encryption_key_sha256 ComputeInstanceFromTemplate#disk_encryption_key_sha256}
    */
    readonly diskEncryptionKeySha256?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#mode ComputeInstanceFromTemplate#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#source ComputeInstanceFromTemplate#source}
    */
    readonly source?: string;
}
export declare function computeInstanceFromTemplateAttachedDiskToTerraform(struct?: ComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateAttachedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    private _diskEncryptionKeySha256?;
    get diskEncryptionKeySha256(): string;
    set diskEncryptionKeySha256(value: string);
    resetDiskEncryptionKeySha256(): void;
    get diskEncryptionKeySha256Input(): string | undefined;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateAttachedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateAttachedDiskOutputReference;
}
export interface ComputeInstanceFromTemplateGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#count ComputeInstanceFromTemplate#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#type ComputeInstanceFromTemplate#type}
    */
    readonly type?: string;
}
export declare function computeInstanceFromTemplateGuestAcceleratorToTerraform(struct?: ComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateGuestAcceleratorOutputReference;
}
export interface ComputeInstanceFromTemplateScratchDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#interface ComputeInstanceFromTemplate#interface}
    */
    readonly interface?: string;
}
export declare function computeInstanceFromTemplateScratchDiskToTerraform(struct?: ComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateScratchDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable | undefined);
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateScratchDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateScratchDiskOutputReference;
}
export interface ComputeInstanceFromTemplateServiceAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#email ComputeInstanceFromTemplate#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#scopes ComputeInstanceFromTemplate#scopes}
    */
    readonly scopes?: string[];
}
export declare function computeInstanceFromTemplateServiceAccountToTerraform(struct?: ComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
}
export declare class ComputeInstanceFromTemplateServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateServiceAccountOutputReference;
}
export interface ComputeInstanceFromTemplateAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_nested_virtualization ComputeInstanceFromTemplate#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#threads_per_core ComputeInstanceFromTemplate#threads_per_core}
    */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceFromTemplateAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference | ComputeInstanceFromTemplateAdvancedMachineFeatures): any;
export declare class ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
}
export interface ComputeInstanceFromTemplateBootDiskInitializeParams {
    /**
    * The image from which this disk was initialised.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#image ComputeInstanceFromTemplate#image}
    */
    readonly image?: string;
    /**
    * A set of key/value label pairs assigned to the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#labels ComputeInstanceFromTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The size of the image in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#size ComputeInstanceFromTemplate#size}
    */
    readonly size?: number;
    /**
    * The Google Compute Engine disk type. Such as pd-standard, pd-ssd or pd-balanced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#type ComputeInstanceFromTemplate#type}
    */
    readonly type?: string;
}
export declare function computeInstanceFromTemplateBootDiskInitializeParamsToTerraform(struct?: ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference | ComputeInstanceFromTemplateBootDiskInitializeParams): any;
export declare class ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
    set internalValue(value: ComputeInstanceFromTemplateBootDiskInitializeParams | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ComputeInstanceFromTemplateBootDisk {
    /**
    * Whether the disk will be auto-deleted when the instance is deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#auto_delete ComputeInstanceFromTemplate#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Name with which attached disk will be accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#device_name ComputeInstanceFromTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#mode ComputeInstanceFromTemplate#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#source ComputeInstanceFromTemplate#source}
    */
    readonly source?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#initialize_params ComputeInstanceFromTemplate#initialize_params}
    */
    readonly initializeParams?: ComputeInstanceFromTemplateBootDiskInitializeParams;
}
export declare function computeInstanceFromTemplateBootDiskToTerraform(struct?: ComputeInstanceFromTemplateBootDiskOutputReference | ComputeInstanceFromTemplateBootDisk): any;
export declare class ComputeInstanceFromTemplateBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateBootDisk | undefined;
    set internalValue(value: ComputeInstanceFromTemplateBootDisk | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    get diskEncryptionKeySha256(): string;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: ComputeInstanceFromTemplateBootDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): ComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
}
export interface ComputeInstanceFromTemplateConfidentialInstanceConfig {
    /**
    * Defines whether the instance should have confidential compute enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_confidential_compute ComputeInstanceFromTemplate#enable_confidential_compute}
    */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference | ComputeInstanceFromTemplateConfidentialInstanceConfig): any;
export declare class ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceAccessConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#nat_ip ComputeInstanceFromTemplate#nat_ip}
    */
    readonly natIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#network_tier ComputeInstanceFromTemplate#network_tier}
    */
    readonly networkTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#ip_cidr_range ComputeInstanceFromTemplate#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#subnetwork_range_name ComputeInstanceFromTemplate#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig {
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#network_tier ComputeInstanceFromTemplate#network_tier}
    */
    readonly networkTier: string;
    /**
    * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
}
export declare class ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface ComputeInstanceFromTemplateNetworkInterface {
    /**
    * Access configurations, i.e. IPs via which this instance can be accessed via the Internet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#access_config ComputeInstanceFromTemplate#access_config}
    */
    readonly accessConfig?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * An array of alias IP ranges for this network interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#alias_ip_range ComputeInstanceFromTemplate#alias_ip_range}
    */
    readonly aliasIpRange?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * The name or self_link of the network attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#network ComputeInstanceFromTemplate#network}
    */
    readonly network?: string;
    /**
    * The private IP address assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#network_ip ComputeInstanceFromTemplate#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#nic_type ComputeInstanceFromTemplate#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#queue_count ComputeInstanceFromTemplate#queue_count}
    */
    readonly queueCount?: number;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#stack_type ComputeInstanceFromTemplate#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name or self_link of the subnetwork attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#subnetwork ComputeInstanceFromTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The project in which the subnetwork belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#subnetwork_project ComputeInstanceFromTemplate#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#ipv6_access_config ComputeInstanceFromTemplate#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateNetworkInterfaceToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable | undefined);
    private _accessConfig;
    get accessConfig(): ComputeInstanceFromTemplateNetworkInterfaceAccessConfigList;
    putAccessConfig(value: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): ComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | undefined;
    get ipv6AccessType(): string;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class ComputeInstanceFromTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateNetworkInterfaceOutputReference;
}
export interface ComputeInstanceFromTemplateReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#key ComputeInstanceFromTemplate#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#values ComputeInstanceFromTemplate#values}
    */
    readonly values: string[];
}
export declare function computeInstanceFromTemplateReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference | ComputeInstanceFromTemplateReservationAffinitySpecificReservation): any;
export declare class ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ComputeInstanceFromTemplateReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#type ComputeInstanceFromTemplate#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#specific_reservation ComputeInstanceFromTemplate#specific_reservation}
    */
    readonly specificReservation?: ComputeInstanceFromTemplateReservationAffinitySpecificReservation;
}
export declare function computeInstanceFromTemplateReservationAffinityToTerraform(struct?: ComputeInstanceFromTemplateReservationAffinityOutputReference | ComputeInstanceFromTemplateReservationAffinity): any;
export declare class ComputeInstanceFromTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateReservationAffinity | undefined;
    set internalValue(value: ComputeInstanceFromTemplateReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: ComputeInstanceFromTemplateReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
}
export interface ComputeInstanceFromTemplateSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#key ComputeInstanceFromTemplate#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#operator ComputeInstanceFromTemplate#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#values ComputeInstanceFromTemplate#values}
    */
    readonly values: string[];
}
export declare function computeInstanceFromTemplateSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ComputeInstanceFromTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceFromTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface ComputeInstanceFromTemplateScheduling {
    /**
    * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#automatic_restart ComputeInstanceFromTemplate#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#instance_termination_action ComputeInstanceFromTemplate#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#min_node_cpus ComputeInstanceFromTemplate#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#on_host_maintenance ComputeInstanceFromTemplate#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Whether the instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#preemptible ComputeInstanceFromTemplate#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#provisioning_model ComputeInstanceFromTemplate#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#node_affinities ComputeInstanceFromTemplate#node_affinities}
    */
    readonly nodeAffinities?: ComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateSchedulingToTerraform(struct?: ComputeInstanceFromTemplateSchedulingOutputReference | ComputeInstanceFromTemplateScheduling): any;
export declare class ComputeInstanceFromTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateScheduling | undefined;
    set internalValue(value: ComputeInstanceFromTemplateScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _nodeAffinities;
    get nodeAffinities(): ComputeInstanceFromTemplateSchedulingNodeAffinitiesList;
    putNodeAffinities(value: ComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | ComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined;
}
export interface ComputeInstanceFromTemplateShieldedInstanceConfig {
    /**
    * Whether integrity monitoring is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_integrity_monitoring ComputeInstanceFromTemplate#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether secure boot is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_secure_boot ComputeInstanceFromTemplate#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance uses vTPM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#enable_vtpm ComputeInstanceFromTemplate#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateShieldedInstanceConfigToTerraform(struct?: ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference | ComputeInstanceFromTemplateShieldedInstanceConfig): any;
export declare class ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceFromTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceFromTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#create ComputeInstanceFromTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#delete ComputeInstanceFromTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template#update ComputeInstanceFromTemplate#update}
    */
    readonly update?: string;
}
export declare function computeInstanceFromTemplateTimeoutsToTerraform(struct?: ComputeInstanceFromTemplateTimeoutsOutputReference | ComputeInstanceFromTemplateTimeouts | cdktf.IResolvable): any;
export declare class ComputeInstanceFromTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceFromTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceFromTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template google_compute_instance_from_template}
*/
export declare class ComputeInstanceFromTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_from_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template google_compute_instance_from_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeInstanceFromTemplateConfig
    */
    constructor(scope: Construct, id: string, config: ComputeInstanceFromTemplateConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _attachedDisk;
    get attachedDisk(): ComputeInstanceFromTemplateAttachedDiskList;
    putAttachedDisk(value: ComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable): void;
    resetAttachedDisk(): void;
    get attachedDiskInput(): cdktf.IResolvable | ComputeInstanceFromTemplateAttachedDisk[] | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string;
    set desiredStatus(value: string);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): ComputeInstanceFromTemplateGuestAcceleratorList;
    putGuestAccelerator(value: ComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ComputeInstanceFromTemplateGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _scratchDisk;
    get scratchDisk(): ComputeInstanceFromTemplateScratchDiskList;
    putScratchDisk(value: ComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable): void;
    resetScratchDisk(): void;
    get scratchDiskInput(): cdktf.IResolvable | ComputeInstanceFromTemplateScratchDisk[] | undefined;
    get selfLink(): string;
    private _serviceAccount;
    get serviceAccount(): ComputeInstanceFromTemplateServiceAccountList;
    putServiceAccount(value: ComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): cdktf.IResolvable | ComputeInstanceFromTemplateServiceAccount[] | undefined;
    private _sourceInstanceTemplate?;
    get sourceInstanceTemplate(): string;
    set sourceInstanceTemplate(value: string);
    get sourceInstanceTemplateInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: ComputeInstanceFromTemplateAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    private _bootDisk;
    get bootDisk(): ComputeInstanceFromTemplateBootDiskOutputReference;
    putBootDisk(value: ComputeInstanceFromTemplateBootDisk): void;
    resetBootDisk(): void;
    get bootDiskInput(): ComputeInstanceFromTemplateBootDisk | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: ComputeInstanceFromTemplateConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    private _networkInterface;
    get networkInterface(): ComputeInstanceFromTemplateNetworkInterfaceList;
    putNetworkInterface(value: ComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ComputeInstanceFromTemplateNetworkInterface[] | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ComputeInstanceFromTemplateReservationAffinityOutputReference;
    putReservationAffinity(value: ComputeInstanceFromTemplateReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ComputeInstanceFromTemplateReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): ComputeInstanceFromTemplateSchedulingOutputReference;
    putScheduling(value: ComputeInstanceFromTemplateScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): ComputeInstanceFromTemplateScheduling | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ComputeInstanceFromTemplateShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): ComputeInstanceFromTemplateTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceFromTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeInstanceFromTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
