import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The default port used if the port number is not specified in the
  network endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#default_port ComputeNetworkEndpointGroup#default_port}
    */
    readonly defaultPort?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#description ComputeNetworkEndpointGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#id ComputeNetworkEndpointGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#name ComputeNetworkEndpointGroup#name}
    */
    readonly name: string;
    /**
    * The network to which all network endpoints in the NEG belong.
  Uses "default" project network if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#network ComputeNetworkEndpointGroup#network}
    */
    readonly network: string;
    /**
    * Type of network endpoints in this network endpoint group.
  NON_GCP_PRIVATE_IP_PORT is used for hybrid connectivity network
  endpoint groups (see https://cloud.google.com/load-balancing/docs/hybrid).
  Note that NON_GCP_PRIVATE_IP_PORT can only be used with Backend Services
  that 1) have the following load balancing schemes: EXTERNAL, EXTERNAL_MANAGED,
  INTERNAL_MANAGED, and INTERNAL_SELF_MANAGED and 2) support the RATE or
  CONNECTION balancing modes.
  
  Possible values include: GCE_VM_IP, GCE_VM_IP_PORT, and NON_GCP_PRIVATE_IP_PORT. Default value: "GCE_VM_IP_PORT" Possible values: ["GCE_VM_IP", "GCE_VM_IP_PORT", "NON_GCP_PRIVATE_IP_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#network_endpoint_type ComputeNetworkEndpointGroup#network_endpoint_type}
    */
    readonly networkEndpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#project ComputeNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * Optional subnetwork to which all network endpoints in the NEG belong.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#subnetwork ComputeNetworkEndpointGroup#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * Zone where the network endpoint group is located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#zone ComputeNetworkEndpointGroup#zone}
    */
    readonly zone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#timeouts ComputeNetworkEndpointGroup#timeouts}
    */
    readonly timeouts?: ComputeNetworkEndpointGroupTimeouts;
}
export interface ComputeNetworkEndpointGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#create ComputeNetworkEndpointGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group#delete ComputeNetworkEndpointGroup#delete}
    */
    readonly delete?: string;
}
export declare function computeNetworkEndpointGroupTimeoutsToTerraform(struct?: ComputeNetworkEndpointGroupTimeoutsOutputReference | ComputeNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group google_compute_network_endpoint_group}
*/
export declare class ComputeNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_endpoint_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group google_compute_network_endpoint_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkEndpointGroupConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkEndpointGroupConfig);
    private _defaultPort?;
    get defaultPort(): number;
    set defaultPort(value: number);
    resetDefaultPort(): void;
    get defaultPortInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string;
    set networkEndpointType(value: string);
    resetNetworkEndpointType(): void;
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get size(): number;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkEndpointGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
