import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNodeTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * CPU overcommit. Default value: "NONE" Possible values: ["ENABLED", "NONE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#cpu_overcommit_type ComputeNodeTemplate#cpu_overcommit_type}
    */
    readonly cpuOvercommitType?: string;
    /**
    * An optional textual description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#description ComputeNodeTemplate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#id ComputeNodeTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#name ComputeNodeTemplate#name}
    */
    readonly name?: string;
    /**
    * Labels to use for node affinity, which will be used in
  instance scheduling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#node_affinity_labels ComputeNodeTemplate#node_affinity_labels}
    */
    readonly nodeAffinityLabels?: {
        [key: string]: string;
    };
    /**
    * Node type to use for nodes group that are created from this template.
  Only one of nodeTypeFlexibility and nodeType can be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#node_type ComputeNodeTemplate#node_type}
    */
    readonly nodeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#project ComputeNodeTemplate#project}
    */
    readonly project?: string;
    /**
    * Region where nodes using the node template will be created.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#region ComputeNodeTemplate#region}
    */
    readonly region?: string;
    /**
    * node_type_flexibility block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#node_type_flexibility ComputeNodeTemplate#node_type_flexibility}
    */
    readonly nodeTypeFlexibility?: ComputeNodeTemplateNodeTypeFlexibility;
    /**
    * server_binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#server_binding ComputeNodeTemplate#server_binding}
    */
    readonly serverBinding?: ComputeNodeTemplateServerBinding;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#timeouts ComputeNodeTemplate#timeouts}
    */
    readonly timeouts?: ComputeNodeTemplateTimeouts;
}
export interface ComputeNodeTemplateNodeTypeFlexibility {
    /**
    * Number of virtual CPUs to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#cpus ComputeNodeTemplate#cpus}
    */
    readonly cpus?: string;
    /**
    * Physical memory available to the node, defined in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#memory ComputeNodeTemplate#memory}
    */
    readonly memory?: string;
}
export declare function computeNodeTemplateNodeTypeFlexibilityToTerraform(struct?: ComputeNodeTemplateNodeTypeFlexibilityOutputReference | ComputeNodeTemplateNodeTypeFlexibility): any;
export declare class ComputeNodeTemplateNodeTypeFlexibilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeTemplateNodeTypeFlexibility | undefined;
    set internalValue(value: ComputeNodeTemplateNodeTypeFlexibility | undefined);
    private _cpus?;
    get cpus(): string;
    set cpus(value: string);
    resetCpus(): void;
    get cpusInput(): string | undefined;
    get localSsd(): string;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface ComputeNodeTemplateServerBinding {
    /**
    * Type of server binding policy. If 'RESTART_NODE_ON_ANY_SERVER',
  nodes using this template will restart on any physical server
  following a maintenance event.
  
  If 'RESTART_NODE_ON_MINIMAL_SERVER', nodes using this template
  will restart on the same physical server following a maintenance
  event, instead of being live migrated to or restarted on a new
  physical server. This option may be useful if you are using
  software licenses tied to the underlying server characteristics
  such as physical sockets or cores, to avoid the need for
  additional licenses when maintenance occurs. However, VMs on such
  nodes will experience outages while maintenance is applied. Possible values: ["RESTART_NODE_ON_ANY_SERVER", "RESTART_NODE_ON_MINIMAL_SERVERS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#type ComputeNodeTemplate#type}
    */
    readonly type: string;
}
export declare function computeNodeTemplateServerBindingToTerraform(struct?: ComputeNodeTemplateServerBindingOutputReference | ComputeNodeTemplateServerBinding): any;
export declare class ComputeNodeTemplateServerBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeTemplateServerBinding | undefined;
    set internalValue(value: ComputeNodeTemplateServerBinding | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ComputeNodeTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#create ComputeNodeTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template#delete ComputeNodeTemplate#delete}
    */
    readonly delete?: string;
}
export declare function computeNodeTemplateTimeoutsToTerraform(struct?: ComputeNodeTemplateTimeoutsOutputReference | ComputeNodeTemplateTimeouts | cdktf.IResolvable): any;
export declare class ComputeNodeTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNodeTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_template google_compute_node_template}
*/
export declare class ComputeNodeTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_node_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_template google_compute_node_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNodeTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ComputeNodeTemplateConfig);
    private _cpuOvercommitType?;
    get cpuOvercommitType(): string;
    set cpuOvercommitType(value: string);
    resetCpuOvercommitType(): void;
    get cpuOvercommitTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeAffinityLabels?;
    get nodeAffinityLabels(): {
        [key: string]: string;
    };
    set nodeAffinityLabels(value: {
        [key: string]: string;
    });
    resetNodeAffinityLabels(): void;
    get nodeAffinityLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeType?;
    get nodeType(): string;
    set nodeType(value: string);
    resetNodeType(): void;
    get nodeTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _nodeTypeFlexibility;
    get nodeTypeFlexibility(): ComputeNodeTemplateNodeTypeFlexibilityOutputReference;
    putNodeTypeFlexibility(value: ComputeNodeTemplateNodeTypeFlexibility): void;
    resetNodeTypeFlexibility(): void;
    get nodeTypeFlexibilityInput(): ComputeNodeTemplateNodeTypeFlexibility | undefined;
    private _serverBinding;
    get serverBinding(): ComputeNodeTemplateServerBindingOutputReference;
    putServerBinding(value: ComputeNodeTemplateServerBinding): void;
    resetServerBinding(): void;
    get serverBindingInput(): ComputeNodeTemplateServerBinding | undefined;
    private _timeouts;
    get timeouts(): ComputeNodeTemplateTimeoutsOutputReference;
    putTimeouts(value: ComputeNodeTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNodeTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
