import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * The cluster to create the node pool for. Cluster must be present in location provided for zonal clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#cluster ContainerNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#id ContainerNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The initial number of nodes for the pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#initial_node_count ContainerNodePool#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The location (region or zone) of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#location ContainerNodePool#location}
    */
    readonly location?: string;
    /**
    * The maximum number of pods per node in this node pool. Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#max_pods_per_node ContainerNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#name ContainerNodePool#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#name_prefix ContainerNodePool#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The number of nodes per instance group. This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#node_count ContainerNodePool#node_count}
    */
    readonly nodeCount?: number;
    /**
    * The list of zones in which the node pool's nodes should be located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#node_locations ContainerNodePool#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The ID of the project in which to create the node pool. If blank, the provider-configured project will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#project ContainerNodePool#project}
    */
    readonly project?: string;
    /**
    * The Kubernetes version for the nodes in this pool. Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#version ContainerNodePool#version}
    */
    readonly version?: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#autoscaling ContainerNodePool#autoscaling}
    */
    readonly autoscaling?: ContainerNodePoolAutoscaling;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#management ContainerNodePool#management}
    */
    readonly management?: ContainerNodePoolManagement;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#node_config ContainerNodePool#node_config}
    */
    readonly nodeConfig?: ContainerNodePoolNodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#timeouts ContainerNodePool#timeouts}
    */
    readonly timeouts?: ContainerNodePoolTimeouts;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#upgrade_settings ContainerNodePool#upgrade_settings}
    */
    readonly upgradeSettings?: ContainerNodePoolUpgradeSettings;
}
export interface ContainerNodePoolAutoscaling {
    /**
    * Location policy specifies the algorithm used when scaling-up the node pool. "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#location_policy ContainerNodePool#location_policy}
    */
    readonly locationPolicy?: string;
    /**
    * Maximum number of nodes per zone in the node pool. Must be >= min_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#max_node_count ContainerNodePool#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Minimum number of nodes per zone in the node pool. Must be >=0 and <= max_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#min_node_count ContainerNodePool#min_node_count}
    */
    readonly minNodeCount?: number;
    /**
    * Maximum number of all nodes in the node pool. Must be >= total_min_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#total_max_node_count ContainerNodePool#total_max_node_count}
    */
    readonly totalMaxNodeCount?: number;
    /**
    * Minimum number of all nodes in the node pool. Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#total_min_node_count ContainerNodePool#total_min_node_count}
    */
    readonly totalMinNodeCount?: number;
}
export declare function containerNodePoolAutoscalingToTerraform(struct?: ContainerNodePoolAutoscalingOutputReference | ContainerNodePoolAutoscaling): any;
export declare class ContainerNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolAutoscaling | undefined;
    set internalValue(value: ContainerNodePoolAutoscaling | undefined);
    private _locationPolicy?;
    get locationPolicy(): string;
    set locationPolicy(value: string);
    resetLocationPolicy(): void;
    get locationPolicyInput(): string | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
    private _totalMaxNodeCount?;
    get totalMaxNodeCount(): number;
    set totalMaxNodeCount(value: number);
    resetTotalMaxNodeCount(): void;
    get totalMaxNodeCountInput(): number | undefined;
    private _totalMinNodeCount?;
    get totalMinNodeCount(): number;
    set totalMinNodeCount(value: number);
    resetTotalMinNodeCount(): void;
    get totalMinNodeCountInput(): number | undefined;
}
export interface ContainerNodePoolManagement {
    /**
    * Whether the nodes will be automatically repaired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#auto_repair ContainerNodePool#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Whether the nodes will be automatically upgraded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#auto_upgrade ContainerNodePool#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function containerNodePoolManagementToTerraform(struct?: ContainerNodePoolManagementOutputReference | ContainerNodePoolManagement): any;
export declare class ContainerNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolManagement | undefined;
    set internalValue(value: ContainerNodePoolManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#count ContainerNodePool#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#gpu_partition_size ContainerNodePool#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#type ContainerNodePool#type}
    */
    readonly type?: string;
}
export declare function containerNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: ContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class ContainerNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ContainerNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface ContainerNodePoolNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#effect ContainerNodePool#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#key ContainerNodePool#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#value ContainerNodePool#value}
    */
    readonly value?: string;
}
export declare function containerNodePoolNodeConfigTaintToTerraform(struct?: ContainerNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare class ContainerNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerNodePoolNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerNodePoolNodeConfigTaintOutputReference;
}
export interface ContainerNodePoolNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#enabled ContainerNodePool#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerNodePoolNodeConfigGcfsConfigToTerraform(struct?: ContainerNodePoolNodeConfigGcfsConfigOutputReference | ContainerNodePoolNodeConfigGcfsConfig): any;
export declare class ContainerNodePoolNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfigGcfsConfig | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#enabled ContainerNodePool#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerNodePoolNodeConfigGvnicToTerraform(struct?: ContainerNodePoolNodeConfigGvnicOutputReference | ContainerNodePoolNodeConfigGvnic): any;
export declare class ContainerNodePoolNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfigGvnic | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#consume_reservation_type ContainerNodePool#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#key ContainerNodePool#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#values ContainerNodePool#values}
    */
    readonly values?: string[];
}
export declare function containerNodePoolNodeConfigReservationAffinityToTerraform(struct?: ContainerNodePoolNodeConfigReservationAffinityOutputReference | ContainerNodePoolNodeConfigReservationAffinity): any;
export declare class ContainerNodePoolNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfigReservationAffinity | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface ContainerNodePoolNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#enable_integrity_monitoring ContainerNodePool#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#enable_secure_boot ContainerNodePool#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function containerNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference | ContainerNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#mode ContainerNodePool#mode}
    */
    readonly mode: string;
}
export declare function containerNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference | ContainerNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface ContainerNodePoolNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#boot_disk_kms_key ContainerNodePool#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#disk_size_gb ContainerNodePool#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#disk_type ContainerNodePool#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#guest_accelerator ContainerNodePool#guest_accelerator}
    */
    readonly guestAccelerator?: ContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#image_type ContainerNodePool#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#labels ContainerNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#local_ssd_count ContainerNodePool#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#machine_type ContainerNodePool#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#metadata ContainerNodePool#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#min_cpu_platform ContainerNodePool#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#node_group ContainerNodePool#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#oauth_scopes ContainerNodePool#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#preemptible ContainerNodePool#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#service_account ContainerNodePool#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#spot ContainerNodePool#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#tags ContainerNodePool#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#taint ContainerNodePool#taint}
    */
    readonly taint?: ContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#gcfs_config ContainerNodePool#gcfs_config}
    */
    readonly gcfsConfig?: ContainerNodePoolNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#gvnic ContainerNodePool#gvnic}
    */
    readonly gvnic?: ContainerNodePoolNodeConfigGvnic;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#reservation_affinity ContainerNodePool#reservation_affinity}
    */
    readonly reservationAffinity?: ContainerNodePoolNodeConfigReservationAffinity;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#shielded_instance_config ContainerNodePool#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ContainerNodePoolNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#workload_metadata_config ContainerNodePool#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: ContainerNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function containerNodePoolNodeConfigToTerraform(struct?: ContainerNodePoolNodeConfigOutputReference | ContainerNodePoolNodeConfig): any;
export declare class ContainerNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolNodeConfig | undefined;
    set internalValue(value: ContainerNodePoolNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): ContainerNodePoolNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: ContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): ContainerNodePoolNodeConfigTaintList;
    putTaint(value: ContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | ContainerNodePoolNodeConfigTaint[] | undefined;
    private _gcfsConfig;
    get gcfsConfig(): ContainerNodePoolNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: ContainerNodePoolNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): ContainerNodePoolNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): ContainerNodePoolNodeConfigGvnicOutputReference;
    putGvnic(value: ContainerNodePoolNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): ContainerNodePoolNodeConfigGvnic | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ContainerNodePoolNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: ContainerNodePoolNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ContainerNodePoolNodeConfigReservationAffinity | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerNodePoolNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerNodePoolNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#create ContainerNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#delete ContainerNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#update ContainerNodePool#update}
    */
    readonly update?: string;
}
export declare function containerNodePoolTimeoutsToTerraform(struct?: ContainerNodePoolTimeoutsOutputReference | ContainerNodePoolTimeouts | cdktf.IResolvable): any;
export declare class ContainerNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerNodePoolUpgradeSettings {
    /**
    * The number of additional nodes that can be added to the node pool during an upgrade. Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#max_surge ContainerNodePool#max_surge}
    */
    readonly maxSurge: number;
    /**
    * The number of nodes that can be simultaneously unavailable during an upgrade. Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool#max_unavailable ContainerNodePool#max_unavailable}
    */
    readonly maxUnavailable: number;
}
export declare function containerNodePoolUpgradeSettingsToTerraform(struct?: ContainerNodePoolUpgradeSettingsOutputReference | ContainerNodePoolUpgradeSettings): any;
export declare class ContainerNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerNodePoolUpgradeSettings | undefined;
    set internalValue(value: ContainerNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_node_pool google_container_node_pool}
*/
export declare class ContainerNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_node_pool google_container_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: ContainerNodePoolConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get managedInstanceGroupUrls(): string[];
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    get operation(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): ContainerNodePoolAutoscalingOutputReference;
    putAutoscaling(value: ContainerNodePoolAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): ContainerNodePoolAutoscaling | undefined;
    private _management;
    get management(): ContainerNodePoolManagementOutputReference;
    putManagement(value: ContainerNodePoolManagement): void;
    resetManagement(): void;
    get managementInput(): ContainerNodePoolManagement | undefined;
    private _nodeConfig;
    get nodeConfig(): ContainerNodePoolNodeConfigOutputReference;
    putNodeConfig(value: ContainerNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ContainerNodePoolNodeConfig | undefined;
    private _timeouts;
    get timeouts(): ContainerNodePoolTimeoutsOutputReference;
    putTimeouts(value: ContainerNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerNodePoolTimeouts | undefined;
    private _upgradeSettings;
    get upgradeSettings(): ContainerNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: ContainerNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): ContainerNodePoolUpgradeSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
