import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeDefaultServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account#id DataGoogleComputeDefaultServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account#project DataGoogleComputeDefaultServiceAccount#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account google_compute_default_service_account}
*/
export declare class DataGoogleComputeDefaultServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_default_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account google_compute_default_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeDefaultServiceAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeDefaultServiceAccountConfig);
    get displayName(): string;
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
