import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFoldersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folders#id DataGoogleFolders#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folders#parent_id DataGoogleFolders#parent_id}
    */
    readonly parentId: string;
}
export interface DataGoogleFoldersFolders {
}
export declare function dataGoogleFoldersFoldersToTerraform(struct?: DataGoogleFoldersFolders): any;
export declare class DataGoogleFoldersFoldersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFoldersFolders | undefined;
    set internalValue(value: DataGoogleFoldersFolders | undefined);
    get createTime(): string;
    get deleteTime(): string;
    get displayName(): string;
    get etag(): string;
    get name(): string;
    get parent(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class DataGoogleFoldersFoldersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFoldersFoldersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/folders google_folders}
*/
export declare class DataGoogleFolders extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_folders";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/folders google_folders} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFoldersConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFoldersConfig);
    private _folders;
    get folders(): DataGoogleFoldersFoldersList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parentId?;
    get parentId(): string;
    set parentId(value: string);
    get parentIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
